/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:        DataInterface
//- Description:  Class implementation
//- Owner:        Mike Eldred

#include "DataInterface.H"
#include "data_io.h"


namespace Dakota {

DataInterfaceRep::DataInterfaceRep():
  verbatimFlag(false), apreproFlag(false), fileTagFlag(false),
  fileSaveFlag(false), procsPerAnalysis(0),
  interfaceSynchronization("synchronous"), asynchLocalEvalConcurrency(0),
  asynchLocalAnalysisConcurrency(0), evalServers(0), analysisServers(0),
  failAction("abort"), retryLimit(1), activeSetVectorFlag(true),
  evalCacheFlag(true), restartFileFlag(true), referenceCount(1)
{ }


void DataInterfaceRep::write(MPIPackBuffer& s) const
{
  s << idInterface << interfaceType << algebraicMappings << analysisDrivers
    << analysisComponents << inputFilter << outputFilter << parametersFile
    << resultsFile << verbatimFlag << apreproFlag << fileTagFlag << fileSaveFlag
    << procsPerAnalysis //<< gridHostNames << gridProcsPerHost
    << interfaceSynchronization << asynchLocalEvalConcurrency
    << asynchLocalAnalysisConcurrency << evalServers << evalScheduling
    << analysisServers << analysisScheduling << failAction << retryLimit
    << recoveryFnVals << activeSetVectorFlag << evalCacheFlag
    << restartFileFlag;
}


void DataInterfaceRep::read(MPIUnpackBuffer& s)
{
  s >> idInterface >> interfaceType >> algebraicMappings >> analysisDrivers
    >> analysisComponents >> inputFilter >> outputFilter >> parametersFile
    >> resultsFile >> verbatimFlag >> apreproFlag >> fileTagFlag >> fileSaveFlag
    >> procsPerAnalysis //>> gridHostNames >> gridProcsPerHost
    >> interfaceSynchronization >> asynchLocalEvalConcurrency
    >> asynchLocalAnalysisConcurrency >> evalServers >> evalScheduling
    >> analysisServers >> analysisScheduling >> failAction >> retryLimit
    >> recoveryFnVals >> activeSetVectorFlag >> evalCacheFlag
    >> restartFileFlag;
}


void DataInterfaceRep::write(ostream& s) const
{
  s << idInterface << interfaceType << algebraicMappings << analysisDrivers
    << analysisComponents << inputFilter << outputFilter << parametersFile
    << resultsFile << verbatimFlag << apreproFlag << fileTagFlag << fileSaveFlag
    << procsPerAnalysis //<< gridHostNames << gridProcsPerHost
    << interfaceSynchronization << asynchLocalEvalConcurrency
    << asynchLocalAnalysisConcurrency << evalServers << evalScheduling
    << analysisServers << analysisScheduling << failAction << retryLimit
    << recoveryFnVals << activeSetVectorFlag << evalCacheFlag
    << restartFileFlag;
}


DataInterface::DataInterface(): dataIfaceRep(new DataInterfaceRep())
{
#ifdef REFCOUNT_DEBUG
  Cout << "DataInterface::DataInterface(), dataIfaceRep referenceCount = "
       << dataIfaceRep->referenceCount << endl;
#endif
}


DataInterface::DataInterface(const DataInterface& data_resp)
{
  // Increment new (no old to decrement)
  dataIfaceRep = data_resp.dataIfaceRep;
  if (dataIfaceRep) // Check for an assignment of NULL
    dataIfaceRep->referenceCount++;

#ifdef REFCOUNT_DEBUG
  Cout << "DataInterface::DataInterface(DataInterface&)" << endl;
  if (dataIfaceRep)
    Cout << "dataIfaceRep referenceCount = " << dataIfaceRep->referenceCount
	 << endl;
#endif
}


DataInterface& DataInterface::operator=(const DataInterface& data_interface)
{
  if (dataIfaceRep != data_interface.dataIfaceRep) { // normal case: old != new
    // Decrement old
    if (dataIfaceRep) // Check for NULL
      if ( --dataIfaceRep->referenceCount == 0 ) 
	delete dataIfaceRep;
    // Assign and increment new
    dataIfaceRep = data_interface.dataIfaceRep;
    if (dataIfaceRep) // Check for NULL
      dataIfaceRep->referenceCount++;
  }
  // else if assigning same rep, then do nothing since referenceCount
  // should already be correct

#ifdef REFCOUNT_DEBUG
  Cout << "DataInterface::operator=(DataInterface&)" << endl;
  if (dataIFaceRep)
    Cout << "dataIFaceRep referenceCount = " << dataIFaceRep->referenceCount
	 << endl;
#endif

  return *this;
}


DataInterface::~DataInterface()
{
  if (dataIfaceRep) { // Check for NULL
    --dataIfaceRep->referenceCount; // decrement
#ifdef REFCOUNT_DEBUG
    Cout << "dataIfaceRep referenceCount decremented to "
         << dataIfaceRep->referenceCount << endl;
#endif
    if (dataIfaceRep->referenceCount == 0) {
#ifdef REFCOUNT_DEBUG
      Cout << "deleting dataIfaceRep" << endl;
#endif
      delete dataIfaceRep;
    }
  }
}

} // namespace Dakota
