# include <string>

namespace webbur
{
  void level_to_order_default ( int dim_num, int level[], int rule[], 
    int order[] );

  void level_to_order_exponential ( int dim_num, int level[], int rule[], 
    int order[] );

  void level_to_order_linear ( int dim_num, int level[], int rule[], 
    int order[] );

  void product_mixed_growth_weight ( int dim_num, int order_1d[], int order_nd, 
    int rule[], double alpha[], double beta[], 
    void ( *gw_compute_weights[] ) ( int order, double alpha, double beta, double w[] ),
    double weight_nd[] );

  void sparse_grid_mixed_growth_index ( int dim_num, int level_max, int rule[], 
    int point_num, int point_total_num, int sparse_unique_index[], 
    void level_to_order ( int dim_num, int level[], int rule[], int order[] ),
    int sparse_order[], int sparse_index[] );

  void sparse_grid_mixed_growth_point ( int dim_num, int level_max, int rule[], 
    double alpha[], double beta[], 
    void ( *gw_compute_points[] ) ( int order, double alpha, double beta, double x[] ),
    int point_num, int sparse_order[], int sparse_index[], 
    void level_to_order ( int dim_num, int level[], int rule[], int order[] ),
    double sparse_point[] );

  int sparse_grid_mixed_growth_size ( int dim_num, int level_max, int rule[], 
    double alpha[], double beta[], 
    void ( *gw_compute_points[] ) ( int order, double alpha, double beta, double x[] ),
    double tol,
    void level_to_order ( int dim_num, int level[], int rule[], int order[] ) );

  int sparse_grid_mixed_growth_size_total ( int dim_num, int level_max, int rule[],
    void level_to_order ( int dim_num, int level[], int rule[], int order[] ) );

  void sparse_grid_mixed_growth_unique_index ( int dim_num, int level_max, int rule[], 
    double alpha[], double beta[], 
    void ( *gw_compute_points[] ) ( int order, double alpha, double beta, double x[] ),
    double tol, int point_num, int point_total_num,
    void level_to_order ( int dim_num, int level[], int rule[], int order[] ),
    int sparse_unique_index[] );

  void sparse_grid_mixed_growth_weight ( int dim_num, int level_max, int rule[], 
    double alpha[], double beta[], 
    void ( *gw_compute_weights[] ) ( int order, double alpha, double beta, double w[] ),
    int point_num, int point_total_num, int sparse_unique_index[],
    void level_to_order ( int dim_num, int level[], int rule[], int order[] ),
    double sparse_weight[] );

  void sparse_grid_mixed_growth_write ( int dim_num, int rule[], double alpha[], 
    double beta[], int point_num, double sparse_weight[], double sparse_point[], 
    std::string file_name );
}
