C***********************************************************************
C LHS (Latin Hypercube Sampling) UNIX Library/Standalone. 
C Copyright (c) 2004, Sandia Corporation.  Under the terms of Contract
C DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government
C retains certain rights in this software.
C
C This software is distributed under the GNU General Public License.
C For more information, see the README file in the LHS directory. 
C***********************************************************************
C     Last change:  SLD  28 Mar 101    9:52 am
C****************************************************************
C FUNCTION RIERFC1 IS USED IN GENERATING THE NORMAL AND
C LOGNORMAL DISTRIBUTIONS
C
      DOUBLE PRECISION FUNCTION RIERFC1 (Y)
cc    RIERFC1 is called from:  FINVNOR                                  sld01
cc    RIERFC1 has no calls to any other external routines               sld01
      USE KILLFILE                                                      sld01
C
C
C     THIS IS THE SAME AS THE RIERFC ROUTINE IN THE DEAMOS LIBRARY
C     THE NAME MODIFICATION WAS TO PREVENT OUR LIBRARY FROM CALLING
C     ANOTHER LIBRARY.                 ELF   OCTOBER 1980
C
C     WRITTEN BY D.E. AMOS AND S.L. DANIEL, SEPTEMBER, 1972.
C
C     REFERENCES
C         HASTINGS, C.JR., APPROXIMATIONS FOR DIGITAL COMPUTERS,
C         PRINCETON UNIVERSITY PRESS, PRINCETON, N.J., 1955
C
C         COMMUNICATION FROM L.F. SHAMPINE FOR CHEBYSHEV COEFFICIENTS.
C
C     ABSTRACT
C         RIERFC EVALUATES THE INVERSE COERROR FUNCTION DEFINED BY
C
C                          Y= ERFC(X)     0.LE.X.LT.INFINITY
C
C         WHERE 0.LT.Y.LE.1. CHEBYSHEV APPROXIMATIONS ON
C
C              EXP(-81).LE.Y.LT.0.1, 0.1.LE.Y.LT.0.5, 0.5.LE.Y.LE.1.
C
C         ARE USED WITH A CHANGE OF VARIABLES
C
C         YY=C1*W+C2, W=SQRT(-LN(Y)), YY=5.*Y-1.5, YY=2.*(1.-Y)
C
C         RESPECTIVELY. THE INVERSE OF THE NORMAL DISTRIBUTION IS GIVEN
C         BY
C                          SQRT(2)*RIERFC(2.*(1.-RN))  0.5.LE.RN.LT.1.0,
C                      X=
C                         -SQRT(2)*RIERFC(2.*RN)       0.0.LT.RN.LT.0.5.
C
C         THE RELATIVE ERROR IN RIERFC DECREASES FROM 1.E-10 TO 3.E-13
C         AS Y INCREASES FROM EXP(-81) TO 1.0.
C
C     DESCRIPTION OF ARGUMENTS
C
C         INPUT
C
C           Y      - Y, EXP(-81).LE.Y.LE.1.
C
C         OUTPUT
C
C           RIERFC - VALUE FOR THE INVERSE COERROR FUNCTION
C
C     ERROR CONDITIONS
C         Y.LT.EXP(-81) OR Y.GT.1 ARE FATAL ERRORS
C
C
cc    No call to ERRCHK remains in this code:                           sld01
C     RIERFC USES SUBROUTINES ERRCHK, ERRGET, ERRPRT, ERXSET, ERSTGT
C     COMPILE DECKS RIERFC, ERRCHK
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION A(22,3)
      DIMENSION A1(22), A2(22), A3(22)
      EQUIVALENCE (A(1,1),A1(1))
      EQUIVALENCE (A(1,2),A2(1))
      EQUIVALENCE (A(1,3),A3(1))
C
      DATA(A1(I),I=1,22)/9.18725611735013E-01,0.,1.68792878000327E-02
     1,0.,6.60337139058300E-04,0.,3.20203849839380E-05,0.,1.720
     260607522481E-06,0.,9.81965971588191E-08,0.,5.83049613537653E
     3-09,0.,3.56019351836136E-10,0.,2.21968915783128E-11,0.,1.
     440639693109741E-12,0.,9.02597345404862E-14,0./
C
      DATA(A2(I),I=1,22)/1.54701109458613E+00,-3.31460331083896E-01,4.33
     1001124090060E-02,-1.06564004165532E-02,2.90613542304156E-03,-8.618
     272838022491E-04,2.67933751795053E-04,-8.60838893942933E-05,2.83232
     3058814598E-05,-9.48870819734494E-06,3.22422655069385E-06,-1.108157
     478472076E-06,3.84464770797987E-07,-1.34439275565208E-07,4.73255976
     5052393E-08,-1.67556011100019E-08,5.96199003969093E-09,-2.130705032
     691886E-09,7.64427040920545E-10,-2.75198005584737E-10,9.93792246090
     7789E-11,-3.59877382902119E-11/
C
      DATA(A3(I),I=1,22)/1.10642888011036E+01,4.34299147561447E+00,-2.33
     1781774969295E-02,4.23345215362947E-03,8.68757084192089E-06,-5.9826
     21113270881E-04,4.50490139240298E-04,-2.54858131942102E-04,1.278241
     389261340E-04,-5.97873878043957E-05,2.66474012012582E-05,-1.1438183
     46209267E-05,4.75393030377615E-06,-1.91759589929610E-06,7.508064655
     594834E-07,-2.84791180387123E-07,1.04187791696225E-07,-3.6456724368
     69145E-08,1.20129296139030E-08,-3.61030126779729E-09,9.123561400817
     759E-10,-1.36851363400914E-10/
C
      DATA C1,C2/2.35777520630369E-01,1.35777520630369E+00/
C
      IF (Y.LT.6.63967719958073E-36.OR.Y.GT.1.0) GO TO 50
      IF (Y.GE.0.5) GO TO 10
      IF (Y.GE.0.1) GO TO 20
      J=3
      W=SQRT(-LOG(Y))
      D=C1*W-C2
      GO TO 30
   10 J=1
      D=1.-Y
      D=D+D
      GO TO 30
   20 J=2
      D=5.*Y-1.5
   30 TD=D+D
      VNP1=0.
      VN=0.
      DO 40 L=1,21
      K=22-L+1
      TEMP=VN
      VN=TD*VN-VNP1+A(K,J)
   40 VNP1=TEMP
      RIERFC1=D*VN-VNP1+.5*A(1,J)
      IF (J.EQ.1) RIERFC1=D*RIERFC1
      RETURN
   50 WRITE(4,60)
      WRITE(99,60)                                                      sld01
      KLLERR = .TRUE.                                                   sld01
      RETURN
C
   60 FORMAT(' Y LESS THAN EXP(-81.) OR Y GREATER THAN 1.0')
      END
