// $Id: MEDIATOR_Main_MPI.cpp,v 1.2 2008/05/02 00:57:23 tgkolda Exp $ 
// $Source: /usr/local/cvsroot/hopspack/src/MEDIATOR_Main_MPI.cpp,v $ 

//@HEADER
// ************************************************************************
// 
//         HOPSPACK: Hybrid Opitmization Parallel Search Package
//               Copyright (2008) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//                                                                                 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.                                                                           .
// 
// Questions? Contact Tammy Kolda (tgkolda@sandia.gov) 
// 
// ************************************************************************
//@HEADER

/*!
  \file MEDIATOR_Main_MPI.cpp
  \brief The main for a MPI version of APPSPACK based on a simple system call.
  \todo Josh fix comments.
*/

#include "APPSPACK_GCI.hpp"
#include "APPSPACK_Common.hpp"
#include "APPSPACK_Parameter_List.hpp"
#include "APPSPACK_Utils.hpp"
#include "APPSPACK_Scheduler.hpp"
#include "APPSPACK_Evaluator_SystemCall.hpp"
#include "APPSPACK_Citizen_Generator.hpp"

//! Main subroutine \todo more comments.
int main(int argc, char* argv[])
{
  APPSPACK::Scheduler scheduler(argc, argv);
  APPSPACK::Citizen::Generator generator;

  scheduler.init();
  
  APPSPACK::Parameter::List& params = scheduler.getParameters();
  APPSPACK::Evaluator::SystemCall evaluator(params);
  
  if (scheduler.isMaster())
  {
    scheduler.masterLoop(generator);
  }
  else if (scheduler.isCitizen())
  {
    scheduler.citizenLoop(generator);
  }
  else
  {
    scheduler.workerLoop(evaluator);
  }

  scheduler.cleanup();
}

