// $Id: APPSPACK_Citizen_Interface.cpp,v 1.2 2008/05/02 00:57:23 tgkolda Exp $ 
// $Source: /usr/local/cvsroot/hopspack/src/APPSPACK_Citizen_Interface.cpp,v $ 

//@HEADER
// ************************************************************************
// 
//         HOPSPACK: Hybrid Opitmization Parallel Search Package
//               Copyright (2008) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//                                                                                 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.                                                                           .
// 
// Questions? Contact Tammy Kolda (tgkolda@sandia.gov) 
// 
// ************************************************************************
//@HEADER

/*!
  \file APPSPACK_Citizen_Interface.cpp
  \brief Implements APPSPACK::Citizen::Interface
*/

#include "APPSPACK_Citizen_Interface.hpp"

ostream& operator<<(ostream& stream, APPSPACK::Citizen::State state) 
{
  switch (state)
  {
  case APPSPACK::Citizen::MustContinue:
    stream << "MustContinue";
    break;
  case APPSPACK::Citizen::PassiveContinue:
    stream << "PassiveContinue";
    break;
  case APPSPACK::Citizen::StopRequest:
    stream << "StopRequest";
    break;
  case APPSPACK::Citizen::MustStop:
    stream << "MustStop";
    break;
  case APPSPACK::Citizen::Retired:
    stream << "Retired";
    break;
  }

  return stream;
}

bool  APPSPACK::Citizen::Interface::worker()
{
  // This default function should never be called.  If a Citizens defines
  // getNumberOfProcessors to return a number greater than 0, than they
  // must also provide a corresponding worker function.
  cerr << "APPSPACK::Iterator::writeSolutionFile() - Unable to open solution file" << endl;
  throw "APPSPACK Error";
}
