//@HEADER
// ************************************************************************
// 
//         HOPSPACK: Hybrid Opitmization Parallel Search Package
//               Copyright (2008) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//                                                                                 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.                                                                           .
// 
// Questions? Contact Tammy Kolda (tgkolda@sandia.gov) 
// 
// ************************************************************************
//@HEADER

/*! 
  \file APPSPACK_Combiner_Lagrange.cpp
  \brief Implementation of APPSPACK::Combiner::Lagrange
*/

#include "APPSPACK_Common.hpp"
#include "APPSPACK_Combiner_Lagrange.hpp"
#include "APPSPACK_Float.hpp"

APPSPACK::Combiner::Lagrange::Lagrange()
{
}

APPSPACK::Combiner::Lagrange::~Lagrange()
{
}

double APPSPACK::Combiner::Lagrange::operator()(const APPSPACK::Vector& fc) const
{
  if (fc.size() == 0)
    return dne();

  // Check constraints
  for (int i = 0; i < fc.size(); i ++)
    if (!exists(fc[i]))
      return dne();
  
  double phik = 1000*fc[0]; 
  for (int i = 0; i < lambda.size(); i++)
    phik += fc[i+1]*(lambda[i] + .5*fc[i+1]/mu);

  // Return objective value
  return phik;
}

const APPSPACK::Vector& APPSPACK::Combiner::Lagrange::getLambda() const
{
  return lambda;
}

double APPSPACK::Combiner::Lagrange::getMu() const
{
  return mu;
}

void APPSPACK::Combiner::Lagrange::setLambda(const APPSPACK::Vector& lambda_in)
{
  lambda = lambda_in;
}

void APPSPACK::Combiner::Lagrange::setMu(double mu_in)
{
  mu = mu_in;
}

void APPSPACK::Combiner::Lagrange::setBounds(const APPSPACK::Vector& crhs_in, 
					    const APPSPACK::Vector& hlow_in, 
					    const APPSPACK::Vector& hupp_in)
{
  crhs = crhs_in;
  hlow = hlow_in;
  hupp = hupp_in;
}
