/* $Id: ha6.cpp,v 1.3 2008/08/02 22:36:53 jgriffi Exp $ */
/* $Source: /usr/local/cvsroot/hopspack/results/gdl/src/ha6.cpp,v $ */

/* @HEADER */
// ************************************************************************
// 
//         HOPSPACK: Hybrid Opitmization Parallel Search Package
//               Copyright (2008) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//                                                                                 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.                                                                           .
// 
// Questions? Contact Tammy Kolda (tgkolda@sandia.gov) 
// 
// ************************************************************************
/* @HEADER */

/*! \file Hartman 6 problem
*/

#include <iostream>
#include <fstream>
#include <vector>
#include <math.h>

using std::vector;
using std::ifstream;
using std::ofstream;
using std::cout;
using std::endl;
using std::cerr;

//! The objective function
double feval(const vector<double>& x)
{
  double A[6][4]={{10.00,  0.05,  3.00, 17.00},
                  {3.00, 10.00,  3.50,  8.00},
                  {17.00, 17.00,  1.70,  0.05},
                  {3.50,  0.10, 10.00, 10.00},
                  {1.70,  8.00, 17.00,  0.10},
                  {8.00, 14.00,  8.00, 14.00}};

  double P[6][4] ={{0.1312, 0.2329, 0.2348, 0.4047},
                   {0.1696, 0.4135, 0.1451, 0.8828},
                   {0.5569, 0.8307, 0.3522, 0.8732},
                   {0.0124, 0.3736, 0.2883, 0.5743},
                   {0.8283, 0.1004, 0.3047, 0.1091},
                   {0.5886, 0.9991, 0.6650, 0.0381}};
  double c[] = {1.0, 1.2, 3.0, 3.2};

  double f=0;
  for (int i=0; i<4; i++)
  {
    double d=0;
    for (int j=0; j<6; j++)
      d += A[j][i]*pow(x[j] - P[j][i],2);
    f += c[i]*exp(-d);
  }
  f=-f;

  return f;
}

//! Main
int main(int argc, char* argv[])
{

  int i;			// counter 
  vector<double> x;		// x-vector 
  double y;			// solution of f(x) 
  ifstream fin;			// input file
  ofstream fout;		// output file

  // Check input arguments 

  if (argc < 2) 
  {
    cout << "usage: " << argv[0] << " <input file> <output file>" << endl;
    return -1;
  }

  system("sleepTest.sh");
  // Open input file 

  fin.open(argv[1]);
  if (!fin)
  {
    cout << argv[0] << " - Error opening input file " << argv[1] << endl;
    return -1;
  }

  // Read size of x 

  int n;
  fin >> n;

  // Allocate memory for x 

  x.resize(n);

  // Read x 

  for (i = 0; i < n; i ++)
    fin >> x[i];
  
  // Close input file 

  fin.close();

  // Open output file 

  fout.open(argv[2]);
  if (!fout)
  {
    cout << argv[0] << " - Error opening output file " << argv[2] << endl;
    return -1;
  }

  // Evaluate function at x 

  y = feval(x);

  // Write function value to output file 
  fout.precision(14);
  fout << y;

  // Close output file 

  fout.close();

  // Exit 

  return 0;
}
