/* This is third-party software that is distributed with Acro.
 * For licensing information concerning this file, see the Acro home page:
 * http://software.sandia.gov/Acro
 */

///////////////////////////////////////////////////////////////////
/*****************************************************************
Copyright: Artificial Life and Adaptive Robotics Laboratory - ALAR
School of ITEE, UNSW@ADFA, Australia, 2005
*******************************************************************/
///////////////////////////////////////////////////////////////////

#if !defined(_SPEA2)
#define _SPEA2

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "population.h"
#include "Random.h"
#include "objective.h"
#include "distance.h"
class operators_SPEA2
{
public:
	void Evolve(int population_size, int N_generation, int SEED, int n_Genes,int n_Objs,int *GSize,double *Ub,double *Lb, int CS);
	void crossover(population &pop);
	void mutation(population &pop);
	void create_mating_pool(population &PA,population &P);

	
	
	// housekeeping stuff
	void sort_array(double *&arr, int size);
	void sort_by_fitness(population &p);
	static void copyarray(unsigned int *&d,unsigned int *s,int size);
	double eDistance(individual &id1,individual &id2);

	// combinate the parrent set and archive set
	void combination(population &R, population &Q, population &P, int Q_size);
	
	void fitness_assignment(population &P);
	
	// Environmental selection
	// copy nondominated set
	void get_nondominated_set(population &Q, population &P, int ALPHA);
	// truncate the oversize population to the archive size
	void oversize(population &input, population &output);
	
	// set objective
	void set_objectivevalue(individual &id,double *real_params);
	void set_objectivevalue_maxmin(population &p, int size);
	
	// create initial population
	void initialize_population(const int n_Genes,int n_Objs,int *GSize,double *Ub,double *Lb,population &pop);
	
	operators_SPEA2(){pc=1;pm=0;max_values=NULL;min_values=NULL;}
	operators_SPEA2(double _pc,double _pm, int ObjID) {
		pc=_pc;pm=_pm;
		objID=ObjID;
		max_values=NULL;
		min_values=NULL;
		//R=NULL;
	}
	virtual ~operators_SPEA2();
	
	
	population newpop;  //temporary
	population P;          // parrent population: size N
	population PA,R;     // current archive and temporary population for combination P and PA


     
	int n_SEED,n_GEN;
	objective *obj;   // for objectives

	Random rnd;   //random generator
	double pc;    // crossover rate
	double pm;    // mutation rate
	
	//variable ranges
	double *min_values; 
	double *max_values;
	//int lastrun;
	double dev;
	int objID;
};

#endif // !defined(_SPEA2)
