/*  _________________________________________________________________________
 *
 *  Coliny: A Library of COLIN optimizers
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top Coliny directory.
 *  _________________________________________________________________________
 */

/**
 * \file EAminlp.h
 *
 * Defines the coliny::EAminlp typedef.
 */

#ifndef coliny_EAminlp_h
#define coliny_EAminlp_h

#include <acro_config.h>
#include <coliny/EAgeneric.h>
#include <coliny/DomainOpsMixedInteger.h>
#include <coliny/DomainInfoMixedInteger.h>

namespace coliny {

///
template <>
class EAgeneric_name<utilib::MixedIntVars,
        coliny::DomainInfoMixedInteger,
        coliny::DomainOpsMixedInteger<coliny::DomainInfoMixedInteger> >
{ protected: const char* get_name() { return "EAminlp"; } };


///
typedef coliny::EAgeneric<utilib::MixedIntVars, 
	coliny::DomainInfoMixedInteger,
	coliny::DomainOpsMixedInteger<coliny::DomainInfoMixedInteger> > EAminlp;

}

#endif
