/*  _________________________________________________________________________
 *
 *  Coliny: A Library of COLIN optimizers
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top Coliny directory.
 *  _________________________________________________________________________
 */

/**
 * \file DomainInfoMixedInteger.h
 *
 * Defines the coliny::DomainInfoMixedInteger class.
 */

#ifndef coliny_DomainInfoMixedInteger_h
#define coliny_DomainInfoMixedInteger_h

#include <acro_config.h>
#include <utilib/NumArray.h>
#include <coliny/DomainInfoBase.h>

namespace coliny {

///
class DomainInfoMixedInteger : public DomainInfoBase
{
public:

  ///
  virtual ~DomainInfoMixedInteger() {}

  ///
  bool epsa_flag;

  ///
  utilib::NumArray<double> scale;

  ///
  void copy(const DomainInfoMixedInteger& info)
	{
	epsa_flag = info.epsa_flag;
	scale << info.scale;
	}

  ///
  void write(std::ostream& os) const
	{os << "EPSA Flag: " << epsa_flag << "  Scale: " << scale << std::endl;}

  ///
  void read(std::istream& is) 
	{}

  ///
  void write(utilib::PackBuffer& os) const
	{os << epsa_flag << scale;}

  ///
  void read(utilib::UnPackBuffer& is) 
	{is >> epsa_flag >> scale;}

};

}

#endif
