/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

//
// OptProblem test
//

#include <acro_config.h>
#include <utilib/std_headers.h>
#include <utilib/stl_auxillary.h>
#include <colin/colin.h>

using namespace std;
using namespace colin;

class A {
public:
  vector<double> vec;
};

ostream& operator<<(ostream& os, const A& a)
{ os << a.vec; return os; }

istream& operator>>(istream& is, A& a)
{ is >> a.vec; return is; }

namespace colin {

template<>
void map_domain(A& a, const A& b)
{ a.vec &= b.vec; }

}

void func1(const A& x, AppResponse<>& response) {}
void func2(A& x, AppResponse<>& response) {}

void func9(const A& x, AppResponse<>& response) {}
void func10(A& x, AppResponse<>& response) {}

void func3(const utilib::pvector<double>& x, AppResponse<>& response) {}
void func4(utilib::pvector<double>& x, AppResponse<>& response) {}

void func7(const utilib::pvector<double>& x, const std::vector<int>& asv, 
		AppResponse<>& response) {}
void func8(utilib::pvector<double>& x, std::vector<int>& asv, 
		AppResponse<>& response) {}

void func13(A&, UserResponse<utilib::pvector<real > >& response) {}
void func14(const A&, UserResponse<utilib::pvector<real > >& response) {}

void fooA()
{
OptProblem<A> opt;
OptSetup(opt,&func1);
OptSetup(opt,&func2);
OptSetup(opt,&func9);
OptSetup(opt,&func10);
#ifdef ACRO_HAVE_TEMPLATES_AS_TEMPLATE_ARGUMENTS
OptSetup(opt,&func13);
OptSetup(opt,&func14);
#endif

A a;
real value;
opt.EvalF(a,value);
}


double func5(const double*, int n) {return -1.0;}
double func6(double*, int n) {return -1.0;}


double func11(const utilib::pvector<double>& x) {return -1.0;}
double func12(utilib::pvector<double>& x) {return -1.0;}

void func15(utilib::pvector<double>&, UserResponse<utilib::pvector<real > >& response) {}
void func16(const utilib::pvector<double>&, UserResponse<utilib::pvector<real > >& response) {}

void fooVec()
{
OptProblem<utilib::pvector<double> > opt;
OptSetup(opt,&func3);
OptSetup(opt,&func4);
OptSetup(opt,&func5);
OptSetup(opt,&func6);
OptSetup(opt,&func7);
OptSetup(opt,&func8);
OptSetup(opt,&func11);
OptSetup(opt,&func12);
#ifdef ACRO_HAVE_TEMPLATES_AS_TEMPLATE_ARGUMENTS
OptSetup(opt,&func15);
OptSetup(opt,&func16);
#endif
string str;
OptSetup(opt,str,str,str);

utilib::pvector<double> a;
real value;
opt.EvalF(a,value);
}

int main()
{return 0;}
