/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2001, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:        ForkApplicInterface
//- Description:  Derived class for the case when analysis code simulators use
//-               vfork\exec\wait to provide the function evaluations
//- Owner:        Mike Eldred
//- Version: $Id: ForkApplicInterface.H 1204 2002-12-02 14:19:54Z DEVsgopt $

#if 0

#ifndef FORK_APPLIC_INTERFACE_H
#define FORK_APPLIC_INTERFACE_H

#include "ForkAnalysisCode.H"
#include "ApplicationInterface.H"


/// Derived application interface class which spawns simulation codes
/// using forks.

/** ForkApplicInterface uses a ForkAnalysisCode object for performing
    simulation invocations. */

class ForkApplicInterface: public ApplicationInterface
{
  public:

    //
    //- Heading: Constructors and destructor
    //

    /// constructor
    ForkApplicInterface(const ProblemDescDB& problem_db, const size_t& num_fns);
    /// destructor
    ~ForkApplicInterface();

    //
    //- Heading: Virtual function redefinitions
    //

    void derived_map(const DakotaVariables& vars, const DakotaIntArray& asv,
	             DakotaResponse& response, int fn_eval_id);

    void derived_map_asynch(const ParamResponsePair& pair);

    void derived_synch(DakotaList<ParamResponsePair>& prp_list);

    void derived_synch_nowait(DakotaList<ParamResponsePair>& prp_list);

    int  derived_synchronous_local_analysis(const int& analysis_id);

  private:

    //
    //- Heading: Methods
    //

    /// Convenience function for common code between derived_synch() &
    /// derived_synch_nowait()
    void derived_synch_kernel(DakotaList<ParamResponsePair>& prp_list,
                              const pid_t pid);

    /// perform the complete function evaluation by managing the input
    /// filter, analysis programs, and output filter
    pid_t fork_application(const short block_flag);

    /// execute analyses asynchronously on the local processor
    void asynchronous_local_analyses(const int& start, const int& end,
                                     const int& step);

    /// execute analyses synchronously on the local processor
    void synchronous_local_analyses(const int& start, const int& end,
                                    const int& step);

    /// serve the analysis scheduler and execute analysis assignments
    /// asynchronously
    void serve_analyses_asynch();

    //void clear_bookkeeping(); // virtual fn redefinition: clear processIdList

    //
    //- Heading: Data
    //

    /// ForkAnalysisCode provides convenience functions for forking
    /// individual programs and checking fork exit status
    ForkAnalysisCode forkSimulator;

    /// list of process id's for asynchronous evaluations;
    /// correspondence to evalIdList used for mapping captured fork
    /// process id's to function evaluation id's
    DakotaList<pid_t> processIdList;
    /// list of function evaluation id's for asynchronous evaluations;
    /// correspondence to processIdList used for mapping captured fork
    /// process id's to function evaluation id's
    DakotaIntList evalIdList;
};


//inline void ForkApplicInterface::clear_bookkeeping()
//{ processIdList.clear(); }

#endif

#endif
