dnl @synopsis AX_CXX_HAVE_STD_DISTANCE
dnl
dnl Probes the C++ compiler to determine whether the version of the STL
dnl it uses makes std::clear() usable by instances of std::string.
dnl
dnl @author Shannon Brown <slbrow@sandia.gov>
dnl @category Cxx
dnl @license GPL2
dnl @version 2006-02-15

AC_DEFUN([AX_CXX_HAVE_STRING_CLEAR],
[AC_CACHE_CHECK(whether the C++ compiler has std::clear() (for STL strings),
ax_cv_cxx_have_string_clear,
[AC_REQUIRE([AC_CXX_NAMESPACES])
 AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 AC_TRY_COMPILE([#include <iterator>
#include <string>
#ifdef HAVE_NAMESPACES
using namespace std;
#endif],[string array = "test";array.clear();],
 ax_cv_cxx_have_string_clear=yes,ax_cv_cxx_have_string_clear=no)
 AC_LANG_RESTORE
])
 if test "x$ax_cv_cxx_have_string_clear" = xyes; then
   AC_DEFINE([HAVE_STRING_CLEAR],[1],
             [Define if you have an STL-conforming std::clear() for STL strings.])
 fi
])dnl
