#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>
#include <stdlib.h>

/* ---------------------------------------------------------------
   dim.dat file creator for Transportation Cask Shape Optimization
           Michael Eldred, Sandia National Laboratories,
                     C++, January 20, 1995
   --------------------------------------------------------------- */

/* Define symbolic constants */

#define MAXDESVAR 6 /* Maximum number of design variables */


main(int argc, char** argv)

{
     if(argc != 2) {
       cout << "Invalid command usage\n" << endl;
       exit(0);
     }

/* declarations */
     ifstream fin_dakota_temp_file(argv[1]); /* temps. in deg. C from timeplt.dat file */
     if (!fin_dakota_temp_file) {
        cout << "Cannot open file";
        exit(1);
     }
     ofstream fout_dimdat("dim.dat");

     int numdesvar;
     double x[MAXDESVAR+1];
     char label[80];

/* Set format for dim.dat output */
     fout_dimdat << setprecision(10);
//     fout_dimdat.setf(ios::scientific);
     
/* Read in design variable values from Dakota temporary file and 
   output design variable values to dim.dat in aprepro format */
     fin_dakota_temp_file >> numdesvar >> label;
     fout_dimdat << "$ container width           {cx = 3.0}   \n";
     fout_dimdat << "$ container height          {cy = 10.34} \n";
     fout_dimdat << "$ container wall thickness  {ct = 0.375} \n";
     for(int i=1; i<=numdesvar; i++) {
        fin_dakota_temp_file >> x[i] >> label;
        cout << i << " " << x[i] << " " << label << "\n";
        fout_dimdat << "$ " << label << "  {x" << i << " = " << x[i] << "} \n";
     }

}
