#include "petsc.h"
#include "petscfix.h"
#include "private/fortranimpl.h"
/* linesearch.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "taolinesearch.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchsetup_ TAOLINESEARCHSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchsetup_ taolinesearchsetup
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchreset_ TAOLINESEARCHRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchreset_ taolinesearchreset
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchdestroy_ TAOLINESEARCHDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchdestroy_ taolinesearchdestroy
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchapply_ TAOLINESEARCHAPPLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchapply_ taolinesearchapply
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchsetfromoptions_ TAOLINESEARCHSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchsetfromoptions_ taolinesearchsetfromoptions
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchgetnumberfunctionevaluations_ TAOLINESEARCHGETNUMBERFUNCTIONEVALUATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchgetnumberfunctionevaluations_ taolinesearchgetnumberfunctionevaluations
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchisusingtaosolverroutines_ TAOLINESEARCHISUSINGTAOSOLVERROUTINES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchisusingtaosolverroutines_ taolinesearchisusingtaosolverroutines
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchcomputeobjective_ TAOLINESEARCHCOMPUTEOBJECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchcomputeobjective_ taolinesearchcomputeobjective
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchcomputeobjectiveandgradient_ TAOLINESEARCHCOMPUTEOBJECTIVEANDGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchcomputeobjectiveandgradient_ taolinesearchcomputeobjectiveandgradient
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchcomputegradient_ TAOLINESEARCHCOMPUTEGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchcomputegradient_ taolinesearchcomputegradient
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchcomputeobjectiveandgts_ TAOLINESEARCHCOMPUTEOBJECTIVEANDGTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchcomputeobjectiveandgts_ taolinesearchcomputeobjectiveandgts
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchgetsolution_ TAOLINESEARCHGETSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchgetsolution_ taolinesearchgetsolution
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchgetstartingvector_ TAOLINESEARCHGETSTARTINGVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchgetstartingvector_ taolinesearchgetstartingvector
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchgetstepdirection_ TAOLINESEARCHGETSTEPDIRECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchgetstepdirection_ taolinesearchgetstepdirection
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchgetfullstepobjective_ TAOLINESEARCHGETFULLSTEPOBJECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchgetfullstepobjective_ taolinesearchgetfullstepobjective
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchsetvariablebounds_ TAOLINESEARCHSETVARIABLEBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchsetvariablebounds_ taolinesearchsetvariablebounds
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchsetinitialsteplength_ TAOLINESEARCHSETINITIALSTEPLENGTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchsetinitialsteplength_ taolinesearchsetinitialsteplength
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taolinesearchgetsteplength_ TAOLINESEARCHGETSTEPLENGTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taolinesearchgetsteplength_ taolinesearchgetsteplength
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif

void PETSC_STDCALL  taolinesearchsetup_(TaoLineSearch *ls, int *__ierr ){
*__ierr = TaoLineSearchSetUp(*ls);
}
void PETSC_STDCALL  taolinesearchreset_(TaoLineSearch *ls, int *__ierr ){
*__ierr = TaoLineSearchReset(*ls);
}
void PETSC_STDCALL  taolinesearchdestroy_(TaoLineSearch *ls, int *__ierr ){
*__ierr = TaoLineSearchDestroy(
	((ls) ));
}

void PETSC_STDCALL  taolinesearchapply_(TaoLineSearch *ls,Vec x,PetscReal *f,Vec g,Vec s,PetscReal *steplength,TaoLineSearchTerminationReason *reason, int *__ierr ){
*__ierr = TaoLineSearchApply(*ls,
	(Vec)PetscToPointer((x) ),f,
	(Vec)PetscToPointer((g) ),
	(Vec)PetscToPointer((s) ),steplength,
	((reason) ));
}
void PETSC_STDCALL  taolinesearchsetfromoptions_(TaoLineSearch *ls, int *__ierr ){
*__ierr = TaoLineSearchSetFromOptions(*ls);
}
void PETSC_STDCALL  taolinesearchgetnumberfunctionevaluations_(TaoLineSearch *ls,PetscInt *nfeval,PetscInt *ngeval,PetscInt *nfgeval, int *__ierr ){
*__ierr = TaoLineSearchGetNumberFunctionEvaluations(*ls,nfeval,ngeval,nfgeval);
}
void PETSC_STDCALL  taolinesearchisusingtaosolverroutines_(TaoLineSearch *ls,PetscBool *flg, int *__ierr ){
*__ierr = TaoLineSearchIsUsingTaoSolverRoutines(*ls,flg);
}
void PETSC_STDCALL  taolinesearchcomputeobjective_(TaoLineSearch *ls,Vec x,PetscReal *f, int *__ierr ){
*__ierr = TaoLineSearchComputeObjective(*ls,
	(Vec)PetscToPointer((x) ),f);
}
void PETSC_STDCALL  taolinesearchcomputeobjectiveandgradient_(TaoLineSearch *ls,Vec x,PetscReal *f,Vec g, int *__ierr ){
*__ierr = TaoLineSearchComputeObjectiveAndGradient(*ls,
	(Vec)PetscToPointer((x) ),f,
	(Vec)PetscToPointer((g) ));
}
void PETSC_STDCALL  taolinesearchcomputegradient_(TaoLineSearch *ls,Vec x,Vec g, int *__ierr ){
*__ierr = TaoLineSearchComputeGradient(*ls,
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((g) ));
}
void PETSC_STDCALL  taolinesearchcomputeobjectiveandgts_(TaoLineSearch *ls,Vec x,PetscReal *f,PetscReal *gts, int *__ierr ){
*__ierr = TaoLineSearchComputeObjectiveAndGTS(*ls,
	(Vec)PetscToPointer((x) ),f,gts);
}
void PETSC_STDCALL  taolinesearchgetsolution_(TaoLineSearch *ls,Vec x,PetscReal *f,Vec g,PetscReal *steplength,TaoLineSearchTerminationReason *reason, int *__ierr ){
*__ierr = TaoLineSearchGetSolution(*ls,
	(Vec)PetscToPointer((x) ),f,
	(Vec)PetscToPointer((g) ),steplength,
	((reason) ));
}
void PETSC_STDCALL  taolinesearchgetstartingvector_(TaoLineSearch *ls,Vec *x, int *__ierr ){
*__ierr = TaoLineSearchGetStartingVector(*ls,x);
}
void PETSC_STDCALL  taolinesearchgetstepdirection_(TaoLineSearch *ls,Vec *s, int *__ierr ){
*__ierr = TaoLineSearchGetStepDirection(*ls,s);
}

void PETSC_STDCALL  taolinesearchgetfullstepobjective_(TaoLineSearch *ls,PetscReal *f_fullstep, int *__ierr ){
*__ierr = TaoLineSearchGetFullStepObjective(*ls,f_fullstep);
}
void PETSC_STDCALL  taolinesearchsetvariablebounds_(TaoLineSearch *ls,Vec xl,Vec xu, int *__ierr ){
*__ierr = TaoLineSearchSetVariableBounds(*ls,
	(Vec)PetscToPointer((xl) ),
	(Vec)PetscToPointer((xu) ));
}
void PETSC_STDCALL  taolinesearchsetinitialsteplength_(TaoLineSearch *ls,PetscReal *s, int *__ierr ){
*__ierr = TaoLineSearchSetInitialStepLength(*ls,*s);
}
void PETSC_STDCALL  taolinesearchgetsteplength_(TaoLineSearch *ls,PetscReal *s, int *__ierr ){
*__ierr = TaoLineSearchGetStepLength(*ls,s);
}
#if defined(__cplusplus)
}
#endif
