// tps (01/14/2010) : Switching from rose.h to sage3. Added buildMangledNameMap, buildReplacementMap, fixupTraversal, replaceExpressionWithStatement
//#include "rose.h"
#include "sage3basic.h"
#include "markLhsValues.h"
#include "fixupNames.h"
#include "buildMangledNameMap.h"
#include "buildReplacementMap.h"
#include "fixupTraversal.h"
#include "sageInterface.h"
#include "replaceExpressionWithStatement.h"

#include "constantFolding.h"

// DQ (10/14/2006): Added supporting help functions. tps commented out since it caused no compilation errors
//#include "rewrite.h"

// Liao 1/24/2008 : need access to scope stack sometimes
#include "sageBuilder.h"

// For reusing some code from Qing's loop optimizer
// Liao, 2/26/2009
#include "AstInterface_ROSE.h"
#include "LoopTransformInterface.h"

#include "DepInfoAnal.h" // for AnalyzeStmtRefs()
#include "ArrayAnnot.h"
#include "ArrayInterface.h"

#include "LoopUnroll.h"
#include "abstract_handle.h"
#include "roseAdapter.h"

#include <sstream>
#include <iostream>
#include <algorithm> //for set operations

typedef std::set<SgLabelStatement*> SgLabelStatementPtrSet;

// DQ (12/31/2005): This is OK if not declared in a header file
using namespace std;
using namespace SageBuilder;

int SageInterface::gensym_counter = 0;
#if 0 // use StringUtility::numberToString() instead
template <typename T>
static std::string numToString(T x)
{
  std::ostringstream os;
  os <<x;
  return os.str();
}
#endif
// DQ: 09/23/03
// We require a global function for getting the string associated
// with the definition of a variant (which is a global enum).
string getVariantName ( VariantT v )
   {
     ROSE_ASSERT( int(v) < int(V_SgNumVariants));

  // This code is far simpler (if the function is static)

  // DQ (4/8/2004): Modified code to use new global list of sage
  // class names (simpler this way)
  // return string(SgTreeTraversal<int,int>::get_variantName(v));
     extern const char* roseGlobalVariantNameList[];
     return string(roseGlobalVariantNameList[v]);
   }

SgNamespaceDefinitionStatement*
SageInterface::enclosingNamespaceScope( SgDeclarationStatement* declaration )
   {
  // DQ (11/4/2007): This function is used in the markTemplateInstantiationsForOutput.C

  // This function returns the namespace associated with any declaration.
  // If the declaration is nested inside of other scopes this function
  // iterates through these scopes to get the the first namespace.
  // This is important for details of template handling, namely making sure
  // that the template specializations (generated by ROSE) are put into the
  // correct location (namespace) since stricted rules in gnu now enforce
  // these details.  If the declaration is not in a namespace as computed
  // in the chain of scopes then this function returns NULL.

     ROSE_ASSERT(declaration != NULL);
     SgScopeStatement* tempScope = declaration->get_scope();

  // Loop back to the first namespace or stop at global scope (stop on either a namespace or the global scope)
     while ( isSgNamespaceDefinitionStatement(tempScope) == NULL && isSgGlobal(tempScope) == NULL )
        {
          tempScope = tempScope->get_scope();
          ROSE_ASSERT(tempScope != NULL);
#if 0
          printf ("Iterating back through scopes: tempScope = %p = %s = %s \n",tempScope,tempScope->class_name().c_str(),SageInterface::get_name(tempScope).c_str());
#endif
        }

     SgNamespaceDefinitionStatement* namespaceScope = isSgNamespaceDefinitionStatement(tempScope);
     return namespaceScope;
   }


SgDeclarationStatement*
SageInterface::getNonInstantiatonDeclarationForClass ( SgTemplateInstantiationMemberFunctionDecl* memberFunctionInstantiation )
   {
  // DQ (11/4/2007): This function is used in the markTemplateInstantiationsForOutput.C
  // DQ (11/4/2007): Get the associated declaration that will be in the original source code,
  // if it is part of a template instantiation then get the original template declaration.

     SgDeclarationStatement* parentDeclaration = NULL;

     SgClassDefinition* classDefinition = memberFunctionInstantiation->get_class_scope();
     ROSE_ASSERT(classDefinition != NULL);

     SgTemplateDeclaration* templateDeclaration = memberFunctionInstantiation->get_templateDeclaration();
     ROSE_ASSERT(templateDeclaration != NULL);

  // If it is a template instatiation, then we have to find the temple declaration (not the template instantiation declaration), else we want the class declaration.
     SgTemplateInstantiationDefn* templateInstatiationClassDefinition = isSgTemplateInstantiationDefn(classDefinition);
     if (templateInstatiationClassDefinition != NULL)
        {
       // This is the case of a template member function in a templated class (see test2005_172.C).
          SgTemplateInstantiationDefn* parentTemplateInstantiationDefinition = isSgTemplateInstantiationDefn(templateDeclaration->get_scope());
          ROSE_ASSERT(parentTemplateInstantiationDefinition != NULL);
          SgTemplateInstantiationDecl* parentTemplateInstantiationDeclaration = isSgTemplateInstantiationDecl(parentTemplateInstantiationDefinition->get_declaration());
          ROSE_ASSERT(parentTemplateInstantiationDeclaration != NULL);

          parentDeclaration = parentTemplateInstantiationDeclaration->get_templateDeclaration();
          ROSE_ASSERT(parentDeclaration != NULL);
        }
       else
        {
       // This is the case of a template member function in a class definition (see test2005_168.C).
          parentDeclaration = classDefinition->get_declaration();
          ROSE_ASSERT(parentDeclaration != NULL);
        }

      return parentDeclaration;
   }

//! Liao, 11/9/2009
  //! a better version for SgVariableDeclaration::set_baseTypeDefininingDeclaration(), handling all side effects automatically
  //! Used to have a struct declaration embedded into a variable declaration
  void SageInterface::setBaseTypeDefiningDeclaration(SgVariableDeclaration* var_decl, SgDeclarationStatement *base_decl)
{
  ROSE_ASSERT (var_decl && base_decl);

  // try to remove it from the scope's declaration list
  // If the struct decl was previously inserted into its scope
  if (base_decl->get_parent() != NULL)
  {
    if (base_decl->get_scope() == base_decl->get_parent())
    {
      SgStatementPtrList stmt_list = base_decl->get_scope()->generateStatementList();
      if (find(stmt_list.begin(), stmt_list.end(), base_decl) != stmt_list.end())
        SageInterface::removeStatement(base_decl);
    }
  }
  base_decl->set_parent(var_decl);
  var_decl->set_baseTypeDefiningDeclaration(base_decl);

  //Set an internal mangled name for the anonymous declaration, if necessary
  //  resetNamesInAST(); // this will trigger mangleNameMap.size() ==0 assertion.
  // We call resetEmptyNames directly instead.
  ResetEmptyNames t1;
  t1.traverseMemoryPool();
}

// DQ (11/4/2007): This looks for a forward temple member function declaration of matching name exists in the specified scope.
bool
SageInterface::isPrototypeInScope ( SgScopeStatement* scope, SgFunctionDeclaration* functionDeclaration, SgDeclarationStatement* startingAtDeclaration )
   {
  // DQ (11/3/2007): Look for an existing previously inserted (or existing) template member function declaration and only add one if we can't find it.

     bool foundExistingPrototype = false;

     ROSE_ASSERT(scope != NULL);
     ROSE_ASSERT(functionDeclaration != NULL);
     ROSE_ASSERT(startingAtDeclaration != NULL);

  // These are the scopes for which get_declarationList() is properly defined.
     ROSE_ASSERT(scope->containsOnlyDeclarations() == true);

  // Note that this is only defined for certain scopes, but we only want it for THOSE scopes
     SgDeclarationStatementPtrList & declarationList = scope->getDeclarationList();

  // This is a simple way to restrict the evaluation (still linear, but jumps to initial position to start search).
     SgDeclarationStatementPtrList::iterator startingLocation = find(declarationList.begin(),declarationList.end(),startingAtDeclaration);

     if (startingLocation != declarationList.end())
        {
#if 0
          printf ("startingLocation = %p = %s = %s \n",*startingLocation,(*startingLocation)->class_name().c_str(),SageInterface::get_name(*startingLocation).c_str());
#endif
       // printf ("Found the startingLocation is the global scope, now check if we need to add a new declaration \n");
          SgDeclarationStatementPtrList::iterator i = startingLocation;
          SgScopeStatement* targetScope = functionDeclaration->get_scope();
          SgName targetName = functionDeclaration->get_name();

          while (i != declarationList.end())
             {
            // printf ("i = %p = %s = %s \n",*i,(*i)->class_name().c_str(),SageInterface::get_name(*i).c_str());

            // Look for a prototype like what we want to insert, if we find it then we don't need to add a second one!
               SgTemplateInstantiationMemberFunctionDecl* templateMemberFunction = isSgTemplateInstantiationMemberFunctionDecl(*i);
               if (templateMemberFunction != NULL)
                  {
                 // Check the name and the scope
                 // if (memberFunctionInstantiation->get_scope() == templateMemberFunction->get_scope())
                    if (targetScope == templateMemberFunction->get_scope())
                       {
                      // printf ("Testing member function = %s against member function = %s \n",memberFunctionInstantiation->get_name().str(),templateMemberFunction->get_name().str());
                      // if (memberFunctionInstantiation->get_name() == templateMemberFunction->get_name())
                         if (targetName == templateMemberFunction->get_name())
                            {
                           // Don't count the defining declaration which may be at the end of the global scope.
                              if (templateMemberFunction->isForward() == true)
                                 {
                                   foundExistingPrototype = true;

                                // Exit the loop (optimization)
                                   break;
                                 }
                            }
                       }
                  }

               i++;
             }
        }

     return foundExistingPrototype;
   }

bool
SageInterface::isAncestor (SgNode* node1, SgNode* node2)
{
  ROSE_ASSERT(node1&&node2);
  SgNode* curnode= node2;
  if (node1==node2)
    return false;
  do {
      curnode= curnode->get_parent();
  } while( (curnode!=NULL)&&(curnode!=node1));

  if (curnode==node1)
   return true;
  else
    return false;
}

std::vector<SgNode*>
SageInterface::astIntersection ( SgNode* original, SgNode* copy, SgCopyHelp* help )
   {
     std::vector<SgNode*> intersectionSet;

  // Collect all the IR nodes for the original AST
     std::vector<SgNode*> AST_original = NodeQuery::querySubTree (original,V_SgNode);
     std::vector<SgNode*> AST_copy     = NodeQuery::querySubTree (copy,V_SgNode);

     int AST_original_size = AST_original.size();
     int AST_copy_size     = AST_copy.size();

     if (SgProject::get_verbose() > 0)
        {
          printf ("Original AST size         = %d \n",AST_original_size);
          printf ("Copy of original AST size = %d \n",AST_copy_size);
        }

     int differenceInSizes = AST_original_size - AST_copy_size;
     if (differenceInSizes == 0)
        {
          if (SgProject::get_verbose() > 0)
               printf ("Copied AST is the SAME size as the original (size = %d) \n",AST_original_size);
        }
       else
        {
          printf ("Warning: Copied AST and the original are DIFFERENT sizes (original size = %d copyied size = %d) \n",AST_original_size,AST_copy_size);
        }

  // Compute the intersection (reference in the copy that point to the origal AST).
  // std::set<SgNode*> AST_set_original = AST_original;
     std::set<SgNode*> AST_set_original;
     for (int i = 0; i < AST_original_size; i++)
        {
          AST_set_original.insert(AST_original[i]);
        }

     std::set<SgNode*> AST_set_copy;
     for (int i = 0; i < AST_copy_size; i++)
        {
          AST_set_copy.insert(AST_copy[i]);
        }

     int size = AST_original_size;
     std::vector<SgNode*> intersectionList(size);

  // Is there a better way to do this? Build scratch space and then use the different between begin() and end to build another vector.
     std::vector<SgNode*>::iterator end = set_intersection(AST_set_original.begin(),AST_set_original.end(),AST_set_copy.begin(),AST_set_copy.end(),intersectionList.begin());

  // Build a new vector from the relevant elements of the intersectionList scratch space.
     std::vector<SgNode*> meaningIntersectionList = std::vector<SgNode*>(intersectionList.begin(),end);
     std::vector<SgNode*> deleteList;
     for (int i = 0; i < (int)meaningIntersectionList.size(); i++)
        {
       // printf ("     (before removing types) meaningIntersectionList[%d] = %p = %s \n",i,meaningIntersectionList[i],(meaningIntersectionList[i] != NULL) ? meaningIntersectionList[i]->class_name().c_str() : "NULL");
          if (meaningIntersectionList[i] != NULL && isSgType(meaningIntersectionList[i]) != NULL)
             {
               deleteList.push_back(meaningIntersectionList[i]);
             }
        }

  // Remove the types since they are allowed to be shared...
     if (SgProject::get_verbose() > 0)
          printf ("Remove the types that are allowed to be shared: deleteList.size() = %ld \n",(long)deleteList.size());

     for (std::vector<SgNode*>::iterator i = deleteList.begin(); i != deleteList.end(); i++)
        {
          meaningIntersectionList.erase(find(meaningIntersectionList.begin(),meaningIntersectionList.end(),*i));
        }

     if (SgProject::get_verbose() > 0)
          printf ("After removing the types there are meaningIntersectionList.size() = %ld \n",(long)meaningIntersectionList.size());

     for (int i = 0; i < (int)meaningIntersectionList.size(); i++)
        {
       // printf ("     meaningIntersectionList[%d] = %p = %s \n",i,meaningIntersectionList[i],(meaningIntersectionList[i] != NULL) ? meaningIntersectionList[i]->class_name().c_str() : "NULL");
          printf ("     meaningIntersectionList[%d] = %p = %s = %s \n",i,meaningIntersectionList[i],meaningIntersectionList[i]->class_name().c_str(),get_name(meaningIntersectionList[i]).c_str());
        }

     int unmatchedIRnodes = 0;
     if (help != NULL)
        {
          std::vector<SgNode*> tmp_AST_original; // = AST_original;
          std::vector<SgNode*> tmp_AST_copy; //     = AST_copy;

          int AST_original_size = AST_original.size();
          for (int j = 0; j < AST_original_size; j++)
             {
               if (AST_original[j] != NULL && isSgType(AST_original[j]) == NULL)
                  {
                    tmp_AST_original.push_back(AST_original[j]);
                  }
             }

          int AST_copy_size = AST_copy.size();
          for (int j = 0; j < AST_copy_size; j++)
             {
               if (AST_copy[j] != NULL && isSgType(AST_copy[j]) == NULL)
                  {
                    tmp_AST_copy.push_back(AST_copy[j]);
                  }
             }

          std::vector<SgNode*> deleteList_original;
          std::vector<SgNode*> deleteList_copy;
          for (int j = 0; j < (int)tmp_AST_original.size(); j++)
             {
            // printf ("     (before removing types) meaningIntersectionList[%d] = %p = %s \n",i,meaningIntersectionList[i],(meaningIntersectionList[i] != NULL) ? meaningIntersectionList[i]->class_name().c_str() : "NULL");
               SgCopyHelp::copiedNodeMapTypeIterator i = help->get_copiedNodeMap().find(tmp_AST_original[j]);
            // printf ("SgCopyHelp::copiedNodeMapTypeIterator i != help->get_copiedNodeMap().end() = %s \n",i != help->get_copiedNodeMap().end() ? "true" : "false");
               if (i != help->get_copiedNodeMap().end())
                  {
                 // Matched up an original IR node with it's copy
                    SgNode* associated_node_copy = i->second;
                    ROSE_ASSERT(associated_node_copy != NULL);
                    deleteList_original.push_back(tmp_AST_original[j]);
                    deleteList_copy.push_back(associated_node_copy);
#if 0
                 // printf ("Original IR node = %p = %s copy = %p \n",tmp_AST_original[j],tmp_AST_original[j]->class_name().c_str(),associated_node_copy);
                    SgTemplateInstantiationMemberFunctionDecl* templateMemberFunction = isSgTemplateInstantiationMemberFunctionDecl(tmp_AST_original[j]);
                    SgTemplateInstantiationMemberFunctionDecl* templateMemberFunction_copy = isSgTemplateInstantiationMemberFunctionDecl(associated_node_copy);
                    if (templateMemberFunction != NULL)
                       {
                         printf ("In SageInterface::astIntersection(): Found a SgTemplateInstantiationMemberFunctionDecl = %p copy = %p \n",templateMemberFunction,associated_node_copy);
                      // templateMemberFunction->get_startOfConstruct()->display("original: debug");
                      // templateMemberFunction_copy->get_startOfConstruct()->display("copy: debug");
                       }
#endif
                  }
             }

          int deleteList_original_size = deleteList_original.size();
          for (int j = 0; j < deleteList_original_size; j++)
             {
            // tmp_AST_original.erase(find(tmp_AST_original.begin(),tmp_AST_original.end(),deleteList_original[j]));
               std::vector<SgNode*>::iterator k = find(tmp_AST_original.begin(),tmp_AST_original.end(),deleteList_original[j]);
               if (k != tmp_AST_original.end())
                  {
                    tmp_AST_original.erase(k);
                  }
             }

          if (SgProject::get_verbose() > 0)
               printf ("IR nodes different between the original AST and the copy of the AST = %zu \n",tmp_AST_original.size());

          for (int j = 0; j < (int)tmp_AST_original.size(); j++)
             {
               printf ("non matched IR node = %p = %s = %s \n",tmp_AST_original[j],tmp_AST_original[j]->class_name().c_str(),get_name(tmp_AST_original[j]).c_str());
            // tmp_AST_original[j]->get_startOfConstruct()->display("debug");
             }

          unmatchedIRnodes = (int)tmp_AST_original.size();
        }

  // DQ (11/2/2007): Make this an error now!
     if (differenceInSizes != 0)
        {
          SgProject* originalProject = isSgProject(original);
          if (originalProject != NULL)
             {
               printf ("In %s Copied AST and the original are DIFFERENT sizes (original size = %d copyied size = %d) IR nodes different = %d \n",
                    (*originalProject)[0]->get_sourceFileNameWithoutPath().c_str(),AST_original_size,AST_copy_size,unmatchedIRnodes);
             }

          if (unmatchedIRnodes > 0)
             {
               printf ("Make this an error under stricter testing \n");
               ROSE_ASSERT(false);
             }
        }

     return intersectionSet;
   }

// AJ (10/21/2004): Added support for changing the symbol name associated with an SgInitializedName
// by updating the symbol table
int
SageInterface::set_name ( SgInitializedName *initializedNameNode, SgName new_name )
   {
  // find the appropriate symbol table, delete the symbol
  // with the old name and add a symbol with the new name.
     ROSE_ASSERT(initializedNameNode != NULL);

  // SgNode * node = this;

#if 0
  // DQ (12/9/2004): This should likely call the get_scope function (which is more robust than traversing
  // parents, there is a reason why we are forced to include the scope explicitly on some IR nodes,
  // see test2004_133.C for details).
     while((node!=NULL) && ( isSgScopeStatement(node)==NULL))
          node = node->get_parent();

     ROSE_ASSERT(node!=NULL);

     SgScopeStatement * scope_stmt = isSgScopeStatement(node);
#else
     SgScopeStatement *scope_stmt = initializedNameNode->get_scope();
#endif

     ROSE_ASSERT(scope_stmt != NULL);
     ROSE_ASSERT(scope_stmt->get_symbol_table() != NULL);
     ROSE_ASSERT(scope_stmt->get_symbol_table()->get_table() != NULL);

     SgDeclarationStatement * parent_declaration = initializedNameNode->get_declaration();

     ROSE_ASSERT(parent_declaration != NULL);

  // Find the symbols associated with p_name
     std::pair<SgSymbolTable::hash_iterator,SgSymbolTable::hash_iterator> pair_it =
          scope_stmt->get_symbol_table()->get_table()->equal_range(initializedNameNode->get_name());

     SgSymbolTable::hash_iterator found_it=scope_stmt->get_symbol_table()->get_table()->end();

     for(SgSymbolTable::hash_iterator it = pair_it.first; it != pair_it.second; ++it)
        {
          switch(parent_declaration->variantT())
             {
               case V_SgVariableDeclaration:
                  {
                    if (isSgVariableSymbol((*it).second)!=NULL)
                         found_it = it;
                    break;
                  }
               case V_SgClassDeclaration:
                  {
                    if (isSgClassSymbol((*it).second)!=NULL)
                         found_it = it;
                    break;
                  }
               case V_SgFunctionDeclaration:
                  {
                    if (isSgFunctionSymbol((*it).second)!=NULL)
                         found_it = it;
                    break;
                  }
               default:
                  {
                  }
             };
        }

  // there is no Variable,Class or Function symbol associated with p_name
     if (found_it == scope_stmt->get_symbol_table()->get_table()->end())
        {
          printf ("Warning: There is no Variable,Class or Function symbol associated with p_name \n");
          return 0;
        }

     SgSymbol * associated_symbol = (*found_it).second;

  // erase the name from there
     scope_stmt->get_symbol_table()->get_table()->erase(found_it);

  // insert the new_name in the symbol table
// CH (4/9/2010): Use boost::unordered instead
//#ifdef _MSCx_VER
#if 0
  // DQ (11/28/2009): Unclear if this code is a problem (testing).

// CH (4/7/2010): It seems that the following code can be compiled under MSVC 9.0
//#pragma message ("WARNING: this code does not apprear to compile with MSVC.")
//	 printf ("ERROR: this code does not apprear to compile with MSVC. \n");
//	 ROSE_ASSERT(false);
     found_it = scope_stmt->get_symbol_table()->get_table()->insert(pair<SgName,SgSymbol*> ( new_name,associated_symbol));
#else
     found_it = scope_stmt->get_symbol_table()->get_table()->insert(pair<SgName,SgSymbol*> ( new_name,associated_symbol));
#endif
  // if insertion failed
     if (found_it == scope_stmt->get_symbol_table()->get_table()->end())
        {
          printf ("Warning: insertion of new symbol failed \n");
          return 0;
        }

  // Set the p_name to the new_name
     printf ("Reset initializedNameNode->get_name() = %s to new_name = %s \n",initializedNameNode->get_name().str(),new_name.str());
  // p_name = new_name;
     initializedNameNode->set_name(new_name);

  // Invalidate the p_iterator, p_no_name and p_name data members in the Symbol table

     return 1;
   }

string
SageInterface::get_name ( const SgC_PreprocessorDirectiveStatement* directive )
   {
     string name = "undefined_name";

     ROSE_ASSERT(directive != NULL);

     name = directive->class_name();

#if 1
  // I don't think we need this code now!
     switch (directive->variantT())
        {
       // Separate out these cases...
          case V_SgIncludeDirectiveStatement:
          case V_SgDefineDirectiveStatement:
          case V_SgUndefDirectiveStatement:
          case V_SgIfdefDirectiveStatement:
          case V_SgIfndefDirectiveStatement:
          case V_SgDeadIfDirectiveStatement:
          case V_SgIfDirectiveStatement:
          case V_SgElseDirectiveStatement:
          case V_SgElseifDirectiveStatement:
          case V_SgLineDirectiveStatement:
          case V_SgWarningDirectiveStatement:
          case V_SgErrorDirectiveStatement:
          case V_SgEmptyDirectiveStatement:
             {
               name = directive->class_name();
               break;
             }

       // case ClinkageDeclarationStatement:
          case V_SgClinkageStartStatement:
          case V_SgClinkageEndStatement:
             {
               name = directive->class_name();
               break;
             }

          case V_SgFortranIncludeLine:
             {
               name = directive->class_name();
               break;
             }

          default:
            // name = "default name (default case reached: not handled)";
               printf ("Warning: default case reached in SageInterface::get_name ( const SgC_PreprocessorDirectiveStatement* directive ), directive = %p = %s \n",
                    directive,directive->class_name().c_str());
               ROSE_ASSERT(false);

               name = "directive_default_name_case_reached_not_handled";
               break;
        }
#endif

     return name;
   }

string
SageInterface::get_name ( const SgDeclarationStatement* declaration )
   {
     string name = "undefined_name";

     ROSE_ASSERT(declaration != NULL);

  // DQ (11/23/2008): Handle the case of a Cpp directive...
     const SgC_PreprocessorDirectiveStatement* directive = isSgC_PreprocessorDirectiveStatement(declaration);
     if (directive != NULL)
        {
          return SageInterface::get_name (directive);
        }

     switch (declaration->variantT())
        {
          case V_SgTemplateDeclaration:
               name = isSgTemplateDeclaration(declaration)->get_name().str();
               break;

       // DQ (2/10/2007): Use the get_templateName() instead of combining this with the case V_SgClassDeclaration
          case V_SgTemplateInstantiationDecl:
               name = isSgTemplateInstantiationDecl(declaration)->get_templateName().str();
               break;

          case V_SgClassDeclaration:
          case V_SgDerivedTypeStatement:
               name = isSgClassDeclaration(declaration)->get_name().str();
               break;

          case V_SgEnumDeclaration:
               name = isSgEnumDeclaration(declaration)->get_name().str();
               break;

          case V_SgTypedefDeclaration:
               name = isSgTypedefDeclaration(declaration)->get_name().str();
               break;

          case V_SgFunctionDeclaration:
          case V_SgProgramHeaderStatement:
          case V_SgProcedureHeaderStatement:
          case V_SgMemberFunctionDeclaration:
          case V_SgTemplateInstantiationFunctionDecl:
          case V_SgTemplateInstantiationMemberFunctionDecl:
               name = isSgFunctionDeclaration(declaration)->get_name().str();
               break;

          case V_SgNamespaceDeclarationStatement:
               name = isSgNamespaceDeclarationStatement(declaration)->get_name().str();
               break;

       // DQ (2/12/2006): Added support to get name of SgFunctionParameterList
          case V_SgFunctionParameterList:
             {
            // Parents should be set prior to calling these functions (if not we might have to implement that case)
               ROSE_ASSERT(declaration->get_parent() != NULL);
               SgFunctionDeclaration* functionDeclaration = isSgFunctionDeclaration(declaration->get_parent());
               ROSE_ASSERT(functionDeclaration != NULL);
               name = get_name(functionDeclaration);
               name += "_parameter_list_";
               break;
             }

       // DQ (3/8/2006): Implemented case for variable declaration (forgot this case)
          case V_SgVariableDeclaration:
             {
            // DQ (2/11/2007): Modified to return names that can be used as variables (required
            // because we use this mechanism to generate names for unnamed structs and enums).
               name = "_variable_declaration_";
               const SgVariableDeclaration* variableDeclaration = isSgVariableDeclaration(declaration);
               ROSE_ASSERT(variableDeclaration != NULL);
               SgInitializedNamePtrList::const_iterator i = variableDeclaration->get_variables().begin();

            // Make sure that we have at least one variable in the list
               ROSE_ASSERT(i != variableDeclaration->get_variables().end());
               do {
                 // name += string(" ") + string((*i)->get_name().str());
                    name += string((*i)->get_name().str());
                    i++;
                  }
               while (i != variableDeclaration->get_variables().end());
               break;
             }


       // DQ (3/8/2006): Implemented case for variable declaration (forgot this case)
          case V_SgVariableDefinition:
             {
            // DQ (2/11/2007): Modified to return names that can be used as variables (required
            // because we use this mechanism to generate names for unnamed structs and enums).
               name = "_variable_definition_";
               const SgVariableDefinition* variableDefinition = isSgVariableDefinition(declaration);
               ROSE_ASSERT(variableDefinition != NULL);

            // define this in terms of the associated SgInitializedName
               ROSE_ASSERT(variableDefinition->get_vardefn() != NULL);
               name += get_name(variableDefinition->get_vardefn());
               break;
             }

       // DQ (3/17/2006): Implemented case for pragma declaration (forgot this case)
          case V_SgPragmaDeclaration:
             {
               name = "_pragma_declaration_";
               const SgPragmaDeclaration* pragmaDeclaration = isSgPragmaDeclaration(declaration);
               ROSE_ASSERT(pragmaDeclaration != NULL);
               ROSE_ASSERT(pragmaDeclaration->get_pragma() != NULL);
               name += get_name(pragmaDeclaration->get_pragma());
               break;
             }

       // DQ (4/15/2007): Implemented case for using directive statement (forgot this case)
          case V_SgUsingDirectiveStatement:
             {
               name = "_using_directive_statement_";
               const SgUsingDirectiveStatement* usingDeclaration = isSgUsingDirectiveStatement(declaration);
               ROSE_ASSERT(usingDeclaration != NULL);
               ROSE_ASSERT(usingDeclaration->get_namespaceDeclaration() != NULL);
               name += get_name(usingDeclaration->get_namespaceDeclaration());
               break;
             }

       // DQ (6/20/2007): Added new case!
          case V_SgNamespaceAliasDeclarationStatement:
             {
               name = "_namespace_alias_directive_statement_";
               const SgNamespaceAliasDeclarationStatement* namespaceAliasDeclaration = isSgNamespaceAliasDeclarationStatement(declaration);
               ROSE_ASSERT(namespaceAliasDeclaration != NULL);
               ROSE_ASSERT(namespaceAliasDeclaration->get_name().is_null() == false);
               name += namespaceAliasDeclaration->get_name();
               break;
             }

       // DQ (6/20/2007): Added new case!
          case V_SgUsingDeclarationStatement:
             {
               name = "_using_declaration_statement_";
               const SgUsingDeclarationStatement* usingDeclaration = isSgUsingDeclarationStatement(declaration);
               ROSE_ASSERT(usingDeclaration != NULL);
               if (usingDeclaration->get_declaration() != NULL)
                  {
                    name += get_name(usingDeclaration->get_declaration());
                  }
                 else
                  {
                    ROSE_ASSERT(usingDeclaration->get_initializedName() != NULL);
                    name += get_name(usingDeclaration->get_initializedName());
                  }
               break;
             }

       // DQ (6/20/2007): Added new case!
          case V_SgTemplateInstantiationDirectiveStatement:
             {
               name = "_template_instantiation_directive_statement_";
               ROSE_ASSERT(declaration != NULL);
               const SgTemplateInstantiationDirectiveStatement* templateInstantiationDirective = isSgTemplateInstantiationDirectiveStatement(declaration);
               ROSE_ASSERT(templateInstantiationDirective != NULL);
               ROSE_ASSERT(templateInstantiationDirective->get_declaration() != NULL);
               printf ("declaration->get_declaration() = %p = %s \n",templateInstantiationDirective->get_declaration(),templateInstantiationDirective->get_declaration()->class_name().c_str());
               name += get_name(templateInstantiationDirective->get_declaration());
               break;
             }

          case V_SgCtorInitializerList:
             {
               name = "_ctor_list_";
               const SgCtorInitializerList* ctorDeclaration = isSgCtorInitializerList(declaration);
               ROSE_ASSERT(ctorDeclaration != NULL);
               ROSE_ASSERT(ctorDeclaration->get_parent() != NULL);
               name += get_name(ctorDeclaration->get_parent());
               break;
             }

       // DQ (8/9/2007): Added case for SgAsmStmt
          case V_SgAsmStmt:
             {
               name = "_asm_stmt_";
               const SgAsmStmt* asmStatement = isSgAsmStmt(declaration);
               ROSE_ASSERT(asmStatement != NULL);
               ROSE_ASSERT(asmStatement->get_parent() != NULL);
               name += StringUtility::numberToString(const_cast<SgAsmStmt*>(asmStatement));
               break;
             }

       // DQ (8/22/2007): Added case for SgImplicitStatement
          case V_SgImplicitStatement:
             {
               name = "_fortran_implicit_";
               const SgImplicitStatement* implicitStatement = isSgImplicitStatement(declaration);
               ROSE_ASSERT(implicitStatement != NULL);
               ROSE_ASSERT(implicitStatement->get_parent() != NULL);
               name += StringUtility::numberToString(const_cast<SgImplicitStatement*>(implicitStatement));
               break;
             }

       // DQ (8/22/2007): Added case for SgNamelistStatement
          case V_SgNamelistStatement:
             {
               name = "_fortran_namelist_";
               const SgNamelistStatement* namelistStatement = isSgNamelistStatement(declaration);
               ROSE_ASSERT(namelistStatement != NULL);
               ROSE_ASSERT(namelistStatement->get_parent() != NULL);
               name += StringUtility::numberToString(const_cast<SgNamelistStatement*>(namelistStatement));
               break;
             }

       // DQ (11/21/2007): Added case for SgEquivalenceStatement
          case V_SgEquivalenceStatement:
             {
               name = "_fortran_equivalence_";
               const SgEquivalenceStatement* equivalenceStatement = isSgEquivalenceStatement(declaration);
               ROSE_ASSERT(equivalenceStatement != NULL);
               ROSE_ASSERT(equivalenceStatement->get_parent() != NULL);
               name += StringUtility::numberToString(const_cast<SgEquivalenceStatement*>(equivalenceStatement));
               break;
             }


       // DQ (11/21/2007): Added case for SgCommonBlock
          case V_SgCommonBlock:
             {
               name = "_fortran_common_block_";
               const SgCommonBlock* commonBlockStatement = isSgCommonBlock(declaration);
               ROSE_ASSERT(commonBlockStatement != NULL);
               ROSE_ASSERT(commonBlockStatement->get_parent() != NULL);
               name += StringUtility::numberToString(const_cast<SgCommonBlock*>(commonBlockStatement));
               break;
             }

       // DQ (11/21/2007): Added case for SgImportStatement
          case V_SgImportStatement:
             {
               name = "_fortran_import_stmt_";
               const SgImportStatement* importStatement = isSgImportStatement(declaration);
               ROSE_ASSERT(importStatement != NULL);
               ROSE_ASSERT(importStatement->get_parent() != NULL);
               name += StringUtility::numberToString(const_cast<SgImportStatement*>(importStatement));
               break;
             }

       // DQ (11/21/2007): Added case for SgFormatStatement
          case V_SgFormatStatement:
             {
               name = "_fortran_format_stmt_";
               const SgFormatStatement* formatStatement = isSgFormatStatement(declaration);
               ROSE_ASSERT(formatStatement != NULL);
               ROSE_ASSERT(formatStatement->get_parent() != NULL);
               name += StringUtility::numberToString(const_cast<SgFormatStatement*>(formatStatement));
               break;
             }

       // DQ (12/27/2007): Added case for SgModuleStatement
          case V_SgModuleStatement:
             {
               name = "_fortran_module_stmt_";
               const SgModuleStatement* moduleStatement = isSgModuleStatement(declaration);
               ROSE_ASSERT(moduleStatement != NULL);
               ROSE_ASSERT(moduleStatement->get_parent() != NULL);
               name += StringUtility::numberToString(const_cast<SgModuleStatement*>(moduleStatement));
               break;
             }

       // DQ (12/27/2007): Added case for SgUseStatement
          case V_SgUseStatement:
             {
               name = "_fortran_use_stmt_";
               const SgUseStatement* useStatement = isSgUseStatement(declaration);
               ROSE_ASSERT(useStatement != NULL);
               ROSE_ASSERT(useStatement->get_parent() != NULL);
               name += StringUtility::numberToString(const_cast<SgUseStatement*>(useStatement));
               break;
             }

       // DQ (12/28/2007): Added case for SgContainsStatement
          case V_SgContainsStatement:
             {
               name = "_fortran_contains_stmt_";
               const SgContainsStatement* containsStatement = isSgContainsStatement(declaration);
               ROSE_ASSERT(containsStatement != NULL);
               ROSE_ASSERT(containsStatement->get_parent() != NULL);
               name += StringUtility::numberToString(const_cast<SgContainsStatement*>(containsStatement));
               break;
             }

       // DQ (1/20/2008): Added case for SgEntryStatement
          case V_SgEntryStatement:
             {
               name = "_fortran_entry_stmt_";
               const SgEntryStatement* entryStatement = isSgEntryStatement(declaration);
               ROSE_ASSERT(entryStatement != NULL);
               ROSE_ASSERT(entryStatement->get_parent() != NULL);
               name += StringUtility::numberToString(const_cast<SgEntryStatement*>(entryStatement));
               break;
             }

       // DQ (1/23/2008): Added case for SgAttributeSpecificationStatement
          case V_SgAttributeSpecificationStatement:
             {
               name = "_fortran_attribute_specification_stmt_";
               const SgAttributeSpecificationStatement* statement = isSgAttributeSpecificationStatement(declaration);
               ROSE_ASSERT(statement != NULL);
               ROSE_ASSERT(statement->get_parent() != NULL);
               name += StringUtility::numberToString(const_cast<SgAttributeSpecificationStatement*>(statement));
               break;
             }

           case V_SgInterfaceStatement:
             {
               name = "_fortran_interface_stmt_";
               const SgInterfaceStatement* statement = isSgInterfaceStatement(declaration);
               ROSE_ASSERT(statement != NULL);
               ROSE_ASSERT(statement->get_parent() != NULL);
               name += StringUtility::numberToString(const_cast<SgInterfaceStatement*>(statement));
               break;
             }

           case V_SgFortranIncludeLine:
             {
               name = "_fortran_include_line_stmt_";
               const SgFortranIncludeLine* statement = isSgFortranIncludeLine(declaration);
               ROSE_ASSERT(statement != NULL);
               ROSE_ASSERT(statement->get_parent() != NULL);
               name += StringUtility::numberToString(const_cast<SgFortranIncludeLine*>(statement));
               break;
             }

       // Note that the case for SgVariableDeclaration is not implemented
          default:
            // name = "default name (default case reached: not handled)";
               printf ("Warning: default case reached in SageInterface::get_name ( const SgDeclarationStatement* declaration ), declaration = %p = %s \n",
                    declaration,declaration->class_name().c_str());
               ROSE_ASSERT(false);

               name = "default_name_case_reached_not_handled";
               break;
        }

     return name;
   }

string
SageInterface::get_name ( const SgScopeStatement* scope )
   {
     string name = "undefined_name";

     ROSE_ASSERT(scope != NULL);

     switch (scope->variantT())
        {
          case V_SgClassDefinition:
          case V_SgTemplateInstantiationDefn:
               name = get_name(isSgClassDefinition(scope)->get_declaration());
               break;

          case V_SgFunctionDefinition:
               name = get_name(isSgFunctionDefinition(scope)->get_declaration());
               break;

          case V_SgNamespaceDefinitionStatement:
               name = get_name(isSgNamespaceDefinitionStatement(scope)->get_namespaceDeclaration());
               break;

       // DQ (11/30/2007): Added more fortran suport.
          case V_SgAssociateStatement:

          case V_SgBasicBlock:
          case V_SgCatchOptionStmt:
          case V_SgDoWhileStmt:
          case V_SgForStatement:
          case V_SgGlobal:
          case V_SgIfStmt:
          case V_SgSwitchStatement:
          case V_SgWhileStmt:
          case V_SgFortranDo:
          case V_SgForAllStatement:
               name = StringUtility::numberToString(const_cast<SgScopeStatement*>(scope));
               break;

          default:
               printf ("Error: undefined scope in SageInterface::get_name(): node = %s \n",scope->class_name().c_str());
               ROSE_ASSERT(false);
               break;
        }

     return name;
   }

string
SageInterface::get_name ( const SgStatement* stmt )
   {
     string name = "undefined_name";

     ROSE_ASSERT(stmt != NULL);

     const SgDeclarationStatement* declaration = isSgDeclarationStatement(stmt);
     if (declaration != NULL)
        {
          name = get_name(declaration);
        }
       else
        {
          const SgScopeStatement* scope = isSgScopeStatement(stmt);
          if (scope != NULL)
             {
               name = get_name(scope);
             }
            else
             {
#if 0
            // DQ (9/5/2005): I think this is good enough for the more general case
               name = stmt->class_name();
#else
            // DQ (10/25/2007): This is better since it names the SgLabelStatement case
               switch (stmt->variantT())
                  {
#if 0
                    case V_SgBreakStmt:
                    case V_SgCaseOptionStmt:
                    case V_SgCatchStatementSeq:
                    case V_SgClinkageStartStatement:
                    case V_SgContinueStmt:
                    case V_SgDefaultOptionStmt:
                    case V_SgExprStmt:
                    case V_SgForInitStmt:
                    case V_SgFunctionTypeTable:
                    case V_SgGotoStatement:
                    case V_SgReturnStmt:
                    case V_SgSpawnStmt:
                    case V_SgTryStmt:
                         name = stmt->class_name();
                         break;
#endif
                    case V_SgLabelStatement:
                       {
                         const SgLabelStatement* labelStatement = isSgLabelStatement(stmt);
                         name = labelStatement->get_label().str();
                         break;
                       }

                    default:
                       {
                      // printf ("Default reached in switch \n");
                      // name = "default name";
                         name = stmt->class_name();
                         break;
                       }
                  }
#endif
             }
        }

     return name;
   }

string
SageInterface::get_name ( const SgSupport* node )
   {
  // This function is useful for debugging
  // This is the most general case of a function to return a name for an IR node.
     ROSE_ASSERT(node != NULL);

     string name = "undefined_name";

     ROSE_ASSERT(node != NULL);

     switch (node->variantT())
        {
          case V_SgInitializedName:
             {
               const SgInitializedName* initializedName = isSgInitializedName(node);
               if (initializedName != NULL)
                  {
                    name = initializedName->get_name().str();
                  }
               break;
             }
#if 1
       // DQ (3/17/2006): Implemented case for pragma declaration (forgot this case)
          case V_SgPragma:
             {
               name = "_pragma_string_";
               const SgPragma* pragma = isSgPragma(node);
               ROSE_ASSERT(pragma != NULL);
               name += pragma->get_pragma();
               break;
             }
#endif

       // DQ (5/31/2007): Implemented case for SgProject
          case V_SgProject:
             {
               name = "_project_";
               break;
             }

       // DQ (5/31/2007): Implemented case for SgFile
       // case V_SgFile:
          case V_SgSourceFile:
          case V_SgBinaryComposite:
             {
               name = "_file_";

            // DQ (3/1/2009): Added support to include the file name.
               const SgFile* file = isSgFile(node);
               ROSE_ASSERT(file != NULL);

               name += file->getFileName();
               break;
             }

       // DQ (5/31/2007): Implemented case for SgSymbolTable
          case V_SgSymbolTable:
             {
               name = "_symbol_table_";
               break;
             }

       // DQ (5/31/2007): Implemented case for SgStorageModifier
          case V_SgStorageModifier:
             {
               name = "_storage_modifier_";
               break;
             }


       // DQ (5/31/2007): Implemented case for Sg_File_Info
          case V_Sg_File_Info:
             {
               name = "_file_info_";
               break;
             }

       // DQ (8/7/2007): Implemented case for SgTemplateArgument
          case V_SgTemplateArgument:
             {
               name = "_template_argument_";
               const SgTemplateArgument* templateArgument = isSgTemplateArgument(node);
               ROSE_ASSERT(templateArgument != NULL);
               switch(templateArgument->get_argumentType())
                  {
                    case SgTemplateArgument::type_argument:
                       {
                         SgType* t = templateArgument->get_type();
                         ROSE_ASSERT(t != NULL);
                         name += get_name(t);
                         break;
                       }

                    case SgTemplateArgument::nontype_argument:
                       {
                         SgExpression* t = templateArgument->get_expression();
                         ROSE_ASSERT(t != NULL);
                         name += get_name(t);
                         break;
                       }

                    case SgTemplateArgument::template_template_argument:
                       {
                         SgTemplateDeclaration* t = templateArgument->get_templateDeclaration();
                         ROSE_ASSERT(t != NULL);
                         name += get_name(t);
                         break;
                       }

                    default:
                       {
                         printf ("Error: default case reached in switch on templateArgument->get_argumentType() \n");
                         ROSE_ASSERT(false);
                       }
                  }
               break;
             }


       // DQ (8/7/2007): Implemented case for SgTemplateArgument
          case V_SgTypeModifier:
             {
               const SgTypeModifier* typeModifier = isSgTypeModifier(node);
               ROSE_ASSERT(typeModifier != NULL);
               name = "_type_modifier_" + typeModifier->displayString();
               break;
             }

       // DQ (11/19/2007): Implemented case for SgNameGroup
          case V_SgNameGroup:
             {
               const SgNameGroup* nameGroup = isSgNameGroup(node);
               ROSE_ASSERT(nameGroup != NULL);
               name = "_name_group_" + nameGroup->get_group_name();
               break;
             }

       // DQ (11/20/2007): Implemented case for Fortran data statement support
          case V_SgDataStatementGroup:
             {
               const SgDataStatementGroup* dataGroup = isSgDataStatementGroup(node);
               ROSE_ASSERT(dataGroup != NULL);
               name = "_data_statement_group_";
               break;
             }

       // DQ (11/20/2007): Implemented case for Fortran data statement support
          case V_SgDataStatementObject:
             {
               const SgDataStatementObject* dataObject = isSgDataStatementObject(node);
               ROSE_ASSERT(dataObject != NULL);
               name = "_data_statement_object_";
               break;
             }

       // DQ (11/20/2007): Implemented case for Fortran data statement support
          case V_SgDataStatementValue:
             {
               const SgDataStatementValue* dataValue = isSgDataStatementValue(node);
               ROSE_ASSERT(dataValue != NULL);
               name = "_data_statement_value_";
               break;
             }

       // DQ (11/19/2007): Implemented case for SgCommonBlock
          case V_SgCommonBlockObject:
             {
               const SgCommonBlockObject* commonBlockObject = isSgCommonBlockObject(node);
               ROSE_ASSERT(commonBlockObject != NULL);
               name = "_common_block_object_" + commonBlockObject->get_block_name();
               break;
             }

       // DQ (12/23/2007): Added support for repeat_specification
          case V_SgFormatItem:
             {
               const SgFormatItem* formatItem = isSgFormatItem(node);
               ROSE_ASSERT(formatItem != NULL);
               name = "_format_item_";
               break;
             }

       // DQ (12/23/2007): Added support for repeat_specification
          case V_SgFormatItemList:
             {
               const SgFormatItemList* formatItemList = isSgFormatItemList(node);
               ROSE_ASSERT(formatItemList != NULL);
               name = "_format_item_list_";
               break;
             }

       // DQ (12/23/2007): Added support for repeat_specification
          case V_SgRenamePair:
             {
               const SgRenamePair* renamePair = isSgRenamePair(node);
               ROSE_ASSERT(renamePair != NULL);
               name = renamePair->get_local_name() + "__" + renamePair->get_use_name() + "_rename_pair_";
               break;
             }

       // DQ (12/2/2010): Implemented case for SgName
          case V_SgName:
             {
               const SgName* name_node = isSgName(node);
               ROSE_ASSERT(name_node != NULL);
               name = "_name_" + name_node->getString();
               break;
             }

          default:
             {
               printf ("Default reached in switch for SgSupport IR node = %s \n",node->class_name().c_str());
               name = "default name";
            // ROSE_ASSERT(false);
               break;
             }
        }

     return name;
   }


string
SageInterface::get_name ( const SgSymbol* symbol )
   {
  // This function is useful for debugging
  // This is the most general case of a function to return a name for an IR node.
     ROSE_ASSERT(symbol != NULL);

     string aliasSymbolPrefix = "";
     if (isSgAliasSymbol(symbol) != NULL)
        {
          aliasSymbolPrefix = "_ALIAS";
        }

  // printf ("In SageInterface::get_name(): symbol->get_symbol_basis() = %p = %s \n",symbol->get_symbol_basis(),symbol->get_symbol_basis()->class_name().c_str());
  // printf ("In SageInterface::get_name(): symbol->get_declaration() = %p = %s \n",symbol->get_declaration(),symbol->get_declaration()->class_name().c_str());

  // This is a call to the "get_name()" virtual function
     return symbol->get_name() + aliasSymbolPrefix + "_symbol_";
   }

string
SageInterface::get_name ( const SgType* type )
   {
  // This function is useful for debugging
  // This is the most general case of a function to return a name for an IR node.
     ROSE_ASSERT(type != NULL);

     string returnName;

     const SgNamedType* namedType = isSgNamedType(type);
     if (namedType != NULL)
        {
          returnName = "named_type_";
          returnName = namedType->get_name().getString();
        }
       else
        {
          switch(type->variantT())
             {
               case V_SgPointerType:
                  {
                    const SgPointerType* pointerType = isSgPointerType(type);
                    returnName = "pointer_to_";
                    returnName += get_name(pointerType->get_base_type());
                    break;
                  }

               case V_SgReferenceType:
                  {
                    const SgReferenceType* referenceType = isSgReferenceType(type);
                    returnName = "reference_to_";
                    returnName += get_name(referenceType->get_base_type());
                    break;
                  }

               case V_SgArrayType:
                  {
                    const SgArrayType* arrayType = isSgArrayType(type);
                    returnName = "array_of_";
                    returnName += get_name(arrayType->get_base_type());
                    break;
                  }

               case V_SgModifierType:
                  {
                    const SgModifierType* modifierType = isSgModifierType(type);
                    returnName = get_name(&(modifierType->get_typeModifier()));
                    returnName += get_name(modifierType->get_base_type());
                    break;
                  }

               default:
                  {
                    returnName = type->class_name();
                  }
             }
        }

     return returnName;
   }

string
SageInterface::get_name ( const SgExpression* expr )
   {
     string name = "undefined_name";

  // ROSE_ASSERT(expr != NULL);
     switch(expr->variantT())
        {
          case V_SgVarRefExp:
             {
               const SgVarRefExp* varRef = isSgVarRefExp(expr);
               name = "var_ref_of_";
               ROSE_ASSERT(varRef != NULL);
               ROSE_ASSERT(varRef->get_symbol() != NULL);
               name += varRef->get_symbol()->get_name();
               break;
             }

          case V_SgPntrArrRefExp:
             {
               const SgPntrArrRefExp* arrayRef = isSgPntrArrRefExp(expr);
               name = "array_ref_of_";
               name += get_name(arrayRef->get_lhs_operand());
               name += "_at_";
               name += get_name(arrayRef->get_rhs_operand());
               break;
             }

          case V_SgFunctionCallExp:
             {
               const SgFunctionCallExp* functionCall = isSgFunctionCallExp(expr);
               name = "function_call_";
               name += get_name(functionCall->get_function());
               break;
             }

          case V_SgFunctionRefExp:
             {
               const SgFunctionRefExp* functionRefExp = isSgFunctionRefExp(expr);
               name = "function_ref_";
               name += functionRefExp->get_symbol()->get_name();
               break;
             }

          case V_SgIntVal:
             {
               const SgIntVal* valueExp = isSgIntVal(expr);
               name = "integer_value_exp_";
               name += StringUtility::numberToString(valueExp->get_value());
               break;
             }

          case V_SgStringVal:
             {
               const SgStringVal* valueExp = isSgStringVal(expr);
               name = "string_value_exp_";
               name += valueExp->get_value();
               break;
             }

          case V_SgSubscriptExpression:
             {
               const SgSubscriptExpression* subscriptExpression = isSgSubscriptExpression(expr);
               name = "subscript_exp_";
            // name += StringUtility::numberToString(subscriptExpression->get_lowerBound());
               name += get_name(subscriptExpression->get_lowerBound());
               name += "_";
            // name += StringUtility::numberToString(subscriptExpression->get_upperBound());
               name += get_name(subscriptExpression->get_upperBound());
               name += "_";
            // name += StringUtility::numberToString(subscriptExpression->get_stride());
               name += get_name(subscriptExpression->get_stride());
               break;
             }

          case V_SgNullExpression:
             {
               name = "null_expression";
               break;
             }

       // DQ (1/17/2011): Added support for SgExprListExp (to support debugging).
          case V_SgExprListExp:
             {
               const SgExprListExp* exprListExp = isSgExprListExp(expr);
               name = "expr_list_exp_";
               for (size_t i = 0; i < exprListExp->get_expressions().size(); i++)
                  {
                    name += get_name(exprListExp->get_expressions()[i]);
                  }
               break;
             }

          default:
             {
            // Nothing to do for other IR nodes

            // DQ (4/8/2010): define something specific to this function to make debugging more clear.
               name = "undefined_expression_name";
               break;
             }
        }

     return name;
   }

string
SageInterface::get_name ( const SgLocatedNodeSupport* node )
   {
  // This function is useful for debugging
  // This is the most general case of a function to return a name for an IR node.
     ROSE_ASSERT(node != NULL);

     string returnName;

     switch(node->variantT())
        {
          case V_SgRenamePair:
             {
               const SgRenamePair* n = isSgRenamePair(node);
               returnName = "rename_pair_";
               returnName += n->get_local_name().str();
               returnName += "_from_";
               returnName += n->get_use_name().str();
               break;
             }
          case V_SgInitializedName:
          {
            const SgInitializedName * n = isSgInitializedName (node);
            ROSE_ASSERT (n != NULL);
            returnName = "initialized_name_";
            returnName += n->get_name().str();

            break;
          }
#if 0
          case V_SgInterfaceBody:
             {
               const SgInterfaceBody* n = isSgInterfaceBody(node);
               returnName = "interface_body";
               break;
             }
#endif
          default:
             {
               returnName = node->class_name();
             }
        }

     return returnName;
   }

string
SageInterface::get_name ( const SgNode* node )
   {
  // This function is useful for debugging
  // This is the most general case of a function to return a name for an IR node.
  // Later this function will handle expressions, etc.

     string name = "undefined_name";

     ROSE_ASSERT(node != NULL);

     const SgLocatedNode* locatedNode = isSgLocatedNode(node);
     if (locatedNode != NULL)
        {
          const SgStatement* statement = isSgStatement(node);
          if (statement != NULL)
             {
               name = get_name(statement);
             }
            else
             {
               const SgExpression* expression = isSgExpression(node);
               if (expression != NULL)
                  {
                    name = get_name(expression);
                  }
                 else
                  {
                    const SgLocatedNodeSupport* locatedNodeSupport = isSgLocatedNodeSupport(node);
                    if (locatedNodeSupport != NULL)
                       {
                         name = get_name(locatedNodeSupport);
                       }
                      else
                       {
                         const SgToken* token = isSgToken(node);
                         if (token != NULL)
                            {
                              name = get_name(token);
                            }
                           else
                            {
                              printf ("Unknown SgLocatedNode = %p = %s \n",node,node->class_name().c_str());
                              ROSE_ASSERT(false);
                            }
                       }
                  }
             }
        }
       else
        {
          const SgSupport* supportNode = isSgSupport(node);
          if (supportNode != NULL)
             {
               name = get_name(supportNode);
             }
            else
             {
            // DQ (9/21/2005): I think this is good enough for the more general case (for now)
               const SgSymbol* symbol = isSgSymbol(node);
               if (symbol != NULL)
                  {
                    name = get_name(symbol);
                  }
                 else
                  {
                 // DQ (8/7/2007): Added support to get names of types (usefult for SgNamedType objects).
                    const SgType* type = isSgType(node);
                    if (type != NULL)
                       {
                         name = get_name(type);
                       }
                      else
                       {
                         name = node->class_name();
                       }
                  }
             }
        }

     return name;
   }


string
SageInterface::get_name ( const SgToken* token )
   {
  // This function is useful for debugging
     string name = "undefined_name";

     ROSE_ASSERT(token != NULL);
     name = token->get_lexeme_string();

  // Handle special cases
     if (name == " ")
        name = "<space>";
     else if (name == "\n")
        name = "<eol>";
     else if (name == "\t")
        name = "<tab>";

     return name;
   }


SgMemberFunctionDeclaration*
SageInterface::getDefaultConstructor( SgClassDeclaration* classDeclaration )
   {
     SgMemberFunctionDeclaration* defaultConstructor = NULL;

     ROSE_ASSERT(classDeclaration != NULL);
     SgDeclarationStatement* definingDeclaration = classDeclaration->get_definingDeclaration();
     ROSE_ASSERT(definingDeclaration != NULL);
     SgClassDeclaration* definingClassDeclaration = isSgClassDeclaration(definingDeclaration);

  // Note that not all class declarations have to have a defining declaration (e.g. "~int()"
  // would be associated with a class declaration but no definition would exist).
     if (definingClassDeclaration != NULL)
        {
          SgClassDefinition* classDefinition = definingClassDeclaration->get_definition();
          ROSE_ASSERT(classDefinition != NULL);

          SgDeclarationStatementPtrList::iterator i = classDefinition->get_members().begin();
          while ( i != classDefinition->get_members().end() )
             {
            // Check the parent pointer to make sure it is properly set
               ROSE_ASSERT( (*i)->get_parent() != NULL);
               ROSE_ASSERT( (*i)->get_parent() == classDefinition);

               SgMemberFunctionDeclaration* memberFunction = isSgMemberFunctionDeclaration(*i);
               if (memberFunction != NULL)
                  {
                 // printf ("memberFunction = %p = %s \n",memberFunction,memberFunction->get_name().str());
                    if ( memberFunction->get_specialFunctionModifier().isConstructor() == true )
                       defaultConstructor = memberFunction;
                  }

            // iterate through the class members
               i++;
             }
        }

  // This should be true for the specific case that we are currently debugging!
  // ROSE_ASSERT(defaultConstructor != NULL);

     return defaultConstructor;
   }

SgMemberFunctionDeclaration*
SageInterface::getDefaultDestructor( SgClassDeclaration* classDeclaration )
   {
     SgMemberFunctionDeclaration* defaultDestructor = NULL;

     ROSE_ASSERT(classDeclaration != NULL);
     SgDeclarationStatement* definingDeclaration = classDeclaration->get_definingDeclaration();
     if (definingDeclaration != NULL)
        {
          ROSE_ASSERT(definingDeclaration != NULL);
          SgClassDeclaration* definingClassDeclaration = isSgClassDeclaration(definingDeclaration);

       // Note that not all class declarations have to have a defining declaration (e.g. "~int()"
       // would be associated with a class declaration but no definition would exist).
          if (definingClassDeclaration != NULL)
             {
               SgClassDefinition* classDefinition = definingClassDeclaration->get_definition();
               ROSE_ASSERT(classDefinition != NULL);

               SgDeclarationStatementPtrList::iterator i = classDefinition->get_members().begin();
               while ( i != classDefinition->get_members().end() )
                  {
                 // Check the parent pointer to make sure it is properly set
                    ROSE_ASSERT( (*i)->get_parent() != NULL);

                 // DQ (11/1/2005): Note that a template instantiation can have a parent which is the
                 // variable which forced it's instantiation.  Since it does not really exist in the
                 // source code explicitly (it is compiler generated) this is as reasonable as anything else.
                 // if ( (*i)->get_parent() != classDefinition && isSgVariableDeclaration((*i)->get_parent()) == NULL)
                    if ( (*i)->get_parent() != classDefinition )
                       {
                         printf ("Error: (*i)->get_parent() = %p = %s \n",(*i)->get_parent(),(*i)->get_parent()->class_name().c_str());
                         printf ("(*i) = %p = %s = %s \n",*i,(*i)->class_name().c_str(),(*i)->unparseToString().c_str());
                         (*i)->get_file_info()->display("Called from SageInterface::getDefaultDestructor: debug");
                       }
                    ROSE_ASSERT( (*i)->get_parent() == classDefinition);
                 // ROSE_ASSERT( (*i)->get_parent() == classDefinition || isSgVariableDeclaration((*i)->get_parent()) != NULL);

                    SgMemberFunctionDeclaration* memberFunction = isSgMemberFunctionDeclaration(*i);
                    if (memberFunction != NULL)
                       {
                      // printf ("memberFunction = %p = %s \n",memberFunction,memberFunction->get_name().str());
                         if ( memberFunction->get_specialFunctionModifier().isDestructor() == true )
                            defaultDestructor = memberFunction;
                       }

                 // iterate through the class members
                    i++;
                  }
             }
        }

  // This should be true for the specific case that we are currently debugging!
  // ROSE_ASSERT(defaultDestructor != NULL);

     return defaultDestructor;
   }


void
SageInterface::outputGlobalFunctionTypeSymbolTable()
   {
  // DQ (6/27/2005): This function outputs the global table of function type symbols
  // it is built during the EDG/Sage translation phase, and it built initially with
  // the EDG names of all instantiated templates.  At a later phase (incomplete at
  // the moment) the AST fixup rebuilds the table to use the modified template names
  // (that is mangled names built from the modified template names used in Sage III).

  // DQ (1/31/2006): Modified to build all types in the memory pools
  // extern SgFunctionTypeTable Sgfunc_type_table;
  // Sgfunc_type_table.print_functypetable();
     ROSE_ASSERT(SgNode::get_globalFunctionTypeTable() != NULL);
     SgNode::get_globalFunctionTypeTable()->print_functypetable();
   }

void
SageInterface::outputLocalSymbolTables ( SgNode* node )
   {
  // This simplifies how the traversal is called!
     OutputLocalSymbolTables astTraversal;

  // I think the default should be preorder so that the interfaces would be more uniform
     astTraversal.traverse(node,preorder);
   }

void
SageInterface::OutputLocalSymbolTables::visit ( SgNode* node )
   {
  // DQ (6/27/2005): Output the local symbol table from each scope.
  // printf ("node = %s \n",node->sage_class_name());

     SgScopeStatement* scope = isSgScopeStatement(node);
     if (scope != NULL)
        {
          SgSymbolTable* symbolTable = scope->get_symbol_table();
          ROSE_ASSERT(symbolTable != NULL);

          printf ("Symbol Table from %p = %s at: \n",scope,scope->sage_class_name());
          scope->get_file_info()->display("Symbol Table Location (Called from SageInterface::OutputLocalSymbolTables::visit())");
          symbolTable->print("Called from SageInterface::OutputLocalSymbolTables::visit()");
        }
   }

#if 0
// DQ (8/28/2005): This is already a member function of the SgFunctionDeclaration
// (so that it can handle template functions and member functions)

// DQ (8/27/2005):
bool
SageInterface::isTemplateMemberFunction( SgTemplateInstantiationMemberFunctionDecl* memberFunctionDeclaration )
   {
  // This function determines if the member function is associated with a template
  // or just a template class (where it is a normal non-template member function).

     bool result = false;

     result = memberFunctionDeclaration->isTemplateFunction();

     return result;
   }
#endif

// DQ (8/27/2005):
bool
SageInterface::templateDefinitionIsInClass( SgTemplateInstantiationMemberFunctionDecl* memberFunctionDeclaration )
   {
  // This function determines if the template declaration associated withthis member function instantiation is
  // defined in the class or outside of the class.

     bool result = false;

#if 0
  // Check if this is a template or non-template member function
     if (isTemplateMemberFunction(memberFunctionDeclaration) == true)
        {
          SgTemplateDeclaration* templateDeclaration = memberFunctionDeclaration->get_templateDeclaration();
          printf ("templateDeclaration = %p parent of templateDeclaration = %p \n",templateDeclaration,templateDeclaration->get_parent());

       // SgTemplateInstantiationDecl* classTemplateInstantiation = memberFunctionDeclaration->get_class_scope()->get_declaration();
          SgClassDeclaration* classDeclaration = memberFunctionDeclaration->get_class_scope()->get_declaration();
          ROSE_ASSERT(classDeclaration != NULL);
          SgTemplateInstantiationDecl* classTemplateInstantiation = isSgTemplateInstantiationDecl(classDeclaration);

          if (classTemplateInstantiation != NULL)
             {
               SgTemplateDeclaration* classTemplateDeclaration = classTemplateInstantiation->get_templateDeclaration();
               if (classTemplateDeclaration != NULL && classTemplateDeclaration != templateDeclaration)
                  {
                    result = true;
                  }
             }
        }
#endif

  // Alternative approach
     SgTemplateDeclaration* templateDeclaration = memberFunctionDeclaration->get_templateDeclaration();
     printf ("In templateDefinitionIsInClass(): templateDeclaration = %p parent of templateDeclaration = %p = %s \n",templateDeclaration,
          templateDeclaration->get_parent(),templateDeclaration->get_parent()->class_name().c_str());

     SgScopeStatement* parentScope = isSgScopeStatement(templateDeclaration->get_parent());
     if (isSgClassDefinition(parentScope) != NULL)
        {
          result = true;
        }

     return result;
   }

SgDeclarationStatement*
generateUniqueDeclaration ( SgDeclarationStatement* declaration )
   {
  // DQ (10/11/2007): This is no longer used.
     printf ("Error: This is no longer used. \n");
     ROSE_ASSERT(false);

  // Get the defining or first non-defining declaration so that we can use it as a key to know
  // when we have found the same function. So we don't count a redundant forward declaration
  // found outside of the class as matching the first non-defining declaration or the defining
  // declaration in the class by mistake. All declarations share the same firstNondefining
  // declaration and defining declaration so either could be a key declaration, but there are
  // times when either one of then (but not both) can be NULL (function defined withouth forward
  // declaration or not defined at all).
     SgDeclarationStatement* firstNondefiningDeclaration = declaration->get_firstNondefiningDeclaration();
     SgDeclarationStatement* definingDeclaration         = declaration->get_definingDeclaration();
     SgDeclarationStatement* keyDeclaration = NULL;
     if (firstNondefiningDeclaration != NULL)
          keyDeclaration = firstNondefiningDeclaration;
       else
          keyDeclaration = definingDeclaration;
     ROSE_ASSERT(keyDeclaration != NULL);

     return keyDeclaration;
   }

//! Check if a node is SgOmp*Statement
bool SageInterface::isOmpStatement(SgNode* n)
{
  ROSE_ASSERT (n != NULL);
  bool result = false;
  if (isSgOmpBarrierStatement(n)||isSgOmpBodyStatement(n)|| isSgOmpFlushStatement(n)|| isSgOmpTaskwaitStatement(n) )
    result = true;

  return result;

}
// DQ (8/28/2005):
bool
SageInterface::isOverloaded ( SgFunctionDeclaration* functionDeclaration )
   {
  // This function looks for any other function that might overload the input function.
  // for member functions we only look in the scope where the member function is defined.
  // for non-member functions we look only in the scope where the function is declared.

  // Note that there are scenarios where this approach of searching only these locations
  // might not catch an overloaded function.
  //     * member functions:
  //         - overloaded functions might be declared in base classes
  //     * non-member functions:
  //         - function declarations might be friend functions in classes
  //         - functions might be declared in differen namespace definitions
  //              (SgNamespaceDefinitionStatement), since a namespace in re-entrant
  //              and can have many namespace declarations and definitions.

  // bool result = false;
     int counter = 0;

     SgMemberFunctionDeclaration* memberFunctionDeclaration = isSgMemberFunctionDeclaration(functionDeclaration);
     if (memberFunctionDeclaration != NULL)
        {
       // This is a member function declaration

       // DQ (10/11/2007): Fix this to NOT use the generateUniqueDeclaration() function.
       // Generate a key to use for comparision (avoids false positives)
       // SgMemberFunctionDeclaration* keyDeclaration = isSgMemberFunctionDeclaration(generateUniqueDeclaration(functionDeclaration));
       // ROSE_ASSERT(keyDeclaration != NULL);

       // Get the class definition
          SgClassDefinition* classDefinition =
               isSgClassDefinition(memberFunctionDeclaration->get_scope());
          ROSE_ASSERT(classDefinition != NULL);

       // Get the class declaration associated with the class definition
          SgClassDeclaration* classDeclaration = isSgClassDeclaration(classDefinition->get_declaration());
          ROSE_ASSERT(classDeclaration != NULL);

       // Get the list of member declarations in the class
          SgDeclarationStatementPtrList & memberList = classDefinition->get_members();
#if 0
       // DQ (10/11/2007): Fix this function better by checking for more than one member function declaration in the class definition.
          printf ("   memberList.size() = %zu \n",memberList.size());
#endif
          for (SgDeclarationStatementPtrList::iterator i = memberList.begin(); i != memberList.end(); i++)
             {
#if 0
               printf ("   counter = %d declaration = %p = %s \n",counter,*i,(*i)->class_name().c_str());
#endif
               SgMemberFunctionDeclaration* tempMemberFunction = isSgMemberFunctionDeclaration(*i);
               SgTemplateDeclaration* tempTemplateDeclaration  = isSgTemplateDeclaration(*i);

            // Member functions could be overloaded
               if (tempMemberFunction != NULL)
                  {
#if 0
                 // DQ (10/11/2007): This is a problem for where s member function prototype from outside the class is checked to be an ovverloaded function.
                 // Check using the key declaration
                    if ( keyDeclaration == generateUniqueDeclaration(tempMemberFunction) )
                       {
#if 0
                         printf ("Skipping the case of keyDeclaration == generateUniqueDeclaration(tempMemberFunction) = %p \n",keyDeclaration);
#endif
                         continue;
                       }
#endif
                    ROSE_ASSERT(tempMemberFunction->get_name() != "");
#if 0
                    printf ("      tempMemberFunction = (name) %s = (qualified) %s \n",
                              tempMemberFunction->get_name().str(),
                              tempMemberFunction->get_qualified_name().str());
#endif
                    if (tempMemberFunction->get_name() == memberFunctionDeclaration->get_name())
                       {
#if 0
                         printf ("      Found a matching overloaded member function! \n");
#endif
                      // result = true;
                         counter++;
                       }
                  }
                 else
                  {
                 // Or templates could be overloaded, but nothing else.
                    if (tempTemplateDeclaration != NULL)
                       {
                      // If this is a template declaration, it could be a template
                      // declaration for an overloaded member function of the same name.
#if 0
                      // printf ("keyDeclaration->get_name() = %s \n",keyDeclaration->get_name().str());
                         printf ("tempTemplateDeclaration->get_name() = %s \n",tempTemplateDeclaration->get_name().str());
#endif
                      // if (keyDeclaration->get_name() == tempTemplateDeclaration->get_name())
                         if (memberFunctionDeclaration->get_name() == tempTemplateDeclaration->get_name())
                            {
#if 0
                              printf ("      Found a matching overloaded member function! \n");
#endif
                           // result = true;
                              counter++;
                            }
                       }
                      else
                       {
                       // DQ (10/12/2007): Could friend functions defined in a class be overloaded?  Need to check this!
                          if (functionDeclaration->variantT() == V_SgFunctionDeclaration)
                             {
                               printf ("In SageInterface::isOverloaded(): could friend functions be overloaded in a class? \n");
                             }
                       }
                  }

            // If we have detected two, so we have an overloaded function.
               if (counter > 1)
                    break;
             }
        }
       else
        {
       // This is a non-member function declaration
          printf ("In SageInterface::isOverloaded(): case of non-member function not yet implemented! \n");
          ROSE_ASSERT(false);
        }

  // DQ (10/11/2007): Fixup to use the counter and consider more than 1 function with the same name an overloaded member function.
  // This might be a problem for friend functions, so test this separately.
  // return result;
     return (counter > 1);
   }




SgTemplateInstantiationMemberFunctionDecl*
SageInterface::buildForwardFunctionDeclaration ( SgTemplateInstantiationMemberFunctionDecl* memberFunctionInstantiation )
   {
  // DQ (9/6/2005): This function builds a copy of the input function for the
  // construction of a forward declaration of the function. Required in the
  // instantiated functions definition is to be output as a specialization by ROSE.
  // Since the shallow copy mechanism will cause IR nodes to be shared, we have
  // to fix it up with deep copies of the parameter list and the CtorInitializerList.

     ROSE_ASSERT(memberFunctionInstantiation != NULL);

#if 0
    printf ("buildForwardFunctionDeclaration: Member function = %p = %s = definition = %p \n",
          memberFunctionInstantiation,
          memberFunctionInstantiation->get_name().str(),
          memberFunctionInstantiation->get_definition());
    memberFunctionInstantiation->get_file_info()->display("memberFunctionInstantiation: debug");
#endif

  // This is a better implementation using a derived class from SgCopyHelp to control the
  // copying process (skipping the copy of any function definition).  This is a variable
  // declaration with an explicitly declared class type.
     class NondefiningFunctionDeclarationCopyType : public SgCopyHelp
        {
       // DQ (9/26/2005): This class demonstrates the use of the copy mechanism
       // within Sage III (originally designed and implemented by Qing Yi).
       // One problem with it is that there is no context information permitted.

          public:
               virtual SgNode *copyAst(const SgNode *n)
                  {
                 // If still NULL after switch then make the copy
                    SgNode* returnValue = NULL;

                    switch(n->variantT())
                       {
                      // DQ (10/21/2007): Now that s bug is fixed in the SgDeclarationStatement::fixupCopy()
                      // member function, I think we might not need this case.

                      // Don't copy the associated non-defining declaration when building a function prototype!
                         case V_SgFunctionDeclaration:
                         case V_SgMemberFunctionDeclaration:
                         case V_SgTemplateInstantiationFunctionDecl:
                         case V_SgTemplateInstantiationMemberFunctionDecl:
                            {
                           // printf ("Skip copying an associated non-defining declaration if it is present \n");
                              const SgFunctionDeclaration* functionDeclaration = isSgFunctionDeclaration(n);
                              ROSE_ASSERT(functionDeclaration != NULL);
                              if (functionDeclaration == functionDeclaration->get_definingDeclaration())
                                 {
                                // This is the defining declaration (make a shallow copy)
                                // printf ("In NondefiningFunctionDeclarationCopyType::copyAst(): This is the DEFINING declaration! \n");
                                // return const_cast<SgNode *>(n);
                                   returnValue = const_cast<SgNode *>(n);
                                 }
                                else
                                 {
                                // This is the non-defining declaration where we want to make a deep copy.
                                // printf ("In NondefiningFunctionDeclarationCopyType::copyAst(): This is the NONDEFINING declaration! \n");
                                 }

                              break;
                            }

                      // Don't copy the function definitions (roughly the body of the function)
                         case V_SgFunctionDefinition:
                            {
                              printf ("Skip copying the function definition if it is present \n");
                           // return const_cast<SgNode *>(n);
                              returnValue = const_cast<SgNode *>(n);
                              break;
                            }

                         default:
                            {
                           // Nothing to do here
                              break;
                            }
                       }

                 // return n->copy(*this);

                 // If not set at this point then make the copy!
                    if (returnValue == NULL)
                         returnValue = n->copy(*this);

                    ROSE_ASSERT(returnValue != NULL);
                    return returnValue;
                  }
        } nondefiningFunctionDeclarationCopy;

  // DQ (10/20/2007): The more accurate copy mechanism now builds us a defining declaration to go with the non-defining declaration!
  // This is because we have to remove the pointers from non-defining declaration to the definition (which should be pointed to ONLY by the defining declaration!
  // delete copyOfMemberFunction->get_definingDeclaration();
     if (memberFunctionInstantiation->get_definition() != NULL)
        {
          printf ("\n\nNEED TO REMOVE POINTERS IN THE NON-DEFINING DECLARATION TO THE SgClassDefinition objects. \n");
          ROSE_ASSERT(false);

       // If we see the assertion above fail then we might want to use this code:
          ROSE_ASSERT( memberFunctionInstantiation != memberFunctionInstantiation->get_definingDeclaration() );
          memberFunctionInstantiation->set_definition(NULL);
        }
     SgNode* copyOfMemberFunctionNode = memberFunctionInstantiation->copy(nondefiningFunctionDeclarationCopy);
     SgTemplateInstantiationMemberFunctionDecl* copyOfMemberFunction = static_cast<SgTemplateInstantiationMemberFunctionDecl*>(copyOfMemberFunctionNode);

  // printf ("\n\nHOW DO WE KNOW WHEN TO NOT COPY THE DEFINING DECLARATION SO THAT WE CAN JUST BUILD A FUNCTION PROTOTYPE! \n");
  // ROSE_ASSERT(false);

#if 0
     printf ("copyOfMemberFunction->get_firstNondefiningDeclaration() = %p \n",copyOfMemberFunction->get_firstNondefiningDeclaration());
#endif
  // DQ (10/11/2007): The copy function sets the firstNondefiningDeclaration to itself if in the original declaration it had the
  // firstNondefiningDeclaration set to itself, this is incorrect in the case where we only make a copy of function declaration,
  // and causes the symbol table tests for get_declaration_associated_with_symbol() to fail because it uses the
  // firstNondefiningDeclaration which is not the one associated with the symbol in the parent scope. So reset the
  // firstNondefiningDeclaration in the copy of the member function.
     copyOfMemberFunction->set_firstNondefiningDeclaration(memberFunctionInstantiation->get_firstNondefiningDeclaration());

#if 0
     printf ("memberFunctionInstantiation->get_firstNondefiningDeclaration() = %p \n",memberFunctionInstantiation->get_firstNondefiningDeclaration());

     printf ("copyOfMemberFunction->isForward()        = %s \n",copyOfMemberFunction->isForward() ? "true" : "false");
     printf ("memberFunctionInstantiation->isForward() = %s \n",memberFunctionInstantiation->isForward() ? "true" : "false");
#endif
#if 0
     printf ("memberFunctionInstantiation->isSpecialization()        = %s \n",memberFunctionInstantiation->isSpecialization() ? "true" : "false");
     printf ("copyOfMemberFunctionNode = %p = %s = %s memberFunctionInstantiation->isSpecialization() = %s \n",
          copyOfMemberFunction,copyOfMemberFunction->class_name().c_str(),SageInterface::get_name(copyOfMemberFunction).c_str(),copyOfMemberFunction->isSpecialization() ? "true" : "false");
     copyOfMemberFunction->get_file_info()->display("copyOfMemberFunction: debug");
#endif

  // Make sure that we have the same number of arguments on the copy that we build
     ROSE_ASSERT(memberFunctionInstantiation->get_args().size() == copyOfMemberFunction->get_args().size());

  // DQ (11/5/2007): Additional tests
     ROSE_ASSERT(memberFunctionInstantiation->get_startOfConstruct()->isOutputInCodeGeneration() == copyOfMemberFunction->get_startOfConstruct()->isOutputInCodeGeneration());
     ROSE_ASSERT(memberFunctionInstantiation->get_startOfConstruct()->isCompilerGenerated() == copyOfMemberFunction->get_startOfConstruct()->isCompilerGenerated());

     ROSE_ASSERT(copyOfMemberFunction != NULL);
     return copyOfMemberFunction;
   }


void
supportForBaseTypeDefiningDeclaration ( SgSymbolTable* symbolTable, SgDeclarationStatement* declarationForType )
   {
  // DQ (10/14/2007): Supporting function for

     ROSE_ASSERT(declarationForType != NULL);

  // DQ (11/7/2007): Added more cases...
     switch(declarationForType->variantT())
        {
          case V_SgClassDeclaration:
             {
               SgClassDeclaration* classDeclaration = isSgClassDeclaration(declarationForType);
               SgSymbol* symbol = new SgClassSymbol(classDeclaration);
               ROSE_ASSERT(symbol != NULL);
               SgName name = classDeclaration->get_name();
               symbolTable->insert(name,symbol);
               break;
             }

          case V_SgEnumDeclaration:
             {
               SgEnumDeclaration* enumDeclaration = isSgEnumDeclaration(declarationForType);
               SgSymbol* symbol = new SgEnumSymbol(enumDeclaration);
               ROSE_ASSERT(symbol != NULL);
               SgName name = enumDeclaration->get_name();
               symbolTable->insert(name,symbol);
               break;
             }

          case V_SgFunctionDeclaration:
             {
               SgFunctionDeclaration* functionDeclaration = isSgFunctionDeclaration(declarationForType);
               SgSymbol* symbol = new SgFunctionSymbol(functionDeclaration);
               ROSE_ASSERT(symbol != NULL);
               SgName name = functionDeclaration->get_name();
               symbolTable->insert(name,symbol);
               break;
             }

          case V_SgMemberFunctionDeclaration:
             {
               SgMemberFunctionDeclaration* functionDeclaration = isSgMemberFunctionDeclaration(declarationForType);
               SgSymbol* symbol = new SgMemberFunctionSymbol(functionDeclaration);
               ROSE_ASSERT(symbol != NULL);

            // printf ("In supportForBaseTypeDefiningDeclaration(): symbol = %p = %s = %s \n",symbol,symbol->class_name().c_str(),SageInterface::get_name(symbol).c_str());

               SgName name = functionDeclaration->get_name();
               symbolTable->insert(name,symbol);
               break;
             }

          default:
             {
               printf ("Default reached in evaluation of typedef inner definition = %p = %s and building a symbol for it for the symbol table \n",declarationForType,declarationForType->class_name().c_str());
               ROSE_ASSERT(false);
             }
        }
   }


void
supportForVariableLists ( SgScopeStatement* scope, SgSymbolTable* symbolTable, SgInitializedNamePtrList & variableList )
   {
  // DQ (11/1/2007): Added supporting function to refactor code.
     SgInitializedNamePtrList::iterator i = variableList.begin();
     while (i != variableList.end())
        {
          SgInitializedName* variable = *i;
          ROSE_ASSERT(variable != NULL);
          if (variable->get_scope() == scope)
             {
            // printf ("Scopes match, OK! \n");
             }
            else
             {
               printf ("WARNING: Scopes do NOT match! variable = %p = %s (could this be a static variable, or has the symbol table been setup before the scopes have been set?) \n",variable,variable->get_name().str());
             }

          SgSymbol* symbol = new SgVariableSymbol(variable);
          ROSE_ASSERT(symbol != NULL);
          SgName name = variable->get_name();
          symbolTable->insert(name,symbol);

          i++;
        }
   }

void
supportForVariableDeclarations ( SgScopeStatement* scope, SgSymbolTable* symbolTable, SgVariableDeclaration* variableDeclaration )
   {
  // DQ (10/24/2007): Added supporting function to refactor code.
     SgInitializedNamePtrList & variableList = variableDeclaration->get_variables();
#if 1
     supportForVariableLists(scope,symbolTable,variableList);
#else
     SgInitializedNamePtrList::iterator i = variableList.begin();
     while ( i != variableList.end() )
        {
          SgInitializedName* variable = *i;
          ROSE_ASSERT(variable != NULL);

       // DQ (10/20/2007): static data members declared outside the class scope don't generate symbols.
       // if (variable->get_prev_decl_item() != NULL)
          if (variable->get_scope() == scope)
             {
               SgSymbol* symbol = new SgVariableSymbol(variable);
               ROSE_ASSERT(symbol != NULL);

            // printf ("In SageInterface::rebuildSymbolTable() variable = %p building a new SgVariableSymbol = %p \n",variable,symbol);

               SgName name = variable->get_name();
               symbolTable->insert(name,symbol);
             }
            else
             {
            // I think there is nothing to do in this case
            // printf ("In SageInterface::rebuildSymbolTable() This variable has a scope inconsistant with the symbol table: variable->get_scope() = %p scope = %p \n",variable->get_scope(),scope);
             }

          i++;
        }
#endif

  // DQ (10/13/2007): Need to look into variable declarations to see if there are defining declaration
  // that also force symbols to be built in the current scope!
  // ROSE_ASSERT(derivedDeclaration->get_variableDeclarationContainsBaseTypeDefiningDeclaration() == false);
     if (variableDeclaration->get_variableDeclarationContainsBaseTypeDefiningDeclaration() == true)
        {
       // Build a SgClassDeclaration, SgEnumDeclaration associated symbol and add it to the symbol table.
          ROSE_ASSERT(symbolTable != NULL);
          ROSE_ASSERT(variableDeclaration->get_baseTypeDefiningDeclaration() != NULL);
          supportForBaseTypeDefiningDeclaration ( symbolTable, variableDeclaration->get_baseTypeDefiningDeclaration() );
        }
   }



void
supportForLabelStatements ( SgScopeStatement* scope, SgSymbolTable* symbolTable )
   {
  // Update the symbol table in SgFunctionDefinition with all the labels in the function.

     std::vector<SgNode*> labelList = NodeQuery::querySubTree (scope,V_SgLabelStatement);

     int numberOfLabels = labelList.size();
     for (int i=0; i < numberOfLabels; i++)
        {
          SgLabelStatement* labelStatement = isSgLabelStatement(labelList[i]);

          ROSE_ASSERT(labelStatement->get_scope() == scope);

          SgSymbol* symbol = new SgLabelSymbol(labelStatement);
          ROSE_ASSERT(symbol != NULL);

       // printf ("In SageInterface::rebuildSymbolTable() labelStatement = %p building a new SgLabelSymbol = %p \n",labelStatement,symbol);

          SgName name = labelStatement->get_name();
          symbolTable->insert(name,symbol);
        }
   }


void
SageInterface::rebuildSymbolTable ( SgScopeStatement* scope )
   {
  // This function is called from the implementation of the copy member functions.

     ROSE_ASSERT(scope != NULL);

  // printf ("In SageInterface::rebuildSymbolTable(): Symbol Table from %p = %s \n",scope,scope->class_name().c_str());

#if 0
     printf ("Exiting as a test \n");
     ROSE_ASSERT(false);
#endif

     SgSymbolTable* symbolTable = scope->get_symbol_table();

     if (symbolTable != NULL)
        {
       // This must be an empty symbol table!
          if (symbolTable->size() != 0)
             {
               printf ("symbolTable->size() = %d \n",symbolTable->size());
             }
          ROSE_ASSERT(symbolTable->size() == 0);
#if 0
          printf ("Symbol Table from %p = %s of size = %zu \n",scope,scope->class_name().c_str(),symbolTable->size());
          symbolTable->print("Called from SageInterface::rebuildSymbolTable()");
#endif
        }
       else
        {
#if 0
          printf ("In SageInterface::rebuildSymbolTable(): No symbol table found \n");
#endif
          ROSE_ASSERT(symbolTable == NULL);

       // DQ (10/8/2007): Build a new symbol table if there was not already one built.
          symbolTable = new SgSymbolTable();

          ROSE_ASSERT(symbolTable != NULL);
          ROSE_ASSERT(symbolTable->get_table() != NULL);

       // DQ (2/16/2006): Set this parent directly (now tested)
          symbolTable->set_parent(scope);
          ROSE_ASSERT(symbolTable->get_parent() != NULL);

          scope->set_symbol_table(symbolTable);
        }

  // DQ (10/8/2007): If there is already a symbol table then don't over write it. This fixes copies generated with more than one symbol table.
     ROSE_ASSERT(scope->get_symbol_table() != NULL);
     ROSE_ASSERT(scope->get_symbol_table()->get_table() != NULL);

  // This implements SgScopeStatement specific details (e.g function declarations have parameters and their declaration causes variable
  // symbols to be placed into the SgFunctionDefinition scope (but only for defining declarations).
     switch(scope->variantT())
        {
          case V_SgForStatement:
             {
            // These scopes have their symbols split between the attached symbol table and the symbol tables in the SgBasicBlock data member(s).
            // printf ("Symbol tables could contain symbols outside of the inclosed body scope = %p = %s \n",scope,scope->class_name().c_str());

               SgForStatement* forStatement = isSgForStatement(scope);

               SgStatementPtrList::iterator i = forStatement->get_init_stmt().begin();

            // printf ("i != forStatement->get_init_stmt().end() = %s \n",i != forStatement->get_init_stmt().end() ? "true" : "false");

               while (i != forStatement->get_init_stmt().end())
                  {
                 // printf ("For statement initialization list: *i = %p = %s \n",*i,(*i)->class_name().c_str());
                    SgVariableDeclaration* variableDeclarationInitializer = isSgVariableDeclaration(*i);
                    if (variableDeclarationInitializer != NULL)
                       {
                      // There is a variable declaration in the conditional, it needs to be added to the symbol table.
                      // printf ("There is a variable declaration in the for statement initializer, it needs to be added to the symbol table scope = %p = %s \n",scope,scope->class_name().c_str());
                      // ROSE_ASSERT(false);
                         supportForVariableDeclarations ( scope, symbolTable, variableDeclarationInitializer );
                       }

                    i++;
                  }

               SgVariableDeclaration* variableDeclarationCondition = isSgVariableDeclaration(forStatement->get_test());
               if (variableDeclarationCondition != NULL)
                  {
                 // There is a variable declaration in the conditional, it needs to be added to the symbol table.
                 // printf ("There is a variable declaration in the for statement test, it needs to be added to the symbol table scope = %p = %s \n",scope,scope->class_name().c_str());
                 // ROSE_ASSERT(false);
                    supportForVariableDeclarations ( scope, symbolTable, variableDeclarationCondition );
                  }

               return;
               break;
             }

    case V_SgFunctionDefinition:
      {
        // These scopes have their sysmbols split between the attached symbol table and the symbol tables in the SgBasicBlock data member(s).
        // printf ("Symbol tables could contain symbols outside of the enclosed body scope = %p = %s \n",scope,scope->class_name().c_str());

        // DQ (10/8/2007): If this is a SgFunctionDefinition, then include the parameters in the SgFunctionDeclaration.
        SgFunctionDefinition* functionDefinition = isSgFunctionDefinition(scope);
        if (functionDefinition != NULL)
        {
          SgFunctionDeclaration* functionDeclaration = functionDefinition->get_declaration();
       // printf ("In SageInterface::rebuildSymbolTable(): functionDefinition = %p functionDeclaration = %p \n",functionDefinition,functionDeclaration);

          // DQ (10/8/2007): It turns out that this is always NULL, because the parent of the functionDeclaration has not yet been set in the copy mechanism!
          if (functionDeclaration != NULL)
          {
            ROSE_ASSERT(functionDeclaration->isForward() == false);
            SgInitializedNamePtrList & argumentList = functionDeclaration->get_args();
            supportForVariableLists(scope,symbolTable,argumentList);
          }
          else
          {
            // This happend in the copy function because the function definition is copied from the SgFunctionDeclaration
            // and only after the copy is made is the parent of the definition set to be the function declaration.  Thus
            // the get_declaration() member function returns NULL.
            // printf ("There is no function declaration associated with this function definition! \n");
            // ROSE_ASSERT(functionDeclaration->isForward() == true);
          }
        }

        // DQ (10/25/2007): Label symbols are now places into the SgFunctionDefinition (they have to be collected from the function).
        supportForLabelStatements(scope,symbolTable);

        return;
        break;
      }

    case V_SgIfStmt:
      {
        // These scopes have their sysmbols split between the attached symbol table and the symbol tables in the SgBasicBlock data member(s).
        // printf ("Symbol tables could contain symbols outside of the enclosed body scope = %p = %s \n",scope,scope->class_name().c_str());

        SgIfStmt* ifStatement = isSgIfStmt(scope);
        SgVariableDeclaration* variableDeclarationCondition = isSgVariableDeclaration(ifStatement->get_conditional());
        if (variableDeclarationCondition != NULL)
        {
          // There is a variable declaration in the conditional, it needs to be added to the symbol table.
          // printf ("There is a variable declaration in the conditional, it needs to be added to the symbol table \n");
          // ROSE_ASSERT(false);
          supportForVariableDeclarations ( scope, symbolTable, variableDeclarationCondition );
        }
        return;
        break;
      }

    case V_SgSwitchStatement:
      {
        // These scopes have their sysmbols split between the attached symbol table and the symbol tables in the SgBasicBlock data member(s).
        // printf ("Symbol tables could contain symbols outside of the enclosed body scope = %p = %s \n",scope,scope->class_name().c_str());

        SgSwitchStatement* switchStatement = isSgSwitchStatement(scope);
        SgVariableDeclaration* variableDeclarationSelector = isSgVariableDeclaration(switchStatement->get_item_selector());
        if (variableDeclarationSelector != NULL)
        {
          // There is a variable declaration in the conditional, it needs to be added to the symbol table.
          // printf ("There is a variable declaration in the item selector of the switch statement, it needs to be added to the symbol table \n");

          supportForVariableDeclarations ( scope, symbolTable, variableDeclarationSelector );
        }
        return;
        break;
      }

    case V_SgWhileStmt:
      {
        // These scopes have their sysmbols split between the attached symbol table and the symbol tables in the SgBasicBlock data member(s).
        // commented out like for others, otherwise show up each time a While is being copied. Liao, 1/31/2008
        //   printf ("Symbol tables could contain symbols outside of the enclosed body scope = %p = %s \n",scope,scope->class_name().c_str());

        SgWhileStmt* whileStatement = isSgWhileStmt(scope);
        SgVariableDeclaration* variableDeclarationCondition = isSgVariableDeclaration(whileStatement->get_condition());
        if (variableDeclarationCondition != NULL)
        {
          // There is a variable declaration in the conditional, it needs to be added to the symbol table.
          // printf ("There is a variable declaration in the while statement condition, it needs to be added to the symbol table \n");
          // ROSE_ASSERT(false);

          supportForVariableDeclarations ( scope, symbolTable, variableDeclarationCondition );
        }
        return;
        break;
      }

    case V_SgCatchOptionStmt:
    case V_SgDoWhileStmt:
      {
        // These scopes contain a SgBasicBlock as a data member and the scope is held there.
        // printf ("Symbol tables can must be computed by the enclosed body scope = %p = %s \n",scope,scope->class_name().c_str());
        return;
        break;
      }

          case V_SgBasicBlock:
          case V_SgClassDefinition:
          case V_SgTemplateInstantiationDefn:
          case V_SgGlobal:
          case V_SgNamespaceDefinitionStatement:
          case V_SgFortranDo: //Liao 12/19/2008, My understanding is that Fortran do loop header does not introduce new symbols like  a C/C++ for loop does
             {
            // printf ("Used the list of statements/declarations that are held deirectly by this scope \n");
               break;
             }

          default:
             {
               printf ("Default reached in SageInterface::rebuildSymbolTable() scope = %p = %s \n",scope,scope->class_name().c_str());
               ROSE_ASSERT(false);
               break;
             }
        }

#if 0
     printf ("In SageInterface::rebuildSymbolTable(): fixup declarations in Symbol Table from %p = %s \n",scope,scope->class_name().c_str());
#endif

  // Generate a copy of the statement list (this is simpler than handling the cases of a
  // declaration list and a statement list separately for the scopes that contain one or the other.
     SgStatementPtrList statementList = scope->generateStatementList();

  // Loop through the statements and for each declaration build a symbol and add it to the symbol table
     for (SgStatementPtrList::iterator i = statementList.begin(); i != statementList.end(); i++)
        {
       // At some point we should move this mechanism in to a factory patterns for SgSymbol

       // printf ("Iterating through the declaration in this scope ... %p = %s = %s \n",*i,(*i)->class_name().c_str(),get_name(*i).c_str());

          SgDeclarationStatement* declaration = isSgDeclarationStatement(*i);
          if (declaration != NULL)
             {
            // DQ (11/7/2007): Where there can be multiple declaration (e.g. function declarations with prototypes) only use one of them.
               bool useThisDeclaration = (declaration->get_firstNondefiningDeclaration() == declaration) ||
                                         ( (declaration->get_firstNondefiningDeclaration() == NULL) && (declaration->get_definingDeclaration() == declaration) );

               list<SgSymbol*> symbolList;
               switch(declaration->variantT())
                  {
                    case V_SgTemplateInstantiationMemberFunctionDecl:
                       {
                         SgTemplateInstantiationMemberFunctionDecl* derivedDeclaration = isSgTemplateInstantiationMemberFunctionDecl(declaration);
                      // DQ (11/6/2007): Don't build a symbol for the defining declaration defined in another scope and put the resulting symbol into the wrong scope
                         if (scope == derivedDeclaration->get_scope())
                            {
                              SgSymbol* symbol = new SgMemberFunctionSymbol(derivedDeclaration);
                              ROSE_ASSERT(symbol != NULL);

                           // printf ("In rebuildSymbolTable: symbol = %p = %s = %s \n",symbol,symbol->class_name().c_str(),SageInterface::get_name(symbol).c_str());

                           // printf ("SgTemplateInstantiationMemberFunctionDecl: scope = %p derivedDeclaration = %p = %s inserting a symbol = %p \n",scope,derivedDeclaration,get_name(derivedDeclaration).c_str(),symbol);

                              SgName name = derivedDeclaration->get_name();
                              symbolTable->insert(name,symbol);
                            }
                           else
                            {
                           // printf ("SgTemplateInstantiationMemberFunctionDecl: scope = %p derivedDeclaration = %p = %s didn't match the scope \n",scope,derivedDeclaration,get_name(derivedDeclaration).c_str());

                           // These IR nodes might only exist as a template declaration and thus not be structureally present in their scope.
                           // So we would never traverse them in the correct scope and so never build sysmbols for them and add the symbols
                           // to the correct symbol table.  This is a fundamental problem.  So we have to try to add these sorts of symbols
                           // to the scope were they belong.
                              SgScopeStatement* derivedDeclarationScope = derivedDeclaration->get_scope();
                              ROSE_ASSERT(derivedDeclarationScope != NULL);

                           // If this is a copy then it would be nice to make sure that the scope has been properly set.
                           // Check this by looking for the associated template declaration in the scope.
                              SgTemplateDeclaration* templateDeclaration = derivedDeclaration->get_templateDeclaration();
                              ROSE_ASSERT(templateDeclaration != NULL);
                              SgTemplateSymbol* templateSymbol = derivedDeclarationScope->lookup_template_symbol(templateDeclaration->get_name());
                              if (templateSymbol != NULL)
                                 {
                                // The symbol is not present, so we have to build one and add it.
#if 0
                                   printf ("Building a symbol for derivedDeclaration = %p = %s to an alternative symbol table in derivedDeclarationScope = %p \n",
                                        derivedDeclaration,get_name(derivedDeclaration).c_str(),derivedDeclarationScope);
#endif
                                   SgSymbol* symbol = new SgMemberFunctionSymbol(derivedDeclaration);
                                   ROSE_ASSERT(symbol != NULL);
                                   SgName name = derivedDeclaration->get_name();
                                   derivedDeclarationScope->insert_symbol(name,symbol);
                                 }
                                else
                                 {
                                // printf ("The symbol was already present in the derivedDeclarationScope = %p \n",derivedDeclarationScope);
                                 }
                            }
                         break;
                       }

                    case V_SgMemberFunctionDeclaration:
                       {
                         SgMemberFunctionDeclaration* derivedDeclaration = isSgMemberFunctionDeclaration(declaration);

                      // DQ (11/6/2007): Don't build a symbol for the defining declaration defined in another scope and put the resulting symbol into the wrong scope
                         if (scope == derivedDeclaration->get_scope())
                            {
                              SgSymbol* symbol = new SgMemberFunctionSymbol(derivedDeclaration);
                              ROSE_ASSERT(symbol != NULL);

                           // printf ("In rebuildSymbolTable: symbol = %p = %s = %s \n",symbol,symbol->class_name().c_str(),SageInterface::get_name(symbol).c_str());

                              SgName name = derivedDeclaration->get_name();
                              symbolTable->insert(name,symbol);
                            }
                           else
                            {
                           // This happens when a defining declaration is located outside of the class where it is associated.
                           // printf ("SgMemberFunctionDeclaration: scope = %p derivedDeclaration = %p = %s didn't match the scope \n",scope,derivedDeclaration,get_name(derivedDeclaration).c_str());
                            }
                         break;
                       }

     // DQ (2/26/2009): These have to be reformatted from where someone removed the formatting previously.
        case V_SgTemplateInstantiationFunctionDecl:
          {
            SgTemplateInstantiationFunctionDecl* derivedDeclaration = isSgTemplateInstantiationFunctionDecl(declaration);
         // DQ (10/21/2007): If this is a friend function in a class then we have to skip insertion of the symbol into this scope (this symbol table)
         // if (derivedDeclaration->get_declarationModifier().isFriend() == false)
            if (scope == derivedDeclaration->get_scope())
            {
              SgSymbol* symbol = new SgFunctionSymbol(derivedDeclaration);
              ROSE_ASSERT(symbol != NULL);
              SgName name = derivedDeclaration->get_name();
              symbolTable->insert(name,symbol);
            }
            else
            {
              if (derivedDeclaration->get_declarationModifier().isFriend() == false)
              {
#if PRINT_DEVELOPER_WARNINGS
                printf ("Shouldn't this be a friend declaration = %p = %s \n",derivedDeclaration,derivedDeclaration->class_name().c_str());
#endif
              }
            }
            break;
          }

                    case V_SgFunctionDeclaration:
                       {
                         SgFunctionDeclaration* derivedDeclaration = isSgFunctionDeclaration(declaration);

                      // DQ (10/20/2007): If this is a friend function in a class then we have to skip insertion of the symbol into this scope (this symbol table)
                      // if (derivedDeclaration->get_declarationModifier().isFriend() == false)

                         if (useThisDeclaration == true)
                            {
                              if (scope == derivedDeclaration->get_scope())
                                 {
                                   SgSymbol* symbol = new SgFunctionSymbol(derivedDeclaration);
                                   ROSE_ASSERT(symbol != NULL);
                                   SgName name = derivedDeclaration->get_name();
                                   symbolTable->insert(name,symbol);
                                 }
                                else
                                 {
                                   if (derivedDeclaration->get_declarationModifier().isFriend() == false)
                                      {
#if PRINT_DEVELOPER_WARNINGS
                                        printf ("Shouldn't this be a friend declaration = %p = %s \n",derivedDeclaration,derivedDeclaration->class_name().c_str());
#endif
                                      }
                                 }
                            }
                         break;
                       }

        case V_SgVariableDeclaration:
          {
            SgVariableDeclaration* derivedDeclaration = isSgVariableDeclaration(declaration);
            SgInitializedNamePtrList & variableList = derivedDeclaration->get_variables();
            SgInitializedNamePtrList::iterator i = variableList.begin();
            while ( i != variableList.end() )
            {
              SgInitializedName* variable = *i;
              ROSE_ASSERT(variable != NULL);

              // DQ (10/20/2007): static data members declared outside the class scope don't generate symbols.
              // if (variable->get_prev_decl_item() != NULL)
              if (variable->get_scope() == scope)
              {
                SgSymbol* symbol = new SgVariableSymbol(variable);
                ROSE_ASSERT(symbol != NULL);

                // printf ("In SageInterface::rebuildSymbolTable() variable = %p building a new SgVariableSymbol = %p \n",variable,symbol);

                SgName name = variable->get_name();
                symbolTable->insert(name,symbol);
              }
              else
              {
                // I think there is nothing to do in this case
                // printf ("In SageInterface::rebuildSymbolTable() This variable has a scope inconsistant with the symbol table: variable->get_scope() = %p scope = %p \n",variable->get_scope(),scope);
              }

              i++;
            }

            // DQ (10/13/2007): Need to look into variable declarations to see if there are defining declaration
            // that also force symbols to be built in the current scope!
            // ROSE_ASSERT(derivedDeclaration->get_variableDeclarationContainsBaseTypeDefiningDeclaration() == false);
            if (derivedDeclaration->get_variableDeclarationContainsBaseTypeDefiningDeclaration() == true)
            {
              // Build a SgClassDeclaration, SgEnumDeclaration associated symbol and add it to the symbol table.
              ROSE_ASSERT(symbolTable != NULL);
              ROSE_ASSERT(derivedDeclaration->get_baseTypeDefiningDeclaration() != NULL);
              supportForBaseTypeDefiningDeclaration ( symbolTable, derivedDeclaration->get_baseTypeDefiningDeclaration() );
            }

            // ROSE_ASSERT(symbolList.empty() == false);
            break;
          }

        case V_SgTemplateInstantiationDecl:
          {
            SgTemplateInstantiationDecl* derivedDeclaration = isSgTemplateInstantiationDecl(declaration);
#if 1
            // printf ("case SgTemplateInstantiationDecl: derivedDeclaration name = %s derivedDeclaration->get_declarationModifier().isFriend() = %s \n",
            //      derivedDeclaration->get_name().str(),derivedDeclaration->get_declarationModifier().isFriend() ? "true" : "false");

            // if (derivedDeclaration->get_declarationModifier().isFriend() == false)
            if (scope == derivedDeclaration->get_scope())
            {
              SgSymbol* symbol = new SgClassSymbol(derivedDeclaration);
              // printf ("Inserting SgClassSymbol = %p into scope = %p = %s \n",symbol,scope,scope->class_name().c_str());
              ROSE_ASSERT(symbol != NULL);
              SgName name = derivedDeclaration->get_name();
#if 0
              // DQ (10/21/2007): The scopes should match
              if (scope != derivedDeclaration->get_scope())
              {
                printf ("Error: scopes don't match for derivedDeclaration = %p = %s \n",derivedDeclaration,derivedDeclaration->class_name().c_str());
              }
              ROSE_ASSERT(scope == derivedDeclaration->get_scope());
#endif
              symbolTable->insert(name,symbol);
            }
            else
            {
              // printf ("SgTemplateInstantiationDecl: scope = %p derivedDeclaration = %p = %s didn't match the scope \n",scope,derivedDeclaration,get_name(derivedDeclaration).c_str());

              if (derivedDeclaration->get_declarationModifier().isFriend() == false)
              {
#if PRINT_DEVELOPER_WARNINGS
                printf ("Shouldn't this be a friend declaration = %p = %s \n",derivedDeclaration,derivedDeclaration->class_name().c_str());
#endif
              }
            }
#else
            SgSymbol* symbol = new SgClassSymbol(derivedDeclaration);
            ROSE_ASSERT(symbol != NULL);
            SgName name = derivedDeclaration->get_name();
            symbolTable->insert(name,symbol);
#endif
            break;
          }

        case V_SgClassDeclaration:
          {
            SgClassDeclaration* derivedDeclaration = isSgClassDeclaration(declaration);
#if 1
            // printf ("case SgClassDeclaration: derivedDeclaration name = %s derivedDeclaration->get_declarationModifier().isFriend() = %s \n",
            //      derivedDeclaration->get_name().str(),derivedDeclaration->get_declarationModifier().isFriend() ? "true" : "false");
            // if (derivedDeclaration->get_declarationModifier().isFriend() == false)
            if (scope == derivedDeclaration->get_scope())
            {
              SgSymbol* symbol = new SgClassSymbol(derivedDeclaration);
              ROSE_ASSERT(symbol != NULL);
              SgName name = derivedDeclaration->get_name();
              symbolTable->insert(name,symbol);
            }
            else
            {
              if (derivedDeclaration->get_declarationModifier().isFriend() == false)
              {
#if PRINT_DEVELOPER_WARNINGS
                printf ("Shouldn't this be a friend declaration = %p = %s \n",derivedDeclaration,derivedDeclaration->class_name().c_str());
#endif
              }
            }
#else
            SgSymbol* symbol = new SgClassSymbol(derivedDeclaration);
            ROSE_ASSERT(symbol != NULL);
            SgName name = derivedDeclaration->get_name();
            symbolTable->insert(name,symbol);
#endif
            break;
          }

        case V_SgEnumDeclaration:
          {
            SgEnumDeclaration* derivedDeclaration = isSgEnumDeclaration(declaration);
            ROSE_ASSERT(derivedDeclaration != NULL);
            SgSymbol* symbol = new SgEnumSymbol(derivedDeclaration);
            ROSE_ASSERT(symbol != NULL);
            SgName name = derivedDeclaration->get_name();
            symbolTable->insert(name,symbol);

            // DQ (10/18/2007): Fixed construction of symbol tabel to include enum fields.
            SgInitializedNamePtrList & enumFieldList = derivedDeclaration->get_enumerators();
            SgInitializedNamePtrList::iterator i     = enumFieldList.begin();

            // Iterate over enum fields and add each one to the symbol table.
            while (i != enumFieldList.end())
            {
              SgSymbol* enum_field_symbol = new SgEnumFieldSymbol(*i);
              ROSE_ASSERT(enum_field_symbol != NULL);
              SgName enum_field_name = (*i)->get_name();
              symbolTable->insert(enum_field_name,enum_field_symbol);

              i++;
            }

            break;
          }

        case V_SgTypedefDeclaration:
          {
            SgTypedefDeclaration* derivedDeclaration = isSgTypedefDeclaration(declaration);
            SgSymbol* symbol = new SgTypedefSymbol(derivedDeclaration);
            ROSE_ASSERT(symbol != NULL);
            SgName name = derivedDeclaration->get_name();
            symbolTable->insert(name,symbol);

            // DQ (10/13/2007): Need to look into typedefs to see if there are defining declaration
            // that also force symbols to be built in the current scope!
            // ROSE_ASSERT(derivedDeclaration->get_typedefBaseTypeContainsDefiningDeclaration() == false);
            if (derivedDeclaration->get_typedefBaseTypeContainsDefiningDeclaration() == true)
            {
              // Build a SgClassDeclaration, SgEnumDeclaration associated symbol and add it to the symbol table.
              ROSE_ASSERT(symbolTable != NULL);
              ROSE_ASSERT(derivedDeclaration->get_baseTypeDefiningDeclaration() != NULL);
              supportForBaseTypeDefiningDeclaration ( symbolTable, derivedDeclaration->get_baseTypeDefiningDeclaration() );
            }
            else
            {
              // DQ (11/7/2007): If the typedef has a definition (e.g. function pointer) then build a symbol.
              SgDeclarationStatement* declaration = derivedDeclaration->get_declaration();
              if (declaration != NULL)
              {
                supportForBaseTypeDefiningDeclaration ( symbolTable, derivedDeclaration->get_declaration() );
              }
            }

            break;
          }

        case V_SgTemplateDeclaration:
          {
            SgTemplateDeclaration* derivedDeclaration = isSgTemplateDeclaration(declaration);
#if 1
            // DQ (10/21/2007): If this is a friend function in a class then we have to skip insertion of the symbol into this scope (this symbol table)
#if 0
            printf ("case V_SgTemplateDeclaration: derivedDeclaration               = %p \n",derivedDeclaration);
            printf ("case V_SgTemplateDeclaration: derivedDeclaration->get_declarationModifier().isFriend() = %s \n",derivedDeclaration->get_declarationModifier().isFriend() ? "true" : "false");
            printf ("case V_SgTemplateDeclaration: derivedDeclaration->get_name()   = %s \n",derivedDeclaration->get_name().str());
            printf ("case V_SgTemplateDeclaration: derivedDeclaration->get_string() = %s \n",derivedDeclaration->get_string().str());
#endif
            // if (derivedDeclaration->get_declarationModifier().isFriend() == false)
            if (scope == derivedDeclaration->get_scope())
            {
              // printf ("Building symbol for SgTemplateDeclaration: derivedDeclaration = %p for symbol table in scope = %p \n",derivedDeclaration,scope);
              SgSymbol* symbol = new SgTemplateSymbol(derivedDeclaration);
              ROSE_ASSERT(symbol != NULL);
              SgName name = derivedDeclaration->get_name();
              symbolTable->insert(name,symbol);
            }
            else
            {
              if (derivedDeclaration->get_declarationModifier().isFriend() == false)
              {
#if PRINT_DEVELOPER_WARNINGS
                printf ("Shouldn't this be a friend declaration = %p = %s \n",derivedDeclaration,derivedDeclaration->class_name().c_str());
#endif
              }
            }
#else
            SgTemplateDeclaration* derivedDeclaration = isSgTemplateDeclaration(declaration);
            SgSymbol* symbol = new SgTemplateSymbol(derivedDeclaration);
            ROSE_ASSERT(symbol != NULL);
            SgName name = derivedDeclaration->get_name();
            symbolTable->insert(name,symbol);
#endif
            break;
          }

          // Does this cause a symbol to be built?  Seems that it should,
          // unless we always reference the non-aliased symbol (reuse it)!
        case V_SgNamespaceAliasDeclarationStatement:
          {
            SgNamespaceAliasDeclarationStatement* aliasDeclaration = isSgNamespaceAliasDeclarationStatement(declaration);
            ROSE_ASSERT(aliasDeclaration != NULL);
            ROSE_ASSERT(aliasDeclaration->get_namespaceDeclaration() != NULL);

            SgNamespaceDeclarationStatement* derivedDeclaration = isSgNamespaceDeclarationStatement(aliasDeclaration->get_namespaceDeclaration());
            ROSE_ASSERT(derivedDeclaration != NULL);

            // The constructor for the SgNamespaceSymbol is disturbingly different from the rest of the constructors.
            SgSymbol* symbol = new SgNamespaceSymbol(derivedDeclaration->get_name(),derivedDeclaration);
            ROSE_ASSERT(symbol != NULL);
            SgName name = derivedDeclaration->get_name();
            symbolTable->insert(name,symbol);
            // symbolList.push_back(symbol);
            // ROSE_ASSERT(symbolList.empty() == false);
            break;
          }

          // Does this cause a symbol to be built?  Seems that it should,
          // unless we always reference the non-aliased symbol (reuse it)!
        case V_SgNamespaceDeclarationStatement:
          {
            SgNamespaceDeclarationStatement* derivedDeclaration = isSgNamespaceDeclarationStatement(declaration);
            ROSE_ASSERT(derivedDeclaration != NULL);

            // The constructor for the SgNamespaceSymbol is disturbingly different from the rest of the constructors.
            SgSymbol* symbol = new SgNamespaceSymbol(derivedDeclaration->get_name(),derivedDeclaration);
            ROSE_ASSERT(symbol != NULL);
            SgName name = derivedDeclaration->get_name();
            symbolTable->insert(name,symbol);
            // symbolList.push_back(symbol);
            // ROSE_ASSERT(symbolList.empty() == false);
            break;
          }

                    case V_SgUsingDirectiveStatement:
                    case V_SgPragmaDeclaration:
                    case V_SgTemplateInstantiationDirectiveStatement:
                    case V_SgUsingDeclarationStatement:
                      {
                        // DQ (10/22/2005): Not sure if we have to worry about this declaration's appearance in the symbol table!
#if 0
                        printf ("This declaration is ignored in rebuilding symbol table %p = %s = %s \n",*i,(*i)->class_name().c_str(),get_name(*i).c_str());
#endif
                        break;
                      }

                    case V_SgAsmStmt:
                      {
                        // DQ (8/13/2006): This is not really a declaration (I think).  This will be fixed later.
#if 0
                        printf ("An ASM statement (SgAsmStmt) declaration is not really a declaration %p = %s = %s \n",*i,(*i)->class_name().c_str(),get_name(*i).c_str());
#endif
                        break;
                      }

                 // Cases where declations are not used or referenced and so symbols are not required!
                    case V_SgVariableDefinition:
                    case V_SgFunctionParameterList:
                    case V_SgCtorInitializerList:
                 // These are not referenced so they don't need a symbol!
                      {
                        printf ("Special cases not handled %p = %s = %s \n",*i,(*i)->class_name().c_str(),get_name(*i).c_str());
                        ROSE_ASSERT(false);
                        break;
                      }

                    default:
                      {
                        printf ("Default reached in rebuildSymbolTable \n");
                        ROSE_ASSERT(false);
                      }
                  }

               ROSE_ASSERT(symbolTable != NULL);
               ROSE_ASSERT(symbolTable->get_table() != NULL);
             }
       // printf ("DONE: Iterating through the declaration in this scope ... %p = %s = %s \n",*i,(*i)->class_name().c_str(),get_name(*i).c_str());

        }

     ROSE_ASSERT(symbolTable != NULL);
     ROSE_ASSERT(symbolTable->get_table() != NULL);

#if 0
     printf ("Leaving SageInterface::rebuildSymbolTable(): fixup declarations in Symbol Table from %p = %s \n",scope,scope->class_name().c_str());
#endif

#if 0
     printf ("Symbol Table from %p = %s at: \n",scope,scope->class_name().c_str());
     scope->get_file_info()->display("Symbol Table Location");
     symbolTable->print("Called from SageInterface::rebuildSymbolTable()");
#endif
   }


// #ifndef USE_ROSE

void
SageInterface::fixupReferencesToSymbols( const SgScopeStatement* this_scope,  SgScopeStatement* copy_scope, SgCopyHelp & help )
   {
  // This function is called by the SageInterface::rebuildSymbolTable().
  // It resets references to old symbols to the new symbols (just built).
  // All pairs of old/new symbols are also saved in the object:
  //    SgCopyHelp::copiedNodeMapType copiedNodeMap

     ROSE_ASSERT(this_scope != NULL);
     ROSE_ASSERT(copy_scope != NULL);

#if 0
     printf ("In fixupReferencesToSymbols(this_scope = %p = %s = %s, copy_scope = %p = %s = %s) \n",
          this_scope,this_scope->class_name().c_str(),get_name(this_scope).c_str(),
          copy_scope,copy_scope->class_name().c_str(),get_name(copy_scope).c_str());
#endif

     SgSymbolTable* this_symbolTable = this_scope->get_symbol_table();
     SgSymbolTable* copy_symbolTable = copy_scope->get_symbol_table();
#if 0
     printf ("Before fixup: this scope = %p = %s this_symbolTable->get_table()->size() = %zu \n",this_scope,this_scope->class_name().c_str(),this_symbolTable->get_table()->size());
     printf ("Before fixup: copy scope = %p = %s copy_symbolTable->get_table()->size() = %zu \n",copy_scope,copy_scope->class_name().c_str(),copy_symbolTable->get_table()->size());
#endif

  // DQ (3/4/2009): For now just output a warning, but this might be a more serious problem.
  // Since the symbol table size of the copy is larger than that of the original it might
  // be that a symbol is enterted twice by the copy mechanism.  If so I want to fix this.
     if (this_symbolTable->get_table()->size() != copy_symbolTable->get_table()->size())
        {
          if (SgProject::get_verbose() > 0)
              {
               printf ("Before fixup: this scope = %p = %s this_symbolTable->get_table()->size() = %zu \n",this_scope,this_scope->class_name().c_str(),this_symbolTable->get_table()->size());
               printf ("Before fixup: copy scope = %p = %s copy_symbolTable->get_table()->size() = %zu \n",copy_scope,copy_scope->class_name().c_str(),copy_symbolTable->get_table()->size());
               printf ("Warning the symbols tables in these different scopes are different sizes \n");
             }
        }
  // ROSE_ASSERT(this_symbolTable->get_table()->size() <= copy_symbolTable->get_table()->size());

     SgSymbolTable::hash_iterator i = this_symbolTable->get_table()->begin();

  // This is used to fixup the AST by resetting references to IR nodes (leveraged from AST merge).
     int replacementHashTableSize = 1001;
// CH (4/9/2010): Use boost::unordered instead
//#ifdef _MSCx_VER
#if 0
//#pragma message ("WARNING: in MSCV, hash_map constructor taking integer is not availalbe in MSVC.")
     printf ("WARNING: in MSCV, hash_map constructor taking integer is not availalbe in MSVC. \n");
     ReplacementMapTraversal::ReplacementMapType replacementMap;
#else
     ReplacementMapTraversal::ReplacementMapType replacementMap(replacementHashTableSize);
#endif
     int counter = 0;
     while (i != this_symbolTable->get_table()->end())
        {
          ROSE_ASSERT ( isSgSymbol( (*i).second ) != NULL );

          SgName name     = (*i).first;
       // SgSymbol* symbol = isSgSymbol((*i).second);
          SgSymbol* symbol = (*i).second;
          ROSE_ASSERT ( symbol != NULL );

          SgSymbol* associated_symbol = NULL;
#if 0
          printf ("Symbol number: %d (pair.first (SgName) = %s) pair.second (SgSymbol) = %p sage_class_name() = %s \n",counter,i->first.str(),i->second,i->second->class_name().c_str());
#endif
       // Look for the associated symbol in the copy_scope's symbol table.
          SgSymbolTable::hash_iterator associated_symbol_iterator = copy_symbolTable->get_table()->find(name);

       // Note that this is a multi-map and for C++ a number of symbols can have the same name
       // (though not the same type of symbol) so we have to iterator over the symbols of the
       // same name so that we can identify the associated symbol.
          while (associated_symbol_iterator != copy_symbolTable->get_table()->end() && associated_symbol_iterator->first == name)
             {
               if ( associated_symbol_iterator->second->variantT() == symbol->variantT() )
                  {
                    associated_symbol = associated_symbol_iterator->second;
                  }

               associated_symbol_iterator++;
             }

          if (associated_symbol != NULL)
             {
               ROSE_ASSERT ( associated_symbol != NULL );

            // Check to make sure that this is correct
               ROSE_ASSERT(copy_scope->symbol_exists(associated_symbol) == true);

            // Add the SgGlobal referenece to the replacementMap
            // replacementMap.insert(pair<SgNode*,SgNode*>(originalFileGlobalScope,scope));
            // DQ (23/1/2009): Find the reference to symbol and replace it with associated_symbol.
               replacementMap.insert(pair<SgNode*,SgNode*>(symbol,associated_symbol));

            // DQ (3/1/2009): This is backwards
            // replacementMap.insert(pair<SgNode*,SgNode*>(associated_symbol,symbol));

            // DQ (3/2/2009): accumulate the symbol pair into the SgCopyHelp object (to support the outliner).
            // Actually this should also improve the robustness of the outliner.
               help.get_copiedNodeMap().insert(pair<const SgNode*,SgNode*>(symbol,associated_symbol));
             }
            else
             {
            // DQ (3/4/2009): This case was broken out because copytest2007_14.C fails here.
               if (SgProject::get_verbose() > 0)
                  {
                    printf ("Warning: Symbol number: %d (pair.first (SgName) = %s) pair.second (SgSymbol) = %p sage_class_name() = %s \n",counter,i->first.str(),i->second,i->second->class_name().c_str());
                    printf ("Warning: associated_symbol == NULL, need to investigate this (ignoring for now) \n");
                  }
             }

          counter++;

          i++;
        }

     set<SgNode*>  intermediateDeleteSet;

#if 0
     printf ("Output the replacementMap: \n");
  // printf ("replacementMap.size() = %zu \n",replacementMap.size());
     ReplacementMapTraversal::displayReplacementMap(replacementMap);

     printf ("\n\n************************************************************\n");
     printf ("fixupReferencesToSymbols(this_scope = %p copy_scope = %p = %s = %s): calling fixupSubtreeTraversal() \n",this_scope,copy_scope,copy_scope->class_name().c_str(),get_name(copy_scope).c_str());
#endif

     fixupSubtreeTraversal(copy_scope,replacementMap,intermediateDeleteSet);

#if 0
     printf ("fixupReferencesToSymbols(): calling fixupSubtreeTraversal(): DONE \n");
     printf ("************************************************************\n\n");

     printf ("\n\n After replacementMapTraversal(): intermediateDeleteSet: \n");
     displaySet(intermediateDeleteSet,"After fixupTraversal");

     printf ("After fixup: this_symbolTable->get_table()->size() = %zu \n",this_symbolTable->get_table()->size());
     printf ("After fixup: copy_symbolTable->get_table()->size() = %zu \n",copy_symbolTable->get_table()->size());
#endif

  // DQ (3/1/2009): find a case where this code is tested.
  // ROSE_ASSERT(this_symbolTable->get_table()->size() == 0);
  // ROSE_ASSERT(isSgClassDefinition(copy_scope) == NULL);

#if 0
     printf ("Exiting as a test in fixupReferencesToSymbols() \n");
     ROSE_ASSERT(false);
#endif
   }

// #endif

#ifndef USE_ROSE

std::vector<SgFile*>
SageInterface::generateFileList()
   {
  // This function uses a memory pool traversal specific to the SgFile IR nodes
     class FileTraversal : public ROSE_VisitTraversal
        {
          public:
               vector<SgFile*> fileList;
               void visit ( SgNode* node)
                  {
                    SgFile* file = isSgFile(node);
                    ROSE_ASSERT(file != NULL);
                    if (file != NULL)
                       {
                         fileList.push_back(file);
                       }
                  };

              virtual ~FileTraversal() {}
        };

     FileTraversal fileTraversal;

  // traverse just the SgFile nodes (both the SgSourceFile and SgBinaryComposite IR nodes)!
  // SgFile::visitRepresentativeNode(fileTraversal);
     SgSourceFile::visitRepresentativeNode(fileTraversal);
     SgBinaryComposite::visitRepresentativeNode(fileTraversal);

  // This would alternatively traverse all IR nodes in thememory pool!
  // fileTraversal.traverseMemoryPool();

     ROSE_ASSERT(fileTraversal.fileList.empty() == false);
     return fileTraversal.fileList;
   }

#endif

// #ifndef USE_ROSE

// This function uses a memory pool traversal specific to the SgProject IR nodes
SgProject*
SageInterface::getProject()
{
#if 0
  class ProjectTraversal : public ROSE_VisitTraversal
  {
    public:
      SgProject * project;
      void visit ( SgNode* node)
      {
        project = isSgProject(node);
        ROSE_ASSERT(project!= NULL);
      };
      virtual ~ProjectTraversal() {}
  };

  ProjectTraversal projectTraversal;
  SgProject::visitRepresentativeNode(projectTraversal);
  return projectTraversal.project;
#endif
  std::vector<SgProject* > resultlist = getSgNodeListFromMemoryPool<SgProject>();
  ROSE_ASSERT(resultlist.size()==1);
  return resultlist[0];
}

SgFunctionDeclaration* SageInterface::getDeclarationOfNamedFunction(SgExpression* func) {
  if (isSgFunctionRefExp(func)) {
    return isSgFunctionRefExp(func)->get_symbol()->get_declaration();
  } else if (isSgDotExp(func) || isSgArrowExp(func)) {
    SgExpression* func2 = isSgBinaryOp(func)->get_rhs_operand();
    ROSE_ASSERT (isSgMemberFunctionRefExp(func2));
    return isSgMemberFunctionRefExp(func2)->get_symbol()->get_declaration();
  } else return 0;
}

SgExpression* SageInterface::forallMaskExpression(SgForAllStatement* stmt) {
  SgExprListExp* el = stmt->get_forall_header();
  const SgExpressionPtrList& ls = el->get_expressions();
  if (ls.empty()) return 0;
  if (isSgAssignOp(ls.back())) return 0;
  return ls.back();
}

//Find all SgPntrArrRefExp under astNode, add the referenced dim_info SgVarRefExp (if any) into NodeList_t 
void SageInterface::addVarRefExpFromArrayDimInfo(SgNode * astNode, Rose_STL_Container<SgNode *>& NodeList_t)
{
  ROSE_ASSERT (astNode != NULL);
  Rose_STL_Container<SgNode*> arr_exp_list = NodeQuery::querySubTree(astNode,V_SgPntrArrRefExp);
  for (Rose_STL_Container<SgNode*>::iterator iter_0 = arr_exp_list.begin(); iter_0 !=arr_exp_list.end(); iter_0 ++)
  {
    SgPntrArrRefExp * arr_exp = isSgPntrArrRefExp(*iter_0);
    ROSE_ASSERT (arr_exp != NULL);
    //printf("Debug: Found SgPntrArrRefExp :%p\n", arr_exp);
    Rose_STL_Container<SgNode*> refList = NodeQuery::querySubTree(arr_exp->get_lhs_operand(),V_SgVarRefExp);
    for (Rose_STL_Container<SgNode*>::iterator iter = refList.begin(); iter !=refList.end(); iter ++)
    {
      SgVarRefExp* cur_ref = isSgVarRefExp(*iter);
      ROSE_ASSERT (cur_ref != NULL);
      SgVariableSymbol * sym = cur_ref->get_symbol();
      ROSE_ASSERT (sym != NULL);
      SgInitializedName * i_name = sym->get_declaration();
      ROSE_ASSERT (i_name != NULL);
      SgArrayType * a_type = isSgArrayType(i_name->get_typeptr());
      if (a_type && a_type->get_dim_info())
      {
        Rose_STL_Container<SgNode*> dim_ref_list = NodeQuery::querySubTree(a_type->get_dim_info(),V_SgVarRefExp);
        for (Rose_STL_Container<SgNode*>::iterator iter2 = dim_ref_list.begin(); iter2 != dim_ref_list.end(); iter2++)
        {
          SgVarRefExp* dim_ref = isSgVarRefExp(*iter2);
          //printf("Debug: Found indirect SgVarRefExp as part of array dimension declaration:%s\n", dim_ref->get_symbol()->get_name().str());
          NodeList_t.push_back(dim_ref);
        }
      }
    }
  } // end for
}


bool
SageInterface::is_C_language()
   {
     bool returnValue = false;

     vector<SgFile*> fileList = generateFileList();

     int size = (int)fileList.size();
     for (int i = 0; i < size; i++)
        {
          if (fileList[i]->get_C_only() == true)
               returnValue = true;
        }

     return returnValue;
   }
bool
SageInterface::is_OpenMP_language()
   {
     bool returnValue = false;

     vector<SgFile*> fileList = generateFileList();

     int size = (int)fileList.size();
     for (int i = 0; i < size; i++)
        {
          if (fileList[i]->get_openmp() == true)
               returnValue = true;
        }

     return returnValue;
   }

bool
SageInterface::is_UPC_language()
   {
     bool returnValue = false;

     vector<SgFile*> fileList = generateFileList();

     int size = (int)fileList.size();
     for (int i = 0; i < size; i++)
        {
          if (fileList[i]->get_UPC_only() == true)
               returnValue = true;
        }

     return returnValue;
   }

//FMZ
bool
SageInterface::is_CAF_language()
   {
     bool returnValue = false;

     vector<SgFile*> fileList = generateFileList();

     int size = (int)fileList.size();
     for (int i = 0; i < size; i++)
        {
          if (fileList[i]->get_CoArrayFortran_only()==true)
               returnValue = true;
        }

     return returnValue;
   }


// true if any of upc_threads is set to >0 via command line: -rose:upc_threads n
bool
SageInterface::is_UPC_dynamic_threads()
   {
     bool returnValue = false;

     vector<SgFile*> fileList = generateFileList();

     int size = (int)fileList.size();
     for (int i = 0; i < size; i++)
        {
          if (fileList[i]->get_upc_threads() > 0)
               returnValue = true;
        }

     return returnValue;
   }



bool
SageInterface::is_C99_language()
   {
     bool returnValue = false;

     vector<SgFile*> fileList = generateFileList();

     int size = (int)fileList.size();
     for (int i = 0; i < size; i++)
        {
          if (fileList[i]->get_C99_only() == true)
               returnValue = true;
        }

     return returnValue;
   }

bool
SageInterface::is_Cxx_language()
   {
     bool returnValue = false;

     vector<SgFile*> fileList = generateFileList();

     int size = (int)fileList.size();
     for (int i = 0; i < size; i++)
        {
       // DQ (8/19/2007): Make sure this is not a Fortran code!
       // if (fileList[i]->get_C99_only() == false && fileList[i]->get_C_only() == false)
       // if (fileList[i]->get_Fortran_only() == false && fileList[i]->get_C99_only() == false && fileList[i]->get_C_only() == false && fileList[i]->get_binary_only() == false)
          if (fileList[i]->get_Cxx_only() == true)
             {
            // ROSE_ASSERT(fileList[i]->get_Cxx_only() == true);
               ROSE_ASSERT(fileList[i]->get_Fortran_only() == false && fileList[i]->get_C99_only() == false && fileList[i]->get_C_only() == false && fileList[i]->get_binary_only() == false);

               returnValue = true;
             }
        }

     return returnValue;
   }

bool
SageInterface::is_Java_language()
   {
     bool returnValue = false;

     vector<SgFile*> fileList = generateFileList();

     int size = (int)fileList.size();
     for (int i = 0; i < size; i++)
        {
          if (fileList[i]->get_Java_only() == true)
               returnValue = true;
        }

     return returnValue;
   }


bool
SageInterface::is_Fortran_language()
   {
     bool returnValue = false;

     vector<SgFile*> fileList = generateFileList();

     int size = (int)fileList.size();
     for (int i = 0; i < size; i++)
        {
          if (fileList[i]->get_Fortran_only() == true)
               returnValue = true;
        }

     return returnValue;
   }


bool
SageInterface::is_binary_executable()
   {
     bool returnValue = false;

     vector<SgFile*> fileList = generateFileList();

     int size = (int)fileList.size();
     for (int i = 0; i < size; i++)
        {
          if (fileList[i]->get_binary_only() == true)
               returnValue = true;
        }

     return returnValue;
   }

bool
SageInterface::is_PHP_language()
   {
     bool returnValue = false;

     vector<SgFile*> fileList = generateFileList();

     int size = (int)fileList.size();
     for (int i = 0; i < size; i++)
        {
          if (fileList[i]->get_PHP_only() == true)
               returnValue = true;
        }

     return returnValue;
   }

bool SageInterface::is_mixed_C_and_Cxx_language()
   {
     return is_C_language() && is_Cxx_language();
   }

bool SageInterface::is_mixed_Fortran_and_C_language()
   {
     return is_Fortran_language() && is_C_language();
   }

bool SageInterface::is_mixed_Fortran_and_Cxx_language()
   {
     return is_Fortran_language() && is_Cxx_language();
   }

bool SageInterface::is_mixed_Fortran_and_C_and_Cxx_language()
   {
     return is_Fortran_language() && is_C_language() && is_Cxx_language();
   }

// #endif

// DQ (10/5/2006): Added support for faster (non-quadratic) computation of unique
// labels for scopes in a function (as required for name mangling).
void
SageInterface::clearScopeNumbers( SgFunctionDefinition* functionDefinition )
   {
     ROSE_ASSERT(functionDefinition != NULL);
     std::map<SgNode*,int> & scopeMap = functionDefinition->get_scope_number_list();

  // Clear the cache of stored (scope,integer) pairs
     scopeMap.erase(scopeMap.begin(),scopeMap.end());

     ROSE_ASSERT(scopeMap.empty() == true);
     ROSE_ASSERT(functionDefinition->get_scope_number_list().empty() == true);
   }

#ifndef USE_ROSE

// DQ (10/5/2006): Added support for faster (non-quadratic) computation of unique
// labels for scopes in a function (as required for name mangling).
void
SageInterface::resetScopeNumbers( SgFunctionDefinition* functionDefinition )
   {
     ROSE_ASSERT(functionDefinition != NULL);
  // std::map<SgNode*,int> & scopeMap = functionDefinition->get_scope_number_list();
  // ROSE_ASSERT(scopeMap.empty() == true);
     ROSE_ASSERT(functionDefinition->get_scope_number_list().empty() == true);

  // Preorder traversal to uniquely label the scopes (SgScopeStatements)
     class ScopeNumberingTraversal : public AstSimpleProcessing
        {
          public:
               ScopeNumberingTraversal() : count (0), storedFunctionDefinition(NULL) {}
               void visit (SgNode* node)
                  {
                    SgScopeStatement* scope = isSgScopeStatement (node);
                    if (scope != NULL)
                       {
                      // Set the function definition
                         SgFunctionDefinition* testFunctionDefinition = isSgFunctionDefinition(scope);
                         if (testFunctionDefinition != NULL && storedFunctionDefinition == NULL)
                            {
                              ROSE_ASSERT(storedFunctionDefinition == NULL);
                              storedFunctionDefinition = testFunctionDefinition;
                            }

                      // This should now be set (since the root of each traversal is a SgFunctionDefinition).
                         ROSE_ASSERT(storedFunctionDefinition != NULL);

                         count++;

                         std::map<SgNode*,int> & scopeMap = storedFunctionDefinition->get_scope_number_list();
                         scopeMap.insert(pair<SgNode*,int>(scope,count));
#if 0
                         string functionName = storedFunctionDefinition->get_declaration()->get_name().str();
                         printf ("In function = %s insert scope = %p = %s with count = %d into local map (size = %d) \n",
                              functionName.c_str(),scope,scope->class_name().c_str(),count,scopeMap.size());
#endif
                       }
                  }

          private:
               int count; // running total of scopes found in the input function
               SgFunctionDefinition* storedFunctionDefinition;
        };

    // Now buid the traveral object and call the traversal (preorder) on the function definition.
       ScopeNumberingTraversal traversal;
       traversal.traverse(functionDefinition, preorder);
   }

#endif

#ifndef USE_ROSE

#if 0
// DQ (6/26/2007): These are removed and the support is added to SgNode to support a single mangled name cache.
// DQ (10/5/2006): Added support for faster (non-quadratic) computation of unique
// labels for scopes in a function (as required for name mangling).
void
SageInterface::clearMangledNameCache( SgGlobal* globalScope )
   {
     ROSE_ASSERT(globalScope != NULL);
     std::map<SgNode*,std::string> & mangledNameCache = globalScope->get_mangledNameCache();

  // Clear the cache of stored (scope,integer) pairs
     mangledNameCache.erase(mangledNameCache.begin(),mangledNameCache.end());

     ROSE_ASSERT(mangledNameCache.empty() == true);
     ROSE_ASSERT(globalScope->get_mangledNameCache().empty() == true);
   }

// DQ (10/5/2006): Added support for faster (non-quadratic) computation of unique
// labels for scopes in a function (as required for name mangling).
void
SageInterface::resetMangledNameCache( SgGlobal* globalScope )
   {
     ROSE_ASSERT(globalScope != NULL);
     ROSE_ASSERT(globalScope->get_mangledNameCache().empty() == true);

  // Preorder traversal to uniquely label the scopes (SgScopeStatements)
     class MangledNameTraversal : public AstSimpleProcessing
        {
          public:
               MangledNameTraversal() : storedGlobalScope(NULL) {}
               void visit (SgNode* node)
                  {
                    SgFunctionDeclaration* mangleableNode = isSgFunctionDeclaration(node);
                    if ( (mangleableNode != NULL) || (isSgGlobal(node) != NULL) )
                       {
                      // Set the global scope
                         SgGlobal* testGlobalScope = isSgGlobal(mangleableNode);
                         if (testGlobalScope != NULL && storedGlobalScope == NULL)
                            {
                              ROSE_ASSERT(storedGlobalScope == NULL);
                              storedGlobalScope = testGlobalScope;
                            }

                      // This should now be set (since the root of each traversal is a SgFunctionDefinition).
                         ROSE_ASSERT(storedGlobalScope != NULL);

                         string mangledName = mangleableNode->get_mangled_name();
                      // printf ("mangledName = %s \n",mangledName.c_str());

                         std::map<SgNode*,std::string> & mangledNameCache = storedGlobalScope->get_mangledNameCache();
                         mangledNameCache.insert(pair<SgNode*,std::string>(mangleableNode,mangledName));
#if 0
                         string nodeName = get_name(mangleableNode);
                         printf ("At node = %p = %s = %s in local map (size = %d) \n",
                              mangleableNode,mangleableNode->class_name().c_str(),nodeName.c_str(),mangledNameCache.size());
#endif
                       }
                  }

          private:
               SgGlobal* storedGlobalScope;
        };

    // Now buid the traveral object and call the traversal (preorder) on the function definition.
       MangledNameTraversal traversal;
       traversal.traverse(globalScope, preorder);
   }
#endif


string
SageInterface::getMangledNameFromCache( SgNode* astNode )
   {
  // The TransformationSupport is not defined yet (I forget the
  // details but I recall that there is a reason why this is this way).
  // SgGlobal* globalScope = TransformationSupport::getGlobalScope(astNode);
#if 0
     SgGlobal* globalScope = isSgGlobal(astNode);

     if (globalScope == NULL && isSgFile(astNode) != NULL)
        {
          globalScope = isSgFile(astNode)->get_globalScope();
          ROSE_ASSERT(globalScope != NULL);
        }

     if (globalScope == NULL && isSgProject(astNode) != NULL)
        {
       // Check to make sure that the SgFile can be uniquely determined
          ROSE_ASSERT( isSgProject(astNode)->get_fileList()->size() == 1 );
          globalScope = isSgProject(astNode)->get_fileList()->operator[](0)->get_globalScope();
          ROSE_ASSERT(globalScope != NULL);
        }

     SgNode* temp = astNode;
     while (temp->get_parent() != NULL && globalScope == NULL)
        {
          temp = temp->get_parent();
          globalScope = isSgGlobal(temp);
        }
     ROSE_ASSERT(globalScope != NULL);
#endif

  // std::map<SgNode*,std::string> & mangledNameCache = globalScope->get_mangledNameCache();
     std::map<SgNode*,std::string> & mangledNameCache = SgNode::get_globalMangledNameMap();

  // Build an iterator
     std::map<SgNode*,std::string>::iterator i = mangledNameCache.find(astNode);

     string mangledName;
     if (i != mangledNameCache.end())
        {
       // get the precomputed mangled name!
       // printf ("Mangled name IS found in cache (node = %p = %s) \n",astNode,astNode->class_name().c_str());
          mangledName = i->second;
        }
       else
        {
       // mangled name not found in cache!
       // printf ("Mangled name NOT found in cache (node = %p = %s) \n",astNode,astNode->class_name().c_str());
        }

     return mangledName;
   }

std::string
SageInterface::addMangledNameToCache( SgNode* astNode, const std::string & oldMangledName)
   {
#if 0
     SgGlobal* globalScope = isSgGlobal(astNode);

     if (globalScope == NULL && isSgFile(astNode) != NULL)
        {
          globalScope = isSgFile(astNode)->get_globalScope();
          ROSE_ASSERT(globalScope != NULL);
        }

     if (globalScope == NULL && isSgProject(astNode) != NULL)
        {
       // Check to make sure that the SgFile can be uniquely determined
          ROSE_ASSERT( isSgProject(astNode)->get_fileList()->size() == 1 );
          globalScope = isSgProject(astNode)->get_fileList()->operator[](0)->get_globalScope();
          ROSE_ASSERT(globalScope != NULL);
        }

     SgNode* temp = astNode;
     while (temp->get_parent() != NULL && globalScope == NULL)
        {
          temp = temp->get_parent();
          globalScope = isSgGlobal(temp);
        }
     ROSE_ASSERT(globalScope != NULL);
#endif

  // std::map<SgNode*,std::string> & mangledNameCache = globalScope->get_mangledNameCache();
  // std::map<std::string, int> & shortMangledNameCache = globalScope->get_shortMangledNameCache();
     std::map<SgNode*,std::string> & mangledNameCache   = SgNode::get_globalMangledNameMap();
     std::map<std::string, int> & shortMangledNameCache = SgNode::get_shortMangledNameCache();

     std::string mangledName;

#define USE_SHORT_MANGLED_NAMES 1
#if USE_SHORT_MANGLED_NAMES
  // This bound was 40 previously!
     if (oldMangledName.size() > 40) {
       std::map<std::string, int>::const_iterator shortMNIter = shortMangledNameCache.find(oldMangledName);
       int idNumber = (int)shortMangledNameCache.size();
       if (shortMNIter != shortMangledNameCache.end())
          {
            idNumber = shortMNIter->second;
          }
         else
          {
            shortMangledNameCache.insert(std::pair<std::string, int>(oldMangledName, idNumber));
          }

       std::ostringstream mn;
       mn << 'L' << idNumber << 'R';
       mangledName = mn.str();
     } else {
       mangledName = oldMangledName;
     }
#else
     mangledName = oldMangledName;
#endif

  // DQ (6/26/2007): Output information useful for understanding Jeremiah's shortended name merge caching.
  // std::cerr << "Changed MN " << oldMangledName << " to " << mangledName << std::endl;

#if 0
     printf ("Updating mangled name cache for node = %p = %s with mangledName = %s \n",astNode,astNode->class_name().c_str(),mangledName.c_str());
#endif

     mangledNameCache.insert(pair<SgNode*,string>(astNode,mangledName));

  // printf ("In SageInterface::addMangledNameToCache(): returning mangledName = %s \n",mangledName.c_str());

     return mangledName;
   }


// #endif

#ifndef USE_ROSE

bool
SageInterface::declarationPreceedsDefinition ( SgDeclarationStatement* nonDefiningDeclaration, SgDeclarationStatement* definingDeclaration )
   {
  // This function is used in the unparser, but might be more generally useful.  Since it is
  // related to general AST tests, I have put it here.  It might be alternatively put in the
  // src/backend/unparser or related utility directory.

  // Preorder traversal to test the order of declaration of non-defining vs. defining class
  // declarations in the preorder traversal of the AST.
     class DeclarationOrderTraversal : public AstSimpleProcessing
        {
          public:
               DeclarationOrderTraversal( SgDeclarationStatement* nonDefiningDeclaration, SgDeclarationStatement* definingDeclaration )
                  : storedNondefiningDeclaration(nonDefiningDeclaration),
                    storedDefiningDeclaration(definingDeclaration)
                  {
                    storedDeclarationFound                            = false;
                    nonDefiningDeclarationPreceedsDefiningDeclaration = false;
                  }

               void visit (SgNode* node)
                  {
                    ROSE_ASSERT(storedNondefiningDeclaration != NULL);
                    ROSE_ASSERT(storedDefiningDeclaration != NULL);
                    ROSE_ASSERT(storedNondefiningDeclaration != storedDefiningDeclaration);
                 // ROSE_ASSERT(storedNondefiningDeclaration->get_definingDeclaration() == storedDefiningDeclaration);

                 // Even though we only care about the SgClassDeclaration IR nodes we have to traverse them
                 // in the AST in the order defined by the traversal (order of apprearance in the AST).  We
                 // also can't just search the declarations of a single scope (since the nondefining declaration
                 // can appear in a different scope than the defining declaration).
                    SgDeclarationStatement* declaration = isSgDeclarationStatement(node);
                    if ( declaration != NULL )
                       {
                      // if (classDeclaration == storedNondefiningDeclaration && neitherStoredDeclarationFound == true)
                         if (storedDeclarationFound == false)
                            {
                              if (declaration == storedDefiningDeclaration)
                                 {
                                   storedDeclarationFound = true;
                                   nonDefiningDeclarationPreceedsDefiningDeclaration = false;
                                 }
                              if (declaration == storedNondefiningDeclaration)
                                 {
                                   storedDeclarationFound = true;
                                   nonDefiningDeclarationPreceedsDefiningDeclaration = true;
                                 }
                            }
                       }
                  }

          public:
               bool storedDeclarationFound;
               bool nonDefiningDeclarationPreceedsDefiningDeclaration;

          private:
               SgDeclarationStatement* storedNondefiningDeclaration;
               SgDeclarationStatement* storedDefiningDeclaration;
        };

     ROSE_ASSERT(nonDefiningDeclaration != NULL);
#if 0
     printf ("In SageInterface::declarationPreceedsDefinition(): \n");
     printf ("     nondefiningDeclaration                            = %p = %s \n",nonDefiningDeclaration,nonDefiningDeclaration->class_name().c_str());
     nonDefiningDeclaration->get_file_info()->display("nonDefiningDeclaration");
     printf ("     nondefiningDeclaration->get_definingDeclaration() = %p \n",nonDefiningDeclaration->get_definingDeclaration());
     printf ("     definingDeclaration                               = %p = %s \n",definingDeclaration,definingDeclaration->class_name().c_str());
     definingDeclaration->get_file_info()->display("definingDeclaration");
     printf ("************************************************************* \n");
#endif

#if 0
  // The nonDefiningDeclaration can be a different type of declaration than the definingDeclaration
     if (nonDefiningDeclaration->get_definingDeclaration() != definingDeclaration)
        {
          printf ("In SageInterface::declarationPreceedsDefinition() (warning): \n");
          printf ("     nondefiningDeclaration                            = %p \n",nonDefiningDeclaration);
          printf ("     nondefiningDeclaration->get_definingDeclaration() = %p \n",nonDefiningDeclaration->get_definingDeclaration());
          printf ("     definingDeclaration                               = %p \n",definingDeclaration);
        }
#endif

  // define trival case of classNonDefiningDeclaration == classDefiningDeclaration to be false.
     bool returnResult = false;
     if (nonDefiningDeclaration != definingDeclaration)
        {
       // Get the global scope from a traversal back (up) through the AST.
          SgGlobal* globalScope = TransformationSupport::getGlobalScope(definingDeclaration);
          ROSE_ASSERT(globalScope != NULL);

       // Now buid the traveral object and call the traversal (preorder) on the function definition.
          DeclarationOrderTraversal traversal (nonDefiningDeclaration,definingDeclaration);

#if 0
          traversal.traverse(globalScope, preorder);
#else
       // DQ (5/29/2007): To avoid order n^2 complexity in unparsing we turn off the name qualification for now.
          printf ("Skipping traversal within SageInterface::declarationPreceedsDefinition() \n");
          traversal.storedDeclarationFound = true;
          traversal.nonDefiningDeclarationPreceedsDefiningDeclaration = false;
#endif

       // I hope that we have found the input nondefining or defining declaration, if not let it be an error
       // for now.  There may however be good reasons why we might miss them (hidden island problem, or
       // nondefining declarations that are not in the traversal).

          if (traversal.storedDeclarationFound == false)
             {
#if 0
               printf ("In SageInterface::declarationPreceedsDefinition(): warning, nonDefiningDeclaration not found in the AST \n");
               nonDefiningDeclaration->get_file_info()->display("nonDefiningDeclaration");
               definingDeclaration->get_file_info()->display("definingDeclaration");
               printf ("---------------------------------------------------- \n\n");
#endif
            // Set this error case to return true so that we will not assume incorrectly
            // that the classNonDefiningDeclaration apears after the classDefiningDeclaration.
               returnResult = true;
             }
            else
             {
               returnResult = traversal.nonDefiningDeclarationPreceedsDefiningDeclaration;
             }

       // ROSE_ASSERT(traversal.storedDeclarationFound == true);
        }
#if 0
     printf ("returnResult = %s \n",returnResult ? "true" : "false");
     printf ("************************************************************* \n\n");
#endif
     return returnResult;
   }


bool
SageInterface::functionCallExpressionPreceedsDeclarationWhichAssociatesScope ( SgFunctionCallExp* functionCall )
   {
  // This function is used in the unparser, but might be more generally useful.  Since it is
  // related to general AST tests, I have put it here.  It might be alternatively put in the
  // src/backend/unparser or related utility directory.

  // Preorder traversal to test the order of declaration of non-defining vs. defining class
  // declarations in the preorder traversal of the AST.
     class DeclarationOrderTraversal : public AstSimpleProcessing
        {
          public:
               DeclarationOrderTraversal( SgFunctionCallExp* functionCall )
                  : storedFunctionCall(functionCall)
                  {
                    ROSE_ASSERT(functionCall != NULL);
                    ROSE_ASSERT(functionCall->get_function() != NULL);
                    SgExpression* functionExpression = functionCall->get_function();

                    switch (functionExpression->variantT())
                       {
                      // these are the acceptable cases
                         case V_SgDotExp:
                         case V_SgDotStarOp:
                         case V_SgArrowExp:
                         case V_SgArrowStarOp:
                         case V_SgPointerDerefExp:
                            {
                           // These are the acceptable cases, but not handled yet.
                              printf ("These are the acceptable cases, but not handled yet... \n");
                              ROSE_ASSERT(false);
                              break;
                            }

                         case V_SgFunctionRefExp:
                            {
                              SgFunctionRefExp* functionRefExp = isSgFunctionRefExp(functionExpression);
                              ROSE_ASSERT(functionRefExp != NULL);
                              SgFunctionSymbol* functionSymbol = functionRefExp->get_symbol();
                              ROSE_ASSERT(functionSymbol != NULL);

                           // Make sure that the function has a valid declaration
                              ROSE_ASSERT(functionSymbol->get_declaration() != NULL);
                              storedFunctionDeclaration = functionSymbol->get_declaration();
                              break;
                            }

                         case V_SgMemberFunctionRefExp:
                            {
                              SgMemberFunctionRefExp* memberFunctionRefExp = isSgMemberFunctionRefExp(functionExpression);
                              ROSE_ASSERT(memberFunctionRefExp != NULL);
                              SgMemberFunctionSymbol* memberFunctionSymbol = memberFunctionRefExp->get_symbol();
                              ROSE_ASSERT(memberFunctionSymbol != NULL);

                              storedFunctionDeclaration = memberFunctionSymbol->get_declaration();

                              printf ("V_SgMemberFunctionRefExp case not handled yet... \n");
                              ROSE_ASSERT(false);
                            }

                         default:
                            {
                              printf ("default reached in SageInterface::functionCallExpressionPreceedsDeclarationWhichAssociatesScope() functionExpression = %s \n",
                                   functionExpression->class_name().c_str());
                              ROSE_ASSERT(false);
                            }
                       }
                 // ROSE_ASSERT(functionCall->get_declaration() != NULL);
                 // ROSE_ASSERT(functionCall->get_function()->get_firstNondefiningDeclaration() != NULL);
                 // storedFunctionDeclaration = functionCall->get_declaration()->get_firstNondefiningDeclaration();
                    ROSE_ASSERT(storedFunctionDeclaration != NULL);

                    storedFunctionCallFound                                       = false;
                    functionCallExpressionPreceedsDeclarationWhichAssociatesScope = false;
                  }

               void visit (SgNode* node)
                  {
                    ROSE_ASSERT(storedFunctionCall != NULL);
                    ROSE_ASSERT(storedFunctionDeclaration != NULL);
                 // ROSE_ASSERT(storedFunctionCall != storedFunctionDeclaration);

                    if (storedFunctionCallFound == false)
                       {
                         SgFunctionCallExp* functionCall = isSgFunctionCallExp(node);
                         if ( functionCall != NULL )
                            {
                              if (functionCall == storedFunctionCall)
                                 {
                                   storedFunctionCallFound = true;

                                // A declaration for the function in a scope where the function could be defined
                                // (and a scope associated with it) has not been found so the function call
                                // preceeds such a declaration (if it even exists).
                                   functionCallExpressionPreceedsDeclarationWhichAssociatesScope = true;
                                 }
                            }

                         SgDeclarationStatement* declaration = isSgDeclarationStatement(node);
                         ROSE_ASSERT(storedFunctionDeclaration != NULL);

                      // Note that all firstNondefiningDeclaration are set to the same declaration (for all associated declarations).
                      // Need to check the result of get_firstNondefiningDeclaration() since this will be the same for all declarations
                      // of the same function and thus can be used to match that we have an associated declaration for the same function.
                      // if ( declaration != NULL && declaration->get_firstNondefiningDeclaration() == storedFunctionDeclaration)
                         if ( declaration != NULL && declaration->get_firstNondefiningDeclaration() == storedFunctionDeclaration->get_firstNondefiningDeclaration())
                            {
                           // Test if this is a declaration is a scope where the existance of the forward
                           // declaration will define the scope fo the function declaration.
                           // if (declaration->get_scope()->supportsDefiningFunctionDeclaration() == true)
                              SgScopeStatement* parentScopeOfDeclaration = isSgScopeStatement(declaration->get_parent());
                              if (parentScopeOfDeclaration != NULL && parentScopeOfDeclaration->supportsDefiningFunctionDeclaration() == true)
                                 {
                                // We are done so we can skip further testing
                                   storedFunctionCallFound = true;

                                // We have found a declaration which will associated the scope of a function declaration
                                // (so all function calls after this point can be qualified (and might have to be).
                                   functionCallExpressionPreceedsDeclarationWhichAssociatesScope = false;
#if 0
                                   printf ("Found a declaration which preceeds the function \n");
                                   declaration->get_file_info()->display("Found a declaration which preceeds the function: declaration");
                                   storedFunctionCall->get_file_info()->display("Found a declaration which preceeds the function: storedFunctionCall");
                                   storedFunctionDeclaration->get_file_info()->display("Found a declaration which preceeds the function: storedFunctionDeclaration");
#endif
                                 }
                                else
                                 {
                                // Error checking!
                                   if (parentScopeOfDeclaration == NULL)
                                      {
                                     // This might be a function declaration (non-defining) used in a type or buried deeply in some sort of declaration!
                                        printf ("Strange case of parentScopeOfDeclaration == NULL in SageInterface::functionCallExpressionPreceedsDeclarationWhichAssociatesScope() \n");
                                        printf ("declaration->get_parent() = %s \n",declaration->get_parent()->class_name().c_str());
                                        declaration->get_file_info()->display("case of parentScopeOfDeclaration == NULL");
                                        ROSE_ASSERT(false);
                                      }
                                 }
                            }
                       }
                  }

          public:
               bool storedFunctionCallFound;
               bool functionCallExpressionPreceedsDeclarationWhichAssociatesScope;

          private:
               SgFunctionCallExp* storedFunctionCall;
               SgDeclarationStatement* storedFunctionDeclaration;
        };

     ROSE_ASSERT(functionCall != NULL);
#if 0
     printf ("In SageInterface::functionCallExpressionPreceedsDeclarationWhichAssociatesScope(): \n");
     printf ("     storedFunctionCall                           = %p = %s \n",functionCall,functionCall->class_name().c_str());
     functionCall->get_file_info()->display("storedFunctionCall");
     printf ("     storedFunctionCall->get_function() = %p = %s \n",functionCall->get_function(),functionCall->get_function()->class_name().c_str());
     printf ("************************************************************* \n");
#endif

  // define trival case of classNonDefiningDeclaration == classDefiningDeclaration to be false.
     bool returnResult = false;

  // Get the global scope from a traversal back (up) through the AST.
     SgGlobal* globalScope = TransformationSupport::getGlobalScope(functionCall);
     ROSE_ASSERT(globalScope != NULL);

  // Now buid the traveral object and call the traversal (preorder) on the function definition.
     DeclarationOrderTraversal traversal (functionCall);

#if 0
     traversal.traverse(globalScope, preorder);
#else
  // DQ (5/29/2007): To avoid order n^2 complexity in unparsing we turn off the name qualification for now.
     printf ("Skipping traversal within SageInterface::functionCallExpressionPreceedsDeclarationWhichAssociatesScope() \n");
     traversal.storedFunctionCallFound = true;
     traversal.functionCallExpressionPreceedsDeclarationWhichAssociatesScope = false;
#endif

  // I hope that we have found the input nondefining or defining declaration, if not let it be an error
  // for now.  There may however be good reasons why we might miss them (hidden island problem, or
  // nondefining declarations that are not in the traversal).

     if (traversal.storedFunctionCallFound == false)
        {
#if 0
          printf ("In SageInterface::functionCallExpressionPreceedsDeclarationWhichAssociatesScope(): warning, storedFunctionCall not found in the AST \n");
          functionCall->get_file_info()->display("functionCall");
          printf ("---------------------------------------------------- \n\n");
#endif
       // Set this error case to return true so that we will not assume incorrectly
       // that the function call is used after a declaration that associated the scope
       // with the function.  This still causes the global name qualifier to be omitted.
          returnResult = true;
        }
       else
        {
          returnResult = traversal.functionCallExpressionPreceedsDeclarationWhichAssociatesScope;
        }

  // I hope that this is nearly always be true!
     ROSE_ASSERT(traversal.storedFunctionCallFound == true);
#if 0
     printf ("returnResult = %s \n",returnResult ? "true" : "false");
     printf ("************************************************************* \n\n");
#endif
     return returnResult;
   }

#endif

// #ifndef USE_ROSE

string
SageInterface::generateProjectName( const SgProject* project, bool supressSuffix )
   {
  // This function generates a string to use as a unique project name for
  // a collection of files.  The last file will include it's suffix so that
  // we generate proper names that communicate the source language.
  // Also also allows the single file case to be consistant with the previous
  // version of names generated for "DOT" files in the tutorial.

  // DQ (9/6/2008): Introduced optional parameter to supresse the suffix in the
  // generation of the project name so that we can support more complex name
  // construction as required for the generation of names for the whole AST
  // graphs which append an additional suffix to avoid filename collision.

     ROSE_ASSERT(project != NULL);
     string projectName;

  // DQ (9/2/2008): Removed the redundant function getFileNames().
  // Rose_STL_Container<string> fileList = project->get_sourceFileNameList();
     Rose_STL_Container<string> fileList = project->getAbsolutePathFileNames();

     Rose_STL_Container<string>::iterator i = fileList.begin();

  // Handle the case of an empty list (e.g. for link lines).
     if ( fileList.empty() == true )
        {
          return "empty_file_list";
        }

     do {
          string filename = *i;

       // printf ("In SageInterface::generateProjectName(): absolute filename = %s \n",filename.c_str());

       // string filenameWithoutSuffix       = StringUtility::stripFileSuffixFromFileName(filename);

          if (i != fileList.begin())
               projectName += "--";

          i++;

          string filenameWithoutSuffix;
          if ( i != fileList.end() || supressSuffix == true )
               filenameWithoutSuffix = StringUtility::stripFileSuffixFromFileName(filename);
            else
               filenameWithoutSuffix = filename;

          string filenameWithoutPathOrSuffix = StringUtility::stripPathFromFileName(filenameWithoutSuffix);

       // printf ("filenameWithoutSuffix       = %s \n",filenameWithoutSuffix.c_str());
       // printf ("filenameWithoutPathOrSuffix = %s \n",filenameWithoutPathOrSuffix.c_str());

          filename = filenameWithoutPathOrSuffix;

          unsigned long int n = 0;
          while (n < filename.size())
             {
               if (filename[n] == '/')
                    filename[n] = '_';
               n++;
             }

       // printf ("In SageInterface:generateProjectName(): modified absolute filename = %s \n",filename.c_str());

          projectName += filename;

       // printf ("In SageInterface:generateProjectName(): evolving projectName = %s \n",projectName.c_str());
        }
     while (i != fileList.end());

  // printf ("In SageInterface:generateProjectName(): projectName = %s \n",projectName.c_str());

     return projectName;
   }

// #endif

// #ifndef USE_ROSE

SgFunctionSymbol*
SageInterface::lookupFunctionSymbolInParentScopes(const SgName & functionName, SgScopeStatement* currentScope )
   {
  // DQ (11/24/2007): This function can return NULL.  It returns NULL when the function symbol is not found.
  // This can happen when a function is referenced before it it defined (no prototype mechanism in Fortran is required).

  // enable default search from top of StackScope, Liao, 1/24/2008
     SgFunctionSymbol* functionSymbol = NULL;
     if (currentScope == NULL)
          currentScope = SageBuilder::topScopeStack();
     ROSE_ASSERT(currentScope != NULL);

     SgScopeStatement* tempScope = currentScope;
     while ((functionSymbol == NULL) && (tempScope != NULL))
        {
          functionSymbol = tempScope->lookup_function_symbol(functionName);

          if (tempScope->get_parent()!=NULL) // avoid calling get_scope when parent is not set in middle of translation
               tempScope = isSgGlobal(tempScope) ? NULL : tempScope->get_scope();
            else
               tempScope = NULL;
        }
     return functionSymbol;
   }


void
SageInterface::addTextForUnparser ( SgNode* astNode, string s, AstUnparseAttribute::RelativePositionType inputlocation )
   {
    // printf ("addText(): using new attribute interface (s = %s) \n",s.c_str());

     if (isSgType(astNode) != NULL)
        {
          printf ("Error: the mechanism to add text to be unparsed at IR nodes is not intended to operate on SgType IR nodes (since they are shared) \n");
          ROSE_ASSERT(false);
        }

     if (astNode->attributeExists(AstUnparseAttribute::markerName) == true)
        {
          AstUnparseAttribute* code = dynamic_cast<AstUnparseAttribute*>(astNode->getAttribute(AstUnparseAttribute::markerName));
          ROSE_ASSERT(code != NULL);

       // DQ (2/23/2009): commented added.
       // Since there is at least one other string (there is an existing attribute) the relative order of the strings is significant.
          code->addString(s,inputlocation);
        }
       else
        {
       // DQ (2/23/2009): commented added.
       // Note that this will be the only string in the attribute, so inputlocation is not significant (and e_before is the default used).
          AstUnparseAttribute* code = new AstUnparseAttribute(s,AstUnparseAttribute::e_before);
          ROSE_ASSERT(code != NULL);

          astNode->addNewAttribute(AstUnparseAttribute::markerName,code);
        }
   }






SgType* SageInterface::lookupNamedTypeInParentScopes(const std::string& type_name, SgScopeStatement* scope/*=NULL*/)
{
  if (scope== NULL)
          scope= SageBuilder::topScopeStack();
  SgSymbol* symbol = lookupSymbolInParentScopes (type_name,scope);
  if (symbol==NULL) return NULL;
  else return symbol->get_type();
}

SgFunctionSymbol *SageInterface::lookupFunctionSymbolInParentScopes (const SgName &functionName,
                                                        const SgType* t,
                                                        SgScopeStatement *currentScope)
                                                        //SgScopeStatement *currentScope=NULL)
{
    SgFunctionSymbol* functionSymbol = NULL;
    if (currentScope == NULL)
        currentScope = SageBuilder::topScopeStack();   
    ROSE_ASSERT(currentScope != NULL);
    SgScopeStatement* tempScope = currentScope;
    while (functionSymbol == NULL && tempScope != NULL)
    {
        functionSymbol = tempScope->lookup_function_symbol(functionName,t);
        if (tempScope->get_parent()!=NULL) // avoid calling get_scope when parent is not set
            tempScope = isSgGlobal(tempScope) ? NULL : tempScope->get_scope();
        else tempScope = NULL;
    }
    return functionSymbol;
}

// Liao, 1/22/2008
// SgScopeStatement* SgStatement::get_scope
// SgScopeStatement* SgStatement::get_scope() assumes all parent pointers are set, which is
// not always true during translation.
SgSymbol *SageInterface:: lookupSymbolInParentScopes (const SgName &  name,
        SgScopeStatement *cscope)
{
    SgSymbol* symbol = NULL;
    if (cscope == NULL)
        cscope = SageBuilder::topScopeStack(); 
    ROSE_ASSERT(cscope);

    while ((cscope!=NULL)&&(symbol==NULL))
    {
        symbol = cscope->lookup_symbol(name);
        //debug
        // cscope->print_symboltable("debug sageInterface.C L3749...");
        if (cscope->get_parent()!=NULL) // avoid calling get_scope when parent is not set
            cscope = isSgGlobal(cscope) ? NULL : cscope->get_scope();
        else 
            cscope = NULL;
    }

    if (symbol==NULL)
    {
        //    printf ("Warning: could not locate the specified name %s in any outer symbol table \n"e,
        //	name.str());
        //  ROSE_ASSERT(false); 
    }
    return symbol;
}

SgVariableSymbol *
SageInterface::lookupVariableSymbolInParentScopes (const SgName &  name,
                                                        SgScopeStatement *cscope)
   {
  // DQ (1/24/2011): This function is inconsistant with an implementation that would correctly handle SgAliasSymbols.
  // Also this function might get a SgClassSymbol instead of a SgVariableSymbol when both names are used.
  // This function needs to be fixed to handle the multi-map semantics of the symbol tables.
     SgVariableSymbol* result = NULL;
     SgSymbol* symbol=lookupSymbolInParentScopes(name,cscope);
     if (symbol != NULL)
        {
          if (isSgAliasSymbol(symbol) != NULL)
             {
               printf ("Error: This SageInterface::lookupVariableSymbolInParentScopes() function does not handle SgAliasSymbols \n");
               ROSE_ASSERT(false);
             }
          result = isSgVariableSymbol(symbol);
        }
     return result;
   }

void
SageInterface::setSourcePosition( SgLocatedNode* locatedNode )
   {
  // DQ (1/24/2009): It might be thst this function is only called from the Fortran support.

  // This function sets the source position to be marked as not
  // available (since we often don't have token information)
  // These nodes WILL be unparsed in the conde generation phase.

  // The SgLocatedNode has both a startOfConstruct and endOfConstruct source position.
     ROSE_ASSERT(locatedNode != NULL);

  // Check the endOfConstruct forst since it is most likely NULL (helpful in debugging)
     ROSE_ASSERT(locatedNode->get_endOfConstruct()   == NULL);
     ROSE_ASSERT(locatedNode->get_startOfConstruct() == NULL);

     Sg_File_Info* start_fileInfo = Sg_File_Info::generateDefaultFileInfo();
     Sg_File_Info* end_fileInfo   = Sg_File_Info::generateDefaultFileInfo();

     start_fileInfo->setSourcePositionUnavailableInFrontend();
     end_fileInfo->setSourcePositionUnavailableInFrontend();

  // This is required for the unparser to output the code from the AST.
     start_fileInfo->setOutputInCodeGeneration();
     end_fileInfo->setOutputInCodeGeneration();

     locatedNode->set_startOfConstruct(start_fileInfo);
     locatedNode->set_endOfConstruct  (end_fileInfo);

     locatedNode->get_startOfConstruct()->set_parent(locatedNode);
     locatedNode->get_endOfConstruct  ()->set_parent(locatedNode);
   }

void
SageInterface::setOneSourcePositionForTransformation(SgNode *node)
   {
  // DQ (1/24/2009): I think this should be renamed to be "setSourcePositionAsTransformation(SgNode *node)"
  // The logic should be make more independent of if (locatedNode->get_startOfConstruct() == NULL)
  // Since that make understanding where the function is applied too complex.
  // If (locatedNode->get_startOfConstruct() != NULL), then we should just make that Sg_File_Info as
  // a transforamtion directly, this function misses that step.

     ROSE_ASSERT(node != NULL);

     SgLocatedNode*     locatedNode = isSgLocatedNode(node);
     SgExpression*      expression  = isSgExpression(node);
//     SgInitializedName* initName    = isSgInitializedName(node);
     SgPragma*          pragma      = isSgPragma(node); // missed this one!! Liao, 1/30/2008
     SgGlobal*          global      = isSgGlobal(node); // SgGlobal should have NULL endOfConstruct()

#if 0
     SgVariableDefinition * v_d = isSgVariableDefinition(node);
     if (v_d )
       printf ("Debug, Found a variable definition: %p\n", v_d);
#endif
  // if ((locatedNode) && (locatedNode->get_endOfConstruct() == NULL))
  //   if ( (locatedNode != NULL) && (locatedNode->get_startOfConstruct() == NULL) )
     if (locatedNode != NULL)
        {
          locatedNode->set_startOfConstruct(Sg_File_Info::generateDefaultFileInfoForTransformationNode());
          locatedNode->get_startOfConstruct()->set_parent(locatedNode);

          if (global==NULL)
             {
               locatedNode->set_endOfConstruct(Sg_File_Info::generateDefaultFileInfoForTransformationNode());
               locatedNode->get_endOfConstruct  ()->set_parent(locatedNode);
             }

       // Only SgExpression IR nodes have a 3rd source position data structure.
          if (expression!=NULL)
             {
               expression->set_operatorPosition(Sg_File_Info::generateDefaultFileInfoForTransformationNode());
               expression->get_operatorPosition()->set_parent(expression);
             }
        }
       else // special non-located node with file info
       {
//         if ( (initName != NULL) && (initName->get_startOfConstruct() == NULL) )
//         {
//           locatedNode->set_startOfConstruct(Sg_File_Info::generateDefaultFileInfoForTransformationNode());
//           locatedNode->get_startOfConstruct()->set_parent(locatedNode);
//
//           locatedNode->set_endOfConstruct(Sg_File_Info::generateDefaultFileInfoForTransformationNode());
//           locatedNode->get_endOfConstruct  ()->set_parent(locatedNode);
//
//         }
//         else  
           if ( (pragma != NULL) && (pragma->get_startOfConstruct() == NULL) )
         {
           pragma->set_startOfConstruct(Sg_File_Info::generateDefaultFileInfoForTransformationNode());
           pragma->get_startOfConstruct()->set_parent(pragma);
         }
       }
   }


void
SageInterface::setOneSourcePositionNull(SgNode *node)
   {
  // DQ (1/24/2009): I think this should be renamed to be "setSourcePositionToNULL(SgNode *node)"
  // However, if this is doen then the logic should be that it asserts that: (locatedNode->get_startOfConstruct() == NULL)
  // so that we know when we are leaking memory.  Similarly, we should assert that:
  // (locatedNode->get_endOfConstruct() == NULL).
  // But then this function just asserts that everything is already NULL and is less about setting them to NULL.
  // If (locatedNode->get_startOfConstruct() != NULL), should we delete the existing Sg_File_Info object?
  // This function misses that step.

     ROSE_ASSERT(node != NULL);

     SgLocatedNode *    locatedNode = isSgLocatedNode(node);
     SgExpression*      expression  = isSgExpression(node);
//     SgInitializedName* initName    = isSgInitializedName(node);
     SgPragma*          pragma      = isSgPragma(node); // missed this one!! Liao, 1/30/2008
     SgGlobal*          global      = isSgGlobal(node); // SgGlobal should have NULL endOfConstruct()

  // DQ (1/24/2009): If the point is to set the source position to NULL pointers,
  // why do we only handle the case when (get_startOfConstruct() == NULL)
  // (i.e. when the start source postion is already NULL).

  // if ((locatedNode) && (locatedNode->get_endOfConstruct() == NULL))
  //   if ( (locatedNode != NULL) && (locatedNode->get_startOfConstruct() == NULL) )
     if  (locatedNode != NULL) 
        {
          locatedNode->set_startOfConstruct(NULL);

       // Note that SgGlobal should have NULL endOfConstruct()
          if (global == NULL)
             {
               locatedNode->set_endOfConstruct(NULL);
             }

       // Only SgExpression IR nodes have a 3rd source position data structure.
          if (expression != NULL)
             {
               expression->set_operatorPosition(NULL);
             }
        }
       else
        {
//          if ( (initName != NULL) && (initName->get_startOfConstruct() == NULL) )
//             { //  no endOfConstruct for SgInitializedName
//               initName->set_startOfConstruct(NULL);
//             }
//            else
               if ( (pragma != NULL) && (pragma->get_startOfConstruct() == NULL) )
                  {
                    pragma->set_startOfConstruct(NULL);
                  }
        }
   }


// DQ (1/24/2009): Could we change the name to be "setSourcePositionAtRootAndAllChildrenAsTransformation(SgNode *root)"
void
SageInterface::setSourcePositionForTransformation(SgNode *root)
   {
     Rose_STL_Container <SgNode*> nodeList= NodeQuery::querySubTree(root,V_SgNode);
     for (Rose_STL_Container<SgNode *>::iterator i = nodeList.begin(); i!=nodeList.end(); i++ )
        {
          setOneSourcePositionForTransformation(*i);
        }
   }


void
SageInterface::setSourcePositionForTransformation_memoryPool()
   {
  // DQ (1/24/2009): This seems like a very dangerous function to have, is it required!

     VariantVector vv(V_SgNode);
     Rose_STL_Container<SgNode*> nodeList = NodeQuery::queryMemoryPool(vv);
     for (Rose_STL_Container<SgNode *>::iterator i = nodeList.begin(); i != nodeList.end(); i++ )
        {
          setOneSourcePositionForTransformation(*i);
        }
   }


SgGlobal * SageInterface::getFirstGlobalScope(SgProject *project)
   {
  // Liao, 1/9/2008, get the first global scope from current project
  // mostly used to prepare for AST construction under the global scope
     ROSE_ASSERT(project != NULL);

  // DQ (1/24/2009): Added a check to make sure STL list is non-empty.
     ROSE_ASSERT(project->get_fileList().empty() == false);

  // SgGlobal* global = project->get_file(0).get_root();
     SgSourceFile* file = isSgSourceFile(project->get_fileList()[0]);
     SgGlobal* global = file->get_globalScope();

#if 0
     SgFilePtrListPtr fileList = project->get_fileList();
     SgFilePtrList::const_iterator i= fileList->begin();

     SgGlobal* global = (*i)->get_globalScope();
#endif
     ROSE_ASSERT(global != NULL);

     return global;
   }

// Liao, 1/10/2008, get the last stmt from the scope
// two cases
//      SgScopeStatement::getDeclarationList
//      SgScopeStatement::getStatementList()
SgStatement* SageInterface::getLastStatement(SgScopeStatement *scope)
{
  ROSE_ASSERT(scope);
  SgStatement* stmt=NULL;

  if (scope->containsOnlyDeclarations())
  {
    SgDeclarationStatementPtrList declList = scope->getDeclarationList();
    if (declList.size()>0)
       stmt = isSgStatement(declList.back());
  }
  else
  {
    SgStatementPtrList stmtList = scope->getStatementList();
    if (stmtList.size()>0)
      stmt = stmtList.back();
  }
  return stmt;
}

SgStatement* SageInterface::getFirstStatement(SgScopeStatement *scope, bool includingCompilerGenerated/*=false*/)
{
  ROSE_ASSERT(scope);
  SgStatement* stmt=NULL;

  if (scope->containsOnlyDeclarations())
    {
   // DQ Note: Do we really need to make a copy of the list just to return a pointer to the first entry?
      SgDeclarationStatementPtrList declList = scope->getDeclarationList();
      if (includingCompilerGenerated)
      {
       // DQ Note: (declList.empty() == false) is a much faster test  O(1) than (declList.size() > 0), which is O(n).
          if (declList.size()>0)
             stmt = isSgStatement(declList.front());
      } else
      { //skip compiler-generated declarations
        SgDeclarationStatementPtrList::iterator i=declList.begin();
        while (i!=declList.end())
        {  //isCompilerGenerated(),isOutputInCodeGeneration(),etc. are not good enough,
           //some content from headers included are not marked as compiler-generated
           //
           // cout<<(*i)->unparseToString()<<endl;
           // ((*i)->get_file_info())->display("debug.......");
           Sg_File_Info * fileInfo = (*i)->get_file_info();
          // include transformation-generated  statements, but not the hidden ones
        // Note: isOutputInCodeGeneration is not default to true for original statements from user code
         if ((fileInfo->isSameFile(scope->get_file_info()))||
              (fileInfo->isTransformation()&& fileInfo->isOutputInCodeGeneration())
            )
            {
              stmt=*i;
              break;
            } else
            {
              i++;
              continue;
            }
        }
      }
    }
  else
  {
 // DQ Note: Do we really need to make a copy of the list just to return a pointer to the first entry?
    SgStatementPtrList stmtList = scope->getStatementList();
   if (includingCompilerGenerated)
    {
   // DQ Note: (stmtList.empty() == false) is a much faster test  O(1) than (stmtList.size() > 0), which is O(n).
      if (stmtList.size()>0)
      stmt = stmtList.front();
    } else
    { //skip compiler-generated declarations
      SgStatementPtrList::iterator i=stmtList.begin();
      while (i!=stmtList.end())
      {  //isCompilerGenerated(),isOutputInCodeGeneration(),etc. are not good enough,
         //some content from headers included are not marked as compiler-generated
         //
         // cout<<(*i)->unparseToString()<<endl;
         // ((*i)->get_file_info())->display("debug.......");
         Sg_File_Info * fileInfo = (*i)->get_file_info();
        // include transformation-generated  statements, but not the hidden ones
        // Note: isOutputInCodeGeneration is not default to true for original statements from user code
         if ( (fileInfo->isSameFile(scope->get_file_info()))||
              (fileInfo->isTransformation()&& fileInfo->isOutputInCodeGeneration())
            )
          {
            stmt=*i;
            break;
          } else
          {
            i++;
            continue;
          }
      }
    }

  }
  return stmt;

}

  SgFunctionDeclaration* SageInterface::findFirstDefiningFunctionDecl(SgScopeStatement* scope)
  {
    ROSE_ASSERT(scope);
    SgFunctionDeclaration* result = NULL;
    if (scope->containsOnlyDeclarations())
    {
      SgDeclarationStatementPtrList declList = scope->getDeclarationList();
      SgDeclarationStatementPtrList::iterator i=declList.begin();
      while (i!=declList.end())
      {
        Sg_File_Info * fileInfo = (*i)->get_file_info();

       if ((fileInfo->isSameFile(scope->get_file_info()))||
          (fileInfo->isTransformation()&& fileInfo->isOutputInCodeGeneration())
        )
        {
          SgFunctionDeclaration* func = isSgFunctionDeclaration(*i);
          if (func)
          {
            if (func->get_definingDeclaration ()==func)
            {
            //cout<<"debug, first defining func decl is:"<<(*i)->unparseToString()<<endl;
            result=func;
            break;
            }
          }
        }
        i++;
      }//end while
    } else
    {
      SgStatementPtrList stmtList = scope->getStatementList();
      SgStatementPtrList::iterator i=stmtList.begin();
      while (i!=stmtList.end())
      {
        Sg_File_Info * fileInfo = (*i)->get_file_info();
        if ( (fileInfo->isSameFile(scope->get_file_info()))||
             (fileInfo->isTransformation()&& fileInfo->isOutputInCodeGeneration())
            )
         {
          SgFunctionDeclaration* func = isSgFunctionDeclaration(*i);
          if (func)
          {
            if (func->get_definingDeclaration ()==func)
            {
            //cout<<"debug, first defining func decl is:"<<(*i)->unparseToString()<<endl;
            result=func;
            break;
            }// if defining
          } // if func
         }// if fileInof
        i++;
      }//while
    } // end if
    return result;
  }


bool SageInterface::isMain(const SgNode* n)
{
 bool result = false;
 // Liao 1/5/2010, handle Fortran main entry: SgProgramHeaderStatement 
 if (SageInterface::is_Fortran_language())
 {
   if (isSgProgramHeaderStatement(n))
     result = true;
 }
 else  
 {
   if (isSgFunctionDeclaration(n) &&
     isSgGlobal(isSgStatement(n)->get_scope())&&
     isSgFunctionDeclaration(n)->get_name() == "main")
   result = true;
 }

   return result;
}

// Originally from ompTranslator.C
// DQ (1/6/2007): The correct qualified name for "main" is "::main", at least in C++.
// however for C is should be "main".  Our name qualification is not language specific,
// however, for C is makes no sense to as for the qualified name, so the name we
// want to search for could be language specific.  The test code test2007_07.C
// demonstrates that the function "main" can exist in both classes (as member functions)
// and in namespaces (as more meaningfully qualified names).  Because of this C++
// would have to qualify the global main function as "::main", I think.

// Revised by Jeremiah,
// Added check to see if the scope is global: Liao
SgFunctionDeclaration* SageInterface::findMain(SgNode* n) {
  if (!n) return 0;
  if (isMain(n))
  {
    return isSgFunctionDeclaration(n);
  }
  vector<SgNode*> children = n->get_traversalSuccessorContainer();
  for (vector<SgNode*>::const_iterator i = children.begin();
  i != children.end(); ++i) {

    SgFunctionDeclaration* mainDecl = findMain(*i);
    if (mainDecl)
      if (mainDecl->get_definingDeclaration() == mainDecl) // skip non-defining main() declaration, Liao 8/27/2010
      return mainDecl;
  }
  return 0;
}

//! iterate through the statement within a scope, find the last declaration statement (if any) after which 
//  another declaration statement can be inserted.  
// This is useful to find a safe place to insert a declaration statement with special requirements about where it can be inserted.
// e.g. a variable declaration statement should not be inserted before IMPLICIT none in Fortran
// If it returns NULL, a declaration statement should be able to be prepended to the scope
SgStatement* SageInterface::findLastDeclarationStatement(SgScopeStatement * scope)
{   
  SgStatement* rt = NULL;
  ROSE_ASSERT (scope != NULL);

  SgStatementPtrList stmt_list = scope->generateStatementList ();
    
  for (size_t i = 0; i<stmt_list.size(); i++)
  { 
    SgStatement* cur_stmt = stmt_list[i];
    if (isSgDeclarationStatement(cur_stmt))
      rt = cur_stmt;
    //if (isSgImplicitStatement(cur_stmt)) || isSgFortranIncludeLine(cur_stmt) || isSgDeclarationStatement
  } 
    
  return rt;
}   

SgNode * SageInterface::deepCopyNode (const SgNode* n)
{
  SgTreeCopy g_treeCopy; // should use a copy object each time of usage!
  return n ? n->copy (g_treeCopy) : 0;
}

// by Jeremiah
// Return bool for C++ code, and int for C code
SgType* SageInterface::getBoolType(SgNode* n) {
  bool isC = TransformationSupport::getSourceFile(n)->get_outputLanguage() == SgFile::e_C_output_language;
  if (isC) {
    return SgTypeInt::createType();
  } else {
    return SgTypeBool::createType();
  }
}

#if 1
// Change continue statements in a given block of code to gotos to a label
void SageInterface::changeContinuesToGotos(SgStatement* stmt, SgLabelStatement* label)
   {
     std::vector<SgContinueStmt*> continues = SageInterface::findContinueStmts(stmt);
     for (std::vector<SgContinueStmt*>::iterator i = continues.begin(); i != continues.end(); ++i)
        {
          SgGotoStatement* gotoStatement = SageBuilder::buildGotoStatement(label);
       // printf ("Building gotoStatement #1 = %p \n",gotoStatement);
#ifndef _MSC_VER
//#if 1
          LowLevelRewrite::replace(*i, make_unit_list( gotoStatement ) );
#else
		  ROSE_ASSERT(false);
#endif
	}
   }

// Add a step statement to the end of a loop body
// Add a new label to the end of the loop, with the step statement after
// it; then change all continue statements in the old loop body into
// jumps to the label
//
// For example:
// while (a < 5) {if (a < -3) continue;} (adding "a++" to end) becomes
// while (a < 5) {if (a < -3) goto label; label: a++;}
void SageInterface::addStepToLoopBody(SgScopeStatement* loopStmt, SgStatement* step) {
  using namespace SageBuilder;
  SgScopeStatement* proc = SageInterface::getEnclosingProcedure(loopStmt);
  SgStatement* old_body = SageInterface::getLoopBody(loopStmt);
  SgBasicBlock* new_body = buildBasicBlock();
// printf ("Building IR node #13: new SgBasicBlock = %p \n",new_body);
  SgName labelname = "rose_label__";
  labelname << ++gensym_counter;
  SgLabelStatement* labelstmt = buildLabelStatement(labelname,
buildBasicBlock(), proc);
  changeContinuesToGotos(old_body, labelstmt);
  appendStatement(old_body, new_body);
  appendStatement(labelstmt, new_body);
  appendStatement(step, new_body);
  SageInterface::setLoopBody(loopStmt, new_body);
}


void SageInterface::moveForStatementIncrementIntoBody(SgForStatement* f) {
  if (isSgNullExpression(f->get_increment())) return;
  SgExprStatement* incrStmt = SageBuilder::buildExprStatement(f->get_increment());
  f->get_increment()->set_parent(incrStmt);
  SageInterface::addStepToLoopBody(f, incrStmt);
  SgNullExpression* ne = SageBuilder::buildNullExpression();
  f->set_increment(ne);
  ne->set_parent(f);
}

void SageInterface::convertForToWhile(SgForStatement* f) {
  moveForStatementIncrementIntoBody(f);
  SgBasicBlock* bb = SageBuilder::buildBasicBlock();
  SgForInitStatement* inits = f->get_for_init_stmt();
  SgStatementPtrList& bbStmts = bb->get_statements();
  SgStatementPtrList& initStmts = inits->get_init_stmt();
  bbStmts = initStmts;
  for (size_t i = 0; i < bbStmts.size(); ++i) {
    bbStmts[i]->set_parent(bb);
  }
  bool testIsNull =
    isSgExprStatement(f->get_test()) &&
    isSgNullExpression(isSgExprStatement(f->get_test())->get_expression());
  SgStatement* test =
    testIsNull ?
    SageBuilder::buildExprStatement(
        SageBuilder::buildBoolValExp(true)) :
    f->get_test();
  SgWhileStmt* ws = SageBuilder::buildWhileStmt(
      test,
      f->get_loop_body());
  appendStatement(ws, bb);
  isSgStatement(f->get_parent())->replace_statement(f, bb);
}

void SageInterface::convertAllForsToWhiles(SgNode* top) {
  Rose_STL_Container<SgNode*> fors = NodeQuery::querySubTree(top,
V_SgForStatement);
  for (size_t i = 0; i < fors.size(); ++i) {
    convertForToWhile(isSgForStatement(fors[i]));
  }
}

  vector<SgGotoStatement*> SageInterface::findGotoStmts(SgStatement* scope, SgLabelStatement* l) {
 // DQ (9/25/2007): Moved from std::list to std::vector uniformally in ROSE.
 // But we still need the copy since the return type is IR node specific.
    Rose_STL_Container<SgNode*> allGotos = NodeQuery::querySubTree(scope, V_SgGotoStatement);

    vector<SgGotoStatement*> result;
    for (Rose_STL_Container<SgNode*>::const_iterator i = allGotos.begin(); i != allGotos.end(); ++i) {
      if (isSgGotoStatement(*i)->get_label() == l) {
	result.push_back(isSgGotoStatement(*i));
      }
    }
    return result;
  }

#if 0 // Liao 5/21/2010. This is a bad function in terms of performance
      // vectors are created/destroyed multiple times
  vector<SgReturnStmt*> SageInterface::findReturnStmts(SgStatement* scope) {
 // DQ (9/25/2007): Moved from std::list to std::vector uniformally in ROSE.
 // But we still need the copy since the return type is IR node specific.
    Rose_STL_Container<SgNode*> returns = NodeQuery::querySubTree(scope, V_SgReturnStmt);

    vector<SgReturnStmt*> result;
    for (Rose_STL_Container<SgNode*>::const_iterator i = returns.begin(); i != returns.end(); ++i) {
      result.push_back(isSgReturnStmt(*i));
    }
    return result;
  }

#endif
static  void getSwitchCasesHelper(SgStatement* top, vector<SgStatement*>& result) {
    ROSE_ASSERT (top);
    if (isSgSwitchStatement(top)) return; // Don't descend into nested switches
    if (isSgCaseOptionStmt(top) || isSgDefaultOptionStmt(top)) {
      result.push_back(top);
    }
    vector<SgNode*> children = top->get_traversalSuccessorContainer();
    for (unsigned int i = 0; i < children.size(); ++i) {
      if (isSgStatement(children[i])) {
	getSwitchCasesHelper(isSgStatement(children[i]), result);
      }
    }
  }

  vector<SgStatement*> SageInterface::getSwitchCases(SgSwitchStatement* sw) {
    vector<SgStatement*> result;
    getSwitchCasesHelper(sw->get_body(), result);
    return result;
  }


#endif

// from transformationSupport.C
SgScopeStatement*
SageInterface::getScope( const SgNode* astNode )
   {
    if (const SgSymbol* symbol = isSgSymbol(astNode))
        return symbol->get_scope();
    else if (const SgInitializedName* initName = isSgInitializedName(astNode))
        return initName->get_scope();
    else if (const SgTemplateArgument* tempArg = isSgTemplateArgument(astNode))
        return tempArg->get_scope();
    else if (const SgQualifiedName* qualifiedName = isSgQualifiedName(astNode))
        return qualifiedName->get_scope();

  // DQ (6/9/2007): This function traverses through the parents to the first scope (used for name qualification support of template arguments)
  const SgNode* parentNode = astNode;
  while (!isSgScopeStatement(parentNode))
  {
      //George Vulov (11/29/2010)
      //Function parameter lists are siblings of SgFunctionDefinition, so just going up to parents
      //produces SgGlobal.
      if (isSgFunctionParameterList(parentNode) || isSgCtorInitializerList(parentNode))
      {
          const SgFunctionDeclaration* funcDeclaration = isSgFunctionDeclaration(parentNode->get_parent());
          ROSE_ASSERT(funcDeclaration != NULL);
          funcDeclaration = isSgFunctionDeclaration(funcDeclaration->get_definingDeclaration());
          if (funcDeclaration != NULL)
          {
              return funcDeclaration->get_definition();
          }
      }

      parentNode = parentNode->get_parent();
      if (parentNode == NULL)
      {
          break;
      }
  }

  // Check to see if we made it back to the root (current root is SgProject).
  // It is also OK to stop at a node for which get_parent() returns NULL (SgType and SgSymbol nodes).
     if ( isSgScopeStatement(parentNode) == NULL &&
          dynamic_cast<const SgType*>(parentNode) == NULL &&
          dynamic_cast<const SgSymbol*>(parentNode) == NULL )
        {
          printf ("Error: could not trace back to SgScopeStatement node \n");
          ROSE_ABORT();
        }
       else
        {
          if ( dynamic_cast<const SgType*>(parentNode) != NULL || dynamic_cast<const SgSymbol*>(parentNode) != NULL )
             {
               printf ("Error: can't locate an associated SgStatement from astNode = %p = %s parentNode = %p = %s \n",astNode,astNode->class_name().c_str(),parentNode,parentNode->class_name().c_str());
               return NULL;
             }
        }

  // Make sure we have a SgStatement node
     const SgScopeStatement* scopeStatement = isSgScopeStatement(parentNode);
     //SgScopeStatement* scopeStatement = isSgScopeStatement(parentNode);
     ROSE_ASSERT (scopeStatement != NULL);

   // return scopeStatement;
       return const_cast<SgScopeStatement*>(scopeStatement);
   }


// from outliner, ASTtools
// ========================================================================

/*!
 *  \brief Return an existing variable symbol for the given
 *  initialized name.
 *
 *  This routine checks various scopes in trying to find a suitable
 *  variable symbol for the given initialized name.
 */
static
const SgVariableSymbol *
getVarSymFromName_const (const SgInitializedName* name)
{
  SgVariableSymbol* v_sym = 0;
  if (name)
    {
      SgScopeStatement* s = name->get_scope ();
      ROSE_ASSERT (s);
      v_sym = s->lookup_var_symbol (name->get_name ());

      if (!v_sym) // E.g., might be part of an 'extern' declaration.
        {
          // Try the declaration's scope.
          SgDeclarationStatement* decl = name->get_declaration ();
          ROSE_ASSERT (decl);

          SgScopeStatement* decl_scope = decl->get_scope ();
          if (decl_scope)
            v_sym = decl_scope->lookup_var_symbol (name->get_name ());

          if (!v_sym)
            cerr << "\t\t*** WARNING: Can't seem to find a symbol for '"
                 << name->get_name ().str ()
                 << "' ***" << endl;
        }
    }
  return v_sym;
}

#if 0
/*!
 *  \brief Return an existing variable symbol for the given
 *  initialized name.
 *
 *  This routine checks various scopes in trying to find a suitable
 *  variable symbol for the given initialized name.
 */
static
SgVariableSymbol *
getVarSymFromName (SgInitializedName* name)
{
  const SgVariableSymbol* v_sym = getVarSymFromName_const (name);
  return const_cast<SgVariableSymbol *> (v_sym);
}
#endif
/*!
 *  \brief Returns the SgVariableSymbol associated with an SgVarRefExp
 *  or SgInitializedName, or 0 if none.
 */
static
const SgVariableSymbol *
getVarSym_const (const SgNode* n)
{
  const SgVariableSymbol* v_sym = 0;
  switch (n->variantT ())
    {
    case V_SgVarRefExp:
      v_sym = isSgVarRefExp (n)->get_symbol ();
      break;
    case V_SgInitializedName:
      v_sym = getVarSymFromName_const (isSgInitializedName (n));
      break;
    default:
      break;
    }
  return v_sym;
}

#if 0
/*!
 *  \brief Returns the SgVariableSymbol associated with an SgVarRefExp
 *  or SgInitializedName, or 0 if none.
 */
static
SgVariableSymbol *
getVarSym (SgNode* n)
{
  const SgVariableSymbol* v_sym = getVarSym_const (n);
  return const_cast<SgVariableSymbol *> (v_sym);
}
#endif

static
const SgVariableSymbol *
getFirstVarSym_const (const SgVariableDeclaration* decl)
{
  if (!decl) return 0;
  const SgInitializedNamePtrList& names = decl->get_variables ();
  if (names.begin () != names.end ())
    {
      const SgInitializedName* name = *(names.begin ());
      return getVarSym_const (name);
    }
  else
    return 0;
}

SgVariableSymbol *
SageInterface::getFirstVarSym (SgVariableDeclaration* decl)
{
  const SgVariableSymbol* sym = getFirstVarSym_const (decl);
  return const_cast<SgVariableSymbol *> (sym);
}


SgInitializedName*
SageInterface::getFirstInitializedName (SgVariableDeclaration* decl)
{
  ROSE_ASSERT(decl);
  SgInitializedNamePtrList& names = decl->get_variables ();
  if (names.begin () != names.end ())
    return *(names.begin ());
  else
    return NULL;
}


static void findBreakStmtsHelper(SgStatement* code, const std::string& fortranLabel, bool inOutermostBody, vector<SgBreakStmt*>& breakStmts) {
  if (isSgWhileStmt(code) || isSgDoWhileStmt(code) || isSgForStatement(code) || isSgSwitchStatement(code)) {
    if (fortranLabel == "") {
      // Outermost loop only
      return;
    } else {
      // Set this for query on children
      inOutermostBody = false;
    }
  }
  if (isSgBreakStmt(code)) {
    SgBreakStmt* bs = isSgBreakStmt(code);
    bool breakMatchesThisConstruct = false;
    if (bs->get_do_string_label() == "") {
      // Break matches closest construct
      breakMatchesThisConstruct = inOutermostBody;
    } else {
      breakMatchesThisConstruct = (fortranLabel == bs->get_do_string_label());
    }
    if (breakMatchesThisConstruct) {
      breakStmts.push_back(bs);
    }
    return;
  }
  vector<SgNode*> children = code->get_traversalSuccessorContainer();
  for (unsigned int i = 0; i < children.size(); ++i) {
    if (isSgStatement(children[i])) {
      findBreakStmtsHelper(isSgStatement(children[i]), fortranLabel, inOutermostBody, breakStmts);
    }
  }
}

vector<SgBreakStmt*> SageInterface::findBreakStmts(SgStatement* code, const std::string& fortranLabel) {
  // Run this on the body of a loop or switch, because it stops at any
  // construct which defines a new scope for break statements
  vector<SgBreakStmt*> result;
  findBreakStmtsHelper(code, fortranLabel, true, result);
  return result;
}


static void findContinueStmtsHelper(SgStatement* code, const std::string& fortranLabel, bool inOutermostBody, vector<SgContinueStmt*>& continueStmts) {
  if (isSgWhileStmt(code) || isSgDoWhileStmt(code) || isSgForStatement(code)) {
    if (fortranLabel == "") {
      // Outermost loop only
      return;
    } else {
      // Set this for query on children
      inOutermostBody = false;
    }
  }
  if (isSgContinueStmt(code)) {
    SgContinueStmt* cs = isSgContinueStmt(code);
    bool continueMatchesThisConstruct = false;
    if (cs->get_do_string_label() == "") {
      // Continue matches closest construct
      continueMatchesThisConstruct = inOutermostBody;
    } else {
      continueMatchesThisConstruct = (fortranLabel == cs->get_do_string_label());
    }
    if (continueMatchesThisConstruct) {
      continueStmts.push_back(cs);
    }
    return;
  }
  vector<SgNode*> children = code->get_traversalSuccessorContainer();
  for (unsigned int i = 0; i < children.size(); ++i) {
    if (isSgStatement(children[i])) {
      findContinueStmtsHelper(isSgStatement(children[i]), fortranLabel, inOutermostBody, continueStmts);
    }
  }
}

vector<SgContinueStmt*> SageInterface::findContinueStmts(SgStatement* code, const std::string& fortranLabel) {
  // Run this on the body of a loop, because it stops at any construct which
  // defines a new scope for continue statements
  vector<SgContinueStmt*> result;
  findContinueStmtsHelper(code, fortranLabel, true, result);
  return result;
}


// Get the initializer containing an expression if it is within an
// initializer.
//  from replaceExpressionWithStatement.C
SgInitializer* SageInterface::getInitializerOfExpression(SgExpression* n) {
  assert(n);
#if 0
  std::cout << "Starting getInitializerOfExpression on 0x" << std::hex << (int)n << ", which has type " << n->sage_class_name() << std::endl;
#endif
  while (!isSgInitializer(n)) {
    n = isSgExpression(n->get_parent());
#if 0
    std::cout << "Continuing getInitializerOfExpression on 0x" << std::hex << (int)n;
    if (n) std::cout << ", which has type " << n->sage_class_name();
    std::cout << std::endl;
#endif
    assert(n);
  }
  return isSgInitializer(n);
}

#ifndef USE_ROSE
// Get all symbols used in a given expression
vector<SgVariableSymbol*> SageInterface::getSymbolsUsedInExpression(SgExpression* expr) {
 class GetSymbolsUsedInExpressionVisitor: public AstSimpleProcessing {
  public:
  std::vector<SgVariableSymbol*> symbols;

  virtual void visit(SgNode* n) {
    if (isSgVarRefExp(n))
      symbols.push_back(isSgVarRefExp(n)->get_symbol());
  }
 };

  GetSymbolsUsedInExpressionVisitor vis;
  vis.traverse(expr, preorder);
  return vis.symbols;
}
#endif

SgFunctionDefinition* SageInterface::getEnclosingProcedure(SgNode* n, bool includingSelf)
{
  return getEnclosingFunctionDefinition(n,includingSelf);
}

SgFunctionDefinition* SageInterface::getEnclosingFunctionDefinition(SgNode* n,bool includingSelf)
{
    SgFunctionDefinition* temp = getEnclosingNode<SgFunctionDefinition>(n,includingSelf);
  if (temp)
    return temp;
  else
    return NULL;
}


SgFunctionDeclaration *
SageInterface::getEnclosingFunctionDeclaration (SgNode * astNode,bool includingSelf)
{
  SgNode* temp = getEnclosingNode<SgFunctionDeclaration>(astNode,includingSelf);
  if (temp)
    return isSgFunctionDeclaration(temp);
  else
    return NULL;
#if 0
  SgNode *astnode = astNode;
  ROSE_ASSERT (astNode != NULL);
  do
    {
      astnode = astnode->get_parent ();
    }
  while ((astnode != NULL) &&
         (isSgFunctionDeclaration (astnode) == NULL) &&
	 (isSgMemberFunctionDeclaration (astnode) == NULL));
  if (astnode==NULL) return NULL;
  else return isSgFunctionDeclaration(astnode);
#endif
}

// #endif

// #ifndef USE_ROSE

 SgGlobal* SageInterface::getGlobalScope( const SgNode* astNode)
 {
   // should including itself in this case
    SgNode* temp = getEnclosingNode<SgGlobal>(astNode,true);
    if (temp)
      return isSgGlobal(temp);
    else
      return NULL;
  }

  SgClassDefinition*
  SageInterface::getEnclosingClassDefinition(SgNode* astNode, const bool includingSelf/* =false*/)
  {
    SgNode* temp = getEnclosingNode<SgClassDefinition>(astNode,includingSelf);
    if (temp)
      return isSgClassDefinition(temp);
    else
      return NULL;
 }


SgFile * SageInterface::getEnclosingFileNode(SgNode* astNode)
{
    ROSE_ASSERT (astNode != NULL);

  // Make sure this is not a project node (since the SgFile exists below
  // the project and could not be found by a traversal of the parent list)
     ROSE_ASSERT (isSgProject(astNode) == NULL);

     SgNode* parent = astNode;
     while ( (parent != NULL) && (isSgFile(parent) == NULL) )
        {
       // printf ("In getFileNameByTraversalBackToFileNode(): parent = %p = %s \n",parent,parent->class_name().c_str());
          parent = parent->get_parent();
        }
 if (!parent)
   return NULL;
 else return isSgFile(parent);

}

SgStatement* SageInterface::getEnclosingStatement(SgNode* n) {
  while (n && !isSgStatement(n)) n = n->get_parent();
  return isSgStatement(n);
}

// DQ (/20/2010): Control debugging output for SageInterface::removeStatement() function.
#define REMOVE_STATEMENT_DEBUG 0

//! Remove a statement: TODO consider side effects for symbol tables
void SageInterface::removeStatement(SgStatement* targetStmt, bool autoRelocatePreprocessingInfo /*= true*/)
   {
  // This function removes the input statement.
  // If there are comments and/or CPP directives then those comments and/or CPP directives will
  // be moved to a new SgStatement.  The new SgStatement is selected using the findSurroundingStatementFromSameFile()
  // function and if there is not statement found then the SgGlobal IR node will be selected.
  // this work is tested by the tests/roseTests/astInterfaceTests/removeStatementCommentRelocation.C
  // translator and a number of input codes that represent a range of contexts which exercise different
  // cases in the code below.

#ifndef _MSC_VER
  // This function only supports the removal of a whole statement (not an expression within a statement)
     ROSE_ASSERT (targetStmt != NULL);

     SgStatement * parentStatement = isSgStatement(targetStmt->get_parent());

  // Can't assert this since SgFile is the parent of SgGlobal, and SgFile is not a statement.
  // Even so SgGlobal can't be removed from SgFile, but isRemovableStatement() takes a SgStatement.
  // ROSE_ASSERT (parentStatement != NULL);

     bool isRemovable = (parentStatement != NULL) ? LowLevelRewrite::isRemovableStatement(targetStmt) : false;

#if REMOVE_STATEMENT_DEBUG
     printf ("In parentStatement = %s remove targetStatement = %s (isRemovable = %s) \n",parentStatement->class_name().c_str(),targetStmt->class_name().c_str(),isRemovable ? "true" : "false");
#endif

     if (isRemovable == true)
        {
       // DQ (9/19/2010): Disable this new (not completely working feature) so that I can checkin the latest UPC/UPC++ work.
#if 1
       // DQ (9/16/2010): Added support to move comments and CPP directives marked to
       // appear before the statment to be attached to the inserted statement (and marked
       // to appear before that statement).
          AttachedPreprocessingInfoType* comments = targetStmt->getAttachedPreprocessingInfo();

       // DQ (9/17/2010): Trying to eliminate failing case in OpenMP projects/OpenMP_Translator/tests/npb2.3-omp-c/LU/lu.c
       // I think that special rules apply to inserting a SgBasicBlock so disable comment reloation when inserting a SgBasicBlock.
       // if (comments != NULL && isRemovable == true && isSgBasicBlock(targetStmt) == NULL )
       // Liao 10/28/2010. Sometimes we want remove the statement with all its preprocessing information
         if (autoRelocatePreprocessingInfo)
         {
          if (comments != NULL && isSgBasicBlock(targetStmt) == NULL )
             {
               vector<int> captureList;
#if REMOVE_STATEMENT_DEBUG
               printf ("Found attached comments (removing %p = %s): comments->size() = %zu \n",targetStmt,targetStmt->class_name().c_str(),comments->size());
#endif

             // Liao 10/28/2010. relinking AST statements may be achieved by remove it and attach it to somewhere else.
             // In this case, preprocessing information sometimes should go with the statements and not be relocated to the original places.
            // Dan: Since this statement will be removed we have to relocate all the associated comments and CPP directives.
               int commentIndex = 0;
               AttachedPreprocessingInfoType::iterator i;
               for (i = comments->begin(); i != comments->end(); i++)
                  {
                    ROSE_ASSERT ( (*i) != NULL );
#if REMOVE_STATEMENT_DEBUG
                    printf ("          Attached Comment (relativePosition=%s): %s\n",
                         ((*i)->getRelativePosition() == PreprocessingInfo::before) ? "before" : "after",
                         (*i)->getString().c_str());
                    printf ("Comment/Directive getNumberOfLines = %d getColumnNumberOfEndOfString = %d \n",(*i)->getNumberOfLines(),(*i)->getColumnNumberOfEndOfString());
                    (*i)->get_file_info()->display("comment/directive location debug");
#endif
                    captureList.push_back(commentIndex);
                    commentIndex++;
                  }

#if REMOVE_STATEMENT_DEBUG
               printf ("captureList.size() = %zu \n",captureList.size());
#endif

               if (captureList.empty() == false)
                  {
                 // Remove these comments and/or CPP directives and put them into the previous statement (marked to be output after the statement).
                 // Find the surrounding statement by first looking up in the sequence of statements in this block, then down, we need another
                 // statement from the same file.
                    bool surroundingStatementPreceedsTargetStatement = false;
                    SgStatement* surroundingStatement = findSurroundingStatementFromSameFile(targetStmt,surroundingStatementPreceedsTargetStatement);

                 // ROSE_ASSERT(surroundingStatement != NULL);
                    if (surroundingStatement != NULL)
                       {
                      // If we have identified a valid surrounding statemen, then move the comments and CPP directives to that statement.
#if REMOVE_STATEMENT_DEBUG
                         printf ("In removeStatement(): surroundingStatementPreceedsTargetStatement = %s \n",surroundingStatementPreceedsTargetStatement ? "true" : "false");
#endif
                         moveCommentsToNewStatement(targetStmt,captureList,surroundingStatement,surroundingStatementPreceedsTargetStatement);
                       }
                  }
             } // end if (comments)
        }// end if (autoRelocatePreprocessingInfo)
#endif  // end #if 1

          parentStatement->remove_statement(targetStmt);
        }
#else
     printf ("Error: This is not supported within Microsoft Windows (I forget why). \n");
     ROSE_ASSERT(false);
#endif
   }

//! Relocate comments and CPP directives from one statement to another.
void
SageInterface::moveCommentsToNewStatement(SgStatement* sourceStatement, const vector<int> & indexList, SgStatement* targetStatement , bool surroundingStatementPreceedsTargetStatement)
   {
     AttachedPreprocessingInfoType* comments = sourceStatement->getAttachedPreprocessingInfo();

#if REMOVE_STATEMENT_DEBUG
     printf ("In moveCommentsToNewStatement(): surroundingStatementPreceedsTargetStatement = %s \n",surroundingStatementPreceedsTargetStatement ? "true" : "false");
#endif

  // Now add the entries from the captureList to the surroundingStatement and remove them from the targetStmt.
  // printf ("This is a valid surrounding statement = %s for insertBefore = %s \n",surroundingStatement->class_name().c_str(),insertBefore ? "true" : "false");
     vector<int>::const_iterator j = indexList.begin();
     while (j != indexList.end())
        {
       // Add the captured comments to the new statement. Likely we need to make sure that the order is preserved.
          ROSE_ASSERT(targetStatement->get_file_info() != NULL);
#if REMOVE_STATEMENT_DEBUG
          printf ("Attaching comments to targetStatement = %p = %s on file = %s line %d \n",
               targetStatement,targetStatement->class_name().c_str(),
               targetStatement->get_file_info()->get_filenameString().c_str(),
               targetStatement->get_file_info()->get_line());

          printf ("(*comments)[*j]->getRelativePosition() = %s \n",PreprocessingInfo::relativePositionName((*comments)[*j]->getRelativePosition()).c_str());
#endif

          if (surroundingStatementPreceedsTargetStatement == true)
             {
               if ((*comments)[*j]->getRelativePosition() == PreprocessingInfo::before)
                  {
                    (*comments)[*j]->setRelativePosition(PreprocessingInfo::after);
                    ROSE_ASSERT((*comments)[*j]->getRelativePosition() == PreprocessingInfo::after);
                  }
                 else
                  {
                 // If is is not before, I hope it can only be after.
                    ROSE_ASSERT((*comments)[*j]->getRelativePosition() == PreprocessingInfo::after);
                  }
             }
            else
             {
               if ((*comments)[*j]->getRelativePosition() == PreprocessingInfo::before)
                  {
                 // Leave the comments marked as being before the associated statement.
                  }
                 else
                  {
                 // If is is not before, I hope it can only be after.
                    ROSE_ASSERT((*comments)[*j]->getRelativePosition() == PreprocessingInfo::after);
                    (*comments)[*j]->setRelativePosition(PreprocessingInfo::before);
                    ROSE_ASSERT((*comments)[*j]->getRelativePosition() == PreprocessingInfo::before);
                  }

            // printf (" This case (surroundingStatementPreceedsTargetStatement == false) is not handled yet. \n");
            // ROSE_ASSERT(false);
             }

          targetStatement->addToAttachedPreprocessingInfo((*comments)[*j]);

       // Remove them from the targetStmt. (set them to NULL and then remove them in a separate step).
#if REMOVE_STATEMENT_DEBUG
          printf ("Marking entry from comments list as NULL on sourceStatement = %p = %s \n",sourceStatement,sourceStatement->class_name().c_str());
#endif
          (*comments)[*j] = NULL;

          j++;
        }

  // Now remove each NULL entries in the comments vector.
  // Because of iterator invalidation we must reset the iterators after each call to erase (I think).
     for (size_t n = 0; n < indexList.size(); n++)
        {
#if REMOVE_STATEMENT_DEBUG
          printf ("Erase entry from comments list on comments->size() %zu \n",comments->size());
#endif
          bool modifiedList = false;
          AttachedPreprocessingInfoType::iterator k = comments->begin();
          while (k != comments->end() && modifiedList == false)
             {
            // Only modify the list once per iteration over the captureList
            // if ((*comments)[*k] == NULL)
               if (*k == NULL)
                  {
                    comments->erase(k);
                    modifiedList = true;
                  }
               k++;
             }
        }
   }


//! Remove a statement: TODO consider side effects for symbol tables
SgStatement*
SageInterface::findSurroundingStatementFromSameFile(SgStatement* targetStmt, bool & surroundingStatementPreceedsTargetStatement)
   {
  // Note that if the return value is SgGlobal (global scope), then surroundingStatementPreceedsTargetStatement is false, but meaningless.
  // This function can not return a NULL pointer.

     ROSE_ASSERT(targetStmt != NULL);

     SgStatement* surroundingStatement = targetStmt;
     int surroundingStatement_fileId   = Sg_File_Info::BAD_FILE_ID; // No file id can have this value.

#if REMOVE_STATEMENT_DEBUG
     printf ("TOP of findSurroundingStatementFromSameFile(): surroundingStatementPreceedsTargetStatement = %s \n",surroundingStatementPreceedsTargetStatement ? "true" : "false");
#endif

  // Only handle relocation for statements that exist in the file (at least for now while debugging).
     if (targetStmt->get_file_info()->get_file_id() >= 0)
        {
          surroundingStatementPreceedsTargetStatement = true;

#if REMOVE_STATEMENT_DEBUG
          printf ("   targetStmt->get_file_info()->get_file_id()           = %d \n",targetStmt->get_file_info()->get_file_id());
#endif
          bool returningNullSurroundingStatement = false;
       // while (surroundingStatement->get_file_info()->get_file_id() != targetStmt->get_file_info()->get_file_id())
          while ((returningNullSurroundingStatement == false) && (surroundingStatement != NULL) && surroundingStatement_fileId != targetStmt->get_file_info()->get_file_id())
             {
            // Start by going up in the source sequence.
            // This is a declaration from the wrong file so go to the next statement.
            // surroundingStatement = (insertBefore == true) ? getNextStatement(surroundingStatement) : getPreviousStatement(surroundingStatement);
            // surroundingStatement = (insertBefore == true) ? getPreviousStatement(surroundingStatement) : getNextStatement(surroundingStatement);
               surroundingStatement = getPreviousStatement(surroundingStatement);
               if (surroundingStatement == NULL)
                  {
                    surroundingStatement_fileId = Sg_File_Info::BAD_FILE_ID;
#if REMOVE_STATEMENT_DEBUG
                    printf ("   surroundingStatement_fileId set to Sg_File_Info::BAD_FILE_ID \n");
#endif
                  }
                 else
                  {
                    surroundingStatement_fileId = surroundingStatement->get_file_info()->get_file_id();
#if REMOVE_STATEMENT_DEBUG
                    printf ("   surroundingStatement = %p = %s surroundingStatement->get_file_info()->get_file_id() = %d \n",
                         surroundingStatement,surroundingStatement->class_name().c_str(),surroundingStatement->get_file_info()->get_file_id());
#endif
                  }

#if REMOVE_STATEMENT_DEBUG
               if (surroundingStatement != NULL)
                  {
                    printf ("Looping toward the top of the file for a statement to attach comments and CPP directives to: surroundingStatement = %p = %s file = %s file id = %d line = %d \n",
                         surroundingStatement,surroundingStatement->class_name().c_str(),
                         surroundingStatement->get_file_info()->get_filenameString().c_str(),
                         surroundingStatement->get_file_info()->get_file_id(),
                         surroundingStatement->get_file_info()->get_line());
                  }
                 else
                  {
                    printf ("surroundingStatement == NULL \n");
                  }
#endif
            // As a last resort restart and go down in the statement sequence.
            // if (surroundingStatement == NULL)
               if (surroundingStatement == NULL || isSgGlobal(surroundingStatement) != NULL)
                  {
                 // This is triggered by rose_inputloopUnrolling.C
#if REMOVE_STATEMENT_DEBUG
                    printf ("We just ran off the start (top) of the file... targetStmt = %p = %s \n",targetStmt,targetStmt->class_name().c_str());
#endif
#if 0
                    ROSE_ASSERT(false);
#endif
                 // A statement in the same file could not be identified, so this is false.
                    surroundingStatementPreceedsTargetStatement = false;

                 // Restart by going the other direction (down in the source sequence)
                    surroundingStatement = targetStmt;
                    SgStatement* previousStatement = surroundingStatement;
                 // surroundingStatement = getNextStatement(surroundingStatement);
                    surroundingStatement_fileId = Sg_File_Info::BAD_FILE_ID;
                 // while ( (surroundingStatement != NULL) && (surroundingStatement->get_file_info()->get_file_id() != targetStmt->get_file_info()->get_file_id()) )
                    while ( (surroundingStatement != NULL) && (surroundingStatement_fileId != targetStmt->get_file_info()->get_file_id()) )
                       {
                         previousStatement = surroundingStatement;
                         surroundingStatement = getNextStatement(surroundingStatement);

                         if (surroundingStatement == NULL)
                            {
                              surroundingStatement_fileId = Sg_File_Info::BAD_FILE_ID;
#if REMOVE_STATEMENT_DEBUG
                              printf ("We just ran off the end (bottom) of the file... \n");
#endif
#if 0
                              ROSE_ASSERT(false);
#endif
                              returningNullSurroundingStatement = true;
                            }
                           else
                            {
                              surroundingStatement_fileId = surroundingStatement->get_file_info()->get_file_id();
#if REMOVE_STATEMENT_DEBUG
                              printf ("Looping toward the bottom of the file for a statement to attach comments and CPP directives to: surroundingStatement = %p = %s file = %s file id = %d line = %d \n",
                                   surroundingStatement,surroundingStatement->class_name().c_str(),
                                   surroundingStatement->get_file_info()->get_filenameString().c_str(),
                                   surroundingStatement->get_file_info()->get_file_id(),
                                   surroundingStatement->get_file_info()->get_line());
#endif
                            }
                       }

                    if (surroundingStatement == NULL)
                       {
#if REMOVE_STATEMENT_DEBUG
                         printf ("Resetting the surroundingStatement to the previousStatement = %p = %s \n",previousStatement,previousStatement->class_name().c_str());
#endif
                         surroundingStatement = previousStatement;

                      // Check if this is the input statement we are removing (since the we have to attach comments to the global scope IR node.
                         if (surroundingStatement == targetStmt)
                            {
                           // This can happen if there was only a single statement in a file and it was removed.
                           // All associated comments would have to be relocated to the SgGlobal IR node.
#if REMOVE_STATEMENT_DEBUG
                              printf ("Setting the surroundingStatement to be global scope \n");
#endif
                              surroundingStatement = TransformationSupport::getGlobalScope(targetStmt);
                            }
                       }
                  }
             }

          ROSE_ASSERT(surroundingStatement != NULL);
        }
       else
        {
          printf ("This is a special statement (not associated with the original source code, comment relocation is not supported for these statements) targetStmt file id = %d \n",targetStmt->get_file_info()->get_file_id());
          surroundingStatement = NULL;
        }

#if REMOVE_STATEMENT_DEBUG
     printf ("BOTTOM of findSurroundingStatementFromSameFile(): surroundingStatementPreceedsTargetStatement = %s surroundingStatement = %p \n",surroundingStatementPreceedsTargetStatement ? "true" : "false",surroundingStatement);
     if (surroundingStatement != NULL)
        {
          printf ("surroundingStatement = %p = %s \n",surroundingStatement,surroundingStatement->class_name().c_str());
        }
#endif

  // ROSE_ASSERT(surroundingStatement != NULL);

     return surroundingStatement;
   }


#ifndef USE_ROSE
//! Deep delete a sub AST tree. It uses postorder traversal to delete each child node.
void SageInterface::deepDelete(SgNode* root)
{
#if 0
   struct Visitor: public AstSimpleProcessing {
    virtual void visit(SgNode* n) {
        delete (n);
     }
    };
  Visitor().traverse(root, postorder);
#else
  deleteAST(root);
#endif
}
#endif

//! Replace a statement with another
void SageInterface::replaceStatement(SgStatement* oldStmt, SgStatement* newStmt, bool movePreprocessinInfo/* = false*/)
{
  ROSE_ASSERT(oldStmt);
  ROSE_ASSERT(newStmt);
  if (oldStmt == newStmt) return;
  SgStatement * p = isSgStatement(oldStmt->get_parent());
  ROSE_ASSERT(p);
  // TODO  handle replace the body of a C/Fortran function definition with a single statement?
  oldStmt->set_parent(p); // needed ?
  p->replace_statement(oldStmt,newStmt);

// Some translators have their own handling for this (e.g. the outliner)
  if (movePreprocessinInfo)
    moveUpPreprocessingInfo(newStmt, oldStmt);
}

// This code is based on OpenMP translator's ASTtools::replaceVarRefExp() and astInling's replaceExpressionWithExpression()
// Motivation: It involves the parent node to replace a VarRefExp with a new node
// Used to replace shared variables with the dereference expression of their addresses
// e.g. to replace shared1 with (*__pp_shared1)

void SageInterface::replaceExpression(SgExpression* oldExp, SgExpression* newExp, bool keepOldExp/*=false*/)
{
  ROSE_ASSERT(oldExp);
  ROSE_ASSERT(newExp);
  if (oldExp==newExp) return;

  if (isSgVarRefExp(newExp))
    newExp->set_need_paren(true); // enclosing new expression with () to be safe

  SgNode* parent = oldExp->get_parent();
  ROSE_ASSERT(parent!=NULL);
  newExp->set_parent(parent);

  // set lvalue when necessary
  if (oldExp->get_lvalue() == true) newExp->set_lvalue(true);

  if (isSgExprStatement(parent)) {
    isSgExprStatement(parent)->set_expression(newExp);
    }
  else if (isSgForStatement(parent)) {
    ROSE_ASSERT (isSgForStatement(parent)->get_increment() == oldExp);
    isSgForStatement(parent)->set_increment(newExp);
    // TODO: any other cases here??
  }
  else if (isSgReturnStmt(parent))
    isSgReturnStmt(parent)->set_expression(newExp);
  else  if (isSgBinaryOp(parent)!=NULL){
    if (oldExp==isSgBinaryOp(parent)->get_lhs_operand())
        {
          isSgBinaryOp(parent)->set_lhs_operand(newExp);
         }
     else if (oldExp==isSgBinaryOp(parent)->get_rhs_operand())
         {isSgBinaryOp(parent)->set_rhs_operand(newExp); }
     else
       ROSE_ASSERT(false);
   } else //unary parent
  if (isSgUnaryOp(parent)!=NULL){
      if (oldExp==isSgUnaryOp(parent)->get_operand_i())
           isSgUnaryOp(parent)->set_operand_i(newExp);
      else
        ROSE_ASSERT(false);
  }  else//SgConditionalExp
  if (isSgConditionalExp(parent)!=NULL){
     SgConditionalExp *expparent= isSgConditionalExp(parent);//get explicity type parent
     if (oldExp==expparent->get_conditional_exp()) expparent->set_conditional_exp(newExp);
     else if (oldExp==expparent->get_true_exp()) expparent->set_true_exp(newExp);
     else if (oldExp==expparent->get_false_exp()) expparent->set_false_exp(newExp);
     else
       ROSE_ASSERT(false);
  } else if (isSgExprListExp(parent)!=NULL)
  {
    SgExpressionPtrList & explist = isSgExprListExp(parent)->get_expressions();
    for (Rose_STL_Container<SgExpression*>::iterator i=explist.begin();i!=explist.end();i++)
      if (isSgExpression(*i)==oldExp) {
        isSgExprListExp(parent)->replace_expression(oldExp,newExp);
       // break; //replace the first occurrence only??
      }
  }
  else if (isSgValueExp(parent))
  {
      // For compiler generated code, this could happen.
      // We can just ignore this function call since it will not appear in the final AST.
      return;
  }
  else if (isSgExpression(parent)) {
    int worked = isSgExpression(parent)->replace_expression(oldExp, newExp);
    // ROSE_DEPRECATED_FUNCTION
    ROSE_ASSERT (worked);
  }
  else if (isSgInitializedName(parent))
  {
	  SgInitializedName* initializedNameParent = isSgInitializedName(parent);
	  if (oldExp == initializedNameParent->get_initializer())
	  {
		  //We can only replace an initializer expression with another initializer expression
		  ROSE_ASSERT(isSgInitializer(newExp));
		  initializedNameParent->set_initializer(isSgInitializer(newExp));
	  }
	  else
	  {
		  //What other expressions can be children of an SgInitializedname?
		  ROSE_ASSERT(false);
	  }
  }
 else{
  cerr<<"SageInterface::replaceExpression(). Unhandled parent expression type of SageIII enum value: " <<parent->class_name()<<endl;
  ROSE_ASSERT(false);
  }

  if (!keepOldExp)
  {
    deepDelete(oldExp); // avoid dangling node in memory pool
  }

} //replaceExpression()

#if 0 // move to header
// Contributed by Jeremiah
//! Get all nodes with a certain variant, with an appropriate downcast. FIXME:
//! there needs to be a static method in each SgNode subclass that returns the
//! correct variant number.
template <typename NodeType>
std::vector<NodeType*> SageInterface::querySubTree(SgNode* top, VariantT variant) {

  Rose_STL_Container<SgNode*> nodes = NodeQuery::querySubTree(top,variant);
  std::vector<NodeType*> result(nodes.size(), NULL);
  int count = 0;
  for (Rose_STL_Container<SgNode*>::const_iterator i = nodes.begin();
       i != nodes.end(); ++i, ++count) {
    NodeType* node = dynamic_cast<NodeType*>(*i);
    ROSE_ASSERT (node);
    result[count] = node;
  }
  return result;
}
#endif

 SgStatement* SageInterface::getNextStatement(SgStatement * currentStmt)
{
// reuse the implementation in ROSE namespace from src/roseSupport/utility_functions.C
  return ROSE::getNextStatement(currentStmt);
}

  SgStatement* SageInterface::getPreviousStatement(SgStatement * currentStmt)
{
  return ROSE::getPreviousStatement(currentStmt);
}

bool SageInterface::isEqualToIntConst(SgExpression* e, int value) {
     return isSgIntVal(e) && isSgIntVal(e)->get_value() == value;
  }

 bool SageInterface::isSameFunction(SgFunctionDeclaration* func1, SgFunctionDeclaration* func2)
 {
   ROSE_ASSERT(func1&& func2);
   bool result = false;
   if (func1 == func2)
     result = true;
   else
    {
      if (is_C_language()||is_C99_language()||is_PHP_language())
      {
        if (func1->get_name() == func2->get_name())
          result = true;
      }
      else if (is_Cxx_language())
      {
         if (func1->get_qualified_name().getString() +
            func1->get_mangled_name().getString() ==
            func2->get_qualified_name().getString() +
            func2->get_mangled_name().getString()
            )
         result = true;
      }
      else if (is_Fortran_language())
      {
        if (func1->get_name() == func2->get_name())
          result = true;
      }
      else
      {
        cout<<"Error: SageInterface::isSameFunction(): unhandled language"<<endl;
        ROSE_ASSERT(false);
      }

    } // not identical
  return result;
 } // isSameFunction()

//! Check if a statement is the last statement within its closed scope
 bool SageInterface::isLastStatement(SgStatement* stmt)
{
  bool result =false;
  ROSE_ASSERT(stmt != NULL);
  SgScopeStatement* p_scope = stmt->get_scope();
  ROSE_ASSERT(p_scope != NULL);
#if 0
  if (p_scope->containsOnlyDeclarations())
  {
    SgDeclarationStatementPtrList stmtlist= p_scope->getDeclarationList ()
      if (stmtlist[stmtlist.size()-1] == stmt)
        result = true;
  }
  else
  {
    SgStatementPtrList  stmtlist= p_scope->getStatementList ();
    if (stmtlist[stmtlist.size()-1] == stmt)
      result = true;
  }
#endif
  SgStatementPtrList  stmtlist= p_scope->generateStatementList ();
  if (stmtlist[stmtlist.size()-1] == stmt)
    result = true;

  return result;
}

#ifndef USE_ROSE
//-----------------------------------------------
// Remove original expression trees from expressions, so you can change
// the value and have it unparsed correctly.
void SageInterface::removeAllOriginalExpressionTrees(SgNode* top) {
  struct Visitor: public AstSimpleProcessing {
    virtual void visit(SgNode* n) {
      if (isSgValueExp(n)) {
        isSgValueExp(n)->set_originalExpressionTree(NULL);
      } else if (isSgCastExp(n)) {
        isSgCastExp(n)->set_originalExpressionTree(NULL);
      }
    }
  };
  Visitor().traverse(top, preorder);
}
#endif

SgSwitchStatement* SageInterface::findEnclosingSwitch(SgStatement* s) {
  while (s && !isSgSwitchStatement(s)) {
    s = isSgStatement(s->get_parent());
  }
  ROSE_ASSERT (s);
  return isSgSwitchStatement(s);
}

SgScopeStatement* SageInterface::findEnclosingLoop(SgStatement* s, const std::string& fortranLabel, bool stopOnSwitches) {
  for (; s; s = isSgStatement(s->get_parent())) {
    SgScopeStatement* sc = isSgScopeStatement(s);
    switch (s->variantT()) {
      case V_SgDoWhileStmt: return sc;
      case V_SgForStatement: return sc;
      case V_SgFortranDo:
      case V_SgFortranNonblockedDo: {
        if (fortranLabel.empty() ||
            fortranLabel == isSgFortranDo(sc)->get_string_label()) {
          return sc;
        }
        break;
      }
      case V_SgWhileStmt: {
        if (fortranLabel.empty() ||
            fortranLabel == isSgWhileStmt(sc)->get_string_label()) {
          return sc;
        }
        break;
      }
      case V_SgSwitchStatement: {
        if (stopOnSwitches) return sc;
        break;
      }
      default: continue;
    }
  }
  return NULL;
}

#ifndef USE_ROSE
void SageInterface::removeJumpsToNextStatement(SgNode* top)
{
 class RemoveJumpsToNextStatementVisitor: public AstSimpleProcessing {
    public:
    virtual void visit(SgNode* n) {
      if (isSgBasicBlock(n)) {
        SgBasicBlock* bb = isSgBasicBlock(n);
        bool changes = true;
        while (changes) {
          changes = false;
          for (SgStatementPtrList::iterator i = bb->get_statements().begin();
               i != bb->get_statements().end(); ++i) {
            if (isSgGotoStatement(*i)) {
              SgGotoStatement* gs = isSgGotoStatement(*i);
              SgStatementPtrList::iterator inext = i;
              ++inext;
             if (inext == bb->get_statements().end())
                continue;
             if (!isSgLabelStatement(*inext))
                continue;
              SgLabelStatement* ls = isSgLabelStatement(*inext);
              if (gs->get_label() == ls) {
                changes = true;
                bb->get_statements().erase(i);
                break;
              }
            }
          }
        }
      }
    }
  };

  RemoveJumpsToNextStatementVisitor().traverse(top, postorder);

}
#endif

// special purpose remove for AST transformation/optimization from astInliner, don't use it otherwise.
void SageInterface::myRemoveStatement(SgStatement* stmt) {
  // assert (LowLevelRewrite::isRemovableStatement(*i));
  SgStatement* parent = isSgStatement(stmt->get_parent());
  ROSE_ASSERT (parent);
  SgBasicBlock* bb = isSgBasicBlock(parent);
  SgForInitStatement* fis = isSgForInitStatement(parent);
  if (bb || fis) {
    ROSE_ASSERT (bb || fis);
    SgStatementPtrList& siblings =
      (bb ? bb->get_statements() : fis->get_init_stmt());
    SgStatementPtrList::iterator j =
      std::find(siblings.begin(), siblings.end(), stmt);
    ROSE_ASSERT (j != siblings.end());
    siblings.erase(j);
    // LowLevelRewrite::remove(*i);
  } else {
    parent->replace_statement(stmt, new SgNullStatement(TRANS_FILE));
  }
}


#ifndef USE_ROSE
// Remove all unused labels in a section of code.
void SageInterface::removeUnusedLabels(SgNode* top) {

class FindUsedAndAllLabelsVisitor: public AstSimpleProcessing {
  SgLabelStatementPtrSet& used;
  SgLabelStatementPtrSet& all;

  public:
  FindUsedAndAllLabelsVisitor(SgLabelStatementPtrSet& used,
                              SgLabelStatementPtrSet& all):
    used(used), all(all) {}

  virtual void visit(SgNode* n) {
    if (isSgGotoStatement(n)) {
      used.insert(isSgGotoStatement(n)->get_label());
    }
    if (isSgLabelStatement(n)) {
      all.insert(isSgLabelStatement(n));
    }
  }
};

  SgLabelStatementPtrSet used;
  SgLabelStatementPtrSet unused;
  FindUsedAndAllLabelsVisitor(used, unused).traverse(top, preorder);
  for (SgLabelStatementPtrSet::iterator i = used.begin();
       i != used.end(); ++i) {
    assert (unused.find(*i) != unused.end());
    // std::cout << "Keeping used label " << (*i)->get_label().str() << std::endl;
    unused.erase(*i);
  }
  for (SgLabelStatementPtrSet::iterator i = unused.begin();
       i != unused.end(); ++i) {
    // std::cout << "Removing unused label " << (*i)->get_label().str() << std::endl;
    myRemoveStatement(*i);
  }
}
#endif

  SgStatement* SageInterface::getLoopBody(SgScopeStatement* loopStmt) {
    if (isSgWhileStmt(loopStmt)) return isSgWhileStmt(loopStmt)->get_body();
    if (isSgForStatement(loopStmt)) return isSgForStatement(loopStmt)->get_loop_body();
    if (isSgDoWhileStmt(loopStmt)) return isSgDoWhileStmt(loopStmt)->get_body();

	ROSE_ASSERT (!"Bad loop kind");
    return NULL;
  }

  void SageInterface::setLoopBody(SgScopeStatement* loopStmt, SgStatement* body) {
    if (isSgWhileStmt(loopStmt)) {
      isSgWhileStmt(loopStmt)->set_body(body);
    } else if (isSgForStatement(loopStmt)) {
      isSgForStatement(loopStmt)->set_loop_body(body);
    } else if (isSgDoWhileStmt(loopStmt)) {
      isSgDoWhileStmt(loopStmt)->set_body(body);
    } else {
      ROSE_ASSERT (!"Bad loop kind");
    }
    body->set_parent(loopStmt);
  }

  SgStatement* SageInterface::getLoopCondition(SgScopeStatement* loopStmt) {
    if (isSgWhileStmt(loopStmt)) return isSgWhileStmt(loopStmt)->get_condition();
    if (isSgForStatement(loopStmt)) return isSgForStatement(loopStmt)->get_test();
    if (isSgDoWhileStmt(loopStmt)) return isSgDoWhileStmt(loopStmt)->get_condition();

	ROSE_ASSERT (!"Bad loop kind");
    return NULL;
  }

  void SageInterface::setLoopCondition(SgScopeStatement* loopStmt, SgStatement* cond) {
    if (isSgWhileStmt(loopStmt)) {
      isSgWhileStmt(loopStmt)->set_condition(cond);
    } else if (isSgForStatement(loopStmt)) {
      isSgForStatement(loopStmt)->set_test(cond);
    } else if (isSgDoWhileStmt(loopStmt)) {
      isSgDoWhileStmt(loopStmt)->set_condition(cond);
    } else {
      ROSE_ASSERT (!"Bad loop kind");
    }
    cond->set_parent(loopStmt);
  }

//! A helper function to strip off possible type casting operations for an expression
// usually useful when compare two expressions to see if they actually refer to the same variable
static SgExpression* SkipCasting (SgExpression* exp)
{
  SgCastExp* cast_exp = isSgCastExp(exp);
   if (cast_exp != NULL)
   {
      SgExpression* operand = cast_exp->get_operand();
      assert(operand != 0);
      return SkipCasting(operand);
   }
  else
    return exp;
}

//! Promote the single variable declaration statement outside of the for loop header's init statement, e.g. for (int i=0;) becomes int i_x; for (i_x=0;..) and rewrite the loop with the new index variable
bool SageInterface::normalizeForLoopInitDeclaration(SgForStatement* loop)
{
  ROSE_ASSERT(loop!=NULL);

  SgStatementPtrList &init = loop ->get_init_stmt();
  if (init.size() !=1) // We only handle one statement case
    return false;
  else
  {
    SgStatement* init1 = init.front();
    SgVariableDeclaration* decl = isSgVariableDeclaration(init1);
    if (decl)
    {
      SgVariableSymbol* osymbol = getFirstVarSym(decl);
      SgInitializedName* ivarname = decl->get_variables().front();
      SgExpression* lbast = NULL; // the lower bound, initial state
      ROSE_ASSERT(ivarname != NULL);
      SgInitializer * initor = ivarname->get_initializer();
      if (isSgAssignInitializer(initor))
      {
        lbast = isSgAssignInitializer(initor)->get_operand();
      } else
      { //SgConstructorInitializer etc.
        // other complex declaration statements, such as Decomposition::Iterator ditr(&decomp) should be skipped
        // they cause a loop to be non-canonical.
        return false;
      }

      // add a new statement like int i; and insert it to the enclosing function
      // There are multiple choices about where to insert this statement:
      //  global scope: max name pollution,
      //  right before the loop: mess up perfectly nested loops
      //  So we prepend the statement to the enclosing function's body
      SgFunctionDefinition* funcDef =  getEnclosingFunctionDefinition(loop);
      ROSE_ASSERT(funcDef!=NULL);
      SgBasicBlock* funcBody = funcDef->get_body();
      ROSE_ASSERT(funcBody!=NULL);
      //TODO a better name
      std::ostringstream os;
      os<<ivarname->get_name().getString();
      os<<"_nom_";
      os<<++gensym_counter;
      SgVariableDeclaration* ndecl = buildVariableDeclaration(os.str(),ivarname->get_type(), NULL, funcBody);
      prependStatement(ndecl, funcBody);
      SgVariableSymbol* nsymbol = getFirstVarSym(ndecl);

      // replace variable ref to the new symbol
      Rose_STL_Container<SgNode*> varRefs = NodeQuery::querySubTree(loop,V_SgVarRefExp);
      for (Rose_STL_Container<SgNode *>::iterator i = varRefs.begin(); i != varRefs.end(); i++)
      {
        SgVarRefExp *vRef = isSgVarRefExp((*i));
        if (vRef->get_symbol()==osymbol)
          vRef->set_symbol(nsymbol);
      }
      // replace for (int i=0;) with for (i=0;)
      SgExprStatement* ninit = buildAssignStatement(buildVarRefExp(nsymbol),deepCopy(lbast));
      removeStatement(decl); //any side effect to the symbol? put after symbol replacement anyway
      init.push_back(ninit);
      ROSE_ASSERT (loop->get_for_init_stmt () != NULL);
      // ninit->set_parent(loop);
       ninit->set_parent(loop->get_for_init_stmt ());
    }
  }
  return true;
}
//! Normalize a for loop, part of migrating Qing's loop handling into SageInterface
// Her loop translation does not pass AST consistency tests so we rewrite some of them here
// NormalizeCPP.C  NormalizeLoopTraverse::ProcessLoop()
bool SageInterface::forLoopNormalization(SgForStatement* loop)
{
  ROSE_ASSERT(loop != NULL);
  // Normalize initialization statement of the for loop
  // -------------------------------------
  // for (int i=0;... ) becomes int i; for (i=0;..)
  // Only roughly check here, isCanonicalForLoop() should be called to have a stricter check
  if (!normalizeForLoopInitDeclaration(loop))
    return false;

  // Normalized the test expressions
  // -------------------------------------
  SgExpression* test = loop->get_test_expr();
  SgExpression* testlhs=NULL, * testrhs=NULL;
  if (isSgBinaryOp(test))
  {
    testlhs = isSgBinaryOp(test)->get_lhs_operand();
    testrhs = isSgBinaryOp(test)->get_rhs_operand();
    ROSE_ASSERT(testlhs && testrhs);
  }
  else
    return false;
  // keep the variable since test will be removed later on
  SgVarRefExp* testlhs_var = isSgVarRefExp(SkipCasting(testlhs));
  if (testlhs_var == NULL )
    return false;
  SgVariableSymbol * var_symbol = testlhs_var->get_symbol();
  if (var_symbol==NULL)
    return false;

  switch (test->variantT()) {
    case V_SgLessThanOp:  // i<x is normalized to i<= (x-1)
      replaceExpression(test, buildLessOrEqualOp(deepCopy(testlhs),
            buildSubtractOp(deepCopy(testrhs), buildIntVal(1))));
      // deepDelete(test);// replaceExpression() does this already by default.
      break;
    case V_SgGreaterThanOp: // i>x is normalized to i>= (x+1)
      replaceExpression( test, buildGreaterOrEqualOp(deepCopy(testlhs),
            buildAddOp(deepCopy(testrhs), buildIntVal(1))));
      break;
    case V_SgLessOrEqualOp:
    case V_SgGreaterOrEqualOp:
    case V_SgNotEqualOp: //TODO Do we want to allow this?
      break;
    default:
      return false;
  }
  // Normalize the increment expression
  // -------------------------------------
  SgExpression* incr = loop->get_increment();
  ROSE_ASSERT(incr != NULL);
  switch (incr->variantT()) {
    case V_SgPlusPlusOp: //i++ is normalized to i+=1
      {
        // check if the variables match
        SgVarRefExp* incr_var = isSgVarRefExp(SkipCasting(isSgPlusPlusOp(incr)->get_operand()));
        if (incr_var == NULL) return false;
        if ( incr_var->get_symbol() != var_symbol)
          return false;
        replaceExpression(incr,
            buildPlusAssignOp(isSgExpression(deepCopy(incr_var)),buildIntVal(1)));
        break;
      }
    case V_SgMinusMinusOp: //i-- is normalized to i+=-1
      {
        // check if the variables match
        SgVarRefExp* incr_var = isSgVarRefExp(SkipCasting(isSgMinusMinusOp(incr)->get_operand()));
        if (incr_var == NULL) return false;
        if ( incr_var->get_symbol() != var_symbol)
          return false;
        replaceExpression(incr,
            buildPlusAssignOp(isSgExpression(deepCopy(incr_var)), buildIntVal(-1)));
        break;
      }
    case V_SgMinusAssignOp: // i-= s is normalized to i+= -s
      {
        SgVarRefExp* incr_var = isSgVarRefExp(SkipCasting(isSgMinusAssignOp(incr)->get_lhs_operand()));
        SgExpression* rhs = isSgMinusAssignOp(incr)->get_rhs_operand();
        ROSE_ASSERT (rhs != NULL);
        if (incr_var == NULL) return false;
        if ( incr_var->get_symbol() != var_symbol)
          return false;
        replaceExpression(incr,
            buildPlusAssignOp(isSgExpression(deepCopy(incr_var)), buildMultiplyOp(buildIntVal(-1), copyExpression(rhs))));
        break;
      }
    case V_SgAssignOp:
    case V_SgPlusAssignOp:
      break;
    default:
      return false;
  }

  // Normalize the loop body: ensure there is a basic block
  SgBasicBlock* body = ensureBasicBlockAsBodyOfFor(loop);
  ROSE_ASSERT(body!=NULL);
   // Liao, 9/22/2009
   // folding entire loop may cause decreased accuracy for floating point operations
   // we only want to fold the loop controlling expressions
  //constantFolding(loop->get_parent());
  constantFolding(loop->get_test());
  constantFolding(loop->get_increment());


  return true;
}
//!Normalize a Fortran Do loop. Make the default increment expression (1) explicit
bool SageInterface::doLoopNormalization(SgFortranDo* loop)
{
  // TODO, normalize continue to enddo ?
  ROSE_ASSERT (loop != NULL);
  SgExpression* e_3 = loop->get_increment();
  if (isSgNullExpression(e_3))
  {
    loop->set_increment(buildIntVal(1));
    delete (e_3);
  }

  return true;
}

#if 0
bool SageInterface::loopUnrolling(SgForStatement* loop, size_t unrolling_factor)
{
  // normalize the loop first
  if (!forLoopNormalization(loop))
    return false; // input loop cannot be normalized to a canonical form
  // prepare Loop transformation environment
  SgFunctionDeclaration* func = getEnclosingFunctionDeclaration(loop);
  ROSE_ASSERT(func!=NULL);
  AstInterfaceImpl faImpl(func->get_definition()->get_body());
  AstInterface fa(&faImpl);
  ArrayAnnotation* annot = ArrayAnnotation::get_inst();
  ArrayInterface array_interface (*annot);
  array_interface.initialize(fa, AstNodePtrImpl(func->get_definition()));
  array_interface.observe(fa);
  LoopTransformInterface lpTrans(fa, array_interface);

  // invoke the unrolling defined in Qing's code
  // the traversal will skip the input node ptr, so we pass loop's parent ptr instead
  AstNodePtr result = AstNodePtrImpl(loop->get_parent()) ;

  LoopUnrolling lu(unrolling_factor);
  //LoopUnrolling lu(unrolling_factor,LoopUnrolling::COND_LEFTOVER);//works but not a good choice
  //if (lu.cmdline_configure()) // this will cause unrolling to be skipped if no -unroll is used in command line
  result = lu(lpTrans, result);
  return true;
}
#else

// a brand new serious implementation for loop unrolling, Liao, 6/25/2009
/* Handle left-over iterations if iteration_count%unrolling_factor != 0
 * Handle stride (step) >1
 * Assuming loop is normalized to [lb,ub,step], ub is inclusive (<=, >=)
 *
 *  iteration_count = (ub-lb+1)%step ==0?(ub-lb+1)/step: (ub-lb+1)/step+1
 *  fringe = iteration_count%unroll_factor==0 ? 0:unroll_factor*step;
 *    fringe ==0 if no leftover iterations
 *    otherwise adjust ub so the leftover iterations will put into the last fringe loop
 *  unrolled loop's header: for (i=lb;i<=ub - fringe; i+= step*unroll_factor)
 *  loop body: copy body n times from 0 to factor -1
 *     stmt(i+ 0*step); ...; stmt (i+ (factor-1)*step);
 *  fringe loop: the same as the original loop, except for no init statement
 *
 * e.g:
 * // unrolling 3 times for the following loop with stride !=1
 *       for (i=0; i<=9; i+=3)
 *       {
 *         a[i]=i;
 *       }
 * // it becomes
 *     // iteration count = 10%3=1 -> 10/3+1 = 4
 *     // fringe = 4%3 =1 --> 3*3
 *     // ub-fringe = 9-3*3
 *        for (i=0; i<=9-3*3; i+=3*3)
 *     {
 *       a[i+3*0]=i;
 *       a[i+3*1]=i;
 *       a[i+3*2]=i;
 *     }
 *     // i=9 is the leftover iteration
 *     for (; i<=9; i+=3)
 *     {
 *       a[i]=i;
 *     }
 *
 */
bool SageInterface::loopUnrolling(SgForStatement* target_loop, size_t unrolling_factor)
{
  //Handle 0 and 1, which means no unrolling at all
  if (unrolling_factor <= 1)
    return true;
  // normalize the target loop first
  if (!forLoopNormalization(target_loop));
  {// the return value is not reliable
    //    cerr<<"Error in SageInterface::loopUnrolling(): target loop cannot be normalized."<<endl;
    //    dumpInfo(target_loop);
    //    return false;
  }
  // grab the target loop's essential header information
  SgInitializedName* ivar = NULL;
  SgExpression* lb = NULL;
  SgExpression* ub = NULL;
  SgExpression* step = NULL;
  SgStatement* orig_body = NULL;
  if (!isCanonicalForLoop(target_loop, &ivar, &lb, &ub, &step, &orig_body))
  {
    cerr<<"Error in SageInterface::loopUnrolling(): target loop is not canonical."<<endl;
    dumpInfo(target_loop);
    return false;
  }
  ROSE_ASSERT(ivar&& lb && ub && step);
  ROSE_ASSERT(isSgBasicBlock(orig_body));

   // generate the fringe loop
   bool needFringe = true;
   SgForStatement* fringe_loop = deepCopy<SgForStatement>(target_loop);
   insertStatementAfter(target_loop,fringe_loop);
   removeStatement(fringe_loop->get_for_init_stmt());
   fringe_loop->set_for_init_stmt(NULL);

  // _lu_iter_count = (ub-lb+1)%step ==0?(ub-lb+1)/step: (ub-lb+1)/step+1;
  SgExpression* raw_range_exp =buildSubtractOp(buildAddOp(copyExpression(ub),buildIntVal(1)),
            copyExpression(lb));
  raw_range_exp->set_need_paren(true);
  SgExpression* range_d_step_exp = buildDivideOp(raw_range_exp,copyExpression(step));//(ub-lb+1)/step
  SgExpression* condition_1 = buildEqualityOp(buildModOp(copyExpression(raw_range_exp),copyExpression(step)),buildIntVal(0)); //(ub-lb+1)%step ==0

  SgExpression* iter_count_exp = buildConditionalExp(condition_1,range_d_step_exp, buildAddOp(copyExpression(range_d_step_exp),buildIntVal(1)));
  // fringe = iteration_count%unroll_factor==0 ? 0:unroll_factor*step
  SgExpression* condition_2 = buildEqualityOp(buildModOp(iter_count_exp, buildIntVal(unrolling_factor)), buildIntVal(0));
  SgExpression* initor = buildConditionalExp(condition_2, buildIntVal(0), buildMultiplyOp(buildIntVal(unrolling_factor),copyExpression(step)));

   SgScopeStatement* scope = target_loop->get_scope();
   ROSE_ASSERT(scope != NULL);
   string fringe_name = "_lu_fringe";
   SgVariableDeclaration* fringe_decl = buildVariableDeclaration(fringe_name, buildIntType(),buildAssignInitializer(initor), scope);
   insertStatementBefore(target_loop, fringe_decl);
   attachComment(fringe_decl, "iter_count = (ub-lb+1)%step ==0?(ub-lb+1)/step: (ub-lb+1)/step+1;");
   attachComment(fringe_decl, "fringe = iter_count%unroll_factor==0 ? 0:unroll_factor*step");

  // compile-time evaluate to see if initor is a constant of value 0
  // if so, the iteration count can be divided even by the unrolling factor
  // and no fringe loop is needed
  // WE have to fold on its parent node to get a possible constant since
  // constant folding only folds children nodes, not the current node to a constant
   ConstantFolding::constantFoldingOptimization(fringe_decl,false);
   SgInitializedName * ivarname = fringe_decl->get_variables().front();
   ROSE_ASSERT(ivarname != NULL);
   // points to a new address if constant folding happens
   SgAssignInitializer * init1 = isSgAssignInitializer(ivarname->get_initializer());
   if (init1)
    if (isSgIntVal(init1->get_operand_i()))
     if (isSgIntVal(init1->get_operand_i())->get_value() == 0)
       needFringe = false;

  // rewrite loop header ub --> ub -fringe; step --> step *unrolling_factor
   SgBinaryOp* ub_bin_op = isSgBinaryOp(ub->get_parent());
   ROSE_ASSERT(ub_bin_op);
   if (needFringe)
     ub_bin_op->set_rhs_operand(buildSubtractOp(copyExpression(ub),buildVarRefExp(fringe_name,scope)));
   else
   {
     ub_bin_op->set_rhs_operand(copyExpression(ub));
     removeStatement(fringe_decl);
   }

   SgBinaryOp* step_bin_op = isSgBinaryOp(step->get_parent());
   ROSE_ASSERT(step_bin_op != NULL);
   step_bin_op->set_rhs_operand(buildMultiplyOp(copyExpression(step),buildIntVal(unrolling_factor)));

   bool isPlus = false;
   if (isSgPlusAssignOp(step_bin_op))
     isPlus = true;
    else if (isSgMinusAssignOp(step_bin_op))
      isPlus = false;
    else
    {
      cerr<<"Error in SageInterface::loopUnrolling(): illegal incremental exp of a canonical loop"<<endl;
      dumpInfo(step_bin_op);
      ROSE_ASSERT(false);
    }

   // copy loop body factor -1 times, and replace reference to ivar  with ivar +/- step*[1 to factor-1]
   for (size_t i =1; i<unrolling_factor; i++)
   {
     SgBasicBlock* body = isSgBasicBlock(deepCopy(fringe_loop->get_loop_body())); // normalized loop has a BB body
     ROSE_ASSERT(body);
     // replace reference to ivar with ivar +/- step*i
     SgExpression* new_exp = NULL;
     std::vector<SgVarRefExp*> refs = querySubTree<SgVarRefExp> (body, V_SgVarRefExp);
     for (std::vector<SgVarRefExp*>::iterator iter = refs.begin(); iter !=refs.end(); iter++)
     {
       SgVarRefExp* refexp = *iter;
       if (refexp->get_symbol()==ivar->get_symbol_from_symbol_table())
       {
         //build replacement  expression if it is NULL
         if (new_exp == NULL)
         {
           if (isPlus) //ivar +/- step * i
           new_exp = buildAddOp(buildVarRefExp(ivar,scope),buildMultiplyOp(copyExpression(step),buildIntVal(i)));
           else
           new_exp = buildSubtractOp(buildVarRefExp(ivar,scope),buildMultiplyOp(copyExpression(step),buildIntVal(i)));

         }
         // replace it with the right one
         replaceExpression(refexp, new_exp);
       }
     }
     // copy body to loop body, this should be a better choice
     // to avoid redefinition of variables after unrolling (new scope is introduced to avoid this)
     appendStatement(body,isSgBasicBlock(orig_body));
    // moveStatementsBetweenBlocks(body,isSgBasicBlock(orig_body));
   }

   // remove the fringe loop if not needed finally
   // it is used to buffering the original loop body before in either cases
   if (!needFringe)
     removeStatement(fringe_loop);

   // constant folding for the transformed AST
   ConstantFolding::constantFoldingOptimization(scope,false);
   //ConstantFolding::constantFoldingOptimization(getProject(),false);

  return true;
}
#endif

// Liao, 6/15/2009
//! A helper function to calculate n!
static size_t myfactorial (size_t n)
{
  size_t result=1;
  for (size_t i=2; i<=n; i++)
    result*=i;
  return result;
}

#endif

#ifndef USE_ROSE

//! A helper function to return a permutation order for n elements based on a lexicographical order number
std::vector<size_t> getPermutationOrder( size_t n, size_t lexicoOrder)
{
  size_t k = lexicoOrder;
  std::vector<size_t> s(n);
  // initialize the permutation vector
  for (size_t i=0; i<n; i++)
    s[i]=i;

  //compute (n- 1)!
  size_t factorial = myfactorial(n-1);
  //check if the number is not in the range of [0, n! - 1]
  if (k/n>=factorial)
  {
    printf("Error: in getPermutationOrder(), lexicoOrder is larger than n!-1\n");
    ROSE_ASSERT(false);
  }
  // Algorithm:
  //check each element of the array, excluding the right most one.
  //the goal is to find the right element for each s[j] from 0 to n-2
  // method: each position is associated a factorial number
  //    s[0] -> (n-1)!
  //    s[1] -> (n-2)! ...
  // the input number k is divided by the factorial at each position (6, 3, 2, 1 for size =4)
  //   so only big enough k can have non-zero value after division
  //   0 value means no change to the position for the current iteration
  // The non-zero value is further modular by the number of the right hand elements of the current element.
  //     (mode on 4, 3, 2 to get offset 1-2-3, 1-2, 1 from the current position 0, 1, 2)
  //  choose one of them to be moved to the current position,
  //  shift elements between the current and the moved element to the right direction for one position
  for (size_t j=0; j<n-1; j++)
  {
    //calculates the next cell from the cells left
    //(the cells in the range [j, s.length - 1])
    int tempj = (k/factorial) % (n - j);
    //Temporarily saves the value of the cell needed
    // to add to the permutation this time
    int temps = s[j+tempj];
    //shift all elements to "cover" the "missing" cell
    //shift them to the right
    for (size_t i=j+tempj; i>j; i--)
    {
      s[i] = s[i-1]; //shift the chain right
    }
    // put the chosen cell in the correct spot
    s[j]= temps;
    // updates the factorial
    factorial = factorial /(n-(j+1));
  }
#if 0
  for (size_t i = 0; i<n; i++)
    cout<<" "<<s[i];
  cout<<endl;
#endif
  return s;
}

//! Tile the n-level (starting from 1) of a perfectly nested loop nest using tiling size s
/* Translation
 Before:
  for (i = 0; i < 100; i++)
    for (j = 0; j < 100; j++)
      for (k = 0; k < 100; k++)
        c[i][j]= c[i][j]+a[i][k]*b[k][j];

  After tiling i loop nest's level 3 (k-loop) with size 5, it becomes

// added a new controlling loop at the outer most level
  int _lt_var_k;
  for (_lt_var_k = 0; _lt_var_k <= 99; _lt_var_k += 1 * 5) {
    for (i = 0; i < 100; i++)
      for (j = 0; j < 100; j++)
        // rewritten loop header , normalized also
        for (k = _lt_var_k; k <= (99 < (_lt_var_k + 5 - 1))?99 : (_lt_var_k + 5 - 1); k += 1) {
          c[i][j] = c[i][j] + a[i][k] * b[k][j];
        }
  }
// finally run constant folding

 */
bool SageInterface::loopTiling(SgForStatement* loopNest, size_t targetLevel, size_t tileSize)
{
  ROSE_ASSERT(loopNest != NULL);
  ROSE_ASSERT(targetLevel >0);
 // ROSE_ASSERT(tileSize>0);// 1 is allowed
 // skip tiling if tiling size is 0 (no tiling), we allow 0 to get a reference value for the original code being tuned
 // 1 (no need to tile)
  if (tileSize<=1)
    return true;
  // Locate the target loop at level n
  std::vector<SgForStatement* > loops= SageInterface::querySubTree<SgForStatement>(loopNest,V_SgForStatement);
  ROSE_ASSERT(loops.size()>=targetLevel);
  SgForStatement* target_loop = loops[targetLevel -1]; // adjust to numbering starting from 0

  // normalize the target loop first
  if (!forLoopNormalization(target_loop));
  {// the return value is not reliable
//    cerr<<"Error in SageInterface::loopTiling(): target loop cannot be normalized."<<endl;
//    dumpInfo(target_loop);
//    return false;
  }
   // grab the target loop's essential header information
   SgInitializedName* ivar = NULL;
   SgExpression* lb = NULL;
   SgExpression* ub = NULL;
   SgExpression* step = NULL;
   if (!isCanonicalForLoop(target_loop, &ivar, &lb, &ub, &step, NULL))
   {
     cerr<<"Error in SageInterface::loopTiling(): target loop is not canonical."<<endl;
     dumpInfo(target_loop);
     return false;
   }
   ROSE_ASSERT(ivar&& lb && ub && step);

  // Add a controlling loop around the top loop nest
  // Ensure the parent can hold more than one children
  SgLocatedNode* parent = ensureBasicBlockAsParent(loopNest);
  ROSE_ASSERT(parent!= NULL);
     // Now we can prepend a controlling loop index variable: __lt_var_originalIndex
  string ivar2_name = "_lt_var_"+ivar->get_name().getString();
  SgScopeStatement* scope = loopNest->get_scope();
  SgVariableDeclaration* loop_index_decl = buildVariableDeclaration
  (ivar2_name, buildIntType(),NULL, scope);
  insertStatementBefore(loopNest, loop_index_decl);
   // init statement of the loop header, copy the lower bound
   SgStatement* init_stmt = buildAssignStatement(buildVarRefExp(ivar2_name,scope), copyExpression(lb));
   //two cases <= or >= for a normalized loop
   SgExprStatement* cond_stmt = NULL;
   SgExpression* orig_test = target_loop->get_test_expr();
   if (isSgBinaryOp(orig_test))
   {
     if (isSgLessOrEqualOp(orig_test))
       cond_stmt = buildExprStatement(buildLessOrEqualOp(buildVarRefExp(ivar2_name,scope),copyExpression(ub)));
     else if (isSgGreaterOrEqualOp(orig_test))
     {
       cond_stmt = buildExprStatement(buildGreaterOrEqualOp(buildVarRefExp(ivar2_name,scope),copyExpression(ub)));
       }
     else
     {
       cerr<<"Error: illegal condition operator for a canonical loop"<<endl;
       dumpInfo(orig_test);
       ROSE_ASSERT(false);
     }
   }
   else
   {
     cerr<<"Error: illegal condition expression for a canonical loop"<<endl;
     dumpInfo(orig_test);
     ROSE_ASSERT(false);
   }
   ROSE_ASSERT(cond_stmt != NULL);

   // build loop incremental  I
   // expression var+=up*tilesize or var-=upper * tilesize
   SgExpression* incr_exp = NULL;
   SgExpression* orig_incr_exp = target_loop->get_increment();
   if( isSgPlusAssignOp(orig_incr_exp))
   {
     incr_exp = buildPlusAssignOp(buildVarRefExp(ivar2_name,scope), buildMultiplyOp(copyExpression(step), buildIntVal(tileSize)));
   }
    else if (isSgMinusAssignOp(orig_incr_exp))
    {
      incr_exp = buildMinusAssignOp(buildVarRefExp(ivar2_name,scope), buildMultiplyOp(copyExpression(step), buildIntVal(tileSize)));
    }
    else
    {
      cerr<<"Error: illegal increment expression for a canonical loop"<<endl;
      dumpInfo(orig_incr_exp);
      ROSE_ASSERT(false);
    }
    SgForStatement* control_loop = buildForStatement(init_stmt, cond_stmt,incr_exp, buildBasicBlock());
  insertStatementBefore(loopNest, control_loop);
  // move loopNest into the control loop
  removeStatement(loopNest);
  appendStatement(loopNest,isSgBasicBlock(control_loop->get_loop_body()));

  // rewrite the lower (i=lb), upper bounds (i<=/>= ub) of the target loop
  SgAssignOp* assign_op  = isSgAssignOp(lb->get_parent());
  ROSE_ASSERT(assign_op);
  assign_op->set_rhs_operand(buildVarRefExp(ivar2_name,scope));
    // ub< var_i+tileSize-1? ub:var_i+tileSize-1
  SgBinaryOp* bin_op = isSgBinaryOp(ub->get_parent());
  ROSE_ASSERT(bin_op);
  SgExpression* ub2 = buildSubtractOp(buildAddOp(buildVarRefExp(ivar2_name,scope), buildIntVal(tileSize)), buildIntVal(1));
  SgExpression* test_exp = buildLessThanOp(copyExpression(ub),ub2);
  test_exp->set_need_paren(true);
  ub->set_need_paren(true);
  ub2->set_need_paren(true);
  SgConditionalExp * triple_exp = buildConditionalExp(test_exp,copyExpression(ub), copyExpression(ub2));
  bin_op->set_rhs_operand(triple_exp);
  // constant folding
  // folding entire loop may decrease the accuracy of floating point calculation
  // we fold loop control expressions only
  //constantFolding(control_loop->get_scope());
  constantFolding(control_loop->get_test());
  constantFolding(control_loop->get_increment());
  return true;
}

//! Interchange/Permutate a n-level perfectly-nested loop rooted at 'loop' using a lexicographical order number within [0,depth!)
bool SageInterface::loopInterchange(SgForStatement* loop, size_t depth, size_t lexicoOrder)
{
  if (lexicoOrder == 0) // allow 0 to mean no interchange at all
    return true;
  // parameter verification
  ROSE_ASSERT(loop != NULL);
  //must have at least two levels
  ROSE_ASSERT (depth >1);
  ROSE_ASSERT(lexicoOrder<myfactorial(depth));
  //TODO need to verify the input loop has n perfectly-nested children loops inside
  // save the loop nest's headers: init, test, and increment
  std::vector<SgForStatement* > loopNest = SageInterface::querySubTree<SgForStatement>(loop,V_SgForStatement);
  ROSE_ASSERT(loopNest.size()>=depth);
  std::vector<std::vector<SgNode*> > loopHeads;
  for (std::vector<SgForStatement* > ::iterator i = loopNest.begin(); i!= loopNest.end(); i++)
  {
    SgForStatement* cur_loop = *i;
    std::vector<SgNode*> head;
    head.push_back(cur_loop->get_for_init_stmt());
    head.push_back(cur_loop->get_test());
    head.push_back(cur_loop->get_increment());
    loopHeads.push_back(head);
  }

  // convert the lexicographical number to a permutation order array permutation[depth]
  std::vector<size_t> changedOrder = getPermutationOrder (depth, lexicoOrder);
  // rewrite the loop nest to reflect the permutation
  // set the header to the new header based on the permutation array
  for (size_t i=0; i<depth; i++)
  {
    // only rewrite if necessary
    if (i != changedOrder[i])
    {
      SgForStatement* cur_loop = loopNest[i];
      std::vector<SgNode*> newhead = loopHeads[changedOrder[i]];

      SgForInitStatement* init = isSgForInitStatement(newhead[0]);
      //ROSE_ASSERT(init != NULL) // could be NULL?
      ROSE_ASSERT(init != cur_loop->get_for_init_stmt());
      cur_loop->set_for_init_stmt(init);
      if (init)
      {
        init->set_parent(cur_loop);
        setSourcePositionForTransformation(init);
      }

      SgStatement* test = isSgStatement(newhead[1]);
      cur_loop->set_test(test);
      if (test)
      {
        test->set_parent(cur_loop);
        setSourcePositionForTransformation(test);
      }

      SgExpression* incr = isSgExpression(newhead[2]);
      cur_loop->set_increment(incr);
      if (incr)
      {
        incr->set_parent(cur_loop);
        setSourcePositionForTransformation(incr);
      }
    }
  }
  return true;
}

//!Return the loop index variable for a for loop
SgInitializedName* SageInterface::getLoopIndexVariable(SgNode* loop)
{
  ROSE_ASSERT(loop != NULL);
  SgForStatement* fs = isSgForStatement(loop);
  ROSE_ASSERT (fs != NULL);

  //Check initialization statement is something like i=xx;
  SgStatementPtrList & init = fs->get_init_stmt();
  if (init.size() !=1)
  {
    cerr<<"SageInterface::getLoopIndexVariable(), no or more than one initialization statements are encountered. Not supported yet "<<endl;
    ROSE_ASSERT(false);
  }
  SgStatement* init1 = init.front();
  SgExpression* ivarast=NULL;
  SgInitializedName* ivarname=NULL;

  bool isCase1=false, isCase2=false;
  //consider C99 style: for (int i=0;...)
  if (isSgVariableDeclaration(init1))
  {
    SgVariableDeclaration* decl = isSgVariableDeclaration(init1);
    ivarname = decl->get_variables().front();
    ROSE_ASSERT(ivarname != NULL);
    SgInitializer * initor = ivarname->get_initializer();
    if (isSgAssignInitializer(initor))
      isCase1 = true;
  }// other regular case: for (i=0;..)
  else if (isAssignmentStatement(init1, &ivarast))
  {
    SgVarRefExp* var = isSgVarRefExp(SkipCasting(ivarast));
    if (var)
    {
      ivarname = var->get_symbol()->get_declaration();
      isCase2 = true;
    }
  } 
  else if (SgExprStatement* exp_stmt = isSgExprStatement(init1))
  { //case like: for (i = 1, len1 = 0, len2=0; i <= n; i++) 
     // AST is: SgCommaOpExp -> SgAssignOp -> SgVarRefExp
    if (SgCommaOpExp* comma_exp = isSgCommaOpExp(exp_stmt->get_expression()))
    {
      SgCommaOpExp* leaf_exp = comma_exp;
      while (isSgCommaOpExp(leaf_exp->get_lhs_operand()))
        leaf_exp = isSgCommaOpExp(leaf_exp->get_lhs_operand());
      if (SgAssignOp* assign_op = isSgAssignOp(leaf_exp->get_lhs_operand()))
      {
        SgVarRefExp* var = isSgVarRefExp(assign_op->get_lhs_operand());
        if (var)
        {
          ivarname = var->get_symbol()->get_declaration();
        }
      }
    }
  }
  else
  {
    cerr<<"Error. SageInterface::getLoopIndexVariable(). Unhandled init_stmt type of SgForStatement"<<endl;
    cerr<<"Init statement is :"<<init1->class_name() <<" " <<init1->unparseToString()<<endl;
    init1->get_file_info()->display("Debug"); 
    ROSE_ASSERT (false);
  }
  // Cannot be both true
 // ROSE_ASSERT(!(isCase1&&isCase2));

  //Check loop index's type
  //ROSE_ASSERT(isStrictIntegerType(ivarname->get_type()));
  return ivarname;
}
//! Get Fortran Do loop's key features
bool SageInterface::isCanonicalDoLoop(SgFortranDo* loop,SgInitializedName** ivar/*=NULL*/, SgExpression** lb/*=NULL*/, SgExpression** ub/*=NULL*/, SgExpression** step/*=NULL*/, SgStatement** body/*=NULL*/, bool *hasIncrementalIterationSpace/*= NULL*/, bool* isInclusiveUpperBound/*=NULL*/)
{
  ROSE_ASSERT(loop != NULL);
  SgFortranDo* fs = isSgFortranDo(loop);
  if (fs == NULL)
    return false;
  // 1. Check initialization statement is something like i=xx;
  SgExpression * init = fs->get_initialization();
  if (init == NULL)
    return false;
  SgAssignOp* init_assign = isSgAssignOp (init);
  SgExpression *lbast=NULL, *ubast=NULL;
 // SgExpression* ivarast=NULL, *stepast=NULL;
  SgInitializedName* ivarname=NULL;

  bool isCase1=false;
  if (init_assign)
   {
     SgVarRefExp* var = isSgVarRefExp(init_assign->get_lhs_operand());
     if (var)
       ivarname = var->get_symbol()->get_declaration();
     lbast = init_assign->get_rhs_operand();
     if (ivarname && lbast )
       isCase1 = true;
   }
   // if not i=1
    if (!isCase1)
      return false;

  //Check loop index's type
  if (!SageInterface::isStrictIntegerType(ivarname->get_type()))
    return false;
#if 0
  //2. Check test expression i [<=, >=, <, > ,!=] bound
  SgBinaryOp* test = isSgBinaryOp(fs->get_test_expr());
  if (test == NULL)
    return false;
  switch (test->variantT()) {
    case V_SgLessOrEqualOp:
       if (isInclusiveUpperBound != NULL)
         *isInclusiveUpperBound = true;
       if (hasIncrementalIterationSpace != NULL)
         *hasIncrementalIterationSpace = true;
       break;
    case V_SgLessThanOp:
       if (isInclusiveUpperBound != NULL)
         *isInclusiveUpperBound = false;
       if (hasIncrementalIterationSpace != NULL)
         *hasIncrementalIterationSpace = true;
       break;
    case V_SgGreaterOrEqualOp:
       if (isInclusiveUpperBound != NULL)
         *isInclusiveUpperBound = true;
        if (hasIncrementalIterationSpace != NULL)
         *hasIncrementalIterationSpace = false;
      break;
    case V_SgGreaterThanOp:
       if (isInclusiveUpperBound != NULL)
         *isInclusiveUpperBound = false;
       if (hasIncrementalIterationSpace != NULL)
         *hasIncrementalIterationSpace = false;
      break;
//    case V_SgNotEqualOp: // Do we really want to allow this != operator ?
      break;
    default:
      return false;
  }
  // check the tested variable is the same as the loop index
  SgVarRefExp* testvar = isSgVarRefExp(SkipCasting(test->get_lhs_operand()));
  if (testvar == NULL)
    return false;
  if (testvar->get_symbol() != ivarname->get_symbol_from_symbol_table ())
    return false;
#endif
 //grab the upper bound
  ubast = loop->get_bound();
  // Fortran Do loops always have inclusive upper bound  
  if (isInclusiveUpperBound != NULL) 
     *isInclusiveUpperBound = true;  
  //3. Check the increment expression
  SgExpression* incr = fs->get_increment();
  ROSE_ASSERT (incr != NULL);
  if (isSgNullExpression(incr))
  {
    cerr<<"Error:isCanonicalDoLoop() found NULL increment expression. Please call doLoopNormalization() first!"<<endl;
    ROSE_ASSERT (false);
  }
  if (hasIncrementalIterationSpace != NULL)
  {
     *hasIncrementalIterationSpace = true;
    // We can only tell a few cases 
    if (SgIntVal* i_v = isSgIntVal(incr))
    {
      if (i_v->get_value()<0)
     *hasIncrementalIterationSpace = false;
    }
  }
#if 0
  SgVarRefExp* incr_var = NULL;
  switch (incr->variantT()) {
    case V_SgPlusAssignOp: //+=
    case V_SgMinusAssignOp://-=
      incr_var = isSgVarRefExp(SkipCasting(isSgBinaryOp(incr)->get_lhs_operand()));
      stepast = isSgBinaryOp(incr)->get_rhs_operand();
      break;
    case V_SgPlusPlusOp:   //++
    case V_SgMinusMinusOp:  //--
      incr_var = isSgVarRefExp(SkipCasting(isSgUnaryOp(incr)->get_operand()));
      stepast = buildIntVal(1); // will this dangling SgNode cause any problem?
      break;
    default:
      return false;
  }
  if (incr_var == NULL)
    return false;
  if (incr_var->get_symbol() != ivarname->get_symbol_from_symbol_table ())
    return false;
#endif
  // return loop information if requested
  if (ivar != NULL)
    *ivar = ivarname;
  if (lb != NULL)
    *lb = lbast;
  if (ub != NULL)
    *ub = ubast;
  if (step != NULL)
    *step = incr;
  if (body != NULL) {
    *body = fs->get_body();
  }
  return true;
}


//! Based on AstInterface::IsFortranLoop() and ASTtools::getLoopIndexVar()
//TODO check the loop index is not being written in the loop body
bool SageInterface::isCanonicalForLoop(SgNode* loop,SgInitializedName** ivar/*=NULL*/, SgExpression** lb/*=NULL*/, SgExpression** ub/*=NULL*/, SgExpression** step/*=NULL*/, SgStatement** body/*=NULL*/, bool *hasIncrementalIterationSpace/*= NULL*/, bool* isInclusiveUpperBound/*=NULL*/)
{
  ROSE_ASSERT(loop != NULL);
  SgForStatement* fs = isSgForStatement(loop);
  //SgFortranDo* fs2 = isSgFortranDo(loop);
  if (fs == NULL)
  { 
   // if (fs2)
   //   return isCanonicalDoLoop (fs2, ivar, lb, ub, step, body, hasIncrementalIterationSpace, isInclusiveUpperBound);
   // else
      return false;
   }
  // 1. Check initialization statement is something like i=xx;
  SgStatementPtrList & init = fs->get_init_stmt();
  if (init.size() !=1)
    return false;
  SgStatement* init1 = init.front();
  SgExpression* ivarast=NULL, *lbast=NULL, *ubast=NULL, *stepast=NULL;
  SgInitializedName* ivarname=NULL;

  bool isCase1=false, isCase2=false;
  //consider C99 style: for (int i=0;...)
  if (isSgVariableDeclaration(init1))
   {
     SgVariableDeclaration* decl = isSgVariableDeclaration(init1);
     ivarname = decl->get_variables().front();
     ROSE_ASSERT(ivarname != NULL);
     SgInitializer * initor = ivarname->get_initializer();
     if (isSgAssignInitializer(initor))
     {
       lbast = isSgAssignInitializer(initor)->get_operand();
       isCase1 = true;
     }
   }// other regular case: for (i=0;..)
   else if (isAssignmentStatement(init1, &ivarast, &lbast))
   {
     SgVarRefExp* var = isSgVarRefExp(SkipCasting(ivarast));
     if (var)
     {
       ivarname = var->get_symbol()->get_declaration();
       isCase2 = true;
     }
   }
   // Cannot be both true
   ROSE_ASSERT(!(isCase1&&isCase2));
   // if not either case is true
    if (!(isCase1||isCase2))
      return false;

  //Check loop index's type
  if (!isStrictIntegerType(ivarname->get_type()))
    return false;

  //2. Check test expression i [<=, >=, <, > ,!=] bound
  SgBinaryOp* test = isSgBinaryOp(fs->get_test_expr());
  if (test == NULL)
    return false;
  switch (test->variantT()) {
    case V_SgLessOrEqualOp:
       if (isInclusiveUpperBound != NULL)
         *isInclusiveUpperBound = true;
       if (hasIncrementalIterationSpace != NULL)
         *hasIncrementalIterationSpace = true;
       break;
    case V_SgLessThanOp:
       if (isInclusiveUpperBound != NULL)
         *isInclusiveUpperBound = false;
       if (hasIncrementalIterationSpace != NULL)
         *hasIncrementalIterationSpace = true;
       break;
    case V_SgGreaterOrEqualOp:
       if (isInclusiveUpperBound != NULL)
         *isInclusiveUpperBound = true;
        if (hasIncrementalIterationSpace != NULL)
         *hasIncrementalIterationSpace = false;
      break;
    case V_SgGreaterThanOp:
       if (isInclusiveUpperBound != NULL)
         *isInclusiveUpperBound = false;
       if (hasIncrementalIterationSpace != NULL)
         *hasIncrementalIterationSpace = false;
      break;
//    case V_SgNotEqualOp: // Do we really want to allow this != operator ?
      break;
    default:
      return false;
  }
  // check the tested variable is the same as the loop index
  SgVarRefExp* testvar = isSgVarRefExp(SkipCasting(test->get_lhs_operand()));
  if (testvar == NULL)
    return false;
  if (testvar->get_symbol() != ivarname->get_symbol_from_symbol_table ())
    return false;
  //grab the upper bound
  ubast = test->get_rhs_operand();

  //3. Check the increment expression
  SgExpression* incr = fs->get_increment();
  SgVarRefExp* incr_var = NULL;
  switch (incr->variantT()) {
    case V_SgPlusAssignOp: //+=
    case V_SgMinusAssignOp://-=
      incr_var = isSgVarRefExp(SkipCasting(isSgBinaryOp(incr)->get_lhs_operand()));
      stepast = isSgBinaryOp(incr)->get_rhs_operand();
      break;
    case V_SgPlusPlusOp:   //++
    case V_SgMinusMinusOp:  //--
      incr_var = isSgVarRefExp(SkipCasting(isSgUnaryOp(incr)->get_operand()));
      stepast = buildIntVal(1); // will this dangling SgNode cause any problem?
      break;
    default:
      return false;
  }
  if (incr_var == NULL)
    return false;
  if (incr_var->get_symbol() != ivarname->get_symbol_from_symbol_table ())
    return false;

  // return loop information if requested
  if (ivar != NULL)
    *ivar = ivarname;
  if (lb != NULL)
    *lb = lbast;
  if (ub != NULL)
    *ub = ubast;
  if (step != NULL)
    *step = stepast;
  if (body != NULL) {
    *body = fs->get_loop_body();
  }
  return true;
}

//! Set the lower bound of a loop header
void SageInterface::setLoopLowerBound(SgNode* loop, SgExpression* lb)
{
  ROSE_ASSERT(loop != NULL);
  ROSE_ASSERT(lb != NULL);
  SgForStatement* forstmt = isSgForStatement(loop);
  SgFortranDo* dostmt = isSgFortranDo(loop);
  //  ROSE_ASSERT(forstmt!= NULL);

  if (forstmt != NULL)
  {
    // two cases: init_stmt is
    //       SgExprStatement (assignment) like i=0;
    //       SgVariableDeclaration int i =0 or
    Rose_STL_Container<SgNode* > testList = NodeQuery::querySubTree( *((forstmt->get_init_stmt()).begin()), V_SgAssignOp);
    if (testList.size()>0) // assignment statement
    {
      ROSE_ASSERT(testList.size()==1);// only handle the case of 1 statement, canonical form
      SgAssignOp * assignop = isSgAssignOp((*testList.begin()));
      ROSE_ASSERT(assignop);
      if( assignop->get_rhs_operand()->get_lvalue())
        lb->set_lvalue(true);
      assignop->set_rhs_operand(lb);
      lb->set_parent(assignop);
      //TODO what happens to the original rhs operand?
    }
    else // variable declaration case
    {
      // SgVariableDeclaration
      Rose_STL_Container<SgNode* > testList = NodeQuery::querySubTree( *((forstmt->get_init_stmt()).begin()),  V_SgAssignInitializer );
      ROSE_ASSERT(testList.size()==1);// only handle the case of 1 statement, canonical form
      SgAssignInitializer* init = isSgAssignInitializer((*testList.begin()));
      ROSE_ASSERT(init != NULL);
      init->set_operand(lb);
      lb->set_parent(init);
      //TODO what happens to the original rhs operand?
    }
  }
  else if (dostmt != NULL)
  {
    SgExpression* init = dostmt->get_initialization();
    ROSE_ASSERT (init != NULL);
    SgAssignOp * a_op = isSgAssignOp (init);
    ROSE_ASSERT (a_op!=NULL);
    a_op->set_rhs_operand(lb);
    lb->set_parent(a_op);
    //TODO delete the previous operand?
  }
  else
  {
    cerr<<"Error. SageInterface::setLoopLowerBound(), illegal loop type:"<< loop->class_name()<<endl;
    ROSE_ASSERT (false);
  }
}

//! Set the upper bound of a loop header,regardless the condition expression type.  for (i=lb; i op up, ...)
void SageInterface::setLoopUpperBound(SgNode* loop, SgExpression* ub)
{
  ROSE_ASSERT(loop != NULL);
  ROSE_ASSERT(ub != NULL);
  SgForStatement* forstmt = isSgForStatement(loop);
  //  ROSE_ASSERT(forstmt!= NULL);
  SgFortranDo* dostmt = isSgFortranDo(loop);
  if (forstmt != NULL)
  {
    // set upper bound expression
    SgBinaryOp * binop= isSgBinaryOp(isSgExprStatement(forstmt->get_test())->get_expression());
    ROSE_ASSERT(binop != NULL);
    binop->set_rhs_operand(ub);
    ub->set_parent(binop);
  }
  else if (dostmt != NULL)
  {
    dostmt->set_bound(ub);
    ub->set_parent(dostmt);
    //TODO delete the original bound expression
  }
  else
  {
    cerr<<"Error. SageInterface::setLoopUpperBound(), illegal loop type:"<< loop->class_name()<<endl;
    ROSE_ASSERT (false);
  } 

}

//! Set the stride(step) of a loop 's incremental expression, regardless the expression types (i+=s; i= i+s, etc)
void SageInterface::setLoopStride(SgNode* loop, SgExpression* stride)
{
  ROSE_ASSERT(loop != NULL);
  ROSE_ASSERT(stride != NULL);
  SgForStatement* forstmt = isSgForStatement(loop);
  SgFortranDo * dostmt = isSgFortranDo (loop);
  // ROSE_ASSERT(forstmt!= NULL);
  if (dostmt != NULL)
  {
    dostmt->set_increment(stride);
    stride->set_parent(dostmt);
    //TODO delete original increment expression
  }
  else  if (forstmt != NULL)  
  {
    // set stride expression
    // case 1: i++ change to i+=stride
    Rose_STL_Container<SgNode*> testList = NodeQuery::querySubTree( forstmt->get_increment(), V_SgPlusPlusOp);
    if (testList.size()>0)
    {
      ROSE_ASSERT(testList.size() == 1); // should have only one
      SgVarRefExp *loopvarexp = isSgVarRefExp(SageInterface::deepCopy
          (isSgPlusPlusOp( *testList.begin())->get_operand()));
      SgPlusAssignOp *plusassignop = buildPlusAssignOp(loopvarexp, stride);
      forstmt->set_increment(plusassignop);
    }

    // case 1.5: i-- also changed to i+=stride
    testList = NodeQuery::querySubTree(forstmt->get_increment(), V_SgMinusMinusOp);
    if (testList.size()>0)
    {
      ROSE_ASSERT(testList.size()==1);// should have only one
      SgVarRefExp *loopvarexp =isSgVarRefExp(SageInterface::deepCopy
          (isSgMinusMinusOp(*testList.begin())->get_operand()));
      SgPlusAssignOp *plusassignop = buildPlusAssignOp(loopvarexp, stride);
      forstmt->set_increment(plusassignop);
    }

    // case 2: i+=X
    testList = NodeQuery::querySubTree( forstmt->get_increment(), V_SgPlusAssignOp);
    if (testList.size()>0)
    {
      ROSE_ASSERT(testList.size()==1);// should have only one
      SgPlusAssignOp * assignop = isSgPlusAssignOp(*(testList.begin()));
      ROSE_ASSERT(assignop!=NULL);
      assignop->set_rhs_operand(stride);
    }

    // case 2.5: i-=X changed to i+=stride
    testList = NodeQuery::querySubTree(forstmt->get_increment(), V_SgMinusAssignOp);
    if (testList.size()>0)
    {
      ROSE_ASSERT(testList.size()==1);// should have only one
      SgVarRefExp *loopvarexp =isSgVarRefExp(SageInterface::deepCopy
          (isSgMinusAssignOp(*testList.begin())->get_lhs_operand()));
      SgExprStatement* exprstmt = isSgExprStatement((*testList.begin())->get_parent());
      ROSE_ASSERT(exprstmt !=NULL);
      SgPlusAssignOp *plusassignop = buildPlusAssignOp(loopvarexp, stride);
      exprstmt->set_expression(plusassignop);
    }

    // DQ (1/3/2007): I think this is a meaningless statement.
    testList.empty();
    // case 3: i=i + X or i =X +i  i
    // TODO; what if users use i*=,etc ??
    //      send out a warning: not canonical FOR/DO loop
    //      or do this in the real frontend. MUST conform to canonical form
    testList = NodeQuery::querySubTree(forstmt->get_increment(), V_SgAddOp);
    if (testList.size()>0)
    {
      ROSE_ASSERT(testList.size()==1);// should have only one ??
      // consider only the top first one
      SgAddOp * addop = isSgAddOp(*(testList.begin()));
      ROSE_ASSERT(addop!=NULL);
      string loopvar= (isSgVarRefExp(isSgAssignOp(addop->get_parent())->get_lhs_operand())->get_symbol()->get_name()).getString();
      if (isSgVarRefExp(addop->get_rhs_operand())!=NULL)
      {
        if ((isSgVarRefExp(addop->get_rhs_operand())->get_symbol()->get_name()).getString() ==loopvar)
          addop->set_lhs_operand(stride);
        else
          addop->set_rhs_operand(stride);
      }
      else
        addop->set_rhs_operand(stride);
    }

    // case 3.5: i=i - X
    testList = NodeQuery::querySubTree(forstmt->get_increment(), V_SgSubtractOp);
    if (testList.size()>0)
    {
      ROSE_ASSERT(testList.size()==1);// should have only one ??
      // consider only the top first one
      SgSubtractOp * subtractop = isSgSubtractOp(*(testList.begin()));
      ROSE_ASSERT(subtractop!=NULL);
      SgVarRefExp *loopvarexp =isSgVarRefExp(SageInterface::deepCopy
          (isSgSubtractOp(*testList.begin())->get_lhs_operand()));
      SgAssignOp *assignop = isSgAssignOp((*testList.begin())->get_parent());
      ROSE_ASSERT(assignop !=NULL);
      SgPlusAssignOp *plusassignop = buildPlusAssignOp(loopvarexp, stride);
      assignop->set_rhs_operand(plusassignop);
    }
  }
  else
  {
    cerr<<"Error. SageInterface::setLoopStride(), illegal loop type:"<< loop->class_name()<<endl;
    ROSE_ASSERT (false);

  }  
}

//! Check if a SgNode _s is an assignment statement (any of =,+=,-=,&=,/=, ^=, etc)
//!
//! Return the left hand, right hand expressions and if the left hand variable is also being read. This code is from AstInterface::IsAssignment()
bool SageInterface::isAssignmentStatement(SgNode* s, SgExpression** lhs/*=NULL*/, SgExpression** rhs/*=NULL*/, bool* readlhs/*=NULL*/)
{
  SgExprStatement *n = isSgExprStatement(s);
  SgExpression *exp = (n != 0)? n->get_expression() : isSgExpression(s);
  if (exp != 0) {
    switch (exp->variantT()) {
      case V_SgPlusAssignOp:
      case V_SgMinusAssignOp:
      case V_SgAndAssignOp:
      case V_SgIorAssignOp:
      case V_SgMultAssignOp:
      case V_SgDivAssignOp:
      case V_SgModAssignOp:
      case V_SgXorAssignOp:
      case V_SgAssignOp:
        {
          SgBinaryOp* s2 = isSgBinaryOp(exp);
          if (lhs != 0)
            *lhs = s2->get_lhs_operand();
          if (rhs != 0) {
            SgExpression* init = s2->get_rhs_operand();
            if ( init->variantT() == V_SgAssignInitializer)
              init = isSgAssignInitializer(init)->get_operand();
            *rhs = init;
          }
          if (readlhs != 0)
            *readlhs = (exp->variantT() != V_SgAssignOp);
          return true;
        }
      default:
         return false;
    }
  }
  return false;
}


  void SageInterface::removeConsecutiveLabels(SgNode* top) {
   Rose_STL_Container<SgNode*> gotos = NodeQuery::querySubTree(top,V_SgGotoStatement);
   for (size_t i = 0; i < gotos.size(); ++i) {
     SgGotoStatement* gs = isSgGotoStatement(gotos[i]);
     SgLabelStatement* ls = gs->get_label();
     SgBasicBlock* lsParent = isSgBasicBlock(ls->get_parent());
     if (!lsParent) continue;
     SgStatementPtrList& bbStatements = lsParent->get_statements();
     size_t j = std::find(bbStatements.begin(), bbStatements.end(), ls)
  - bbStatements.begin();
     ROSE_ASSERT (j != bbStatements.size());     while (j <
  bbStatements.size() - 1 && isSgLabelStatement(bbStatements[j + 1])) {
     ++j;
     }
     gs->set_label(isSgLabelStatement(bbStatements[j]));
   }
  }

namespace SageInterface { // A few internal helper classes

class AndOpGenerator: public StatementGenerator
   {
     SgAndOp* op;

     public:
          AndOpGenerator(SgAndOp* op): op(op) {}

          virtual SgStatement* generate(SgExpression* lhs)
             {
               SgTreeCopy treeCopy;
               SgExpression* lhsCopy = isSgExpression(lhs->copy(treeCopy));
               ROSE_ASSERT (lhsCopy);
               SgIfStmt* tree =
                 SageBuilder::buildIfStmt(
                     SageBuilder::buildExprStatement(op->get_lhs_operand()),
                     SageBuilder::buildBasicBlock(
                       SageBuilder::buildAssignStatement(lhs, op->get_rhs_operand())),
                     SageBuilder::buildBasicBlock(
                       SageBuilder::buildAssignStatement(lhsCopy, SageBuilder::buildBoolValExp(false))));
               return tree;
             }
   };

class OrOpGenerator: public StatementGenerator
   {
     SgOrOp* op;

     public:
          OrOpGenerator(SgOrOp* op): op(op) {}

          virtual SgStatement* generate(SgExpression* lhs)
             {
               SgTreeCopy treeCopy;
               SgExpression* lhsCopy = isSgExpression(lhs->copy(treeCopy));
               ROSE_ASSERT (lhsCopy);
               SgIfStmt* tree =
                 SageBuilder::buildIfStmt(
                     SageBuilder::buildExprStatement(op->get_lhs_operand()),
                     SageBuilder::buildBasicBlock(
                       SageBuilder::buildAssignStatement(lhs, SageBuilder::buildBoolValExp(true))),
                     SageBuilder::buildBasicBlock(
                       SageBuilder::buildAssignStatement(lhsCopy, op->get_rhs_operand())));
               return tree;
             }
   };

class ConditionalExpGenerator: public StatementGenerator
   {
     SgConditionalExp* op;

     public:
          ConditionalExpGenerator(SgConditionalExp* op): op(op) {}

          virtual SgStatement* generate(SgExpression* lhs)
             {
               SgTreeCopy treeCopy;
               SgExpression* lhsCopy = isSgExpression(lhs->copy(treeCopy));
               ROSE_ASSERT (lhsCopy);
               SgIfStmt* tree =
                 SageBuilder::buildIfStmt(
                     SageBuilder::buildExprStatement(op->get_conditional_exp()),
                     SageBuilder::buildBasicBlock(
                       SageBuilder::buildAssignStatement(lhs, op->get_true_exp())),
                     SageBuilder::buildBasicBlock(
                       SageBuilder::buildAssignStatement(lhsCopy, op->get_false_exp())));
               return tree;
             }
   };

} // end of namespace for the helper classes

//! Merged from replaceExpressionWithStatement.C
SgAssignInitializer* SageInterface::splitExpression(SgExpression* from, string newName/* ="" */)
{
  if (!SageInterface::isCopyConstructible(from->get_type())) {
    std::cerr << "Type " << from->get_type()->unparseToString() << " of expression " << from->unparseToString() << " is not copy constructible" << std::endl;
    ROSE_ASSERT (false);
  }

  assert (SageInterface::isCopyConstructible(from->get_type())); // How do we report errors?
  SgStatement* stmt = getStatementOfExpression(from);
  assert (stmt);
  if (!isSgForInitStatement(stmt->get_parent())) {
    SageInterface::ensureBasicBlockAsParent(stmt);
  }

  SgScopeStatement* parent = isSgScopeStatement(stmt->get_parent());
  // cout << "parent is a " << (parent ? parent->sage_class_name() : "NULL") << endl;
  if (!parent && isSgForInitStatement(stmt->get_parent()))
    parent = isSgScopeStatement(stmt->get_parent()->get_parent()->get_parent());
  assert (parent);
  // cout << "parent is a " << parent->sage_class_name() << endl;
  // cout << "parent is " << parent->unparseToString() << endl;
  // cout << "stmt is " << stmt->unparseToString() << endl;
  SgName varname = "rose_temp__";
  if (newName == "") {
    varname << ++SageInterface::gensym_counter;
  } else {
    varname = newName;
  }

  SgType* vartype = from->get_type();
  SgNode* fromparent = from->get_parent();
  vector<SgExpression*> ancestors;
  for (SgExpression *expr = from, *anc = isSgExpression(fromparent); anc != 0;
      expr = anc, anc = isSgExpression(anc->get_parent()))
  {
    if ((isSgAndOp(anc) && expr != isSgAndOp(anc)->get_lhs_operand()) ||
        (isSgOrOp(anc) && expr != isSgOrOp(anc)->get_lhs_operand()) ||
        (isSgConditionalExp(anc) && expr != isSgConditionalExp(anc)->get_conditional_exp()))
      ancestors.push_back(anc); // Closest first
  }
  // cout << "This expression to split has " << ancestors.size() << " ancestor(s)" << endl;
  for (vector<SgExpression*>::reverse_iterator ai = ancestors.rbegin(); ai != ancestors.rend(); ++ai)
  {
    StatementGenerator* gen;
    switch ((*ai)->variantT()) {
      case V_SgAndOp:
        gen = new AndOpGenerator(isSgAndOp(*ai)); break;
      case V_SgOrOp:
        gen = new OrOpGenerator(isSgOrOp(*ai)); break;
      case V_SgConditionalExp:
        gen = new ConditionalExpGenerator(isSgConditionalExp(*ai)); break;
      default: assert (!"Should not happen");
    }
    replaceExpressionWithStatement(*ai, gen);
    delete gen;
  } // for
  if (ancestors.size() != 0) {
    return splitExpression(from);
    // Need to recompute everything if there were ancestors
  }
  SgVariableDeclaration* vardecl = SageBuilder::buildVariableDeclaration(varname, vartype, NULL, parent);
  SgVariableSymbol* sym = SageInterface::getFirstVarSym(vardecl);
  ROSE_ASSERT (sym);
  SgInitializedName* initname = sym->get_declaration();
  ROSE_ASSERT (initname);
  SgVarRefExp* varref = SageBuilder::buildVarRefExp(sym);
  replaceExpressionWithExpression(from, varref);
  // std::cout << "Unparsed 3: " << fromparent->sage_class_name() << " --- " << fromparent->unparseToString() << endl;
  // cout << "From is a " << from->sage_class_name() << endl;
  SgAssignInitializer* ai = SageBuilder::buildAssignInitializer(from);
  initname->set_initializer(ai);
  ai->set_parent(initname);
  myStatementInsert(stmt, vardecl, true);
  // vardecl->set_parent(stmt->get_parent());
  // FixSgTree(vardecl);
  // FixSgTree(parent);
  return ai;
} //splitExpression()

  //! This generalizes the normal splitExpression to allow loop tests and
  void SageInterface::splitExpressionIntoBasicBlock(SgExpression* expr) {
   struct SplitStatementGenerator: public StatementGenerator {
     SgExpression* expr;
     virtual SgStatement* generate(SgExpression* answer) {
       using namespace SageBuilder;
       return buildBasicBlock(buildAssignStatement(answer, expr));
     }
   };
   SplitStatementGenerator gen;
   gen.expr = expr;
   replaceExpressionWithStatement(expr, &gen);
  }

  void SageInterface::removeLabeledGotos(SgNode* top) {
   Rose_STL_Container<SgNode*> gotos = NodeQuery::querySubTree(top,
  V_SgGotoStatement);
   map<SgLabelStatement*, SgLabelStatement*> labelsToReplace;   for
  (size_t i = 0; i < gotos.size(); ++i) {
     SgGotoStatement* gs = isSgGotoStatement(gotos[i]);
     SgBasicBlock* gsParent = isSgBasicBlock(gs->get_parent());
     if (!gsParent) continue;
     SgStatementPtrList& bbStatements = gsParent->get_statements();
     size_t j = std::find(bbStatements.begin(), bbStatements.end(), gs)
  - bbStatements.begin();
     ROSE_ASSERT (j != bbStatements.size());
     if (j == 0) continue;
     if (isSgLabelStatement(bbStatements[j - 1])) {
       labelsToReplace[isSgLabelStatement(bbStatements[j - 1])] =
  gs->get_label();
     }
   }
   for (size_t i = 0; i < gotos.size(); ++i) {
     SgGotoStatement* gs = isSgGotoStatement(gotos[i]);
     SgLabelStatement* oldLabel = gs->get_label();
     while (labelsToReplace.find(oldLabel) != labelsToReplace.end()) {
       oldLabel = labelsToReplace[oldLabel];
     }
     gs->set_label(oldLabel);
   }
  }

  bool SageInterface::isConstantTrue(SgExpression* e) {
  switch (e->variantT()) {
#ifdef _MSC_VER
  // DQ (11/28/2009): This fixes a warning in MSVC (likely p_value should be a "bool" instead of an "int").
    case V_SgBoolValExp: return (isSgBoolValExp(e)->get_value() != 0);
#else
    case V_SgBoolValExp: return (isSgBoolValExp(e)->get_value() == true);
#endif
    case V_SgIntVal: return isSgIntVal(e)->get_value() != 0;
    case V_SgCastExp: return isConstantTrue(isSgCastExp(e)->get_operand());
    case V_SgNotOp: return isConstantFalse(isSgNotOp(e)->get_operand());
    case V_SgAddressOfOp: return true;
    default: return false;
  }
  }

  bool SageInterface::isConstantFalse(SgExpression* e) {
    switch (e->variantT()) {
      case V_SgBoolValExp: return isSgBoolValExp(e)->get_value() == false;
      case V_SgIntVal: return isSgIntVal(e)->get_value() == 0;
      case V_SgCastExp: return
  isConstantFalse(isSgCastExp(e)->get_operand());
      case V_SgNotOp: return isConstantTrue(isSgNotOp(e)->get_operand());
      default: return false;
    }
  }

  bool SageInterface::isCallToParticularFunction(SgFunctionDeclaration* decl,
  SgExpression* e) {
    SgFunctionCallExp* fc = isSgFunctionCallExp(e);
    if (!fc) return false;
    SgFunctionRefExp* fr = isSgFunctionRefExp(fc->get_function());
    return fr->get_symbol()->get_declaration() == decl;
  }

  bool SageInterface::isCallToParticularFunction(const std::string& qualifiedName, size_t
  arity, SgExpression* e) {
    SgFunctionCallExp* fc = isSgFunctionCallExp(e);
    if (!fc) return false;
    SgFunctionRefExp* fr = isSgFunctionRefExp(fc->get_function());
    string name =
  fr->get_symbol()->get_declaration()->get_qualified_name().getString();
    return (name == qualifiedName &&
  fc->get_args()->get_expressions().size() == arity);
  }

  SgExpression* SageInterface::copyExpression(SgExpression* e)
  {
    ROSE_ASSERT( e != NULL);
    // We enforce that the source expression is fully attached to the AST
    // Too strict, the source expression can be just built and not attached.
    // Liao, 9/21/2009
//    ROSE_ASSERT( e->get_parent() != NULL);
    return deepCopy(e);
  }

  SgStatement* SageInterface::copyStatement(SgStatement* s)
  {
    return deepCopy(s);
  }

  //----------------- add into AST tree --------------------
  void SageInterface::appendExpression(SgExprListExp *expList, SgExpression* exp)
  {
    ROSE_ASSERT(expList);
    ROSE_ASSERT(exp);
    expList->append_expression(exp);
    exp->set_parent(expList);
  }

  void SageInterface::appendExpressionList(SgExprListExp *expList, const std::vector<SgExpression*>& exp)
  {
    for (size_t i = 0; i < exp.size(); ++i)
      appendExpression(expList, exp[i]);
  }

  //TODO consider the difference between C++ and Fortran
  // fixup the scope of arguments,no symbols for nondefining function declaration's arguments
  void SageInterface::setParameterList(SgFunctionDeclaration * func,SgFunctionParameterList * paralist)
  {
    ROSE_ASSERT(func);
    ROSE_ASSERT(paralist);
  // Warning users if a paralist is being shared
  if (paralist->get_parent() !=NULL)
  {
    cerr<<"Waring! Setting a used SgFunctionParameterList to function: "
    << (func->get_name()).getString()<<endl
    << " Sharing parameter lists can corrupt symbol tables!"<<endl
    << " Please use deepCopy() to get an exclusive parameter list for each function declaration!"<<endl;
//    ROSE_ASSERT(false);
  }
  // Liao,2/5/2008  constructor of SgFunctionDeclaration will automatically generate SgFunctionParameterList, so be cautious when set new paralist!!
    if (func->get_parameterList() != NULL)
      if (func->get_parameterList() != paralist)
	delete func->get_parameterList();
    func->set_parameterList(paralist);
    paralist->set_parent(func);

  }

static SgVariableSymbol * addArg(SgFunctionParameterList *paraList, SgInitializedName* initName,bool isPrepend)
{
  ROSE_ASSERT(paraList);
  ROSE_ASSERT(initName);
  if (isPrepend)
    paraList->prepend_arg(initName);
  else
    paraList->append_arg(initName);
  initName->set_parent(paraList);

  SgFunctionDeclaration* func_decl= isSgFunctionDeclaration(paraList->get_parent());
  SgScopeStatement* scope = NULL;
  if (func_decl)
  {
    if ((func_decl->get_definingDeclaration()) == func_decl )
    { //defining function declaration, set scope and symbol table
      SgFunctionDefinition* func_def = func_decl->get_definition();
      ROSE_ASSERT(func_def);
      scope = func_def;
    } // nondefining declaration, set scope only, currently set to decl's scope, TODO
    else
      scope = func_decl->get_scope();
    //fix up declptr of the init name
    initName->set_declptr(func_decl);
  } //end if func_decl is available
  // ROSE_ASSERT (scope); -- scope may not be set because the function declaration may not have been inserted anywhere
  initName->set_scope(scope);
  if (scope)
  {
    SgVariableSymbol* sym = isSgVariableSymbol(initName->get_symbol_from_symbol_table());
    if (sym == NULL)
    {
      sym = new SgVariableSymbol(initName);
      scope->insert_symbol(initName->get_name(), sym);
      sym->set_parent(scope->get_symbol_table());
    }
    return sym;
  }
  else
    return NULL;
}

SgVariableSymbol* SageInterface::appendArg(SgFunctionParameterList *paraList, SgInitializedName* initName)
{
  return addArg(paraList,initName,false);
}

SgVariableSymbol* SageInterface::prependArg(SgFunctionParameterList *paraList, SgInitializedName* initName)
{
  return addArg(paraList,initName,true);
}

void SageInterface::setPragma(SgPragmaDeclaration* decl, SgPragma *pragma)
{
  ROSE_ASSERT(decl);
  ROSE_ASSERT(pragma);
  if (decl->get_pragma()!=NULL) delete (decl->get_pragma());
  decl->set_pragma(pragma);
  pragma->set_parent(decl);
}

//! SageInterface::appendStatement()
//TODO should we ensureBasicBlockAsScope(scope) ? like ensureBasicBlockAsParent(targetStmt);
//It might be well legal to append the first and only statement in a scope!
void SageInterface::appendStatement(SgStatement *stmt, SgScopeStatement* scope)
  {
     if (scope == NULL)
          scope = SageBuilder::topScopeStack();

     ROSE_ASSERT(stmt  != NULL);
     ROSE_ASSERT(scope != NULL);

#if 0
  // DQ (2/2/2010): This fails in the projects/OpenMP_Translator "make check" tests.
  // DQ (1/2/2010): Introducing test that are enforced at lower levels to catch errors as early as possible.
     SgDeclarationStatement* declarationStatement = isSgDeclarationStatement(stmt);
     if (declarationStatement != NULL)
        {
          ROSE_ASSERT(declarationStatement->get_firstNondefiningDeclaration() != NULL);
          ROSE_ASSERT(declarationStatement->get_definingDeclaration() != NULL);
        }
#endif

#if 0 // This fix breaks other transformations.
      // It is better to do this explicitly as needed before calling appendStatement();
    // Liao 10/19/2010
    // In rare cases, we are moving the statement from its original scope to another scope
    // We have to remove it from its original scope before append it to the new scope
    SgNode* old_parent=  stmt->get_parent();
    if (old_parent)
    {
      removeStatement(stmt);
    }
#endif
    //catch-all for statement fixup
   // Must fix it before insert it into the scope,
    fixStatement(stmt,scope);

    //-----------------------
    // append the statement finally
    //scope->append_statement (stmt);
    scope->insertStatementInScope(stmt,false);
    stmt->set_parent(scope); // needed?

   // update the links after insertion!
    if (isSgFunctionDeclaration(stmt))
     updateDefiningNondefiningLinks(isSgFunctionDeclaration(stmt),scope);
  }

  void SageInterface::appendStatementList(const std::vector<SgStatement*>& stmts, SgScopeStatement* scope) {
    for (size_t i = 0; i < stmts.size(); ++i) {
      appendStatement(stmts[i], scope);
    }
  }
//!SageInterface::prependStatement()
  void SageInterface::prependStatement(SgStatement *stmt, SgScopeStatement* scope)
  {
    ROSE_ASSERT (stmt != NULL);
   if (scope == NULL)
      scope = SageBuilder::topScopeStack();
    ROSE_ASSERT(scope != NULL);
    //TODO handle side effect like SageBuilder::appendStatement() does

   // Must fix it before insert it into the scope,
   // otherwise assertions in insertStatementInScope() would fail
   fixStatement(stmt,scope);

   scope->insertStatementInScope(stmt,true);
   stmt->set_parent(scope); // needed?
    // update the links after insertion!
   if (isSgFunctionDeclaration(stmt))
     updateDefiningNondefiningLinks(isSgFunctionDeclaration(stmt),scope);

  } //prependStatement()

  void SageInterface::prependStatementList(const std::vector<SgStatement*>& stmts, SgScopeStatement* scope) {
    for (size_t i = stmts.size(); i > 0; --i) {
      prependStatement(stmts[i - 1], scope);
    }
  }

  //! Check if a scope statement has a simple children statement list (SgStatementPtrList)
  //! so insert additional statements under the scope is straightforward and unambiguous .
  //! for example, SgBasicBlock has a simple statement list while IfStmt does not.
  bool  SageInterface::hasSimpleChildrenList (SgScopeStatement* scope)
{
  bool rt = false;
  ROSE_ASSERT (scope != NULL);
  switch (scope->variantT())
  {
    case V_SgBasicBlock:
    case V_SgClassDefinition:
    case V_SgFunctionDefinition:
    case V_SgGlobal:
    case V_SgNamespaceDefinitionStatement: //?
      rt = true;
      break;

     case V_SgAssociateStatement :
     case V_SgBlockDataStatement :
     case V_SgCatchOptionStmt:
     case V_SgDoWhileStmt:
     case V_SgForAllStatement:
     case V_SgForStatement:
     case V_SgFortranDo:
     case V_SgIfStmt:
     case V_SgSwitchStatement:
     case V_SgUpcForAllStatement:
     case V_SgWhileStmt:
      rt = false;
      break;

    default:
      cout<<"unrecognized or unhandled scope type for SageInterface::hasSimpleChildrenList() "<<endl;
    break;
  }
  return rt;
}

  //TODO handle more side effect like SageBuilder::append_statement() does
  //Merge myStatementInsert()
  // insert  SageInterface::insertStatement()
void SageInterface::insertStatement(SgStatement *targetStmt, SgStatement* newStmt, bool insertBefore, bool autoMovePreprocessingInfo /*= true */)
   {
     ROSE_ASSERT(targetStmt &&newStmt);
     ROSE_ASSERT(targetStmt != newStmt); // should not share statement nodes!
     SgNode* parent = targetStmt->get_parent();
     if (parent==NULL)
        {
          cerr<<"Empty parent pointer for target statement. May be caused by the wrong order of target and new statements in insertStatement(targetStmt, newStmt)"<<endl;
          ROSE_ASSERT(parent);
        }

  // We now have single statement true/false body for IfStmt etc
  // However, IfStmt::insert_child() is ambiguous and not implemented
  // So we make SgBasicBlock out of the single statement and
  // essentially call SgBasicBlock::insert_child() instead.
  // TODO: add test cases for If, variable, variable/struct inside if, etc

     parent = ensureBasicBlockAsParent(targetStmt);

  // must get the new scope after ensureBasicBlockAsParent ()
     SgScopeStatement* scope= targetStmt->get_scope();
     ROSE_ASSERT(scope);

     newStmt->set_parent(targetStmt->get_parent());
     fixStatement(newStmt,scope);

  // DQ (9/16/2010): Added assertion that appears to be required to be true.
  // However, if this is required to be true then what about statements in
  // SgStatementExpression IR nodes?
     ROSE_ASSERT(isSgStatement(parent) != NULL);

  // DQ (9/16/2010): Added support to move comments and CPP directives marked to
  // appear before the statement to be attached to the inserted statement (and marked
  // to appear before that statement).
     ROSE_ASSERT(targetStmt != NULL);
     AttachedPreprocessingInfoType* comments = targetStmt->getAttachedPreprocessingInfo();

  // DQ (9/17/2010): Trying to eliminate failing case in OpenMP projects/OpenMP_Translator/tests/npb2.3-omp-c/LU/lu.c
  // I think that special rules apply to inserting a SgBasicBlock so disable comment reloation when inserting a SgBasicBlock.
  // if (comments != NULL && newStmt->getAttachedPreprocessingInfo() == NULL)
  // if (comments != NULL)
   if (autoMovePreprocessingInfo) // Do this only if automatically handling of preprocessing information is request by users
    {
     if (comments != NULL && isSgBasicBlock(newStmt) == NULL)
        {
          vector<int> captureList;
#if 0
          printf ("Found attached comments (at %p = %s, inserting %p = %s insertBefore = %s): comments->size() = %zu \n",
               targetStmt,targetStmt->class_name().c_str(),newStmt,newStmt->class_name().c_str(),insertBefore ? "true" : "false",comments->size());
#endif
       // DQ (9/17/2010): Assert that the new statement being inserted has no attached comments or CPP directives.
          if (newStmt->getAttachedPreprocessingInfo() != NULL && newStmt->getAttachedPreprocessingInfo()->empty() == false)
             {
            // If the inserted statment has attached comments or CPP directives then this is gets a little
            // bit more comple and we don't support that at present.
               printf ("Warning: at present statements being inserted should not have attached comments of CPP directives (could be a problem, but comment relocation is not disabled). \n");
             }
       // DQ (9/17/2010): commented out because it fails test in projects/OpenMP_Translator/for_firstprivate.c
          ROSE_ASSERT((newStmt->getAttachedPreprocessingInfo() == NULL) || (newStmt->getAttachedPreprocessingInfo() != NULL && newStmt->getAttachedPreprocessingInfo()->empty() == false));

          int commentIndex = 0;
          AttachedPreprocessingInfoType::iterator i;
          for (i = comments->begin(); i != comments->end(); i++)
             {
               ROSE_ASSERT ( (*i) != NULL );
#if 0
               printf ("          Attached Comment (relativePosition=%s): %s\n",
                    ((*i)->getRelativePosition() == PreprocessingInfo::before) ? "before" : "after",
                    (*i)->getString().c_str());
               printf ("Comment/Directive getNumberOfLines = %d getColumnNumberOfEndOfString = %d \n",(*i)->getNumberOfLines(),(*i)->getColumnNumberOfEndOfString());
               (*i)->get_file_info()->display("comment/directive location");
#endif
               PreprocessingInfo::RelativePositionType relativePosition = (insertBefore == true) ? PreprocessingInfo::before : PreprocessingInfo::after;
               if ((*i)->getRelativePosition() == relativePosition)
                  {
                 // accumulate into list
                    captureList.push_back(commentIndex);
                  }

               commentIndex++;
             }

       // printf ("captureList.size() = %zu \n",captureList.size());
          if (captureList.empty() == false)
             {
            // Remove these comments and/or CPP directives and put them into the previous statement (marked to be output after the statement).
            // SgStatement* surroundingStatement = (insertBefore == true) ? getPreviousStatement(targetStmt) : getNextStatement(targetStmt);
            // SgStatement* surroundingStatement = (insertBefore == true) ? newStmt : newStmt;
               SgStatement* surroundingStatement = newStmt;
               ROSE_ASSERT(surroundingStatement != targetStmt);
               ROSE_ASSERT(surroundingStatement != NULL);
#if 0
               if (surroundingStatement == NULL)
                  {
                 // printf ("Warning: the surrounding statement for insertBefore = %s is NULL (so use the newStmt) \n",insertBefore ? "true" : "false");
                    surroundingStatement = (insertBefore == true) ? newStmt : newStmt;
                  }
#endif
            // Now add the entries from the captureList to the surroundingStatement and remove them from the targetStmt.
            // printf ("This is a valid surrounding statement = %s for insertBefore = %s \n",surroundingStatement->class_name().c_str(),insertBefore ? "true" : "false");
               vector<int>::iterator j = captureList.begin();
               while (j != captureList.end())
                  {
                 // Add the captured comments to the new statement. Likely we need to make sure that the order is preserved.
                 // printf ("Attaching comments to newStmt = %p = %s \n",newStmt,newStmt->class_name().c_str());
                    newStmt->addToAttachedPreprocessingInfo((*comments)[*j]);

                 // Remove them from the targetStmt. (set them to NULL and then remove them in a separate step).
                 // printf ("Removing entry from comments list on targetStmt = %p = %s \n",targetStmt,targetStmt->class_name().c_str());
                    (*comments)[*j] = NULL;

                    j++;
                  }

            // Now remove each NULL entries in the comments vector.
            // Because of iterator invalidation we must reset the iterators after each call to erase (I think).
               for (size_t n = 0; n < captureList.size(); n++)
                  {
                    bool modifiedList = false;
                    AttachedPreprocessingInfoType::iterator k = comments->begin();
                    while (k != comments->end() && modifiedList == false)
                       {
                      // Only modify the list once per iteration over the captureList
                      // if ((*comments)[*k] == NULL)
                         if (*k == NULL)
                            {
                              comments->erase(k);
                              modifiedList = true;
                            }
                         k++;
                       }
                  }
             }
        }
       else
        {
       // printf ("No attached comments (at %p of type: %s): \n",targetStmt,targetStmt->class_name().c_str());
       // DQ (9/17/2010): Trying to eliminate failing case in OpenMP projects/OpenMP_Translator/tests/npb2.3-omp-c/LU/lu.c
       // I thnk that special rules apply to inserting a SgBasicBlock so disable comment reloation when inserting a SgBasicBlock.
          if (comments != NULL)
             {
               printf ("Warning: special rules appear to apply to the insertion of a SgBasicBlock which has attached comments and/or CPP directives (comment relocation disabled). \n");
             }
        }
     } // end if autoMovePreprocessingInfo
     if (isSgIfStmt(parent))
        {
          if (isSgIfStmt(parent)->get_conditional()==targetStmt)
               insertStatement(isSgStatement(parent),newStmt,insertBefore);
            else
               if (isSgIfStmt(parent)->get_true_body()==targetStmt)
                  {
                 // ensureBasicBlockAsParent(targetStmt);
                    insertStatement(isSgStatement(parent),newStmt,insertBefore);
                  }
                 else
                    if (isSgIfStmt(parent)->get_false_body()==targetStmt)
                       {
	                   // ensureBasicBlockAsParent(targetStmt);
                         insertStatement(isSgStatement(parent),newStmt,insertBefore);
                       }
        }
       else
          if (isSgWhileStmt(parent))
             {
               if (isSgWhileStmt(parent)->get_condition()==targetStmt)
                    insertStatement(isSgStatement(parent),newStmt,insertBefore);
                 else
                    if (isSgWhileStmt(parent)->get_body()==targetStmt)
                       {
                      // ensureBasicBlockAsParent(targetStmt);
                         insertStatement(isSgStatement(parent),newStmt,insertBefore);
                       }
             }
            else
               if (isSgDoWhileStmt(parent))
                  {
                    if (isSgDoWhileStmt(parent)->get_condition()==targetStmt)
                         insertStatement(isSgStatement(parent),newStmt,insertBefore);
                      else
                         if (isSgDoWhileStmt(parent)->get_body()==targetStmt)
                            {
                           // ensureBasicBlockAsParent(targetStmt);
                              insertStatement(isSgStatement(parent),newStmt,insertBefore);
                            }
                  }
                 else
                    if (isSgForStatement(parent))
                       {
                         if (isSgForStatement(parent)->get_loop_body()==targetStmt)
                            {
                           // ensureBasicBlockAsParent(targetStmt);
                              insertStatement(isSgStatement(parent),newStmt,insertBefore);
                            }
                           else
                              if (isSgForStatement(parent)->get_test()==targetStmt)
                                 {
                                   insertStatement(isSgStatement(parent),newStmt,insertBefore);
                                 }
                       }
                      else
                         isSgStatement(parent)->insert_statement(targetStmt,newStmt,insertBefore);

  // update the links after insertion!
     if (isSgFunctionDeclaration(newStmt))
          updateDefiningNondefiningLinks(isSgFunctionDeclaration(newStmt),scope);
   }

  void SageInterface::insertStatementList(SgStatement *targetStmt, const std::vector<SgStatement*>& newStmts, bool insertBefore) {
    if (insertBefore) {
      for (size_t i = 0; i < newStmts.size(); ++i) {
        insertStatementBefore(targetStmt, newStmts[i]);
      }
    } else {
      for (size_t i = newStmts.size(); i > 0; --i) {
        insertStatementAfter(targetStmt, newStmts[i - 1]);
      }
    }
  }

  void SageInterface::insertStatementAfter(SgStatement *targetStmt, SgStatement* newStmt, bool autoMovePreprocessingInfo /*= true*/)
  {
    insertStatement(targetStmt,newStmt,false, autoMovePreprocessingInfo);
  }

  void SageInterface::insertStatementListAfter(SgStatement *targetStmt, const std::vector<SgStatement*>& newStmts)
  {
    insertStatementList(targetStmt,newStmts,false);
  }

  //! Insert a statement after the last declaration within a scope. The statement will be prepended to the scope if there is no declaration statement found
  void SageInterface::insertStatementAfterLastDeclaration(SgStatement* stmt, SgScopeStatement* scope)
  {
    ROSE_ASSERT (stmt != NULL); 
    ROSE_ASSERT (scope != NULL); 
    // Insert to be the declaration after current declaration sequence, if any
    SgStatement* l_stmt = findLastDeclarationStatement (scope);
    if (l_stmt)
      insertStatementAfter(l_stmt,stmt);
    else
      prependStatement(stmt, scope);
  }

  //! Insert a list of statements after the last declaration within a scope. The statement will be prepended to the scope if there is no declaration statement found
  void SageInterface::insertStatementAfterLastDeclaration(std::vector<SgStatement*> stmt_list, SgScopeStatement* scope)
  {
    ROSE_ASSERT (scope != NULL); 
    vector <SgStatement* >::iterator iter;
    SgStatement* prev_stmt = NULL;
    for (iter= stmt_list.begin(); iter != stmt_list.end(); iter++)
    {
      if (iter == stmt_list.begin())
      {
        insertStatementAfterLastDeclaration (*iter, scope);
      }
      else
      {
        ROSE_ASSERT (prev_stmt != NULL);
        insertStatementAfter (prev_stmt, *iter);
      }
      prev_stmt = *iter;
    }
  }

  void SageInterface::insertStatementBefore(SgStatement *targetStmt, SgStatement* newStmt, bool autoMovePreprocessingInfo /*= true */)
  {
    insertStatement(targetStmt,newStmt,true, autoMovePreprocessingInfo);
  }

  void SageInterface::insertStatementListBefore(SgStatement *targetStmt, const std::vector<SgStatement*>& newStmts)
  {
    insertStatementList(targetStmt,newStmts,true);
  }

  //a wrapper for set_expression(), set_operand(), set_operand_exp() etc
  // special concern for lvalue, parent,
  // todo: warning overwritting existing operands
  void SageInterface::setOperand(SgExpression* target, SgExpression* operand)
  {
    ROSE_ASSERT(target);
    ROSE_ASSERT(operand);
    ROSE_ASSERT(target!=operand);
    switch (target->variantT())
    {
      case V_SgActualArgumentExpression:
        isSgActualArgumentExpression(target)->set_expression(operand);
        break;
      case V_SgAsmOp:
        isSgAsmOp(target)->set_expression(operand);
        break;
      case V_SgSizeOfOp:
        isSgSizeOfOp(target)->set_operand_expr(operand);
	break;
      case V_SgTypeIdOp:
        isSgTypeIdOp(target)->set_operand_expr(operand);
	break;
      case V_SgVarArgOp:
        isSgVarArgOp(target)->set_operand_expr(operand);
	break;
      case V_SgVarArgStartOneOperandOp:
        isSgVarArgStartOneOperandOp(target)->set_operand_expr(operand);
	break;
      default:
        if (isSgUnaryOp(target)!=NULL) isSgUnaryOp(target)->set_operand_i(operand);
	else
	  {
            cout<<"SageInterface::setOperand(): unhandled case for target expression of type "
                <<target->class_name()<<endl;
            ROSE_ASSERT(false);
	  }
    }// end switch
    operand->set_parent(target);
    markLhsValues(target);
  }

  // binary and SgVarArgCopyOp, SgVarArgStartOp
  void SageInterface::setLhsOperand(SgExpression* target, SgExpression* lhs)
  {
    ROSE_ASSERT(target);
    ROSE_ASSERT(lhs);
    ROSE_ASSERT(target!=lhs);
    bool hasrhs = false;

    SgVarArgCopyOp* varargcopy = isSgVarArgCopyOp(target);
    SgVarArgStartOp* varargstart = isSgVarArgStartOp(target);
    SgBinaryOp* binary = isSgBinaryOp(target);

    if (varargcopy!=NULL)
    {
      varargcopy->set_lhs_operand(lhs);
       if( varargcopy->get_rhs_operand()!=NULL) hasrhs= true;
    }
    else if(varargstart!=NULL)
    {
      varargstart->set_lhs_operand(lhs);
      if( varargstart->get_rhs_operand()!=NULL) hasrhs= true;
    }
    else if(binary!=NULL)
    {
      binary->set_lhs_operand(lhs);
      if( binary->get_rhs_operand()!=NULL) hasrhs= true;
    }
    else
    {
      cout<<"SageInterface::setLhsOperand(): unhandled case for target expression of type "
                <<target->class_name()<<endl;
      ROSE_ASSERT(false);
    }
    lhs->set_parent(target);
// only when both lhs and rhs are available, can we set lvalue
// there is assertion(rhs!=NULL) in markLhsValues()
   if (hasrhs)
      markLhsValues(target);
  }

  void SageInterface::setRhsOperand(SgExpression* target, SgExpression* rhs)
  {
    ROSE_ASSERT(target);
    ROSE_ASSERT(rhs);
    ROSE_ASSERT(target!=rhs);
    bool haslhs = false;

    SgVarArgCopyOp* varargcopy = isSgVarArgCopyOp(target);
    SgVarArgStartOp* varargstart = isSgVarArgStartOp(target);
    SgBinaryOp* binary = isSgBinaryOp(target);

    if (varargcopy!=NULL)
    {
       varargcopy->set_rhs_operand(rhs);
       if( varargcopy->get_lhs_operand()!=NULL) haslhs= true;
    }
    else if(varargstart!=NULL)
    {
      varargstart->set_rhs_operand(rhs);
      if( varargstart->get_lhs_operand()!=NULL) haslhs= true;
    }
    else if(binary!=NULL)
    {
      binary->set_rhs_operand(rhs);
      if( binary->get_lhs_operand()!=NULL) haslhs= true;
    }
    else
    {
      cout<<"SageInterface::setRhsOperand(): unhandled case for target expression of type "
                <<target->class_name()<<endl;
      ROSE_ASSERT(false);
    }
    rhs->set_parent(target);
// only when both lhs and rhs are available, can we set lvalue
   if (haslhs)
      markLhsValues(target);
  }

// DQ (1/25/2010): Added to simplify handling of directories (e.g. for code generation).
void SageInterface::moveToSubdirectory ( std::string directoryName, SgFile* file )
   {
  // This support makes use of the new SgDirectory IR node.  It causes the unparser to
  // generate a subdirectory and unparse the file into the subdirectory.  It works
  // by internally calling the system function "system()" to call "mkdir directoryName"
  // and then chdir()" to change the current directory.  These steps are handled by the
  // unparser.

  // This function just does the transformation to insert a SgDirectory IR node between
  // the referenced SgFile and it's project (fixing up parents and file lists etc.).

  // Add a directory and unparse the code (to the new directory)
     SgDirectory* directory = new SgDirectory(directoryName);

     SgFileList* parentFileList = isSgFileList(file->get_parent());
     ROSE_ASSERT(parentFileList != NULL);
     directory->set_parent(file->get_parent());

     SgProject* project           = NULL;
     SgDirectory* parentDirectory = isSgDirectory(parentFileList->get_parent());

     if (parentDirectory != NULL)
        {
       // Add a directory to the list in the SgDirectory node.
          parentDirectory->get_directoryList()->get_listOfDirectories().push_back(directory);

       // Erase the reference to the file in the project's file list.
       // parentDirectory->get_fileList().erase(find(parentDirectory->get_fileList().begin(),parentDirectory->get_fileList().end(),file));
        }
       else
        {
          project = isSgProject(parentFileList->get_parent());
          ROSE_ASSERT(project != NULL);

       // Add a directory to the list in the SgProject node.
          project->get_directoryList()->get_listOfDirectories().push_back(directory);

       // Erase the reference to the file in the project's file list.
       // project->get_fileList().erase(find(project->get_fileList().begin(),project->get_fileList().end(),file));
        }

  // Put the file into the new directory.
     directory->get_fileList()->get_listOfFiles().push_back(file);

  // Erase the reference to the file in the project's file list.
     parentFileList->get_listOfFiles().erase(find(parentFileList->get_listOfFiles().begin(),parentFileList->get_listOfFiles().end(),file));

     file->set_parent(directory);
}


//------------------------- AST repair----------------------------
//----------------------------------------------------------------
  void SageInterface::fixStructDeclaration(SgClassDeclaration* structDecl, SgScopeStatement* scope)
  {
    ROSE_ASSERT(structDecl != NULL);
    ROSE_ASSERT(scope != NULL);
    SgClassDeclaration* nondefdecl = isSgClassDeclaration(structDecl->get_firstNondefiningDeclaration());
    ROSE_ASSERT(nondefdecl != NULL);

    ROSE_ASSERT(structDecl->get_definingDeclaration() != NULL);
    SgClassDeclaration* defdecl = isSgClassDeclaration(structDecl->get_definingDeclaration());
    ROSE_ASSERT(defdecl != NULL);

    // Liao, 9/2/2009
    // fixup missing scope when bottomup AST building is used
    if (structDecl->get_scope() == NULL)
      structDecl->set_scope(scope);
    if (nondefdecl->get_scope() == NULL)
      nondefdecl->set_scope(scope);

    if (structDecl->get_parent() == NULL)
      structDecl->set_parent(scope);
    if (nondefdecl->get_parent() == NULL)
      nondefdecl->set_parent(scope);

    SgName name= structDecl->get_name();
    // This is rare case (translation error) when scope->lookup_class_symbol(name) will find something
    // but nondefdecl->get_symbol_from_symbol_table() returns NULL
    // But symbols are associated with nondefining declarations whenever possible
    // and AST consistent check will check the nondefining declarations first
    // Liao, 9/2/2009
    //SgClassSymbol* mysymbol = scope->lookup_class_symbol(name);
    SgClassSymbol* mysymbol = isSgClassSymbol(nondefdecl->get_symbol_from_symbol_table());
    if (mysymbol == NULL)
    {
      mysymbol = new SgClassSymbol(nondefdecl);
      ROSE_ASSERT(mysymbol);
      scope->insert_symbol(name, mysymbol);

      ROSE_ASSERT(defdecl != NULL);
      defdecl->set_scope(scope);
      nondefdecl->set_scope(scope);

      defdecl->set_parent(scope);
      nondefdecl->set_parent(scope);
    }
    //fixup SgClassType, which is associated with the first non-defining declaration only
    //and the other declarations share it.
    if (nondefdecl->get_type() == NULL)
    {
      nondefdecl->set_type(SgClassType::createType(nondefdecl));
    }
    ROSE_ASSERT (nondefdecl->get_type() != NULL);

    ROSE_ASSERT(defdecl != NULL);
    if (defdecl->get_type()!= nondefdecl->get_type())
    {
      if (defdecl->get_type())
        delete defdecl->get_type();
      defdecl->set_type(nondefdecl->get_type());
    }
    ROSE_ASSERT (defdecl->get_type() != NULL);
    ROSE_ASSERT (defdecl->get_type() == nondefdecl->get_type());
  }

  void SageInterface::fixClassDeclaration(SgClassDeclaration* classDecl, SgScopeStatement* scope)
  {
    fixStructDeclaration(classDecl,scope);
  }

  void SageInterface::fixNamespaceDeclaration(SgNamespaceDeclarationStatement* structDecl, SgScopeStatement* scope)
  {
    ROSE_ASSERT(structDecl);
    ROSE_ASSERT(scope);
    SgNamespaceDeclarationStatement* nondefdecl = isSgNamespaceDeclarationStatement(structDecl->get_firstNondefiningDeclaration());
    ROSE_ASSERT(nondefdecl);
    // Liao, 9/2/2009
    // fixup missing scope when bottomup AST building is used
    if (structDecl->get_parent() == NULL)
      structDecl->set_parent(scope);
    if (nondefdecl->get_parent() == NULL)
      nondefdecl->set_parent(scope);

	// tps : (09/03/2009) Namespace should not have a scope
    /*
    if (structDecl->get_scope() == NULL)
      structDecl->set_scope(scope);
    if (nondefdecl->get_scope() == NULL)
      nondefdecl->set_scope(scope);
    */


    SgName name= structDecl->get_name();
    //SgNamespaceSymbol* mysymbol = scope->lookup_namespace_symbol(name);
    SgNamespaceSymbol* mysymbol = isSgNamespaceSymbol(nondefdecl->get_symbol_from_symbol_table());
    if (mysymbol==NULL)
    {
      mysymbol = new SgNamespaceSymbol(name,nondefdecl);
      ROSE_ASSERT(mysymbol);
      scope->insert_symbol(name, mysymbol);
      SgNamespaceDeclarationStatement* defdecl = isSgNamespaceDeclarationStatement(structDecl->get_definingDeclaration());
      ROSE_ASSERT(defdecl);
      defdecl->set_scope(scope);
      nondefdecl->set_scope(scope);

      defdecl->set_parent(scope);
      nondefdecl->set_parent(scope);
    }
  }

  void SageInterface::fixVariableDeclaration(SgVariableDeclaration* varDecl, SgScopeStatement* scope)
  {
    ROSE_ASSERT(varDecl);
    ROSE_ASSERT(scope);

    SgInitializedNamePtrList namelist = varDecl->get_variables();

    //avoid duplicated work
    // CH (2010/7/28): The following test may have a bug. Its scope may be not NULL but different from
    // the scope passed in.
    //if (namelist.size()>0) if (namelist[0]->get_scope()!=NULL) return;
    if (namelist.size() > 0) if (namelist[0]->get_scope() == scope) return;
    SgInitializedNamePtrList::iterator i;
    for (i=namelist.begin();i!=namelist.end();i++)
   {
      SgInitializedName *initName =*i;
      ROSE_ASSERT(initName);

      SgName name= initName->get_name();
      initName->set_scope(scope);
     // optional?
      varDecl->set_parent(scope);
      // symbol table
      ROSE_ASSERT(scope != NULL);
      SgVariableSymbol* varSymbol = scope->lookup_variable_symbol(name);
      if (varSymbol==NULL)
      {
        varSymbol = new SgVariableSymbol(initName);
        ROSE_ASSERT(varSymbol);
        scope->insert_symbol(name, varSymbol);
      }
      else
      { // TODO consider prepend() and insert(), prev_decl_time is position dependent.
    //   cout<<"sageInterface.C:5130 debug: found a previous var declaration!!...."<<endl;
	SgInitializedName* prev_decl = varSymbol->get_declaration();
	ROSE_ASSERT(prev_decl);
	initName->set_prev_decl_item(prev_decl);
      } //end if
    } //end for
    // Liao 12/8/2010
    // For Fortran, a common statement may refer to a variable which is declared later.
    // In this case, a fake symbol is used for that variable reference.
    // But we have to replace the fake one with the real one once the variable declaration is inserted into AST
    if (SageInterface::is_Fortran_language() )
    {
      fixVariableReferences (scope);
    }
  }

int SageInterface::fixVariableReferences(SgNode* root)
{
  ROSE_ASSERT(root);
  int counter=0;
  Rose_STL_Container<SgNode*> varList;

  SgVarRefExp* varRef=NULL;
  Rose_STL_Container<SgNode*> reflist = NodeQuery::querySubTree(root, V_SgVarRefExp);
  for (Rose_STL_Container<SgNode*>::iterator i=reflist.begin();i!=reflist.end();i++)
  {
    varRef= isSgVarRefExp(*i);
    ROSE_ASSERT(varRef->get_symbol());
    SgInitializedName* initname= varRef->get_symbol()->get_declaration();


    if (initname->get_type()==SgTypeUnknown::createType())
      //    if ((initname->get_scope()==NULL) && (initname->get_type()==SgTypeUnknown::createType()))
    {
      SgName varName=initname->get_name();
      SgSymbol* realSymbol = NULL;

#if 1
      // CH (5/7/2010): Before searching SgVarRefExp objects, we should first deal with class/structure
      // members. Or else, it is possible that we assign the wrong symbol to those members if there is another
      // variable with the same name in parent scopes. Those members include normal member referenced using . or ->
      // operators, and static members using :: operators.
      //
      if (SgArrowExp* arrowExp = isSgArrowExp(varRef->get_parent()))
      {
        if (varRef == arrowExp->get_rhs_operand_i())
        {
            // make sure the lhs operand has been fixed
            counter += fixVariableReferences(arrowExp->get_lhs_operand_i());

            SgPointerType* ptrType = isSgPointerType(arrowExp->get_lhs_operand_i()->get_type());
            ROSE_ASSERT(ptrType);
            SgClassType* clsType = isSgClassType(ptrType->get_base_type());
            ROSE_ASSERT(clsType);
            SgClassDeclaration* decl = isSgClassDeclaration(clsType->get_declaration());
            decl = isSgClassDeclaration(decl->get_definingDeclaration());
            ROSE_ASSERT(decl);
            realSymbol = lookupSymbolInParentScopes(varName, decl->get_definition());
        }
        else
            realSymbol = lookupSymbolInParentScopes(varName,getScope(varRef));
      }
      else if (SgDotExp* dotExp = isSgDotExp(varRef->get_parent()))
      {
        if (varRef == dotExp->get_rhs_operand_i())
        {
            // make sure the lhs operand has been fixed
            counter += fixVariableReferences(dotExp->get_lhs_operand_i());

            SgClassType* clsType = isSgClassType(dotExp->get_lhs_operand_i()->get_type());
            ROSE_ASSERT(clsType);
            SgClassDeclaration* decl = isSgClassDeclaration(clsType->get_declaration());
            decl = isSgClassDeclaration(decl->get_definingDeclaration());
            ROSE_ASSERT(decl);
            realSymbol = lookupSymbolInParentScopes(varName, decl->get_definition());
        }
        else
            realSymbol = lookupSymbolInParentScopes(varName,getScope(varRef));
      }
      else
#endif
          realSymbol = lookupSymbolInParentScopes(varName,getScope(varRef));

      // should find a real symbol at this final fixing stage!
      // This function can be called any time, not just final fixing stage
      if (realSymbol==NULL)
      {
        //cerr<<"Error: cannot find a symbol for "<<varName.getString()<<endl;
        //ROSE_ASSERT(realSymbol);
      }
      else {
        // release placeholder initname and symbol
        ROSE_ASSERT(realSymbol!=(varRef->get_symbol()));
#if 0
        // CH (5/12/2010):
        // To delete a symbol node, first check if there is any node in memory
        // pool which points to this symbol node. Only if no such node exists,
        // this symbol together with its initialized name can be deleted.
        //
        bool toDelete = true;

        SgSymbol* symbolToDelete = varRef->get_symbol();
        varRef->set_symbol(isSgVariableSymbol(realSymbol));
        counter ++;

        if (varList.empty())
        {
            VariantVector vv(V_SgVarRefExp);
            varList = NodeQuery::queryMemoryPool(vv);
        }

        for (Rose_STL_Container<SgNode*>::iterator i = varList.begin();
                i != varList.end(); ++i)
        {
            if (SgVarRefExp* var = isSgVarRefExp(*i))
            {
                if (var->get_symbol() == symbolToDelete)
                {
                    toDelete = false;
                    break;
                }
            }
        }
        if (toDelete)
        {
            delete initname; // TODO deleteTree(), release File_Info nodes etc.
            delete symbolToDelete;
        }

#else

        // CH (2010/7/26): We cannot delete those initname and symbol here, since there may be other variable references
        // which point to them. We will delay this clear just before AstTests.
#if 0
        delete initname; // TODO deleteTree(), release File_Info nodes etc.
        delete (varRef->get_symbol());
#endif

        //std::cout << "Fixed variable reference: " << realSymbol->get_name().str() << std::endl;
        varRef->set_symbol(isSgVariableSymbol(realSymbol));
        counter ++;
#endif
      }
    }
  } // end for
  return counter;
}

void SageInterface::clearUnusedVariableSymbols()
{
    Rose_STL_Container<SgNode*> symbolList;
    VariantVector sym_vv(V_SgVariableSymbol);
    symbolList = NodeQuery::queryMemoryPool(sym_vv);

    Rose_STL_Container<SgNode*> varList;
    VariantVector var_vv(V_SgVarRefExp);
    varList = NodeQuery::queryMemoryPool(var_vv);

    for (Rose_STL_Container<SgNode*>::iterator i = symbolList.begin();
            i != symbolList.end(); ++i)
    {
        SgVariableSymbol* symbolToDelete = isSgVariableSymbol(*i);
        ROSE_ASSERT(symbolToDelete);
        if (symbolToDelete->get_declaration()->get_type() != SgTypeUnknown::createType())
            continue;

        bool toDelete = true;

#if 0
        for (Rose_STL_Container<SgNode*>::iterator j = varList.begin();
                j != varList.end(); ++j)
        {
            SgVarRefExp* var = isSgVarRefExp(*j);
            ROSE_ASSERT(var);

            if (var->get_symbol() == symbolToDelete)
            {
                toDelete = false;
                break;
            }
        }
#endif

        if (toDelete)
        {
#if 0
            std::cout << "Symbol " << symbolToDelete->get_name().str() << ' ' << symbolToDelete <<
               ' ' << symbolToDelete->get_declaration() <<  " is deleted." << std::endl;
#endif
            delete symbolToDelete->get_declaration();
            delete symbolToDelete;
        }
    }
}

//! fixup symbol table for SgLableStatement. Used Internally when the label is built without knowing its target scope. Both parameters cannot be NULL.
/*
 * label statement has special scope: the closest function definition , not SgBasicBlock or others!
 */
void SageInterface::fixLabelStatement(SgLabelStatement* stmt, SgScopeStatement* scope)
{
   SgLabelStatement* label_stmt = isSgLabelStatement(stmt);
   ROSE_ASSERT(label_stmt);
   SgName name = label_stmt->get_label();

   SgScopeStatement* label_scope = getEnclosingFunctionDefinition(scope,true);
   if (label_scope) //Should we assert this instead? No for bottom up AST building
    {
     label_stmt->set_scope(label_scope);
     SgLabelSymbol* lsymbol = label_scope->lookup_label_symbol(name);
     if (!lsymbol)
      {
        lsymbol= new SgLabelSymbol(label_stmt);
        ROSE_ASSERT(lsymbol);
        label_scope->insert_symbol(lsymbol->get_name(), lsymbol);
      }
    }// end label_scope
} // fixLabelStatement()

//! Set a numerical label for a Fortran statement. The statement should have a enclosing function definition already. SgLabelSymbol and SgLabelR
//efExp are created transparently as needed.
void SageInterface::setFortranNumericLabel(SgStatement* stmt, int label_value)
{
  ROSE_ASSERT (stmt != NULL);
  ROSE_ASSERT (label_value >0 && label_value <=99999); //five digits for Fortran label
  SgScopeStatement* label_scope = getEnclosingFunctionDefinition(stmt);
  ROSE_ASSERT (label_scope != NULL);
  SgName label_name(StringUtility::numberToString(label_value));
  SgLabelSymbol * symbol = label_scope->lookup_label_symbol (label_name);
  if (symbol == NULL)
  {
    symbol = new SgLabelSymbol(NULL);
    ROSE_ASSERT(symbol != NULL);
    symbol->set_fortran_statement(stmt);
    symbol->set_numeric_label_value(label_value);
    label_scope->insert_symbol(label_name,symbol);
  }
  else
  {
    cerr<<"Error. SageInterface::setFortranNumericLabel() tries to set a duplicated label value!"<<endl;
    ROSE_ASSERT (false);
  }  
  //SgLabelRefExp
  SgLabelRefExp* ref_exp = buildLabelRefExp(symbol);
  stmt->set_numeric_label(ref_exp);
  ref_exp->set_parent(stmt);
  
}

//! Suggest next usable (non-conflicting) numeric label value for a Fortran function definition scope
int  SageInterface::suggestNextNumericLabel(SgFunctionDefinition* func_def)
{
  int result =10;
  ROSE_ASSERT (func_def != NULL);
  ROSE_ASSERT (SageInterface::is_Fortran_language()== true);
  std::set<SgNode*> symbols = func_def->get_symbol_table()->get_symbols();
  
  // find the max label value, +10 to be the suggested next label value
  std::set<SgNode*>::iterator iter ;
  for (iter=symbols.begin(); iter !=symbols.end(); iter++)
  {
    SgLabelSymbol * l_symbol = isSgLabelSymbol(*iter);
    if (l_symbol)
    {
      int cur_val = l_symbol->get_numeric_label_value();
      if (result <=cur_val)
        result = cur_val +10;
    }
  }

  ROSE_ASSERT (result <=99999); // max 5 digits for F77 label
  return result; 
}

//! A wrapper containing fixes (fixVariableDeclaration(),fixStructDeclaration(), fixLabelStatement(), etc) for all kinds statements.
void SageInterface::fixStatement(SgStatement* stmt, SgScopeStatement* scope)
{
  // fix symbol table
  if (isSgVariableDeclaration(stmt))
      fixVariableDeclaration(isSgVariableDeclaration(stmt), scope);
  else if (isStructDeclaration(stmt))
  {
  // DQ (1/2/2010): Enforce some rules as early as possible.
  // fixStructDeclaration(isSgClassDeclaration(stmt),scope);
     SgClassDeclaration* classDeclaration = isSgClassDeclaration(stmt);
     ROSE_ASSERT(classDeclaration != NULL);
#if 0
     ROSE_ASSERT(classDeclaration->get_firstNondefiningDeclaration() != NULL);
     ROSE_ASSERT(classDeclaration->get_definingDeclaration() != NULL);
#endif
     fixStructDeclaration(classDeclaration,scope);
  }
  else if (isSgClassDeclaration(stmt))
      fixClassDeclaration(isSgClassDeclaration(stmt),scope);
  else if (isSgLabelStatement(stmt))
      fixLabelStatement(isSgLabelStatement(stmt),scope);
  else if (isSgFunctionDeclaration(stmt))
  {  //fix function type table's parent edge
    // Liao 5/4/2010
    SgFunctionTypeTable * fTable = SgNode::get_globalFunctionTypeTable();
    ROSE_ASSERT(fTable);
    if (fTable->get_parent() == NULL)
      fTable->set_parent(getGlobalScope(scope));

  }

  // fix scope pointer for statements explicitly storing scope pointer
  switch (stmt->variantT())
   {
     case V_SgEnumDeclaration:
     case V_SgTemplateDeclaration:
     case V_SgTypedefDeclaration:
     case V_SgFunctionDeclaration:
  //   case V_SgLabelStatement:
  //   Label statement' scope is special, handled in fixLabelStatement()
      stmt->set_scope(scope);
      break;
    default:
      break;
   } // switch

} // fixStatement()

/*! Liao, 7/3/2008
 * Update a list of function declarations inside a scope according to a newly introduced one
 *
 * Algorithm:
 * iterate declaration list for the same functions
 * func is defining:
 *       set_defining for all
 * func is nondefining:
 *       is first ?  set_first_nondefining for all
 *       not the first ? set first nondefining for itself only
 */
void SageInterface::updateDefiningNondefiningLinks(SgFunctionDeclaration* func, SgScopeStatement* scope)
{
  ROSE_ASSERT(func&&scope);
  SgStatementPtrList stmtList, sameFuncList;
  //SgFunctionDeclaration* first_nondef = NULL;
  // Some annoying part of scope
  if (scope->containsOnlyDeclarations())
  {
    SgDeclarationStatementPtrList declList = scope->getDeclarationList();
    SgDeclarationStatementPtrList::iterator i;
    for (i=declList.begin();i!=declList.end();i++)
      stmtList.push_back(*i);
  }
  else
    stmtList = scope->getStatementList();

  // Find the same function declaration list, including func itself
  SgStatementPtrList::iterator j;
  for (j=stmtList.begin();j!=stmtList.end();j++)
  {
    SgFunctionDeclaration* func_decl = isSgFunctionDeclaration(*j);
    if (func_decl)
    {
      if (isSameFunction(func_decl, func))
      {
        // Assume all defining functions have definingdeclaration links set properly already!!
        //if ((first_nondef == NULL) && (func_decl->get_definingDeclaration() == NULL))
        //  first_nondef = func_decl;
        sameFuncList.push_back(func_decl);
      }
    } // if (func_decl)
  } // for

  if(func->get_definingDeclaration()==func)
  {
    for (j=sameFuncList.begin();j!=sameFuncList.end();j++)
      isSgFunctionDeclaration(*j)->set_definingDeclaration(func);
  }
  else if (func==isSgFunctionDeclaration(*(sameFuncList.begin()))) // is first_nondefining declaration
  {
    for (j=sameFuncList.begin();j!=sameFuncList.end();j++)
      isSgFunctionDeclaration(*j)->set_firstNondefiningDeclaration(func);
  } else // is a following nondefining declaration, grab any other's first nondefining link then
  {
     func->set_firstNondefiningDeclaration(isSgFunctionDeclaration(*(sameFuncList.begin()))
                      ->get_firstNondefiningDeclaration());
  }// if
} // updateDefiningNondefiningLinks()

//---------------------------------------------------------------
PreprocessingInfo* SageInterface::attachComment(
           SgLocatedNode* target, const string& content,
           PreprocessingInfo::RelativePositionType  position /*=PreprocessingInfo::before*/,
           PreprocessingInfo::DirectiveType dtype /* PreprocessingInfo::CpreprocessorUnknownDeclaration */)
   {
     ROSE_ASSERT(target); //dangling comment is not allowed

     PreprocessingInfo* result = NULL;
     PreprocessingInfo::DirectiveType mytype=dtype;
     string comment;

  // DQ (5/5/2010): infer comment type from target's language
     if (mytype == PreprocessingInfo::CpreprocessorUnknownDeclaration)
        {
       // This is a rather expensive way to detect the language type (chases pointers back to the SgFile object).
          if (is_C_language() || is_C99_language())
             {
               mytype = PreprocessingInfo::C_StyleComment;
            // comment = "/* "+ content + " */";
             }
            else
             {
               if (is_Cxx_language())
                  {
                    mytype = PreprocessingInfo::CplusplusStyleComment;
                 // comment = "// "+ content;
                  }
                 else  // TODO :What about Fortran?
                  {
                    if (is_Fortran_language() || is_CAF_language()) //FMZ:3/23/2009
                       {
                         mytype = PreprocessingInfo::F90StyleComment;
                      // comment = "// "+ content;
                       }
                      else  // TODO :What about Fortran?
                       {
                         cout<<"Un-handled programming languages when building source comments.. "<<endl;
                         ROSE_ASSERT(false);
                       }
                  }
             }
        }

  // Once the langauge type is set (discovered automatically or more directly specified by the user).
     bool resetPositionInfo = false;
     switch (mytype)
        {
          case PreprocessingInfo::C_StyleComment:        comment = "/* " + content + " */"; break;
          case PreprocessingInfo::CplusplusStyleComment: comment = "// " + content;         break;
          case PreprocessingInfo::FortranStyleComment:   comment = "      C " + content;    break;
          case PreprocessingInfo::F90StyleComment:   comment = "!" + content;    break;
          case PreprocessingInfo::CpreprocessorLineDeclaration:
               comment = "#myline " + content;
               mytype = PreprocessingInfo::CplusplusStyleComment;
               resetPositionInfo = true;
               break;

          default:
             {
               printf ("Error: default in switch reached in SageInterface::attachComment() PreprocessingInfo::DirectiveType == %d \n",mytype);
               ROSE_ASSERT(false);
             }
        }

     result = new PreprocessingInfo (mytype,comment, "transformation-generated", 0, 0, 0, position);

  // If this is a Cpp Line declaration then we have to set the position to match the statement.
  // if (mytype == PreprocessingInfo::CpreprocessorLineDeclaration)
     if (resetPositionInfo == true)
        {
       // Call the Sg_File_Info::operator=() member function.
          *(result->get_file_info()) = *(target->get_file_info());
        }

     ROSE_ASSERT(result);
     target->addToAttachedPreprocessingInfo(result);
     return result;
   }

PreprocessingInfo* SageInterface::insertHeader(const string& filename, PreprocessingInfo::RelativePositionType position /*=after*/, bool isSystemHeader /*=false*/, SgScopeStatement* scope /*=NULL*/)
  {
    bool successful = false;
    if (scope == NULL)
	scope = SageBuilder::topScopeStack();
    ROSE_ASSERT(scope);
    SgGlobal* globalScope = getGlobalScope(scope);
    ROSE_ASSERT(globalScope);

    PreprocessingInfo* result=NULL;
    string content;
    if (isSystemHeader)
      content = "#include <" + filename + "> \n";
    else
      content = "#include \"" + filename + "\" \n";

    SgDeclarationStatementPtrList & stmtList = globalScope->get_declarations ();
    if (stmtList.size()>0) // the source file is not empty
     {
      for (SgDeclarationStatementPtrList::iterator j = stmtList.begin ();
           j != stmtList.end (); j++)
      {
	    //must have this judgement, otherwise wrong file will be modified!
            //It could also be the transformation generated statements with #include attached
	if ( ((*j)->get_file_info ())->isSameFile(globalScope->get_file_info ())||
              ((*j)->get_file_info ())->isTransformation()
           )
	 {
           result = new PreprocessingInfo(PreprocessingInfo::CpreprocessorIncludeDeclaration,
                                          content, "Transformation generated",0, 0, 0, PreprocessingInfo::before);
           ROSE_ASSERT(result);
	   (*j)->addToAttachedPreprocessingInfo(result,position);
           successful = true;
           break;
         }
      }
     }
    else // empty file, attach it after SgGlobal,TODO it is not working for unknown reason!!
     {
       cerr<<"SageInterface::insertHeader() Empty file is found!"<<endl;
       cerr<<"#include xxx is  preprocessing information which has to be attached  to some other  located node (a statement for example)"<<endl;
       cerr<<"You may have to insert some statement first before inserting a header"<<endl;
       ROSE_ASSERT(false);
       result = new PreprocessingInfo(PreprocessingInfo::CpreprocessorIncludeDeclaration,
                content, "Transformation generated",0, 0, 0, PreprocessingInfo::after);
       ROSE_ASSERT(result);
       globalScope->addToAttachedPreprocessingInfo(result,position);
       successful = true;
    }
    // must be inserted once somehow
    ROSE_ASSERT(successful==true);
    return result;
  }


//! Attach an arbitrary string to a located node. A workaround to insert irregular statements or vendor-specific attributes. We abuse CpreprocessorDefineDeclaration for this purpose.
PreprocessingInfo* SageInterface::attachArbitraryText(SgLocatedNode* target,
                const std::string & text,
               PreprocessingInfo::RelativePositionType position/*=PreprocessingInfo::before*/)
{
    ROSE_ASSERT(target != NULL); //dangling #define xxx is not allowed in the ROSE AST
    PreprocessingInfo* result = NULL;
    PreprocessingInfo::DirectiveType mytype = PreprocessingInfo::CpreprocessorDefineDeclaration;
    result = new PreprocessingInfo (mytype,text, "transformation-generated", 0, 0, 0, position);
    ROSE_ASSERT(result);
    target->addToAttachedPreprocessingInfo(result);
    return result;
}


//!Check if a target node has MacroCall attached, if yes, replace them with expanded strings
// TODO This is a dirty fix since the ideal solution would be having a preprocessed pragma text generated by the compiler. String matching and replacing is never safe.
void SageInterface::replaceMacroCallsWithExpandedStrings(SgPragmaDeclaration* target)
{
  // This is part of Wave support in ROSE.
// #if CAN_NOT_COMPILE_WITH_ROSE != true
// #if CAN_NOT_COMPILE_WITH_ROSE == 0
#ifndef USE_ROSE
  ROSE_ASSERT(target != NULL);
  AttachedPreprocessingInfoType *info=  target->getAttachedPreprocessingInfo ();
  if (info == NULL) return;
  AttachedPreprocessingInfoType::iterator j;
  for (j = info->begin (); j != info->end (); j++)
  {
    if ((*j)->getTypeOfDirective()==PreprocessingInfo::CMacroCall)
    {
      std::ostringstream os;
      token_container tc = (*j)->get_macro_call()->expanded_macro;
      token_container::const_iterator iter;
      for (iter=tc.begin(); iter!=tc.end(); iter++)
        os<<(*iter).get_value();
      //cout<<"Found a macro call: "<<(*j)->getString()<<
      //"\nexpanding it to: "<<os.str()<<endl;
      string pragmaText = target->get_pragma()->get_pragma();
      string targetString = (*j)->getString();
      string replacement = os.str();
      // repeat until not found
      size_t pos1 = pragmaText.find(targetString);
      while (pos1 != string::npos)
      {
        pragmaText.replace(pos1, targetString.size(), replacement);
        pos1 = pragmaText.find(targetString);
      }
       delete target->get_pragma();
       target->set_pragma(buildPragma(pragmaText));
    } // end if
  } // end for
#endif
}

//! If the given statement contains any break statements in its body, add a
//! new label below the statement and change the breaks into gotos to that
//! new label.
void SageInterface::changeBreakStatementsToGotos(SgStatement* loopOrSwitch) {
  using namespace SageBuilder;
  SgStatement* body = NULL;
  if (isSgWhileStmt(loopOrSwitch) || isSgDoWhileStmt(loopOrSwitch) ||
      isSgForStatement(loopOrSwitch)) {
    body = SageInterface::getLoopBody(isSgScopeStatement(loopOrSwitch));
  } else if (isSgSwitchStatement(loopOrSwitch)) {
    body = isSgSwitchStatement(loopOrSwitch)->get_body();
  }
  ROSE_ASSERT (body);
  std::vector<SgBreakStmt*> breaks = SageInterface::findBreakStmts(body);
  if (!breaks.empty()) {
    static int breakLabelCounter = 0;
    SgLabelStatement* breakLabel =
      buildLabelStatement("breakLabel" +
StringUtility::numberToString(++breakLabelCounter),
                          buildBasicBlock(),
                          isSgScopeStatement(loopOrSwitch->get_parent()));
    insertStatement(loopOrSwitch, breakLabel, false);
    for (size_t j = 0; j < breaks.size(); ++j) {
      SgGotoStatement* newGoto = buildGotoStatement(breakLabel);

  isSgStatement(breaks[j]->get_parent())->replace_statement(breaks[j],
  newGoto);
	newGoto->set_parent(breaks[j]->get_parent());
      }
    }
  }

  bool SageInterface::isStructDeclaration(SgNode* node)
  {
    ROSE_ASSERT(node!=NULL);
    SgClassDeclaration *decl = isSgClassDeclaration(node);
    if (decl==NULL)
      return false;
    else
       return (decl->get_class_type() == SgClassDeclaration::e_struct)? true:false;
  }

void  SageInterface::movePreprocessingInfo (SgStatement* stmt_src,  SgStatement* stmt_dst, PreprocessingInfo::RelativePositionType src_position/* =PreprocessingInfo::undef */,
                            PreprocessingInfo::RelativePositionType dst_position/* =PreprocessingInfo::undef */, bool usePrepend /*= false */)
{
  ROSE_ASSERT(stmt_src != NULL);
  ROSE_ASSERT(stmt_dst != NULL);
  AttachedPreprocessingInfoType* infoList=stmt_src->getAttachedPreprocessingInfo();
  AttachedPreprocessingInfoType* infoToRemoveList = new AttachedPreprocessingInfoType();

  if (infoList == NULL) return;
  for (Rose_STL_Container<PreprocessingInfo*>::iterator i= (*infoList).begin();
      i!=(*infoList).end();i++)
  {
    PreprocessingInfo * info=dynamic_cast<PreprocessingInfo *> (*i);
    ROSE_ASSERT(info != NULL);

    if ( (info->getTypeOfDirective()==PreprocessingInfo::CpreprocessorIncludeDeclaration )||
        (info->getTypeOfDirective()==PreprocessingInfo::CpreprocessorDefineDeclaration )||
        (info->getTypeOfDirective()==PreprocessingInfo::CpreprocessorUndefDeclaration)||
        (info->getTypeOfDirective()==PreprocessingInfo::CpreprocessorIfdefDeclaration )||
        (info->getTypeOfDirective()==PreprocessingInfo::CpreprocessorIfndefDeclaration )||
        (info->getTypeOfDirective()==PreprocessingInfo::CpreprocessorIfDeclaration )||
        (info->getTypeOfDirective()==PreprocessingInfo::CpreprocessorElseDeclaration )||
        (info->getTypeOfDirective()==PreprocessingInfo::CpreprocessorElifDeclaration )||
        (info->getTypeOfDirective()==PreprocessingInfo::C_StyleComment)||
        (info->getTypeOfDirective()==PreprocessingInfo::CpreprocessorEndifDeclaration )
       )
    {
      // move all source preprocessing info if the desired source type is not specified or matching
      // a specified desired source type
      if ( src_position == PreprocessingInfo::undef || info->getRelativePosition()==src_position)
      {
        if (usePrepend)
          // addToAttachedPreprocessingInfo() is poorly designed, the last parameter is used
          // to indicate appending or prepending by reusing the type of relative position.
          // this is very confusing for users
          stmt_dst->addToAttachedPreprocessingInfo(info,PreprocessingInfo::before);
        else
          stmt_dst->addToAttachedPreprocessingInfo(info,PreprocessingInfo::after);

        (*infoToRemoveList).push_back(*i);
      }
#if 0
      else if (info->getRelativePosition()==src_position)
      {

        if (usePrepend)
        {
        }
        else
          stmt_dst->addToAttachedPreprocessingInfo(info,PreprocessingInfo::after);

        (*infoToRemoveList).push_back(*i);
      } // if src_position
#endif
      // adjust dst position if needed
      if (dst_position != PreprocessingInfo::undef)
        info->setRelativePosition(dst_position);
    } // end if
  }// end for

  // Remove the element from the list of comments at the current astNode
  AttachedPreprocessingInfoType::iterator j;
  for (j = (*infoToRemoveList).begin(); j != (*infoToRemoveList).end(); j++)
    infoList->erase( find(infoList->begin(),infoList->end(),*j) );

}

//----------------------------
// Sometimes, the preprocessing info attached to a declaration has to be
// moved 'up' if another declaration is inserted before it.
// This is a workaround for the broken LowLevelRewrite::insert() and the private
// LowLevelRewrite::reassociatePreprocessorDeclarations()
//
// input:
//     *stmt_dst: the new inserted declaration
//     *stmt_src: the existing declaration with preprocessing information
// tasks:
//     judge if stmt_src has propressingInfo with headers, ifdef, etc..
//     add them into stmt_dst
//     delete them from stmt_dst
// More general usage: move preprocessingInfo of stmt_src to stmt_dst, should used before any
//           LoweLevel::remove(stmt_src)
void SageInterface::moveUpPreprocessingInfo(SgStatement * stmt_dst, SgStatement * stmt_src,
      PreprocessingInfo::RelativePositionType src_position/*=PreprocessingInfo::undef*/,
      PreprocessingInfo::RelativePositionType dst_position/*=PreprocessingInfo::undef*/,
      bool usePrepend /*= false */)
{
  movePreprocessingInfo (stmt_src, stmt_dst, src_position, dst_position, usePrepend);
} // moveUpPreprocessingInfo()



/*!
 *  \brief Returns 'true' iff the given info object is valid and has
 *  the specified position.
 */
static bool isNotRelPos (const PreprocessingInfo* info,
             PreprocessingInfo::RelativePositionType pos)
{
  return info && (info->getRelativePosition () != pos);
}

/*!
 *  \brief Returns 'true' iff the given info object is valid and does
 *  not have the specified position.
 */
static bool isRelPos (const PreprocessingInfo* info,
             PreprocessingInfo::RelativePositionType pos)
{
  return info && !isNotRelPos (info, pos);
}


//!Cut preprocessing information from a source node and save it into a buffer. Used in combination of pastePreprocessingInfo(). The cut-paste operaation is similar to moveUpPreprocessingInfo() but it is more flexible in that the destination node only need to be known until the paste action.
void SageInterface::cutPreprocessingInfo (SgLocatedNode* src_node, PreprocessingInfo::RelativePositionType pos, AttachedPreprocessingInfoType& save_buf)
{
  ROSE_ASSERT(src_node != NULL);

  AttachedPreprocessingInfoType* info = src_node->get_attachedPreprocessingInfoPtr();
  if (info)
  {
    remove_copy_if (info->begin (), info->end (),
        back_inserter (save_buf),
        bind2nd (ptr_fun (isNotRelPos), pos));

    // DQ (9/26/2007): Commented out as part of move from std::list to std::vector
    // info->remove_if (bind2nd (ptr_fun (isRelPos), pos));
    // Liao (10/3/2007), implement list::remove_if for vector, which lacks sth. like erase_if
    AttachedPreprocessingInfoType::iterator new_end =
      remove_if(info->begin(),info->end(),bind2nd(ptr_fun (isRelPos), pos));
    info->erase(new_end, info->end());
  }
}

static AttachedPreprocessingInfoType *
createInfoList (SgLocatedNode* s)
{
  ROSE_ASSERT (s);
  AttachedPreprocessingInfoType* info_list = s->get_attachedPreprocessingInfoPtr ();
  if (!info_list)
  {
    info_list = new AttachedPreprocessingInfoType;
    ROSE_ASSERT (info_list);
    s->set_attachedPreprocessingInfoPtr (info_list);
  }

  // Guarantee a non-NULL pointer.
  ROSE_ASSERT (info_list);
  return info_list;
}

//!Cut preprocessing information from a source node and save it into a buffer. Used in combination of pastePreprocessingInfo()
void SageInterface::pastePreprocessingInfo (SgLocatedNode* dst_node, PreprocessingInfo::RelativePositionType pos, AttachedPreprocessingInfoType& save_buf)
{
  if (save_buf.size()==0) return;
  // if front
  AttachedPreprocessingInfoType* info = createInfoList (dst_node);
  ROSE_ASSERT (info);

  // DQ (9/26/2007): Commented out as part of move from std::list to std::vector
  // printf ("Commented out front_inserter() as part of move from std::list to std::vector \n");
  // copy (save_buf.rbegin (), save_buf.rend (), front_inserter (*info));

  // Liao (10/3/2007), vectors can only be appended at the rear
  if (pos==PreprocessingInfo::before)
  {
    for(AttachedPreprocessingInfoType::reverse_iterator i=save_buf.rbegin();i!=save_buf.rend();i++)
      info->insert(info->begin(),*i);
  }
  // if back
  else if (pos==PreprocessingInfo::after)
    copy (save_buf.begin (), save_buf.end (), back_inserter (*info));
  else if (pos==PreprocessingInfo::inside)
  {
    copy (save_buf.begin (), save_buf.end (), back_inserter (*info));
    cerr<<"SageInterface::pastePreprocessingInfo() pos==PreprocessingInfo::inside is not supported."<<endl;
    save_buf[0]->display("ttt");
  }
}

void SageInterface::dumpPreprocInfo (SgLocatedNode* locatedNode)
{
  ROSE_ASSERT(locatedNode != NULL);
  AttachedPreprocessingInfoType *comments =
    locatedNode->getAttachedPreprocessingInfo ();

  if (comments != NULL)
  {
    printf ("-----------------------------------------------\n");
    printf ("Found an IR node (at %p of type: %s) in file %s \n",
        locatedNode, locatedNode->class_name ().c_str (),
        (locatedNode->get_file_info ()->get_filenameString ()).c_str ());
    int counter = 0;
    AttachedPreprocessingInfoType::iterator i;
    for (i = comments->begin (); i != comments->end (); i++)
    {
      printf
        ("with attached preprocessingInfo numbering #%d :------------- \nclassification= %s:\nString format:%s\n",
         counter++,
         PreprocessingInfo::directiveTypeName ((*i)->getTypeOfDirective ()).
         c_str (), (*i)->getString ().c_str ());
      if ((*i)->getRelativePosition () == PreprocessingInfo::inside)
        printf ("relative position is: inside\n");
      else
        printf ("relative position is: %s\n", \
            ((*i)->getRelativePosition () == PreprocessingInfo::before) ? "before" : "after");
    }
  }
  else
  {
    printf ("No attached preprocessing info. (at %p of type: %s): \n", locatedNode,
        locatedNode->sage_class_name ());
  }
}

/// \brief             helper function that ensures that a certain child node
///                    of a statement is a basic block.
/// \tparam ParentNode the type of the statement
/// \param stmt        the parent statement
/// \param setter      the member function to retrieve the child node
/// \param getter      the member function to set the child node
/// \return            the pointer stmt.getter() if it is a basic block
///                    a new basic block containing stmt.getter() otherewise
/// \details           if stmt.getter() is not a basic block,
///                    ensureBasicBlock_aux also sets
///                    stmt.setter(new basic block)
template <class ParentNode>
static
SgBasicBlock* ensureBasicBlock_aux( ParentNode& stmt,
                                    SgStatement* (ParentNode::*getter) () const,
                                    void (ParentNode::*setter) (SgStatement*)
                                  )
{
  SgStatement* const body_stmt = (stmt.*getter)();
  SgBasicBlock*      basicblock = isSgBasicBlock(body_stmt);

  if (basicblock == NULL) {
    basicblock = SageBuilder::buildBasicBlock(body_stmt);
    (stmt.*setter)(basicblock);
    basicblock->set_parent(&stmt);
  }

  ROSE_ASSERT (basicblock != NULL);
  return basicblock;
}

SgBasicBlock* SageInterface::ensureBasicBlockAsBodyOfFor(SgForStatement* fs)
{
  SgStatement* b = fs->get_loop_body();
  if (!isSgBasicBlock(b)) {
    b = SageBuilder::buildBasicBlock(b);
    fs->set_loop_body(b);
    b->set_parent(fs);
  }
  ROSE_ASSERT (isSgBasicBlock(b));
  return isSgBasicBlock(b);
}

SgBasicBlock* SageInterface::ensureBasicBlockAsBodyOfUpcForAll(SgUpcForAllStatement* fs)
{
  ROSE_ASSERT (fs != NULL);

  return ensureBasicBlock_aux(*fs, &SgUpcForAllStatement::get_loop_body, &SgUpcForAllStatement::set_loop_body);
}

  SgBasicBlock* SageInterface::ensureBasicBlockAsBodyOfWhile(SgWhileStmt* fs) {
    SgStatement* b = fs->get_body();
    if (!isSgBasicBlock(b)) {
      b = SageBuilder::buildBasicBlock(b);
      fs->set_body(b);
      b->set_parent(fs);
    }
    ROSE_ASSERT (isSgBasicBlock(b));
    return isSgBasicBlock(b);
  }

  SgBasicBlock* SageInterface::ensureBasicBlockAsBodyOfDoWhile(SgDoWhileStmt* fs) {
    SgStatement* b = fs->get_body();
    if (!isSgBasicBlock(b)) {
      b = SageBuilder::buildBasicBlock(b);
      fs->set_body(b);
      b->set_parent(fs);
    }
    ROSE_ASSERT (isSgBasicBlock(b));
    return isSgBasicBlock(b);
  }

  SgBasicBlock* SageInterface::ensureBasicBlockAsBodyOfSwitch(SgSwitchStatement* fs) {
    SgStatement* b = fs->get_body();
    if (!isSgBasicBlock(b)) {
      b = SageBuilder::buildBasicBlock(b);
      fs->set_body(b);
      b->set_parent(fs);
    }
    ROSE_ASSERT (isSgBasicBlock(b));
    return isSgBasicBlock(b);
  }

  SgBasicBlock* SageInterface::ensureBasicBlockAsTrueBodyOfIf(SgIfStmt* fs) {
    SgStatement* b = fs->get_true_body();
    if (!isSgBasicBlock(b)) {
      b = SageBuilder::buildBasicBlock(b);
      fs->set_true_body(b);
      b->set_parent(fs);
    }
    ROSE_ASSERT (isSgBasicBlock(b));
    return isSgBasicBlock(b);
  }

  SgBasicBlock* SageInterface::ensureBasicBlockAsFalseBodyOfIf(SgIfStmt* fs) {
    SgStatement* b = fs->get_false_body();
    if (!isSgBasicBlock(b)) {
      b = SageBuilder::buildBasicBlock(b); // This works if b is NULL as well (producing an empty block)
      fs->set_false_body(b);
      b->set_parent(fs);
    }
    ROSE_ASSERT (isSgBasicBlock(b));
    return isSgBasicBlock(b);
  }

  SgBasicBlock* SageInterface::ensureBasicBlockAsBodyOfCatch(SgCatchOptionStmt* fs) {
    SgStatement* b = fs->get_body();
    if (!isSgBasicBlock(b)) {
      b = SageBuilder::buildBasicBlock(b);
      fs->set_body(b);
      b->set_parent(fs);
    }
    ROSE_ASSERT (isSgBasicBlock(b));
    return isSgBasicBlock(b);
  }

SgBasicBlock* SageInterface::ensureBasicBlockAsBodyOfOmpBodyStmt(SgOmpBodyStatement* fs)
{
  SgStatement* b = fs->get_body();
  if (!isSgBasicBlock(b)) {
    b = SageBuilder::buildBasicBlock(b);
    fs->set_body(b);
    b->set_parent(fs);
  }
  ROSE_ASSERT (isSgBasicBlock(b));
  return isSgBasicBlock(b);
}


SgLocatedNode* SageInterface::ensureBasicBlockAsParent(SgStatement* s)
{
	//SgBasicBlock* ensureBasicBlockAsParent(SgStatement* s) {
	ROSE_ASSERT(s);

	//Vulov: The parent of a statement is not necessarily a statement. It could be SgStatementExpression
	SgLocatedNode* p = isSgLocatedNode(s->get_parent());
	ROSE_ASSERT(p);
	switch (p->variantT())
	{
		case V_SgBasicBlock: return isSgBasicBlock(p);
		case V_SgForStatement:
		{
			if (isSgForStatement(p)->get_loop_body() == s)
				return ensureBasicBlockAsBodyOfFor(isSgForStatement(p));
			else if (isSgForStatement(p)->get_test() == s)
			{
			}
			else if (isSgForStatement(p)->get_for_init_stmt() == s)
			{
			}
			else ROSE_ASSERT(false);
			break;
		}
    case V_SgUpcForAllStatement: // PP
    {
      SgUpcForAllStatement& upcforall = *isSgUpcForAllStatement(p);

      if (upcforall.get_loop_body() == s)
				return ensureBasicBlockAsBodyOfUpcForAll(&upcforall);

      ROSE_ASSERT(  (s == upcforall.get_for_init_stmt())
                 || (s == upcforall.get_test())
                 );
      break;
    }
		case V_SgWhileStmt:
		{
			if (isSgWhileStmt(p)->get_body() == s)
				return ensureBasicBlockAsBodyOfWhile(isSgWhileStmt(p));
			else if (isSgWhileStmt(p)->get_condition() == s)
			{
			}
			else ROSE_ASSERT(false);
			break;
		}
		case V_SgDoWhileStmt:
		{
			if (isSgDoWhileStmt(p)->get_body() == s)
				return ensureBasicBlockAsBodyOfDoWhile(isSgDoWhileStmt(p));
			else if (isSgDoWhileStmt(p)->get_condition() == s)
			{
			}
			else ROSE_ASSERT(false);
			break;
		}
		case V_SgSwitchStatement:
		{
			if (isSgSwitchStatement(p)->get_body() == s)
				return ensureBasicBlockAsBodyOfSwitch(isSgSwitchStatement(p));
			else if (isSgSwitchStatement(p)->get_item_selector() == s)
			{
			}
			else ROSE_ASSERT(false);
			break;
		}
		case V_SgCatchOptionStmt:
		{
			if (isSgCatchOptionStmt(p)->get_body() == s)
				return ensureBasicBlockAsBodyOfCatch(isSgCatchOptionStmt(p));
			else if (isSgCatchOptionStmt(p)->get_condition() == s)
			{
			}
			else ROSE_ASSERT(false);
			break;
		}
		case V_SgIfStmt:
		{
			if (isSgIfStmt(p)->get_true_body() == s)
				return ensureBasicBlockAsTrueBodyOfIf(isSgIfStmt(p));
			else if (isSgIfStmt(p)->get_false_body() == s)
				return ensureBasicBlockAsFalseBodyOfIf(isSgIfStmt(p));
			else if (isSgIfStmt(p)->get_conditional() == s)
			{
			}
			else ROSE_ASSERT(false);
			break;
		}
		default:
		{
			if (isSgOmpBodyStatement(p))
			{
				return ensureBasicBlockAsBodyOfOmpBodyStmt(isSgOmpBodyStatement(p));
			}
			else
				// Liao, 7/3/2008 We allow other conditions to fall through,
				// they are legal parents with list of statements as children.
				//cerr << "Unhandled parent block:"<< p->class_name() << endl;
				// ROSE_ASSERT (!"Bad parent in ensureBasicBlockAsParent");
				break;
		}
	}
	return p;
}

  void SageInterface::changeAllLoopBodiesToBlocks(SgNode* top) {
    struct Visitor: public AstSimpleProcessing {
      virtual void visit(SgNode* n) {
        switch (n->variantT()) {
          case V_SgForStatement: {
            ensureBasicBlockAsBodyOfFor(isSgForStatement(n));
            break;
          }
          case V_SgWhileStmt: {
            ensureBasicBlockAsBodyOfWhile(isSgWhileStmt(n));
            break;
          }
          case V_SgDoWhileStmt: {
            ensureBasicBlockAsBodyOfDoWhile(isSgDoWhileStmt(n));
            break;
          }
          case V_SgIfStmt: {
            ensureBasicBlockAsTrueBodyOfIf(isSgIfStmt(n));
            ensureBasicBlockAsFalseBodyOfIf(isSgIfStmt(n));
            break;
          }
          case V_SgCatchOptionStmt: {
            ensureBasicBlockAsBodyOfCatch(isSgCatchOptionStmt(n));
            break;
          }
          default: break;
        }
      }
    };
    Visitor().traverse(top, postorder);
  }


// Replace a given expression with a list of statements produced by a
// generator.  The generator, when given a variable as input, must produce
// some code which leaves its result in the given variable.  The output
// from the generator is then inserted into the original program in such a
// way that whenever the expression had previously been evaluated, the
// statements produced by the generator are run instead and their result is
// used in place of the expression.
// Assumptions: not currently traversing from or the statement it is in
void
SageInterface::replaceExpressionWithStatement(SgExpression* from, StatementGenerator* to)
   {
  // DQ (3/11/2006): The problem here is that the test expression for a "for loop" (SgForStmt)
  // is assumed to be a SgExpression.  This was changed in Sage III as part of a bugfix and so
  // the original assumptions upon which this function was based are not incorrect, hence the bug!
  // Note that a number of cases were changed when this fix was made to SageIII (see documentation
  // for SgScopeStatement).

     SgStatement*           enclosingStatement      = getStatementOfExpression(from);
     SgExprStatement*       exprStatement           = isSgExprStatement(enclosingStatement);

     SgForStatement*        forStatement            = isSgForStatement(enclosingStatement);
     SgReturnStmt*          returnStatement         = isSgReturnStmt(enclosingStatement);
     SgVariableDeclaration* varDeclarationStatement = isSgVariableDeclaration(enclosingStatement);


  // DQ (3/11/2006): Bugfix for special cases of conditional that are either SgStatement or SgExpression IR nodes.

     ROSE_ASSERT (exprStatement || forStatement || returnStatement || varDeclarationStatement);

     if (varDeclarationStatement)
        {
          replaceSubexpressionWithStatement(from, to);
        }
       else
        {
          SgExpression* root = getRootOfExpression(from);
          ROSE_ASSERT (root);
       // printf ("root = %p \n",root);
             {
               if (forStatement && forStatement->get_increment() == root)
                  {
                 // printf ("Convert step of for statement \n");
                 // Convert step of for statement
                 // for (init; test; e) body; (where e contains from) becomes
                 // for (init; test; ) {
                 //   body (with "continue" changed to "goto label");
                 //   label: e;
                 // }
                 // std::cout << "Converting for step" << std::endl;
                    SgExprStatement* incrStmt = SageBuilder::buildExprStatement(forStatement->get_increment());
                    forStatement->get_increment()->set_parent(incrStmt);

                    SageInterface::addStepToLoopBody(forStatement, incrStmt);
		    SgNullExpression* ne = buildNullExpression();
                    forStatement->set_increment(ne);
                    ne->set_parent(forStatement);
                    replaceSubexpressionWithStatement(from, to);
                  }
                 else
                  {
                    SgStatement* enclosingStmtParent = isSgStatement(enclosingStatement->get_parent());
                    assert (enclosingStmtParent);
                    SgWhileStmt* whileStatement = isSgWhileStmt(enclosingStmtParent);
                    SgDoWhileStmt* doWhileStatement = isSgDoWhileStmt(enclosingStmtParent);
                    SgIfStmt* ifStatement = isSgIfStmt(enclosingStmtParent);
                    SgSwitchStatement* switchStatement = isSgSwitchStatement(enclosingStmtParent);
                    SgForStatement* enclosingForStatement = isSgForStatement(enclosingStmtParent);
                  if (enclosingForStatement && enclosingForStatement->get_test() == exprStatement)
                     {
                    // printf ("Found the test in the for loop \n");
                    // ROSE_ASSERT(false);

                    // Convert test of for statement:
                    // for (init; e; step) body; (where e contains from) becomes
                    // for (init; true; step) {
                    //   bool temp;
                    //   temp = e;
                    //   if (!temp) break;
                    //   body;
                    // }
                    // in which "temp = e;" is rewritten further
                    // std::cout << "Converting for test" << std::endl;
                       pushTestIntoBody(enclosingForStatement);
                       replaceSubexpressionWithStatement(from, to);
                     }
                  else if (whileStatement && whileStatement->get_condition() == exprStatement)
                     {
                    // printf ("Convert while statements \n");
                    // Convert while statement:
                    // while (e) body; (where e contains from) becomes
                    // while (true) {
                    //   bool temp;
                    //   temp = e;
                    //   if (!temp) break;
                    //   body;
                    // }
                    // in which "temp = e;" is rewritten further
                    // std::cout << "Converting while test" << std::endl;
                       pushTestIntoBody(whileStatement);
                    // FixSgTree(whileStatement);
                       replaceSubexpressionWithStatement(from, to);
                     }
                  else if (doWhileStatement && doWhileStatement->get_condition() == exprStatement)
                    {
         // printf ("Convert do-while statements \n");
                   // Convert do-while statement:
                   // do body; while (e); (where e contains from) becomes
                   // {bool temp = true;
                   //  do {
                   //    body (with "continue" changed to "goto label";
                   //    label:
                   //    temp = e;} while (temp);}
                   // in which "temp = e;" is rewritten further
                   // std::cout << "Converting do-while test" << std::endl;
                      SgBasicBlock* new_statement = SageBuilder::buildBasicBlock();
                   // printf ("Building IR node #14: new SgBasicBlock = %p \n",new_statement);
                      assert (doWhileStatement->get_parent());
                      new_statement->set_parent(doWhileStatement->get_parent());
                      myStatementInsert(doWhileStatement, new_statement, false);
                      SageInterface::myRemoveStatement(doWhileStatement);
                      SgName varname = "rose__temp"; // Does not need to be unique, but must not be used in user code anywhere
                      SgAssignInitializer* assignInitializer = buildAssignInitializer(
                          buildBoolValExp(true));
                      //SageInterface::getBoolType(doWhileStatement));
                      SgVariableDeclaration* new_decl = buildVariableDeclaration(
                        varname, buildBoolType(), assignInitializer, new_statement);

                      SgInitializedName* initname = new_decl->get_variables().back();
                      initname->set_scope(new_statement);

         // DQ (12/14/2006): set the parent of the SgAssignInitializer to the variable (SgInitializedName).
            assignInitializer->set_parent(initname);

                      SgVariableSymbol* varsym = new SgVariableSymbol(initname);
                      new_statement->insert_symbol(varname, varsym);
                      varsym->set_parent(new_statement->get_symbol_table());
                      SageInterface::appendStatement(new_decl, new_statement);
                      SageInterface::appendStatement(doWhileStatement, new_statement);
                      assert (varsym);
                      SgCastExp* castExp1 = buildCastExp(root,buildBoolType());
		      SgVarRefExp* vr = buildVarRefExp(varsym);
                      vr->set_lvalue(true);

                      SgExprStatement* temp_setup = SageBuilder::buildAssignStatement(vr, castExp1);

                      SageInterface::addStepToLoopBody(doWhileStatement, temp_setup);
                      SgVarRefExp* varsymVr = buildVarRefExp(varsym);

                      SgExprStatement* condStmt = SageBuilder::buildExprStatement(varsymVr);
                      varsymVr->set_parent(condStmt);
                      doWhileStatement->set_condition(condStmt);
                      condStmt->set_parent(doWhileStatement);
                      replaceSubexpressionWithStatement(from, to);
                    }
                  else if (ifStatement && ifStatement->get_conditional() == exprStatement)
                    {
                      SgBasicBlock* new_statement = SageBuilder::buildBasicBlock();
                   // printf ("Building IR node #15: new SgBasicBlock = %p \n",new_statement);
                      assert (ifStatement->get_parent());
                      new_statement->set_parent(ifStatement->get_parent());
                      myStatementInsert(ifStatement, new_statement, false);
                      SageInterface::myRemoveStatement(ifStatement);
                      SgName varname = "rose__temp"; // Does not need to be unique, but must not be used in user code anywhere
                      SgBoolValExp* trueVal = buildBoolValExp(true);

                      SgAssignInitializer* ai = buildAssignInitializer(trueVal);

                      SgVariableDeclaration* new_decl = buildVariableDeclaration(varname,
                         buildBoolType(), ai,new_statement);
                      SgInitializedName* initname = new_decl->get_variables().back();
                      ai->set_parent(initname);
                      initname->set_scope(new_statement);
                      SgVariableSymbol* varsym = new SgVariableSymbol(initname);
                      new_statement->insert_symbol(varname, varsym);
                      varsym->set_parent(new_statement->get_symbol_table());
                      SageInterface::appendStatement(new_decl, new_statement);
                      ifStatement->set_parent(new_statement);
                      assert (varsym);

                                        SgCastExp* castExp2 = SageBuilder::buildCastExp(root, SageInterface::getBoolType(ifStatement));
		      SgVarRefExp* vr = buildVarRefExp(varsym);
                      vr->set_lvalue(true);
                      SgExprStatement* temp_setup = SageBuilder::buildAssignStatement(vr, castExp2 );
                      SageInterface::appendStatement(temp_setup, new_statement);
                      SageInterface::appendStatement(ifStatement, new_statement);
                      SgVarRefExp* vr2 = SageBuilder::buildVarRefExp(varsym);
                      SgExprStatement* es = SageBuilder::buildExprStatement(vr2);
                      ifStatement->set_conditional(es);
                      es->set_parent(ifStatement);
                      replaceSubexpressionWithStatement(from, to);
                    }
                  else if (switchStatement && switchStatement->get_item_selector() == exprStatement)
                    {
                      SgExpression* switchCond = exprStatement->get_expression();
                      ROSE_ASSERT (switchCond);
                      SgBasicBlock* new_statement = SageBuilder::buildBasicBlock();
                   // printf ("Building IR node #15: new SgBasicBlock = %p \n",new_statement);
                      assert (switchStatement->get_parent());
                      new_statement->set_parent(switchStatement->get_parent());
                      myStatementInsert(switchStatement, new_statement, false);
                      SageInterface::myRemoveStatement(switchStatement);
                      SgName varname = "rose__temp"; // Does not need to be unique, but must not be used in user code anywhere
                      switchCond->set_parent(NULL);
                      SgVariableDeclaration* new_decl = SageBuilder::buildVariableDeclaration(varname, switchCond->get_type(), SageBuilder::buildAssignInitializer(switchCond), new_statement);
                      SgVariableSymbol* varsym = SageInterface::getFirstVarSym(new_decl);
                      SageInterface::appendStatement(new_decl, new_statement);
                      switchStatement->set_parent(new_statement);
                      assert (varsym);


                      SageInterface::appendStatement(switchStatement, new_statement);
                      SgVarRefExp* vr2 = SageBuilder::buildVarRefExp(varsym);
                      SgExprStatement* es = SageBuilder::buildExprStatement(vr2);
                      switchStatement->set_item_selector(es);
                      es->set_parent(switchStatement);
                      replaceSubexpressionWithStatement(from, to);
                    }
                  else
                    {
                      // printf ("Handles expression and return statements \n");
                      // Handles expression and return statements
                      // std::cout << "Converting other statement" << std::endl;
                      replaceSubexpressionWithStatement(from, to);
                    }
                  }
             }
        }

  // printf ("Leaving replaceExpressionWithStatement(from,to) \n");
   }

//! Replace a given expression with a list of statements produced by a
//! generator.  The generator, when given a variable as input, must produce
//! some code which leaves its result in the given variable.  The output
//! from the generator is then inserted into the original program in such a
//! way that whenever the expression had previously been evaluated, the
//! statements produced by the generator are run instead and their result is
//! used in place of the expression.
//! Assumptions: not currently traversing from or the statement it is in

// Similar to replaceExpressionWithStatement, but with more restrictions.
// Assumptions: from is not within the test of a loop or if
//              not currently traversing from or the statement it is in
void SageInterface::replaceSubexpressionWithStatement(SgExpression* from, StatementGenerator* to)
   {

     SgStatement* stmt = getStatementOfExpression(from);


     if (isSgExprStatement(stmt))
        {
          SgExpression* top = getRootOfExpression(from);


          if (top == from)
             {
               SgStatement* generated = to->generate(0);
               isSgStatement(stmt->get_parent())->replace_statement(stmt, generated);
               generated->set_parent(stmt->get_parent());
               return;
             }
            else
             {
               if (isSgAssignOp(top) && isSgAssignOp(top)->get_rhs_operand() == from)
                  {
                    SgAssignOp* t = isSgAssignOp(top);
                    SgStatement* generated = to->generate(t->get_lhs_operand());
                    isSgStatement(stmt->get_parent())->replace_statement(stmt, generated);
                    generated->set_parent(stmt->get_parent());
                    return;
                  }
                 else
                  {
                 // printf ("In replaceSubexpressionWithStatement(): Statement not generated \n");
                  }
             }
        }

  // cout << "1: " << getStatementOfExpression(from)->unparseToString() << endl;
     SgAssignInitializer* init = splitExpression(from);
  // cout << "2: " << getStatementOfExpression(from)->unparseToString() << endl;
     convertInitializerIntoAssignment(init);
  // cout << "3: " << getStatementOfExpression(from)->unparseToString() << endl;
  // cout << "3a: " << getStatementOfExpression(from)->get_parent()->unparseToString() << endl;
     SgExprStatement* new_stmt = isSgExprStatement(getStatementOfExpression(from));
     assert (new_stmt != NULL); // Should now have this form because of conversion
     replaceAssignmentStmtWithStatement(new_stmt, to);

  // printf ("In replaceSubexpressionWithStatement: new_stmt = %p = %s \n",new_stmt,new_stmt->class_name().c_str());
  // cout << "4: " << getStatementOfExpression(from)->get_parent()->unparseToString() << endl;
   }


  // Liao, 6/27/2008
  //Tasks
  //  find all return statements
  //  rewrite it to  temp = expression; return temp; if expression is not a single value.
  //  insert s right before 'return xxx;'
  int SageInterface::instrumentEndOfFunction(SgFunctionDeclaration * func, SgStatement* s)
  {
    int result = 0;
    ROSE_ASSERT(func&&s);
  //  vector<SgReturnStmt* > stmts = findReturnStmts(func);
    Rose_STL_Container <SgNode* > stmts = NodeQuery::querySubTree(func, V_SgReturnStmt);
    //vector<SgReturnStmt*>::iterator i;
    Rose_STL_Container<SgNode*>::iterator i;
    for (i=stmts.begin();i!=stmts.end();i++)
    {
      SgReturnStmt* cur_stmt = isSgReturnStmt(*i);
      ROSE_ASSERT(cur_stmt);
      SgExpression * exp = cur_stmt->get_expression();
      bool needRewrite = !(isSgValueExp(exp));
      if (needRewrite)
      {
        splitExpression(exp);
      }
       // avoid reusing the statement
      if (result>=1 )
         s = copyStatement(s);
       insertStatementBefore(cur_stmt,s);
      result ++;
    } // for
    if (stmts.size()==0 ) // a function without any return at all,
    {
      SgBasicBlock * body = func->get_definition()->get_body();
      if (body== NULL)
       {
         cout<<"In instrumentEndOfFunction(), found an empty function body.! "<<endl;
         ROSE_ASSERT(false);
       }
      appendStatement(s,body);
      result ++;
    }
    return result;
  } // instrumentEndOfFunction

  bool SageInterface::isStatic(SgDeclarationStatement* stmt)
  {
    ROSE_ASSERT(stmt);
    return ((stmt->get_declarationModifier()).get_storageModifier()).isStatic();
  } // isStatic()

  //! Set a declaration as static
  void SageInterface::setStatic(SgDeclarationStatement* stmt)
  {
    ROSE_ASSERT(stmt);
    return ((stmt->get_declarationModifier()).get_storageModifier()).setStatic();
  }

  bool SageInterface::isExtern(SgDeclarationStatement* stmt)
  {
    ROSE_ASSERT(stmt);
    return ((stmt->get_declarationModifier()).get_storageModifier()).isExtern();
  } // isExtern()


  //! Set a declaration as extern
  void SageInterface::setExtern(SgDeclarationStatement* stmt)
  {
    ROSE_ASSERT(stmt);
    return ((stmt->get_declarationModifier()).get_storageModifier()).setExtern();
  }


  unsigned long long SageInterface::getIntegerConstantValue(SgValueExp* expr) {
    switch (expr->variantT()) {
      case V_SgCharVal: return (long long)(isSgCharVal(expr)->get_value());
      case V_SgUnsignedCharVal: return isSgUnsignedCharVal(expr)->get_value();
      case V_SgShortVal: return (long long)(isSgShortVal(expr)->get_value());
      case V_SgUnsignedShortVal: return isSgUnsignedShortVal(expr)->get_value();
      case V_SgIntVal: return (long long)(isSgIntVal(expr)->get_value());
      case V_SgUnsignedIntVal: return isSgUnsignedIntVal(expr)->get_value();
      case V_SgLongIntVal: return (long long)(isSgLongIntVal(expr)->get_value());
      case V_SgUnsignedLongVal: return isSgUnsignedLongVal(expr)->get_value();
      case V_SgLongLongIntVal: return isSgLongLongIntVal(expr)->get_value();
      case V_SgUnsignedLongLongIntVal: return isSgUnsignedLongLongIntVal(expr)->get_value();
      default: ROSE_ASSERT (!"Bad kind in getIntegerConstantValue");
    }

    ROSE_ASSERT (!"Bad kind return in getIntegerConstantValue");
	return 0;
  }


// tps : 28 Oct 2008 - support for finding the main interpretation
// rpm : 18 Sep 2009 - rewritten to support multiple files per interpretation
/** Returns the "main" interpretation. "Main" is defined as the first interpretation that points to a header of the supplied
 *  file. If the supplied file has more than one header then the interpretation must point to this file's PE header. */
SgAsmInterpretation *
SageInterface::getMainInterpretation(SgAsmGenericFile *file)
{
    SgBinaryComposite *binary = isSgBinaryComposite(file->get_parent());
    ROSE_ASSERT(binary!=NULL);

    /* Find the only header or the PE header of this file */
    SgAsmGenericHeader *requisite_header = NULL; /*the returned interpretation must point to this header*/
    const SgAsmGenericHeaderPtrList &headers = file->get_headers()->get_headers();
    if (1==headers.size()) {
        requisite_header = headers[0];
    } else {
        for (SgAsmGenericHeaderPtrList::const_iterator hi=headers.begin(); hi!=headers.end(); ++hi) {
            if (isSgAsmPEFileHeader(*hi)) {
                requisite_header = isSgAsmPEFileHeader(*hi);
                break;
            }
        }
    }
    ROSE_ASSERT(requisite_header!=NULL);

    /* Find an interpretation that points to this header */
    const SgAsmInterpretationPtrList &interps = binary->get_interpretations()->get_interpretations();
    for (SgAsmInterpretationPtrList::const_iterator ii=interps.begin(); ii!=interps.end(); ++ii) {
        const SgAsmGenericHeaderPtrList &headers = (*ii)->get_headers()->get_headers();
        for (SgAsmGenericHeaderPtrList::const_iterator hi=headers.begin(); hi!=headers.end(); ++hi) {
            if ((*hi)==requisite_header)
                return *ii;
        }
    }

    ROSE_ASSERT(!"no appropriate interpretation");
    return NULL;
}

class CollectDependentDeclarationsCopyType : public SgCopyHelp
   {
     public:
       // This is the simpliest possible version of a deep copy SgCopyHelp::copyAst() member function.
       // Note that the root of the does not have its file info set like its children.
          virtual SgNode *copyAst(const SgNode *n)
             {
#if 1
            // DQ (2/26/2009): This defines a simple concept of "deep" copy. It forms a more testable building block, I hope.
               SgNode* copy = n->copy(*this);
#else
            // DQ (2/26/2009): I am giving up for now on this more elegant approach, in favor of something I can tests and debug!
            // This defines a more complex concept of mostly "deep" copy, except for defining function declarations
            // which are converted to non-defining declarations.  However, this level of complexity is difficult to
            // support and debug, so we are switching to a simpler approach of just using the "deep" copy as a building
            // block and then using a second pass to transformat defining declarations to be non-defining declarations
            // were required.  This should be easier to test and debug, I hope.
               SgNode* copy = NULL;
               const SgFunctionDeclaration* functionDeclaration = isSgFunctionDeclaration(n);

            // For function declarations we don't want to do deep copies on defining declarations
            // since that would violate the One-time Definition Rule (ODR).
            // Note that this is only important for nested function in a declaration being copied,
            // since the SgCopyHelp class is not used at the top level of the AST copy mechanism.
               if (functionDeclaration != NULL)
                  {
                    printf ("In CollectDependentDeclarationsCopyType: functionDeclaration = %p = %s = %s \n",functionDeclaration,functionDeclaration->class_name().c_str(),SageInterface::get_name(functionDeclaration).c_str());
                    printf ("In CollectDependentDeclarationsCopyType: Copy mechanism appied to SgFunctionDeclaration functionDeclaration->get_firstNondefiningDeclaration() = %p \n",functionDeclaration->get_firstNondefiningDeclaration());
                    if (functionDeclaration->get_firstNondefiningDeclaration() != NULL)
                       {
                         printf ("Exiting before gettint here \n");
                         ROSE_ASSERT(false);

                      // Make a copy
                         copy = functionDeclaration->get_firstNondefiningDeclaration()->copy(*this);
                       }
                      else
                       {
                      // Build a function prototype, but what scope should be used?
                         ROSE_ASSERT(functionDeclaration->get_scope() != NULL);
                         const SgMemberFunctionDeclaration* memberFunctionDeclaration = isSgMemberFunctionDeclaration(functionDeclaration);
                         if (memberFunctionDeclaration != NULL)
                            {
                              copy = SageBuilder::buildNondefiningMemberFunctionDeclaration(memberFunctionDeclaration,memberFunctionDeclaration->get_scope());
                            }
                           else
                            {
                              copy = SageBuilder::buildNondefiningFunctionDeclaration(functionDeclaration,functionDeclaration->get_scope());
                            }

                         SgFunctionDeclaration* copy_functionDeclaration = isSgFunctionDeclaration(copy);

                      // In the case of a member function in a class there in no non-defining declaration (see moreTest4.cpp).
                      // non-member function can also sometimes not have a non-defining declaration.
                         if (functionDeclaration->get_firstNondefiningDeclaration() != NULL)
                            {
                              ROSE_ASSERT(TransformationSupport::getSourceFile(functionDeclaration) == TransformationSupport::getSourceFile(functionDeclaration->get_firstNondefiningDeclaration()));
                              ROSE_ASSERT(TransformationSupport::getSourceFile(functionDeclaration->get_scope()) == TransformationSupport::getSourceFile(functionDeclaration->get_firstNondefiningDeclaration()));
                            }

                         ROSE_ASSERT(copy_functionDeclaration != NULL);
                         ROSE_ASSERT(copy_functionDeclaration->get_firstNondefiningDeclaration() != NULL);
                         ROSE_ASSERT(TransformationSupport::getSourceFile(copy_functionDeclaration) == TransformationSupport::getSourceFile(copy_functionDeclaration->get_firstNondefiningDeclaration()));
                         ROSE_ASSERT(TransformationSupport::getSourceFile(copy_functionDeclaration->get_scope()) == TransformationSupport::getSourceFile(copy_functionDeclaration->get_firstNondefiningDeclaration()));
                       }
#if 0
                    printf ("DONE: Copy mechanism appied to SgFunctionDeclaration \n");
                    ROSE_ASSERT(false);
#endif
                  }
                 else
                  {
                    copy = n->copy(*this);
                  }
#endif

            // Also mark this as a transformation and to be output in unparsing (so it will be output by the code generator).
               Sg_File_Info* fileInfo = copy->get_file_info();
               if (fileInfo != NULL)
                  {
                 // Must make this for output (checked in unparser), marking as a transformation is not checked
                    fileInfo->setOutputInCodeGeneration();
                    fileInfo->setTransformation();
                  }

               return copy;
             }

   } collectDependentDeclarationsCopyType;


class CollectCppDirectivesTraversal : public SgSimpleProcessing
   {
  // This traversal collects the includes at the top of a file.

     public:
          vector<PreprocessingInfo*> cppDirectiveList;

          void visit(SgNode *astNode);
   };


void
CollectCppDirectivesTraversal::visit(SgNode *astNode)
   {
     SgLocatedNode* locatedNode = isSgLocatedNode(astNode);
     if (locatedNode != NULL)
        {
          AttachedPreprocessingInfoType* comments = locatedNode->getAttachedPreprocessingInfo();

          if (comments != NULL)
             {
#if 0
               printf ("Found attached comments (at %p of type: %s): \n",locatedNode,locatedNode->sage_class_name());
#endif
               AttachedPreprocessingInfoType::iterator i;
               for (i = comments->begin(); i != comments->end(); i++)
                  {
                    ROSE_ASSERT ( (*i) != NULL );
#if 0
                    printf ("          Attached Comment (relativePosition=%s): %s\n",
                         ((*i)->getRelativePosition() == PreprocessingInfo::before) ? "before" : "after",
                         (*i)->getString().c_str());
                    printf ("Comment/Directive getNumberOfLines = %d getColumnNumberOfEndOfString = %d \n",(*i)->getNumberOfLines(),(*i)->getColumnNumberOfEndOfString());
                    (*i)->get_file_info()->display("comment/directive location");
#endif

                 // We only save the #include directives, but likely we should be collecting ALL directives to
                 // avoid the collection of #include that is meant to be hidden in an #if 0 ... #endif pairing.
                 // if ((*i)->getTypeOfDirective() == PreprocessingInfo::CpreprocessorIncludeDeclaration)
                       {
                      // This is an include directive.
                         cppDirectiveList.push_back(*i);
#if 0
                         printf ("          Attached include directive (relativePosition=%s): %s\n",
                              ((*i)->getRelativePosition() == PreprocessingInfo::before) ? "before" : "after",
                              (*i)->getString().c_str());
#endif
                       }
                  }
             }
            else
             {
#if 0
               printf ("No attached comments (at %p of type: %s): \n",locatedNode,locatedNode->sage_class_name());
#endif
             }
        }
   }


// This is part of a mechanism to collect directives from code that is to be outlined.
// However if we collect include directives we likely should really be collecting ALL
// directives (since the #include could be inside of an #if 0 ... #endif pairing.
// This level of detail will be addressed later (in an iterative approach).
vector<PreprocessingInfo*>
collectCppDirectives ( SgSourceFile* file )
   {
  // This function is used to collect include directives from the whole file.
     CollectCppDirectivesTraversal t;
     t.traverse(file,preorder);

     return t.cppDirectiveList;
   }


vector<PreprocessingInfo*>
collectCppDirectives ( SgLocatedNode* n )
   {
  // This function is used to collect include directives from specific dependent declarations.
     CollectCppDirectivesTraversal t;
     t.traverse(n,preorder);

     return t.cppDirectiveList;
   }

// Debugging support.
void
outputPreprocessingInfoList ( const vector<PreprocessingInfo*> & l )
   {
  // This function support debugging the generated directive lists.

     vector<PreprocessingInfo*>::const_iterator i = l.begin();
     while ( i != l.end() )
        {
          printf ("          Attached include directive (relativePosition=%s): %s\n",
             ((*i)->getRelativePosition() == PreprocessingInfo::before) ? "before" : "after",
             (*i)->getString().c_str());
          i++;
        }
   }



SgDeclarationStatement*
getAssociatedDeclaration( SgScopeStatement* scope )
   {
  //TODO This should become a member of SgScopeStatement

     SgDeclarationStatement* declaration = NULL;
     switch(scope->variantT())
        {
          case V_SgNamespaceDefinitionStatement:
             {
               SgNamespaceDefinitionStatement* namespaceDefinition = isSgNamespaceDefinitionStatement(scope);
               declaration = namespaceDefinition->get_namespaceDeclaration();
               break;
             }

          case V_SgClassDefinition:
          case V_SgTemplateInstantiationDefn: // Liao, 5/12/2009
             {
               SgClassDefinition* classDefinition = isSgClassDefinition(scope);
               declaration = classDefinition->get_declaration();
               break;
             }

          default:
             {
               printf ("Error: default reached in getAssociatedDeclaration(): scope = %p = %s \n",scope,scope->class_name().c_str());
               ROSE_ASSERT(false);
             }
        }

  // There may be some scopes that don't have an associated declaration.
     ROSE_ASSERT(declaration != NULL);

     return declaration;
   }


class CollectDependentDeclarationsTraversal : public SgSimpleProcessing
   {
     public:
       // Accumulate a list of copies of associated declarations referenced in the AST subtree
       // (usually of the outlined functions) to insert in the separate file to support outlining.
          vector<SgDeclarationStatement*> declarationList;

       // Save the list of associated symbols of dependent declarations identified so that we can
       // support their replacement in the new AST.
          vector<SgSymbol*> symbolList;

       // Keep track of declarations already copied so that we don't copy them more than once and try to insert them.
          set<SgDeclarationStatement*> alreadySavedDeclarations;

       // Required visit function for the AST traversal
          void visit(SgNode *astNode);
     private:
       void addDeclaration(SgDeclarationStatement* decl);
   };

SgDeclarationStatement*
getGlobalScopeDeclaration( SgDeclarationStatement* inputDeclaration )
   {
  // DQ (2/16/2009): Basically if a class is used from a namespace (or any outer scope) and we
  // outline the reference to the class, we have to declare not the class but the outer scope
  // (which will have the class included).

     SgDeclarationStatement* returnDeclaration = inputDeclaration;

  // I think that we have to copy the outer scope if the declaration's scope is not SgGlobal.
     SgScopeStatement* scope = inputDeclaration->get_scope();
     ROSE_ASSERT(scope != NULL);

  // printf ("inputDeclaration->get_scope() = %p = %s \n",scope,scope->class_name().c_str());

  // If the input declaration is not in global scope then find the parent declaration that is in global scope!
     SgGlobal* globalScope = isSgGlobal(scope);
     if (globalScope == NULL)
        {
       // Traverse back to the global scope to include outer declarations which contain the "declaration"
       // printf ("Traverse back to the global scope to include outer declarations \n");

          SgScopeStatement* parentScope = scope;
          SgDeclarationStatement* associatedDeclaration = returnDeclaration;
          ROSE_ASSERT(parentScope != NULL);
          while (globalScope == NULL)
             {
               associatedDeclaration = getAssociatedDeclaration(parentScope);
               ROSE_ASSERT(associatedDeclaration != NULL);

               parentScope = parentScope->get_scope();
               globalScope = isSgGlobal(parentScope);
             }

          returnDeclaration = associatedDeclaration;
        }

     return returnDeclaration;
   }


// Debugging support.
void
outputDeclarationList ( const vector<SgDeclarationStatement*> & l )
   {
  // This function support debugging the generated declarations.

     int counter = 0;
     vector<SgDeclarationStatement*>::const_iterator i = l.begin();
     while ( i != l.end() )
        {
          printf ("In outputDeclarationList(): list[%d] = %p = %s = %s \n",counter++,*i,(*i)->class_name().c_str(),SageInterface::get_name(*i).c_str());
          i++;
        }
   }

void CollectDependentDeclarationsTraversal::addDeclaration(SgDeclarationStatement* declaration)
{
  // If there was a declaration found then handle it.
     if (declaration != NULL)
        {
       // Reset the defining declaration in case there is an outer declaration that is more important
       // to consider the dependent declaration (e.g. a class in a namespace).  In general this will
       // find the associated outer declaration in the global scope.
          SgDeclarationStatement* dependentDeclaration = getGlobalScopeDeclaration(declaration);

       // This declaration is in global scope so we just copy the declaration
       // For namespace declarations: they may have the save name but they have to be saved separated.
          if (alreadySavedDeclarations.find(dependentDeclaration) == alreadySavedDeclarations.end())
             {
#if 0
               printf ("In CollectDependentDeclarationsTraversal::visit(): selected dependentDeclaration = %p = %s = %s \n",
                    dependentDeclaration,dependentDeclaration->class_name().c_str(),SageInterface::get_name(dependentDeclaration).c_str());
#endif
            // DQ (2/22/2009): Semantics change for this function, just save the original declaration, not a copy of it.
               declarationList.push_back(dependentDeclaration);

            // Record this as a copied declaration
               alreadySavedDeclarations.insert(dependentDeclaration);
#if 0
               printf ("In CollectDependentDeclarationsTraversal::visit(): astNode = %p = %s = %s \n",astNode,astNode->class_name().c_str(),SageInterface::get_name(astNode).c_str());
               printf ("############### ADDING dependentDeclaration = %p = %s to alreadySavedDeclarations set (size = %zu) \n",
                    dependentDeclaration,dependentDeclaration->class_name().c_str(),alreadySavedDeclarations.size());
#endif
            // DQ (2/21/2009): Added assertions (will be inforced in SageInterface::appendStatementWithDependentDeclaration()).
            // ROSE_ASSERT(copy_definingDeclaration->get_firstNondefiningDeclaration() != NULL);
             }
            else
             {
#if 0
               printf ("In CollectDependentDeclarationsTraversal::visit(): astNode = %p = %s = %s \n",astNode,astNode->class_name().c_str(),SageInterface::get_name(astNode).c_str());
               printf ("############### EXISTING dependentDeclaration = %p = %s found in alreadySavedDeclarations set (size = %zu) \n",
                    dependentDeclaration,dependentDeclaration->class_name().c_str(),alreadySavedDeclarations.size());
#endif
             }
        }
}

//! Collect all typedef declarations used by an input type and its base types
static std::vector<SgTypedefDeclaration*> collectTypedefDeclarations(SgType* type)
{
  ROSE_ASSERT(type != NULL);
  std::vector<SgTypedefDeclaration*> result;
  SgType* currentType = type;

  SgModifierType*  modType     = NULL;
  SgPointerType*   pointType   = NULL;
  SgReferenceType* refType     = NULL;
  SgArrayType*     arrayType   = NULL;
  SgTypedefType*   typedefType = NULL;

  while (true)
  {
    modType = isSgModifierType(currentType);
    if(modType)
    {
      currentType = modType->get_base_type();
    }
    else
    {
      refType = isSgReferenceType(currentType);
      if(refType)
      {
        currentType = refType->get_base_type();
      }
      else
      {
         pointType = isSgPointerType(currentType);
        if ( pointType)
        {
          currentType = pointType->get_base_type();
        }
        else
        {
          arrayType = isSgArrayType(currentType);
          if  (arrayType)
          {
            currentType = arrayType->get_base_type();
          }
          else
          {
            typedefType = isSgTypedefType(currentType);
            if (typedefType)
            {
              currentType = typedefType->get_base_type();
              SgTypedefDeclaration* tdecl = isSgTypedefDeclaration(typedefType->get_declaration());
              // have to try to get the defining declaration for a defining typedef declaration
              // otherwise AST traversal will not visit the non-defining one for a defining typedef declaration
              // sortSgNodeListBasedOnAppearanceOrderInSource() won't work properly
              SgTypedefDeclaration* decl = isSgTypedefDeclaration(tdecl->get_definingDeclaration());
              if (decl ==NULL)
                decl = tdecl;
              result.push_back(decl);
            }
            else
            {
              // Exit the while(true){} loop!
              break;
            }
          }
        }
      }
    }
  }
#if 0
  // debug here
  if (result.size()>0)
  {
    cout<<"------------Found a chain of typedef decls: count="<<result.size()<<endl;
    for (vector <SgTypedefDeclaration*>::const_iterator iter = result.begin();
          iter!=result.end(); iter ++)
      cout<<(*iter)->unparseToString()<<endl;
  }
#endif
  return result;
}

//! visitor function for each node to collect non-builtin types' declarations
void
CollectDependentDeclarationsTraversal::visit(SgNode *astNode)
   {
  // Statements that can cause us to have declaration dependences:
  //    1) variable declarations (through their types)
  //    2) function calls
  //    3) typedefs (through their base types)
  //    4) static member functions (through their class)
  //    5) static data members (through their class)
  //    6) namespaces
  //    7) #include<> CPP directives.

  // DQ (2/22/2009): Changing the semantics for this function,
  // just save the original declaration, not a copy of it.

#if 0
  // Debugging support.
     Sg_File_Info* fileInfo = astNode->get_file_info();
     if (fileInfo != NULL && fileInfo->isFrontendSpecific() == false && (isSgStatement(astNode) != NULL) )
        {
          printf ("\n\nIn CollectDependentDeclarationsTraversal::visit(): astNode = %p = %s = %s \n",astNode,astNode->class_name().c_str(),SageInterface::get_name(astNode).c_str());
       // fileInfo->display("In CollectDependentDeclarationsTraversal::visit()");
          int counter = 0;
          printf ("alreadySavedDeclarations.size() = %zu \n",alreadySavedDeclarations.size());
          for (set<SgDeclarationStatement*>::iterator i = alreadySavedDeclarations.begin(); i != alreadySavedDeclarations.end(); i++)
             {
               printf ("alreadySavedDeclarations %d: %p = %s \n",counter++,*i,(*i)->class_name().c_str());
             }
        }
#endif

  // The following conditionals set this variable
     SgDeclarationStatement* declaration = NULL;

  // 1) ------------------------------------------------------------------
  // Collect the declarations associated with referenced types in variable declarations (or any types associated with SgInitializedName IR nodes)
     SgInitializedName* initializedname = isSgInitializedName(astNode);
     if (initializedname != NULL)
     {
       SgType* type = initializedname->get_type();

       // handle all dependent typedef declarations, if any
       std::vector <SgTypedefDeclaration*> typedefVec = collectTypedefDeclarations(type);
        for (std::vector <SgTypedefDeclaration*>::const_iterator iter =typedefVec.begin();
                iter != typedefVec.end(); iter++)
       {
         SgTypedefDeclaration* typedef_decl = *iter;
         addDeclaration(typedef_decl);
         symbolList.push_back(typedef_decl->get_symbol_from_symbol_table());
       }

      // handle base type:
       SgType* strippedType = type;
       // We now can to strip typedefs since they are already handled by collectTypedefDeclarations()
       // this also reach to the defining body of a defining typedef declaration
       // and treat it as an independent declarations,
       // the assumption here is that a defining typedef declaration will only has its
       // nondefining declaration copied to avoid redefining of the struct.
       // This is also a workaround for an AST copy bug: defining body gets lost after copying
       // a defining typedef declaration.
       // Liao, 5/8/2009
       //
       // e.g. typedef struct hypre_BoxArray_struct
       // {
       //          int alloc_size;
       // } hypre_BoxArray;
       //
       // struct hypre_BoxArray_struct will be treated as a strippedType and its declaration
       // will be inserted.
       //
       strippedType = type->stripType();
       SgNamedType* namedType = isSgNamedType(strippedType);
       if (namedType != NULL)
       {
         // Note that since this was obtained via the types and types are shared, this is the non-defining
         // declaration in original program (not the separate file is this is to support outlining into a
         // separate file.
         SgDeclarationStatement* named_decl = namedType->get_declaration();
         // the case of class declaration, including struct, union
         SgClassDeclaration* classDeclaration = isSgClassDeclaration(named_decl);
         if (classDeclaration != NULL)
         {
           // printf ("Found class declaration: classDeclaration = %p \n",classDeclaration);
           declaration = classDeclaration->get_definingDeclaration();
           ROSE_ASSERT(declaration != NULL);
           addDeclaration(declaration);

           // Note that since types are shared in the AST, the declaration for a named type may be (is)
           // associated with the class declaration in the original file. However, we want to associated
           // class declaration in the current file, but since the AST copy mechanism work top-down, this
           // mapping form the declaration in the original file to the new declaration in the copied AST
           // is available in the SgCopyHelp map of copied IR nodes.
           // DQ (3/3/2009): Added support for symbol references to be saved (symbols in the original file).
           // these symbols will be mapped to their new symbols.
           ROSE_ASSERT(classDeclaration->hasAssociatedSymbol() == true);
           SgSymbol* classSymbol = classDeclaration->get_symbol_from_symbol_table();
           ROSE_ASSERT(classSymbol != NULL);

           // printf ("Saving classSymbol = %p \n",classSymbol);
           symbolList.push_back(classSymbol);
         }

         // handle Enum types
         SgEnumDeclaration* enum_decl = isSgEnumDeclaration(named_decl);
         if (enum_decl != NULL)
         {
           declaration = enum_decl->get_definingDeclaration();
           ROSE_ASSERT(declaration != NULL);
           addDeclaration(declaration);
           ROSE_ASSERT(enum_decl->hasAssociatedSymbol() == true);
           SgSymbol* esymbol = enum_decl->get_symbol_from_symbol_table();
           ROSE_ASSERT(esymbol!= NULL);
           symbolList.push_back(esymbol);
         }
       } // end if namedType
#if 0
       printf ("Found reference to type = %p = %s strippedType = %p = %s \n",type,type->class_name().c_str(),strippedType,strippedType->class_name().c_str());
#endif
     }// end if (initializedname)

  // 2) ------------------------------------------------------------------
  // Collect declarations associated with function calls.
     SgFunctionCallExp* functionCallExp = isSgFunctionCallExp(astNode);
     if (functionCallExp != NULL)
        {
          declaration = functionCallExp->getAssociatedFunctionDeclaration();
          //ROSE_ASSERT(declaration != NULL);
          // We allow a function pointer to have no specific declaration associated.
          if (declaration != NULL)
            addDeclaration(declaration);

       // DQ (3/2/2009): Added support for symbol references to be saved (this can be a SgFunctionSymbol or a SgMemberFunctionSymbol).
          SgSymbol* functionSymbol = functionCallExp->getAssociatedFunctionSymbol();
          //ROSE_ASSERT(functionSymbol != NULL);

       // printf ("Saving functionSymbol = %p \n",functionSymbol);
          if (functionSymbol)
            symbolList.push_back(functionSymbol);
        }

    // 3) ------------------------------------------------------------------
    // Collect enumerate declarations associated with SgEnumVal
    SgEnumVal * eval = isSgEnumVal(astNode);
    if (eval != NULL)
    {
      declaration = eval->get_declaration();
      ROSE_ASSERT(declaration != NULL);
      addDeclaration(declaration);
      SgSymbol* symbol = declaration->get_firstNondefiningDeclaration()->get_symbol_from_symbol_table();
      ROSE_ASSERT(symbol != NULL);
      symbolList.push_back(symbol);
    }
//       addDeclaration(declaration); // do it in different cases individually
   }

static std::map<const SgStatement*, bool> visitedDeclMap; // avoid infinite recursion


//! Collect dependent type declarations and corresponding symbols used by a declaration statement with defining body.
// Used to separate a function to a new source file and add necessary type declarations into the new file.
// NOTICE: each call to this function has to have call visitedDeclMap.clear() first!!
static void
getDependentDeclarations (SgStatement* stmt, vector<SgDeclarationStatement*> & declarationList, vector<SgSymbol*> & symbolList )
{
  // This function returns a list of the dependent declaration for any input statement.
  // Dependent declaration are functions called, types referenced in variable declarations, etc.
#if 0
  printf ("\n\n********************************************************** \n");
  printf (" Inside of getDependentDeclarations(stmt = %p = %s) \n",stmt,stmt->class_name().c_str());
  printf ("********************************************************** \n");
#endif
 visitedDeclMap[stmt]= true;
  CollectDependentDeclarationsTraversal t;
  t.traverse(stmt,preorder);
#if 0
     declarationList = t.declarationList;
     symbolList      = t.symbolList;
#else
  // Merge to the parent level list
  copy(t.declarationList.begin(),t.declarationList.end(), back_inserter(declarationList));
  copy(t.symbolList.begin(),t.symbolList.end(), back_inserter(symbolList));
    // make their elements unique
  sort (declarationList.begin(), declarationList.end());
  vector<SgDeclarationStatement*>::iterator new_end = unique(declarationList.begin(), declarationList.end());
  declarationList.erase(new_end, declarationList.end());

  sort (symbolList.begin(), symbolList.end());
  vector<SgSymbol*>::iterator end2 = unique(symbolList.begin(), symbolList.end());
  symbolList.erase(end2, symbolList.end());


  // Liao, 5/7/2009 recursively call itself to get dependent declarations' dependent declarations
  for (vector<SgDeclarationStatement*>::const_iterator iter = t.declarationList.begin();
      iter !=t.declarationList.end(); iter++)
  {
    SgDeclarationStatement* decl = *iter;
    SgType* base_type = NULL;
    SgStatement* body_stmt= NULL;

    // grab base type for a declaration
    // For class declaration: grab their
    if (isSgClassDeclaration(decl))
    {
      base_type =  isSgClassDeclaration(decl)->get_type();
    } else
    if (isSgTypedefDeclaration(decl))
    {

      // we don't want to strip of nested typedef declarations
      base_type = isSgTypedefDeclaration(decl)->get_base_type()->stripType(SgType::STRIP_POINTER_TYPE|SgType::STRIP_ARRAY_TYPE|SgType::STRIP_REFERENCE_TYPE|SgType::STRIP_MODIFIER_TYPE);
    }

    //TODO variable declaration, function declaration: parameter list types,
    // multiple base_type then

    // is the base type associated with a defining body?
    // TODO enum type
      if (isSgClassType(base_type))
      {
        SgClassDeclaration* class_decl = isSgClassDeclaration(isSgClassType(base_type)->get_declaration()->get_definingDeclaration());
        if (class_decl!=NULL)
        {
          body_stmt = class_decl->get_definition();
        }
      }
    // recursively collect dependent declarations for the body stmt
    if ((body_stmt!=NULL) &&(!visitedDeclMap[body_stmt]))
      { // avoid infinite recursion
        getDependentDeclarations(body_stmt, declarationList, symbolList);
      }
    }
#endif
} // end void getDependentDeclarations()


// Reorder a list of declaration statements based on their appearance order in source files
// This is essential to insert their copies into a new file in a right order
// Liao, 5/7/2009
vector<SgDeclarationStatement*>
SageInterface::sortSgNodeListBasedOnAppearanceOrderInSource(const vector<SgDeclarationStatement*>& nodevec)
{
  vector<SgDeclarationStatement*> sortedNode;

  if (nodevec.size()==0 )
    return sortedNode;
  // no need to sort if there is only 1 element
  if (nodevec.size() ==1)
    return nodevec;

  SgProject* project = SageInterface::getProject();
  Rose_STL_Container<SgNode*> queryResult = NodeQuery::querySubTree(project,V_SgDeclarationStatement);
  for (Rose_STL_Container<SgNode*>::const_iterator iter = queryResult.begin();
      iter!= queryResult.end(); iter++)
  {
//    cerr<<"Trying to match:"<<(*iter)<<(*iter)->class_name() <<" "<<(*iter)->unparseToString()<<endl;
    SgNode* cur_node = *iter;
    SgDeclarationStatement* cur_stmt =  isSgDeclarationStatement(cur_node);
    ROSE_ASSERT(cur_stmt!=NULL);
    vector<SgDeclarationStatement*>::const_iterator i = find (nodevec.begin(), nodevec.end(), cur_stmt);
   if (i!=nodevec.end())
      sortedNode.push_back(*i);
  }

  if (nodevec.size() != sortedNode.size())
  {
    cerr<<"Fatal error in sortSgNodeListBasedOnAppearanceOrderInSource(): nodevec.size() != sortedNode.size()"<<endl;
    cerr<<"nodevec() have "<< nodevec.size()<<" elements. They are:"<<endl;
    for (vector<SgDeclarationStatement*>::const_iterator iter = nodevec.begin(); iter != nodevec.end(); iter++)
    {
      cerr<<(*iter)<<(*iter)->class_name() <<" "<<(*iter)->unparseToString()<<endl;
    }
    cerr<<"sortedNode() have " << sortedNode.size() <<" elements. They are:"<<endl;
    for (vector<SgDeclarationStatement*>::const_iterator iter = sortedNode.begin(); iter != sortedNode.end(); iter++)
    {
      cerr<<(*iter)<<(*iter)->class_name() <<" "<<(*iter)->unparseToString()<<endl;
    }

    ROSE_ASSERT(nodevec.size() == sortedNode.size());
  }
  return sortedNode;
}

//! Please call this instead of calling getDependentDeclarations ( SgStatement* stmt, vector<SgDeclarationStatement*> & declarationList, vector<SgSymbol*> & symbolList )
// This function clears a history map transparently and return a sorted list of dependent declarations
std::vector<SgDeclarationStatement*>
SageInterface::getDependentDeclarations ( SgStatement* stmt )
   {
  // This function returns a list of the dependent declaration for any input statement.
  // Dependent declaration are functions called, types referenced in variable declarations, etc.
#if 0
     printf ("\n\n********************************************************** \n");
     printf (" Inside of getDependentDeclarations(stmt = %p = %s) \n",stmt,stmt->class_name().c_str());
     printf ("********************************************************** \n");

     CollectDependentDeclarationsTraversal t;
     t.traverse(stmt,preorder);

     return t.declarationList;
#else
     // share a single implementation for recursive lookup for dependent declaration
   visitedDeclMap.clear();
   vector<SgDeclarationStatement*> declarationList;
   vector<SgSymbol*> symbolList;
   getDependentDeclarations(stmt, declarationList, symbolList);
   declarationList = sortSgNodeListBasedOnAppearanceOrderInSource(declarationList);
#if 0
     printf ("\n\n ********************************************************** \n");
     cout<<"Found dependent decl: count="<<declarationList.size()<<endl;
     for ( vector<SgDeclarationStatement*>::const_iterator iter = declarationList.begin();
          iter != declarationList.end(); iter++)
     {
       cout<<"\t"<<(*iter)->class_name()<<" at line "<<(*iter)->get_file_info()->get_line()<<endl;
       if ((*iter)->variantT()== V_SgFunctionDeclaration)
         cout<<"func name is:"<<isSgFunctionDeclaration(*iter)->get_name().getString()<<endl;
       //<<(*iter)->unparseToString()<<endl;  // unparseToString() won't work on outlined function
     }
     printf ("\n ********************************************************** \n");
#endif

   return declarationList;

#endif
   }

//! Generate copies for a list of declarations and insert them into a different targetScope.
vector<SgDeclarationStatement*>
generateCopiesOfDependentDeclarations (const  vector<SgDeclarationStatement*>& dependentDeclarations, SgScopeStatement* targetScope)
//generateCopiesOfDependentDeclarations ( SgStatement* stmt, SgScopeStatement* targetScope )
   {
  // Liao suggests adding the target scope to the parameter list so that the constructed function
  // built using SageBuilder::buildNondefiningFunctionDeclaration() can be built to be in the
  // correct scope as soon as possible.

  // This function uses the getDependentDeclarations() function to get the dependent declarations
  // and then returns a list of copies of each of them.

#if 0
     printf ("\n\n********************************************************** \n");
     printf (" Inside of generateCopiesOfDependentDeclarations(stmt = %p = %s) \n",stmt,stmt->class_name().c_str());
     printf ("********************************************************** \n");
#endif

     vector<SgDeclarationStatement*> copiesOfDependentDeclarations;
     // avoiding call getDependentDeclarations() twice
//     vector<SgDeclarationStatement*> dependentDeclarations = getDependentDeclarations(stmt);

#if 0
     printf ("Output the dependentDeclarations: dependentDeclarations.size() = %zu \n",dependentDeclarations.size());
     outputDeclarationList(dependentDeclarations);
#endif
#if 0
     printf ("************************************************ \n");
     printf ("*** Make all copies of dependentDeclarations *** \n");
     printf ("************************************************ \n");
#endif

  // Should have a valid scope, so that symbol tables can be expected to be setup.
     ROSE_ASSERT(targetScope != NULL);

  // DQ (2/25/2009): Initially this is always global scope so test this for now, at least.
     ROSE_ASSERT(isSgGlobal(targetScope) != NULL);

     for (vector<SgDeclarationStatement*>::const_iterator i = dependentDeclarations.begin(); i != dependentDeclarations.end(); i++)
        {
#if 0
          printf ("Copying declaration = %p = %s = %s \n",*i,(*i)->class_name().c_str(),SageInterface::get_name(*i).c_str());
#endif
       // SgNode* copy_node = (*i)->copy(collectDependentDeclarationsCopyType);

          SgNode* copy_node = NULL;
          const SgFunctionDeclaration* functionDeclaration = isSgFunctionDeclaration(*i);

       // For function declarations we don't want to do deep copies on defining declarations
       // since that would violate the One-time Definition Rule (ODR).
          if (functionDeclaration != NULL)
             {
#if 1
               // the target scope may already have a declaration for this function.
               // This happens since SageInterface::appendStatementWithDependentDeclaration() is called in the end of outlining
               // and the original enclosing class of the outlined target has been changed already (replaced target with a call to OUT_xxx())
               // Also, getDependentDeclarations() recursively searches for declarations within the dependent class and hits OUT_xxx()
               // Liao, 5/8/2009
               if (targetScope->lookup_symbol(functionDeclaration->get_name()) !=NULL)
                 continue;
#endif
#if 0
               printf ("In generateCopiesOfDependentDeclarations(): Copy mechanism appied to SgFunctionDeclaration functionDeclaration->get_firstNondefiningDeclaration() = %p \n",functionDeclaration->get_firstNondefiningDeclaration());

               printf ("functionDeclaration                                    = %p \n",functionDeclaration);
               printf ("functionDeclaration->get_definingDeclaration()         = %p \n",functionDeclaration->get_definingDeclaration());
               printf ("functionDeclaration->get_firstNondefiningDeclaration() = %p \n",functionDeclaration->get_firstNondefiningDeclaration());
               printf ("functionDeclaration->get_scope()                       = %p \n",functionDeclaration->get_scope());
               printf ("targetScope                                            = %p \n",targetScope);
#endif
            // FIXME: This conditional could be replace by a single case using the SageBuilder::buildNondefiningFunctionDeclaration()
            // But the idea started that only defining function declarations would be a special case to all declarations being copied.

            // Make sure this is not a defining declaration
            // if (functionDeclaration->get_firstNondefiningDeclaration() != NULL)
            // if (functionDeclaration->get_firstNondefiningDeclaration() != NULL && functionDeclaration->get_definingDeclaration() != functionDeclaration)
               if (functionDeclaration->get_definingDeclaration() != functionDeclaration)
                  { //functionDeclaration is a non-defining declaration
                    ROSE_ASSERT(functionDeclaration->get_firstNondefiningDeclaration() != NULL);

                 // Make a copy of the non-defining declaration
                    copy_node = functionDeclaration->get_firstNondefiningDeclaration()->copy(collectDependentDeclarationsCopyType);

                    SgFunctionDeclaration* copy_nondefiningDeclaration = isSgFunctionDeclaration(copy_node);
                    copy_nondefiningDeclaration->set_firstNondefiningDeclaration(copy_nondefiningDeclaration);
                    ROSE_ASSERT(copy_nondefiningDeclaration->get_definingDeclaration() == NULL);

                 // DQ (2/25/2009): Added assertion.
                    ROSE_ASSERT(copy_nondefiningDeclaration->get_scope() == functionDeclaration->get_scope());
                    ROSE_ASSERT(copy_nondefiningDeclaration->get_firstNondefiningDeclaration() != NULL);

                 // Set the scope now that we know it (might be the same as the parent which will be set when the copy is inserted into the AST).
                    copy_nondefiningDeclaration->set_scope(targetScope);

                 // Need to fixup the symbol table to have a symbol for the copied function (this is fixed up later).
                 // ROSE_ASSERT(copy_nondefiningDeclaration->get_symbol_from_symbol_table() != NULL);
                  }
                 else  // functionDeclaration is a defining declaration
                  {
                 // Build a function prototype, but what scope should be used?
                    ROSE_ASSERT(functionDeclaration->get_scope() != NULL);

                 // FIXME: The scope passed to SageBuilder::buildNondefiningFunctionDeclaration() should be NULL
                 // copy_node = SageBuilder::buildNondefiningFunctionDeclaration(functionDeclaration,functionDeclaration->get_scope());
                 // copy_node = SageBuilder::buildNondefiningFunctionDeclaration(functionDeclaration,NULL);
                    copy_node = SageBuilder::buildNondefiningFunctionDeclaration(functionDeclaration,targetScope);

                    SgDeclarationStatement* copy_definingDeclaration = isSgDeclarationStatement(copy_node);

                 // Since copy_definingDeclaration is build as a non-defining declaration we can set it to be the firstNondefiningDeclaration (for the separate file).
                    copy_definingDeclaration->set_firstNondefiningDeclaration(copy_definingDeclaration);

                 // This causes a cross file reference which we might want to disallow in the future.
                 // I think that this might cause the AST post-processing to reset some fields (e.g. scope to be incorect as well).
                 // copy_definingDeclaration->set_definingDeclaration(functionDeclaration->get_definingDeclaration());

                 // DQ (2/25/2009): Added assertion.
                 // ROSE_ASSERT(copy_definingDeclaration->get_scope() == functionDeclaration->get_scope());
                 // ROSE_ASSERT(copy_definingDeclaration->get_scope() == NULL);
                    ROSE_ASSERT(copy_definingDeclaration->get_scope() == targetScope);

                 // If this is for a separate file then the scopes should not match.
                    ROSE_ASSERT(functionDeclaration->get_scope() != targetScope);

                    ROSE_ASSERT(copy_definingDeclaration->get_firstNondefiningDeclaration() != NULL);

                 // This is setup in the SageBuilder::buildNondefiningFunctionDeclaration() function,
                 // so resetting up the symbol table will be skipped later.
                    ROSE_ASSERT(copy_definingDeclaration->get_symbol_from_symbol_table() != NULL);
                  }

               SgFunctionDeclaration* copy_functionDeclaration = isSgFunctionDeclaration(copy_node);
               ROSE_ASSERT(copy_functionDeclaration != NULL);
               //Liao, 5/19/2009
               //FixupTemplateDeclarations::visit() has this assertion
               //patch up endOfConstruct: TODO should do this in copy()
               SgFunctionParameterList * functionParameterList = copy_functionDeclaration->get_parameterList();
               functionParameterList->set_endOfConstruct(functionParameterList->get_startOfConstruct());
               ROSE_ASSERT(functionParameterList->get_startOfConstruct()->isSameFile(functionParameterList->get_endOfConstruct()) == true);

            // Set the scope to NULL, since it AST copy just preserves the scope to be that of functionDeclaration->get_scope()
            // copy_functionDeclaration->set_scope(NULL);

            // ROSE_ASSERT(isSgGlobal(copy_functionDeclaration->get_scope()) != NULL);
            // ROSE_ASSERT(TransformationSupport::getSourceFile(copy_functionDeclaration) == NULL);

            // Parents are not set and the test of SgSourceFile is structural (based on parent pointers).
            // ROSE_ASSERT(TransformationSupport::getSourceFile(copy_functionDeclaration) != NULL);

            // printf ("copy_functionDeclaration reported to be in file = %s \n",TransformationSupport::getSourceFile(copy_functionDeclaration)->getFileName().c_str());
            // ROSE_ASSERT(copy_functionDeclaration->get_scope() == NULL);
               ROSE_ASSERT(copy_functionDeclaration->get_scope() == targetScope);

            // The original function declaration in the original source file could have not had a function
            // prototype, and so it is allowable to have firstNondefiningDeclaration() == NULL.
            // ROSE_ASSERT(functionDeclaration->get_firstNondefiningDeclaration() != NULL);
               if (functionDeclaration->get_firstNondefiningDeclaration() != NULL)
                  {
                    ROSE_ASSERT(TransformationSupport::getSourceFile(functionDeclaration) == TransformationSupport::getSourceFile(functionDeclaration->get_firstNondefiningDeclaration()));
                    ROSE_ASSERT(TransformationSupport::getSourceFile(functionDeclaration->get_scope()) == TransformationSupport::getSourceFile(functionDeclaration->get_firstNondefiningDeclaration()));
                  }

               ROSE_ASSERT(copy_functionDeclaration != NULL);
               ROSE_ASSERT(copy_functionDeclaration->get_firstNondefiningDeclaration() != NULL);

            // Since the scopes are not properly set (functions have not been inserted) TransformationSupport::getSourceFile() will just be NULL.
            // ROSE_ASSERT(TransformationSupport::getSourceFile(copy_functionDeclaration) == TransformationSupport::getSourceFile(copy_functionDeclaration->get_firstNondefiningDeclaration()));

            // The scope has not been set yet, so we can't test that the files are the same.
            // ROSE_ASSERT(TransformationSupport::getSourceFile(copy_functionDeclaration->get_scope()) == TransformationSupport::getSourceFile(copy_functionDeclaration->get_firstNondefiningDeclaration()));
#if 0
               printf ("In generateCopiesOfDependentDeclarations(): DONE: Copy mechanism appied to SgFunctionDeclaration \n");
               ROSE_ASSERT(false);
#endif
             }
            else
             {
#if 1     // We only copy the non-defining declaration of a defining typedef declaration
          // since its defining body will be treated as a separate declaration and inserted to the new file.
          // This is also a workaround for an AST copy bug: losing defining body of a defining typedef declaration after copying.
                 SgTypedefDeclaration* tdecl = isSgTypedefDeclaration(*i);
                 if (tdecl)
                 {
#if 0
                   if (tdecl->get_definingDeclaration() == tdecl)
                     cout<<"Copying a defining typedef declaration:"<<tdecl->unparseToString()<<endl;
                   else
                     cout<<"Copying a non-defining typedef declaration:"<<tdecl->unparseToString()<<endl;
#endif
                   copy_node = SageInterface::deepCopy(tdecl->get_firstNondefiningDeclaration());
                 }
                  else
#endif
                   copy_node = (*i)->copy(collectDependentDeclarationsCopyType);

            // Set the scope now that we know it (might be the same as the parent which will be set when the copy is inserted into the AST).
               SgDeclarationStatement* copy_declaration = isSgDeclarationStatement(copy_node);
               ROSE_ASSERT(copy_declaration != NULL);

            // DQ (3/2/2009): This will be done later, but it is set above, so set it in this branch to be consistant.
               if (copy_declaration->hasExplicitScope() == true)
                    copy_declaration->set_scope(targetScope);
             }

       // SgNode* copy_node = (*i)->copy(collectDependentDeclarationsCopyType);
       // Build a function prototype, but what scope should be used?
       // ROSE_ASSERT(functionDeclaration->get_scope() != NULL);
       // copy = SageBuilder::buildNondefiningFunctionDeclaration(functionDeclaration,functionDeclaration->get_scope());

#if 0
          printf ("DONE: Copying declaration: original = %p = %s = %s to copy = %p = %s = %s \n",*i,(*i)->class_name().c_str(),SageInterface::get_name(*i).c_str(),copy_node,copy_node->class_name().c_str(),SageInterface::get_name(copy_node).c_str());
#endif

          ROSE_ASSERT(copy_node != NULL);
          ROSE_ASSERT(copy_node->get_file_info() != NULL);

       // Note that the root of the does not have its file info set like its children.
          copy_node->get_file_info()->setTransformation();
          copy_node->get_file_info()->setOutputInCodeGeneration();
       // copy_node->get_file_info()->display("CollectDependentDeclarationsTraversal::visit()");

          SgDeclarationStatement* copy_definingDeclaration = isSgDeclarationStatement(copy_node);
          ROSE_ASSERT(copy_definingDeclaration != NULL);

          ROSE_ASSERT( *i != NULL );
          ROSE_ASSERT(copy_definingDeclaration != NULL);

       // DQ (2/26/2009): get_scope() will require a valid parent for some cases (see moreTest4.cpp).
          if (copy_definingDeclaration->get_parent() == NULL)
             {
               copy_definingDeclaration->set_parent(targetScope);
             }
          ROSE_ASSERT(copy_definingDeclaration->get_parent() != NULL);

#if 0
          printf ("DONE: Copying declaration: original scope = %p copied to scope = %p \n",(*i)->get_scope(),copy_definingDeclaration->get_scope());
#endif

       // DQ (2/22/2009): I think we need to set these explicitly (it will be reset later).
          copy_definingDeclaration->set_parent(NULL);

       // Now that we pass in the scope explicitly we can set the scope (above), so don't reset to NULL!
       // copy_definingDeclaration->set_scope(NULL);

       // DQ (2/20/2009): Added assertion.
          ROSE_ASSERT(copy_definingDeclaration->get_parent() == NULL);

#if 0
       // DQ (2/20/2009): Added assertion.
       // ROSE_ASSERT(copy_definingDeclaration->get_definingDeclaration() != NULL);
          if (copy_definingDeclaration->get_firstNondefiningDeclaration() == NULL)
             {
               printf ("copy_definingDeclaration = %p \n",copy_definingDeclaration);
               printf ("copy_definingDeclaration->get_firstNondefiningDeclaration() == NULL \n");
               printf ("copy_definingDeclaration->get_definingDeclaration() = %p \n",copy_definingDeclaration->get_definingDeclaration());
             }
#endif

       // DQ (2/21/2009): Commented out as a test.
          if ((*i)->get_firstNondefiningDeclaration() != NULL)
             {
               ROSE_ASSERT(copy_definingDeclaration->get_firstNondefiningDeclaration() != NULL);
             }

       // DQ (2/20/2009): Added asertion.
       // ROSE_ASSERT(copy_definingDeclaration->get_parent() != NULL);

          copiesOfDependentDeclarations.push_back(copy_definingDeclaration);
        }

#if 0
     printf ("****************************************************** \n");
     printf ("*** DONE: Make all copies of dependentDeclarations *** \n");
     printf ("****************************************************** \n");
     printf ("copiesOfDependentDeclarations.size() = %zu \n",copiesOfDependentDeclarations.size());
#endif

  // The mapping of copies to original declarations should be 1-to-1.
  // Liao, not true anymore for getDependentDeclarations() using recursion: a depending class's body is searched for dependents also.
  // The class body  might have a call to an outlined function, which already has a prototype in the target scope and needs no redundant copy
     ROSE_ASSERT(copiesOfDependentDeclarations.size() <= dependentDeclarations.size());

     return copiesOfDependentDeclarations;
   }


bool
declarationContainsDependentDeclarations( SgDeclarationStatement* decl, vector<SgDeclarationStatement*> & dependentDeclarationList )
   {
  // DQ (2/16/2009): This function finds the declarations in "decl" and checks if they match against those in dependentDeclarationList
     bool returnValue = false;

#if 0
     printf ("\n\n********************************************************** \n");
     printf (" Inside of declarationContainsDependentDeclarations(decl = %p = %s) \n",decl,decl->class_name().c_str());
     printf ("********************************************************** \n");
#endif

     vector<SgDeclarationStatement*> locallyDependentDeclarationList = SageInterface::getDependentDeclarations(decl);

  // printf ("In declarationContainsDependentDeclarations(): locallyDependentDeclarationList: \n");
  // outputPreprocessingInfoList(locallyDependentDeclarationList);

     for (size_t i = 0; i < locallyDependentDeclarationList.size(); i++)
        {
          SgDeclarationStatement* d = locallyDependentDeclarationList[i];
#if 0
          printf ("locallyDependentDeclarationList[%zu] = %p = %s = %s \n",i,d,d->class_name().c_str(),SageInterface::get_name(d).c_str());
#endif
          vector<SgDeclarationStatement*>::iterator j = find(dependentDeclarationList.begin(),dependentDeclarationList.end(),d);
          if (j != dependentDeclarationList.end())
             {
            // These identified declaration must be output as members of the class when it is output in the separate header file.
            // infact ODR may require that the whole class be output! Actually I think we don't have any chioce here!
#if 0
               printf ("Found a dependent declaration buried in the class definition: locallyDependentDeclarationList[%zu] = %p = %s = %s \n",i,d,d->class_name().c_str(),SageInterface::get_name(d).c_str());
#endif
               returnValue = true;
             }
        }

#if 0
     printf ("**************************************************************************** \n");
     printf (" LEAVING: Inside of declarationContainsDependentDeclarations(decl = %p = %s) returnValue = %s \n",decl,decl->class_name().c_str(),returnValue ? "true" : "false");
     printf ("**************************************************************************** \n");
#endif

     return returnValue;
   }

void
SageInterface::addMessageStatement( SgStatement* stmt, string message )
   {
  // Put out a message in the separate file to lable the dependent CPP directives.
  // --- PreprocessingInfo(DirectiveType, const std::string & inputString, const std::string & filenameString, int line_no, int col_no, int nol, RelativePositionType relPos );
  // SgSourceFile* separateSourceFile = TransformationSupport::getSourceFile(scope);
     string fileName = "separate-outlined-file";
     PreprocessingInfo* messageToUser = new PreprocessingInfo(PreprocessingInfo::C_StyleComment,message,fileName,0,0,1,PreprocessingInfo::before);
  // requiredDirectivesList.push_back(messageToUser);
     stmt->addToAttachedPreprocessingInfo(messageToUser,PreprocessingInfo::before);
   }


// DQ (2/6/2009): Added function to support outlining into separate file.
// Append a function 'decl' into a 'scope', including any referenced declarations required if the scope is within a compiler generated file. All referenced declarations, including those from headers, are inserted if excludeHeaderFiles is set to true (the new file will not have any headers)
void
SageInterface::appendStatementWithDependentDeclaration( SgDeclarationStatement* decl, SgGlobal* scope, SgStatement* original_statement, bool excludeHeaderFiles)
   {
  // New function to support outlining of functions into separate files (with their required declarations).

#if 0
     printf ("***** In SageInterface::appendStatementWithDependentDeclaration(): decl                                    = %p \n",decl);
     printf ("***** In SageInterface::appendStatementWithDependentDeclaration(): decl->get_parent()                      = %p \n",decl->get_parent());
     printf ("***** In SageInterface::appendStatementWithDependentDeclaration(): decl->get_scope()                       = %p \n",decl->get_scope());
     printf ("***** In SageInterface::appendStatementWithDependentDeclaration(): original_statement                      = %p \n",original_statement);
     printf ("***** In SageInterface::appendStatementWithDependentDeclaration(): file (decl)                             = %s \n",TransformationSupport::getSourceFile(decl)->getFileName().c_str());
     printf ("***** In SageInterface::appendStatementWithDependentDeclaration(): decl->get_firstNondefiningDeclaration() = %p \n",decl->get_firstNondefiningDeclaration());
     if (decl->get_firstNondefiningDeclaration() != NULL)
          printf ("***** In SageInterface::appendStatementWithDependentDeclaration(): file (first non-defining)               = %s \n",TransformationSupport::getSourceFile(decl->get_firstNondefiningDeclaration())->getFileName().c_str());
     printf ("***** In SageInterface::appendStatementWithDependentDeclaration(): decl->get_definingDeclaration()         = %p \n",decl->get_definingDeclaration());
     if (decl->get_definingDeclaration() != NULL)
          printf ("***** In SageInterface::appendStatementWithDependentDeclaration(): file (first non-defining)               = %s \n",TransformationSupport::getSourceFile(decl->get_definingDeclaration())->getFileName().c_str());
#endif

#if 0
  // This is the most basic form of what code is required, but now enough for the general cases.
  // Also a copy is required to avoid sharing a statment in two places in the AST (part of what
  // is required for AST consistancy).
     scope->append_declaration (decl);
     decl->set_scope (scope);
     decl->set_parent (scope);
#endif

  // Make sure that the input declaration (decl" is consistent in it's representation across more
  // than one file (only a significant test when outlining to a separate file; which is what this
  // function supports).
     ROSE_ASSERT(decl->get_firstNondefiningDeclaration() != NULL);
     ROSE_ASSERT(TransformationSupport::getSourceFile(decl) == TransformationSupport::getSourceFile(decl->get_firstNondefiningDeclaration()));
     ROSE_ASSERT(TransformationSupport::getSourceFile(decl->get_scope()) == TransformationSupport::getSourceFile(decl->get_firstNondefiningDeclaration()));

  // DQ (2/6/2009): I need to write this function to support the
  // insertion of the function into the specified scope.  If the
  // file associated with the scope is marked as compiler generated
  // (or as a transformation) then the declarations referenced in the
  // function must be copied as well (those not in include files)
  // and the include files must be copies also. If the SgFile
  // is not compiler generated (or a transformation) then we just
  // append the function to the scope (trivial case).

  // This code will be based on the work in:
  //   developersScratchSpace/Dan/translator_tests/reverseTraversal.C

  // To test this run: "rm moreTest2.o ; make moreTest2.o"
  // in directory: tests/roseTests/astOutliningTests

  // ***** Also move different loop IR nodes into a common base class *****

  // SgSourceFile* separateSourceFile = TransformationSupport::getSourceFile(scope);

  // DQ (3/2/2009): This now calls a newer function which returns a list of declarations and a list of symbols.
  // The declarations are sometimes outer declarations of nested references to dependent declaration in inner
  // scopes (see moreTest3.cpp).  The Symbol list are the symbols in the old AST that will be mapped to newer
  // symbols generated in the copied AST.
  // Collect the declaration that the input declaration depends upon.
    vector<SgDeclarationStatement*> dependentDeclarationList_inOriginalFile;

    dependentDeclarationList_inOriginalFile = getDependentDeclarations(decl);

  // Generate the copies of all the dependent statements
//     printf ("Fixme: this currently causes the getDependentDeclarations(decl) function to be called twice \n");
//     vector<SgDeclarationStatement*> dependentDeclarationList = generateCopiesOfDependentDeclarations(decl,scope);
     vector<SgDeclarationStatement*> dependentDeclarationList = generateCopiesOfDependentDeclarations(dependentDeclarationList_inOriginalFile,scope);
     ROSE_ASSERT(dependentDeclarationList.size() <= dependentDeclarationList_inOriginalFile.size());

  // Make sure that the input declaration (decl" is consistent in it's representation across more
  // than one file (only a significant test when outlining to a separate file; which is what this
  // function supports).
     ROSE_ASSERT(decl->get_firstNondefiningDeclaration() != NULL);
     ROSE_ASSERT(TransformationSupport::getSourceFile(decl) == TransformationSupport::getSourceFile(decl->get_firstNondefiningDeclaration()));
     ROSE_ASSERT(TransformationSupport::getSourceFile(decl->get_scope()) == TransformationSupport::getSourceFile(decl->get_firstNondefiningDeclaration()));

  // This is used to fixup the AST by resetting references to IR nodes (leveraged from AST merge).
     int replacementHashTableSize = 1001;
// CH (4/9/2010): Use boost::unordered instead
//#ifdef _MSC_VER
#if 0
//#pragma message ("WARNING: in MSCV, hash_map constructor taking integer is not availalbe in MSVC.")
     printf ("WARNING: in MSCV, hash_map constructor taking integer is not availalbe in MSVC. \n");
     ReplacementMapTraversal::ReplacementMapType replacementMap;
#else
     ReplacementMapTraversal::ReplacementMapType replacementMap(replacementHashTableSize);
#endif

  // DQ (3/2/2009): Now use the collectDependentDeclarationsCopyType object to generate the mapping
  // from the symbols in the old AST to the new symbols in the new AST (generated as part of the AST
  // copy mechanism).
     SgCopyHelp::copiedNodeMapType copyNodeMap = collectDependentDeclarationsCopyType.get_copiedNodeMap();
     SgCopyHelp::copiedNodeMapType::iterator copyNodeMapItrator = copyNodeMap.begin();
     while (copyNodeMapItrator != copyNodeMap.end())
        {
       // Loop over all the nodes generated in the AST copy mechanism (accumulated result over multiple copies).
       // const SgNode* first  = const_cast<SgNode*>(copyNodeMapItrator->first);
       // SgNode* first  = copyNodeMapItrator->first;
          SgNode* first  = const_cast<SgNode*>(copyNodeMapItrator->first);
          SgNode* second = copyNodeMapItrator->second;
#if 0
          printf ("copyNodeMapItrator.first = %p = %s second = %p = %s \n",first,first->class_name().c_str(),second,second->class_name().c_str());
#endif
       // Add the SgGlobal referenece to the replacementMap
          if (isSgSymbol(first) != NULL)
             {
#if 0
               printf ("Adding to replacementMap (first = %p = %s = %s , second = %p \n",first,first->class_name().c_str(),SageInterface::get_name(first).c_str(),second);
#endif
               replacementMap.insert(pair<SgNode*,SgNode*>(first,second));
             }

          copyNodeMapItrator++;
        }

#if 0
     printf ("Exiting after test of new functionality \n");
     ROSE_ASSERT(false);
#endif

  // DQ (2/22/2009): We need all the declarations! (moreTest3.cpp demonstrates this, since it drops
  // the "#define SIMPLE 1" which causes it to be treated a "0" (causing errors in the generated code).
     SgSourceFile* sourceFile = TransformationSupport::getSourceFile(original_statement);
     vector<PreprocessingInfo*> requiredDirectivesList = collectCppDirectives(sourceFile);

     SgFunctionDeclaration* outlinedFunctionDeclaration = isSgFunctionDeclaration(decl);
     ROSE_ASSERT(outlinedFunctionDeclaration != NULL);
     SgGlobal* originalFileGlobalScope = TransformationSupport::getGlobalScope(original_statement);
     ROSE_ASSERT(originalFileGlobalScope != NULL);
     SgFunctionSymbol* outlinedFunctionSymbolFromOriginalFile = isSgFunctionSymbol(originalFileGlobalScope->lookup_symbol(outlinedFunctionDeclaration->get_name()));

  // SgSymbol* outlinedFunctionSymbolFromOutlinedFile = scope->lookup_symbol(outlinedFunctionDeclaration->get_name());
     ROSE_ASSERT(decl->get_firstNondefiningDeclaration() != NULL);
     SgFunctionSymbol* outlinedFunctionSymbolFromOutlinedFile = isSgFunctionSymbol(decl->get_firstNondefiningDeclaration()->get_symbol_from_symbol_table());
#if 0
     printf ("outlinedFunctionSymbolFromOriginalFile = %p outlinedFunctionSymbolFromOutlinedFile = %p \n",outlinedFunctionSymbolFromOriginalFile,outlinedFunctionSymbolFromOutlinedFile);

     printf ("TransformationSupport::getSourceFile(decl)->getFileName()                                    = %s \n",TransformationSupport::getSourceFile(decl)->getFileName().c_str());
     printf ("TransformationSupport::getSourceFile(decl->get_firstNondefiningDeclaration())->getFileName() = %s \n",TransformationSupport::getSourceFile(decl->get_firstNondefiningDeclaration())->getFileName().c_str());
     printf ("TransformationSupport::getSourceFile(original_statement)->getFileName()                      = %s \n",TransformationSupport::getSourceFile(original_statement)->getFileName().c_str());
#endif

     ROSE_ASSERT(outlinedFunctionSymbolFromOriginalFile != NULL);
     ROSE_ASSERT(outlinedFunctionSymbolFromOutlinedFile != NULL);

     ROSE_ASSERT(outlinedFunctionSymbolFromOriginalFile != outlinedFunctionSymbolFromOutlinedFile);

  // Add the SgFunctionSymbol for the outlined function to the replacement list so that references
  // to the original symbol (in the original file) within the outlined code will be replaced in the
  // AST for the outlined code copied to the separated outlined file.
  // replacementMap.insert(pair<SgNode*,SgNode*>(outlinedFunctionSymbolFromOutlinedFile,outlinedFunctionSymbolFromOriginalFile));
     replacementMap.insert(pair<SgNode*,SgNode*>(outlinedFunctionSymbolFromOriginalFile,outlinedFunctionSymbolFromOutlinedFile));

  // Add the SgGlobal referenece to the replacementMap
     replacementMap.insert(pair<SgNode*,SgNode*>(originalFileGlobalScope,scope));

  // Add the non-defining declarations of the outlined function to the replacementMap
     SgFunctionDeclaration* outlinedNondefiningFunctionDeclarationFromOriginalFile = isSgFunctionDeclaration(outlinedFunctionSymbolFromOriginalFile->get_declaration());
     SgFunctionDeclaration* outlinedNondefiningFunctionDeclarationFromOutlinedFile = isSgFunctionDeclaration(decl->get_firstNondefiningDeclaration());
     ROSE_ASSERT(outlinedNondefiningFunctionDeclarationFromOriginalFile != NULL);
     ROSE_ASSERT(outlinedNondefiningFunctionDeclarationFromOutlinedFile != NULL);
     replacementMap.insert(pair<SgNode*,SgNode*>(outlinedNondefiningFunctionDeclarationFromOriginalFile,outlinedNondefiningFunctionDeclarationFromOutlinedFile));


  // list<SgDeclarationStatement>::iterator i = declarationList.begin();
  // while (i != declarationList.end())
  // for (list<SgDeclarationStatement>::iterator i = declarationList.begin(); i != declarationList.end(); i++)

//      cout<<"\n*******************************************\n"<<endl;
//      cout<<"Inserting dependent decls: count="<<dependentDeclarationList.size()<<endl;
     for (size_t i = 0; i < dependentDeclarationList.size(); i++)
        {
          SgDeclarationStatement* d                   = dependentDeclarationList[i]; // copies of dependent declarations
          SgDeclarationStatement* originalDeclaration = dependentDeclarationList_inOriginalFile[i];
#if 0
          printf ("declarationList[%zu] = %p = %s = %s \n",i,d,d->class_name().c_str(),SageInterface::get_name(d).c_str());
          printf ("originalDeclaration = %p \n",originalDeclaration);

          d->get_file_info()->display("SageInterface::appendStatementWithDependentDeclaration()");
#endif
       // DQ (2/20/2009): Added assertions (fails for moreTest2.cpp)
       // ROSE_ASSERT(d->get_firstNondefiningDeclaration() != NULL);

       // This is not defined for SgNamespaceDeclarationStatement (so it is OK if the copy is NULL)
       // ROSE_ASSERT(d->get_definingDeclaration() != NULL);

       // DQ (2/20/2009): Added assertion.
          ROSE_ASSERT(d->get_parent() == NULL);

       // scope->append_declaration(d);
       // scope->insert_statement (decl, d, /* bool inFront= */ true);
          ROSE_ASSERT(decl->get_scope() == scope);
          ROSE_ASSERT(find(scope->getDeclarationList().begin(),scope->getDeclarationList().end(),decl) != scope->getDeclarationList().end());
          scope->insert_statement (decl, d, /* bool inFront= */ true);
          d->set_parent (scope);

//debug here
//     cout<<d->class_name()<<endl;
       // "d" appears to loose the fact that it is a SgNamespaceDeclarationStatement (because it is not explicitly stored for this case!).
       // d->set_scope (scope);
          if (d->hasExplicitScope() == true)
               d->set_scope (scope);

       // Also set the scope and parent for the firstNondefiningDeclaration (also built via AST Copy)
       // Show this detail to Liao and now to see it in the AST.
          if (d->get_firstNondefiningDeclaration() != NULL)
             {
               d->get_firstNondefiningDeclaration()->set_parent (scope);
               if (d->hasExplicitScope() == true)
                    d->get_firstNondefiningDeclaration()->set_scope (scope);

               ROSE_ASSERT(d->get_firstNondefiningDeclaration()->get_parent() != NULL);
               ROSE_ASSERT(d->get_firstNondefiningDeclaration()->get_parent() == scope);
             }

          if (d->get_definingDeclaration() != NULL)
             {
               d->get_definingDeclaration()->set_parent(scope);

               ROSE_ASSERT(d->get_definingDeclaration()->get_parent() != NULL);
               ROSE_ASSERT(d->get_definingDeclaration()->get_parent() == scope);
               if (d->hasExplicitScope() == true)
                  {
                    d->get_definingDeclaration()->set_scope (scope);
                    ROSE_ASSERT(d->get_definingDeclaration()->get_scope() == scope);
                  }
             }

       // Make sure that internal references are to the same file (else the symbol table information will not be consistent).
          ROSE_ASSERT(d->get_firstNondefiningDeclaration() != NULL);
          ROSE_ASSERT(TransformationSupport::getSourceFile(d) == TransformationSupport::getSourceFile(d->get_firstNondefiningDeclaration()));
          ROSE_ASSERT(TransformationSupport::getSourceFile(d->get_scope()) == TransformationSupport::getSourceFile(d->get_firstNondefiningDeclaration()));

#if 0
          printf ("Add the required symbol information to the symbol table: scope = %p = %s \n",scope,scope->class_name().c_str());
#endif

       // For whatever type of declaration we add to the global scope in the new separate
       // file we have to add the required symbol information to the symbol table.
          switch(d->variantT())
             {
               case V_SgClassDeclaration:
                  {
                 // This is not called, since this function is used to insert functions!
                    ROSE_ASSERT(d->get_firstNondefiningDeclaration() != NULL);
                    SgClassDeclaration* classDeclaration = NULL;
                    if ( declarationContainsDependentDeclarations(d,dependentDeclarationList) == true )
                       {
                      // If we need to reference declaration in the class then we need the same defining
                      // declaration as was in the other file where we outlined the original function from!
                         printf ("Warning: This class contains dependent declarations (not implemented) \n");
                      // ROSE_ASSERT(false);
                         classDeclaration = isSgClassDeclaration(d);
                         ROSE_ASSERT(classDeclaration != NULL);
                       }
                      else
                       {
                         classDeclaration = isSgClassDeclaration(d->get_firstNondefiningDeclaration());
                         ROSE_ASSERT(classDeclaration != NULL);
                       }

                    ROSE_ASSERT(classDeclaration != NULL);

                 // printf ("$$$$$$$$$$$$$$$$$$$$$  Building a SgClassSymbol %s $$$$$$$$$$$$$$$$$$$$$ \n",classDeclaration->get_name().str());
                    SgClassSymbol* classSymbol = new SgClassSymbol(classDeclaration);
                    ROSE_ASSERT(classSymbol != NULL);
                    scope->insert_symbol(classDeclaration->get_name(),classSymbol);
                 // ROSE_ASSERT(classDeclaration->get_symbol_from_symbol_table() != NULL);

                 // printf ("Case of SgClassDeclaration implemented but not being tested \n");
                 // ROSE_ASSERT(false);

                    SgSymbol* symbolInOutlinedFile = classDeclaration->get_symbol_from_symbol_table();
                 // printf ("$$$$$$$$$$$$$$ originalDeclaration = %p = %s \n",originalDeclaration,originalDeclaration->class_name().c_str());
                    ROSE_ASSERT(originalDeclaration != NULL);
                    ROSE_ASSERT(originalDeclaration->get_firstNondefiningDeclaration() != NULL);
                    SgSymbol* symbolInOriginalFile = originalDeclaration->get_firstNondefiningDeclaration()->get_symbol_from_symbol_table();
                 // printf ("$$$$$$$$$$$$$$ case V_SgClassDeclaration: symbolInOriginalFile = %p symbolInOutlinedFile = %p \n",symbolInOriginalFile,symbolInOutlinedFile);

                    ROSE_ASSERT(symbolInOriginalFile != NULL);
                    ROSE_ASSERT(symbolInOutlinedFile != NULL);
                    ROSE_ASSERT(symbolInOriginalFile != symbolInOutlinedFile);

                    replacementMap.insert(pair<SgNode*,SgNode*>(symbolInOutlinedFile,symbolInOriginalFile));
                    break;
                  }

               case V_SgFunctionDeclaration:
                  {
                 // ROSE_ASSERT(d->get_firstNondefiningDeclaration() == NULL);
                    SgFunctionDeclaration* copiedFunctionDeclaration = isSgFunctionDeclaration(d);
                    ROSE_ASSERT(copiedFunctionDeclaration != NULL);
#if 0
                    printf ("$$$$$$$$$$$$$$$$$$$$$  Building a SgFunctionSymbol %s $$$$$$$$$$$$$$$$$$$$$ \n",copiedFunctionDeclaration->get_name().str());
                    printf ("functionDeclaration                                    = %p \n",copiedFunctionDeclaration);
                    printf ("functionDeclaration->get_definingDeclaration()         = %p \n",copiedFunctionDeclaration->get_definingDeclaration());
                    printf ("functionDeclaration->get_firstNondefiningDeclaration() = %p \n",copiedFunctionDeclaration->get_firstNondefiningDeclaration());
                    printf ("lokup symbol in scope =                                = %p \n",scope);
#endif

                    if (scope->lookup_symbol(copiedFunctionDeclaration->get_name()) == NULL)
                       {
                         SgFunctionSymbol* functionSymbol = new SgFunctionSymbol(copiedFunctionDeclaration);
                         ROSE_ASSERT(functionSymbol != NULL);
                      // printf ("copiedFunctionDeclaration = %p Inserting functionSymbol = %p with name = %s \n",copiedFunctionDeclaration,functionSymbol,copiedFunctionDeclaration->get_name().str());
                         scope->insert_symbol(copiedFunctionDeclaration->get_name(),functionSymbol);
                         ROSE_ASSERT(scope->lookup_symbol(copiedFunctionDeclaration->get_name()) == functionSymbol);

                         ROSE_ASSERT(copiedFunctionDeclaration->get_symbol_from_symbol_table() != NULL);
                         copiedFunctionDeclaration->set_scope(scope);
                       }
                    ROSE_ASSERT(copiedFunctionDeclaration->get_symbol_from_symbol_table() != NULL);

                 // printf ("decl = %p = %s original_statement = %p = %s \n",decl,decl->class_name().c_str(),original_statement,original_statement->class_name().c_str());
                    printf ("decl = %p = %s originalDeclaration = %p = %s \n",decl,decl->class_name().c_str(),originalDeclaration,originalDeclaration->class_name().c_str());

                 // SgFunctionDeclaration* originalFunctionDeclaration = isSgFunctionDeclaration(decl);
                    SgFunctionDeclaration* originalFunctionDeclaration = isSgFunctionDeclaration(originalDeclaration);
                    ROSE_ASSERT(originalFunctionDeclaration != NULL);

                    SgSymbol* symbolInOutlinedFile = originalFunctionDeclaration->get_symbol_from_symbol_table();
                    SgSymbol* symbolInOriginalFile = copiedFunctionDeclaration->get_symbol_from_symbol_table();
#if 0
                    printf ("symbolInOriginalFile = %p symbolInOutlinedFile = %p \n",symbolInOriginalFile,symbolInOutlinedFile);
#endif
                    ROSE_ASSERT(symbolInOriginalFile != NULL);
                    ROSE_ASSERT(symbolInOutlinedFile != NULL);
                    ROSE_ASSERT(symbolInOriginalFile != symbolInOutlinedFile);

                 // Build up the replacementMap
                 // replacementMap.insert(pair<SgNode*,SgNode*>(node,duplicateNodeFromOriginalAST));
                 // replacementMap.insert(pair<SgNode*,SgNode*>(symbolInOriginalFile,symbolInOutlinedFile));
                    replacementMap.insert(pair<SgNode*,SgNode*>(symbolInOutlinedFile,symbolInOriginalFile));

#if 0
                 // Not sure if this is a problem (at this point)
                    SgFunctionType* functionType = functionDeclaration->get_type();
                    ROSE_ASSERT(functionType != NULL);
                    string functionTypeName = functionType->get_mangled();
                    printf ("Testing the function type: functionTypeName = %s \n",functionTypeName.c_str());
                    if (SgNode::get_globalFunctionTypeTable()->lookup_function_type(functionTypeName) == NULL)
                       {
                         printf ("Adding the function type: functionTypeName = %s \n",functionTypeName.c_str());
                         SgNode::get_globalFunctionTypeTable()->insert_function_type(functionTypeName,functionType);
                       }
#endif
                 // printf ("Case of SgFunctionDeclaration implemented but not being tested \n");
                 // ROSE_ASSERT(false);

                    break;
                  }

               case V_SgMemberFunctionDeclaration:
                  {
                 // ROSE_ASSERT(d->get_firstNondefiningDeclaration() == NULL);
                    SgMemberFunctionDeclaration* copiedMemberFunctionDeclaration = isSgMemberFunctionDeclaration(d);
                    ROSE_ASSERT(copiedMemberFunctionDeclaration != NULL);

                    printf ("Sorry, support for dependent member function declarations not implemented! \n");
                    ROSE_ASSERT(false);

                    break;
                  }

                case V_SgTemplateInstantiationDecl:
                  {
                    printf ("Sorry, not implemented: case SgTemplateInstantiationDecl not handled as dependent declaration \n");
                    d->get_file_info()->display("Sorry, not implemented: case SgTemplateInstantiationDecl not handled as dependent declaration");

                    printf ("Case of SgTemplateInstantiationDecl not implemented. \n");
                    ROSE_ASSERT(false);
                    break;
                  }

                case V_SgNamespaceDeclarationStatement:
                  {
                 // printf ("Sorry, not implemented: case SgNamespaceDeclarationStatement not handled as dependent declaration \n");
                 // d->get_file_info()->display("Sorry, not implemented: case SgNamespaceDeclarationStatement not handled as dependent declaration");

                    ROSE_ASSERT(d->get_firstNondefiningDeclaration() != NULL);
                    SgNamespaceDeclarationStatement* namespaceDeclaration = NULL;
                    if ( declarationContainsDependentDeclarations(d,dependentDeclarationList) == true )
                       {
                      // If we need to reference declaration in the class then we need the same defining
                      // declaration as was in the other file where we outlined the original function from!
                         printf ("Warning: This namespace contains dependent declarations (not supported) \n");
                      // ROSE_ASSERT(false);
                         namespaceDeclaration = isSgNamespaceDeclarationStatement(d);
                         ROSE_ASSERT(namespaceDeclaration != NULL);
                       }
                      else
                       {
                         namespaceDeclaration = isSgNamespaceDeclarationStatement(d->get_firstNondefiningDeclaration());
                         ROSE_ASSERT(namespaceDeclaration != NULL);
                       }

                    ROSE_ASSERT(namespaceDeclaration != NULL);

                 // DQ (2/22/2009): This should not already be present! If it is present then we don't want to add it (for now detect if it is present).
                    ROSE_ASSERT(scope->lookup_namespace_symbol(namespaceDeclaration->get_name()) == NULL);

                    SgNamespaceSymbol* namespaceSymbol = new SgNamespaceSymbol(namespaceDeclaration->get_name(),namespaceDeclaration);
                    ROSE_ASSERT(namespaceSymbol != NULL);
                    scope->insert_symbol(namespaceDeclaration->get_name(),namespaceSymbol);

                    break;
                  }
                // Liao, 5/7/2009 handle more types of declarations
                case V_SgTypedefDeclaration:
                  {
                    // symbol is associated with the first non-defining declaration
                    SgTypedefDeclaration* typedef_decl = isSgTypedefDeclaration(isSgTypedefDeclaration(d)->get_firstNondefiningDeclaration());
                    ROSE_ASSERT(typedef_decl);
                    // 1 make a symbol in the target scope
                    SgTypedefSymbol * tsymbol = new SgTypedefSymbol(typedef_decl);
                    scope->insert_symbol(typedef_decl->get_name(), tsymbol);

                    SgSymbol* symbolInOutlinedFile = typedef_decl->get_symbol_from_symbol_table();
                    ROSE_ASSERT(symbolInOutlinedFile != NULL);
                    // 2 build a map between old and new symbol
                    ROSE_ASSERT(originalDeclaration != NULL);
                    // symbol is associated with the first non-defining declaration
                    SgSymbol* symbolInOriginalFile = originalDeclaration->get_firstNondefiningDeclaration()->get_symbol_from_symbol_table();
                    ROSE_ASSERT(symbolInOriginalFile != NULL);

                    ROSE_ASSERT(symbolInOriginalFile != symbolInOutlinedFile);
                    replacementMap.insert(pair<SgNode*,SgNode*>(symbolInOutlinedFile,symbolInOriginalFile));
                    break;
                  }
               case V_SgEnumDeclaration:
                  {
                    SgEnumDeclaration * decl = isSgEnumDeclaration(isSgEnumDeclaration(d)->get_firstNondefiningDeclaration());
                    ROSE_ASSERT(decl);
                    SgEnumSymbol * symbol = new SgEnumSymbol(decl);
                    ROSE_ASSERT(symbol);
                    scope->insert_symbol(decl->get_name(), symbol);
                    SgSymbol* symbolInOutlinedFile = decl->get_symbol_from_symbol_table();
                    ROSE_ASSERT(symbolInOutlinedFile != NULL);

                    ROSE_ASSERT(originalDeclaration != NULL);
                    SgSymbol* symbolInOriginalFile = originalDeclaration->get_firstNondefiningDeclaration()->get_symbol_from_symbol_table();
                    ROSE_ASSERT(symbolInOriginalFile != NULL);
                    ROSE_ASSERT(symbolInOriginalFile != symbolInOutlinedFile);
                    replacementMap.insert(pair<SgNode*,SgNode*>(symbolInOutlinedFile,symbolInOriginalFile));
                    break;
                  }
               default:
                  {
                    printf ("default case in SageInterface::appendStatementWithDependentDeclaration() (handling dependentDeclarationList) d = %p = %s \n",d,d->class_name().c_str());
                    ROSE_ASSERT(false);
                  }
             }


       // Collect include directives that are already attached to this dependent declaration.
          vector<PreprocessingInfo*> cppDirectivesAlreadyAttachedToDependentDeclarations = collectCppDirectives(d);

#if 0
          printf ("directives BEFORE excluding those already present in dependent declarations \n");
          outputPreprocessingInfoList(requiredDirectivesList);

          printf ("directives already attached to dependent declarations \n");
          outputPreprocessingInfoList(cppDirectivesAlreadyAttachedToDependentDeclarations);
#endif

       // Remove these include directives from the requiredDirectivesList (to prevent redundant output in the generated file)
          vector<PreprocessingInfo*>::iterator j = cppDirectivesAlreadyAttachedToDependentDeclarations.begin();
          while ( j != cppDirectivesAlreadyAttachedToDependentDeclarations.end() )
             {
            // Remove this directive from the requiredDirectivesList (to avoid having them output redundently).
               vector<PreprocessingInfo*>::iterator entry = find(requiredDirectivesList.begin(),requiredDirectivesList.end(),*j);
               ROSE_ASSERT(entry != requiredDirectivesList.end());

               requiredDirectivesList.erase(entry);

               j++;
             }

#if 0
          printf ("directives AFTER excluding those already present in dependent declarations \n");
          outputPreprocessingInfoList(requiredDirectivesList);
#endif
        }

  // Add a message to the top of the outlined function that has been added
     addMessageStatement(decl,"/* OUTLINED FUNCTION */");

  // Insert the dependent declarations ahead of the input "decl".
     SgStatement* firstStatmentInFile = NULL;
     if (dependentDeclarationList.empty() == true)
        {
          firstStatmentInFile = decl;
        }
       else
        {
          firstStatmentInFile = dependentDeclarationList[0];
        }

     ROSE_ASSERT(firstStatmentInFile != NULL);

  // Add a message to the top of the dependent declarations that have been added
     addMessageStatement(firstStatmentInFile,"/* REQUIRED DEPENDENT DECLARATIONS */");

  // DQ (3/6/2009): Added support to permit exclusion of "#include<header.h>" files since they can make it
  // much more difficult for external tools. Later we will check if there are remaining unsatisfied dependent
  // declarations (which must be in the header file) so we can automate this step.
     if (excludeHeaderFiles == false)
        {
       // Include all the "#include<header.h>" cpp directives obtained from the original file.
          vector<PreprocessingInfo*>::reverse_iterator j = requiredDirectivesList.rbegin();
          while ( j != requiredDirectivesList.rend() )
             {
               firstStatmentInFile->addToAttachedPreprocessingInfo(*j,PreprocessingInfo::before);
               j++;
             }
        }

  // Add a message to the top of the CPP directives that have been added
     addMessageStatement(firstStatmentInFile,"/* REQUIRED CPP DIRECTIVES */");

  // ****************************************************************************
  // ****************  Fixup AST to Reset References To IR nodes  ***************
  // ****************************************************************************
  // This traversal of the replacement map modified the AST to reset pointers to subtrees that will be shared.
  // The whole AST is traversed (using the memory pool traversal) and the data member pointers to IR nodes that
  // are found in the replacement map are used to lookup the replacement values that are used to reset the
  // pointers in the AST. As the replacement is computed the pointer values that are marked in the replacement
  // list for update are added to the intermediateDeleteSet.

     SgSourceFile* outlinedFile = TransformationSupport::getSourceFile(scope);
     ROSE_ASSERT(outlinedFile != NULL);

  // This is required because the AST merge interface records a delete list
  // (these nodes are not deleted for the outlining support).
     set<SgNode*>  intermediateDeleteSet;

  // This replacement will be done over the entire file (parts of it are redundant with what has already
  // been done by the AST copy (so this step need not do as much and may be reduced to just operating
  // on the outlined function, I think).
#if 0
     printf ("\n\n************************************************************\n");
     printf ("Calling fixupSubtreeTraversal() \n");
#endif

     fixupSubtreeTraversal(outlinedFile,replacementMap,intermediateDeleteSet);

#if 0
     printf ("Calling fixupSubtreeTraversal(): DONE \n");
     printf ("************************************************************\n\n");

     printf ("\n\n After replacementMapTraversal(): intermediateDeleteSet: \n");
     displaySet(intermediateDeleteSet,"After fixupTraversal");

     printf ("Output the replacementMap: \n");
     ReplacementMapTraversal::displayReplacementMap(replacementMap);
#endif

  // Repeated test from above
     ROSE_ASSERT(dependentDeclarationList.size() <= dependentDeclarationList_inOriginalFile.size());

#if 0
  // The replacementMap should include the symbols associated with the dependentDeclarationList
  // and the outlined function (so dependentDeclarationList.size() + 1).
     printf ("replacementMap.size() = %zu dependentDeclarationList.size() = %zu \n",replacementMap.size(),dependentDeclarationList.size());
  // ROSE_ASSERT(replacementMap.size() == dependentDeclarationList.size() + 1);
#endif

#if 0
     printf ("Exiting as a test \n");
     ROSE_ASSERT(false);
#endif
   }



#if 0
// This function is not implemented our used, but it might be when the final code is refactored.

// rose_hash::unordered_map<SgNode*, SgNode*, hash_nodeptr>
// void SageInterface::supplementReplacementSymbolMap ( const ReplacementMapTraversal::ReplacementMapType & inputReplacementMap )
void
SageInterface::supplementReplacementSymbolMap ( rose_hash::unordered_map<SgNode*, SgNode*, hash_nodeptr> & inputReplacementMap )
   {
  // Prior to the call to fixupSubtreeTraversal(), we have to build the "replacementMap".  The "replacementMap"
  // contains the IR node address references into the old AST (what was copied) which need to be replaced in the
  // new AST (the copy).  In general the old AST is the original file from which outlining was done and the new
  // AST is the separate file where the outlined code has been placed with its dependent declarations.
  // This function adds to the previously assembled "replacementMap"


   }
#endif


void
SageInterface::deleteAST ( SgNode* n )
   {
//Tan, August/25/2010:       //Re-implement DeleteAST function

	//Use MemoryPoolTraversal to count the number of references to a certain symbol
	//This class defines the visitors for the MemoryPoolTraversal

	class ClassicVisitor : public ROSE_VisitorPattern
	{
		private:
		int SgVariableSymbol_count;
		int SgFunctionSymbol_count;
		int SgClassDeclaration_count;
		int SgTypedefSymbol_count;
		int SgMemFuncSymbol_count;
		int SgTemplateSymbol_count;
		int SgEnumFieldSymbol_count;

		SgVariableSymbol* SgVariableSymbolPtr;
		SgFunctionSymbol* SgFunctionSymbolPtr;
		SgClassSymbol * SgClassSymbolPtr;
		SgTypedefSymbol * SgTypedefPtr;
		SgEnumFieldSymbol * SgEnumFieldSymbolPtr;
		SgMemberFunctionSymbol * SgMemFuncSymbolPtr;
		SgTemplateSymbol * SgTemplateSymbolPtr;
		SgClassDeclaration * class_defining;
		SgTemplateDeclaration * template_defining;
		SgMemberFunctionDeclaration * memFunc;
		SgTypedefDeclaration * typedef_defining;
		SgFunctionDeclaration * function_decl;
 		SgTemplateInstantiationDecl * templateInstantiate_defining;

		public:
		ClassicVisitor(SgVariableSymbol* symbol){
			SgVariableSymbol_count = 0;
			SgVariableSymbolPtr = symbol;
			SgFunctionSymbolPtr =NULL;
			SgClassSymbolPtr =NULL;
			SgTypedefPtr = NULL;
			SgMemFuncSymbolPtr =NULL;
			class_defining = NULL;
			memFunc =NULL;
			typedef_defining =NULL;
			function_decl = NULL;
			SgTemplateSymbolPtr = NULL;
			template_defining = NULL;
			SgEnumFieldSymbolPtr = NULL;
			templateInstantiate_defining =NULL;
		}

		ClassicVisitor(SgFunctionSymbol* symbol){
			SgFunctionSymbol_count = 0;
			SgFunctionSymbolPtr = symbol;
			SgVariableSymbolPtr = NULL;
			SgClassSymbolPtr =NULL;
			SgTypedefPtr = NULL;
			SgMemFuncSymbolPtr =NULL;
			class_defining = NULL;
			memFunc =NULL;
			typedef_defining =NULL;
			function_decl = NULL;
			SgTemplateSymbolPtr = NULL;
			template_defining = NULL;
			SgEnumFieldSymbolPtr = NULL;
			templateInstantiate_defining =NULL;
		}

		ClassicVisitor(SgClassSymbol* symbol){
			SgClassDeclaration_count = 0;
			SgClassSymbolPtr = symbol;
			SgFunctionSymbolPtr = NULL;
			SgVariableSymbolPtr = NULL;
			SgTypedefPtr = NULL;
			SgMemFuncSymbolPtr =NULL;
			class_defining = NULL;
			memFunc =NULL;
			typedef_defining =NULL;
			function_decl = NULL;
			SgTemplateSymbolPtr = NULL;
			template_defining = NULL;
			SgEnumFieldSymbolPtr = NULL;
			templateInstantiate_defining =NULL;
		}

		ClassicVisitor(SgTypedefSymbol* symbol){
			SgTypedefSymbol_count =0;
			SgTypedefPtr = symbol;
			SgClassSymbolPtr = NULL;
			SgFunctionSymbolPtr = NULL;
			SgVariableSymbolPtr = NULL;
			SgMemFuncSymbolPtr =NULL;
			class_defining = NULL;
			memFunc =NULL;
			typedef_defining =NULL;
			function_decl = NULL;
			SgTemplateSymbolPtr = NULL;
			template_defining = NULL;
			SgEnumFieldSymbolPtr = NULL;
			templateInstantiate_defining =NULL;
		}

		ClassicVisitor(SgMemberFunctionSymbol* symbol){
			SgMemFuncSymbolPtr = symbol;
			SgMemFuncSymbol_count =0;
			SgTypedefPtr = NULL;
			SgClassSymbolPtr = NULL;
			SgFunctionSymbolPtr = NULL;
			SgVariableSymbolPtr = NULL;
			class_defining = NULL;
			memFunc =NULL;
			typedef_defining =NULL;
			function_decl = NULL;
			SgTemplateSymbolPtr = NULL;
			template_defining = NULL;
			SgEnumFieldSymbolPtr = NULL;
			templateInstantiate_defining =NULL;
		}

		ClassicVisitor(SgTemplateSymbol* symbol){
			SgTemplateSymbolPtr = symbol;
			SgTemplateSymbol_count =0;
			SgMemFuncSymbolPtr = NULL;
			SgTypedefPtr = NULL;
			SgClassSymbolPtr = NULL;
			SgFunctionSymbolPtr = NULL;
			SgVariableSymbolPtr = NULL;
			class_defining = NULL;
			memFunc =NULL;
			typedef_defining =NULL;
			function_decl = NULL;
			template_defining = NULL;
			SgEnumFieldSymbolPtr = NULL;
			templateInstantiate_defining =NULL;
		}

		ClassicVisitor(SgEnumFieldSymbol* symbol){
			SgEnumFieldSymbolPtr = symbol;
			SgEnumFieldSymbol_count =0;
			SgTemplateSymbolPtr = NULL;
			SgMemFuncSymbolPtr = NULL;
			SgTypedefPtr = NULL;
			SgClassSymbolPtr = NULL;
			SgFunctionSymbolPtr = NULL;
			SgVariableSymbolPtr = NULL;
			class_defining = NULL;
			memFunc =NULL;
			typedef_defining =NULL;
			function_decl = NULL;
			template_defining = NULL;
			templateInstantiate_defining =NULL;
		}


		ClassicVisitor(SgClassDeclaration* node){
			class_defining = node;
			SgMemFuncSymbolPtr = NULL;
			SgTypedefPtr = NULL;
			SgClassSymbolPtr = NULL;
			SgFunctionSymbolPtr = NULL;
			SgVariableSymbolPtr = NULL;
			memFunc =NULL;
			typedef_defining =NULL;
			function_decl = NULL;
			SgTemplateSymbolPtr = NULL;
			template_defining = NULL;
			SgEnumFieldSymbolPtr = NULL;
			templateInstantiate_defining =NULL;
		}

		ClassicVisitor(SgTemplateDeclaration* node){
			template_defining = node;
			class_defining = NULL;
			SgMemFuncSymbolPtr = NULL;
			SgTypedefPtr = NULL;
			SgClassSymbolPtr = NULL;
			SgFunctionSymbolPtr = NULL;
			SgVariableSymbolPtr = NULL;
			memFunc =NULL;
			typedef_defining =NULL;
			function_decl = NULL;
			SgTemplateSymbolPtr = NULL;
			SgEnumFieldSymbolPtr = NULL;
			templateInstantiate_defining =NULL;
		}
		ClassicVisitor(SgFunctionDeclaration* node){
			function_decl =node;
			class_defining = NULL;
			SgMemFuncSymbolPtr = NULL;
			SgTypedefPtr = NULL;
			SgClassSymbolPtr = NULL;
			SgFunctionSymbolPtr = NULL;
			SgVariableSymbolPtr = NULL;
			memFunc =NULL;
			typedef_defining =NULL;
			SgTemplateSymbolPtr = NULL;
			template_defining = NULL;
			SgEnumFieldSymbolPtr = NULL;
			templateInstantiate_defining =NULL;
		}

		ClassicVisitor(SgMemberFunctionDeclaration* node){
			memFunc = node;
			function_decl =NULL;
			class_defining = NULL;
			SgMemFuncSymbolPtr = NULL;
			SgTypedefPtr = NULL;
			SgClassSymbolPtr = NULL;
			SgFunctionSymbolPtr = NULL;
			SgVariableSymbolPtr = NULL;
			typedef_defining =NULL;
			SgTemplateSymbolPtr = NULL;
			template_defining = NULL;
			SgEnumFieldSymbolPtr = NULL;
			templateInstantiate_defining =NULL;
		}

		ClassicVisitor(SgTypedefDeclaration* node){
			typedef_defining = node;
			memFunc = NULL;
			function_decl =NULL;
			class_defining = NULL;
			SgMemFuncSymbolPtr = NULL;
			SgTypedefPtr = NULL;
			SgClassSymbolPtr = NULL;
			SgFunctionSymbolPtr = NULL;
			SgVariableSymbolPtr = NULL;
			SgTemplateSymbolPtr = NULL;
			template_defining = NULL;
			SgEnumFieldSymbolPtr = NULL;
			templateInstantiate_defining =NULL;
		}

		ClassicVisitor(SgTemplateInstantiationDecl* node){
			templateInstantiate_defining =node;
			typedef_defining = NULL;
			memFunc = NULL;
			function_decl =NULL;
			class_defining = NULL;
			SgMemFuncSymbolPtr = NULL;
			SgTypedefPtr = NULL;
			SgClassSymbolPtr = NULL;
			SgFunctionSymbolPtr = NULL;
			SgVariableSymbolPtr = NULL;
			SgTemplateSymbolPtr = NULL;
			template_defining = NULL;
			SgEnumFieldSymbolPtr = NULL;
		}


	// SgVariableSymbol and SgEnumFieldSymbol
		void visit(SgInitializedName* node)
		{
			if(SgVariableSymbolPtr !=NULL){
				if(node->get_scope()!=NULL){
					if(node->get_scope()->get_symbol_table()!=NULL){
						SgSymbol* s = node->get_symbol_from_symbol_table();
						if (isSgVariableSymbol(s) == SgVariableSymbolPtr) SgVariableSymbol_count++;
					}
				}
			}

			if(SgEnumFieldSymbolPtr !=NULL){
				if(node->get_scope()!=NULL){
					if(node->get_scope()->get_symbol_table()!=NULL){
						SgSymbol* s = node->get_symbol_from_symbol_table();
						if (isSgEnumFieldSymbol(s) == SgEnumFieldSymbolPtr) SgEnumFieldSymbol_count++;
					}
				}
			}
		}

		void visit(SgVarRefExp* node)
		{
			if(SgVariableSymbolPtr !=NULL){
				SgVariableSymbol* s = node->get_symbol();
				if (s == SgVariableSymbolPtr) SgVariableSymbol_count++;
			}
		}

		int get_num_variable_pointers(){return SgVariableSymbol_count;}

		int get_num_EnumField_pointers(){return SgEnumFieldSymbol_count;}


	// SgFunctionSymbol
		void visit(SgFunctionDeclaration* node)		{
			if(SgFunctionSymbolPtr !=NULL){
				if(node->get_scope()!=NULL){
					if(node->get_scope()->get_symbol_table()!=NULL){
						SgSymbol* s = ((SgFunctionDeclaration*)node)->get_symbol_from_symbol_table();
						if ((SgFunctionSymbol *)s == SgFunctionSymbolPtr) SgFunctionSymbol_count++;
					}
				}
			}
#if 0
			if(function_decl!=NULL){
				if(node->get_symbol_from_symbol_table() == NULL){
					SgDeclarationStatement * define = ((SgDeclarationStatement*)node)->get_definingDeclaration();
					SgDeclarationStatement * first_nondefine = ((SgDeclarationStatement*)node)->get_firstNondefiningDeclaration();
					if(node!=function_decl && (define==function_decl || first_nondefine==function_decl)) delete node;
				}
			}
#endif
		}

		void visit(SgFunctionRefExp* node)
		{
			if (SgFunctionSymbolPtr !=NULL){
				SgFunctionSymbol* s = node->get_symbol_i();
				if (isSgFunctionSymbol(s) == SgFunctionSymbolPtr) SgFunctionSymbol_count++;
			}
		}

		void visit(SgUserDefinedBinaryOp* node)
		{
			if (SgFunctionSymbolPtr !=NULL){
				SgFunctionSymbol* s = node->get_symbol();
				if (isSgFunctionSymbol(s) == SgFunctionSymbolPtr) SgFunctionSymbol_count++;
			}
		}

		int get_num_Function_pointers(){return SgFunctionSymbol_count;}

	// SgClassSymbol
		void visit(SgClassDeclaration* node)
		{
			if(SgClassSymbolPtr !=NULL){
				if(node->get_scope()!=NULL){
					if(node->get_scope()->get_symbol_table()!=NULL){
						SgSymbol* s = node->get_symbol_from_symbol_table();
						if (isSgClassSymbol(s) == SgClassSymbolPtr) SgClassDeclaration_count++;
					}
				}
			}

			if(class_defining!=NULL) {
				if(node->get_symbol_from_symbol_table() == NULL){
					SgDeclarationStatement * class_decl = ((SgDeclarationStatement*)node)->get_firstNondefiningDeclaration();
					SgDeclarationStatement * class_decl1 = ((SgDeclarationStatement*)node)->get_definingDeclaration();
					if((class_decl==class_defining||class_decl1==class_defining) && node!=class_defining )
						delete node;
				}
			}
		}

		void visit(SgTemplateInstantiationDecl* node)
		{
			if(SgClassSymbolPtr !=NULL){
				if(node->get_scope()!=NULL){
					if(node->get_scope()->get_symbol_table()!=NULL){
						SgSymbol* s = node->get_symbol_from_symbol_table();
						if (isSgClassSymbol(s) == SgClassSymbolPtr) SgClassDeclaration_count++;
					}
				}
			}

			if(templateInstantiate_defining!=NULL) {
				if(node->get_scope()!=NULL){
					if(node->get_scope()->get_symbol_table()!=NULL){
						if(node->get_symbol_from_symbol_table() == NULL){
							SgDeclarationStatement * template_decl = ((SgDeclarationStatement*)node)->get_firstNondefiningDeclaration();
							SgDeclarationStatement * template_decl1 = ((SgDeclarationStatement*)node)->get_definingDeclaration();
							if((template_decl==templateInstantiate_defining||template_decl1==templateInstantiate_defining) && node!=templateInstantiate_defining){
 								/*vector<SgTemplateArgument*> tempargs=  ((SgTemplateInstantiationDecl*)node)->get_templateArguments();
								foreach (SgTemplateArgument* element, tempargs){
									SgTemplateArgument* temparg = isSgTemplateArgument(element);
									if(temparg){
										delete temparg;
									}
									printf("SgTemplateArg in Memory Pool traversal\n");
								}*/
								delete node;
								//printf("SgTemplateInstantiationDecl in Memory Pool traversal\n");
							}
						}
					}
				}
			}
		}

		void visit(SgThisExp* node)
		{
			if (SgClassSymbolPtr !=NULL){
				SgSymbol* s = node->get_class_symbol();
				if (s == SgClassSymbolPtr) SgClassDeclaration_count++;
			}
		}

		void visit(SgClassNameRefExp* node)
		{
			if (SgClassSymbolPtr !=NULL){
				SgSymbol* s = node->get_symbol();
				if (isSgClassSymbol(s) == SgClassSymbolPtr) SgClassDeclaration_count++;
			}
		}


		int get_num_Class_pointers(){return SgClassDeclaration_count;}


	// SgMemberFunctionSymbol
		void visit(SgCtorInitializerList* node)
		{
			if(memFunc !=NULL){
				SgMemberFunctionDeclaration * func= (SgMemberFunctionDeclaration*) (node->get_parent());
				if(func == memFunc){
					delete node;
				}
			}
		}


		void visit(SgMemberFunctionDeclaration* node)
		{
			if (SgMemFuncSymbolPtr !=NULL){
				if(node->get_scope()!=NULL){
					if(node->get_scope()->get_symbol_table()!=NULL){
						SgSymbol* symbol = ((SgMemberFunctionDeclaration*)node)->get_symbol_from_symbol_table();
						if(symbol == SgMemFuncSymbolPtr){
							SgMemFuncSymbol_count++;
						}
					}
				}
			}
		}

		void visit(SgTemplateInstantiationMemberFunctionDecl* node)
		{
			if (SgMemFuncSymbolPtr !=NULL){
				if(node->get_scope()!=NULL){
					if(node->get_scope()->get_symbol_table()!=NULL){
						SgSymbol* symbol = ((SgTemplateInstantiationMemberFunctionDecl*)node)->get_symbol_from_symbol_table();
						if(symbol == SgMemFuncSymbolPtr){
							SgMemFuncSymbol_count++;
						}
					}
				}
			}
		}



		int get_num_memFunc_pointers(){return SgMemFuncSymbol_count;}


	// SgTypedefSymbol
		void visit(SgTypedefDeclaration* node)
		{
			if(SgTypedefPtr!=NULL){
				if(node->get_scope()!=NULL){
					if(node->get_scope()->get_symbol_table()!=NULL){
						SgSymbol* s = ((SgTypedefDeclaration*)node)->get_symbol_from_symbol_table();
						if ((SgTypedefSymbol *)s == SgTypedefPtr) SgTypedefSymbol_count++;
					}
				}
			}
			if(typedef_defining!=NULL){
				SgDeclarationStatement * typedef_define = ((SgDeclarationStatement*)node)->get_definingDeclaration();
				if(typedef_define == typedef_defining && node != typedef_defining ) {
					delete node;
				}
			}
		}

		int get_num_Typedef_pointers(){return SgTypedefSymbol_count;}



		void visit(SgTemplateDeclaration* node)
		{
			if (SgTemplateSymbolPtr !=NULL){
				if(node->get_scope()!=NULL){
					if(node->get_scope()->get_symbol_table()!=NULL){
						SgSymbol* symbol = ((SgTemplateDeclaration*)node)->get_symbol_from_symbol_table();
						if(symbol == SgTemplateSymbolPtr){
							SgTemplateSymbol_count++;
						}
					}
				}
			}

			if(template_defining !=NULL) {
				if(node->get_scope()!=NULL){
					if(node->get_scope()->get_symbol_table()!=NULL){
						if(node->get_symbol_from_symbol_table() == NULL){
							SgDeclarationStatement * template_decl = ((SgDeclarationStatement*)node)->get_firstNondefiningDeclaration();
							SgDeclarationStatement * template_decl1 = ((SgDeclarationStatement*)node)->get_definingDeclaration();
							if((template_decl==template_defining||template_decl1==template_defining) && node!=template_defining) {
								delete node;

							}
						}
					}
				}
			}
		}

		int get_num_Template_pointers(){return SgTemplateSymbol_count;}

	};


	//Tan August,25,2010 //Traverse AST in post order, delete nodes and their symbols if it's safe to do so
	class DeleteAST : public SgSimpleProcessing,  ROSE_VisitTraversal
		{
			public:

			void visit (SgNode* node)
			{
			//These nodes are manually deleted because they cannot be visited by the traversal
				/*////////////////////////////////////////////////
				/remove SgVariableDefinition, SgVariableSymbol and SgEnumFieldSymbol
				/////////////////////////////////////////////////*/

				if(isSgInitializedName(node) !=NULL){
					//remove SgVariableDefinition
					SgDeclarationStatement* var_def;
					var_def =  ((SgInitializedName *)node)->get_definition();
					if(isSgVariableDefinition(var_def) !=NULL){
						delete var_def;
						//printf("A SgVariableDefinition was deleted\n");
					}


					//remove SgVariableSymbol
					if(isSgInitializedName(node)->get_scope()!=NULL){
						if(isSgInitializedName(node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgInitializedName *)node)->get_symbol_from_symbol_table();
							if(isSgVariableSymbol(symbol) !=NULL){
								ClassicVisitor visitor((SgVariableSymbol*)symbol);
								traverseMemoryPoolVisitorPattern(visitor);
								if(visitor.get_num_variable_pointers()==1){ //only one reference to this symbol => safe to delete
								((SgInitializedName*)node)->get_scope()->get_symbol_table()->remove(symbol);
									delete symbol;
									//printf("A SgVariableSymbol was deleted\n");
								}
							}

							if(isSgEnumFieldSymbol(symbol) !=NULL){
								ClassicVisitor visitor((SgEnumFieldSymbol*)symbol);
								traverseMemoryPoolVisitorPattern(visitor);
								if(visitor.get_num_EnumField_pointers()==1){
									((SgInitializedName*)node)->get_scope()->get_symbol_table()->remove(symbol);
									delete symbol;
									//printf("A SgEnumFieldSymbol was deleted\n");
								}
							}

						}
					}
				}

				if(isSgVarRefExp(node) !=NULL){
						SgVariableSymbol *symbol = ((SgVarRefExp*)node)->get_symbol();
						ClassicVisitor visitor(symbol);
						traverseMemoryPoolVisitorPattern(visitor);
						if(visitor.get_num_variable_pointers()==1){ //only one reference to this symbol => safe to delete
							//((SgSymbol*)symbol)->get_scope()->get_symbol_table()->remove(symbol);
							delete symbol;
							//printf("A SgVariableSymbol was deleted\n");
						}
				}

				/*////////////////////////////////////////////////
				/remove SgFunctionSymbol
				/////////////////////////////////////////////////*/

				if(isSgFunctionDeclaration(node) && isSgMemberFunctionDeclaration(node)==NULL){
					if(isSgFunctionDeclaration(node)->get_scope()!=NULL){
						if(isSgFunctionDeclaration(node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgFunctionDeclaration*)node)->get_symbol_from_symbol_table();
							ClassicVisitor visitor((SgFunctionSymbol *)symbol);
							traverseMemoryPoolVisitorPattern(visitor);
							if(visitor.get_num_Function_pointers()==1){ //only one reference to this FunctionSymbol => safe to delete
								((SgFunctionDeclaration*)node)->get_scope()->get_symbol_table()->remove(symbol);
								delete symbol;
								//printf("A SgFunctionSymbol was deleted\n");
							}
							ClassicVisitor visitor1((SgFunctionDeclaration *)node);
							traverseMemoryPoolVisitorPattern(visitor1);
						}
					}
				}


				if(isSgFunctionRefExp(node) !=NULL){
						SgFunctionSymbol *symbol = ((SgFunctionRefExp*)node)->get_symbol_i();
						ClassicVisitor visitor(symbol);
						traverseMemoryPoolVisitorPattern(visitor);
						if(visitor.get_num_Function_pointers()==1){ //only one reference to this FunctionSymbol => safe to delete
							//((SgSymbol*)symbol)->get_scope()->get_symbol_table()->remove(symbol);
							delete symbol;
							//printf("A SgFunctionSymbol was deleted\n");
						}

				}

				if(isSgUserDefinedBinaryOp(node) !=NULL){
					SgFunctionSymbol *symbol = ((SgUserDefinedBinaryOp*)node)->get_symbol();
					ClassicVisitor visitor(symbol);
					traverseMemoryPoolVisitorPattern(visitor);
					if(visitor.get_num_Function_pointers()==1){ //only one reference to this FunctionSymbol => safe to delete
						((SgSymbol*)symbol)->get_scope()->get_symbol_table()->remove(symbol);
						delete symbol;
						//printf("A SgFunctionSymbol was deleted\n");
					}
				}

				/*////////////////////////////////////////////////
				/remove SgTypedefSymbol
				/////////////////////////////////////////////////*/

				if(isSgTypedefDeclaration(node) !=NULL){
					if(((SgTypedefDeclaration*)node)->get_scope()!=NULL){
						if(((SgTypedefDeclaration*)node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgTypedefDeclaration*)node)->get_symbol_from_symbol_table();
							if(isSgTypedefSymbol(symbol)){
								ClassicVisitor visitor((SgTypedefSymbol*) symbol);
								traverseMemoryPoolVisitorPattern(visitor);
								if(visitor.get_num_Typedef_pointers()==1){ //only one reference to this SgTypedefSymbol  => safe to delete
									((SgTypedefDeclaration*)node)->get_scope()->get_symbol_table()->remove(symbol);
									delete symbol;
									//printf("A SgTypedefSymbol was deleted\n");
								}
							}
						}
					}

					if(node == isSgTypedefDeclaration(node)->get_definingDeclaration()){
						ClassicVisitor visitor1((SgTypedefDeclaration*) node);
						traverseMemoryPoolVisitorPattern(visitor1);
					}
				}

				/*////////////////////////////////////////////////
				/remove SgNamespaceDeclarationSymbol
				/////////////////////////////////////////////////*/

				if(isSgNamespaceDeclarationStatement(node) !=NULL){
					if(((SgNamespaceDeclarationStatement*)node)->get_scope()!=NULL){
						if(((SgNamespaceDeclarationStatement*)node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgNamespaceDeclarationStatement*)node)->get_symbol_from_symbol_table();
							if(isSgNamespaceSymbol(symbol)){
								((SgNamespaceDeclarationStatement*)node)->get_scope()->get_symbol_table()->remove(symbol);
								delete symbol;
								//printf("A SgNamespaceSymbol was deleted\n");
							}
						}
					}
				}


				if(isSgNamespaceAliasDeclarationStatement(node) !=NULL){
					if(((SgNamespaceAliasDeclarationStatement*)node)->get_scope()!=NULL){
						if(((SgNamespaceAliasDeclarationStatement*)node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgNamespaceAliasDeclarationStatement*)node)->get_symbol_from_symbol_table();
							if(isSgNamespaceSymbol(symbol)){
								((SgNamespaceAliasDeclarationStatement*)node)->get_scope()->get_symbol_table()->remove(symbol);
								delete symbol;
								//printf("A SgNamespaceSymbol was deleted\n");
							}
						}
					}
				}


				/*////////////////////////////////////////////////
				/remove SgLabelSymbol
				/////////////////////////////////////////////////*/

				if(isSgLabelStatement(node) !=NULL){
					if(((SgLabelStatement*)node)->get_scope()!=NULL){
						if(((SgLabelStatement*)node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgLabelStatement*)node)->get_symbol_from_symbol_table();
							if(isSgLabelSymbol(symbol)){
								((SgLabelStatement*)node)->get_scope()->get_symbol_table()->remove(symbol);
								delete symbol;
								//printf("A SgLabelSymbol was deleted\n");
							}
						}
					}
				}

				if(isSgLabelRefExp(node) !=NULL){
					SgLabelSymbol* symbol = ((SgLabelRefExp*)node)->get_symbol();
					((SgSymbol*)symbol)->get_scope()->get_symbol_table()->remove(symbol);
					delete symbol;
					//printf("A SgLabelSymbol was deleted\n");
				}


				/*////////////////////////////////////////////////
				/remove SgEnumSymbol
				/////////////////////////////////////////////////*/

				if(isSgEnumDeclaration(node) !=NULL){
					if(((SgEnumDeclaration*)node)->get_scope()!=NULL){
						if(((SgEnumDeclaration*)node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgEnumDeclaration*)node)->get_symbol_from_symbol_table();
							if(isSgEnumSymbol(symbol) !=NULL){
								((SgSymbol*)symbol)->get_scope()->get_symbol_table()->remove(symbol);
								delete symbol;
								//printf("A SgEnumSymbol was deleted\n");
							}
						}
					}
					SgEnumType* type= ((SgEnumDeclaration*)node)->get_type();
					if(type !=NULL){
							delete type;
							//printf("A SgEnumType was deleted\n");
					}
				}


				/*////////////////////////////////////////////////
				/remove SgClassSymbol
				/////////////////////////////////////////////////*/

				if(isSgClassDeclaration(node) !=NULL && isSgTemplateInstantiationDecl(node) ==NULL){
					if(((SgClassDeclaration*)node)->get_scope()!=NULL){
						if(((SgClassDeclaration*)node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgClassDeclaration*)node)->get_symbol_from_symbol_table();
							if(isSgClassSymbol(symbol) !=NULL){
								ClassicVisitor visitor((SgClassSymbol*)symbol);
								traverseMemoryPoolVisitorPattern(visitor);
								if(visitor.get_num_Class_pointers()==1){ //only one reference to this symbol => safe to delete
									((SgClassDeclaration*)node)->get_scope()->get_symbol_table()->remove(symbol);
									delete symbol;
									//printf("A SgClassSymbol was deleted\n");
								}
							}
						}
					}

					ClassicVisitor visitor((SgClassDeclaration*) node );
					traverseMemoryPoolVisitorPattern(visitor);

					SgClassType* type= ((SgClassDeclaration*)node)->get_type();
					if(type !=NULL){
						delete type;
						//printf("A SgClassType was deleted\n");
					}
				}

				if(isSgThisExp(node) !=NULL){
					SgSymbol* symbol = ((SgThisExp*)node)->get_class_symbol();
					ClassicVisitor visitor((SgClassSymbol*)symbol);
					traverseMemoryPoolVisitorPattern(visitor);
					if(visitor.get_num_Class_pointers()==1){ //only one reference to this symbol => safe to delete
						((SgSymbol*)symbol)->get_scope()->get_symbol_table()->remove(symbol);
						delete symbol;
						//printf("A SgClassSymbol was deleted\n");
					}

				}

				if(isSgClassNameRefExp(node) !=NULL){
					SgSymbol* symbol = ((SgClassNameRefExp*)node)->get_symbol();
					if(isSgClassSymbol(symbol) !=NULL)
					{
						ClassicVisitor visitor((SgClassSymbol*)symbol);
						traverseMemoryPoolVisitorPattern(visitor);
						if(visitor.get_num_Class_pointers()==1){ //only one reference to this symbol => safe to delete
							((SgSymbol*)symbol)->get_scope()->get_symbol_table()->remove(symbol);
							delete symbol;
							//printf("A SgClassSymbol was deleted\n");
						}
					}
				}

				/*////////////////////////////////////////////////
				/remove SgMemberFunctionSymbol
				/////////////////////////////////////////////////*/


				if(isSgMemberFunctionDeclaration(node) !=NULL){
				   	if(((SgMemberFunctionDeclaration*)node)->get_scope()!=NULL){
						if(((SgMemberFunctionDeclaration*)node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgMemberFunctionDeclaration*)node)->get_symbol_from_symbol_table();
							if(isSgMemberFunctionSymbol(symbol)){
								ClassicVisitor visitor((SgMemberFunctionSymbol*)symbol);
								traverseMemoryPoolVisitorPattern(visitor);
								if(visitor.get_num_memFunc_pointers()==1){
									((SgMemberFunctionDeclaration*)node)->get_scope()->get_symbol_table()->remove(symbol);
									delete symbol;
									//printf("A SgMemberFunctionSymbol was deleted\n");
								}
							}
						}
					}
					ClassicVisitor visitor((SgMemberFunctionDeclaration*) node);
					traverseMemoryPoolVisitorPattern(visitor);

				}
//Tan: I have no idea why the codes below cannot work. Perhaps it conflicts with some prior works
#if 0
				if(isSgMemberFunctionRefExp(node) !=NULL){
					SgMemberFunctionSymbol* symbol = ((SgMemberFunctionRefExp*)node)->get_symbol_i();
					ClassicVisitor visitor(symbol);
					traverseMemoryPoolVisitorPattern(visitor);
					if(visitor.get_num_memFunc_pointers()==1){ //only one reference to this symbol => safe to delete
						((SgSymbol*)symbol)->get_scope()->get_symbol_table()->remove(symbol);
						delete symbol;
						//printf("A SgClassSymbol was deleted\n");
					}

				}

				if(isSgFunctionType(node) !=NULL){
					SgSymbol* symbol = ((SgFunctionType*)node)->get_symbol_from_symbol_table();
					if(isSgFunctionTypeSymbol(symbol)){
						((SgSymbol*)symbol)->get_scope()->get_symbol_table()->remove(symbol);
						delete symbol;
						//printf("A SgFunctionTypeSymbol was deleted\n");
					}
				}
#endif

                                /*////////////////////////////////////////////////
                                /remove SgInterfaceSymbol and SgModuleSymbol
                                /////////////////////////////////////////////////*/

				if(isSgInterfaceStatement(node) !=NULL){
					if(((SgDeclarationStatement*)node)->get_scope()!=NULL){
						if(((SgDeclarationStatement*)node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgDeclarationStatement*)node)->get_symbol_from_symbol_table();
							if(isSgInterfaceSymbol(symbol)){
								((SgDeclarationStatement*)node)->get_scope()->get_symbol_table()->remove(symbol);
								delete symbol;
								//printf("A SgInterfaceSymbol was deleted\n");
							}
						}
					}

				}


				if(isSgModuleStatement(node) !=NULL){
					if(((SgClassDeclaration*)node)->get_scope()!=NULL){
						if(((SgClassDeclaration*)node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgClassDeclaration*)node)->get_symbol_from_symbol_table();
							if(isSgModuleSymbol(symbol)){
								((SgClassDeclaration*)node)->get_scope()->get_symbol_table()->remove(symbol);
								delete symbol;
								//printf("A SgModuleSymbol was deleted\n");
							}
						}
					}

				}


//Tan: I got stuck in deleting the SgTemplateArgument
#if 0
				if(isSgTemplateInstantiationMemberFunctionDecl(node) !=NULL){
				   	if(((SgTemplateInstantiationMemberFunctionDecl*)node)->get_scope()!=NULL){
						if(((SgTemplateInstantiationMemberFunctionDecl*)node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgTemplateInstantiationMemberFunctionDecl*)node)->get_symbol_from_symbol_table();
							if(isSgMemberFunctionSymbol(symbol)){
								ClassicVisitor visitor((SgMemberFunctionSymbol*)symbol);
								traverseMemoryPoolVisitorPattern(visitor);
								if(visitor.get_num_memFunc_pointers()==1){
									((SgMemberFunctionDeclaration*)node)->get_scope()->get_symbol_table()->remove(symbol);
									delete symbol;
									//printf("A SgMemberFunctionSymbol was deleted\n");
								}
							}
						}
					}
					ClassicVisitor visitor((SgMemberFunctionDeclaration*) node);
					traverseMemoryPoolVisitorPattern(visitor);
				}

				if(isSgTemplateDeclaration(node) !=NULL){
					if(((SgTemplateDeclaration*)node)->get_scope()!=NULL){
						if(((SgTemplateDeclaration*)node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgTemplateDeclaration*)node)->get_symbol_from_symbol_table();
							ClassicVisitor visitor((SgTemplateSymbol*)symbol);
							traverseMemoryPoolVisitorPattern(visitor);
							if(visitor.get_num_Template_pointers()==1){
									((SgTemplateDeclaration*)node)->get_scope()->get_symbol_table()->remove(symbol);
									delete symbol;
									printf("A SgTemplateSymbol was deleted\n");
							}
						}
					}
 					//if(isSgTemplateDeclaration(node) == ((SgTemplateDeclaration*)node)->get_firstNondefiningDeclaration()){
 						ClassicVisitor visitor1((SgTemplateDeclaration*) node );
 						traverseMemoryPoolVisitorPattern(visitor1);
 					//}

				}

				if(isSgInterfaceStatement(node) !=NULL){
					if(((SgDeclarationStatement*)node)->get_scope()!=NULL){
						if(((SgDeclarationStatement*)node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgDeclarationStatement*)node)->get_symbol_from_symbol_table();
							if(isSgInterfaceSymbol(symbol)){
								((SgDeclarationStatement*)node)->get_scope()->get_symbol_table()->remove(symbol);
								delete symbol;
								//printf("A SgInterfaceSymbol was deleted\n");
							}
						}
					}

				}


				if(isSgModuleStatement(node) !=NULL){
					if(((SgClassDeclaration*)node)->get_scope()!=NULL){
						if(((SgClassDeclaration*)node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgClassDeclaration*)node)->get_symbol_from_symbol_table();
							if(isSgModuleSymbol(symbol)){
								((SgClassDeclaration*)node)->get_scope()->get_symbol_table()->remove(symbol);
								delete symbol;
								//printf("A SgModuleSymbol was deleted\n");
							}
						}
					}

				}

				if(isSgTemplateInstantiationDecl(node) !=NULL){
					if(((SgTemplateInstantiationDecl*)node)->get_scope()!=NULL){
						if(((SgTemplateInstantiationDecl*)node)->get_scope()->get_symbol_table()!=NULL){
							SgSymbol* symbol = ((SgTemplateInstantiationDecl*)node)->get_symbol_from_symbol_table();
							if(isSgClassSymbol(symbol)){
 								ClassicVisitor visitor((SgClassSymbol*)symbol);
 								traverseMemoryPoolVisitorPattern(visitor);
 								if(visitor.get_num_Class_pointers()==1){
 									((SgClassDeclaration*)node)->get_scope()->get_symbol_table()->remove(symbol);
 									delete symbol;
 								}
							}
						}
					}
					SgClassType* type= ((SgClassDeclaration*)node)->get_type();
					if(type !=NULL){
						delete type;
						//printf("A SgClassType was deleted\n");
					}

 					vector<SgTemplateArgument*> tempargs=  ((SgTemplateInstantiationDecl*)node)->get_templateArguments();
 					foreach (SgTemplateArgument* element, tempargs){
 						SgTemplateArgument* temparg = isSgTemplateArgument(element);
 						if(temparg){
							delete temparg;
						}
						printf("SgTemplateArg in normal traversal\n");
 					}
					printf("SgTemplateInstantiationDecl in normal traversal\n");

					ClassicVisitor visitor((SgTemplateInstantiationDecl*) node);
					traverseMemoryPoolVisitorPattern(visitor);
				}

#endif

			//Normal nodes  will be removed in a post-order way
			delete node;
			}
		};


     	  DeleteAST deleteTree;

          // Deletion must happen in post-order to avoid traversal of (visiting) deleted IR nodes
          deleteTree.traverse(n,postorder);
   }


void
SageInterface::moveStatementsBetweenBlocks ( SgBasicBlock* sourceBlock, SgBasicBlock* targetBlock )
   {
  // This function moves statements from one block to another (used by the outliner).
  // printf ("***** Moving statements from sourceBlock %p to targetBlock %p ***** \n",sourceBlock,targetBlock);
    ROSE_ASSERT (sourceBlock && targetBlock);
    if (sourceBlock == targetBlock)
    {
      cerr<<"warning: SageInterface::moveStatementsBetweenBlocks() is skipped, "<<endl;
      cerr<<"         since program is trying to move statements from and to the identical basic block. "<<endl;
      return;
    }

     SgStatementPtrList & srcStmts = sourceBlock->get_statements();

//     cout<<"debug SageInterface::moveStatementsBetweenBlocks() number of stmts = "<< srcStmts.size() <<endl;
     for (SgStatementPtrList::iterator i = srcStmts.begin(); i != srcStmts.end(); i++)
        {
          // append statement to the target block
          targetBlock->append_statement(*i);

       // Make sure that the parents are set.
          ROSE_ASSERT((*i)->get_parent() == targetBlock);
          if ((*i)->hasExplicitScope())
             {
            // DQ (3/4/2009): This fails the test in ROSE/tutorial/outliner/inputCode_OutlineNonLocalJumps.cc
            // I am unclear if this is a reasonable constraint, it passes all tests but this one!
               if ((*i)->get_scope() != targetBlock)
                  {
                    if (SgFunctionDeclaration* func = isSgFunctionDeclaration(*i)) 
                    { // A call to a undeclared function will introduce a hidden func prototype declaration in the enclosing scope .
                      // The func declaration should be moved along with the call site.
                      // The scope should be set to the new block also
                      // Liao 1/14/2011
                      if (func->get_firstNondefiningDeclaration() == func);
                        func->set_scope(targetBlock);
                    }
                    else
                    {
                      //(*i)->set_scope(targetBlock);
                      printf ("Warning: test failing (*i)->get_scope() == targetBlock in SageInterface::moveStatementsBetweenBlocks() \n");
                      cerr<<"  "<<(*i)->class_name()<<endl;
                    }
                  }
               //ROSE_ASSERT((*i)->get_scope() == targetBlock);
             }

          SgDeclarationStatement* declaration = isSgDeclarationStatement(*i);
          if (declaration != NULL)
             {
            // Need to reset the scope from sourceBlock to targetBlock.
               switch(declaration->variantT())
                  {
                 // There will be other cases to handle, but likely not all declaration will be possible to support.

                    case V_SgVariableDeclaration:
                       {
                      // Reset the scopes on any SgInitializedName objects.
                         SgVariableDeclaration* varDecl = isSgVariableDeclaration(declaration);
                         SgInitializedNamePtrList & l = varDecl->get_variables();
                         for (SgInitializedNamePtrList::iterator i = l.begin(); i != l.end(); i++)
                            {
                           // reset the scope, but make sure it was set to sourceBlock to make sure.
                           // This might be an issue for extern variable declaration that have a scope
                           // in a separate namespace of a static class member defined external to
                           // its class, etc. I don't want to worry about those cases right now.
                              ROSE_ASSERT((*i)->get_scope() == sourceBlock);

                              (*i)->set_scope(targetBlock);
                            }
                         break;
                       }
                     case V_SgFunctionDeclaration: // Liao 1/15/2009, I don't think there is any extra things to do here
                       {
                         SgFunctionDeclaration * funcDecl = isSgFunctionDeclaration(declaration);
                         ROSE_ASSERT (funcDecl);
                         //cout<<"found a function declaration to be moved ..."<<endl;
                       }
                     break;
                     case V_SgFortranIncludeLine:
                       break;
                    default:
                       {
                         printf ("Moving this declaration = %p = %s = %s between blocks is not yet supported \n",declaration,declaration->class_name().c_str(),get_name(declaration).c_str());
                         declaration->get_file_info()->display("file info");
                         ROSE_ASSERT(false);
                       }
                }
             } // end if
        } // end for

  // Remove the statements in the sourceBlock
     srcStmts.clear();
     ROSE_ASSERT(srcStmts.empty() == true);
     ROSE_ASSERT(sourceBlock->get_statements().empty() == true);

  // Move the symbol table
     ROSE_ASSERT(sourceBlock->get_symbol_table() != NULL);
     targetBlock->set_symbol_table(sourceBlock->get_symbol_table());

     ROSE_ASSERT(sourceBlock != NULL);
     ROSE_ASSERT(targetBlock != NULL);
     ROSE_ASSERT(targetBlock->get_symbol_table() != NULL);
     ROSE_ASSERT(sourceBlock->get_symbol_table() != NULL);
     targetBlock->get_symbol_table()->set_parent(targetBlock);

     ROSE_ASSERT(sourceBlock->get_symbol_table() != NULL);
     sourceBlock->set_symbol_table(NULL);
     // Liao 2/4/2009
     // Finally , move preprocessing information attached inside the source block to the target block
     // Outliner uses this function to move a code block to the outlined function.
     // This will ensure that a trailing #endif (which is attached inside the source block) will be moved
     // to the target block to match #if (which is attached
     // before some statement moved to the target block)
     moveUpPreprocessingInfo (targetBlock, sourceBlock, PreprocessingInfo::inside);
   }


//! Variable references can be introduced by SgVarRef, SgPntrArrRefExp, SgInitializedName, SgMemberFunctionRef etc. This function will convert them all to  a top level SgInitializedName.
//TODO consult  AstInterface::IsVarRef() for more cases
SgInitializedName* SageInterface::convertRefToInitializedName(SgNode* current)
{
  SgInitializedName* name = NULL;
  SgExpression* nameExp = NULL;
  ROSE_ASSERT(current != NULL);
  if (isSgInitializedName(current))
  {
    name = isSgInitializedName(current);
  }
  else if (isSgPntrArrRefExp(current))
  {
    bool suc=false;
    suc= SageInterface::isArrayReference(isSgExpression(current),&nameExp);
    ROSE_ASSERT(suc == true);
     // has to resolve this recursively
    return convertRefToInitializedName(nameExp);
  }
  else if (isSgVarRefExp(current))
  {
    SgNode* parent = current->get_parent();
    if (isSgDotExp(parent))
    {
       if (isSgDotExp(parent)->get_rhs_operand() == current)
        return convertRefToInitializedName(parent);
    }
    else if(isSgArrowExp(parent))
    {
      if (isSgArrowExp(parent)->get_rhs_operand() == current)
        return convertRefToInitializedName(parent);
    }
    name = isSgVarRefExp(current)->get_symbol()->get_declaration();
  }
  else if (isSgDotExp(current))
  {
    SgExpression* lhs = isSgDotExp(current)->get_lhs_operand();
    ROSE_ASSERT(lhs);
     // has to resolve this recursively
    return convertRefToInitializedName(lhs);
  }
   else if (isSgArrowExp(current))
  {
    SgExpression* lhs = isSgArrowExp(current)->get_lhs_operand();
    ROSE_ASSERT(lhs);
     // has to resolve this recursively
    return convertRefToInitializedName(lhs);
  } // The following expression types are usually introduced by left hand operands of DotExp, ArrowExp
  else if (isSgPointerDerefExp(current))
  {
    return convertRefToInitializedName(isSgPointerDerefExp(current)->get_operand());
  }
  else if (isSgCastExp(current))
  {
    return convertRefToInitializedName(isSgCastExp(current)->get_operand());
  }
 else
  {
    cerr<<"In SageInterface::convertRefToInitializedName(): unhandled reference type:"<<current->class_name()<<endl;
    ROSE_ASSERT(false);
  }
  ROSE_ASSERT(name != NULL);
  return name;
}

//! Obtain a matching SgNode from an abstract handle string
SgNode* SageInterface::getSgNodeFromAbstractHandleString(const std::string& input_string)
{
  AbstractHandle::abstract_handle * project_handle = buildAbstractHandle(getProject());

  // trim off the possible leading handle for project: "Project<numbering,1>::"
  size_t pos = input_string.find("SourceFile<");
  ROSE_ASSERT (pos != string::npos);
  string trimed_string = input_string.substr(pos);
  AbstractHandle::abstract_handle * handle = new AbstractHandle::abstract_handle(project_handle, trimed_string);
  if (handle)
  {
    if (handle->getNode()!=NULL)
    {
#ifdef _MSC_VER
     // DQ (11/28/2009): This is related to the use of covariant return types (I think).
SgNode* result = NULL; // (SgNode*)(handle->getNode()->getNode());
#pragma message ("WARNING: covariant return type for get_node() not supported in MSVC.")
		printf ("ERROR: covariant return type for get_node() not supported in MSVC. \n");
		ROSE_ASSERT(false);
#else
		SgNode* result = (SgNode*)(handle->getNode()->getNode());
#endif
      // deallocate memory, should not do this!!
      // May corrupt the internal std maps used in abstract handle namespace
      //delete handle->getNode();
      //delete handle;
      return result;
    }
  }
  return NULL;
}


//! Dump information about a SgNode for debugging
// unparseToString() is too strict for debugging purpose
//  we provide this instead.
void SageInterface::dumpInfo(SgNode* node, std::string desc/*=""*/)
{
  ROSE_ASSERT(node != NULL);
  cout<<desc<<endl;
  // base information for all SgNode:
  cout<<"///////////// begin of SageInterface::dumpInfo() ///////////////"<<endl;
  cout<<"--------------base info. for SgNode---------------"<<endl;
  cout<<node<<" "<<node->class_name()<<endl;
  SgLocatedNode* snode = isSgLocatedNode(node);
  if (snode)
  {
    // source file info. dump
    cout<<"--------------source location info. for SgNode---------------"<<endl;
    cout<<snode->get_file_info()->get_filename()
      << ":"<<snode->get_file_info()->get_line()<<"-"
      << snode->get_file_info()->get_col()<<endl;
    // preprocessing info dump
    AttachedPreprocessingInfoType *comments = snode->getAttachedPreprocessingInfo ();
    if (comments)
    {
      cout<<"--------------preprocessing info. for SgNode---------------"<<endl;
      AttachedPreprocessingInfoType::iterator i;
      cout<<"Total attached preprocessingInfo count="<<comments->size()<<endl;
      for (i = comments->begin (); i != comments->end (); i++)
      {
        PreprocessingInfo * pinfo = *i;
        pinfo->display("");
      }
    }
    cout<<"--------------name info. for SgNode---------------"<<endl;
    // print out namea for named nodes
    SgFunctionDeclaration * decl = isSgFunctionDeclaration(snode);
    if (decl)
      cout<<"\tqualified name="<<decl->get_qualified_name().getString()<<endl;
    SgVarRefExp * varRef =  isSgVarRefExp(snode);
    if (varRef)
      cout<<"\treferenced variable name= "<<varRef->get_symbol()->get_name().getString()<<endl;
  }
  SgInitializedName * iname = isSgInitializedName(snode);
  if (iname)
    cout<<"\tvariable name= "<<iname->get_qualified_name().getString()<<endl;

  cout<<endl;
  cout<<"///////////// end of SageInterface::dumpInfo() ///////////////"<<endl;
}

//! Collect all read and write references within stmt, which can be a function, a scope statement, or a single statement. Note that a reference can be both read and written, like i++
//! This is a wrapper function to Qing's side effect analysis from loop optimization
//! Liao, 2/26/2009
bool
SageInterface::collectReadWriteRefs(SgStatement* stmt, std::vector<SgNode*>& readRefs, std::vector<SgNode*>& writeRefs)
{   // The type cannot be SgExpression since variable declarations have SgInitializedName as the reference, not SgVarRefExp.
  ROSE_ASSERT(stmt !=NULL);

  // We should allow accumulate the effects for multiple statements
  // ROSE_ASSERT(readRefs.size() == 0);
  // ROSE_ASSERT(writeRefs.size() == 0);

  // convert a request for a defining function declaration to its function body
  SgFunctionDeclaration* funcDecl = isSgFunctionDeclaration(stmt);
  if (funcDecl != NULL)
  {
    funcDecl= isSgFunctionDeclaration(funcDecl->get_definingDeclaration ());
    if (funcDecl == NULL)
    {
      cerr<<"In collectReadWriteRefs(): cannot proceed without a function body!"<<endl;
    }
    stmt = funcDecl->get_definition()->get_body();
  }

  // get function level information
  SgFunctionDefinition* funcDef = SageInterface::getEnclosingFunctionDefinition(stmt);
  ROSE_ASSERT(funcDef != NULL);
  SgBasicBlock* funcBody = funcDef->get_body();
  ROSE_ASSERT(funcBody!= NULL);

  // prepare Loop transformation environment
  AstInterfaceImpl faImpl(funcBody);
  AstInterface fa(&faImpl);
  ArrayAnnotation* annot = ArrayAnnotation::get_inst();
  ArrayInterface array_interface (*annot);
  array_interface.initialize(fa, AstNodePtrImpl(funcDef));
  array_interface.observe(fa);
  LoopTransformInterface * lpTrans = new LoopTransformInterface(fa, array_interface);

  // variables to store results
  DoublyLinkedListWrap<AstNodePtr> rRef1, wRef1;
  CollectDoublyLinkedList<AstNodePtr> crRef1(rRef1),cwRef1(wRef1);
  AstNodePtr s1 = AstNodePtrImpl(stmt);

  // Actual side effect analysis
  if (!AnalyzeStmtRefs(*lpTrans, s1, cwRef1, crRef1))
  {
    cerr<<"error in side effect analysis!"<<endl;
    return false;
  }

  // transfer results into STL containers.
  for (DoublyLinkedEntryWrap<AstNodePtr>* p = rRef1.First(); p != 0; )
  {
    DoublyLinkedEntryWrap<AstNodePtr>* p1 = p;
    p = rRef1.Next(p);
    AstNodePtr cur = p1->GetEntry();
    SgNode* sgRef = AstNodePtrImpl(cur).get_ptr();
   ROSE_ASSERT(sgRef != NULL);
    readRefs.push_back(sgRef);
    //cout<<"read reference:"<<sgRef->unparseToString()<<" address "<<sgRef<<
    //    " sage type:"<< sgRef->class_name()<< endl;
  }

  for (DoublyLinkedEntryWrap<AstNodePtr>* p = wRef1.First(); p != 0; )
  {
    DoublyLinkedEntryWrap<AstNodePtr>* p1 = p;
    p = wRef1.Next(p);
    AstNodePtr cur = p1->GetEntry();
    SgNode* sgRef = AstNodePtrImpl(cur).get_ptr();
    ROSE_ASSERT(sgRef != NULL);
    writeRefs.push_back(sgRef);
  //  cout<<"write reference:"<<sgRef->unparseToString()<<" address "<<sgRef<<
  //      " sage type:"<< sgRef->class_name()<< endl;
  }
  return true;
}

//!Collect unique variables which are read or written within a statement. Note that a variable can be both read and written. The statement can be either of a function, a scope, or a single line statement.
bool SageInterface::collectReadWriteVariables(SgStatement* stmt, set<SgInitializedName*>& readVars, set<SgInitializedName*>& writeVars)
{
  ROSE_ASSERT(stmt != NULL);
  vector <SgNode* > readRefs, writeRefs;
  if (!collectReadWriteRefs(stmt, readRefs, writeRefs))
  {
    return false;
  }
  // process read references
  vector<SgNode*>::iterator iter = readRefs.begin();
  for (; iter!=readRefs.end();iter++)
  {
    SgNode* current = *iter;
    SgInitializedName* name = convertRefToInitializedName(current);
   // Only insert unique ones
#if 0   //
    vector <SgInitializedName*>::iterator iter2 = find (readVars.begin(), readVars.end(), name);
    if (iter2==readVars.end())
    {
      readVars.push_back(name);
    //  cout<<"inserting read SgInitializedName:"<<name->unparseToString()<<endl;
    }
#else
    // We use std::set to ensure uniqueness now
    readVars.insert(name);
#endif
  }
  // process write references
  vector<SgNode*>::iterator iterw = writeRefs.begin();
  for (; iterw!=writeRefs.end();iterw++)
  {
    SgNode* current = *iterw;
    SgInitializedName* name = convertRefToInitializedName(current);
   // Only insert unique ones
#if 0   //
    vector <SgInitializedName*>::iterator iter2 = find (writeVars.begin(), writeVars.end(), name);
    if (iter2==writeVars.end())
    {
      writeVars.push_back(name);
     // cout<<"inserting written SgInitializedName:"<<name->unparseToString()<<endl;
    }
#else
    // We use std::set to ensure uniqueness now
    writeVars.insert(name);
#endif
  }
  return true;
}

//!Collect read only variables within a statement. The statement can be either of a function, a scope, or a single line statement.
void SageInterface::collectReadOnlyVariables(SgStatement* stmt, std::set<SgInitializedName*>& readOnlyVars)
{
  ROSE_ASSERT(stmt != NULL);
  set<SgInitializedName*> readVars, writeVars;
   // Only collect read only variables if collectReadWriteVariables() succeeded.
  if (collectReadWriteVariables(stmt, readVars, writeVars))
  {
    // read only = read - write
    set_difference(readVars.begin(), readVars.end(),
        writeVars.begin(), writeVars.end(),
        std::inserter(readOnlyVars, readOnlyVars.begin()));
  }
}


//!Collect read only variable symbols within a statement. The statement can be either of a function, a scope, or a single line statement.
void SageInterface::collectReadOnlySymbols(SgStatement* stmt, std::set<SgVariableSymbol*>& readOnlySymbols)
{
  set<SgInitializedName*> temp;
  collectReadOnlyVariables(stmt, temp);

  for (set<SgInitializedName*>::const_iterator iter = temp.begin();
      iter!=temp.end(); iter++)
  {
    SgSymbol* symbol = (*iter)->get_symbol_from_symbol_table () ;
    ROSE_ASSERT(symbol != NULL );
    ROSE_ASSERT(isSgVariableSymbol(symbol));
    readOnlySymbols.insert(isSgVariableSymbol(symbol));
  }

}

//! Check if a variable reference is used by its address: including &a expression and foo(a) when type2 foo(Type& parameter) in C++
bool SageInterface::isUseByAddressVariableRef(SgVarRefExp* ref)
{
  bool result = false;
  ROSE_ASSERT(ref != NULL);
  ROSE_ASSERT(ref->get_parent() != NULL);
  // case 1: ref is used as an operator for & (SgAddressofOp)
  // TODO tolerate possible type casting operations in between ?
  if (isSgAddressOfOp(ref->get_parent()))
  {
    result = true;
  }
  // case 2. ref is used as a function call's parameter, and the parameter has reference type in C++
  else if ((SageInterface::is_Cxx_language())&&(isSgExprListExp(ref->get_parent())))
  {
    SgNode* grandparent = ref->get_parent()->get_parent();
    ROSE_ASSERT(grandparent);
    if (isSgFunctionCallExp(grandparent)) // Is used as a function call's parameter
    {
      // find which parameter ref is in SgExpressionPtrList
      int param_index =0;
      SgExpressionPtrList expList = isSgExprListExp(ref->get_parent())->get_expressions();
      Rose_STL_Container<SgExpression*>::const_iterator iter= expList.begin();
      for (; iter!=expList.end(); iter++)
      {
        if (*iter == ref)
          break;
        else
          param_index++;
      }
      // find the parameter type of the corresponding function declaration
      SgExpression* func_exp = isSgFunctionCallExp(grandparent)->get_function();
      ROSE_ASSERT (func_exp);
      SgFunctionRefExp * funcRef = isSgFunctionRefExp(func_exp);
      if (funcRef) // regular functions
      {
        SgFunctionDeclaration* funcDecl = isSgFunctionSymbol(funcRef->get_symbol())->get_declaration();
        SgInitializedNamePtrList nameList = funcDecl->get_args();
        //TODO tolerate typedef chains
        if (isSgReferenceType(nameList[param_index]->get_type()))
        {
          result = true;
        }
      } //It also could be a dot or arrow expression where its right hand operand is a SgMemberFunctionRefExp
      else if (isSgDotExp (func_exp) || isSgArrowExp(func_exp)) // ArrowExp TODO
      {
        SgBinaryOp* binOp = isSgBinaryOp(func_exp);
        ROSE_ASSERT (binOp);
        SgMemberFunctionRefExp* mfuncRef = isSgMemberFunctionRefExp(binOp->get_rhs_operand_i());
        ROSE_ASSERT (mfuncRef);
        SgMemberFunctionDeclaration * mfuncDecl = isSgMemberFunctionSymbol (mfuncRef->get_symbol())->get_declaration();
        ROSE_ASSERT (mfuncDecl);
        SgInitializedNamePtrList nameList = mfuncDecl->get_args();
        //TODO tolerate typedef chains
        if (isSgReferenceType(nameList[param_index]->get_type()))
        {
          result = true;
        }
      }

    }
  }
  return result;
}


//! Collect variable references involving use by address: including &a expression and foo(a) when foo(Type& parameter) in C++
void SageInterface::collectUseByAddressVariableRefs (const SgStatement* s, std::set<SgVarRefExp* >& varSetB)
{
  Rose_STL_Container <SgNode*> var_refs = NodeQuery::querySubTree (const_cast<SgStatement *> (s), V_SgVarRefExp);

  Rose_STL_Container<SgNode*>::iterator iter = var_refs.begin();
  for (; iter!=var_refs.end(); iter++)
  {
    SgVarRefExp* ref = isSgVarRefExp(*iter);
    ROSE_ASSERT(ref != NULL);
    ROSE_ASSERT(ref->get_parent() != NULL);
#if 0
    // case 1: ref is used as an operator for & (SgAddressofOp)
    // TODO tolerate possible type casting operations in between ?
    if (isSgAddressOfOp(ref->get_parent()))
    {
      varSetB.insert(ref);
    }
    // case 2. ref is used as a function call's parameter, and the parameter has reference type in C++
    else if ((SageInterface::is_Cxx_language())&&(isSgExprListExp(ref->get_parent())))
    {
      SgNode* grandparent = ref->get_parent()->get_parent();
      ROSE_ASSERT(grandparent);
      if (isSgFunctionCallExp(grandparent)) // Is used as a function call's parameter
      {
        // find which parameter ref is in SgExpressionPtrList
        int param_index =0;
        SgExpressionPtrList expList = isSgExprListExp(ref->get_parent())->get_expressions();
        Rose_STL_Container<SgExpression*>::const_iterator iter= expList.begin();
        for (; iter!=expList.end(); iter++)
        {
          if (*iter == ref)
            break;
          else
            param_index++;
        }
        // find the parameter type of the corresponding function declaration
        SgFunctionRefExp * funcRef = isSgFunctionRefExp(isSgFunctionCallExp(grandparent)->get_function());
        SgFunctionDeclaration* funcDecl = isSgFunctionSymbol(funcRef->get_symbol())->get_declaration();
        SgInitializedNamePtrList nameList = funcDecl->get_args();
        //TODO tolerate typedef chains
        if (isSgReferenceType(nameList[param_index]->get_type()))
        {
          varSetB.insert(ref);
        }
      }
    }
#endif
    if (isUseByAddressVariableRef(ref))
      varSetB.insert(ref);
  }
}
//!Call liveness analysis on an entire project
LivenessAnalysis * SageInterface::call_liveness_analysis(SgProject* project, bool debug/*=false*/)
{
  // We expect this function to be called multiple times but always return the result generated from the first execution.
  static LivenessAnalysis* liv = NULL; // one instance
  if (liv!=NULL)
    return liv;

  static DFAnalysis * defuse = NULL; // only one instance
  // Prepare def-use analysis
  if (defuse==NULL)
  {
    ROSE_ASSERT(project != NULL);
    defuse = new DefUseAnalysis(project);
  }

  ROSE_ASSERT(defuse != NULL);
  defuse->run(debug);

  if (debug)
    defuse->dfaToDOT();

  //Prepare variable liveness analysis
  liv = new LivenessAnalysis(debug,(DefUseAnalysis*)defuse);
  ROSE_ASSERT(liv != NULL);

  std::vector <FilteredCFGNode < IsDFAFilter > > dfaFunctions;
  NodeQuerySynthesizedAttributeType vars =
          NodeQuery::querySubTree(project, V_SgFunctionDefinition);
  NodeQuerySynthesizedAttributeType::const_iterator i;
  bool abortme=false;
     // run liveness analysis on each function body
  for (i= vars.begin(); i!=vars.end();++i)
  {
    SgFunctionDefinition* func = isSgFunctionDefinition(*i);
    if (debug)
    {
      std::string name = func->class_name();
      string funcName = func->get_declaration()->get_qualified_name().str();
      cout<< " .. running liveness analysis for function: " << funcName << endl;
    }
    FilteredCFGNode <IsDFAFilter> rem_source = liv->run(func,abortme);
    // propagate results to statement level
    liv->fixupStatementsINOUT(func);
    if (rem_source.getNode()!=NULL)
      dfaFunctions.push_back(rem_source);
    if (abortme)
      break;
  } // end for ()
  if(debug)
  {
    cout << "Writing out liveness analysis results into var.dot... " << endl;
    std::ofstream f2("var.dot");
    dfaToDot(f2, string("var"), dfaFunctions, (DefUseAnalysis*)defuse, liv);
    f2.close();
  }
  if (abortme) {
    cerr<<"Error: Liveness analysis is ABORTING ." << endl;
    ROSE_ASSERT(false);
  }
  return liv;
  //return !abortme;
}

//!Get liveIn and liveOut variables for a for loop
void SageInterface::getLiveVariables(LivenessAnalysis * liv, SgForStatement* loop, std::set<SgInitializedName*>& liveIns, std::set<SgInitializedName*> & liveOuts)
{
  ROSE_ASSERT(liv != NULL);
  ROSE_ASSERT(loop != NULL);
  SgForStatement *forstmt = loop;
  std::vector<SgInitializedName*> liveIns0, liveOuts0; // store the original one

  // Jeremiah's hidden constructor parameter value '2' to grab the node for forStmt's
  // Several CFG nodes are used for the same SgForStatement, only one of the is needed.
  // We have to check the full control flow graph to find all SgForStatement's nodes,
  // check the index numbers from 0 , find the one with two out edges (true, false)
  // The CFG node should have a caption like" <SgForStatement> @ 8: 1",
  // which means this is a CFG node for a for statement at source line 8, with an index 1.
  // For SgForStatement, there are 5 cfg nodes, 0 and 4 are for begin and end CFG nodes
  // 1: after init statement, 2: after test expression (the remaining one after filtering), 3: before increment
  CFGNode cfgnode(forstmt,2);
  FilteredCFGNode<IsDFAFilter> filternode= FilteredCFGNode<IsDFAFilter> (cfgnode);
  // This one does not return the one we want even its getNode returns the
  // right for statement
  //FilteredCFGNode<IsDFAFilter> filternode= FilteredCFGNode<IsDFAFilter> (forstmt->cfgForBeginning());
  ROSE_ASSERT(filternode.getNode()==forstmt);

  // Check out edges
  vector<FilteredCFGEdge < IsDFAFilter > > out_edges = filternode.outEdges();
  ROSE_ASSERT(out_edges.size()==2);
  vector<FilteredCFGEdge < IsDFAFilter > >::iterator iter= out_edges.begin();

  for (; iter!=out_edges.end();iter++)
  {
    FilteredCFGEdge < IsDFAFilter > edge= *iter;
    //SgForStatement should have two outgoing edges based on the loop condition
    // one true(going into the loop body) and one false (going out the loop)
    //x. Live-in (loop) = live-in (first-stmt-in-loop)
    if (edge.condition()==eckTrue)
    {
      SgNode* firstnode= edge.target().getNode();
      liveIns0 = liv->getIn(firstnode);
      // cout<<"Live-in variables for loop:"<<endl;
      for (std::vector<SgInitializedName*>::iterator iter = liveIns0.begin();
          iter!=liveIns0.end(); iter++)
      {
        // SgInitializedName* name = *iter;
        liveIns.insert(*iter);
        //           cout<< name->get_qualified_name().getString()<<endl;
      }
    }
    //x. live-out(loop) = live-in (first-stmt-after-loop)
    else if (edge.condition()==eckFalse)
    {
      SgNode* firstnode= edge.target().getNode();
      liveOuts0 = liv->getIn(firstnode);
      //  cout<<"Live-out variables for loop:"<<endl;
      for (std::vector<SgInitializedName*>::iterator iter = liveOuts0.begin();
          iter!=liveOuts0.end(); iter++)
      {
        // SgInitializedName* name = *iter;
        //  cout<< name->get_qualified_name().getString()<<endl;
        liveOuts.insert(*iter);
      }
    }
    else
    {
      cerr<<"Unexpected CFG out edge type for SgForStmt!"<<endl;
      ROSE_ASSERT(false);
    }
  } // end for (edges)

}

//!Recognize and collect reduction variables and operations within a C/C++ loop, following OpenMP 3.0 specification for allowed reduction variable types and operation types.
/* This code is refactored from project/autoParallelization/autoParSupport.C
  std::vector<SgInitializedName*>
  RecognizeReduction(SgNode *loop, OmpSupport::OmpAttribute* attribute, std::vector<SgInitializedName*>& candidateVars/)
  * Algorithms:
   *   for each scalar candidate which are both live-in and live-out for the loop body
   *   (We don't use liveness analysis here for simplicity)
   *    and which is not the loop invariant variable (loop index).
   *   Consider those with only 1 or 2 references
   *   1 reference
   *     the operation is one of x++, ++x, x--, --x, x binop= expr
   *   2 references belonging to the same operation
   *     operations: one of  x= x op expr,  x = expr op x (except for subtraction)
   * The reduction description from the OpenMP 3.0 specification.
   *  x is not referenced in exp
   *  expr has scalar type (no array, objects etc)
   *  x: scalar only, aggregate types (including arrays), pointer types and reference types may not appear in a reduction clause.
   *  op is not an overloaded operator, but +, *, -, &, ^ ,|, &&, ||
   *  binop is not an overloaded operator, but: +, *, -, &, ^ ,|
  */
void SageInterface::ReductionRecognition(SgForStatement* loop, std::set< std::pair <SgInitializedName*, VariantT> > & results)
{
  //x. Collect variable references of scalar types as candidates, excluding loop index
  SgInitializedName* loopindex;
  if (!(isCanonicalForLoop(loop, &loopindex)))
  {
    cerr<<"Skip reduction recognition for non-canonical for loop"<<endl;
    return;
  }
  std::set<SgInitializedName*> candidateVars; // scalar variables used within the loop
  //Store the references for each scalar variable
  std::map <SgInitializedName*, vector<SgVarRefExp* > > var_references;

  Rose_STL_Container<SgNode*> reflist = NodeQuery::querySubTree(loop, V_SgVarRefExp);
  SgStatement* lbody= loop->get_loop_body();
  ROSE_ASSERT(lbody != NULL);
  Rose_STL_Container<SgNode*>::iterator iter = reflist.begin();
  for (; iter!=reflist.end(); iter++)
  {
    SgVarRefExp* ref_exp = isSgVarRefExp(*iter);
    SgInitializedName* initname= ref_exp->get_symbol()->get_declaration();
    // candidates are of scalar types and are not the loop index variable
    // And also should be live-in:
    //        not declared locally (var_scope equal or lower than loop body )
    //        or redefined (captured by ref count)
    SgScopeStatement* var_scope = initname->get_scope();
    ROSE_ASSERT(var_scope != NULL);
    if ((isScalarType(initname->get_type())) &&(initname !=loopindex)
        && !(SageInterface::isAncestor(lbody, var_scope)||(lbody==var_scope)))
    {
      candidateVars.insert(initname);
      var_references[initname].push_back(ref_exp);
    }
  }
  //
  //Consider variables referenced at most twice
  std::set<SgInitializedName*>::iterator niter=candidateVars.begin();
  for (; niter!=candidateVars.end(); niter++)
  {
    SgInitializedName* initname = *niter;
    bool isReduction = false;
    VariantT optype;
    // referenced once only
    if (var_references[initname].size()==1)
    {
      if(getProject()->get_verbose()>1)
        cout<<"Debug: SageInterface::ReductionRecognition() A candidate used once:"<<initname->get_name().getString()<<endl;
      SgVarRefExp* ref_exp = *(var_references[initname].begin());
      SgStatement* stmt = SageInterface::getEnclosingStatement(ref_exp);
      if (isSgExprStatement(stmt))
      {
        SgExpression* exp = isSgExprStatement(stmt)->get_expression();
        SgExpression* binop = isSgBinaryOp(exp);
        if (isSgPlusPlusOp(exp)) // x++ or ++x
        { // Could have multiple reduction clause with different operators!!
          // So the variable list is associated with each kind of operator
          optype = V_SgPlusPlusOp;
          isReduction = true;
        }
        else if (isSgMinusMinusOp(exp)) // x-- or --x
        {
          optype = V_SgMinusMinusOp;
          isReduction = true;
        }
        else
        // x binop= expr where binop is one of + * - & ^ |
        // x must be on the left hand side
        if (binop!=NULL) {
          SgExpression* lhs= isSgBinaryOp(exp)->get_lhs_operand ();
          if (lhs==ref_exp)
          {
            switch (exp->variantT())
            {
              case V_SgPlusAssignOp:
                {
                  optype = V_SgPlusAssignOp;
                  isReduction = true;
                  break;
                }
              case V_SgMultAssignOp:
                {
                  optype = V_SgMultAssignOp;
                  isReduction = true;
                  break;
                }
              case V_SgMinusAssignOp:
                {
                  optype = V_SgMinusAssignOp;
                  isReduction = true;
                  break;
                }
              case V_SgAndAssignOp:
                {
                  optype = V_SgAndAssignOp;
                  isReduction = true;
                  break;
                }
              case V_SgXorAssignOp:
                {
                  optype = V_SgXorAssignOp;
                  isReduction = true;
                  break;
                }
              case V_SgIorAssignOp:
                {
                  optype = V_SgIorAssignOp;
                  isReduction = true;
                  break;
                }
              default:
                break;
            } // end
          }// end if on left side
        }
      }
    }
    // referenced twice within a same statement
    else if (var_references[initname].size()==2)
    {
      if(getProject()->get_verbose()>1)
        cout<<"Debug: A candidate used twice:"<<initname->get_name().getString()<<endl;
      SgVarRefExp* ref_exp1 = *(var_references[initname].begin());
      SgVarRefExp* ref_exp2 = *(++var_references[initname].begin());
      SgStatement* stmt = SageInterface::getEnclosingStatement(ref_exp1);
      SgStatement* stmt2 = SageInterface::getEnclosingStatement(ref_exp2);
      if (stmt != stmt2)
        continue;
      // must be assignment statement using
      //  x= x op expr,  x = expr op x (except for subtraction)
      // one reference on left hand, the other on the right hand of assignment expression
      // the right hand uses associative operators +, *, -, &, ^ ,|, &&, ||
      SgExprStatement* exp_stmt =  isSgExprStatement(stmt);
      if (exp_stmt && isSgAssignOp(exp_stmt->get_expression()))
      {
        SgExpression* assign_lhs=NULL, * assign_rhs =NULL;
        assign_lhs = isSgAssignOp(exp_stmt->get_expression())->get_lhs_operand();
        assign_rhs = isSgAssignOp(exp_stmt->get_expression())->get_rhs_operand();
        ROSE_ASSERT(assign_lhs && assign_rhs);
        // x must show up in both lhs and rhs in any order:
        //  e.g.: ref1 = ref2 op exp or ref2 = ref1 op exp
        if (((assign_lhs==ref_exp1)&&SageInterface::isAncestor(assign_rhs,ref_exp2))
            ||((assign_lhs==ref_exp2)&&SageInterface::isAncestor(assign_rhs,ref_exp1)))
        {
          // assignment's rhs must match the associative binary operations
          // +, *, -, &, ^ ,|, &&, ||
          SgBinaryOp * binop = isSgBinaryOp(assign_rhs);
          if (binop!=NULL){
            SgExpression* op_lhs = binop->get_lhs_operand();
            SgExpression* op_rhs = binop->get_rhs_operand();
            // double check that the binary expression has either ref1 or ref2 as one operand
            if( !((op_lhs==ref_exp1)||(op_lhs==ref_exp2))
                && !((op_rhs==ref_exp1)||(op_rhs==ref_exp2)))
              continue;
            bool isOnLeft = false; // true if it has form (refx op exp), instead (exp or refx)
            if ((op_lhs==ref_exp1)||   // TODO might have in between !!
                (op_lhs==ref_exp2))
              isOnLeft = true;
            switch (binop->variantT())
            {
              case V_SgAddOp:
                {
                  optype = V_SgAddOp;
                  isReduction = true;
                  break;
                }
              case V_SgMultiplyOp:
                {
                  optype = V_SgMultiplyOp;
                  isReduction = true;
                  break;
                }
              case V_SgSubtractOp: // special handle here!!
                {
                  optype = V_SgSubtractOp;
                  if (isOnLeft) // cannot allow (exp - x)a
                  {
                    isReduction = true;
                  }
                  break;
                }
              case V_SgBitAndOp:
                {
                  optype = V_SgBitAndOp;
                  isReduction = true;
                  break;
                }
              case V_SgBitXorOp:
                {
                  optype = V_SgBitXorOp;
                  isReduction = true;
                  break;
                }
              case V_SgBitOrOp:
                {
                  optype = V_SgBitOrOp;
                  isReduction = true;
                  break;
                }
              case V_SgAndOp:
                {
                  optype = V_SgAndOp;
                  isReduction = true;
                  break;
                }
              case V_SgOrOp:
                {
                  optype = V_SgOrOp;
                  isReduction = true;
                  break;
                }
              default:
                break;
            }
          } // end matching associative operations
        }
      } // end if assignop
    }// end referenced twice
    if (isReduction)
      results.insert(make_pair(initname,optype));
  }// end for ()
}

//! a wrapper for ConstantFolding::constantFoldingOptimization ()
void SageInterface::constantFolding(SgNode* r)
{
  ROSE_ASSERT(r!=NULL);
  ConstantFolding::constantFoldingOptimization(r,false);
}

//! Generate unique names for expressions and attach the names as persistent attributes
void SageInterface::annotateExpressionsWithUniqueNames (SgProject* project)
{
  class visitorTraversal:public AstSimpleProcessing
  {
    public:
      virtual void visit (SgNode * n)
      {
        SgExpression* exp = isSgExpression(n);
        if (exp)
        {
          string u_name = generateUniqueName(exp,false);
          AstAttribute * name_attribute = new UniqueNameAttribute(u_name);
          ROSE_ASSERT (name_attribute != NULL);
          exp->addNewAttribute("UniqueNameAttribute",name_attribute);
        }
      }
  };
  visitorTraversal exampleTraversal;
  exampleTraversal.traverseInputFiles(project,preorder);
}

#endif
