//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "sage3basic.h"
#include "AssemblerX86.h"

/* Generated by ./IntelAssemblyBuilder from 
 * x86-InstructionSetReference-AM.pdf 
 * x86-InstructionSetReference-NZ.pdf 
 * ExtraInstructions.txt */
void AssemblerX86::initAssemblyRules_part6() {
    AssemblerX86::InsnDefn *defn = NULL;
    defn = new InsnDefn("pmovsxbd", x86_pmovsxbd, 0x03, 0x660f3821, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-174");
    define(defn);
    // 66 0f 38        PMOVSXBQ xmm1,   Valid    Valid      Sign extend 2 packed signed 8-bit
    // 22 /r           xmm2/m16                             integers in the low 2 bytes of
    //                                                      xmm2/m16 to 2 packed signed 64-
    //                                                      bit integers in xmm1.
    defn = new InsnDefn("pmovsxbq", x86_pmovsxbq, 0x03, 0x660f3822, od_modrm, od_xmm, od_xmm_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-174");
    define(defn);
    // 66 0f 38        PMOVSXWD xmm1,   Valid    Valid      Sign extend 4 packed signed 16-bit
    // 23 /r           xmm2/m64                             integers in the low 8 bytes of
    //                                                      xmm2/m64 to 4 packed signed 32-
    //                                                      bit integers in xmm1.
    defn = new InsnDefn("pmovsxwd", x86_pmovsxwd, 0x03, 0x660f3823, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-174");
    define(defn);
    // 66 0f 38        PMOVSXWQ xmm1,   Valid    Valid      Sign extend 2 packed signed 16-bit
    // 24 /r           xmm2/m32                             integers in the low 4 bytes of
    //                                                      xmm2/m32 to 2 packed signed 64-
    //                                                      bit integers in xmm1.
    defn = new InsnDefn("pmovsxwq", x86_pmovsxwq, 0x03, 0x660f3824, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-174");
    define(defn);
    // 66 0f 38        PMOVSXDQ xmm1,   Valid    Valid      Sign extend 2 packed signed 32-bit
    // 25 /r           xmm2/m64                             integers in the low 8 bytes of
    //                                                      xmm2/m64 to 2 packed signed 64-
    //                                                      bit integers in xmm1.
    defn = new InsnDefn("pmovsxdq", x86_pmovsxdq, 0x03, 0x660f3825, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-178");
    define(defn);

    //--- page 4-178 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0f 38 PMOVZXBW xmm1,       Valid    Valid      Zero extend 8 packed 8-bit integers in the
    // 30 /r    xmm2/m64                                 low 8 bytes of xmm2/m64 to 8 packed
    //                                                   16-bit integers in xmm1.
    defn = new InsnDefn("pmovzxbw", x86_pmovzxbw, 0x03, 0x660f3830, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-178");
    define(defn);
    // 66 0f 38 PMOVZXBD xmm1,       Valid    Valid      Zero extend 4 packed 8-bit integers in the
    // 31 /r    xmm2/m32                                 low 4 bytes of xmm2/m32 to 4 packed
    //                                                   32-bit integers in xmm1.
    defn = new InsnDefn("pmovzxbd", x86_pmovzxbd, 0x03, 0x660f3831, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-178");
    define(defn);
    // 66 0f 38 PMOVZXBQ xmm1,       Valid    Valid      Zero extend 2 packed 8-bit integers in the
    // 32 /r    xmm2/m16                                 low 2 bytes of xmm2/m16 to 2 packed
    //                                                   64-bit integers in xmm1.
    defn = new InsnDefn("pmovzxbq", x86_pmovzxbq, 0x03, 0x660f3832, od_modrm, od_xmm, od_xmm_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-178");
    define(defn);
    // 66 0f 38 PMOVZXWD xmm1,       Valid    Valid      Zero extend 4 packed 16-bit integers in
    // 33 /r    xmm2/m64                                 the low 8 bytes of xmm2/m64 to 4
    //                                                   packed 32-bit integers in xmm1.
    defn = new InsnDefn("pmovzxwd", x86_pmovzxwd, 0x03, 0x660f3833, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-178");
    define(defn);
    // 66 0f 38 PMOVZXWQ xmm1,       Valid    Valid      Zero extend 2 packed 16-bit integers in
    // 34 /r    xmm2/m32                                 the low 4 bytes of xmm2/m32 to 2
    //                                                   packed 64-bit integers in xmm1.
    defn = new InsnDefn("pmovzxwq", x86_pmovzxwq, 0x03, 0x660f3834, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-178");
    define(defn);
    // 66 0f 38 PMOVZXDQ xmm1,       Valid    Valid      Zero extend 2 packed 32-bit integers in
    // 35 /r    xmm2/m64                                 the low 8 bytes of xmm2/m64 to 2
    //                                                   packed 64-bit integers in xmm1.
    defn = new InsnDefn("pmovzxdq", x86_pmovzxdq, 0x03, 0x660f3835, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-182");
    define(defn);

    //--- page 4-182 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 38        PMULDQ xmm1,    Valid      Valid        Multiply the packed signed dword
    // 28 /r           xmm2/m128                               integers in xmm1 and xmm2/m128 and
    //                                                         store the quadword product in xmm1.
    defn = new InsnDefn("pmuldq", x86_pmuldq,  0x03, 0x660f3828, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-184");
    define(defn);

    //--- page 4-184 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 38 0B /r              PMULHRSW          Valid      Valid          Multiply 16-bit signed
    //                          mm1, mm2/m64                                words, scale and round
    //                                                                      signed doublewords, pack
    //                                                                      high 16 bits to MM1.
    defn = new InsnDefn("pmulhrsw", x86_pmulhrsw, 0x03, 0x0f380b, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-184");
    define(defn);
    // 66 0F 38 0B /r           PMULHRSW          Valid      Valid          Multiply 16-bit signed
    //                          xmm1,                                       words, scale and round
    //                          xmm2/m128                                   signed doublewords, pack
    //                                                                      high 16 bits to XMM1.
    defn = new InsnDefn("pmulhrsw", x86_pmulhrsw, 0x03, 0x660f380b, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-187");
    define(defn);

    //--- page 4-187 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F E4 /r         PMULHUW mm1,          Valid         Valid           Multiply the packed unsigned
    //                   mm2/m64                                             word integers in mm1 register
    //                                                                       and mm2/m64, and store the
    //                                                                       high 16 bits of the results in
    //                                                                       mm1.
    defn = new InsnDefn("pmulhuw", x86_pmulhuw, 0x03, 0x0fe4, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-187");
    define(defn);
    //  66 0F E4 /r      PMULHUW xmm1,         Valid         Valid           Multiply the packed unsigned
    //                   xmm2/m128                                           word integers in xmm1 and
    //                                                                       xmm2/m128, and store the high
    //                                                                       16 bits of the results in xmm1.
    defn = new InsnDefn("pmulhuw", x86_pmulhuw, 0x03, 0x660fe4, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-191");
    define(defn);

    //--- page 4-191 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F E5 /r         PMULHW mm,            Valid      Valid       Multiply the packed signed word
    //                   mm/m64                                       integers in mm1 register and
    //                                                                mm2/m64, and store the high 16
    //                                                                bits of the results in mm1.
    defn = new InsnDefn("pmulhw", x86_pmulhw,  0x03, 0x0fe5, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-191");
    define(defn);
    //  66 0F E5 /r      PMULHW xmm1,          Valid      Valid       Multiply the packed signed word
    //                   xmm2/m128                                    integers in xmm1 and
    //                                                                xmm2/m128, and store the high 16
    //                                                                bits of the results in xmm1.
    defn = new InsnDefn("pmulhw", x86_pmulhw,  0x03, 0x660fe5, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-194");
    define(defn);

    //--- page 4-194 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 38 40 /r PMULLD xmm1,      Valid      Valid          Multiply the packed dword signed
    //                xmm2/m128                                   integers in xmm1 and xmm2/m128
    //                                                            and store the low 32 bits of each
    //                                                            product in xmm1.
    defn = new InsnDefn("pmulld", x86_pmulld,  0x03, 0x660f3840, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-196");
    define(defn);

    //--- page 4-196 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F D5 /r        PMULLW mm,         Valid            Valid              Multiply the packed signed word
    //                 mm/m64                                                 integers in mm1 register and
    //                                                                        mm2/m64, and store the low 16
    //                                                                        bits of the results in mm1.
    defn = new InsnDefn("pmullw", x86_pmullw,  0x03, 0x0fd5, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-196");
    define(defn);
    // 66 0F D5 /r     PMULLW xmm1,       Valid            Valid              Multiply the packed signed word
    //                 xmm2/m128                                              integers in xmm1 and xmm2/m128,
    //                                                                        and store the low 16 bits of the
    //                                                                        results in xmm1.
    defn = new InsnDefn("pmullw", x86_pmullw,  0x03, 0x660fd5, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-200");
    define(defn);

    //--- page 4-200 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F F4 /r        PMULUDQ mm1,       Valid     Valid         Multiply unsigned doubleword
    //                 mm2/m64                                    integer in mm1 by unsigned
    //                                                            doubleword integer in mm2/m64,
    //                                                            and store the quadword result in
    //                                                            mm1.
    defn = new InsnDefn("pmuludq", x86_pmuludq, 0x03, 0x0ff4, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-200");
    define(defn);
    // 66 0F F4 /r     PMULUDQ xmm1,      Valid     Valid         Multiply packed unsigned
    //                 xmm2/m128                                  doubleword integers in xmm1 by
    //                                                            packed unsigned doubleword
    //                                                            integers in xmm2/m128, and store
    //                                                            the quadword results in xmm1.
    defn = new InsnDefn("pmuludq", x86_pmuludq, 0x03, 0x660ff4, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);

    //--- page 4-203 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  8F /0            POP r/m16      Valid     Valid      Pop top of stack into m16; increment stack
    //                                                       pointer.
    defn = new InsnDefn("pop",    x86_pop,     0x03, 0x8f, od_e0, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);
    //  8F /0            POP r/m32      N.E.      Valid      Pop top of stack into m32; increment stack
    //                                                       pointer.
    defn = new InsnDefn("pop",    x86_pop,     0x01, 0x8f, od_e0, od_r_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);
    //  8F /0            POP r/m64      Valid     N.E.       Pop top of stack into m64; increment stack
    //                                                       pointer. Cannot encode 32-bit operand size.
    defn = new InsnDefn("pop",    x86_pop,     0x02, 0x8f, od_e0, od_r_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);
    //  58+ rw           POP r16        Valid     Valid      Pop top of stack into r16; increment stack
    //                                                       pointer.
    defn = new InsnDefn("pop",    x86_pop,     0x03, 0x58, od_rw, od_r16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);
    //  58+ rd           POP r32        N.E.      Valid      Pop top of stack into r32; increment stack
    //                                                       pointer.
    defn = new InsnDefn("pop",    x86_pop,     0x01, 0x58, od_rd, od_r32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);
    //  58+ rd           POP r64        Valid     N.E.       Pop top of stack into r64; increment stack
    //                                                       pointer. Cannot encode 32-bit operand size.
    defn = new InsnDefn("pop",    x86_pop,     0x02, 0x58, od_rd, od_r64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);
    //  1F               POP DS         Invalid   Valid      Pop top of stack into DS; increment stack
    //                                                       pointer.
    defn = new InsnDefn("pop",    x86_pop,     0x01, 0x1f, od_none, od_DS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);
    //  07               POP ES         Invalid   Valid      Pop top of stack into ES; increment stack
    //                                                       pointer.
    defn = new InsnDefn("pop",    x86_pop,     0x01, 0x07, od_none, od_ES);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);
    //  17               POP SS         Invalid   Valid      Pop top of stack into SS; increment stack
    //                                                       pointer.
    defn = new InsnDefn("pop",    x86_pop,     0x01, 0x17, od_none, od_SS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);
    //  0F A1            POP FS         Valid     Valid      Pop top of stack into FS; increment stack
    //                                                       pointer by 16 bits.
    defn = new InsnDefn("pop",    x86_pop,     0x03, 0x0fa1, od_none, od_FS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);
    //  0F A1            POP FS         N.E.      Valid      Pop top of stack into FS; increment stack
    //                                                       pointer by 32 bits.
    defn = new InsnDefn("pop",    x86_pop,     0x01, 0x0fa1, od_none, od_FS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);
    //  0F A1            POP FS         Valid     N.E.       Pop top of stack into FS; increment stack
    //                                                       pointer by 64 bits.
    defn = new InsnDefn("pop",    x86_pop,     0x02, 0x0fa1, od_none, od_FS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);
    //  0F A9            POP GS         Valid     Valid      Pop top of stack into GS; increment stack
    //                                                       pointer by 16 bits.
    defn = new InsnDefn("pop",    x86_pop,     0x03, 0x0fa9, od_none, od_GS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);
    //  0F A9            POP GS         N.E.      Valid      Pop top of stack into GS; increment stack
    //                                                       pointer by 32 bits.
    defn = new InsnDefn("pop",    x86_pop,     0x01, 0x0fa9, od_none, od_GS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-203");
    define(defn);
    //  0F A9            POP GS         Valid     N.E.       Pop top of stack into GS; increment stack
    //                                                       pointer by 64 bits.
    defn = new InsnDefn("pop",    x86_pop,     0x02, 0x0fa9, od_none, od_GS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-210");
    define(defn);

    //--- page 4-210 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 61              POPA               Invalid      Valid           Pop DI, SI, BP, BX, DX, CX, and AX.
    defn = new InsnDefn("popa",   x86_popa,    0x01, 0x61, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-210");
    define(defn);
    // 61              POPAD              Invalid      Valid           Pop EDI, ESI, EBP, EBX, EDX, ECX, and
    //                                                                 EAX.
    defn = new InsnDefn("popad",  x86_popad,   0x01, 0x61, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-212");
    define(defn);

    //--- page 4-212 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  F3 0F B8 /r                POPCNT r16, r/m16     Valid           Valid         POPCNT on r/m16
    defn = new InsnDefn("popcnt", x86_popcnt,  0x03, 0xf30fb8, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-212");
    define(defn);
    //  F3 0F B8 /r                POPCNT r32, r/m32     Valid           Valid         POPCNT on r/m32
    defn = new InsnDefn("popcnt", x86_popcnt,  0x03, 0xf30fb8, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-212");
    define(defn);
    //  F3 REX.W 0F B8 /r          POPCNT r64, r/m64     Valid           N.E.          POPCNT on r/m64
    defn = new InsnDefn("popcnt", x86_popcnt,  0x02, 0xf30fb8, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-214");
    define(defn);

    //--- page 4-214 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 9D               POPF             Valid          Valid           Pop top of stack into lower 16 bits of
    //                                                                  EFLAGS.
    defn = new InsnDefn("popf",   x86_popf,    0x03, 0x9d, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-214");
    define(defn);
    // 9D               POPFD            N.E.           Valid           Pop top of stack into EFLAGS.
    defn = new InsnDefn("popfd",  x86_popfd,   0x01, 0x9d, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-214");
    define(defn);
    // REX.W + 9D       POPFQ            Valid          N.E.            Pop top of stack and zero-extend into
    //                                                                  RFLAGS.
    defn = new InsnDefn("popfq",  x86_popfq,   0x02, 0x9d, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-218");
    define(defn);

    //--- page 4-218 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F EB /r        POR mm, mm/m64      Valid    Valid        Bitwise OR of mm/m64 and mm.
    defn = new InsnDefn("por",    x86_por,     0x03, 0x0feb, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-218");
    define(defn);
    // 66 0F EB /r     POR xmm1,           Valid    Valid        Bitwise OR of xmm2/m128 and
    //                 xmm2/m128                                 xmm1.
    defn = new InsnDefn("por",    x86_por,     0x03, 0x660feb, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-221");
    define(defn);

    //--- page 4-221 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 18 /1     PREFETCHT0 m8           Valid    Valid      Move data from m8 closer to the
    //                                                           processor using T0 hint.
    defn = new InsnDefn("prefetcht0", x86_prefetcht0, 0x03, 0x0f18, od_e1, od_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-221");
    define(defn);
    //  0F 18 /2     PREFETCHT1 m8           Valid    Valid      Move data from m8 closer to the
    //                                                           processor using T1 hint.
    defn = new InsnDefn("prefetcht1", x86_prefetcht1, 0x03, 0x0f18, od_e2, od_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-221");
    define(defn);
    //  0F 18 /3     PREFETCHT2 m8           Valid    Valid      Move data from m8 closer to the
    //                                                           processor using T2 hint.
    defn = new InsnDefn("prefetcht2", x86_prefetcht2, 0x03, 0x0f18, od_e3, od_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-221");
    define(defn);
    //  0F 18 /0     PREFETCHNTA m8          Valid    Valid      Move data from m8 closer to the
    //                                                           processor using NTA hint.
    defn = new InsnDefn("prefetchnta", x86_prefetchnta, 0x03, 0x0f18, od_e0, od_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-223");
    define(defn);

    //--- page 4-223 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F F6 /r       PSADBW mm1,        Valid     Valid      Computes the absolute differences of
    //                 mm2/m64                                 the packed unsigned byte integers
    //                                                         from mm2 /m64 and mm1; differences
    //                                                         are then summed to produce an
    //                                                         unsigned word integer result.
    defn = new InsnDefn("psadbw", x86_psadbw,  0x03, 0x0ff6, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-223");
    define(defn);
    //  66 0F F6 /r    PSADBW xmm1,       Valid     Valid      Computes the absolute differences of
    //                 xmm2/m128                               the packed unsigned byte integers
    //                                                         from xmm2 /m128 and xmm1; the 8
    //                                                         low differences and 8 high differences
    //                                                         are then summed separately to
    //                                                         produce two unsigned word integer
    //                                                         results.
    defn = new InsnDefn("psadbw", x86_psadbw,  0x03, 0x660ff6, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-227");
    define(defn);

    //--- page 4-227 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 38 00 /r                PSHUFB mm1,        Valid       Valid            Shuffle bytes in mm1
    //                             mm2/m64                                         according to contents of
    //                                                                             mm2/m64.
    defn = new InsnDefn("pshufb", x86_pshufb,  0x03, 0x0f3800, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-227");
    define(defn);
    //  66 0F 38 00 /r             PSHUFB xmm1,       Valid       Valid            Shuffle bytes in xmm1
    //                             xmm2/m128                                       according to contents of
    //                                                                             xmm2/m128.
    defn = new InsnDefn("pshufb", x86_pshufb,  0x03, 0x660f3800, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-231");
    define(defn);

    //--- page 4-231 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  66 0F 70 /r ib   PSHUFD xmm1,              Valid         Valid              Shuffle the doublewords in
    //                   xmm2/m128, imm8                                            xmm2/m128 based on the
    //                                                                              encoding in imm8 and store
    //                                                                              the result in xmm1.
    defn = new InsnDefn("pshufd", x86_pshufd,  0x03, 0x660f70, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-234");
    define(defn);

    //--- page 4-234 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // F3 0F 70 /r ib   PSHUFHW xmm1, xmm2/m128   Valid     Valid        Shuffle the high words in
    //                        imm8                                       xmm2/m128 based on the
    //                                                                   encoding in imm8 and store
    //                                                                   the result in xmm1.
    defn = new InsnDefn("pshufhw", x86_pshufhw, 0x03, 0xf30f70, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-237");
    define(defn);

    //--- page 4-237 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  F2 0F 70 /r ib   PSHUFLW xmm1,         Valid     Valid        Shuffle the low words in
    //                   xmm2/m128, imm8                              xmm2/m128 based on the
    //                                                                encoding in imm8 and store the
    //                                                                result in xmm1.
    defn = new InsnDefn("pshuflw", x86_pshuflw, 0x03, 0xf20f70, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-240");
    define(defn);

    //--- page 4-240 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 70 /r ib     PSHUFW mm1,          Valid     Valid      Shuffle the words in mm2/m64
    //                 mm2/m64, imm8                             based on the encoding in imm8 and
    //                                                           store the result in mm1.
    defn = new InsnDefn("pshufw", x86_pshufw,  0x03, 0x0f70, od_modrm|od_ib, od_mm, od_mm_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-242");
    define(defn);

    //--- page 4-242 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 38 08 /r     PSIGNB mm1,    Valid    Valid       Negate/zero/preserve packed byte
    //                 mm2/m64                             integers in mm1 depending on the
    //                                                     corresponding sign in mm2/m64
    defn = new InsnDefn("psignb", x86_psignb,  0x03, 0x0f3808, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-242");
    define(defn);
    // 66 0F 38 08 /r PSIGNB xmm1, Valid       Valid       Negate/zero/preserve packed byte
    //                xmm2/m128                            integers in xmm1 depending on the
    //                                                     corresponding sign in xmm2/m128.
    defn = new InsnDefn("psignb", x86_psignb,  0x03, 0x660f3808, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-242");
    define(defn);
    // 0F 38 09 /r     PSIGNW mm1,    Valid    Valid       Negate/zero/preserve packed word
    //                 mm2/m64                             integers in mm1 depending on the
    //                                                     corresponding sign in mm2/m128.
    defn = new InsnDefn("psignw", x86_psignw,  0x03, 0x0f3809, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-242");
    define(defn);
    // 66 0F 38 09 /r PSIGNW xmm1, Valid       Valid       Negate/zero/preserve packed word
    //                xmm2/m128                            integers in xmm1 depending on the
    //                                                     corresponding sign in xmm2/m128.
    defn = new InsnDefn("psignw", x86_psignw,  0x03, 0x660f3809, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-242");
    define(defn);
    // 0F 38 0A /r     PSIGND mm1,    Valid    Valid       Negate/zero/preserve packed
    //                 mm2/m64                             doubleword integers in mm1
    //                                                     depending on the corresponding sign
    //                                                     in mm2/m128.
    defn = new InsnDefn("psignd", x86_psignd,  0x03, 0x0f380a, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-242");
    define(defn);
    // 66 0F 38 0A /r PSIGND xmm1, Valid       Valid       Negate/zero/preserve packed
    //                xmm2/m128                            doubleword integers in xmm1
    //                                                     depending on the corresponding sign
    //                                                     in xmm2/m128.
    defn = new InsnDefn("psignd", x86_psignd,  0x03, 0x660f380a, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-247");
    define(defn);

    //--- page 4-247 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  66 0F 73 /7 ib     PSLLDQ xmm1,        Valid     Valid      Shift xmm1 left by imm8 bytes
    //                     imm8                                     while shifting in 0s.
    defn = new InsnDefn("pslldq", x86_pslldq,  0x03, 0x660f73, od_e7|od_ib, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-249");
    define(defn);

    //--- page 4-249 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F F1 /r          PSLLW mm, mm/m64 Valid           Valid       Shift words in mm left mm/m64
    //                                                                 while shifting in 0s.
    defn = new InsnDefn("psllw",  x86_psllw,   0x03, 0x0ff1, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-249");
    define(defn);
    //  66 0F F1 /r       PSLLW xmm1,             Valid    Valid       Shift words in xmm1 left by
    //                    xmm2/m128                                    xmm2/m128 while shifting in 0s.
    defn = new InsnDefn("psllw",  x86_psllw,   0x03, 0x660ff1, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-249");
    define(defn);
    //  0F 71 /6 ib       PSLLW xmm1, imm8        Valid    Valid       Shift words in mm left by imm8
    //                                                                 while shifting in 0s.
    defn = new InsnDefn("psllw",  x86_psllw,   0x03, 0x0f71, od_e6|od_ib, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-249");
    define(defn);
    //  66 0F 71 /6 ib    PSLLW xmm1, imm8        Valid    Valid       Shift words in xmm1 left by
    //                                                                 imm8 while shifting in 0s.
    defn = new InsnDefn("psllw",  x86_psllw,   0x03, 0x660f71, od_e6|od_ib, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-249");
    define(defn);
    //  0F F2 /r          PSLLD mm, mm/m64        Valid    Valid       Shift doublewords in mm left by
    //                                                                 mm/m64 while shifting in 0s.
    defn = new InsnDefn("pslld",  x86_pslld,   0x03, 0x0ff2, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-249");
    define(defn);
    //  66 0F F2 /r       PSLLD xmm1,             Valid    Valid       Shift doublewords in xmm1 left
    //                    xmm2/m128                                    by xmm2/m128 while shifting in
    //                                                                 0s.
    defn = new InsnDefn("pslld",  x86_pslld,   0x03, 0x660ff2, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-249");
    define(defn);
    //  0F 72 /6 ib       PSLLD mm, imm8          Valid    Valid       Shift doublewords in mm left by
    //                                                                 imm8 while shifting in 0s.
    defn = new InsnDefn("pslld",  x86_pslld,   0x03, 0x0f72, od_e6|od_ib|od_modrm, od_mm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-249");
    define(defn);
    //  66 0F 72 /6 ib    PSLLD xmm1, imm8        Valid    Valid       Shift doublewords in xmm1 left
    //                                                                 by imm8 while shifting in 0s.
    defn = new InsnDefn("pslld",  x86_pslld,   0x03, 0x660f72, od_e6|od_ib, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-249");
    define(defn);
    //  0F F3 /r          PSLLQ mm, mm/m64        Valid    Valid       Shift quadword in mm left by
    //                                                                 mm/m64 while shifting in 0s.
    defn = new InsnDefn("psllq",  x86_psllq,   0x03, 0x0ff3, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-249");
    define(defn);
    //  66 0F F3 /r       PSLLQ xmm1,             Valid    Valid       Shift quadwords in xmm1 left by
    //                    xmm2/m128                                    xmm2/m128 while shifting in 0s.
    defn = new InsnDefn("psllq",  x86_psllq,   0x03, 0x660ff3, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-249");
    define(defn);
    //  0F 73 /6 ib       PSLLQ mm, imm8          Valid    Valid       Shift quadword in mm left by
    //                                                                 imm8 while shifting in 0s.
    defn = new InsnDefn("psllq",  x86_psllq,   0x03, 0x0f73, od_e6|od_ib|od_modrm, od_mm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-249");
    define(defn);
    //  66 0F 73 /6 ib    PSLLQ xmm1, imm8        Valid    Valid       Shift quadwords in xmm1 left by
    //                                                                 imm8 while shifting in 0s.
    defn = new InsnDefn("psllq",  x86_psllq,   0x03, 0x660f73, od_e6|od_ib, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-254");
    define(defn);

    //--- page 4-254 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F E1 /r         PSRAW mm,        Valid    Valid         Shift words in mm right by
    //                  mm/m64                                  mm/m64 while shifting in sign
    //                                                          bits.
    defn = new InsnDefn("psraw",  x86_psraw,   0x03, 0x0fe1, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-254");
    define(defn);
    // 66 0F E1 /r      PSRAW xmm1,      Valid    Valid         Shift words in xmm1 right by
    //                  xmm2/m128                               xmm2/m128 while shifting in sign
    //                                                          bits.
    defn = new InsnDefn("psraw",  x86_psraw,   0x03, 0x660fe1, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-254");
    define(defn);
    // 0F 71 /4 ib      PSRAW mm, imm8 Valid      Valid         Shift words in mm right by imm8
    //                                                          while shifting in sign bits
    defn = new InsnDefn("psraw",  x86_psraw,   0x03, 0x0f71, od_e4|od_ib|od_modrm, od_mm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-254");
    define(defn);
    // 66 0F 71 /4 ib   PSRAW xmm1,      Valid    Valid         Shift words in xmm1 right by
    //                  imm8                                    imm8 while shifting in sign bits
    defn = new InsnDefn("psraw",  x86_psraw,   0x03, 0x660f71, od_e4|od_ib, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-254");
    define(defn);
    // 0F E2 /r         PSRAD mm,        Valid    Valid         Shift doublewords in mm right by
    //                  mm/m64                                  mm/m64 while shifting in sign
    //                                                          bits.
    defn = new InsnDefn("psrad",  x86_psrad,   0x03, 0x0fe2, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-254");
    define(defn);
    // 66 0F E2 /r      PSRAD xmm1,      Valid    Valid         Shift doubleword in xmm1 right
    //                  xmm2/m128                               by xmm2 /m128 while shifting in
    //                                                          sign bits.
    defn = new InsnDefn("psrad",  x86_psrad,   0x03, 0x660fe2, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-254");
    define(defn);
    // 0F 72 /4 ib      PSRAD mm, imm8 Valid      Valid         Shift doublewords in mm right by
    //                                                          imm8 while shifting in sign bits.
    defn = new InsnDefn("psrad",  x86_psrad,   0x03, 0x0f72, od_e4|od_ib|od_modrm, od_mm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-254");
    define(defn);
    // 66 0F 72 /4 ib   PSRAD xmm1,      Valid    Valid         Shift doublewords in xmm1 right
    //                  imm8                                    by imm8 while shifting in sign bits.
    defn = new InsnDefn("psrad",  x86_psrad,   0x03, 0x660f72, od_e4|od_ib, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-259");
    define(defn);

    //--- page 4-259 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  66 0F 73 /3 ib    PSRLDQ xmm1,      Valid    Valid        Shift xmm1 right by imm8 while
    //                    imm8                                    shifting in 0s.
    defn = new InsnDefn("psrldq", x86_psrldq,  0x03, 0x660f73, od_e3|od_ib, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-261");
    define(defn);

    //--- page 4-261 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F D1 /r        PSRLW mm,          Valid       Valid      Shift words in mm right by amount
    //                  mm/m64                                    specified in mm/m64 while shifting in
    //                                                            0s.
    defn = new InsnDefn("psrlw",  x86_psrlw,   0x03, 0x0fd1, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-261");
    define(defn);
    //  66 0F D1 /r     PSRLW xmm1,        Valid       Valid      Shift words in xmm1 right by amount
    //                  xmm2/m128                                 specified in xmm2/m128 while
    //                                                            shifting in 0s.
    defn = new InsnDefn("psrlw",  x86_psrlw,   0x03, 0x660fd1, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-261");
    define(defn);
    //  0F 71 /2 ib     PSRLW mm,          Valid       Valid      Shift words in mm right by imm8 while
    //                  imm8                                      shifting in 0s.
    defn = new InsnDefn("psrlw",  x86_psrlw,   0x03, 0x0f71, od_e2|od_ib|od_modrm, od_mm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-261");
    define(defn);
    //  66 0F 71 /2 ib PSRLW xmm1,         Valid       Valid      Shift words in xmm1 right by imm8
    //                 imm8                                       while shifting in 0s.
    defn = new InsnDefn("psrlw",  x86_psrlw,   0x03, 0x660f71, od_e2|od_ib, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-261");
    define(defn);
    //  0F D2 /r        PSRLD mm,          Valid       Valid      Shift doublewords in mm right by
    //                  mm/m64                                    amount specified in mm/m64 while
    //                                                            shifting in 0s.
    defn = new InsnDefn("psrld",  x86_psrld,   0x03, 0x0fd2, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-261");
    define(defn);
    //  66 0F D2 /r     PSRLD xmm1,        Valid       Valid      Shift doublewords in xmm1 right by
    //                  xmm2/m128                                 amount specified in xmm2 /m128
    //                                                            while shifting in 0s.
    defn = new InsnDefn("psrld",  x86_psrld,   0x03, 0x660fd2, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-261");
    define(defn);
    //  0F 72 /2 ib     PSRLD mm,          Valid       Valid      Shift doublewords in mm right by
    //                  imm8                                      imm8 while shifting in 0s.
    defn = new InsnDefn("psrld",  x86_psrld,   0x03, 0x0f72, od_e2|od_ib|od_modrm, od_mm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-261");
    define(defn);
    //  66 0F 72 /2 ib PSRLD xmm1,         Valid       Valid      Shift doublewords in xmm1 right by
    //                 imm8                                       imm8 while shifting in 0s.
    defn = new InsnDefn("psrld",  x86_psrld,   0x03, 0x660f72, od_e2|od_ib, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-261");
    define(defn);
    //  0F D3 /r        PSRLQ mm,          Valid       Valid      Shift mm right by amount specified in
    //                  mm/m64                                    mm/m64 while shifting in 0s.
    defn = new InsnDefn("psrlq",  x86_psrlq,   0x03, 0x0fd3, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-261");
    define(defn);
    //  66 0F D3 /r     PSRLQ xmm1,        Valid       Valid      Shift quadwords in xmm1 right by
    //                  xmm2/m128                                 amount specified in xmm2/m128
    //                                                            while shifting in 0s.
    defn = new InsnDefn("psrlq",  x86_psrlq,   0x03, 0x660fd3, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-261");
    define(defn);
    //  0F 73 /2 ib     PSRLQ mm,          Valid       Valid      Shift mm right by imm8 while shifting
    //                  imm8                                      in 0s.
    defn = new InsnDefn("psrlq",  x86_psrlq,   0x03, 0x0f73, od_e2|od_ib|od_modrm, od_mm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-261");
    define(defn);
    //  66 0F 73 /2 ib PSRLQ xmm1,         Valid       Valid      Shift quadwords in xmm1 right by
    //                 imm8                                       imm8 while shifting in 0s.
    defn = new InsnDefn("psrlq",  x86_psrlq,   0x03, 0x660f73, od_e2|od_ib, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-266");
    define(defn);

    //--- page 4-266 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F F8 /r        PSUBB mm,        Valid    Valid       Subtract packed byte integers in
    //                 mm/m64                                mm/m64 from packed byte integers in
    //                                                       mm.
    defn = new InsnDefn("psubb",  x86_psubb,   0x03, 0x0ff8, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-266");
    define(defn);
    // 66 0F F8 /r     PSUBB xmm1,      Valid    Valid       Subtract packed byte integers in
    //                 xmm2/m128                             xmm2/m128 from packed byte
    //                                                       integers in xmm1.
    defn = new InsnDefn("psubb",  x86_psubb,   0x03, 0x660ff8, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-266");
    define(defn);
    // 0F F9 /r        PSUBW mm,        Valid    Valid       Subtract packed word integers in
    //                 mm/m64                                mm/m64 from packed word integers in
    //                                                       mm.
    defn = new InsnDefn("psubw",  x86_psubw,   0x03, 0x0ff9, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-266");
    define(defn);
    // 66 0F F9 /r     PSUBW xmm1,      Valid    Valid       Subtract packed word integers in
    //                 xmm2/m128                             xmm2/m128 from packed word
    //                                                       integers in xmm1.
    defn = new InsnDefn("psubw",  x86_psubw,   0x03, 0x660ff9, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-266");
    define(defn);
    // 0F FA /r        PSUBD mm,        Valid    Valid       Subtract packed doubleword integers
    //                 mm/m64                                in mm/m64 from packed doubleword
    //                                                       integers in mm.
    defn = new InsnDefn("psubd",  x86_psubd,   0x03, 0x0ffa, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-266");
    define(defn);
    // 66 0F FA /r     PSUBD xmm1,      Valid    Valid       Subtract packed doubleword integers
    //                 xmm2/m128                             in xmm2/mem128 from packed
    //                                                       doubleword integers in xmm1.
    defn = new InsnDefn("psubd",  x86_psubd,   0x03, 0x660ffa, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-270");
    define(defn);

    //--- page 4-270 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F FB /r        PSUBQ mm1, mm2/m64        Valid    Valid         Subtract quadword integer
    //                                                                  in mm1 from mm2 /m64.
    defn = new InsnDefn("psubq",  x86_psubq,   0x03, 0x0ffb, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-270");
    define(defn);
    // 66 0F FB /r     PSUBQ xmm1, xmm2/m128 Valid        Valid         Subtract packed quadword
    //                                                                  integers in xmm1 from
    //                                                                  xmm2 /m128.
    defn = new InsnDefn("psubq",  x86_psubq,   0x03, 0x660ffb, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-273");
    define(defn);

    //--- page 4-273 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F E8 /r       PSUBSB mm,           Valid       Valid          Subtract signed packed bytes in
    //                 mm/m64                                          mm/m64 from signed packed bytes
    //                                                                 in mm and saturate results.
    defn = new InsnDefn("psubsb", x86_psubsb,  0x03, 0x0fe8, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-273");
    define(defn);
    //  66 0F E8 /r    PSUBSB xmm1,         Valid       Valid          Subtract packed signed byte
    //                 xmm2/m128                                       integers in xmm2/m128 from
    //                                                                 packed signed byte integers in
    //                                                                 xmm1 and saturate results.
    defn = new InsnDefn("psubsb", x86_psubsb,  0x03, 0x660fe8, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-273");
    define(defn);
    //  0F E9 /r       PSUBSW mm,           Valid       Valid          Subtract signed packed words in
    //                 mm/m64                                          mm/m64 from signed packed words
    //                                                                 in mm and saturate results.
    defn = new InsnDefn("psubsw", x86_psubsw,  0x03, 0x0fe9, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-273");
    define(defn);
    //  66 0F E9 /r    PSUBSW xmm1,         Valid       Valid          Subtract packed signed word
    //                 xmm2/m128                                       integers in xmm2/m128 from
    //                                                                 packed signed word integers in
    //                                                                 xmm1 and saturate results.
    defn = new InsnDefn("psubsw", x86_psubsw,  0x03, 0x660fe9, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-277");
    define(defn);

    //--- page 4-277 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F D8 /r        PSUBUSB mm,          Valid     Valid         Subtract unsigned packed bytes in
    //                  mm/m64                                       mm/m64 from unsigned packed
    //                                                               bytes in mm and saturate result.
    defn = new InsnDefn("psubusb", x86_psubusb, 0x03, 0x0fd8, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-277");
    define(defn);
    //  66 0F D8 /r     PSUBUSB xmm1,        Valid     Valid         Subtract packed unsigned byte
    //                  xmm2/m128                                    integers in xmm2/m128 from packed
    //                                                               unsigned byte integers in xmm1 and
    //                                                               saturate result.
    defn = new InsnDefn("psubusb", x86_psubusb, 0x03, 0x660fd8, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-277");
    define(defn);
    //  0F D9 /r        PSUBUSW mm,          Valid     Valid         Subtract unsigned packed words in
    //                  mm/m64                                       mm/m64 from unsigned packed
    //                                                               words in mm and saturate result.
    defn = new InsnDefn("psubusw", x86_psubusw, 0x03, 0x0fd9, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-277");
    define(defn);
    //  66 0F D9 /r     PSUBUSW xmm1,        Valid     Valid         Subtract packed unsigned word
    //                  xmm2/m128                                    integers in xmm2/m128 from packed
    //                                                               unsigned word integers in xmm1 and
    //                                                               saturate result.
    defn = new InsnDefn("psubusw", x86_psubusw, 0x03, 0x660fd9, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-281");
    define(defn);

    //--- page 4-281 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  66 0F 38 17 /r PTEST xmm1,         Valid    Valid         Set ZF if xmm2/m128 AND xmm1
    //                 xmm2/m128                                  result is all 0s. Set CF if xmm2/m128
    //                                                            AND NOT xmm1 result is all 0s.
    defn = new InsnDefn("ptest",  x86_ptest,   0x03, 0x660f3817, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-284");
    define(defn);

    //--- page 4-284 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 68 /r        PUNPCKHBW mm,        Valid     Valid       Unpack and interleave high-order
    //                 mm/m64                                     bytes from mm and mm/m64
    //                                                            into mm.
    defn = new InsnDefn("punpckhbw", x86_punpckhbw, 0x03, 0x0f68, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-284");
    define(defn);
    // 66 0F 68 /r     PUNPCKHBW xmm1,      Valid     Valid       Unpack and interleave high-order
    //                 xmm2/m128                                  bytes from xmm1 and
    //                                                            xmm2/m128 into xmm1.
    defn = new InsnDefn("punpckhbw", x86_punpckhbw, 0x03, 0x660f68, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-284");
    define(defn);
    // 0F 69 /r        PUNPCKHWD mm,        Valid     Valid       Unpack and interleave high-order
    //                 mm/m64                                     words from mm and mm/m64
    //                                                            into mm.
    defn = new InsnDefn("punpckhwd", x86_punpckhwd, 0x03, 0x0f69, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-284");
    define(defn);
    // 66 0F 69 /r     PUNPCKHWD xmm1,      Valid     Valid       Unpack and interleave high-order
    //                 xmm2/m128                                  words from xmm1 and
    //                                                            xmm2/m128 into xmm1.
    defn = new InsnDefn("punpckhwd", x86_punpckhwd, 0x03, 0x660f69, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-284");
    define(defn);
    // 0F 6A /r        PUNPCKHDQ mm,        Valid     Valid       Unpack and interleave high-order
    //                 mm/m64                                     doublewords from mm and
    //                                                            mm/m64 into mm.
    defn = new InsnDefn("punpckhdq", x86_punpckhdq, 0x03, 0x0f6a, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-284");
    define(defn);
    // 66 0F 6A /r     PUNPCKHDQ xmm1,      Valid     Valid       Unpack and interleave high-order
    //                 xmm2/m128                                  doublewords from xmm1 and
    //                                                            xmm2/m128 into xmm1.
    defn = new InsnDefn("punpckhdq", x86_punpckhdq, 0x03, 0x660f6a, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-284");
    define(defn);
    // 66 0F 6D /r     PUNPCKHQDQ xmm1,     Valid     Valid       Unpack and interleave high-order
    //                 xmm2/m128                                  quadwords from xmm1 and
    //                                                            xmm2/m128 into xmm1.
    defn = new InsnDefn("punpckhqdq", x86_punpckhqdq, 0x03, 0x660f6d, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-290");
    define(defn);

    //--- page 4-290 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 60 /r        PUNPCKLBW mm,          Valid    Valid       Interleave low-order bytes from
    //                 mm/m32                                      mm and mm/m32 into mm.
    defn = new InsnDefn("punpcklbw", x86_punpcklbw, 0x03, 0x0f60, od_modrm, od_mm, od_mm_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-290");
    define(defn);
    // 66 0F 60 /r     PUNPCKLBW xmm1,        Valid    Valid       Interleave low-order bytes from
    //                 xmm2/m128                                   xmm1 and xmm2/m128 into
    //                                                             xmm1.
    defn = new InsnDefn("punpcklbw", x86_punpcklbw, 0x03, 0x660f60, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-290");
    define(defn);
    // 0F 61 /r        PUNPCKLWD mm,          Valid    Valid       Interleave low-order words from
    //                 mm/m32                                      mm and mm/m32 into mm.
    defn = new InsnDefn("punpcklwd", x86_punpcklwd, 0x03, 0x0f61, od_modrm, od_mm, od_mm_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-290");
    define(defn);
    // 66 0F 61 /r     PUNPCKLWD xmm1,        Valid    Valid       Interleave low-order words from
    //                 xmm2/m128                                   xmm1 and xmm2/m128 into
    //                                                             xmm1.
    defn = new InsnDefn("punpcklwd", x86_punpcklwd, 0x03, 0x660f61, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-290");
    define(defn);
    // 0F 62 /r        PUNPCKLDQ mm,          Valid    Valid       Interleave low-order doublewords
    //                 mm/m32                                      from mm and mm/m32 into mm.
    defn = new InsnDefn("punpckldq", x86_punpckldq, 0x03, 0x0f62, od_modrm, od_mm, od_mm_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-290");
    define(defn);
    // 66 0F 62 /r     PUNPCKLDQ xmm1,        Valid    Valid       Interleave low-order doublewords
    //                 xmm2/m128                                   from xmm1 and xmm2/m128 into
    //                                                             xmm1.
    defn = new InsnDefn("punpckldq", x86_punpckldq, 0x03, 0x660f62, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-290");
    define(defn);
    // 66 0F 6C /r     PUNPCKLQDQ xmm1,       Valid    Valid       Interleave low-order quadword
    //                 xmm2/m128                                   from xmm1 and xmm2/m128 into
    //                                                             xmm1 register.
    defn = new InsnDefn("punpcklqdq", x86_punpcklqdq, 0x03, 0x660f6c, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);

    //--- page 4-295 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  FF /6          PUSH r/m16        Valid       Valid      Push r/m16.
    defn = new InsnDefn("push",   x86_push,    0x03, 0xff, od_e6, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  FF /6          PUSH r/m32        N.E.        Valid      Push r/m32.
    defn = new InsnDefn("push",   x86_push,    0x01, 0xff, od_e6, od_r_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  FF /6          PUSH r/m64        Valid       N.E.       Push r/m64. Default operand size 64-
    //                                                          bits.
    defn = new InsnDefn("push",   x86_push,    0x02, 0xff, od_e6, od_r_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  50+rw          PUSH r16          Valid       Valid      Push r16.
    defn = new InsnDefn("push",   x86_push,    0x03, 0x50, od_rw, od_r16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  50+rd          PUSH r32          N.E.        Valid      Push r32.
    defn = new InsnDefn("push",   x86_push,    0x01, 0x50, od_rd, od_r32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  50+rd          PUSH r64          Valid       N.E.       Push r64. Default operand size
    //                                                          64-bits.
    defn = new InsnDefn("push",   x86_push,    0x02, 0x50, od_rd, od_r64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  6A             PUSH imm8         Valid       Valid      Push sign-extended imm8. Stack
    //                                                          pointer is incremented by the size of
    //                                                          stack pointer.
    defn = new InsnDefn("push",   x86_push,    0x03, 0x6a, od_ib, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  68             PUSH imm16        Valid       Valid      Push sign-extended imm16. Stack
    //                                                          pointer is incremented by the size of
    //                                                          stack pointer.
    defn = new InsnDefn("push",   x86_push,    0x03, 0x68, od_iw, od_imm16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  68             PUSH imm32        Valid       Valid      Push sign-extended imm32. Stack
    //                                                          pointer is incremented by the size of
    //                                                          stack pointer.
    defn = new InsnDefn("push",   x86_push,    0x03, 0x68, od_id, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  0E             PUSH CS           Invalid     Valid      Push CS.
    defn = new InsnDefn("push",   x86_push,    0x01, 0x0e, od_none, od_CS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  16             PUSH SS           Invalid     Valid      Push SS.
    defn = new InsnDefn("push",   x86_push,    0x01, 0x16, od_none, od_SS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  1E             PUSH DS           Invalid     Valid      Push DS.
    defn = new InsnDefn("push",   x86_push,    0x01, 0x1e, od_none, od_DS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  06             PUSH ES           Invalid     Valid      Push ES.
    defn = new InsnDefn("push",   x86_push,    0x01, 0x06, od_none, od_ES);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  0F A0          PUSH FS           Valid       Valid      Push FS and decrement stack pointer
    //                                                          by 16 bits.
    defn = new InsnDefn("push",   x86_push,    0x03, 0x0fa0, od_none, od_FS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  0F A0          PUSH FS           N.E.        Valid      Push FS and decrement stack pointer
    //                                                          by 32 bits.
    defn = new InsnDefn("push",   x86_push,    0x01, 0x0fa0, od_none, od_FS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  0F A0          PUSH FS           Valid       N.E.       Push FS. Default operand size 64-bits.
    //                                                          (66H override causes 16-bit
    //                                                          operation).
    defn = new InsnDefn("push",   x86_push,    0x02, 0x0fa0, od_none, od_FS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  0F A8          PUSH GS           Valid       Valid      Push GS and decrement stack pointer
    //                                                          by 16 bits.
    defn = new InsnDefn("push",   x86_push,    0x03, 0x0fa8, od_none, od_GS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-295");
    define(defn);
    //  0F A8          PUSH GS           N.E.        Valid      Push GS and decrement stack pointer
    //                                                          by 32 bits.
    defn = new InsnDefn("push",   x86_push,    0x01, 0x0fa8, od_none, od_GS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-296");
    define(defn);
    // 0F A8           PUSH GS          Valid      N.E.           Push GS, default operand size 64-bits.
    //                                                            (66H override causes 16-bit
    //                                                            operation).
    defn = new InsnDefn("push",   x86_push,    0x02, 0x0fa8, od_none, od_GS);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-300");
    define(defn);

    //--- page 4-300 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  60             PUSHA         Invalid   Valid         Push AX, CX, DX, BX, original SP, BP, SI, and
    //                                                       DI.
    defn = new InsnDefn("pusha",  x86_pusha,   0x01, 0x60, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-300");
    define(defn);
    //  60             PUSHAD        Invalid   Valid         Push EAX, ECX, EDX, EBX, original ESP, EBP,
    //                                                       ESI, and EDI.
    defn = new InsnDefn("pushad", x86_pushad,  0x01, 0x60, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-303");
    define(defn);

    //--- page 4-303 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  9C              PUSHF             Valid      Valid      Push lower 16 bits of EFLAGS.
    defn = new InsnDefn("pushf",  x86_pushf,   0x03, 0x9c, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-303");
    define(defn);
    //  9C              PUSHFD            N.E.       Valid      Push EFLAGS.
    defn = new InsnDefn("pushfd", x86_pushfd,  0x01, 0x9c, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-303");
    define(defn);
    //  9C              PUSHFQ            Valid      N.E.       Push RFLAGS.
    defn = new InsnDefn("pushfq", x86_pushfq,  0x02, 0x9c, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-306");
    define(defn);

    //--- page 4-306 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F EF /r        PXOR mm, mm/m64             Valid     Valid        Bitwise XOR of
    //                                                                    mm/m64 and mm.
    defn = new InsnDefn("pxor",   x86_pxor,    0x03, 0x0fef, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-306");
    define(defn);
    // 66 0F EF /r     PXOR xmm1, xmm2/m128        Valid    Valid         Bitwise XOR of
    //                                                                    xmm2/m128 and
    //                                                                    xmm1.
    defn = new InsnDefn("pxor",   x86_pxor,    0x03, 0x660fef, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);

    //--- page 4-309 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  D0 /2            RCL r/m8, 1     Valid    Valid      Rotate 9 bits (CF, r/m8) left once.
    defn = new InsnDefn("rcl",    x86_rcl,     0x03, 0xd0, od_e2, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  REX + D0 /2      RCL r/m8*, 1    Valid    N.E.       Rotate 9 bits (CF, r/m8) left once.
    defn = new InsnDefn("rcl",    x86_rcl,     0x02, 0xd0, od_rex|od_e2, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  D2 /2            RCL r/m8, CL    Valid    Valid      Rotate 9 bits (CF, r/m8) left CL times.
    defn = new InsnDefn("rcl",    x86_rcl,     0x03, 0xd2, od_e2, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  REX + D2 /2      RCL r/m8*, CL   Valid    N.E.       Rotate 9 bits (CF, r/m8) left CL times.
    defn = new InsnDefn("rcl",    x86_rcl,     0x02, 0xd2, od_rex|od_e2, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  C0 /2 ib         RCL r/m8,       Valid    Valid      Rotate 9 bits (CF, r/m8) left imm8
    //                   imm8                                times.
    defn = new InsnDefn("rcl",    x86_rcl,     0x03, 0xc0, od_e2|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  REX + C0 /2 ib   RCL r/m8*,      Valid    N.E.       Rotate 9 bits (CF, r/m8) left imm8
    //                   imm8                                times.
    defn = new InsnDefn("rcl",    x86_rcl,     0x02, 0xc0, od_rex|od_e2|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  D1 /2            RCL r/m16, 1    Valid    Valid      Rotate 17 bits (CF, r/m16) left once.
    defn = new InsnDefn("rcl",    x86_rcl,     0x03, 0xd1, od_e2, od_r_m16, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  D3 /2            RCL r/m16, CL   Valid    Valid      Rotate 17 bits (CF, r/m16) left CL
    //                                                       times.
    defn = new InsnDefn("rcl",    x86_rcl,     0x03, 0xd3, od_e2, od_r_m16, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  C1 /2 ib         RCL r/m16,      Valid    Valid      Rotate 17 bits (CF, r/m16) left imm8
    //                   imm8                                times.
    defn = new InsnDefn("rcl",    x86_rcl,     0x03, 0xc1, od_e2|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  D1 /2            RCL r/m32, 1    Valid    Valid      Rotate 33 bits (CF, r/m32) left once.
    defn = new InsnDefn("rcl",    x86_rcl,     0x03, 0xd1, od_e2, od_r_m32, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  REX.W + D1 /2    RCL r/m64, 1    Valid    N.E.       Rotate 65 bits (CF, r/m64) left once.
    //                                                       Uses a 6 bit count.
    defn = new InsnDefn("rcl",    x86_rcl,     0x02, 0xd1, od_rexw|od_e2, od_r_m64, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  D3 /2            RCL r/m32, CL   Valid    Valid      Rotate 33 bits (CF, r/m32) left CL
    //                                                       times.
    defn = new InsnDefn("rcl",    x86_rcl,     0x03, 0xd3, od_e2, od_r_m32, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  REX.W + D3 /2    RCL r/m64, CL   Valid    N.E.       Rotate 65 bits (CF, r/m64) left CL
    //                                                       times. Uses a 6 bit count.
    defn = new InsnDefn("rcl",    x86_rcl,     0x02, 0xd3, od_rexw|od_e2, od_r_m64, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  C1 /2 ib         RCL r/m32,      Valid    Valid      Rotate 33 bits (CF, r/m32) left imm8
    //                   imm8                                times.
    defn = new InsnDefn("rcl",    x86_rcl,     0x03, 0xc1, od_e2|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  REX.W + C1 /2    RCL r/m64,      Valid    N.E.       Rotate 65 bits (CF, r/m64) left imm8
    //  ib               imm8                                times. Uses a 6 bit count.
    defn = new InsnDefn("rcl",    x86_rcl,     0x02, 0xc1, od_rexw|od_e2|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  D0 /3            RCR r/m8, 1     Valid    Valid      Rotate 9 bits (CF, r/m8) right once.
    defn = new InsnDefn("rcr",    x86_rcr,     0x03, 0xd0, od_e3, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  REX + D0 /3      RCR r/m8*, 1    Valid    N.E.       Rotate 9 bits (CF, r/m8) right once.
    defn = new InsnDefn("rcr",    x86_rcr,     0x02, 0xd0, od_rex|od_e3, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  D2 /3            RCR r/m8, CL    Valid    Valid      Rotate 9 bits (CF, r/m8) right CL
    //                                                       times.
    defn = new InsnDefn("rcr",    x86_rcr,     0x03, 0xd2, od_e3, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-309");
    define(defn);
    //  REX + D2 /3      RCR r/m8*, CL   Valid    N.E.       Rotate 9 bits (CF, r/m8) right CL
    //                                                       times.
    defn = new InsnDefn("rcr",    x86_rcr,     0x02, 0xd2, od_rex|od_e3, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // C0 /3 ib         RCR r/m8,       Valid    Valid      Rotate 9 bits (CF, r/m8) right imm8
    //                  imm8                                times.
    defn = new InsnDefn("rcr",    x86_rcr,     0x03, 0xc0, od_e3|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // REX + C0 /3 ib   RCR r/m8*,      Valid    N.E.       Rotate 9 bits (CF, r/m8) right imm8
    //                  imm8                                times.
    defn = new InsnDefn("rcr",    x86_rcr,     0x02, 0xc0, od_rex|od_e3|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // D1 /3            RCR r/m16, 1    Valid    Valid      Rotate 17 bits (CF, r/m16) right once.
    defn = new InsnDefn("rcr",    x86_rcr,     0x03, 0xd1, od_e3, od_r_m16, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // D3 /3            RCR r/m16, CL   Valid    Valid      Rotate 17 bits (CF, r/m16) right CL
    //                                                      times.
    defn = new InsnDefn("rcr",    x86_rcr,     0x03, 0xd3, od_e3, od_r_m16, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // C1 /3 ib         RCR r/m16,      Valid    Valid      Rotate 17 bits (CF, r/m16) right imm8
    //                  imm8                                times.
    defn = new InsnDefn("rcr",    x86_rcr,     0x03, 0xc1, od_e3|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // D1 /3            RCR r/m32, 1    Valid    Valid      Rotate 33 bits (CF, r/m32) right once.
    //                                                      Uses a 6 bit count.
    defn = new InsnDefn("rcr",    x86_rcr,     0x03, 0xd1, od_e3, od_r_m32, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // REX.W + D1 /3    RCR r/m64, 1    Valid    N.E.       Rotate 65 bits (CF, r/m64) right once.
    //                                                      Uses a 6 bit count.
    defn = new InsnDefn("rcr",    x86_rcr,     0x02, 0xd1, od_rexw|od_e3, od_r_m64, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // D3 /3            RCR r/m32, CL   Valid    Valid      Rotate 33 bits (CF, r/m32) right CL
    //                                                      times.
    defn = new InsnDefn("rcr",    x86_rcr,     0x03, 0xd3, od_e3, od_r_m32, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // REX.W + D3 /3    RCR r/m64, CL   Valid    N.E.       Rotate 65 bits (CF, r/m64) right CL
    //                                                      times. Uses a 6 bit count.
    defn = new InsnDefn("rcr",    x86_rcr,     0x02, 0xd3, od_rexw|od_e3, od_r_m64, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // C1 /3 ib         RCR r/m32,      Valid    Valid      Rotate 33 bits (CF, r/m32) right imm8
    //                  imm8                                times.
    defn = new InsnDefn("rcr",    x86_rcr,     0x03, 0xc1, od_e3|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // REX.W + C1 /3    RCR r/m64,      Valid    N.E.       Rotate 65 bits (CF, r/m64) right imm8
    // ib               imm8                                times. Uses a 6 bit count.
    defn = new InsnDefn("rcr",    x86_rcr,     0x02, 0xc1, od_rexw|od_e3|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // D0 /0            ROL r/m8, 1     Valid    Valid      Rotate 8 bits r/m8 left once.
    defn = new InsnDefn("rol",    x86_rol,     0x03, 0xd0, od_e0, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // REX + D0 /0      ROL r/m8*, 1    Valid    N.E.       Rotate 8 bits r/m8 left once
    defn = new InsnDefn("rol",    x86_rol,     0x02, 0xd0, od_rex|od_e0, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // D2 /0            ROL r/m8, CL    Valid    Valid      Rotate 8 bits r/m8 left CL times.
    defn = new InsnDefn("rol",    x86_rol,     0x03, 0xd2, od_e0, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // REX + D2 /0      ROL r/m8*, CL   Valid    N.E.       Rotate 8 bits r/m8 left CL times.
    defn = new InsnDefn("rol",    x86_rol,     0x02, 0xd2, od_rex|od_e0, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // C0 /0 ib         ROL r/m8,       Valid    Valid      Rotate 8 bits r/m8 left imm8 times.
    //                  imm8
    defn = new InsnDefn("rol",    x86_rol,     0x03, 0xc0, od_e0|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // REX + C0 /0 ib   ROL r/m8*,      Valid    N.E.       Rotate 8 bits r/m8 left imm8 times.
    //                  imm8
    defn = new InsnDefn("rol",    x86_rol,     0x02, 0xc0, od_rex|od_e0|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // D1 /0            ROL r/m16, 1    Valid    Valid      Rotate 16 bits r/m16 left once.
    defn = new InsnDefn("rol",    x86_rol,     0x03, 0xd1, od_e0, od_r_m16, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // D3 /0            ROL r/m16, CL   Valid    Valid      Rotate 16 bits r/m16 left CL times.
    defn = new InsnDefn("rol",    x86_rol,     0x03, 0xd3, od_e0, od_r_m16, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // C1 /0 ib         ROL r/m16,      Valid    Valid      Rotate 16 bits r/m16 left imm8
    //                  imm8                                times.
    defn = new InsnDefn("rol",    x86_rol,     0x03, 0xc1, od_e0|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-310");
    define(defn);
    // D1 /0            ROL r/m32, 1    Valid    Valid      Rotate 32 bits r/m32 left once.
    defn = new InsnDefn("rol",    x86_rol,     0x03, 0xd1, od_e0, od_r_m32, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  REX.W + D1 /0    ROL r/m64, 1      Valid        N.E.         Rotate 64 bits r/m64 left once. Uses
    //                                                               a 6 bit count.
    defn = new InsnDefn("rol",    x86_rol,     0x02, 0xd1, od_rexw|od_e0, od_r_m64, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  D3 /0            ROL r/m32, CL     Valid        Valid        Rotate 32 bits r/m32 left CL times.
    defn = new InsnDefn("rol",    x86_rol,     0x03, 0xd3, od_e0, od_r_m32, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  REX.W + D3 /0    ROL r/m64, CL     Valid        N.E.         Rotate 64 bits r/m64 left CL times.
    //                                                               Uses a 6 bit count.
    defn = new InsnDefn("rol",    x86_rol,     0x02, 0xd3, od_rexw|od_e0, od_r_m64, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  C1 /0 ib         ROL r/m32,        Valid        Valid        Rotate 32 bits r/m32 left imm8
    //                   imm8                                        times.
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
