//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "sage3basic.h"
#include "AssemblerX86.h"

/* Generated by ./IntelAssemblyBuilder from 
 * x86-InstructionSetReference-AM.pdf 
 * x86-InstructionSetReference-NZ.pdf 
 * ExtraInstructions.txt */
void AssemblerX86::initAssemblyRules_part5() {
    AssemblerX86::InsnDefn *defn = NULL;
    defn = new InsnDefn("movq",   x86_movq,    0x03, 0xf30f7e, od_none, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-710");
    define(defn);
    // 66 0F D6    MOVQ xmm2/m64, xmm1 Valid             Valid         Move quadword from xmm1 to
    //                                                                 xmm2/mem64.
    defn = new InsnDefn("movq",   x86_movq,    0x03, 0x660fd6, od_none, od_xmm_m64, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-713");
    define(defn);

    //--- page 3-713 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F3 0F D6   MOVQ2DQ xmm, mm       Valid     Valid           Move quadword from mmx to low
    //                                                             quadword of xmm.
    defn = new InsnDefn("movq2dq", x86_movq2dq, 0x03, 0xf30fd6, od_none, od_xmm, od_mm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-715");
    define(defn);

    //--- page 3-715 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //     A4           MOVS m8, m8     Valid     Valid       For legacy mode, Move byte from
    //                                                        address DS:(E)SI to ES:(E)DI. For 64-bit
    //                                                        mode move byte from address (R|E)SI
    //                                                        to (R|E)DI.
    // See MOVSB, MOVSW, MOVSD, or MOVSQ instead.
    // defn = new InsnDefn("movs",   x86_movs,    0x03, 0xa4, od_none, od_m8, od_m8);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-715");
    // define(defn);
    //     A5           MOVS m16, m16   Valid     Valid       For legacy mode, move word from
    //                                                        address DS:(E)SI to ES:(E)DI. For 64-bit
    //                                                        mode move word at address (R|E)SI to
    //                                                        (R|E)DI.
    // See MOVSB, MOVSW, MOVSD, or MOVSQ instead.
    // defn = new InsnDefn("movs",   x86_movs,    0x03, 0xa5, od_none, od_m16, od_m16);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-715");
    // define(defn);
    //     A5           MOVS m32, m32   Valid     Valid       For legacy mode, move dword from
    //                                                        address DS:(E)SI to ES:(E)DI. For 64-bit
    //                                                        mode move dword from address (R|E)SI
    //                                                        to (R|E)DI.
    // See MOVSB, MOVSW, MOVSD, or MOVSQ instead.
    // defn = new InsnDefn("movs",   x86_movs,    0x03, 0xa5, od_none, od_m32, od_m32);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-715");
    // define(defn);
    //     REX.W + A5   MOVS m64, m64   Valid     N.E.        Move qword from address (R|E)SI to
    //                                                        (R|E)DI.
    // See MOVSB, MOVSW, MOVSD, or MOVSQ instead.
    // defn = new InsnDefn("movs",   x86_movs,    0x02, 0xa5, od_rexw, od_m64, od_m64);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-715");
    // define(defn);
    //     A4           MOVSB           Valid     Valid       For legacy mode, Move byte from
    //                                                        address DS:(E)SI to ES:(E)DI. For 64-bit
    //                                                        mode move byte from address (R|E)SI
    //                                                        to (R|E)DI.
    defn = new InsnDefn("movsb",  x86_movsb,   0x03, 0xa4, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-715");
    define(defn);
    //     A5           MOVSW           Valid     Valid       For legacy mode, move word from
    //                                                        address DS:(E)SI to ES:(E)DI. For 64-bit
    //                                                        mode move word at address (R|E)SI to
    //                                                        (R|E)DI.
    defn = new InsnDefn("movsw",  x86_movsw,   0x03, 0xa5, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-715");
    define(defn);
    //     A5           MOVSD           Valid     Valid       For legacy mode, move dword from
    //                                                        address DS:(E)SI to ES:(E)DI. For 64-bit
    //                                                        mode move dword from address (R|E)SI
    //                                                        to (R|E)DI.
    defn = new InsnDefn("movsd",  x86_movsd,   0x03, 0xa5, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-715");
    define(defn);
    //     REX.W + A5   MOVSQ           Valid     N.E.        Move qword from address (R|E)SI to
    //                                                        (R|E)DI.
    defn = new InsnDefn("movsq",  x86_movsq,   0x02, 0xa5, od_rexw);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-720");
    define(defn);

    //--- page 3-720 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F2 0F 10 /r     MOVSD xmm1,        Valid     Valid           Move scalar double-precision
    //                 xmm2/m64                                     floating-point value from
    //                                                              xmm2/m64 to xmm1 register.
    defn = new InsnDefn("movsd",  x86_movsd_sse, 0x03, 0xf20f10, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-720");
    define(defn);
    // F2 0F 11 /r     MOVSD xmm2/m64, Valid        Valid           Move scalar double-precision
    //                 xmm1                                         floating-point value from xmm1
    //                                                              register to xmm2/m64.
    defn = new InsnDefn("movsd",  x86_movsd_sse, 0x03, 0xf20f11, od_modrm, od_xmm_m64, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-723");
    define(defn);

    //--- page 3-723 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F3 0F 16 /r    MOVSHDUP xmm1,          Valid    Valid               Move two single-precision floating-
    //                 xmm2/m128                                            point values from the higher 32-bit
    //                                                                      operand of each qword in
    //                                                                      xmm2/m128 to xmm1 and
    //                                                                      duplicate each 32-bit operand to
    //                                                                      the lower 32-bits of each qword.
    defn = new InsnDefn("movshdup", x86_movshdup, 0x03, 0xf30f16, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-726");
    define(defn);

    //--- page 3-726 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F3 0F 12 /r     MOVSLDUP xmm1,         Valid    Valid             Move two single-precision floating-point
    //                 xmm2/m128                                         values from the lower 32-bit operand of
    //                                                                   each qword in xmm2/m128 to xmm1
    //                                                                   and duplicate each 32-bit operand to
    //                                                                   the higher 32-bits of each qword.
    defn = new InsnDefn("movsldup", x86_movsldup, 0x03, 0xf30f12, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-729");
    define(defn);

    //--- page 3-729 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F3 0F 10 /r      MOVSS xmm1,            Valid      Valid      Move scalar single-precision
    //                   xmm2/m32                                     floating-point value from
    //                                                                xmm2/m32 to xmm1 register.
    defn = new InsnDefn("movss",  x86_movss,   0x03, 0xf30f10, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-729");
    define(defn);
    //  F3 0F 11 /r      MOVSS xmm2/m32, Valid             Valid      Move scalar single-precision
    //                   xmm                                          floating-point value from xmm1
    //                                                                register to xmm2/m32.
    defn = new InsnDefn("movss",  x86_movss,   0x03, 0xf30f11, od_modrm, od_xmm_m32, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-732");
    define(defn);

    //--- page 3-732 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F BE /r             MOVSX r16, r/m8        Valid      Valid          Move byte to word with sign-
    //                                                                       extension.
    defn = new InsnDefn("movsx",  x86_movsx,   0x03, 0x0fbe, od_modrm, od_r16, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-732");
    define(defn);
    // 0F BE /r             MOVSX r32, r/m8        Valid      Valid          Move byte to doubleword
    //                                                                       with sign-extension.
    defn = new InsnDefn("movsx",  x86_movsx,   0x03, 0x0fbe, od_modrm, od_r32, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-732");
    define(defn);
    // REX + 0F BE /r       MOVSX r64, r/m8*       Valid      N.E.           Move byte to quadword with
    //                                                                       sign-extension.
    defn = new InsnDefn("movsx",  x86_movsx,   0x02, 0x0fbe, od_rex|od_modrm, od_r64, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-732");
    define(defn);
    // 0F BF /r             MOVSX r32, r/m16       Valid      Valid          Move word to doubleword,
    //                                                                       with sign-extension.
    defn = new InsnDefn("movsx",  x86_movsx,   0x03, 0x0fbf, od_modrm, od_r32, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-732");
    define(defn);
    // REX.W + 0F BF /r     MOVSX r64, r/m16       Valid      N.E.           Move word to quadword with
    //                                                                       sign-extension.
    defn = new InsnDefn("movsx",  x86_movsx,   0x02, 0x0fbf, od_rexw|od_modrm, od_r64, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-732");
    define(defn);
    // REX.W** + 63 /r      MOVSXD r64, r/m32 Valid           N.E.           Move doubleword to
    //                                                                       quadword with sign-
    //                                                                       extension.
    defn = new InsnDefn("movsxd", x86_movsxd,  0x02, 0x63, od_rexw|od_modrm, od_r64, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-734");
    define(defn);

    //--- page 3-734 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F 10 /r     MOVUPD xmm1,        Valid      Valid          Move packed double-precision
    //                 xmm2/m128                                     floating-point values from
    //                                                               xmm2/m128 to xmm1.
    defn = new InsnDefn("movupd", x86_movupd,  0x03, 0x660f10, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-734");
    define(defn);
    // 66 0F 11 /r     MOVUPD              Valid      Valid          Move packed double-precision
    //                 xmm2/m128, xmm                                floating-point values from xmm1
    //                                                               to xmm2/m128.
    defn = new InsnDefn("movupd", x86_movupd,  0x03, 0x660f11, od_modrm, od_xmm_m128, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-737");
    define(defn);

    //--- page 3-737 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 10 /r     MOVUPS xmm1,               Valid     Valid        Move packed single-precision
    //               xmm2/m128                                         floating-point values from
    //                                                                 xmm2/m128 to xmm1.
    defn = new InsnDefn("movups", x86_movups,  0x03, 0x0f10, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-737");
    define(defn);
    //  0F 11 /r     MOVUPS xmm2/m128,          Valid     Valid        Move packed single-precision
    //               xmm1                                              floating-point values from xmm1 to
    //                                                                 xmm2/m128.
    defn = new InsnDefn("movups", x86_movups,  0x03, 0x0f11, od_modrm, od_xmm_m128, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-740");
    define(defn);

    //--- page 3-740 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F B6 /r           MOVZX r16, r/m8        Valid     Valid          Move byte to word with zero-
    //                                                                    extension.
    defn = new InsnDefn("movzx",  x86_movzx,   0x03, 0x0fb6, od_modrm, od_r16, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-740");
    define(defn);
    // 0F B6 /r           MOVZX r32, r/m8        Valid     Valid          Move byte to doubleword,
    //                                                                    zero-extension.
    defn = new InsnDefn("movzx",  x86_movzx,   0x03, 0x0fb6, od_modrm, od_r32, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-740");
    define(defn);
    // REX.W + 0F B6 /r   MOVZX r64, r/m8*       Valid     N.E.           Move byte to quadword, zero-
    //                                                                    extension.
    defn = new InsnDefn("movzx",  x86_movzx,   0x02, 0x0fb6, od_rexw|od_modrm, od_r64, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-740");
    define(defn);
    // 0F B7 /r           MOVZX r32, r/m16       Valid     Valid          Move word to doubleword,
    //                                                                    zero-extension.
    defn = new InsnDefn("movzx",  x86_movzx,   0x03, 0x0fb7, od_modrm, od_r32, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-740");
    define(defn);
    // REX.W + 0F B7 /r   MOVZX r64, r/m16       Valid     N.E.           Move word to quadword, zero-
    //                                                                    extension.
    defn = new InsnDefn("movzx",  x86_movzx,   0x02, 0x0fb7, od_rexw|od_modrm, od_r64, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-742");
    define(defn);

    //--- page 3-742 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F 3A    MPSADBW       Valid   Valid      Sums absolute 8-bit integer difference of adjacent
    // 42 /r ib    xmm1,                            groups of 4 byte integers in xmm1 and
    //             xmm2/m128,                       xmm2/m128 and writes the results in xmm1.
    //                imm8                          Starting offsets within xmm1 and xmm2/m128
    //                                              are determined by imm8.
    defn = new InsnDefn("mpsadbw", x86_mpsadbw, 0x03, 0x660f3a42, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-746");
    define(defn);

    //--- page 3-746 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F6 /4            MUL r/m8        Valid      Valid           Unsigned multiply (AX  AL  r/m8).
    //                             *
    defn = new InsnDefn("mul",    x86_mul,     0x03, 0xf6, od_e4, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-746");
    define(defn);
    // REX + F6 /4      MUL r/m8        Valid      N.E.            Unsigned multiply (AX  AL  r/m8).
    defn = new InsnDefn("mul",    x86_mul,     0x02, 0xf6, od_rex|od_e4, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-746");
    define(defn);
    // F7 /4            MUL r/m16       Valid      Valid           Unsigned multiply (DX:AX  AX
    //                                                             r/m16).
    defn = new InsnDefn("mul",    x86_mul,     0x03, 0xf7, od_e4, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-746");
    define(defn);
    // F7 /4            MUL r/m32       Valid      Valid           Unsigned multiply (EDX:EAX  EAX
    //                                                             r/m32).
    defn = new InsnDefn("mul",    x86_mul,     0x03, 0xf7, od_e4, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-746");
    define(defn);
    // REX.W + F7 /4    MUL r/m64       Valid      N.E.            Unsigned multiply (RDX:RAX  RAX
    //                                                             r/m64.
    defn = new InsnDefn("mul",    x86_mul,     0x02, 0xf7, od_rexw|od_e4, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-749");
    define(defn);

    //--- page 3-749 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  66 0F 59 /r MULPD xmm1,              Valid     Valid          Multiply packed double-precision
    //              xmm2/m128                                         floating-point values in xmm2/m128 by
    //                                                                xmm1.
    defn = new InsnDefn("mulpd",  x86_mulpd,   0x03, 0x660f59, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-752");
    define(defn);

    //--- page 3-752 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 59 /r    MULPS xmm1,      Valid        Valid          Multiply packed single-precision
    //             xmm2/m128                                    floating-point values in xmm2/mem by
    //                                                          xmm1.
    defn = new InsnDefn("mulps",  x86_mulps,   0x03, 0x0f59, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-755");
    define(defn);

    //--- page 3-755 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F2 0F 59 /r MULSD xmm1,               Valid      Valid        Multiply the low double-precision
    //              xmm2/m64                                          floating-point value in xmm2/mem64
    //                                                                by low double-precision floating-
    //                                                                point value in xmm1.
    defn = new InsnDefn("mulsd",  x86_mulsd,   0x03, 0xf20f59, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-758");
    define(defn);

    //--- page 3-758 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F3 0F 59 /r     MULSS xmm1,      Valid      Valid         Multiply the low single-precision floating-
    //                 xmm2/m32                                  point value in xmm2/mem by the low
    //                                                           single-precision floating-point value in
    //                                                           xmm1.
    defn = new InsnDefn("mulss",  x86_mulss,   0x03, 0xf30f59, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-761");
    define(defn);

    //--- page 3-761 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 01 C9      MWAIT         Valid    Valid      A hint that allow the processor to stop
    //                                                  instruction execution and enter an
    //                                                  implementation-dependent optimized state
    //                                                  until occurrence of a class of events.
    defn = new InsnDefn("mwait",  x86_mwait,   0x03, 0x0f01c9, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-765");
    define(defn);

    //------------------------------------------------------------------------------------------------------------------
    // The following definitions are from x86-InstructionSetReference-NZ.pdf, version March 2009.
    //------------------------------------------------------------------------------------------------------------------


    //--- page 4-2 of x86-InstructionSetReference-NZ.pdf ---------------------------------------------------------------
    // F6 /3               NEG r/m8      Valid          Valid            Two's complement negate r/m8.
    defn = new InsnDefn("neg",    x86_neg,     0x03, 0xf6, od_e3, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-2");
    define(defn);
    // REX + F6 /3         NEG r/m8*     Valid          N.E.             Two's complement negate r/m8.
    defn = new InsnDefn("neg",    x86_neg,     0x02, 0xf6, od_rex|od_e3, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-2");
    define(defn);
    // F7 /3               NEG r/m16     Valid          Valid            Two's complement negate
    //                                                                   r/m16.
    defn = new InsnDefn("neg",    x86_neg,     0x03, 0xf7, od_e3, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-2");
    define(defn);
    // F7 /3               NEG r/m32     Valid          Valid            Two's complement negate
    //                                                                   r/m32.
    defn = new InsnDefn("neg",    x86_neg,     0x03, 0xf7, od_e3, od_r_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-2");
    define(defn);
    // REX.W + F7 /3       NEG r/m64     Valid          N.E.             Two's complement negate
    //                                                                   r/m64.
    defn = new InsnDefn("neg",    x86_neg,     0x02, 0xf7, od_rexw|od_e3, od_r_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-5");
    define(defn);

    //--- page 4-5 of x86-InstructionSetReference-NZ.pdf ---------------------------------------------------------------
    //  90              NOP           Valid      Valid           One byte no-operation instruction.
    defn = new InsnDefn("nop",    x86_nop,     0x03, 0x90, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-5");
    define(defn);
    //  0F 1F /0        NOP r/m16     Valid      Valid           Multi-byte no-operation instruction.
    defn = new InsnDefn("nop",    x86_nop,     0x03, 0x0f1f, od_e0, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-5");
    define(defn);
    //  0F 1F /0        NOP r/m32     Valid      Valid           Multi-byte no-operation instruction.
    defn = new InsnDefn("nop",    x86_nop,     0x03, 0x0f1f, od_e0, od_r_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-7");
    define(defn);

    //--- page 4-7 of x86-InstructionSetReference-NZ.pdf ---------------------------------------------------------------
    //  F6 /2            NOT r/m8       Valid         Valid           Reverse each bit of r/m8.
    defn = new InsnDefn("not",    x86_not,     0x03, 0xf6, od_e2, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-7");
    define(defn);
    //  REX + F6 /2      NOT r/m8*      Valid         N.E.            Reverse each bit of r/m8.
    defn = new InsnDefn("not",    x86_not,     0x02, 0xf6, od_rex|od_e2, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-7");
    define(defn);
    //  F7 /2            NOT r/m16      Valid         Valid           Reverse each bit of r/m16.
    defn = new InsnDefn("not",    x86_not,     0x03, 0xf7, od_e2, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-7");
    define(defn);
    //  F7 /2            NOT r/m32      Valid         Valid           Reverse each bit of r/m32.
    defn = new InsnDefn("not",    x86_not,     0x03, 0xf7, od_e2, od_r_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-7");
    define(defn);
    //  REX.W + F7 /2    NOT r/m64      Valid         N.E.            Reverse each bit of r/m64.
    defn = new InsnDefn("not",    x86_not,     0x02, 0xf7, od_rexw|od_e2, od_r_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);

    //--- page 4-9 of x86-InstructionSetReference-NZ.pdf ---------------------------------------------------------------
    //  0C ib                    OR AL, imm8       Valid        Valid            AL OR imm8.
    defn = new InsnDefn("or",     x86_or,      0x03, 0x0c, od_ib, od_AL, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  0D iw                    OR AX, imm16      Valid        Valid            AX OR imm16.
    defn = new InsnDefn("or",     x86_or,      0x03, 0x0d, od_iw, od_AX, od_imm16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  0D id                    OR EAX, imm32     Valid        Valid            EAX OR imm32.
    defn = new InsnDefn("or",     x86_or,      0x03, 0x0d, od_id, od_EAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  REX.W + 0D id            OR RAX, imm32     Valid        N.E.             RAX OR imm32 (sign-
    //                                                                           extended).
    defn = new InsnDefn("or",     x86_or,      0x02, 0x0d, od_rexw|od_id, od_RAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  80 /1 ib                 OR r/m8, imm8     Valid        Valid            r/m8 OR imm8.
    defn = new InsnDefn("or",     x86_or,      0x03, 0x80, od_e1|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  REX + 80 /1 ib           OR r/m8*, imm8    Valid        N.E.             r/m8 OR imm8.
    defn = new InsnDefn("or",     x86_or,      0x02, 0x80, od_rex|od_e1|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  81 /1 iw                 OR r/m16, imm16   Valid        Valid            r/m16 OR imm16.
    defn = new InsnDefn("or",     x86_or,      0x03, 0x81, od_e1|od_iw, od_r_m16, od_imm16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  81 /1 id                 OR r/m32, imm32   Valid        Valid            r/m32 OR imm32.
    defn = new InsnDefn("or",     x86_or,      0x03, 0x81, od_e1|od_id, od_r_m32, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  REX.W + 81 /1 id         OR r/m64, imm32   Valid        N.E.             r/m64 OR imm32 (sign-
    //                                                                           extended).
    defn = new InsnDefn("or",     x86_or,      0x02, 0x81, od_rexw|od_e1|od_id, od_r_m64, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  83 /1 ib                 OR r/m16, imm8    Valid        Valid            r/m16 OR imm8 (sign-
    //                                                                           extended).
    defn = new InsnDefn("or",     x86_or,      0x03, 0x83, od_e1|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  83 /1 ib                 OR r/m32, imm8    Valid        Valid            r/m32 OR imm8 (sign-
    //                                                                           extended).
    defn = new InsnDefn("or",     x86_or,      0x03, 0x83, od_e1|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  REX.W + 83 /1 ib         OR r/m64, imm8    Valid        N.E.             r/m64 OR imm8 (sign-
    //                                                                           extended).
    defn = new InsnDefn("or",     x86_or,      0x02, 0x83, od_rexw|od_e1|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  08 /r                    OR r/m8, r8       Valid        Valid            r/m8 OR r8.
    defn = new InsnDefn("or",     x86_or,      0x03, 0x08, od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  REX + 08 /r              OR r/m8*, r8*     Valid        N.E.             r/m8 OR r8.
    defn = new InsnDefn("or",     x86_or,      0x02, 0x08, od_rex|od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  09 /r                    OR r/m16, r16     Valid        Valid            r/m16 OR r16.
    defn = new InsnDefn("or",     x86_or,      0x03, 0x09, od_modrm, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  09 /r                    OR r/m32, r32     Valid        Valid            r/m32 OR r32.
    defn = new InsnDefn("or",     x86_or,      0x03, 0x09, od_modrm, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  REX.W + 09 /r            OR r/m64, r64     Valid        N.E.             r/m64 OR r64.
    defn = new InsnDefn("or",     x86_or,      0x02, 0x09, od_rexw|od_modrm, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  0A /r                    OR r8, r/m8       Valid        Valid            r8 OR r/m8.
    defn = new InsnDefn("or",     x86_or,      0x03, 0x0a, od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  REX + 0A /r              OR r8*, r/m8*     Valid        N.E.             r8 OR r/m8.
    defn = new InsnDefn("or",     x86_or,      0x02, 0x0a, od_rex|od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  0B /r                    OR r16, r/m16     Valid        Valid            r16 OR r/m16.
    defn = new InsnDefn("or",     x86_or,      0x03, 0x0b, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  0B /r                    OR r32, r/m32     Valid        Valid            r32 OR r/m32.
    defn = new InsnDefn("or",     x86_or,      0x03, 0x0b, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-9");
    define(defn);
    //  REX.W + 0B /r            OR r64, r/m64     Valid        N.E.             r64 OR r/m64.
    defn = new InsnDefn("or",     x86_or,      0x02, 0x0b, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-12");
    define(defn);

    //--- page 4-12 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // 66 0F 56 /r    ORPD xmm1, xmm2/m128       Valid      Valid           Bitwise OR of xmm2/m128
    //                                                                      and xmm1.
    defn = new InsnDefn("orpd",   x86_orpd,    0x03, 0x660f56, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-14");
    define(defn);

    //--- page 4-14 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // 0F 56 /r        ORPS xmm1, xmm2/m128        Valid        Valid             Bitwise OR of
    //                                                                            xmm2/m128 and
    //                                                                            xmm1.
    defn = new InsnDefn("orps",   x86_orps,    0x03, 0x0f56, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-16");
    define(defn);

    //--- page 4-16 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // E6 ib            OUT imm8, AL        Valid       Valid      Output byte in AL to I/O port
    //                                                             address imm8.
    defn = new InsnDefn("out",    x86_out,     0x03, 0xe6, od_ib, od_imm8, od_AL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-16");
    define(defn);
    // E7 ib            OUT imm8, AX        Valid       Valid      Output word in AX to I/O port
    //                                                             address imm8.
    defn = new InsnDefn("out",    x86_out,     0x03, 0xe7, od_ib, od_imm8, od_AX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-16");
    define(defn);
    // E7 ib            OUT imm8, EAX       Valid       Valid      Output doubleword in EAX to I/O
    //                                                             port address imm8.
    defn = new InsnDefn("out",    x86_out,     0x03, 0xe7, od_ib, od_imm8, od_EAX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-16");
    define(defn);
    // EE               OUT DX, AL          Valid       Valid      Output byte in AL to I/O port
    //                                                             address in DX.
    defn = new InsnDefn("out",    x86_out,     0x03, 0xee, od_none, od_DX, od_AL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-16");
    define(defn);
    // EF               OUT DX, AX          Valid       Valid      Output word in AX to I/O port
    //                                                             address in DX.
    defn = new InsnDefn("out",    x86_out,     0x03, 0xef, od_none, od_DX, od_AX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-16");
    define(defn);
    // EF               OUT DX, EAX         Valid       Valid      Output doubleword in EAX to I/O
    //                                                             port address in DX.
    defn = new InsnDefn("out",    x86_out,     0x03, 0xef, od_none, od_DX, od_EAX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-18");
    define(defn);

    //--- page 4-18 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // 6E                OUTS DX, m8        Valid           Valid          Output byte from memory
    //                                                                     location specified in DS:(E)SI or
    //                                                                     RSI to I/O port specified in DX**.
    defn = new InsnDefn("outs",   x86_outs,    0x03, 0x6e, od_none, od_DX, od_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-18");
    define(defn);
    // 6F                OUTS DX, m16       Valid           Valid          Output word from memory
    //                                                                     location specified in DS:(E)SI or
    //                                                                     RSI to I/O port specified in DX**.
    defn = new InsnDefn("outs",   x86_outs,    0x03, 0x6f, od_none, od_DX, od_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-18");
    define(defn);
    // 6F                OUTS DX, m32       Valid           Valid          Output doubleword from
    //                                                                     memory location specified in
    //                                                                     DS:(E)SI or RSI to I/O port
    //                                                                     specified in DX**.
    defn = new InsnDefn("outs",   x86_outs,    0x03, 0x6f, od_none, od_DX, od_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-18");
    define(defn);
    // 6E                OUTSB              Valid           Valid          Output byte from memory
    //                                                                     location specified in DS:(E)SI or
    //                                                                     RSI to I/O port specified in DX**.
    defn = new InsnDefn("outsb",  x86_outsb,   0x03, 0x6e, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-18");
    define(defn);
    // 6F                OUTSW              Valid           Valid          Output word from memory
    //                                                                     location specified in DS:(E)SI or
    //                                                                     RSI to I/O port specified in DX**.
    defn = new InsnDefn("outsw",  x86_outsw,   0x03, 0x6f, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-18");
    define(defn);
    // 6F                OUTSD              Valid           Valid          Output doubleword from
    //                                                                     memory location specified in
    //                                                                     DS:(E)SI or RSI to I/O port
    //                                                                     specified in DX**.
    defn = new InsnDefn("outsd",  x86_outsd,   0x03, 0x6f, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-23");
    define(defn);

    //--- page 4-23 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  0F 38 1C /r     PABSB mm1,          Valid       Valid      Compute the absolute value of
    //                  mm2/m64                                    bytes in mm2/m64 and store
    //                                                             UNSIGNED result in mm1.
    defn = new InsnDefn("pabsb",  x86_pabsb,   0x03, 0x0f381c, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-23");
    define(defn);
    //  66 0F 38 1C /r PABSB xmm1,          Valid       Valid      Compute the absolute value of
    //                 xmm2/m128                                   bytes in xmm2/m128 and store
    //                                                             UNSIGNED result in xmm1.
    defn = new InsnDefn("pabsb",  x86_pabsb,   0x03, 0x660f381c, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-23");
    define(defn);
    //  0F 38 1D /r     PABSW mm1,          Valid       Valid      Compute the absolute value of 16-
    //                  mm2/m64                                    bit integers in mm2/m64 and store
    //                                                             UNSIGNED result in mm1.
    defn = new InsnDefn("pabsw",  x86_pabsw,   0x03, 0x0f381d, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-23");
    define(defn);
    //  66 0F 38 1D /r PABSW xmm1,          Valid       Valid      Compute the absolute value of 16-
    //                 xmm2/m128                                   bit integers in xmm2/m128 and
    //                                                             store UNSIGNED result in xmm1.
    defn = new InsnDefn("pabsw",  x86_pabsw,   0x03, 0x660f381d, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-23");
    define(defn);
    //  0F 38 1E /r     PABSD mm1,          Valid       Valid      Compute the absolute value of 32-
    //                  mm2/m64                                    bit integers in mm2/m64 and store
    //                                                             UNSIGNED result in mm1.
    defn = new InsnDefn("pabsd",  x86_pabsd,   0x03, 0x0f381e, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-23");
    define(defn);
    //  66 0F 38 1E /r PABSD xmm1,          Valid       Valid      Compute the absolute value of 32-
    //                 xmm2/m128                                   bit integers in xmm2/m128 and
    //                                                             store UNSIGNED result in xmm1.
    defn = new InsnDefn("pabsd",  x86_pabsd,   0x03, 0x660f381e, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-27");
    define(defn);

    //--- page 4-27 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  0F 63 /r       PACKSSWB mm1,          Valid              Valid            Converts 4 packed signed word
    //                 mm2/m64                                                    integers from mm1 and from
    //                                                                            mm2/m64 into 8 packed signed
    //                                                                            byte integers in mm1 using signed
    //                                                                            saturation.
    defn = new InsnDefn("packsswb", x86_packsswb, 0x03, 0x0f63, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-27");
    define(defn);
    //  66 0F 63 /r    PACKSSWB xmm1,         Valid              Valid            Converts 8 packed signed word
    //                 xmm2/m128                                                  integers from xmm1 and from
    //                                                                            xxm2/m128 into 16 packed signed
    //                                                                            byte integers in xxm1 using signed
    //                                                                            saturation.
    defn = new InsnDefn("packsswb", x86_packsswb, 0x03, 0x660f63, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-27");
    define(defn);
    //  0F 6B /r       PACKSSDW mm1,          Valid              Valid            Converts 2 packed signed
    //                 mm2/m64                                                    doubleword integers from mm1 and
    //                                                                            from mm2/m64 into 4 packed
    //                                                                            signed word integers in mm1 using
    //                                                                            signed saturation.
    defn = new InsnDefn("packssdw", x86_packssdw, 0x03, 0x0f6b, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-27");
    define(defn);
    //  66 0F 6B /r    PACKSSDW xmm1,         Valid              Valid            Converts 4 packed signed
    //                 xmm2/m128                                                  doubleword integers from xmm1
    //                                                                            and from xxm2/m128 into 8 packed
    //                                                                            signed word integers in xxm1 using
    //                                                                            signed saturation.
    defn = new InsnDefn("packssdw", x86_packssdw, 0x03, 0x660f6b, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-32");
    define(defn);

    //--- page 4-32 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // 66 0F    PACKUSDW xmm1,       Valid   Valid      Convert 4 packed signed doubleword integers
    // 38 2B /r xmm2/m128                               from xmm1 and 4 packed signed doubleword
    //                                                  integers from xmm2/m128 into 8 packed
    //                                                  unsigned word integers in xmm1 using
    //                                                  unsigned saturation.
    defn = new InsnDefn("packusdw", x86_packusdw, 0x03, 0x660f382b, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-35");
    define(defn);

    //--- page 4-35 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  0F 67 /r       PACKUSWB mm,         Valid    Valid      Converts 4 signed word integers
    //                 mm/m64                                   from mm and 4 signed word
    //                                                          integers from mm/m64 into 8
    //                                                          unsigned byte integers in mm using
    //                                                          unsigned saturation.
    defn = new InsnDefn("packuswb", x86_packuswb, 0x03, 0x0f67, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-35");
    define(defn);
    //  66 0F 67 /r    PACKUSWB xmm1,       Valid    Valid      Converts 8 signed word integers
    //                 xmm2/m128                                from xmm1 and 8 signed word
    //                                                          integers from xmm2/m128 into 16
    //                                                          unsigned byte integers in xmm1
    //                                                          using unsigned saturation.
    defn = new InsnDefn("packuswb", x86_packuswb, 0x03, 0x660f67, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-39");
    define(defn);

    //--- page 4-39 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  0F FC /r      PADDB mm,         Valid    Valid      Add packed byte integers from
    //                mm/m64                                mm/m64 and mm.
    defn = new InsnDefn("paddb",  x86_paddb,   0x03, 0x0ffc, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-39");
    define(defn);
    //  66 0F FC /r   PADDB xmm1,       Valid    Valid      Add packed byte integers from
    //                xmm2/m128                             xmm2/m128 and xmm1.
    defn = new InsnDefn("paddb",  x86_paddb,   0x03, 0x660ffc, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-39");
    define(defn);
    //  0F FD /r      PADDW mm,         Valid    Valid      Add packed word integers from
    //                mm/m64                                mm/m64 and mm.
    defn = new InsnDefn("paddw",  x86_paddw,   0x03, 0x0ffd, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-39");
    define(defn);
    //  66 0F FD /r   PADDW xmm1,       Valid    Valid      Add packed word integers from
    //                xmm2/m128                             xmm2/m128 and xmm1.
    defn = new InsnDefn("paddw",  x86_paddw,   0x03, 0x660ffd, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-39");
    define(defn);
    //  0F FE /r      PADDD mm,         Valid    Valid      Add packed doubleword integers from
    //                mm/m64                                mm/m64 and mm.
    defn = new InsnDefn("paddd",  x86_paddd,   0x03, 0x0ffe, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-39");
    define(defn);
    //  66 0F FE /r   PADDD xmm1,       Valid    Valid      Add packed doubleword integers from
    //                xmm2/m128                             xmm2/m128 and xmm1.
    defn = new InsnDefn("paddd",  x86_paddd,   0x03, 0x660ffe, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-43");
    define(defn);

    //--- page 4-43 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  0F D4 /r      PADDQ mm1,            Valid      Valid        Add quadword integer
    //                mm2/m64                                       mm2/m64 to mm1.
    defn = new InsnDefn("paddq",  x86_paddq,   0x03, 0x0fd4, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-43");
    define(defn);
    //  66 0F D4 /r   PADDQ xmm1,           Valid      Valid        Add packed quadword integers
    //                xmm2/m128                                     xmm2/m128 to xmm1.
    defn = new InsnDefn("paddq",  x86_paddq,   0x03, 0x660fd4, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-46");
    define(defn);

    //--- page 4-46 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // 0F EC /r       PADDSB mm,           Valid      Valid          Add packed signed byte integers
    //                mm/m64                                         from mm/m64 and mm and
    //                                                               saturate the results.
    defn = new InsnDefn("paddsb", x86_paddsb,  0x03, 0x0fec, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-46");
    define(defn);
    // 66 0F EC /r    PADDSB xmm1,         Valid      Valid          Add packed signed byte integers
    //                xmm2/m128                                      from xmm2/m128 and xmm1
    //                                                               saturate the results.
    defn = new InsnDefn("paddsb", x86_paddsb,  0x03, 0x660fec, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-46");
    define(defn);
    // 0F ED /r       PADDSW mm,           Valid      Valid          Add packed signed word integers
    //                mm/m64                                         from mm/m64 and mm and
    //                                                               saturate the results.
    defn = new InsnDefn("paddsw", x86_paddsw,  0x03, 0x0fed, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-46");
    define(defn);
    // 66 0F ED /r    PADDSW xmm1,         Valid      Valid          Add packed signed word integers
    //                xmm2/m128                                      from xmm2/m128 and xmm1
    //                                                               and saturate the results.
    defn = new InsnDefn("paddsw", x86_paddsw,  0x03, 0x660fed, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-50");
    define(defn);

    //--- page 4-50 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // 0F DC /r       PADDUSB mm,             Valid     Valid        Add packed unsigned byte integers
    //                mm/m64                                         from mm/m64 and mm and
    //                                                               saturate the results.
    defn = new InsnDefn("paddusb", x86_paddusb, 0x03, 0x0fdc, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-50");
    define(defn);
    // 66 0F DC /r    PADDUSB xmm1,           Valid     Valid        Add packed unsigned byte integers
    //                xmm2/m128                                      from xmm2/m128 and xmm1
    //                                                               saturate the results.
    defn = new InsnDefn("paddusb", x86_paddusb, 0x03, 0x660fdc, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-50");
    define(defn);
    // 0F DD /r       PADDUSW mm,             Valid     Valid        Add packed unsigned word
    //                mm/m64                                         integers from mm/m64 and mm
    //                                                               and saturate the results.
    defn = new InsnDefn("paddusw", x86_paddusw, 0x03, 0x0fdd, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-50");
    define(defn);
    // 66 0F DD /r    PADDUSW xmm1,           Valid     Valid        Add packed unsigned word
    //                xmm2/m128                                      integers from xmm2/m128 to
    //                                                               xmm1 and saturate the results.
    defn = new InsnDefn("paddusw", x86_paddusw, 0x03, 0x660fdd, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-54");
    define(defn);

    //--- page 4-54 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // 0F 3A 0F        PALIGNR mm1,        Valid     Valid         Concatenate destination and source
    //                 mm2/m64, imm8                               operands, extract byte-aligned
    //                                                             result shifted to the right by
    //                                                             constant value in imm8 into mm1.
    defn = new InsnDefn("palignr", x86_palignr, 0x03, 0x0f3a0f, od_ib, od_mm, od_mm_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-54");
    define(defn);
    // 66 0F 3A 0F     PALIGNR xmm1,       Valid     Valid         Concatenate destination and source
    //                 xmm2/m128,                                  operands, extract byte-aligned
    //                 imm8                                        result shifted to the right by
    //                                                             constant value in imm8 into xmm1
    defn = new InsnDefn("palignr", x86_palignr, 0x03, 0x660f3a0f, od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-57");
    define(defn);

    //--- page 4-57 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  0F DB /r       PAND mm, mm/m64           Valid    Valid         Bitwise AND mm/m64 and
    //                                                                  mm.
    defn = new InsnDefn("pand",   x86_pand,    0x03, 0x0fdb, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-57");
    define(defn);
    //  66 0F DB /r    PAND xmm1, xmm2/m128      Valid    Valid         Bitwise AND of
    //                                                                  xmm2/m128 and xmm1.
    defn = new InsnDefn("pand",   x86_pand,    0x03, 0x660fdb, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-60");
    define(defn);

    //--- page 4-60 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // 0F DF /r       PANDN mm, mm/m64             Valid    Valid         Bitwise AND NOT of
    //                                                                    mm/m64 and mm.
    defn = new InsnDefn("pandn",  x86_pandn,   0x03, 0x0fdf, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-60");
    define(defn);
    // 66 0F DF /r    PANDN xmm1, xmm2/m128        Valid    Valid         Bitwise AND NOT of
    //                                                                    xmm2/m128 and
    //                                                                    xmm1.
    defn = new InsnDefn("pandn",  x86_pandn,   0x03, 0x660fdf, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-63");
    define(defn);

    //--- page 4-63 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  F3 90        PAUSE         Valid    Valid      Gives hint to processor that improves
    //                                                 performance of spin-wait loops.
    defn = new InsnDefn("pause",  x86_pause,   0x03, 0xf390, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-64");
    define(defn);

    //--- page 4-64 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // 0F E0 /r        PAVGB mm1,        Valid      Valid         Average packed unsigned byte
    //                 mm2/m64                                    integers from mm2/m64 and mm1
    //                                                            with rounding.
    defn = new InsnDefn("pavgb",  x86_pavgb,   0x03, 0x0fe0, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-64");
    define(defn);
    // 66 0F E0, /r    PAVGB xmm1,       Valid      Valid         Average packed unsigned byte
    //                 xmm2/m128                                  integers from xmm2/m128 and xmm1
    //                                                            with rounding.
    defn = new InsnDefn("pavgb",  x86_pavgb,   0x03, 0x660fe0, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-64");
    define(defn);
    // 0F E3 /r        PAVGW mm1,        Valid      Valid         Average packed unsigned word
    //                 mm2/m64                                    integers from mm2/m64 and mm1
    //                                                            with rounding.
    defn = new InsnDefn("pavgw",  x86_pavgw,   0x03, 0x0fe3, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-64");
    define(defn);
    // 66 0F E3 /r     PAVGW xmm1,       Valid      Valid         Average packed unsigned word
    //                 xmm2/m128                                  integers from xmm2/m128 and xmm1
    //                                                            with rounding.
    defn = new InsnDefn("pavgw",  x86_pavgw,   0x03, 0x660fe3, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-68");
    define(defn);

    //--- page 4-68 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // 66 0F 38 10 PBLENDVB xmm1,            Valid    Valid    Select byte values from xmm1 and
    // /r          xmm2/m128,                                  xmm2/m128 from mask specified in
    //             <XMM0>                                      the high bit of each byte in XMM0
    //                                                         and store the values into xmm1.
    defn = new InsnDefn("pblendvb", x86_pblendvb, 0x03, 0x660f3810, od_modrm, od_xmm, od_xmm_m128, od_XMM0);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-72");
    define(defn);

    //--- page 4-72 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // 66 0F 3A       PBLENDW xmm1,   Valid         Valid      Select words from xmm1 and
    // 0E /r ib       xmm2/m128, imm8                          xmm2/m128 from mask specified in
    //                                                         imm8 and store the values into
    //                                                         xmm1.
    defn = new InsnDefn("pblendw", x86_pblendw, 0x03, 0x660f3a0e, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-75");
    define(defn);

    //--- page 4-75 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  0F 74 /r      PCMPEQB mm,            Valid      Valid          Compare packed bytes in
    //                mm/m64                                           mm/m64 and mm for equality.
    defn = new InsnDefn("pcmpeqb", x86_pcmpeqb, 0x03, 0x0f74, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-75");
    define(defn);
    //  66 0F 74 /r   PCMPEQB xmm1,          Valid      Valid          Compare packed bytes in
    //                xmm2/m128                                        xmm2/m128 and xmm1 for
    //                                                                 equality.
    defn = new InsnDefn("pcmpeqb", x86_pcmpeqb, 0x03, 0x660f74, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-75");
    define(defn);
    //  0F 75 /r      PCMPEQW mm,            Valid      Valid          Compare packed words in
    //                mm/m64                                           mm/m64 and mm for equality.
    defn = new InsnDefn("pcmpeqw", x86_pcmpeqw, 0x03, 0x0f75, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-75");
    define(defn);
    //  66 0F 75 /r   PCMPEQW xmm1,          Valid      Valid          Compare packed words in
    //                xmm2/m128                                        xmm2/m128 and xmm1 for
    //                                                                 equality.
    defn = new InsnDefn("pcmpeqw", x86_pcmpeqw, 0x03, 0x660f75, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-75");
    define(defn);
    //  0F 76 /r      PCMPEQD mm,            Valid      Valid          Compare packed doublewords in
    //                mm/m64                                           mm/m64 and mm for equality.
    defn = new InsnDefn("pcmpeqd", x86_pcmpeqd, 0x03, 0x0f76, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-75");
    define(defn);
    //  66 0F 76 /r   PCMPEQD xmm1,          Valid      Valid          Compare packed doublewords in
    //                xmm2/m128                                        xmm2/m128 and xmm1 for
    //                                                                 equality.
    defn = new InsnDefn("pcmpeqd", x86_pcmpeqd, 0x03, 0x660f76, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-79");
    define(defn);

    //--- page 4-79 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  66 0F 38     PCMPEQQ xmm1,         Valid       Valid      Compare packed qwords in
    //  29 /r        xmm2/m128                                    xmm2/m128 and xmm1 for
    //                                                            equality.
    defn = new InsnDefn("pcmpeqq", x86_pcmpeqq, 0x03, 0x660f3829, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-81");
    define(defn);

    //--- page 4-81 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //   66 0F 3A 61       PCMPESTRI           Valid      Valid           Perform a packed comparison of
    //   /r imm8           xmm1,                                          string data with explicit lengths,
    //                     xmm2/m128,                                     generating an index, and storing the
    //                     imm8                                           result in ECX.
    defn = new InsnDefn("pcmpestri", x86_pcmpestri, 0x03, 0x660f3a61, od_modrm, od_imm8, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-84");
    define(defn);

    //--- page 4-84 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  66 0F 3A 60    PCMPESTRM             Valid     Valid         Perform a packed comparison of
    //  /r imm8        xmm1,                                         string data with explicit lengths,
    //                 xmm2/m128,                                    generating a mask, and storing the
    //                 imm8                                          result in XMM0
    defn = new InsnDefn("pcmpestrm", x86_pcmpestrm, 0x03, 0x660f3a60, od_modrm, od_imm8, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-87");
    define(defn);

    //--- page 4-87 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //   66 0F 3A        PCMPISTRI xmm1,          Valid      Valid         Perform a packed comparison of
    //   63 /r imm8      xmm2/m128,                                        string data with implicit lengths,
    //                   imm8                                              generating an index, and storing
    //                                                                     the result in ECX.
    defn = new InsnDefn("pcmpistri", x86_pcmpistri, 0x03, 0x660f3a63, od_modrm, od_xmm, od_imm8, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-90");
    define(defn);

    //--- page 4-90 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  66 0F 3A         PCMPISTRM xmm1,     Valid     Valid         Perform a packed comparison of
    //  62 /r imm8       xmm2/m128, imm8                             string data with implicit lengths,
    //                                                               generating a mask, and storing
    //                                                               the result in XMM0.
    defn = new InsnDefn("pcmpistrm", x86_pcmpistrm, 0x03, 0x660f3a62, od_modrm, od_xmm, od_imm8, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-93");
    define(defn);

    //--- page 4-93 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  0F 64 /r       PCMPGTB mm,             Valid     Valid        Compare packed signed byte
    //                 mm/m64                                         integers in mm and mm/m64 for
    //                                                                greater than.
    defn = new InsnDefn("pcmpgtb", x86_pcmpgtb, 0x03, 0x0f64, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-93");
    define(defn);
    //  66 0F 64 /r    PCMPGTB xmm1,           Valid     Valid        Compare packed signed byte
    //                 xmm2/m128                                      integers in xmm1 and
    //                                                                xmm2/m128 for greater than.
    defn = new InsnDefn("pcmpgtb", x86_pcmpgtb, 0x03, 0x660f64, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-93");
    define(defn);
    //  0F 65 /r       PCMPGTW mm,             Valid     Valid        Compare packed signed word
    //                 mm/m64                                         integers in mm and mm/m64 for
    //                                                                greater than.
    defn = new InsnDefn("pcmpgtw", x86_pcmpgtw, 0x03, 0x0f65, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-93");
    define(defn);
    //  66 0F 65 /r    PCMPGTW xmm1,           Valid     Valid        Compare packed signed word
    //                 xmm2/m128                                      integers in xmm1 and
    //                                                                xmm2/m128 for greater than.
    defn = new InsnDefn("pcmpgtw", x86_pcmpgtw, 0x03, 0x660f65, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-93");
    define(defn);
    //  0F 66 /r       PCMPGTD mm,             Valid     Valid        Compare packed signed
    //                 mm/m64                                         doubleword integers in mm and
    //                                                                mm/m64 for greater than.
    defn = new InsnDefn("pcmpgtd", x86_pcmpgtd, 0x03, 0x0f66, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-93");
    define(defn);
    //  66 0F 66 /r    PCMPGTD xmm1,           Valid     Valid        Compare packed signed
    //                 xmm2/m128                                      doubleword integers in xmm1
    //                                                                and xmm2/m128 for greater
    //                                                                than.
    defn = new InsnDefn("pcmpgtd", x86_pcmpgtd, 0x03, 0x660f66, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-98");
    define(defn);

    //--- page 4-98 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  66 0F 38      PCMPGTQ           Valid      Valid         Compare packed qwords in
    //  37 /r         xmm1,xmm2/m128                             xmm2/m128 and xmm1 for greater
    //                                                           than.
    defn = new InsnDefn("pcmpgtq", x86_pcmpgtq, 0x03, 0x660f3837, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-100");
    define(defn);

    //--- page 4-100 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 3A 14     PEXTRB reg/m8,       Valid      Valid           Extract a byte integer value from
    // /r ib           xmm2, imm8                                      xmm2 at the source byte offset
    //                                                                 specified by imm8 into rreg or
    //                                                                 m8. The upper bits of r32 or r64
    //                                                                 are zeroed.
    defn = new InsnDefn("pextrb", x86_pextrb,  0x03, 0x660f3a14, od_modrm|od_ib, od_r_m8, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-100");
    define(defn);
    // 66 0F 3A 16     PEXTRD r/m32,        Valid      Valid           Extract a dword integer value
    // /r ib           xmm2, imm8                                      from xmm2 at the source dword
    //                                                                 offset specified by imm8 into
    //                                                                 r/m32.
    defn = new InsnDefn("pextrd", x86_pextrd,  0x03, 0x660f3a16, od_modrm|od_ib, od_r_m32, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-100");
    define(defn);
    // 66 REX.W 0F     PEXTRQ r/m64,        Valid      N. E.           Extract a qword integer value
    // 3A 16           xmm2, imm8                                      from xmm2 at the source qword
    // /r ib                                                           offset specified by imm8 into
    //                                                                 r/m64.
    defn = new InsnDefn("pextrq", x86_pextrq,  0x02, 0x660f3a16, od_rexw|od_modrm|od_ib, od_r_m64, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-103");
    define(defn);

    //--- page 4-103 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F C5 /r ib           PEXTRW reg, mm, Valid         Valid         Extract the word specified by
    //                        imm8                                        imm8 from mm and move it to
    //                                                                    reg, bits 15-0. The upper bits of
    //                                                                    r32 or r64 is zeroed.
    defn = new InsnDefn("pextrw", x86_pextrw,  0x03, 0x0fc5, od_modrm|od_ib, od_reg, od_mm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-103");
    define(defn);
    //  66 0F C5 /r ib        PEXTRW reg,        Valid      Valid         Extract the word specified by
    //                        xmm, imm8                                   imm8 from xmm and move it to
    //                                                                    reg, bits 15-0. The upper bits of
    //                                                                    r32 or r64 is zeroed.
    defn = new InsnDefn("pextrw", x86_pextrw,  0x03, 0x660fc5, od_modrm|od_ib, od_reg, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-103");
    define(defn);
    //  66 0F 3A 15           PEXTRW             Valid      Valid         Extract the word specified by
    //  /r ib                 reg/m16, xmm,                               imm8 from xmm and copy it to
    //                        imm8                                        lowest 16 bits of reg or m16.
    //                                                                    Zero-extend the result in the
    //                                                                    destination, r32 or r64.
    defn = new InsnDefn("pextrw", x86_pextrw,  0x03, 0x660f3a15, od_modrm|od_ib, od_r_m16, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-107");
    define(defn);

    //--- page 4-107 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 38 01 /r       PHADDW mm1,          Valid    Valid      Add 16-bit signed integers
    //                    mm2/m64                                  horizontally, pack to MM1.
    defn = new InsnDefn("phaddw", x86_phaddw,  0x03, 0x0f3801, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-107");
    define(defn);
    //  66 0F 38 01 /r    PHADDW xmm1,         Valid    Valid      Add 16-bit signed integers
    //                    xmm2/m128                                horizontally, pack to XMM1.
    defn = new InsnDefn("phaddw", x86_phaddw,  0x03, 0x660f3801, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-107");
    define(defn);
    //  0F 38 02 /r       PHADDD mm1,          Valid    Valid      Add 32-bit signed integers
    //                    mm2/m64                                  horizontally, pack to MM1.
    defn = new InsnDefn("phaddd", x86_phaddd,  0x03, 0x0f3802, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-107");
    define(defn);
    //  66 0F 38 02 /r    PHADDD xmm1,         Valid    Valid      Add 32-bit signed integers
    //                    xmm2/m128                                horizontally, pack to XMM1.
    defn = new InsnDefn("phaddd", x86_phaddd,  0x03, 0x660f3802, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-110");
    define(defn);

    //--- page 4-110 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 38 03 /r     PHADDSW mm1,      Valid     Valid         Add 16-bit signed integers
    //                 mm2/m64                                   horizontally, pack saturated integers
    //                                                           to MM1.
    defn = new InsnDefn("phaddsw", x86_phaddsw, 0x03, 0x0f3803, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-110");
    define(defn);
    // 66 0F 38 03 /r PHADDSW xmm1,      Valid     Valid         Add 16-bit signed integers
    //                xmm2/m128                                  horizontally, pack saturated integers
    //                                                           to XMM1.
    defn = new InsnDefn("phaddsw", x86_phaddsw, 0x03, 0x660f3803, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-113");
    define(defn);

    //--- page 4-113 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  66 0F 38     PHMINPOSUW xmm1,        Valid   Valid   Find the minimum unsigned word in
    //  41 /r        xmm2/m128                               xmm2/m128 and place its value in the
    //                                                       low word of xmm1 and its index in the
    //                                                       second-lowest word of xmm1.
    defn = new InsnDefn("phminposuw", x86_phminposuw, 0x03, 0x660f3841, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-116");
    define(defn);

    //--- page 4-116 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 38 05 /r             PHSUBW mm1,    Valid     Valid        Subtract 16-bit signed
    //                         mm2/m64                               integers horizontally, pack
    //                                                               to MM1.
    defn = new InsnDefn("phsubw", x86_phsubw,  0x03, 0x0f3805, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-116");
    define(defn);
    // 66 0F 38 05 /r          PHSUBW xmm1,   Valid     Valid        Subtract 16-bit signed
    //                         xmm2/m128                             integers horizontally, pack
    //                                                               to XMM1.
    defn = new InsnDefn("phsubw", x86_phsubw,  0x03, 0x660f3805, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-116");
    define(defn);
    // 0F 38 06 /r             PHSUBD mm1,    Valid     Valid        Subtract 32-bit signed
    //                         mm2/m64                               integers horizontally, pack
    //                                                               to MM1.
    defn = new InsnDefn("phsubd", x86_phsubd,  0x03, 0x0f3806, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-116");
    define(defn);
    // 66 0F 38 06 /r          PHSUBD xmm1,   Valid       Valid      Subtract 32-bit signed
    //                         xmm2/m128                             integers horizontally, pack
    //                                                               to XMM1.
    defn = new InsnDefn("phsubd", x86_phsubd,  0x03, 0x660f3806, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-119");
    define(defn);

    //--- page 4-119 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 38 07 /r                PHSUBSW mm1,       Valid    Valid         Subtract 16-bit signed
    //                             mm2/m64                                   integer horizontally, pack
    //                                                                       saturated integers to MM1.
    defn = new InsnDefn("phsubsw", x86_phsubsw, 0x03, 0x0f3807, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-119");
    define(defn);
    //  66 0F 38 07 /r             PHSUBSW            Valid    Valid         Subtract 16-bit signed
    //                             xmm1,                                     integer horizontally, pack
    //                             xmm2/m128                                 saturated integers to
    //                                                                       XMM1
    defn = new InsnDefn("phsubsw", x86_phsubsw, 0x03, 0x660f3807, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-122");
    define(defn);

    //--- page 4-122 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 3A        PINSRB xmm1,   Valid      Valid     Insert a byte integer value from r32/m8
    // 20 /r ib        r32/m8, imm8                        into xmm1 at the destination element in
    //                                                     xmm1 specified by imm8.
    defn = new InsnDefn("pinsrb", x86_pinsrb,  0x03, 0x660f3a20, od_modrm|od_ib, od_xmm, od_r32_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-122");
    define(defn);
    // 66 0F 3A        PINSRD xmm1,   Valid      Valid     Insert a dword integer value from r/m32
    // 22 /r ib        r/m32, imm8                         into the xmm1 at the destination
    //                                                     elements specified by imm8.
    defn = new InsnDefn("pinsrd", x86_pinsrd,  0x03, 0x660f3a22, od_modrm|od_ib, od_xmm, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-122");
    define(defn);
    // 66 REX.W    PINSRQ xmm1,       N. E.      Valid     Insert a qword integer value from r/m32
    // 0F 3A 22 /r r/m64, imm8                             into the xmm1 at the destination
    // ib                                                  elements specified by imm8.
    defn = new InsnDefn("pinsrq", x86_pinsrq,  0x01, 0x660f3a22, od_rexw|od_modrm|od_ib, od_xmm, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-125");
    define(defn);

    //--- page 4-125 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F C4 /r ib           PINSRW mm,       Valid      Valid         Insert the low word from
    //                        r32/m16, imm8                             r32 or from m16 into mm
    //                                                                  at the word position
    //                                                                  specified by imm8
    defn = new InsnDefn("pinsrw", x86_pinsrw,  0x03, 0x0fc4, od_modrm|od_ib, od_mm, od_r32_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-125");
    define(defn);
    //  66 0F C4 /r ib        PINSRW xmm,      Valid      Valid         Move the low word of r32
    //                        r32/m16, imm8                             or from m16 into xmm at
    //                                                                  the word position specified
    //                                                                  by imm8.
    defn = new InsnDefn("pinsrw", x86_pinsrw,  0x03, 0x660fc4, od_modrm|od_ib, od_xmm, od_r32_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-128");
    define(defn);

    //--- page 4-128 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 38 04 /r            PMADDUBSW           Valid       Valid          Multiply signed and
    //                        mm1, mm2/m64                                   unsigned bytes, add
    //                                                                       horizontal pair of signed
    //                                                                       words, pack saturated
    //                                                                       signed-words to MM1.
    defn = new InsnDefn("pmaddubsw", x86_pmaddubsw, 0x03, 0x0f3804, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-128");
    define(defn);
    // 66 0F 38 04 /r         PMADDUBSW           Valid       Valid          Multiply signed and
    //                        xmm1,                                          unsigned bytes, add
    //                        xmm2/m128                                      horizontal pair of signed
    //                                                                       words, pack saturated
    //                                                                       signed-words to XMM1.
    defn = new InsnDefn("pmaddubsw", x86_pmaddubsw, 0x03, 0x660f3804, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-131");
    define(defn);

    //--- page 4-131 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F F5 /r        PMADDWD mm,          Valid    Valid      Multiply the packed words in mm
    //                  mm/m64                                   by the packed words in mm/m64,
    //                                                           add adjacent doubleword results,
    //                                                           and store in mm.
    defn = new InsnDefn("pmaddwd", x86_pmaddwd, 0x03, 0x0ff5, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-131");
    define(defn);
    //  66 0F F5 /r     PMADDWD xmm1,        Valid    Valid      Multiply the packed word integers
    //                  xmm2/m128                                in xmm1 by the packed word
    //                                                           integers in xmm2/m128, add
    //                                                           adjacent doubleword results, and
    //                                                           store in xmm1.
    defn = new InsnDefn("pmaddwd", x86_pmaddwd, 0x03, 0x660ff5, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-135");
    define(defn);

    //--- page 4-135 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  66 0F 38     PMAXSB xmm1,         Valid     Valid      Compare packed signed byte integers
    //  3C /r        xmm2/m128                                 in xmm1 and xmm2/m128 and store
    //                                                         packed maximum values in xmm1.
    defn = new InsnDefn("pmaxsb", x86_pmaxsb,  0x03, 0x660f383c, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-138");
    define(defn);

    //--- page 4-138 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 38        PMAXSD xmm1,    Valid      Valid         Compare packed signed dword integers in
    // 3D /r           xmm2/m128                                xmm1 and xmm2/m128 and store
    //                                                          packed maximum values in xmm1.
    defn = new InsnDefn("pmaxsd", x86_pmaxsd,  0x03, 0x660f383d, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-141");
    define(defn);

    //--- page 4-141 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F EE /r      PMAXSW mm1,         Valid        Valid      Compare signed word integers in
    //                mm2/m64                                     mm2/m64 and mm1 and return
    //                                                            maximum values.
    defn = new InsnDefn("pmaxsw", x86_pmaxsw,  0x03, 0x0fee, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-141");
    define(defn);
    //  66 0F EE /r   PMAXSW xmm1,        Valid        Valid      Compare signed word integers in
    //                xmm2/m128                                   xmm2/m128 and xmm1 and return
    //                                                            maximum values.
    defn = new InsnDefn("pmaxsw", x86_pmaxsw,  0x03, 0x660fee, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-144");
    define(defn);

    //--- page 4-144 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F DE /r        PMAXUB mm1,           Valid     Valid           Compare unsigned byte integers
    //                 mm2/m64                                         in mm2/m64 and mm1 and
    //                                                                 returns maximum values.
    defn = new InsnDefn("pmaxub", x86_pmaxub,  0x03, 0x0fde, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-144");
    define(defn);
    // 66 0F DE /r     PMAXUB xmm1,          Valid     Valid           Compare unsigned byte integers
    //                 xmm2/m128                                       in xmm2/m128 and xmm1 and
    //                                                                 returns maximum values.
    defn = new InsnDefn("pmaxub", x86_pmaxub,  0x03, 0x660fde, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-147");
    define(defn);

    //--- page 4-147 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  66 0F 38     PMAXUD xmm1,        Valid              Valid         Compare packed unsigned
    //  3F /r        xmm2/m128                                            dword integers in xmm1 and
    //                                                                    xmm2/m128 and store packed
    //                                                                    maximum values in xmm1.
    defn = new InsnDefn("pmaxud", x86_pmaxud,  0x03, 0x660f383f, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-150");
    define(defn);

    //--- page 4-150 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 38        PMAXUW xmm1,     Valid       Valid      Compare packed unsigned word
    // 3E /r           xmm2/m128                               integers in xmm1 and xmm2/m128
    //                                                         and store packed maximum values in
    //                                                         xmm1.
    defn = new InsnDefn("pmaxuw", x86_pmaxuw,  0x03, 0x660f383e, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-153");
    define(defn);

    //--- page 4-153 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  66 0F 38 38      PMINSB xmm1,      Valid    Valid   Compare packed signed byte integers in
    //  /r               xmm2/m128                          xmm1 and xmm2/m128 and store packed
    //                                                      minimum values in xmm1.
    defn = new InsnDefn("pminsb", x86_pminsb,  0x03, 0x660f3838, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-156");
    define(defn);

    //--- page 4-156 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 38 PMINSD xmm1,        Valid     Valid       Compare packed signed dword integers in
    // 39 /r    xmm2/m128                                 xmm1 and xmm2/m128 and store packed
    //                                                    minimum values in xmm1.
    defn = new InsnDefn("pminsd", x86_pminsd,  0x03, 0x660f3839, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-159");
    define(defn);

    //--- page 4-159 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F EA /r      PMINSW mm1,         Valid        Valid      Compare signed word integers in
    //                mm2/m64                                     mm2/m64 and mm1 and return
    //                                                            minimum values.
    defn = new InsnDefn("pminsw", x86_pminsw,  0x03, 0x0fea, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-159");
    define(defn);
    //  66 0F EA /r   PMINSW xmm1,        Valid        Valid      Compare signed word integers in
    //                xmm2/m128                                   xmm2/m128 and xmm1 and return
    //                                                            minimum values.
    defn = new InsnDefn("pminsw", x86_pminsw,  0x03, 0x660fea, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-162");
    define(defn);

    //--- page 4-162 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F DA /r         PMINUB mm1,        Valid      Valid         Compare unsigned byte integers in
    //                  mm2/m64                                     mm2/m64 and mm1 and returns
    //                                                              minimum values.
    defn = new InsnDefn("pminub", x86_pminub,  0x03, 0x0fda, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-162");
    define(defn);
    // 66 0F DA /r      PMINUB xmm1,       Valid      Valid         Compare unsigned byte integers in
    //                  xmm2/m128                                   xmm2/m128 and xmm1 and
    //                                                              returns minimum values.
    defn = new InsnDefn("pminub", x86_pminub,  0x03, 0x660fda, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-165");
    define(defn);

    //--- page 4-165 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  66 0F 38     PMINUD xmm1,         Valid    Valid       Compare packed unsigned dword
    //  3B /r        xmm2/m128                                 integers in xmm1 and xmm2/m128
    //                                                         and store packed minimum values in
    //                                                         xmm1.
    defn = new InsnDefn("pminud", x86_pminud,  0x03, 0x660f383b, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-168");
    define(defn);

    //--- page 4-168 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 38 3A PMINUW xmm1,          Valid      Valid         Compare packed unsigned word
    // /r          xmm2/m128                                      integers in xmm1 and xmm2/m128
    //                                                            and store packed minimum values in
    //                                                            xmm1.
    defn = new InsnDefn("pminuw", x86_pminuw,  0x03, 0x660f383a, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-171");
    define(defn);

    //--- page 4-171 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F D7 /r              PMOVMSKB         Valid      Valid        Move a byte mask of mm to
    //                        r32, mm                                  r32.
    defn = new InsnDefn("pmovmskb", x86_pmovmskb, 0x03, 0x0fd7, od_modrm, od_r32, od_mm);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-171");
    define(defn);
    //  REX.W + 0F D7 /r      PMOVMSKB         Valid      N.E.         Move a byte mask of mm to
    //                        r64, mm                                  the lower 32-bits of r64 and
    //                                                                 zero-fill the upper 32-bits.
    defn = new InsnDefn("pmovmskb", x86_pmovmskb, 0x02, 0x0fd7, od_rexw|od_modrm, od_r64, od_mm);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-171");
    define(defn);
    //  66 0F D7 /r           PMOVMSKB reg, Valid         Valid        Move a byte mask of xmm
    //                        xmm                                      to reg. The upper bits of r32
    //                                                                 or r64 are zeroed
    defn = new InsnDefn("pmovmskb", x86_pmovmskb, 0x03, 0x660fd7, od_modrm, od_reg, od_xmm);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-174");
    define(defn);

    //--- page 4-174 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0f 38        PMOVSXBW xmm1,   Valid    Valid      Sign extend 8 packed signed 8-bit
    // 20 /r           xmm2/m64                             integers in the low 8 bytes of
    //                                                      xmm2/m64 to 8 packed signed 16-
    //                                                      bit integers in xmm1.
    defn = new InsnDefn("pmovsxbw", x86_pmovsxbw, 0x03, 0x660f3820, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-174");
    define(defn);
    // 66 0f 38        PMOVSXBD xmm1,   Valid    Valid      Sign extend 4 packed signed 8-bit
    // 21 /r           xmm2/m32                             integers in the low 4 bytes of
    //                                                      xmm2/m32 to 4 packed signed 32-
    //                                                      bit integers in xmm1.
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
