//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "sage3basic.h"
#include "AssemblerX86.h"

/* Generated by ./IntelAssemblyBuilder from 
 * x86-InstructionSetReference-AM.pdf 
 * x86-InstructionSetReference-NZ.pdf 
 * ExtraInstructions.txt */
void AssemblerX86::initAssemblyRules_part4() {
    AssemblerX86::InsnDefn *defn = NULL;
    defn = new InsnDefn("jbe",    x86_jbe,     0x01, 0x0f86, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 86 cd        JNA rel32     Valid    Valid      Jump near if not above (CF=1 or ZF=1).
    defn = new InsnDefn("jbe",    x86_jbe,     0x03, 0x0f86, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 82 cw        JNAE rel16    N.S.     Valid      Jump near if not above or equal (CF=1).
    //                                                   Not supported in 64-bit mode.
    defn = new InsnDefn("jb",     x86_jb,      0x01, 0x0f82, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 82 cd        JNAE rel32    Valid    Valid      Jump near if not above or equal (CF=1).
    defn = new InsnDefn("jb",     x86_jb,      0x03, 0x0f82, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 83 cw        JNB rel16     N.S.     Valid      Jump near if not below (CF=0). Not
    //                                                   supported in 64-bit mode.
    defn = new InsnDefn("jae",    x86_jae,     0x01, 0x0f83, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 83 cd        JNB rel32     Valid    Valid      Jump near if not below (CF=0).
    defn = new InsnDefn("jae",    x86_jae,     0x03, 0x0f83, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 87 cw        JNBE rel16    N.S.     Valid      Jump near if not below or equal (CF=0
    //                                                   and ZF=0). Not supported in 64-bit
    //                                                   mode.
    defn = new InsnDefn("ja",     x86_ja,      0x01, 0x0f87, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 87 cd        JNBE rel32    Valid    Valid      Jump near if not below or equal (CF=0
    //                                                   and ZF=0).
    defn = new InsnDefn("ja",     x86_ja,      0x03, 0x0f87, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 83 cw        JNC rel16     N.S.     Valid      Jump near if not carry (CF=0). Not
    //                                                   supported in 64-bit mode.
    defn = new InsnDefn("jae",    x86_jae,     0x01, 0x0f83, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 83 cd        JNC rel32     Valid    Valid      Jump near if not carry (CF=0).
    defn = new InsnDefn("jae",    x86_jae,     0x03, 0x0f83, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 85 cw        JNE rel16     N.S.     Valid      Jump near if not equal (ZF=0). Not
    //                                                   supported in 64-bit mode.
    defn = new InsnDefn("jne",    x86_jne,     0x01, 0x0f85, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 85 cd        JNE rel32     Valid    Valid      Jump near if not equal (ZF=0).
    defn = new InsnDefn("jne",    x86_jne,     0x03, 0x0f85, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 8E cw        JNG rel16     N.S.     Valid      Jump near if not greater (ZF=1 or SF
    //                                                   OF). Not supported in 64-bit mode.
    defn = new InsnDefn("jle",    x86_jle,     0x01, 0x0f8e, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 8E cd        JNG rel32     Valid    Valid      Jump near if not greater (ZF=1 or SF
    //                                                   OF).
    defn = new InsnDefn("jle",    x86_jle,     0x03, 0x0f8e, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 8C cw        JNGE rel16    N.S.     Valid      Jump near if not greater or equal (SF
    //                                                   OF). Not supported in 64-bit mode.
    defn = new InsnDefn("jl",     x86_jl,      0x01, 0x0f8c, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 8C cd         JNGE rel32    Valid    Valid      Jump near if not greater or equal (SF
    //                                                     OF).
    defn = new InsnDefn("jl",     x86_jl,      0x03, 0x0f8c, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 8D cw         JNL rel16     N.S.     Valid      Jump near if not less (SF=OF). Not
    //                                                     supported in 64-bit mode.
    defn = new InsnDefn("jge",    x86_jge,     0x01, 0x0f8d, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 8D cd         JNL rel32     Valid    Valid      Jump near if not less (SF=OF).
    defn = new InsnDefn("jge",    x86_jge,     0x03, 0x0f8d, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 8F cw         JNLE rel16    N.S.     Valid      Jump near if not less or equal (ZF=0 and
    //                                                     SF=OF). Not supported in 64-bit mode.
    defn = new InsnDefn("jg",     x86_jg,      0x01, 0x0f8f, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 8F cd         JNLE rel32    Valid    Valid      Jump near if not less or equal (ZF=0 and
    //                                                     SF=OF).
    defn = new InsnDefn("jg",     x86_jg,      0x03, 0x0f8f, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 81 cw         JNO rel16     N.S.     Valid      Jump near if not overflow (OF=0). Not
    //                                                     supported in 64-bit mode.
    defn = new InsnDefn("jno",    x86_jno,     0x01, 0x0f81, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 81 cd         JNO rel32     Valid    Valid      Jump near if not overflow (OF=0).
    defn = new InsnDefn("jno",    x86_jno,     0x03, 0x0f81, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 8B cw         JNP rel16     N.S.     Valid      Jump near if not parity (PF=0). Not
    //                                                     supported in 64-bit mode.
    defn = new InsnDefn("jpo",    x86_jpo,     0x01, 0x0f8b, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 8B cd         JNP rel32     Valid    Valid      Jump near if not parity (PF=0).
    defn = new InsnDefn("jpo",    x86_jpo,     0x03, 0x0f8b, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 89 cw         JNS rel16     N.S.     Valid      Jump near if not sign (SF=0). Not
    //                                                     supported in 64-bit mode.
    defn = new InsnDefn("jns",    x86_jns,     0x01, 0x0f89, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 89 cd         JNS rel32     Valid    Valid      Jump near if not sign (SF=0).
    defn = new InsnDefn("jns",    x86_jns,     0x03, 0x0f89, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 85 cw         JNZ rel16     N.S.     Valid      Jump near if not zero (ZF=0). Not
    //                                                     supported in 64-bit mode.
    defn = new InsnDefn("jne",    x86_jne,     0x01, 0x0f85, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 85 cd         JNZ rel32     Valid    Valid      Jump near if not zero (ZF=0).
    defn = new InsnDefn("jne",    x86_jne,     0x03, 0x0f85, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 80 cw         JO rel16      N.S.     Valid      Jump near if overflow (OF=1). Not
    //                                                     supported in 64-bit mode.
    defn = new InsnDefn("jo",     x86_jo,      0x01, 0x0f80, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 80 cd         JO rel32      Valid    Valid      Jump near if overflow (OF=1).
    defn = new InsnDefn("jo",     x86_jo,      0x03, 0x0f80, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 8A cw         JP rel16      N.S.     Valid      Jump near if parity (PF=1). Not supported
    //                                                     in 64-bit mode.
    defn = new InsnDefn("jpe",    x86_jpe,     0x01, 0x0f8a, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 8A cd         JP rel32      Valid    Valid      Jump near if parity (PF=1).
    defn = new InsnDefn("jpe",    x86_jpe,     0x03, 0x0f8a, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 8A cw         JPE rel16     N.S.     Valid      Jump near if parity even (PF=1). Not
    //                                                     supported in 64-bit mode.
    defn = new InsnDefn("jpe",    x86_jpe,     0x01, 0x0f8a, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 8A cd         JPE rel32     Valid    Valid      Jump near if parity even (PF=1).
    defn = new InsnDefn("jpe",    x86_jpe,     0x03, 0x0f8a, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 8B cw         JPO rel16     N.S.     Valid      Jump near if parity odd (PF=0). Not
    //                                                     supported in 64-bit mode.
    defn = new InsnDefn("jpo",    x86_jpo,     0x01, 0x0f8b, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 8B cd         JPO rel32     Valid    Valid      Jump near if parity odd (PF=0).
    defn = new InsnDefn("jpo",    x86_jpo,     0x03, 0x0f8b, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-545");
    define(defn);
    //  0F 88 cw         JS rel16      N.S.     Valid      Jump near if sign (SF=1). Not supported
    //                                                     in 64-bit mode.
    defn = new InsnDefn("js",     x86_js,      0x01, 0x0f88, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-546");
    define(defn);
    // 0F 88 cd        JS rel32      Valid     Valid        Jump near if sign (SF=1).
    defn = new InsnDefn("js",     x86_js,      0x03, 0x0f88, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-546");
    define(defn);
    // 0F 84 cw        JZ rel16      N.S.      Valid        Jump near if 0 (ZF=1). Not supported in
    //                                                      64-bit mode.
    defn = new InsnDefn("je",     x86_je,      0x01, 0x0f84, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-546");
    define(defn);
    // 0F 84 cd        JZ rel32      Valid     Valid        Jump near if 0 (ZF=1).
    defn = new InsnDefn("je",     x86_je,      0x03, 0x0f84, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-549");
    define(defn);

    //--- page 3-549 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  EB cb     JMP rel8      Valid      Valid       Jump short, RIP = RIP + 8-bit displacement
    //                                                 sign extended to 64-bits
    defn = new InsnDefn("jmp",    x86_jmp,     0x03, 0xeb, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-549");
    define(defn);
    //  E9 cw     JMP rel16     N.S.       Valid       Jump near, relative, displacement relative
    //                                                 to next instruction. Not supported in 64-bit
    //                                                 mode.
    defn = new InsnDefn("jmp",    x86_jmp,     0x01, 0xe9, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-549");
    define(defn);
    //  E9 cd     JMP rel32     Valid      Valid       Jump near, relative, RIP = RIP + 32-bit
    //                                                 displacement sign extended to 64-bits
    defn = new InsnDefn("jmp",    x86_jmp,     0x03, 0xe9, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-549");
    define(defn);
    //  FF /4     JMP r/m16     N.S.       Valid       Jump near, absolute indirect, address =
    //                                                 sign-extended r/m16. Not supported in 64-
    //                                                 bit mode.
    defn = new InsnDefn("jmp",    x86_jmp,     0x01, 0xff, od_e4, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-549");
    define(defn);
    //  FF /4     JMP r/m32     N.S.       Valid       Jump near, absolute indirect, address =
    //                                                 sign-extended r/m32. Not supported in 64-
    //                                                 bit mode.
    defn = new InsnDefn("jmp",    x86_jmp,     0x01, 0xff, od_e4, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-549");
    define(defn);
    //  FF /4     JMP r/m64     Valid      N.E.        Jump near, absolute indirect, RIP = 64-Bit
    //                                                 offset from register or memory
    defn = new InsnDefn("jmp",    x86_jmp,     0x02, 0xff, od_e4, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-549");
    define(defn);
    //  EA cd     JMP ptr16:16 Inv.        Valid       Jump far, absolute, address given in
    //                                                 operand
    defn = new InsnDefn("jmp",    x86_farjmp,  0x01, 0xea, od_cd, od_ptr16_16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-549");
    define(defn);
    //  EA cp     JMP ptr16:32 Inv.        Valid       Jump far, absolute, address given in
    //                                                 operand
    defn = new InsnDefn("jmp",    x86_farjmp,  0x01, 0xea, od_cp, od_ptr16_32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-549");
    define(defn);
    //  FF /5     JMP m16:16    Valid      Valid       Jump far, absolute indirect, address given in
    //                                                 m16:16
    defn = new InsnDefn("jmp",    x86_farjmp,  0x03, 0xff, od_e5, od_m16_16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-549");
    define(defn);
    //  FF /5     JMP m16:32    Valid      Valid       Jump far, absolute indirect, address given in
    //                                                 m16:32.
    defn = new InsnDefn("jmp",    x86_farjmp,  0x03, 0xff, od_e5, od_m16_32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-549");
    define(defn);
    //  REX.W +   JMP m16:64    Valid      N.E.        Jump far, absolute indirect, address given in
    //  FF /5                                          m16:64.
    defn = new InsnDefn("jmp",    x86_farjmp,  0x02, 0xff, od_rexw|od_e5, od_m16_64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-559");
    define(defn);

    //--- page 3-559 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  9F           LAHF           Invalid*     Valid            Load: AH  EFLAGS(SF:ZF:0:AF:0:PF:1:CF).
    defn = new InsnDefn("lahf",   x86_lahf,    0x01, 0x9f, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-561");
    define(defn);

    //--- page 3-561 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 02 /r     LAR r16, r16/m16      Valid            Valid            r16  r16/m16 masked by
    //                                                                       FF00H.
    defn = new InsnDefn("lar",    x86_lar,     0x03, 0x0f02, od_modrm, od_r16, od_r16_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-561");
    define(defn);
    //  0F 02 /r     LAR r32, r32/m161 Valid                Valid            r32  r32/m16 masked by
    //                                                                       00FxFF00H
    defn = new InsnDefn("lar",    x86_lar,     0x03, 0x0f02, od_modrm, od_r32, od_r32_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-561");
    define(defn);
    //  REX.W +      LAR r64, r32/m161 Valid                N.E.             r64 r32/m16 masked by
    //  0F 02 /r                                                             00FxFF00H and zero extended
    defn = new InsnDefn("lar",    x86_lar,     0x02, 0x0f02, od_rexw|od_modrm, od_r64, od_r32_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-565");
    define(defn);

    //--- page 3-565 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F2 0F F0 /r    LDDQU xmm1, mem         Valid    Valid        Load unaligned data from mem
    //                                                               and return double quadword in
    //                                                               xmm1.
    defn = new InsnDefn("lddqu",  x86_lddqu,   0x03, 0xf20ff0, od_modrm, od_xmm, od_m);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-568");
    define(defn);

    //--- page 3-568 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F,AE,/2    LDMXCSR m32       Valid        Valid      Load MXCSR register from m32.
    defn = new InsnDefn("ldmxcsr", x86_ldmxcsr, 0x03, 0x0fae, od_e2, od_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-570");
    define(defn);

    //--- page 3-570 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // C5 /r            LDS             Invalid   Valid      Load DS:r16 with far pointer from
    //                  r16,m16:16                           memory.
    defn = new InsnDefn("lds",    x86_lds,     0x01, 0xc5, od_modrm, od_r16, od_m16_16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-570");
    define(defn);
    // C5 /r            LDS             Invalid   Valid      Load DS:r32 with far pointer from
    //                  r32,m16:32                           memory.
    defn = new InsnDefn("lds",    x86_lds,     0x01, 0xc5, od_modrm, od_r32, od_m16_32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-570");
    define(defn);
    // 0F B2 /r         LSS r16,m16:16 Valid      Valid      Load SS:r16 with far pointer from
    //                                                       memory.
    defn = new InsnDefn("lss",    x86_lss,     0x03, 0x0fb2, od_modrm, od_r16, od_m16_16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-570");
    define(defn);
    // 0F B2 /r         LSS r32,m16:32 Valid      Valid      Load SS:r32 with far pointer from
    //                                                       memory.
    defn = new InsnDefn("lss",    x86_lss,     0x03, 0x0fb2, od_modrm, od_r32, od_m16_32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-570");
    define(defn);
    // REX + 0F B2 /r   LSS r64,m16:64 Valid      N.E.       Load SS:r64 with far pointer from
    //                                                       memory.
    defn = new InsnDefn("lss",    x86_lss,     0x02, 0x0fb2, od_rex|od_modrm, od_r64, od_m16_64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-570");
    define(defn);
    // C4 /r            LES r16,m16:16 Invalid    Valid      Load ES:r16 with far pointer from
    //                                                       memory.
    defn = new InsnDefn("les",    x86_les,     0x01, 0xc4, od_modrm, od_r16, od_m16_16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-570");
    define(defn);
    // C4 /r            LES r32,m16:32 Invalid    Valid      Load ES:r32 with far pointer from
    //                                                       memory.
    defn = new InsnDefn("les",    x86_les,     0x01, 0xc4, od_modrm, od_r32, od_m16_32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-570");
    define(defn);
    // 0F B4 /r         LFS r16,m16:16 Valid      Valid      Load FS:r16 with far pointer from
    //                                                       memory.
    defn = new InsnDefn("lfs",    x86_lfs,     0x03, 0x0fb4, od_modrm, od_r16, od_m16_16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-570");
    define(defn);
    // 0F B4 /r         LFS r32,m16:32 Valid      Valid      Load FS:r32 with far pointer from
    //                                                       memory.
    defn = new InsnDefn("lfs",    x86_lfs,     0x03, 0x0fb4, od_modrm, od_r32, od_m16_32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-570");
    define(defn);
    // REX + 0F B4 /r   LFS r64,m16:64 Valid      N.E.       Load FS:r64 with far pointer from
    //                                                       memory.
    defn = new InsnDefn("lfs",    x86_lfs,     0x02, 0x0fb4, od_rex|od_modrm, od_r64, od_m16_64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-570");
    define(defn);
    // 0F B5 /r         LGS             Valid     Valid      Load GS:r16 with far pointer from
    //                  r16,m16:16                           memory.
    defn = new InsnDefn("lgs",    x86_lgs,     0x03, 0x0fb5, od_modrm, od_r16, od_m16_16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-570");
    define(defn);
    // 0F B5 /r         LGS             Valid     Valid      Load GS:r32 with far pointer from
    //                  r32,m16:32                           memory.
    defn = new InsnDefn("lgs",    x86_lgs,     0x03, 0x0fb5, od_modrm, od_r32, od_m16_32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-570");
    define(defn);
    // REX + 0F B5 /r   LGS             Valid     N.E.       Load GS:r64 with far pointer from
    //                  r64,m16:64                           memory.
    defn = new InsnDefn("lgs",    x86_lgs,     0x02, 0x0fb5, od_rex|od_modrm, od_r64, od_m16_64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-576");
    define(defn);

    //--- page 3-576 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 8D /r            LEA r16,m     Valid       Valid         Store effective address for m in register
    //                                                          r16.
    defn = new InsnDefn("lea",    x86_lea,     0x03, 0x8d, od_modrm, od_r16, od_m);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-576");
    define(defn);
    // 8D /r            LEA r32,m     Valid       Valid         Store effective address for m in register
    //                                                          r32.
    defn = new InsnDefn("lea",    x86_lea,     0x03, 0x8d, od_modrm, od_r32, od_m);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-576");
    define(defn);
    // REX.W + 8D /r    LEA r64,m     Valid       N.E.          Store effective address for m in register
    //                                                          r64.
    defn = new InsnDefn("lea",    x86_lea,     0x02, 0x8d, od_rexw|od_modrm, od_r64, od_m);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-579");
    define(defn);

    //--- page 3-579 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  C9            LEAVE              Valid    Valid      Set SP to BP, then pop BP.
    defn = new InsnDefn("leave",  x86_leave,   0x03, 0xc9, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-579");
    define(defn);
    //  C9            LEAVE              N.E.     Valid      Set ESP to EBP, then pop EBP.
    defn = new InsnDefn("leave",  x86_leave,   0x01, 0xc9, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-579");
    define(defn);
    //  C9            LEAVE              Valid    N.E.       Set RSP to RBP, then pop RBP.
    defn = new InsnDefn("leave",  x86_leave,   0x02, 0xc9, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-581");
    define(defn);

    //--- page 3-581 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F AE /5     LFENCE        Valid       Valid           Serializes load operations.
    defn = new InsnDefn("lfence", x86_lfence,  0x03, 0x0fae, od_e5);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-582");
    define(defn);

    //--- page 3-582 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 01 /2        LGDT m16&32       N.E.         Valid             Load m into GDTR.
    defn = new InsnDefn("lgdt",   x86_lgdt,    0x01, 0x0f01, od_e2, od_m16a32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-582");
    define(defn);
    // 0F 01 /3        LIDT m16&32       N.E.         Valid             Load m into IDTR.
    defn = new InsnDefn("lidt",   x86_lidt,    0x01, 0x0f01, od_e3, od_m16a32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-582");
    define(defn);
    // 0F 01 /2        LGDT m16&64       Valid        N.E.              Load m into GDTR.
    defn = new InsnDefn("lgdt",   x86_lgdt,    0x02, 0x0f01, od_e2, od_m16a64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-582");
    define(defn);
    // 0F 01 /3        LIDT m16&64       Valid        N.E.              Load m into IDTR.
    defn = new InsnDefn("lidt",   x86_lidt,    0x02, 0x0f01, od_e3, od_m16a64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-585");
    define(defn);

    //--- page 3-585 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 00 /2        LLDT r/m16         Valid    Valid      Load segment selector r/m16 into
    //                                                         LDTR.
    defn = new InsnDefn("lldt",   x86_lldt,    0x03, 0x0f00, od_e2, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-588");
    define(defn);

    //--- page 3-588 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 01 /6        LMSW r/m16    Valid       Valid      Loads r/m16 in machine status word
    //                                                      of CR0.
    defn = new InsnDefn("lmsw",   x86_lmsw,    0x03, 0x0f01, od_e6, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-590");
    define(defn);

    //--- page 3-590 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F0              LOCK           Valid      Valid         Asserts LOCK# signal for duration of
    //                                                         the accompanying instruction.
    defn = new InsnDefn("lock",   x86_lock,    0x03, 0xf0, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-592");
    define(defn);

    //--- page 3-592 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // AC              LODS m8       Valid    Valid       For legacy mode, Load byte at address
    //                                                    DS:(E)SI into AL. For 64-bit mode load byte
    //                                                    at address (R)SI into AL.
    // See LODSB, LODSW, LODSD, or LODSQ instead.
    // defn = new InsnDefn("lods",   x86_lods,    0x03, 0xac, od_none, od_m8);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-592");
    // define(defn);
    // AD              LODS m16      Valid    Valid       For legacy mode, Load word at address
    //                                                    DS:(E)SI into AX. For 64-bit mode load
    //                                                    word at address (R)SI into AX.
    // See LODSB, LODSW, LODSD, or LODSQ instead.
    // defn = new InsnDefn("lods",   x86_lods,    0x03, 0xad, od_none, od_m16);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-592");
    // define(defn);
    // AD              LODS m32      Valid    Valid       For legacy mode, Load dword at address
    //                                                    DS:(E)SI into EAX. For 64-bit mode load
    //                                                    dword at address (R)SI into EAX.
    // See LODSB, LODSW, LODSD, or LODSQ instead.
    // defn = new InsnDefn("lods",   x86_lods,    0x03, 0xad, od_none, od_m32);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-592");
    // define(defn);
    // REX.W + AD      LODS m64      Valid    N.E.        Load qword at address (R)SI into RAX.
    // See LODSB, LODSW, LODSD, or LODSQ instead.
    // defn = new InsnDefn("lods",   x86_lods,    0x02, 0xad, od_rexw, od_m64);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-592");
    // define(defn);
    // AC              LODSB         Valid    Valid       For legacy mode, Load byte at address
    //                                                    DS:(E)SI into AL. For 64-bit mode load byte
    //                                                    at address (R)SI into AL.
    defn = new InsnDefn("lodsb",  x86_lodsb,   0x03, 0xac, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-592");
    define(defn);
    // AD              LODSW         Valid    Valid       For legacy mode, Load word at address
    //                                                    DS:(E)SI into AX. For 64-bit mode load
    //                                                    word at address (R)SI into AX.
    defn = new InsnDefn("lodsw",  x86_lodsw,   0x03, 0xad, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-592");
    define(defn);
    // AD              LODSD         Valid    Valid       For legacy mode, Load dword at address
    //                                                    DS:(E)SI into EAX. For 64-bit mode load
    //                                                    dword at address (R)SI into EAX.
    defn = new InsnDefn("lodsd",  x86_lodsd,   0x03, 0xad, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-592");
    define(defn);
    // REX.W + AD      LODSQ         Valid    N.E.        Load qword at address (R)SI into RAX.
    defn = new InsnDefn("lodsq",  x86_lodsq,   0x02, 0xad, od_rexw);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-596");
    define(defn);

    //--- page 3-596 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // E2 cb                LOOP rel8     Valid    Valid      Decrement count; jump short if count  0.
    defn = new InsnDefn("loop",   x86_loop,    0x03, 0xe2, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-596");
    define(defn);
    // E1 cb                LOOPE rel8    Valid    Valid      Decrement count; jump short if count  0
    //                                                        and ZF = 1.
    defn = new InsnDefn("loopz",  x86_loopz,   0x03, 0xe1, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-596");
    define(defn);
    // E0 cb                LOOPNE rel8 Valid      Valid      Decrement count; jump short if count  0
    //                                                        and ZF = 0.
    defn = new InsnDefn("loopnz", x86_loopnz,  0x03, 0xe0, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-599");
    define(defn);

    //--- page 3-599 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 03 /r             LSL r16, r16/m16     Valid        Valid          Load: r16  segment limit,
    //                                                                        selector r16/m16.
    defn = new InsnDefn("lsl",    x86_lsl,     0x03, 0x0f03, od_modrm, od_r16, od_r16_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-599");
    define(defn);
    //  0F 03 /r             LSL r32, r32/m16* Valid           Valid          Load: r32  segment limit,
    //                                                                        selector r32/m16.
    defn = new InsnDefn("lsl",    x86_lsl,     0x03, 0x0f03, od_modrm, od_r32, od_r32_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-599");
    define(defn);
    //  REX.W + 0F 03 /r     LSL r64, r32/m16* Valid           Valid          Load: r64  segment limit,
    //                                                                        selector r32/m16
    defn = new InsnDefn("lsl",    x86_lsl,     0x03, 0x0f03, od_rexw|od_modrm, od_r64, od_r32_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-603");
    define(defn);

    //--- page 3-603 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 00 /3        LTR r/m16        Valid        Valid               Load r/m16 into task register.
    defn = new InsnDefn("ltr",    x86_ltr,     0x03, 0x0f00, od_e3, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-606");
    define(defn);

    //--- page 3-606 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F F7 /r MASKMOVDQU        Valid    Valid       Selectively write bytes from xmm1 to
    //             xmm1, xmm2                             memory location using the byte mask in
    //                                                    xmm2. The default memory location is
    //                                                    specified by DS:EDI.
    // See MASKMOVQ with 0x66 prefix instead.
    // defn = new InsnDefn("maskmovdqu", x86_maskmovdqu, 0x03, 0x660ff7, od_modrm, od_xmm, od_xmm);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-609");
    // define(defn);

    //--- page 3-609 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F F7 /r   MASKMOVQ mm1,        Valid      Valid      Selectively write bytes from mm1 to
    //             mm2                                        memory location using the byte mask in
    //                                                        mm2. The default memory location is
    //                                                        specified by DS:EDI.
    defn = new InsnDefn("maskmovq", x86_maskmovq, 0x03, 0x0ff7, od_modrm, od_mm, od_mm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-612");
    define(defn);

    //--- page 3-612 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F 5F /r     MAXPD xmm1,      Valid      Valid             Return the maximum double-
    //                 xmm2/m128                                     precision floating-point values
    //                                                               between xmm2/m128 and xmm1.
    defn = new InsnDefn("maxpd",  x86_maxpd,   0x03, 0x660f5f, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-615");
    define(defn);

    //--- page 3-615 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 5F /r     MAXPS xmm1,       Valid        Valid          Return the maximum single-precision
    //               xmm2/m128                                     floating-point values between
    //                                                             xmm2/m128 and xmm1.
    defn = new InsnDefn("maxps",  x86_maxps,   0x03, 0x0f5f, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-618");
    define(defn);

    //--- page 3-618 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F2 0F 5F /r     MAXSD xmm1,        Valid        Valid           Return the maximum scalar double-
    //                 xmm2/m64                                        precision floating-point value
    //                                                                 between xmm2/mem64 and xmm1.
    defn = new InsnDefn("maxsd",  x86_maxsd,   0x03, 0xf20f5f, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-621");
    define(defn);

    //--- page 3-621 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F3 0F 5F /r MAXSS xmm1,             Valid       Valid              Return the maximum scalar single-
    //              xmm2/m32                                               precision floating-point value
    //                                                                     between xmm2/mem32 and
    //                                                                     xmm1.
    defn = new InsnDefn("maxss",  x86_maxss,   0x03, 0xf30f5f, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-624");
    define(defn);

    //--- page 3-624 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F AE /6        MFENCE        Valid      Valid         Serializes load and store operations.
    defn = new InsnDefn("mfence", x86_mfence,  0x03, 0x0fae, od_e6);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-625");
    define(defn);

    //--- page 3-625 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  66 0F 5D /r     MINPD xmm1,        Valid       Valid                Return the minimum double-
    //                  xmm2/m128                                           precision floating-point values
    //                                                                      between xmm2/m128 and xmm1.
    defn = new InsnDefn("minpd",  x86_minpd,   0x03, 0x660f5d, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-628");
    define(defn);

    //--- page 3-628 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 5D /r        MINPS xmm1,       Valid       Valid            Return the minimum single-precision
    //                 xmm2/m128                                      floating-point values between
    //                                                                xmm2/m128 and xmm1.
    defn = new InsnDefn("minps",  x86_minps,   0x03, 0x0f5d, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-631");
    define(defn);

    //--- page 3-631 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F2 0F 5D /r     MINSD xmm1,           Valid      Valid             Return the minimum scalar double-
    //                  xmm2/m64                                           precision floating-point value
    //                                                                     between xmm2/mem64 and xmm1.
    defn = new InsnDefn("minsd",  x86_minsd,   0x03, 0xf20f5d, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-634");
    define(defn);

    //--- page 3-634 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F3 0F 5D /r     MINSS xmm1,        Valid      Valid             Return the minimum scalar single-
    //                 xmm2/m32                                        precision floating-point value
    //                                                                 between xmm2/mem32 and
    //                                                                 xmm1.
    defn = new InsnDefn("minss",  x86_minss,   0x03, 0xf30f5d, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-637");
    define(defn);

    //--- page 3-637 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 01 C8       MONITOR          Valid    Valid      Sets up a linear address range to be
    //                                                      monitored by hardware and activates
    //                                                      the monitor. The address range should
    //                                                      be a write-back memory caching type.
    //                                                      The address is DS:EAX (DS:RAX in 64-
    //                                                      bit mode).
    defn = new InsnDefn("monitor", x86_monitor, 0x03, 0x0f01c8, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);

    //--- page 3-640 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 88 /r             MOV r/m8,r8         Valid    Valid      Move r8 to r/m8.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0x88, od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // REX + 88 /r       MOV r/m8***,r8***   Valid    N.E.       Move r8 to r/m8.
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0x88, od_rex|od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // 89 /r             MOV r/m16,r16       Valid    Valid      Move r16 to r/m16.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0x89, od_modrm, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // 89 /r             MOV r/m32,r32       Valid    Valid      Move r32 to r/m32.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0x89, od_modrm, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // REX.W + 89 /r     MOV r/m64,r64       Valid    N.E.       Move r64 to r/m64.
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0x89, od_rexw|od_modrm, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // 8A /r             MOV r8,r/m8         Valid    Valid      Move r/m8 to r8.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0x8a, od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // REX + 8A /r       MOV r8***,r/m8***   Valid    N.E.       Move r/m8 to r8.
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0x8a, od_rex|od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // 8B /r             MOV r16,r/m16       Valid    Valid      Move r/m16 to r16.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0x8b, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // 8B /r             MOV r32,r/m32       Valid    Valid      Move r/m32 to r32.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0x8b, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // REX.W + 8B /r     MOV r64,r/m64       Valid    N.E.       Move r/m64 to r64.
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0x8b, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // 8C /r             MOV r/m16,Sreg**    Valid    Valid      Move segment register to
    //                                                           r/m16.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0x8c, od_modrm, od_r_m16, od_sreg);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // REX.W + 8C /r     MOV r/m64,Sreg**    Valid    Valid      Move zero extended 16-
    //                                                           bit segment register to
    //                                                           r/m64.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0x8c, od_rexw|od_modrm, od_r_m64, od_sreg);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // 8E /r             MOV Sreg,r/m16**    Valid    Valid      Move r/m16 to segment
    //                                                           register.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0x8e, od_modrm, od_sreg, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // REX.W + 8E /r     MOV Sreg,r/m64**    Valid    Valid      Move lower 16 bits of
    //                                                           r/m64 to segment
    //                                                           register.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0x8e, od_rexw|od_modrm, od_sreg, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // A0                MOV AL,moffs8*      Valid    Valid      Move byte at (seg:offset)
    //                                                           to AL.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0xa0, od_none, od_AL, od_moffs8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // REX.W + A0        MOV AL,moffs8*      Valid    N.E.       Move byte at (offset) to
    //                                                           AL.
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0xa0, od_rexw, od_AL, od_moffs8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // A1                MOV AX,moffs16*     Valid    Valid      Move word at (seg:offset)
    //                                                           to AX.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0xa1, od_none, od_AX, od_moffs16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // A1                MOV EAX,moffs32*    Valid    Valid      Move doubleword at
    //                                                           (seg:offset) to EAX.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0xa1, od_none, od_EAX, od_moffs32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // REX.W + A1        MOV RAX,moffs64*    Valid    N.E.       Move quadword at (offset)
    //                                                           to RAX.
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0xa1, od_rexw, od_RAX, od_moffs64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // A2                MOV moffs8,AL       Valid    Valid      Move AL to (seg:offset).
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0xa2, od_none, od_moffs8, od_AL);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // REX.W + A2        MOV moffs8***,AL    Valid    N.E.       Move AL to (offset).
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0xa2, od_rexw, od_moffs8, od_AL);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-640");
    define(defn);
    // A3                MOV moffs16*,AX     Valid    Valid      Move AX to (seg:offset).
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0xa3, od_none, od_moffs16, od_AX);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-641");
    define(defn);
    //  A3                   MOV moffs32*,EAX       Valid        Valid           Move EAX to (seg:offset).
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0xa3, od_none, od_moffs32, od_EAX);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-641");
    define(defn);
    //  REX.W + A3           MOV moffs64*,RAX       Valid        N.E.            Move RAX to (offset).
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0xa3, od_rexw, od_moffs64, od_RAX);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-641");
    define(defn);
    //  B0+ rb               MOV r8, imm8           Valid        Valid           Move imm8 to r8.
    //                                ***
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0xb0, od_rb|od_ib, od_r8, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-641");
    define(defn);
    //  REX + B0+ rb         MOV r8     , imm8      Valid        N.E.            Move imm8 to r8.
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0xb0, od_rex|od_rb|od_ib, od_r8, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-641");
    define(defn);
    //  B8+ rw               MOV r16, imm16         Valid        Valid           Move imm16 to r16.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0xb8, od_rw|od_iw, od_r16, od_imm16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-641");
    define(defn);
    //  B8+ rd               MOV r32, imm32         Valid        Valid           Move imm32 to r32.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0xb8, od_rd|od_id, od_r32, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-641");
    define(defn);
    //  REX.W + B8+ rd       MOV r64, imm64         Valid        N.E.            Move imm64 to r64.
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0xb8, od_rexw|od_rd|od_io, od_r64, od_imm64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-641");
    define(defn);
    //  C6 /0                MOV r/m8, imm8         Valid        Valid           Move imm8 to r/m8.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0xc6, od_e0|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-641");
    define(defn);
    //  REX + C6 /0          MOV r/m8***, imm8 Valid             N.E.            Move imm8 to r/m8.
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0xc6, od_rex|od_e0|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-641");
    define(defn);
    //  C7 /0                MOV r/m16, imm16       Valid        Valid           Move imm16 to r/m16.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0xc7, od_e0|od_iw, od_r_m16, od_imm16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-641");
    define(defn);
    //  C7 /0                MOV r/m32, imm32       Valid        Valid           Move imm32 to r/m32.
    defn = new InsnDefn("mov",    x86_mov,     0x03, 0xc7, od_e0|od_id, od_r_m32, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-641");
    define(defn);
    //  REX.W + C7 /0        MOV r/m64, imm32       Valid        N.E.            Move imm32 sign
    //                                                                           extended to 64-bits to
    //                                                                           r/m64.
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0xc7, od_rexw|od_e0|od_id, od_r_m64, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-646");
    define(defn);

    //--- page 3-646 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 20/r               MOV r32, CR0       N.E.        Valid           Move control register to r32
    //                       CR7
    defn = new InsnDefn("mov",    x86_mov,     0x01, 0x0f20, od_modrm, od_r32, od_CR0, od_CR7);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-646");
    define(defn);
    // 0F 20/r               MOV r64, CR0       Valid       N.E.            Move extended control
    //                       CR7                                             register to r64.
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0x0f20, od_modrm, od_r64, od_CR0, od_CR7);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-646");
    define(defn);
    // REX.R + 0F 20 /0      MOV r64, CR8        Valid       N.E.            Move extended CR8 to r64.1
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0x0f20, od_rexr|od_e0, od_r64, od_CR8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-646");
    define(defn);
    // 0F 22 /r              MOV CR0CR7,        N.E.        Valid           Move r32 to control register
    //                       r32
    defn = new InsnDefn("mov",    x86_mov,     0x01, 0x0f22, od_modrm, od_CR0CR7, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-646");
    define(defn);
    // 0F 22 /r              MOV CR0CR7,        Valid       N.E.            Move r64 to extended control
    //                       r64                                             register.
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0x0f22, od_modrm, od_CR0CR7, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-646");
    define(defn);
    // REX.R + 0F 22 /0      MOV CR8, r64        Valid       N.E.            Move r64 to extended CR8.1
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0x0f22, od_rexr|od_e0, od_CR8, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-649");
    define(defn);

    //--- page 3-649 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 21/r             MOV r32, DR0DR7      N.E.     Valid      Move debug register to r32
    defn = new InsnDefn("mov",    x86_mov,     0x01, 0x0f21, od_modrm, od_r32, od_DR0DR7);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-649");
    define(defn);
    //  0F 21/r             MOV r64, DR0DR7      Valid    N.E.       Move extended debug
    //                                                                register to r64.
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0x0f21, od_modrm, od_r64, od_DR0DR7);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-649");
    define(defn);
    //  0F 23 /r            MOV DR0DR7, r32      N.E.     Valid      Move r32 to debug register
    defn = new InsnDefn("mov",    x86_mov,     0x01, 0x0f23, od_modrm, od_DR0DR7, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-649");
    define(defn);
    //  0F 23 /r            MOV DR0DR7, r64      Valid    N.E.       Move r64 to extended debug
    //                                                                register.
    defn = new InsnDefn("mov",    x86_mov,     0x02, 0x0f23, od_modrm, od_DR0DR7, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-651");
    define(defn);

    //--- page 3-651 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  66 0F 28 /r    MOVAPD xmm1,            Valid      Valid            Move packed double-precision
    //                 xmm2/m128                                           floating-point values from
    //                                                                     xmm2/m128 to xmm1.
    defn = new InsnDefn("movapd", x86_movapd,  0x03, 0x660f28, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-651");
    define(defn);
    //  66 0F 29 /r    MOVAPD                  Valid      Valid            Move packed double-precision
    //                 xmm2/m128, xmm1                                     floating-point values from xmm1 to
    //                                                                     xmm2/m128.
    defn = new InsnDefn("movapd", x86_movapd,  0x03, 0x660f29, od_modrm, od_xmm_m128, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-654");
    define(defn);

    //--- page 3-654 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 28 /r    MOVAPS xmm1,          Valid      Valid          Move packed single-precision
    //             xmm2/m128                                       floating-point values from
    //                                                             xmm2/m128 to xmm1.
    defn = new InsnDefn("movaps", x86_movaps,  0x03, 0x0f28, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-654");
    define(defn);
    // 0F 29 /r    MOVAPS                Valid      Valid          Move packed single-precision
    //             xmm2/m128, xmm1                                 floating-point values from xmm1 to
    //                                                             xmm2/m128.
    defn = new InsnDefn("movaps", x86_movaps,  0x03, 0x0f29, od_modrm, od_xmm_m128, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-657");
    define(defn);

    //--- page 3-657 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 38 F0 /r         MOVBE r16, m16    Valid    Valid       Reverse byte order in m16
    //                                                             and move to r16
    defn = new InsnDefn("movbe",  x86_movbe,   0x03, 0x0f38f0, od_modrm, od_r16, od_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-657");
    define(defn);
    //  0F 38 F0 /r         MOVBE r32, m32    Valid    Valid       Reverse byte order in m32
    //                                                             and move to r32
    defn = new InsnDefn("movbe",  x86_movbe,   0x03, 0x0f38f0, od_modrm, od_r32, od_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-657");
    define(defn);
    //  REX.W + 0F 38 F0    MOVBE r64, m64    Valid    N.E.        Reverse byte order in m64
    //  /r                                                         and move to r64.
    defn = new InsnDefn("movbe",  x86_movbe,   0x02, 0x0f38f0, od_rexw|od_modrm, od_r64, od_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-657");
    define(defn);
    //  0F 38 F1 /r         MOVBE m16, r16    Valid    Valid       Reverse byte order in r16 and
    //                                                             move to m16
    defn = new InsnDefn("movbe",  x86_movbe,   0x03, 0x0f38f1, od_modrm, od_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-657");
    define(defn);
    //  0F 38 F1 /r         MOVBE m32, r32    Valid    Valid       Reverse byte order in r32 and
    //                                                             move to m32
    defn = new InsnDefn("movbe",  x86_movbe,   0x03, 0x0f38f1, od_modrm, od_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-657");
    define(defn);
    //  REX.W + 0F 38 F1    MOVBE m64, r64    Valid    N.E.        Reverse byte order in r64 and
    //  /r                                                         move to m64.
    defn = new InsnDefn("movbe",  x86_movbe,   0x02, 0x0f38f1, od_rexw|od_modrm, od_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-660");
    define(defn);

    //--- page 3-660 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 6E /r             MOVD mm, r/m32 Valid        Valid        Move doubleword from
    //                                                               r/m32 to mm.
    defn = new InsnDefn("movd",   x86_movd,    0x03, 0x0f6e, od_modrm, od_mm, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-660");
    define(defn);
    // REX.W + 0F 6E /r     MOVQ mm, r/m64 Valid        N.E.         Move quadword from
    //                                                               r/m64 to mm.
    defn = new InsnDefn("movq",   x86_movq,    0x02, 0x0f6e, od_rexw|od_modrm, od_mm, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-660");
    define(defn);
    // 0F 7E /r             MOVD r/m32, mm Valid        Valid        Move doubleword from mm
    //                                                               to r/m32.
    defn = new InsnDefn("movd",   x86_movd,    0x03, 0x0f7e, od_modrm, od_r_m32, od_mm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-660");
    define(defn);
    // REX.W + 0F 7E /r     MOVQ r/m64, mm Valid        N.E.         Move quadword from mm
    //                                                               to r/m64.
    defn = new InsnDefn("movq",   x86_movq,    0x02, 0x0f7e, od_rexw|od_modrm, od_r_m64, od_mm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-660");
    define(defn);
    // 66 0F 6E /r          MOVD xmm,        Valid      Valid        Move doubleword from
    //                      r/m32                                    r/m32 to xmm.
    defn = new InsnDefn("movd",   x86_movd,    0x03, 0x660f6e, od_modrm, od_xmm, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-660");
    define(defn);
    // 66 REX.W 0F 6E /r    MOVQ xmm,        Valid      N.E.         Move quadword from
    //                      r/m64                                    r/m64 to xmm.
    defn = new InsnDefn("movq",   x86_movq,    0x02, 0x660f6e, od_rexw|od_modrm, od_xmm, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-660");
    define(defn);
    // 66 0F 7E /r          MOVD r/m32,      Valid      Valid        Move doubleword from
    //                      xmm                                      xmm register to r/m32.
    defn = new InsnDefn("movd",   x86_movd,    0x03, 0x660f7e, od_modrm, od_r_m32, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-660");
    define(defn);
    //  66 REX.W 0F 7E /r   MOVQ r/m64,      Valid      N.E.         Move quadword from xmm
    //                      xmm                                      register to r/m64.
    defn = new InsnDefn("movq",   x86_movq,    0x02, 0x660f7e, od_rexw|od_modrm, od_r_m64, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-664");
    define(defn);

    //--- page 3-664 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F2 0F 12 /r     MOVDDUP xmm1,         Valid   Valid          Move one double-precision floating-
    //                 xmm2/m64                                     point value from the lower 64-bit
    //                                                              operand in xmm2/m64 to xmm1 and
    //                                                              duplicate.
    defn = new InsnDefn("movddup", x86_movddup, 0x03, 0xf20f12, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-667");
    define(defn);

    //--- page 3-667 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  66 0F 6F /r   MOVDQA xmm1,            Valid        Valid       Move aligned double quadword
    //                xmm2/m128                                        from xmm2/m128 to xmm1.
    defn = new InsnDefn("movdqa", x86_movdqa,  0x03, 0x660f6f, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-667");
    define(defn);
    //  66 0F 7F /r   MOVDQA xmm2/m128,       Valid        Valid       Move aligned double quadword
    //                xmm1                                             from xmm1 to xmm2/m128.
    defn = new InsnDefn("movdqa", x86_movdqa,  0x03, 0x660f7f, od_modrm, od_xmm_m128, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-669");
    define(defn);

    //--- page 3-669 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F3 0F 6F /r    MOVDQU xmm1,            Valid    Valid       Move unaligned double
    //                 xmm2/m128                                    quadword from xmm2/m128 to
    //                                                              xmm1.
    defn = new InsnDefn("movdqu", x86_movdqu,  0x03, 0xf30f6f, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-669");
    define(defn);
    //  F3 0F 7F /r    MOVDQU xmm2/m128, Valid          Valid       Move unaligned double
    //                 xmm1                                         quadword from xmm1 to
    //                                                              xmm2/m128.
    defn = new InsnDefn("movdqu", x86_movdqu,  0x03, 0xf30f7f, od_modrm, od_xmm_m128, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-672");
    define(defn);

    //--- page 3-672 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F2 0F D6        MOVDQ2Q mm, xmm     Valid       Valid          Move low quadword from
    //                                                                xmm to mmx register.
    defn = new InsnDefn("movdq2q", x86_movdq2q, 0x03, 0xf20fd6, od_none, od_mm, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-674");
    define(defn);

    //--- page 3-674 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 12 /r        MOVHLPS xmm1, xmm2      Valid      Valid           Move two packed single-
    //                                                                    precision floating-point values
    //                                                                    from high quadword of xmm2 to
    //                                                                    low quadword of xmm1.
    defn = new InsnDefn("movhlps", x86_movhlps, 0x03, 0x0f12, od_modrm, od_xmm, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-676");
    define(defn);

    //--- page 3-676 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F 16 /r MOVHPD xmm,        Valid       Valid          Move double-precision floating-point
    //             m64                                           value from m64 to high quadword of
    //                                                           xmm.
    defn = new InsnDefn("movhpd", x86_movhpd,  0x03, 0x660f16, od_modrm, od_xmm, od_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-676");
    define(defn);
    // 66 0F 17 /r MOVHPD m64,        Valid       Valid          Move double-precision floating-point
    //             xmm                                           value from high quadword of xmm to
    //                                                           m64.
    defn = new InsnDefn("movhpd", x86_movhpd,  0x03, 0x660f17, od_modrm, od_m64, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-679");
    define(defn);

    //--- page 3-679 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 16 /r         MOVHPS xmm,         Valid     Valid            Move two packed single-precision
    //                   m64                                            floating-point values from m64 to
    //                                                                  high quadword of xmm.
    defn = new InsnDefn("movhps", x86_movhps,  0x03, 0x0f16, od_modrm, od_xmm, od_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-679");
    define(defn);
    //  0F 17 /r         MOVHPS m64,         Valid     Valid            Move two packed single-precision
    //                   xmm                                            floating-point values from high
    //                                                                  quadword of xmm to m64.
    defn = new InsnDefn("movhps", x86_movhps,  0x03, 0x0f17, od_modrm, od_m64, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-682");
    define(defn);

    //--- page 3-682 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 16 /r    MOVLHPS xmm1,        Valid     Valid          Move two packed single-precision
    //             xmm2                                          floating-point values from low quadword
    //                                                           of xmm2 to high quadword of xmm1.
    defn = new InsnDefn("movlhps", x86_movlhps, 0x03, 0x0f16, od_modrm, od_xmm, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-684");
    define(defn);

    //--- page 3-684 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F 12 /r MOVLPD xmm,        Valid      Valid         Move double-precision floating-point
    //             m64                                         value from m64 to low quadword of xmm
    //                                                         register.
    defn = new InsnDefn("movlpd", x86_movlpd,  0x03, 0x660f12, od_modrm, od_xmm, od_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-684");
    define(defn);
    // 66 0F 13 /r MOVLPD m64,        Valid      Valid         Move double-precision floating-point
    //             xmm                                         nvalue from low quadword of xmm
    //                                                         register to m64.
    defn = new InsnDefn("movlpd", x86_movlpd,  0x03, 0x660f13, od_modrm, od_m64, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-686");
    define(defn);

    //--- page 3-686 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 12 /r    MOVLPS xmm,       Valid      Valid            Move two packed single-precision
    //             m64                                           floating-point values from m64 to low
    //                                                           quadword of xmm.
    defn = new InsnDefn("movlps", x86_movlps,  0x03, 0x0f12, od_modrm, od_xmm, od_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-686");
    define(defn);
    // 0F 13 /r    MOVLPS m64,       Valid      Valid            Move two packed single-precision
    //             xmm                                           floating-point values from low
    //                                                           quadword of xmm to m64.
    defn = new InsnDefn("movlps", x86_movlps,  0x03, 0x0f13, od_modrm, od_m64, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-689");
    define(defn);

    //--- page 3-689 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  66 0F 50 /r            MOVMSKPD reg,        Valid     Valid             Extract 2-bit sign mask
    //                         xmm                                              from xmm and store in reg.
    //                                                                          The upper bits of r32 or
    //                                                                          r64 are filled with zeros.
    defn = new InsnDefn("movmskpd", x86_movmskpd, 0x03, 0x660f50, od_modrm, od_reg, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-691");
    define(defn);

    //--- page 3-691 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 50 /r              MOVMSKPS reg,        Valid     Valid         Extract 4-bit sign mask from xmm
    //                        xmm                                          and store in reg. The upper bits of
    //                                                                     r32 or r64 are filled with zeros.
    defn = new InsnDefn("movmskps", x86_movmskps, 0x03, 0x0f50, od_modrm, od_reg, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-693");
    define(defn);

    //--- page 3-693 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  66 0F 38     MOVNTDQA xmm1,          Valid     Valid       Move double quadword from m128
    //  2A /r        m128                                          to xmm using non-temporal hint if
    //                                                             WC memory type.
    defn = new InsnDefn("movntdqa", x86_movntdqa, 0x03, 0x660f382a, od_modrm, od_xmm, od_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-696");
    define(defn);

    //--- page 3-696 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F E7 /r     MOVNTDQ m128,    Valid       Valid          Move double quadword from xmm
    //                 xmm                                         to m128 using non-temporal hint.
    defn = new InsnDefn("movntdq", x86_movntdq, 0x03, 0x660fe7, od_modrm, od_m128, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-699");
    define(defn);

    //--- page 3-699 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F C3 /r            MOVNTI m32, r32     Valid     Valid         Move doubleword from r32 to
    //                                                                  m32 using non-temporal hint.
    defn = new InsnDefn("movnti", x86_movnti,  0x03, 0x0fc3, od_modrm, od_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-699");
    define(defn);
    //  REX.W + 0F C3 /r    MOVNTI m64, r64     Valid     N.E.          Move quadword from r64 to
    //                                                                  m64 using non-temporal hint.
    defn = new InsnDefn("movnti", x86_movnti,  0x02, 0x0fc3, od_rexw|od_modrm, od_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-701");
    define(defn);

    //--- page 3-701 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  66 0F 2B /r    MOVNTPD m128,          Valid      Valid          Move packed double-precision
    //                 xmm                                              floating-point values from xmm to
    //                                                                  m128 using non-temporal hint.
    defn = new InsnDefn("movntpd", x86_movntpd, 0x03, 0x660f2b, od_modrm, od_m128, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-704");
    define(defn);

    //--- page 3-704 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 2B /r    MOVNTPS m128,         Valid      Valid           Move packed single-precision floating-
    //             xmm                                              point values from xmm to m128 using
    //                                                              non-temporal hint.
    defn = new InsnDefn("movntps", x86_movntps, 0x03, 0x0f2b, od_modrm, od_m128, od_xmm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-707");
    define(defn);

    //--- page 3-707 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F E7 /r    MOVNTQ m64,       Valid     Valid       Move quadword from mm to m64 using
    //              mm                                      non-temporal hint.
    defn = new InsnDefn("movntq", x86_movntq,  0x03, 0x0fe7, od_modrm, od_m64, od_mm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-710");
    define(defn);

    //--- page 3-710 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 6F /r    MOVQ mm, mm/m64           Valid       Valid         Move quadword from mm/m64
    //                                                                 to mm.
    defn = new InsnDefn("movq",   x86_movq,    0x03, 0x0f6f, od_modrm, od_mm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-710");
    define(defn);
    // 0F 7F /r    MOVQ mm/m64, mm           Valid       Valid         Move quadword from mm to
    //                                                                 mm/m64.
    defn = new InsnDefn("movq",   x86_movq,    0x03, 0x0f7f, od_modrm, od_mm_m64, od_mm);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-710");
    define(defn);
    // F3 0F 7E    MOVQ xmm1, xmm2/m64 Valid             Valid         Move quadword from
    //                                                                 xmm2/mem64 to xmm1.
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
