//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "sage3basic.h"
#include "AssemblerX86.h"

/* Generated by ./IntelAssemblyBuilder from 
 * x86-InstructionSetReference-AM.pdf 
 * x86-InstructionSetReference-NZ.pdf 
 * ExtraInstructions.txt */
void AssemblerX86::initAssemblyRules_part1() {
    AssemblerX86::InsnDefn *defn = NULL;

    //------------------------------------------------------------------------------------------------------------------
    // The following definitions are from x86-InstructionSetReference-AM.pdf, version March 2009.
    //------------------------------------------------------------------------------------------------------------------


    //--- page 3-26 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    // 37             AAA            Invalid        Valid      ASCII adjust AL after addition.
    defn = new InsnDefn("aaa",    x86_aaa,     0x01, 0x37, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-28");
    define(defn);

    //--- page 3-28 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    // D5 0A          AAD               Invalid        Valid      ASCII adjust AX before division.
    defn = new InsnDefn("aad",    x86_aad,     0x01, 0xd50a, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-28");
    define(defn);
    // D5 ib          (No mnemonic)     Invalid        Valid      Adjust AX before division to
    //                                                            number base imm8.
    defn = new InsnDefn("aad",    x86_aad,     0x01, 0xd5, od_ib);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-30");
    define(defn);

    //--- page 3-30 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    // D4 0A          AAM              Invalid    Valid          ASCII adjust AX after multiply.
    defn = new InsnDefn("aam",    x86_aam,     0x01, 0xd40a, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-30");
    define(defn);
    // D4 ib          (No mnemonic)    Invalid    Valid          Adjust AX after multiply to number
    //                                                           base imm8.
    defn = new InsnDefn("aam",    x86_aam,     0x01, 0xd4, od_ib);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-32");
    define(defn);

    //--- page 3-32 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    // 3F             AAS            Invalid        Valid      ASCII adjust AL after subtraction.
    defn = new InsnDefn("aas",    x86_aas,     0x01, 0x3f, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);

    //--- page 3-34 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    // 14 ib              ADC AL, imm8     Valid    Valid      Add with carry imm8 to AL.
    defn = new InsnDefn("adc",    x86_adc,     0x03, 0x14, od_ib, od_AL, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // 15 iw              ADC AX, imm16 Valid       Valid      Add with carry imm16 to AX.
    defn = new InsnDefn("adc",    x86_adc,     0x03, 0x15, od_iw, od_AX, od_imm16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // 15 id              ADC EAX,         Valid    Valid      Add with carry imm32 to EAX.
    //                    imm32
    defn = new InsnDefn("adc",    x86_adc,     0x03, 0x15, od_id, od_EAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // REX.W + 15 id      ADC RAX,         Valid    N.E.       Add with carry imm32 sign
    //                    imm32                                extended to 64-bits to RAX.
    defn = new InsnDefn("adc",    x86_adc,     0x02, 0x15, od_rexw|od_id, od_RAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // 80 /2 ib           ADC r/m8,        Valid    Valid      Add with carry imm8 to r/m8.
    //                    imm8
    defn = new InsnDefn("adc",    x86_adc,     0x03, 0x80, od_e2|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // REX + 80 /2 ib     ADC r/m8*,       Valid    N.E.       Add with carry imm8 to r/m8.
    //                    imm8
    defn = new InsnDefn("adc",    x86_adc,     0x02, 0x80, od_rex|od_e2|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // 81 /2 iw           ADC r/m16,       Valid    Valid      Add with carry imm16 to r/m16.
    //                    imm16
    defn = new InsnDefn("adc",    x86_adc,     0x03, 0x81, od_e2|od_iw, od_r_m16, od_imm16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // 81 /2 id           ADC r/m32,       Valid    Valid      Add with CF imm32 to r/m32.
    //                    imm32
    defn = new InsnDefn("adc",    x86_adc,     0x03, 0x81, od_e2|od_id, od_r_m32, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // REX.W + 81 /2 id   ADC r/m64,       Valid    N.E.       Add with CF imm32 sign
    //                    imm32                                extended to 64-bits to r/m64.
    defn = new InsnDefn("adc",    x86_adc,     0x02, 0x81, od_rexw|od_e2|od_id, od_r_m64, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // 83 /2 ib           ADC r/m16,       Valid    Valid      Add with CF sign-extended
    //                    imm8                                 imm8 to r/m16.
    defn = new InsnDefn("adc",    x86_adc,     0x03, 0x83, od_e2|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // 83 /2 ib           ADC r/m32,       Valid    Valid      Add with CF sign-extended
    //                    imm8                                 imm8 into r/m32.
    defn = new InsnDefn("adc",    x86_adc,     0x03, 0x83, od_e2|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // REX.W + 83 /2 ib   ADC r/m64,       Valid    N.E.       Add with CF sign-extended
    //                    imm8                                 imm8 into r/m64.
    defn = new InsnDefn("adc",    x86_adc,     0x02, 0x83, od_rexw|od_e2|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // 10 /r              ADC r/m8, r8     Valid    Valid      Add with carry byte register to
    //                                                         r/m8.
    defn = new InsnDefn("adc",    x86_adc,     0x03, 0x10, od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // REX + 10 /r        ADC r/m8*, r8*   Valid    N.E.       Add with carry byte register to
    //                                                         r/m64.
    defn = new InsnDefn("adc",    x86_adc,     0x02, 0x10, od_rex|od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // 11 /r              ADC r/m16, r16 Valid      Valid      Add with carry r16 to r/m16.
    defn = new InsnDefn("adc",    x86_adc,     0x03, 0x11, od_modrm, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // 11 /r              ADC r/m32, r32 Valid      Valid      Add with CF r32 to r/m32.
    defn = new InsnDefn("adc",    x86_adc,     0x03, 0x11, od_modrm, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // REX.W + 11 /r      ADC r/m64, r64 Valid      N.E.       Add with CF r64 to r/m64.
    defn = new InsnDefn("adc",    x86_adc,     0x02, 0x11, od_rexw|od_modrm, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // 12 /r              ADC r8, r/m8     Valid    Valid      Add with carry r/m8 to byte
    //                                                         register.
    defn = new InsnDefn("adc",    x86_adc,     0x03, 0x12, od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // REX + 12 /r        ADC r8*, r/m8*   Valid    N.E.       Add with carry r/m64 to byte
    //                                                         register.
    defn = new InsnDefn("adc",    x86_adc,     0x02, 0x12, od_rex|od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-34");
    define(defn);
    // 13 /r              ADC r16, r/m16 Valid      Valid      Add with carry r/m16 to r16.
    defn = new InsnDefn("adc",    x86_adc,     0x03, 0x13, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-35");
    define(defn);
    //  13 /r               ADC r32, r/m32 Valid           Valid           Add with CF r/m32 to r32.
    defn = new InsnDefn("adc",    x86_adc,     0x03, 0x13, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-35");
    define(defn);
    //  REX.W + 13 /r       ADC r64, r/m64 Valid          N.E.             Add with CF r/m64 to r64.
    defn = new InsnDefn("adc",    x86_adc,     0x02, 0x13, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);

    //--- page 3-37 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  04 ib                ADD AL, imm8           Valid           Valid            Add imm8 to AL.
    defn = new InsnDefn("add",    x86_add,     0x03, 0x04, od_ib, od_AL, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  05 iw                ADD AX, imm16          Valid           Valid            Add imm16 to AX.
    defn = new InsnDefn("add",    x86_add,     0x03, 0x05, od_iw, od_AX, od_imm16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  05 id                ADD EAX, imm32         Valid           Valid            Add imm32 to EAX.
    defn = new InsnDefn("add",    x86_add,     0x03, 0x05, od_id, od_EAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  REX.W + 05 id        ADD RAX, imm32         Valid           N.E.             Add imm32 sign-
    //                                                                               extended to 64-bits
    //                                                                               to RAX.
    defn = new InsnDefn("add",    x86_add,     0x02, 0x05, od_rexw|od_id, od_RAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  80 /0 ib             ADD r/m8, imm8         Valid           Valid            Add imm8 to r/m8.
    defn = new InsnDefn("add",    x86_add,     0x03, 0x80, od_e0|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  REX + 80 /0 ib       ADD r/m8*, imm8        Valid           N.E.             Add sign-extended
    //                                                                               imm8 to r/m64.
    defn = new InsnDefn("add",    x86_add,     0x02, 0x80, od_rex|od_e0|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  81 /0 iw             ADD r/m16, imm16       Valid           Valid            Add imm16 to r/m16.
    defn = new InsnDefn("add",    x86_add,     0x03, 0x81, od_e0|od_iw, od_r_m16, od_imm16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  81 /0 id             ADD r/m32, imm32       Valid           Valid            Add imm32 to r/m32.
    defn = new InsnDefn("add",    x86_add,     0x03, 0x81, od_e0|od_id, od_r_m32, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  REX.W + 81 /0 id     ADD r/m64, imm32       Valid           N.E.             Add imm32 sign-
    //                                                                               extended to 64-bits
    //                                                                               to r/m64.
    defn = new InsnDefn("add",    x86_add,     0x02, 0x81, od_rexw|od_e0|od_id, od_r_m64, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  83 /0 ib             ADD r/m16, imm8        Valid           Valid            Add sign-extended
    //                                                                               imm8 to r/m16.
    defn = new InsnDefn("add",    x86_add,     0x03, 0x83, od_e0|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  83 /0 ib             ADD r/m32, imm8        Valid           Valid            Add sign-extended
    //                                                                               imm8 to r/m32.
    defn = new InsnDefn("add",    x86_add,     0x03, 0x83, od_e0|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  REX.W + 83 /0 ib     ADD r/m64, imm8        Valid           N.E.             Add sign-extended
    //                                                                               imm8 to r/m64.
    defn = new InsnDefn("add",    x86_add,     0x02, 0x83, od_rexw|od_e0|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  00 /r                ADD r/m8, r8           Valid           Valid            Add r8 to r/m8.
    //                                  *    *
    defn = new InsnDefn("add",    x86_add,     0x03, 0x00, od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  REX + 00 /r          ADD r/m8 , r8          Valid           N.E.             Add r8 to r/m8.
    defn = new InsnDefn("add",    x86_add,     0x02, 0x00, od_rex|od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  01 /r                ADD r/m16, r16         Valid           Valid            Add r16 to r/m16.
    defn = new InsnDefn("add",    x86_add,     0x03, 0x01, od_modrm, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  01 /r                ADD r/m32, r32         Valid           Valid            Add r32 to r/m32.
    defn = new InsnDefn("add",    x86_add,     0x03, 0x01, od_modrm, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  REX.W + 01 /r        ADD r/m64, r64         Valid           N.E.             Add r64 to r/m64.
    defn = new InsnDefn("add",    x86_add,     0x02, 0x01, od_rexw|od_modrm, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  02 /r                ADD r8, r/m8           Valid           Valid            Add r/m8 to r8.
    //                              *        *
    defn = new InsnDefn("add",    x86_add,     0x03, 0x02, od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  REX + 02 /r          ADD r8 , r/m8          Valid           N.E.             Add r/m8 to r8.
    defn = new InsnDefn("add",    x86_add,     0x02, 0x02, od_rex|od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  03 /r                ADD r16, r/m16         Valid           Valid            Add r/m16 to r16.
    defn = new InsnDefn("add",    x86_add,     0x03, 0x03, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  03 /r                ADD r32, r/m32         Valid           Valid            Add r/m32 to r32.
    defn = new InsnDefn("add",    x86_add,     0x03, 0x03, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-37");
    define(defn);
    //  REX.W + 03 /r        ADD r64, r/m64         Valid           N.E.             Add r/m64 to r64.
    defn = new InsnDefn("add",    x86_add,     0x02, 0x03, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-40");
    define(defn);

    //--- page 3-40 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    // 66 0F 58 /r    ADDPD xmm1,      Valid      Valid          Add packed double-precision floating-
    //                xmm2/m128                                  point values from xmm2/m128 to
    //                                                           xmm1.
    defn = new InsnDefn("addpd",  x86_addpd,   0x03, 0x660f58, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-43");
    define(defn);

    //--- page 3-43 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  0F 58 /r      ADDPS xmm1, xmm2/m128           Valid      Valid        Add packed single-precision
    //                                                                        floating-point values from
    //                                                                        xmm2/m128 to xmm1.
    defn = new InsnDefn("addps",  x86_addps,   0x03, 0x0f58, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-46");
    define(defn);

    //--- page 3-46 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    // F2 0F 58 /r    ADDSD xmm1, xmm2/m64        Valid     Valid            Add the low double-
    //                                                                       precision floating-point
    //                                                                       value from xmm2/m64 to
    //                                                                       xmm1.
    defn = new InsnDefn("addsd",  x86_addsd,   0x03, 0xf20f58, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-49");
    define(defn);

    //--- page 3-49 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  F3 0F 58 /r      ADDSS xmm1, xmm2/m32            Valid    Valid         Add the low single-
    //                                                                          precision floating-point
    //                                                                          value from xmm2/m32 to
    //                                                                          xmm1.
    defn = new InsnDefn("addss",  x86_addss,   0x03, 0xf30f58, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-52");
    define(defn);

    //--- page 3-52 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    // 66 0F D0 /r    ADDSUBPD xmm1, xmm2/m128      Valid       Valid          Add/subtract
    //                                                                         double-precision
    //                                                                         floating-point values
    //                                                                         from xmm2/m128
    //                                                                         to xmm1.
    defn = new InsnDefn("addsubpd", x86_addsubpd, 0x03, 0x660fd0, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-56");
    define(defn);

    //--- page 3-56 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    // F2 0F D0 /r    ADDSUBPS xmm1, xmm2/m128             Valid     Valid                Add/subtract single-
    //                                                                                    precision floating-
    //                                                                                    point values from
    //                                                                                    xmm2/m128 to
    //                                                                                    xmm1.
    defn = new InsnDefn("addsubps", x86_addsubps, 0x03, 0xf20fd0, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);

    //--- page 3-60 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    // 24 ib            AND AL, imm8           Valid         Valid         AL AND imm8.
    defn = new InsnDefn("and",    x86_and,     0x03, 0x24, od_ib, od_AL, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // 25 iw            AND AX, imm16          Valid         Valid         AX AND imm16.
    defn = new InsnDefn("and",    x86_and,     0x03, 0x25, od_iw, od_AX, od_imm16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // 25 id            AND EAX, imm32         Valid         Valid         EAX AND imm32.
    defn = new InsnDefn("and",    x86_and,     0x03, 0x25, od_id, od_EAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // REX.W + 25 id    AND RAX, imm32         Valid         N.E.          RAX AND imm32 sign-
    //                                                                     extended to 64-bits.
    defn = new InsnDefn("and",    x86_and,     0x02, 0x25, od_rexw|od_id, od_RAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // 80 /4 ib         AND r/m8, imm8         Valid         Valid         r/m8 AND imm8.
    //                              *
    defn = new InsnDefn("and",    x86_and,     0x03, 0x80, od_e4|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // REX + 80 /4 ib   AND r/m8 , imm8        Valid         N.E.          r/m64 AND imm8 (sign-
    //                                                                     extended).
    defn = new InsnDefn("and",    x86_and,     0x02, 0x80, od_rex|od_e4|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // 81 /4 iw         AND r/m16, imm16       Valid         Valid         r/m16 AND imm16.
    defn = new InsnDefn("and",    x86_and,     0x03, 0x81, od_e4|od_iw, od_r_m16, od_imm16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // 81 /4 id         AND r/m32, imm32       Valid         Valid         r/m32 AND imm32.
    defn = new InsnDefn("and",    x86_and,     0x03, 0x81, od_e4|od_id, od_r_m32, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // REX.W + 81 /4    AND r/m64, imm32       Valid         N.E.          r/m64 AND imm32 sign
    // id                                                                  extended to 64-bits.
    defn = new InsnDefn("and",    x86_and,     0x02, 0x81, od_rexw|od_e4|od_id, od_r_m64, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // 83 /4 ib         AND r/m16, imm8        Valid         Valid         r/m16 AND imm8 (sign-
    //                                                                     extended).
    defn = new InsnDefn("and",    x86_and,     0x03, 0x83, od_e4|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // 83 /4 ib         AND r/m32, imm8        Valid         Valid         r/m32 AND imm8 (sign-
    //                                                                     extended).
    defn = new InsnDefn("and",    x86_and,     0x03, 0x83, od_e4|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // REX.W + 83 /4    AND r/m64, imm8        Valid         N.E.          r/m64 AND imm8 (sign-
    // ib                                                                  extended).
    defn = new InsnDefn("and",    x86_and,     0x02, 0x83, od_rexw|od_e4|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // 20 /r            AND r/m8, r8           Valid         Valid         r/m8 AND r8.
    defn = new InsnDefn("and",    x86_and,     0x03, 0x20, od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // REX + 20 /r      AND r/m8*, r8*         Valid         N.E.          r/m64 AND r8 (sign-
    //                                                                     extended).
    defn = new InsnDefn("and",    x86_and,     0x02, 0x20, od_rex|od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // 21 /r            AND r/m16, r16         Valid         Valid         r/m16 AND r16.
    defn = new InsnDefn("and",    x86_and,     0x03, 0x21, od_modrm, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // 21 /r            AND r/m32, r32         Valid         Valid         r/m32 AND r32.
    defn = new InsnDefn("and",    x86_and,     0x03, 0x21, od_modrm, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // REX.W + 21 /r    AND r/m64, r64         Valid         N.E.          r/m64 AND r32.
    defn = new InsnDefn("and",    x86_and,     0x02, 0x21, od_rexw|od_modrm, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // 22 /r            AND r8, r/m8           Valid         Valid         r8 AND r/m8.
    //                          *       *
    defn = new InsnDefn("and",    x86_and,     0x03, 0x22, od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // REX + 22 /r      AND r8 , r/m8          Valid         N.E.          r/m64 AND r8 (sign-
    //                                                                     extended).
    defn = new InsnDefn("and",    x86_and,     0x02, 0x22, od_rex|od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // 23 /r            AND r16, r/m16         Valid         Valid         r16 AND r/m16.
    defn = new InsnDefn("and",    x86_and,     0x03, 0x23, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // 23 /r            AND r32, r/m32         Valid         Valid         r32 AND r/m32.
    defn = new InsnDefn("and",    x86_and,     0x03, 0x23, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-60");
    define(defn);
    // REX.W + 23 /r    AND r64, r/m64         Valid         N.E.          r64 AND r/m64.
    defn = new InsnDefn("and",    x86_and,     0x02, 0x23, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-63");
    define(defn);

    //--- page 3-63 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  66 0F 54 /r ANDPD xmm1,            Valid      Valid          Bitwise logical AND of xmm2/m128 and
    //              xmm2/m128                                        xmm1.
    defn = new InsnDefn("andpd",  x86_andpd,   0x03, 0x660f54, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-65");
    define(defn);

    //--- page 3-65 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  0F 54 /r     ANDPS xmm1, xmm2/m128 Valid                Valid               Bitwise logical AND of
    //                                                                              xmm2/m128 and xmm1.
    defn = new InsnDefn("andps",  x86_andps,   0x03, 0x0f54, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-67");
    define(defn);

    //--- page 3-67 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  66 0F 55 /r     ANDNPD xmm1, xmm2/m128             Valid      Valid              Bitwise logical AND
    //                                                                                   NOT of xmm2/m128
    //                                                                                   and xmm1.
    defn = new InsnDefn("andnpd", x86_andnpd,  0x03, 0x660f55, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-69");
    define(defn);

    //--- page 3-69 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  0F 55 /r      ANDNPS xmm1, xmm2/m128 Valid                Valid          Bitwise logical AND NOT of
    //                                                                           xmm2/m128 and xmm1.
    defn = new InsnDefn("andnps", x86_andnps,  0x03, 0x0f55, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-71");
    define(defn);

    //--- page 3-71 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  63 /r          ARPL r/m16, r16       N. E.    Valid      Adjust RPL of r/m16 to not less
    //                                                           than RPL of r16.
    defn = new InsnDefn("arpl",   x86_arpl,    0x01, 0x63, od_modrm, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-73");
    define(defn);

    //--- page 3-73 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  66 0F 3A 0D      BLENDPD xmm1,   Valid            Valid        Select packed DP-FP values from
    //  /r ib            xmm2/m128, imm8                               xmm1 and xmm2/m128 from mask
    //                                                                 specified in imm8 and store the
    //                                                                 values into xmm1.
    defn = new InsnDefn("blendpd", x86_blendpd, 0x03, 0x660f3a0d, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-75");
    define(defn);

    //--- page 3-75 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  66 0F 3A 0C     BLENDPS xmm1,          Valid     Valid         Select packed single precision
    //  /r ib           xmm2/m128,                                     floating-point values from xmm1 and
    //                  imm8                                           xmm2/m128 from mask specified in
    //                                                                 imm8 and store the values into
    //                                                                 xmm1.
    defn = new InsnDefn("blendps", x86_blendps, 0x03, 0x660f3a0c, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-78");
    define(defn);

    //--- page 3-78 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    // 66 0F 38 15 BLENDVPD xmm1,     Valid           Valid         Select packed DP FP values
    // /r          xmm2/m128 , <XMM0>                               from xmm1 and xmm2 from
    //                                                              mask specified in XMM0 and
    //                                                              store the values in xmm1.
    defn = new InsnDefn("blendvpd", x86_blendvpd, 0x03, 0x660f3815, od_modrm, od_xmm, od_xmm_m128, od_XMM0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-81");
    define(defn);

    //--- page 3-81 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  66 0F 38      BLENDVPS xmm1,    Valid             Valid        Select packed single precision
    //  14 /r         xmm2/m128, <XMM0>                                floating-point values from xmm1
    //                                                                 and xmm2/m128 from mask
    //                                                                 specified in XMM0 and store the
    //                                                                 values into xmm1.
    defn = new InsnDefn("blendvps", x86_blendvps, 0x03, 0x660f3814, od_modrm, od_xmm, od_xmm_m128, od_XMM0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-84");
    define(defn);

    //--- page 3-84 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    // 62 /r          BOUND r16, m16&16     Invalid   Valid           Check if r16 (array index) is
    //                                                                within bounds specified by
    //                                                                m16&16.
    defn = new InsnDefn("bound",  x86_bound,   0x01, 0x62, od_modrm, od_r16, od_m16a16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-84");
    define(defn);
    // 62 /r          BOUND r32, m32&32     Invalid   Valid           Check if r32 (array index) is
    //                                                                within bounds specified by
    //                                                                m16&16.
    defn = new InsnDefn("bound",  x86_bound,   0x01, 0x62, od_modrm, od_r32, od_m32a32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-87");
    define(defn);

    //--- page 3-87 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  0F BC /r              BSF r16, r/m16   Valid    Valid          Bit scan forward on r/m16.
    defn = new InsnDefn("bsf",    x86_bsf,     0x03, 0x0fbc, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-87");
    define(defn);
    //  0F BC /r              BSF r32, r/m32   Valid    Valid          Bit scan forward on r/m32.
    defn = new InsnDefn("bsf",    x86_bsf,     0x03, 0x0fbc, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-87");
    define(defn);
    //  REX.W + 0F BC         BSF r64, r/m64   Valid    N.E.           Bit scan forward on r/m64.
    defn = new InsnDefn("bsf",    x86_bsf,     0x02, 0x0fbc, od_rexw, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-89");
    define(defn);

    //--- page 3-89 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  0F BD /r              BSR r16, r/m16   Valid    Valid         Bit scan reverse on r/m16.
    defn = new InsnDefn("bsr",    x86_bsr,     0x03, 0x0fbd, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-89");
    define(defn);
    //  0F BD /r              BSR r32, r/m32   Valid    Valid         Bit scan reverse on r/m32.
    defn = new InsnDefn("bsr",    x86_bsr,     0x03, 0x0fbd, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-89");
    define(defn);
    //  REX.W + 0F BD         BSR r64, r/m64   Valid    N.E.          Bit scan reverse on r/m64.
    defn = new InsnDefn("bsr",    x86_bsr,     0x02, 0x0fbd, od_rexw, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-91");
    define(defn);

    //--- page 3-91 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  0F C8+rd          BSWAP r32          Valid*     Valid      Reverses the byte order of a 32-
    //                                                             bit register.
    defn = new InsnDefn("bswap",  x86_bswap,   0x03, 0x0fc8, od_rd, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-91");
    define(defn);
    //  REX.W + 0F        BSWAP r64           Valid     N.E.       Reverses the byte order of a 64-
    //  C8+rd                                                      bit register.
    defn = new InsnDefn("bswap",  x86_bswap,   0x02, 0x0fc8, od_rexw|od_rd, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-93");
    define(defn);

    //--- page 3-93 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  0F A3                     BT r/m16, r16      Valid    Valid          Store selected bit in CF
    //                                                                       flag.
    defn = new InsnDefn("bt",     x86_bt,      0x03, 0x0fa3, od_none, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-93");
    define(defn);
    //  0F A3                     BT r/m32, r32      Valid    Valid          Store selected bit in CF
    //                                                                       flag.
    defn = new InsnDefn("bt",     x86_bt,      0x03, 0x0fa3, od_none, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-93");
    define(defn);
    //  REX.W + 0F A3             BT r/m64, r64      Valid    N.E.           Store selected bit in CF
    //                                                                       flag.
    defn = new InsnDefn("bt",     x86_bt,      0x02, 0x0fa3, od_rexw, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-93");
    define(defn);
    //  0F BA /4 ib               BT r/m16, imm8     Valid    Valid          Store selected bit in CF
    //                                                                       flag.
    defn = new InsnDefn("bt",     x86_bt,      0x03, 0x0fba, od_e4|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-93");
    define(defn);
    //  0F BA /4 ib               BT r/m32, imm8     Valid    Valid          Store selected bit in CF
    //                                                                       flag.
    defn = new InsnDefn("bt",     x86_bt,      0x03, 0x0fba, od_e4|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-93");
    define(defn);
    //  REX.W + 0F BA /4 ib       BT r/m64, imm8     Valid    N.E.           Store selected bit in CF
    //                                                                       flag.
    defn = new InsnDefn("bt",     x86_bt,      0x02, 0x0fba, od_rexw|od_e4|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-96");
    define(defn);

    //--- page 3-96 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    // 0F BB                 BTC r/m16, r16     Valid    Valid          Store selected bit in CF flag
    //                                                                  and complement.
    defn = new InsnDefn("btc",    x86_btc,     0x03, 0x0fbb, od_none, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-96");
    define(defn);
    // 0F BB                 BTC r/m32, r32     Valid    Valid          Store selected bit in CF flag
    //                                                                  and complement.
    defn = new InsnDefn("btc",    x86_btc,     0x03, 0x0fbb, od_none, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-96");
    define(defn);
    // REX.W + 0F BB         BTC r/m64, r64     Valid    N.E.           Store selected bit in CF flag
    //                                                                  and complement.
    defn = new InsnDefn("btc",    x86_btc,     0x02, 0x0fbb, od_rexw, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-96");
    define(defn);
    // 0F BA /7 ib           BTC r/m16, imm8    Valid    Valid          Store selected bit in CF flag
    //                                                                  and complement.
    defn = new InsnDefn("btc",    x86_btc,     0x03, 0x0fba, od_e7|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-96");
    define(defn);
    // 0F BA /7 ib           BTC r/m32, imm8    Valid    Valid          Store selected bit in CF flag
    //                                                                  and complement.
    defn = new InsnDefn("btc",    x86_btc,     0x03, 0x0fba, od_e7|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-96");
    define(defn);
    // REX.W + 0F BA /7 ib   BTC r/m64, imm8    Valid    N.E.           Store selected bit in CF flag
    //                                                                  and complement.
    defn = new InsnDefn("btc",    x86_btc,     0x02, 0x0fba, od_rexw|od_e7|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-99");
    define(defn);

    //--- page 3-99 of x86-InstructionSetReference-AM.pdf --------------------------------------------------------------
    //  0F B3                   BTR r/m16, r16   Valid     Valid          Store selected bit in CF
    //                                                                    flag and clear.
    defn = new InsnDefn("btr",    x86_btr,     0x03, 0x0fb3, od_none, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-99");
    define(defn);
    //  0F B3                   BTR r/m32, r32   Valid     Valid          Store selected bit in CF
    //                                                                    flag and clear.
    defn = new InsnDefn("btr",    x86_btr,     0x03, 0x0fb3, od_none, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-99");
    define(defn);
    //  REX.W + 0F B3           BTR r/m64, r64   Valid     N.E.           Store selected bit in CF
    //                                                                    flag and clear.
    defn = new InsnDefn("btr",    x86_btr,     0x02, 0x0fb3, od_rexw, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-99");
    define(defn);
    //  0F BA /6 ib             BTR r/m16, imm8 Valid      Valid          Store selected bit in CF
    //                                                                    flag and clear.
    defn = new InsnDefn("btr",    x86_btr,     0x03, 0x0fba, od_e6|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-99");
    define(defn);
    //  0F BA /6 ib             BTR r/m32, imm8 Valid      Valid          Store selected bit in CF
    //                                                                    flag and clear.
    defn = new InsnDefn("btr",    x86_btr,     0x03, 0x0fba, od_e6|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-99");
    define(defn);
    //  REX.W + 0F BA /6 ib     BTR r/m64, imm8 Valid      N.E.           Store selected bit in CF
    //                                                                    flag and clear.
    defn = new InsnDefn("btr",    x86_btr,     0x02, 0x0fba, od_rexw|od_e6|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-102");
    define(defn);

    //--- page 3-102 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F AB                 BTS r/m16, r16      Valid       Valid        Store selected bit in CF
    //                                                                    flag and set.
    defn = new InsnDefn("bts",    x86_bts,     0x03, 0x0fab, od_none, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-102");
    define(defn);
    // 0F AB                 BTS r/m32, r32      Valid       Valid        Store selected bit in CF
    //                                                                    flag and set.
    defn = new InsnDefn("bts",    x86_bts,     0x03, 0x0fab, od_none, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-102");
    define(defn);
    // REX.W + 0F AB         BTS r/m64, r64      Valid       N.E.         Store selected bit in CF
    //                                                                    flag and set.
    defn = new InsnDefn("bts",    x86_bts,     0x02, 0x0fab, od_rexw, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-102");
    define(defn);
    // 0F BA /5 ib           BTS r/m16, imm8     Valid       Valid        Store selected bit in CF
    //                                                                    flag and set.
    defn = new InsnDefn("bts",    x86_bts,     0x03, 0x0fba, od_e5|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-102");
    define(defn);
    // 0F BA /5 ib           BTS r/m32, imm8     Valid       Valid        Store selected bit in CF
    //                                                                    flag and set.
    defn = new InsnDefn("bts",    x86_bts,     0x03, 0x0fba, od_e5|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-102");
    define(defn);
    // REX.W + 0F BA /5 ib   BTS r/m64, imm8     Valid       N.E.         Store selected bit in CF
    //                                                                    flag and set.
    defn = new InsnDefn("bts",    x86_bts,     0x02, 0x0fba, od_rexw|od_e5|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-105");
    define(defn);

    //--- page 3-105 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  E8 cw                CALL rel16    N.S.      Valid      Call near, relative, displacement
    //                                                          relative to next instruction.
    defn = new InsnDefn("call",   x86_call,    0x01, 0xe8, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-105");
    define(defn);
    //  E8 cd                CALL rel32    Valid     Valid      Call near, relative, displacement
    //                                                          relative to next instruction. 32-bit
    //                                                          displacement sign extended to 64-bits
    //                                                          in 64-bit mode.
    defn = new InsnDefn("call",   x86_call,    0x03, 0xe8, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-105");
    define(defn);
    //  FF /2                CALL r/m16    N.E.      Valid      Call near, absolute indirect, address
    //                                                          given in r/m16.
    defn = new InsnDefn("call",   x86_call,    0x01, 0xff, od_e2, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-105");
    define(defn);
    //  FF /2                CALL r/m32    N.E.      Valid      Call near, absolute indirect, address
    //                                                          given in r/m32.
    defn = new InsnDefn("call",   x86_call,    0x01, 0xff, od_e2, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-105");
    define(defn);
    //  FF /2                CALL r/m64    Valid     N.E.       Call near, absolute indirect, address
    //                                                          given in r/m64.
    defn = new InsnDefn("call",   x86_call,    0x02, 0xff, od_e2, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-105");
    define(defn);
    //  9A cd                CALL          Invalid   Valid      Call far, absolute, address given in
    //                       ptr16:16                           operand.
    defn = new InsnDefn("call",   x86_farcall, 0x01, 0x9a, od_cd, od_ptr16_16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-105");
    define(defn);
    //  9A cp                CALL          Invalid   Valid      Call far, absolute, address given in
    //                       ptr16:32                           operand.
    defn = new InsnDefn("call",   x86_farcall, 0x01, 0x9a, od_cp, od_ptr16_32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-105");
    define(defn);
    //  FF /3                CALL m16:16 Valid       Valid      Call far, absolute indirect address given
    //                                                          in m16:16.
    //                                                          In 32-bit mode: if selector points to a
    //                                                          gate, then RIP = 32-bit zero extended
    //                                                          displacement taken from gate; else RIP
    //                                                          = zero extended 16-bit offset from far
    //                                                          pointer referenced in the instruction.
    defn = new InsnDefn("call",   x86_farcall, 0x03, 0xff, od_e3, od_m16_16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-105");
    define(defn);
    //  FF /3                CALL m16:32 Valid       Valid      In 64-bit mode: If selector points to a
    //                                                          gate, then RIP = 64-bit displacement
    //                                                          taken from gate; else RIP = zero
    //                                                          extended 32-bit offset from far
    //                                                          pointer referenced in the instruction.
    defn = new InsnDefn("call",   x86_farcall, 0x03, 0xff, od_e3, od_m16_32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-105");
    define(defn);
    //  REX.W + FF /3        CALL m16:64 Valid       N.E.       In 64-bit mode: If selector points to a
    //                                                          gate, then RIP = 64-bit displacement
    //                                                          taken from gate; else RIP = 64-bit
    //                                                          offset from far pointer referenced in
    //                                                          the instruction.
    defn = new InsnDefn("call",   x86_farcall, 0x02, 0xff, od_rexw|od_e3, od_m16_64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-123");
    define(defn);

    //--- page 3-123 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  98             CBW             Valid        Valid              AX  sign-extend of AL.
    defn = new InsnDefn("cbw",    x86_cbw,     0x03, 0x98, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-123");
    define(defn);
    //  98             CWDE            Valid        Valid              EAX  sign-extend of AX.
    defn = new InsnDefn("cwde",   x86_cwde,    0x03, 0x98, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-123");
    define(defn);
    //  REX.W + 98     CDQE            Valid        N.E.               RAX  sign-extend of EAX.
    defn = new InsnDefn("cdqe",   x86_cdqe,    0x02, 0x98, od_rexw);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-124");
    define(defn);

    //--- page 3-124 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F8              CLC                Valid      Valid          Clear CF flag.
    defn = new InsnDefn("clc",    x86_clc,     0x03, 0xf8, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-125");
    define(defn);

    //--- page 3-125 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  FC               CLD                 Valid       Valid          Clear DF flag.
    defn = new InsnDefn("cld",    x86_cld,     0x03, 0xfc, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-126");
    define(defn);

    //--- page 3-126 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F AE /7        CLFLUSH m8       Valid       Valid               Flushes cache line
    //                                                                  containing m8.
    defn = new InsnDefn("clflush", x86_clflush, 0x03, 0x0fae, od_e7, od_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-128");
    define(defn);

    //--- page 3-128 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // FA              CLI                Valid          Valid         Clear interrupt flag; interrupts disabled
    //                                                                 when interrupt flag cleared.
    defn = new InsnDefn("cli",    x86_cli,     0x03, 0xfa, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-131");
    define(defn);

    //--- page 3-131 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 06           CLTS                  Valid       Valid             Clears TS flag in CR0.
    defn = new InsnDefn("clts",   x86_clts,    0x03, 0x0f06, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-133");
    define(defn);

    //--- page 3-133 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F5               CMC                     Valid       Valid         Complement CF flag.
    defn = new InsnDefn("cmc",    x86_cmc,     0x03, 0xf5, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);

    //--- page 3-134 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 47 /r           CMOVA r16, r/m16    Valid    Valid      Move if above (CF=0 and
    //                                                            ZF=0).
    defn = new InsnDefn("cmova",  x86_cmova,   0x03, 0x0f47, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // 0F 47 /r           CMOVA r32, r/m32    Valid    Valid      Move if above (CF=0 and
    //                                                            ZF=0).
    defn = new InsnDefn("cmova",  x86_cmova,   0x03, 0x0f47, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // REX.W + 0F 47 /r   CMOVA r64, r/m64    Valid    N.E.       Move if above (CF=0 and
    //                                                            ZF=0).
    defn = new InsnDefn("cmova",  x86_cmova,   0x02, 0x0f47, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // 0F 43 /r           CMOVAE r16, r/m16   Valid    Valid      Move if above or equal
    //                                                            (CF=0).
    defn = new InsnDefn("cmovae", x86_cmovae,  0x03, 0x0f43, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // 0F 43 /r           CMOVAE r32, r/m32   Valid    Valid      Move if above or equal
    //                                                            (CF=0).
    defn = new InsnDefn("cmovae", x86_cmovae,  0x03, 0x0f43, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // REX.W + 0F 43 /r   CMOVAE r64, r/m64   Valid    N.E.       Move if above or equal
    //                                                            (CF=0).
    defn = new InsnDefn("cmovae", x86_cmovae,  0x02, 0x0f43, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // 0F 42 /r           CMOVB r16, r/m16    Valid    Valid      Move if below (CF=1).
    defn = new InsnDefn("cmovb",  x86_cmovb,   0x03, 0x0f42, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // 0F 42 /r           CMOVB r32, r/m32    Valid    Valid      Move if below (CF=1).
    defn = new InsnDefn("cmovb",  x86_cmovb,   0x03, 0x0f42, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // REX.W + 0F 42 /r   CMOVB r64, r/m64    Valid    N.E.       Move if below (CF=1).
    defn = new InsnDefn("cmovb",  x86_cmovb,   0x02, 0x0f42, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // 0F 46 /r           CMOVBE r16, r/m16   Valid    Valid      Move if below or equal
    //                                                            (CF=1 or ZF=1).
    defn = new InsnDefn("cmovbe", x86_cmovbe,  0x03, 0x0f46, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // 0F 46 /r           CMOVBE r32, r/m32   Valid    Valid      Move if below or equal
    //                                                            (CF=1 or ZF=1).
    defn = new InsnDefn("cmovbe", x86_cmovbe,  0x03, 0x0f46, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // REX.W + 0F 46 /r   CMOVBE r64, r/m64   Valid    N.E.       Move if below or equal
    //                                                            (CF=1 or ZF=1).
    defn = new InsnDefn("cmovbe", x86_cmovbe,  0x02, 0x0f46, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // 0F 42 /r           CMOVC r16, r/m16    Valid    Valid      Move if carry (CF=1).
    defn = new InsnDefn("cmovb",  x86_cmovb,   0x03, 0x0f42, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // 0F 42 /r           CMOVC r32, r/m32    Valid    Valid      Move if carry (CF=1).
    defn = new InsnDefn("cmovb",  x86_cmovb,   0x03, 0x0f42, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // REX.W + 0F 42 /r   CMOVC r64, r/m64    Valid    N.E.       Move if carry (CF=1).
    defn = new InsnDefn("cmovb",  x86_cmovb,   0x02, 0x0f42, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // 0F 44 /r           CMOVE r16, r/m16    Valid    Valid      Move if equal (ZF=1).
    defn = new InsnDefn("cmove",  x86_cmove,   0x03, 0x0f44, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // 0F 44 /r           CMOVE r32, r/m32    Valid    Valid      Move if equal (ZF=1).
    defn = new InsnDefn("cmove",  x86_cmove,   0x03, 0x0f44, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // REX.W + 0F 44 /r   CMOVE r64, r/m64    Valid    N.E.       Move if equal (ZF=1).
    defn = new InsnDefn("cmove",  x86_cmove,   0x02, 0x0f44, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // 0F 4F /r           CMOVG r16, r/m16    Valid    Valid      Move if greater (ZF=0
    //                                                            and SF=OF).
    defn = new InsnDefn("cmovg",  x86_cmovg,   0x03, 0x0f4f, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // 0F 4F /r           CMOVG r32, r/m32    Valid    Valid      Move if greater (ZF=0
    //                                                            and SF=OF).
    defn = new InsnDefn("cmovg",  x86_cmovg,   0x03, 0x0f4f, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // REX.W + 0F 4F /r   CMOVG r64, r/m64    Valid    N.E.       Move if greater (ZF=0
    //                                                            and SF=OF).
    defn = new InsnDefn("cmovg",  x86_cmovg,   0x02, 0x0f4f, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-134");
    define(defn);
    // 0F 4D /r           CMOVGE r16, r/m16   Valid    Valid      Move if greater or equal
    //                                                            (SF=OF).
    defn = new InsnDefn("cmovge", x86_cmovge,  0x03, 0x0f4d, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  0F 4D /r            CMOVGE r32, r/m32    Valid    Valid           Move if greater or equal
    //                                                                    (SF=OF).
    defn = new InsnDefn("cmovge", x86_cmovge,  0x03, 0x0f4d, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  REX.W + 0F 4D /r    CMOVGE r64, r/m64    Valid    N.E.            Move if greater or equal
    //                                                                    (SF=OF).
    defn = new InsnDefn("cmovge", x86_cmovge,  0x02, 0x0f4d, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  0F 4C /r            CMOVL r16, r/m16     Valid    Valid           Move if less (SF OF).
    defn = new InsnDefn("cmovl",  x86_cmovl,   0x03, 0x0f4c, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  0F 4C /r            CMOVL r32, r/m32     Valid    Valid           Move if less (SF OF).
    defn = new InsnDefn("cmovl",  x86_cmovl,   0x03, 0x0f4c, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  REX.W + 0F 4C /r    CMOVL r64, r/m64     Valid    N.E.            Move if less (SF OF).
    defn = new InsnDefn("cmovl",  x86_cmovl,   0x02, 0x0f4c, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  0F 4E /r            CMOVLE r16, r/m16    Valid    Valid           Move if less or equal
    //                                                                    (ZF=1 or SF OF).
    defn = new InsnDefn("cmovle", x86_cmovle,  0x03, 0x0f4e, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  0F 4E /r            CMOVLE r32, r/m32    Valid    Valid           Move if less or equal
    //                                                                    (ZF=1 or SF OF).
    defn = new InsnDefn("cmovle", x86_cmovle,  0x03, 0x0f4e, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  REX.W + 0F 4E /r    CMOVLE r64, r/m64    Valid    N.E.            Move if less or equal
    //                                                                    (ZF=1 or SF OF).
    defn = new InsnDefn("cmovle", x86_cmovle,  0x02, 0x0f4e, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  0F 46 /r            CMOVNA r16, r/m16    Valid    Valid           Move if not above (CF=1
    //                                                                    or ZF=1).
    defn = new InsnDefn("cmovbe", x86_cmovbe,  0x03, 0x0f46, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  0F 46 /r            CMOVNA r32, r/m32    Valid    Valid           Move if not above (CF=1
    //                                                                    or ZF=1).
    defn = new InsnDefn("cmovbe", x86_cmovbe,  0x03, 0x0f46, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  REX.W + 0F 46 /r    CMOVNA r64, r/m64    Valid    N.E.            Move if not above (CF=1
    //                                                                    or ZF=1).
    defn = new InsnDefn("cmovbe", x86_cmovbe,  0x02, 0x0f46, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  0F 42 /r            CMOVNAE r16, r/m16   Valid    Valid           Move if not above or
    //                                                                    equal (CF=1).
    defn = new InsnDefn("cmovb",  x86_cmovb,   0x03, 0x0f42, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  0F 42 /r            CMOVNAE r32, r/m32   Valid    Valid           Move if not above or
    //                                                                    equal (CF=1).
    defn = new InsnDefn("cmovb",  x86_cmovb,   0x03, 0x0f42, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  REX.W + 0F 42 /r    CMOVNAE r64, r/m64   Valid    N.E.            Move if not above or
    //                                                                    equal (CF=1).
    defn = new InsnDefn("cmovb",  x86_cmovb,   0x02, 0x0f42, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  0F 43 /r            CMOVNB r16, r/m16    Valid    Valid           Move if not below
    //                                                                    (CF=0).
    defn = new InsnDefn("cmovae", x86_cmovae,  0x03, 0x0f43, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  0F 43 /r            CMOVNB r32, r/m32    Valid    Valid           Move if not below
    //                                                                    (CF=0).
    defn = new InsnDefn("cmovae", x86_cmovae,  0x03, 0x0f43, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  REX.W + 0F 43 /r    CMOVNB r64, r/m64    Valid    N.E.            Move if not below
    //                                                                    (CF=0).
    defn = new InsnDefn("cmovae", x86_cmovae,  0x02, 0x0f43, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  0F 47 /r            CMOVNBE r16, r/m16   Valid    Valid           Move if not below or
    //                                                                    equal (CF=0 and ZF=0).
    defn = new InsnDefn("cmova",  x86_cmova,   0x03, 0x0f47, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  0F 47 /r            CMOVNBE r32, r/m32   Valid    Valid           Move if not below or
    //                                                                    equal (CF=0 and ZF=0).
    defn = new InsnDefn("cmova",  x86_cmova,   0x03, 0x0f47, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-135");
    define(defn);
    //  REX.W + 0F 47 /r    CMOVNBE r64, r/m64   Valid    N.E.            Move if not below or
    //                                                                    equal (CF=0 and ZF=0).
    defn = new InsnDefn("cmova",  x86_cmova,   0x02, 0x0f47, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 43 /r           CMOVNC r16, r/m16    Valid    Valid      Move if not carry (CF=0).
    defn = new InsnDefn("cmovae", x86_cmovae,  0x03, 0x0f43, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 43 /r           CMOVNC r32, r/m32    Valid    Valid      Move if not carry (CF=0).
    defn = new InsnDefn("cmovae", x86_cmovae,  0x03, 0x0f43, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // REX.W + 0F 43 /r   CMOVNC r64, r/m64    Valid    N.E.       Move if not carry (CF=0).
    defn = new InsnDefn("cmovae", x86_cmovae,  0x02, 0x0f43, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 45 /r           CMOVNE r16, r/m16    Valid    Valid      Move if not equal (ZF=0).
    defn = new InsnDefn("cmovne", x86_cmovne,  0x03, 0x0f45, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 45 /r           CMOVNE r32, r/m32    Valid    Valid      Move if not equal (ZF=0).
    defn = new InsnDefn("cmovne", x86_cmovne,  0x03, 0x0f45, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // REX.W + 0F 45 /r   CMOVNE r64, r/m64    Valid    N.E.       Move if not equal (ZF=0).
    defn = new InsnDefn("cmovne", x86_cmovne,  0x02, 0x0f45, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 4E /r           CMOVNG r16, r/m16    Valid    Valid      Move if not greater
    //                                                             (ZF=1 or SF OF).
    defn = new InsnDefn("cmovle", x86_cmovle,  0x03, 0x0f4e, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 4E /r           CMOVNG r32, r/m32    Valid    Valid      Move if not greater
    //                                                             (ZF=1 or SF OF).
    defn = new InsnDefn("cmovle", x86_cmovle,  0x03, 0x0f4e, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // REX.W + 0F 4E /r   CMOVNG r64, r/m64    Valid    N.E.       Move if not greater
    //                                                             (ZF=1 or SF OF).
    defn = new InsnDefn("cmovle", x86_cmovle,  0x02, 0x0f4e, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 4C /r           CMOVNGE r16, r/m16   Valid    Valid      Move if not greater or
    //                                                             equal (SF OF).
    defn = new InsnDefn("cmovl",  x86_cmovl,   0x03, 0x0f4c, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 4C /r           CMOVNGE r32, r/m32   Valid    Valid      Move if not greater or
    //                                                             equal (SF OF).
    defn = new InsnDefn("cmovl",  x86_cmovl,   0x03, 0x0f4c, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // REX.W + 0F 4C /r   CMOVNGE r64, r/m64   Valid    N.E.       Move if not greater or
    //                                                             equal (SF OF).
    defn = new InsnDefn("cmovl",  x86_cmovl,   0x02, 0x0f4c, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 4D /r           CMOVNL r16, r/m16    Valid    Valid      Move if not less (SF=OF).
    defn = new InsnDefn("cmovge", x86_cmovge,  0x03, 0x0f4d, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 4D /r           CMOVNL r32, r/m32    Valid    Valid      Move if not less (SF=OF).
    defn = new InsnDefn("cmovge", x86_cmovge,  0x03, 0x0f4d, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // REX.W + 0F 4D /r   CMOVNL r64, r/m64    Valid    N.E.       Move if not less (SF=OF).
    defn = new InsnDefn("cmovge", x86_cmovge,  0x02, 0x0f4d, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 4F /r           CMOVNLE r16, r/m16   Valid    Valid      Move if not less or equal
    //                                                             (ZF=0 and SF=OF).
    defn = new InsnDefn("cmovg",  x86_cmovg,   0x03, 0x0f4f, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 4F /r           CMOVNLE r32, r/m32   Valid    Valid      Move if not less or equal
    //                                                             (ZF=0 and SF=OF).
    defn = new InsnDefn("cmovg",  x86_cmovg,   0x03, 0x0f4f, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // REX.W + 0F 4F /r   CMOVNLE r64, r/m64   Valid    N.E.       Move if not less or equal
    //                                                             (ZF=0 and SF=OF).
    defn = new InsnDefn("cmovg",  x86_cmovg,   0x02, 0x0f4f, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 41 /r           CMOVNO r16, r/m16    Valid    Valid      Move if not overflow
    //                                                             (OF=0).
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
