extern void *_pp_globalobject;
extern void *__ompc_lock_critical;
/*
*/
#if defined(USE_POW)
#define r23 pow(0.5, 23.0)
#define r46 (r23*r23)
#define t23 pow(2.0, 23.0)
#define t46 (t23*t23)
#else
#define r23 (0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5*0.5)
#define r46 (r23*r23)
#define t23 (2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0*2.0)
#define t46 (t23*t23)
#endif
/*c---------------------------------------------------------------------
c---------------------------------------------------------------------*/
#include "ompcLib.h" 

double randlc(double *x,double a)
{
/*c---------------------------------------------------------------------
c---------------------------------------------------------------------*/
/*c---------------------------------------------------------------------
c
c   This routine returns a uniform pseudorandom double precision number in the
c   range (0, 1) by using the linear congruential generator
c
c   x_{k+1} = a x_k  (mod 2^46)
c
c   where 0 < x_k < 2^46 and 0 < a < 2^46.  This scheme generates 2^44 numbers
c   before repeating.  The argument A is the same as 'a' in the above formula,
c   and X is the same as x_0.  A and X must be odd double precision integers
c   in the range (1, 2^46).  The returned value RANDLC is normalized to be
c   between 0 and 1, i.e. RANDLC = 2^(-46) * x_1.  X is updated to contain
c   the new seed x_1, so that subsequent calls to RANDLC using the same
c   arguments will generate a continuous sequence.
c
c   This routine should produce the same results on any computer with at least
c   48 mantissa bits in double precision floating point data.  On 64 bit
c   systems, double precision should be disabled.
c
c   David H. Bailey     October 26, 1990
c
c---------------------------------------------------------------------*/
  double t1;
  double t2;
  double t3;
  double t4;
  double a1;
  double a2;
  double x1;
  double x2;
  double z;
/*c---------------------------------------------------------------------
c   Break A into two parts such that A = 2^23 * A1 + A2.
c---------------------------------------------------------------------*/
  t1 = (((((((((((((((((((((((0.50000000000000000 * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * a);
  a1 = (((int )t1));
  a2 = (a - (((((((((((((((((((((((2.0000000000000000 * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * a1));
/*c---------------------------------------------------------------------
c   Break X into two parts such that X = 2^23 * X1 + X2, compute
c   Z = A1 * X2 + A2 * X1  (mod 2^23), and then
c   X = 2^23 * Z + A2 * X2  (mod 2^46).
c---------------------------------------------------------------------*/
  t1 = (((((((((((((((((((((((0.50000000000000000 * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) *  *x);
  x1 = (((int )t1));
  x2 = ( *x - (((((((((((((((((((((((2.0000000000000000 * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * x1));
  t1 = ((a1 * x2) + (a2 * x1));
  t2 = (((int )(((((((((((((((((((((((0.50000000000000000 * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * t1)));
  z = (t1 - (((((((((((((((((((((((2.0000000000000000 * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * t2));
  t3 = ((((((((((((((((((((((((2.0000000000000000 * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * z) + (a2 * x2));
  t4 = (((int )((((((((((((((((((((((((0.50000000000000000 * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * ((((((((((((((((((((((0.50000000000000000 * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000)
       * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000)) * t3)));
   *x = (t3 - ((((((((((((((((((((((((2.0000000000000000 * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * ((((((((((((((((((((((2.0000000000000000 * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 
      2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000)) * t4));
  return (((((((((((((((((((((((0.50000000000000000 * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * ((((((((((((((((((((((0.50000000000000000 * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 
      0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000)) *  *x;
}

/*c---------------------------------------------------------------------
c---------------------------------------------------------------------*/

void vranlc(int n,double *x_seed,double a,double *y)
{
/*c---------------------------------------------------------------------
c---------------------------------------------------------------------*/
/*c---------------------------------------------------------------------
c
c   This routine generates N uniform pseudorandom double precision numbers in
c   the range (0, 1) by using the linear congruential generator
c
c   x_{k+1} = a x_k  (mod 2^46)
c
c   where 0 < x_k < 2^46 and 0 < a < 2^46.  This scheme generates 2^44 numbers
c   before repeating.  The argument A is the same as 'a' in the above formula,
c   and X is the same as x_0.  A and X must be odd double precision integers
c   in the range (1, 2^46).  The N results are placed in Y and are normalized
c   to be between 0 and 1.  X is updated to contain the new seed, so that
c   subsequent calls to VRANLC using the same arguments will generate a
c   continuous sequence.  If N is zero, only initialization is performed, and
c   the variables X, A and Y are ignored.
c
c   This routine is the standard version designed for scalar or RISC systems.
c   However, it should produce the same results on any single processor
c   computer with at least 48 mantissa bits in double precision floating point
c   data.  On 64 bit systems, double precision should be disabled.
c
c---------------------------------------------------------------------*/
  int i;
  double x;
  double t1;
  double t2;
  double t3;
  double t4;
  double a1;
  double a2;
  double x1;
  double x2;
  double z;
/*c---------------------------------------------------------------------
c   Break A into two parts such that A = 2^23 * A1 + A2.
c---------------------------------------------------------------------*/
  t1 = (((((((((((((((((((((((0.50000000000000000 * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * a);
  a1 = (((int )t1));
  a2 = (a - (((((((((((((((((((((((2.0000000000000000 * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * a1));
  x =  *x_seed;
/*c---------------------------------------------------------------------
c   Generate N results.   This loop is not vectorizable.
c---------------------------------------------------------------------*/
  for (i = 1; i <= n; i++) {
/*c---------------------------------------------------------------------
c   Break X into two parts such that X = 2^23 * X1 + X2, compute
c   Z = A1 * X2 + A2 * X1  (mod 2^23), and then
c   X = 2^23 * Z + A2 * X2  (mod 2^46).
c---------------------------------------------------------------------*/
    t1 = (((((((((((((((((((((((0.50000000000000000 * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * x);
    x1 = (((int )t1));
    x2 = (x - (((((((((((((((((((((((2.0000000000000000 * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * x1));
    t1 = ((a1 * x2) + (a2 * x1));
    t2 = (((int )(((((((((((((((((((((((0.50000000000000000 * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * t1)));
    z = (t1 - (((((((((((((((((((((((2.0000000000000000 * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * t2));
    t3 = ((((((((((((((((((((((((2.0000000000000000 * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * z) + (a2 * x2));
    t4 = (((int )((((((((((((((((((((((((0.50000000000000000 * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * ((((((((((((((((((((((0.50000000000000000 * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 
        0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000)) * t3)));
    x = (t3 - ((((((((((((((((((((((((2.0000000000000000 * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * ((((((((((((((((((((((2.0000000000000000 * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 
        2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000) * 2.0000000000000000)) * t4));
    y[i] = ((((((((((((((((((((((((0.50000000000000000 * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * ((((((((((((((((((((((0.50000000000000000 * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 
        0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000) * 0.50000000000000000)) * x);
  }
   *x_seed = x;
}

