md=triangle(model,'../Exp/Pig.exp',20000);
md=setmask(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=extrude(md,2,1);
md=setflowequation(md,'stokes','all');
md.cluster=none;
md.timestepping.time_step=0;
md=solve(md,SteadystateSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure','Temperature','BasalforcingsMeltingRate'};
field_tolerances={1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-06
};
field_values={...
	(md.results.SteadystateSolution.Vx),...
	(md.results.SteadystateSolution.Vy),...
	(md.results.SteadystateSolution.Vz),...
	(md.results.SteadystateSolution.Vel),...
	(md.results.SteadystateSolution.Pressure),...
	(md.results.SteadystateSolution.Temperature),...
	(md.results.SteadystateSolution.BasalforcingsMeltingRate),...
	};
