md=triangle(model,'../Exp/Square.exp',180000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=extrude(md,3,1);
md=setflowequation(md,'macayeal','all');
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature1','BasalforcingsMeltingRate1','Temperature2','BasalforcingsMeltingRate2','Temperature3','BasalforcingsMeltingRate3'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	(md.results.ThermalSolution(1).Temperature),...
	(md.results.ThermalSolution(1).BasalforcingsMeltingRate),...
	(md.results.ThermalSolution(2).Temperature),...
	(md.results.ThermalSolution(2).BasalforcingsMeltingRate),...
	(md.results.ThermalSolution(3).Temperature),...
	(md.results.ThermalSolution(3).BasalforcingsMeltingRate),...
	};
