/*\file GetVectorFromInputs.c
 *\brief: recover velocity ug from inputs
 */

#include "./GetVectorFromInputs.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	int name_enum;
	int type_enum;
	Vec      ug=NULL;

	/* output datasets: elements and loads*/

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&GetVectorFromInputsUsage);
	
	/*Input datasets: */
	FetchMatlabData((DataSet**)&elements,ELEMENTSIN);
	FetchMatlabData((DataSet**)&nodes,NODES);
	FetchMatlabData((DataSet**)&vertices,VERTICES);
	FetchMatlabData((DataSet**)&loads,LOADSIN);
	FetchMatlabData((DataSet**)&materials,MATERIALS);
	FetchMatlabData(&parameters,PARAMETERS);
	FetchMatlabData(&name_enum,NAMEENUM);
	FetchMatlabData(&type_enum,TYPEENUM);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!core code:*/
	GetVectorFromInputsx(&ug,elements, nodes,vertices,loads, materials,parameters,name_enum,type_enum);

	/*write output datasets: */
	WriteMatlabData(UG,ug);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void GetVectorFromInputsUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [ug] = %s(elements,nodes,vertices,loads, materials,parameters,name_enum,type_enum);\n",__FUNCT__);
	_printf_(true,"\n");
}
