/*\file ConfigureObjects.c
 *\brief: configure objects (elements, loads for example), that need linking with nodes
 */

#include "./ConfigureObjects.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Loads* loads=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;

	/* output datasets: elements and loads*/

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ConfigureObjectsUsage);
	
	/*Input datasets: */
	FetchMatlabData((DataSet**)&elements,ELEMENTSIN);
	FetchMatlabData((DataSet**)&loads,LOADSIN);
	FetchMatlabData((DataSet**)&nodes,NODES);
	FetchMatlabData((DataSet**)&vertices,VERTICES);
	FetchMatlabData((DataSet**)&materials,MATERIALS);
	FetchMatlabData(&parameters,PARAMETERS);

	/*!Configure objects:*/
	ConfigureObjectsx(elements, loads, nodes, vertices,materials,parameters);

	/*write output datasets: */
	WriteMatlabData(ELEMENTS,elements);
	WriteMatlabData(LOADS,loads);
	WriteMatlabData(NODESOUT,nodes);
	WriteMatlabData(PARAMETERSOUT,parameters);

	/*Free ressources: */
	delete elements;
	delete loads;
	delete nodes;
	delete vertices;
	delete materials;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void ConfigureObjectsUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [elements,loads, nodes,parameters] = %s(elements,loads,nodes, materials,parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
