/*\file ComputeBasalStress.c
 *\brief: recover pressure from elements
 */

#include "./ComputeBasalStress.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL; 
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	int      numberofnodes;

	/* output datasets: */
	Vec sigma_g=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ComputeBasalStressUsage);
        
	/*Input datasets: */
	FetchMatlabData((DataSet**)&elements,ELEMENTS);
	FetchMatlabData((DataSet**)&nodes,NODES);
	FetchMatlabData((DataSet**)&vertices,VERTICES);
	FetchMatlabData((DataSet**)&loads,LOADS);
	FetchMatlabData((DataSet**)&materials,MATERIALS);
	FetchMatlabData(&parameters,PARAMETERS);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Generate internal degree of freedom numbers: */
	ComputeBasalStressx(&sigma_g, elements,nodes,vertices,loads,materials,parameters);

	/*write output datasets: */
	WriteMatlabData(SIGMA,sigma_g);

	/*Free ressources: */
	delete nodes;
	delete vertices;
	delete elements;
	delete materials;
	delete loads;
	delete parameters;
	VecFree(&sigma_g);

	/*end module: */
	MODULEEND();
}

void ComputeBasalStressUsage(void) {
	printf("\n");
	printf("   usage: [p_g] = %s(elements, nodes, vertices, loads, materials, params);\n",__FUNCT__);
	printf("\n");
}
