function  vals=findarg(arglist,field)
%FINDARG - find argument associated to a field in a list
%
%   This function parses through an argument list (typically varargin in a routine)
%   looking for a character array equal to field. Once this is found, we return the 
%   next value in the varargin (if possible). 
%   Because field might appear several times in the argument list, we return a structure 
%   holding all these values. 
%   Note that all comparisons to field value are case independent.
%
%   Usage:
%      vals=findarg(arglist,field)
%
%   Example:
%      routine foobar calls vals=findarg('Data',varargin)
%      with varargin='Data',1,'Data','foo','Plot','velocity','Arrow',4
%      findarg would return the following structure: vals(1).value=1, vals(2).value='foo'; 

%some argument checking: 
if ((nargin==0) | (nargout==0)),
	help findarg;
	error('findarg error message');
end

if ~ischar(field),
	error('findarg error message: field should be a string');
end

if ~iscell(arglist),
	error('findarg error message: argument list should be a cell array.');
end

%Recover data to plot
founddata=0;

for i=1:(length(arglist)-1), %data in arglist comes in pairs, hence the -1.
	if ischar(arglist{i}),
		if (strcmpi(arglist{i},field)),
			founddata=founddata+1;
			if founddata==1,
				vals.value=arglist{i+1};
			else
				vals(end+1).value=arglist{i+1};
			end
		end
	end
end

if founddata==0,
	vals=[];
end
