function effective_value=effective_value(A)
%EFFECTIVE_VALUE - compute the effective value of any matrix
%
%   effective(A)= 1/sqrt(2)*sqrt(sum(Aij^2))
%
%   Usage:
%      effective_value=effective_value(A)

[row,col]=size(A);

SUM=0;
for i=1:row
    for j=1:col
        SUM=SUM+A(i,j)^2;
    end
end

effective_value=1/sqrt(2)*sqrt(SUM);
