function femmodel=solver_linear(femmodel)
%SOLVER_LINEAR - core solver of any linear solution sequence
%
%   Usage:
%      femmodel =solver_linear(femmodel)

	%Get parameters
	configuration_type=femmodel.parameters.ConfigurationType;
	[femmodel.nodes]=UpdateConstraints(femmodel.nodes,femmodel.constraints,femmodel.parameters);

	[K_ff,K_fs,p_f,df,kmax]=SystemMatrices(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);
	ys  =CreateNodalConstraints(femmodel.nodes,configuration_type);
	p_f =Reduceload( p_f, K_fs, ys);

	issmprintf(VerboseSolver(),'%s%g','      condition number of stiffness matrix: ',condest(K_ff));
	u_f=Solver(K_ff,p_f,[],df,femmodel.parameters);
	u_g= Mergesolutionfromftog( u_f, ys, femmodel.nodes,femmodel.parameters); 
	[femmodel.elements,femmodel.materials]=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,u_g);
