function options=soroptions(varargin)
%SOROPTIONS - return Relaxation Solver petsc options
%
%   Usage:
%      options=soroptions;
			 
%retrieve options provided in varargin
arguments=pairoptions(varargin{:});

%default sor options
options={{'mat_type','aij'},{'ksp_type','cg'},{'pc_type','sor'},{'pc_sor_omega',1.1},{'pc_sor_its',2}};

%now, go through our arguments, and write over default options.
for i=1:size(arguments.list,1),
	arg1=arguments.list{i,1};
	arg2=arguments.list{i,2};
	found=0;
	for j=1:size(options,2),
		joption=options{j};
		if strcmpi(joption{1},arg1),
			joption{2}=arg2;
			options{j}=joption;
			found=1;
			break;
		end
	end
	if ~found,
		%this option did not exist, add it: 
		options{end+1}={arg1,arg2};
	end
end
