function options=matlaboptions(varargin)
%MATLABOPTIONS - return Matlab petsc options
%
%   Usage:
%      options=matlaboptions;
			 
%retrieve options provided in varargin
arguments=pairoptions(varargin{:});

%default matlab options
options={{'ksp_type','matlab'}};

%now, go through our arguments, and write over default options.
for i=1:size(arguments.list,1),
	arg1=arguments.list{i,1};
	arg2=arguments.list{i,2};
	found=0;
	for j=1:size(options,2),
		joption=options{j};
		if strcmpi(joption{1},arg1),
			joption{2}=arg2;
			options{j}=joption;
			found=1;
			break;
		end
	end
	if ~found,
		%this option did not exist, add it: 
		options{end+1}={arg1,arg2};
	end
end
