function md=solve(md,solutionenum,varargin)
%SOLVE - apply solution sequence for this model
%
%   Usage:
%      md=solve(md,solutionenum,varargin)
%      where varargin is a lit of paired arguments of string OR enums
%
%   solution types available comprise:
%		 - DiagnosticSolutionEnum
%		 - PrognosticSolutionEnum
%		 - ThermalSolutionEnum
%		 - SteadystateSolutionEnum
%		 - TransientSolutionEnum...
%		 - BalancethicknessSolutionEnum
%		 - BedSlopeSolutionEnum
%		 - SurfaceSlopeSolutionEnum
%		 - HydrologySolutionEnum
%		 - FlaimSolutionEnum
%
%  extra options:
%      - loadonly : does not solve. only load results
%
%   Examples:
%      md=solve(md,DiagnosticSolutionEnum);

%recover options
options=pairoptions(varargin{:},'solution_type',solutionenum);

%add default options
options=process_solve_options(options);

%recover some fields
md.private.solution=options.solution_type;

%check model consistency
disp('checking model consistency');
if (solutionenum == FlaimSolutionEnum)
	modelconsistency(true);
	md.mesh.checkconsistency(md,solutionenum);
	md.flaim.checkconsistency(md,solutionenum);
	if ~modelconsistency()
		error(' ');
	end
else
	ismodelselfconsistent(md),
end

%if running qmu analysis, some preprocessing of dakota files using 
%models fields needs to be carried out. 
if md.qmu.isdakota,
	md=preqmu(md,options);
end

%Save model as is (in case of a crash)
assignin('base',inputname(1),md);

%flaim analysis
if (md.private.solution == FlaimSolutionEnum)
	md=flaim_sol(md,options);
	md.private.solution=EnumToString(options.solution_type);
	return;
end

%Marshall model data into a binary file.
marshall(md);

%write a template file for issm to use, in parallel
PetscFile(md.solver,[md.miscellaneous.name '.petsc']);

%If running in parallel, we have a different way of launching the solution
%sequences. 
if ~strcmpi(md.cluster.name,'none'),
	md=solveparallel(md,options);
	return;
end

%Launch correct solution sequence
md=issm(md,md.private.solution);

%post processes qmu results if necessary
if md.qmu.isdakota,
	md=postqmu(md);
	cd ..
	if ~strncmpi(options.keep,'y',1)
		system(['rm -rf qmu' num2str(feature('GetPid'))]);
	end
end

%convert analysis type to string finally
md.private.solution=EnumToString(options.solution_type);
