function md=parametercontroloptimization(md,varargin),
%PARAMETERCONTROLOPTIMIZATION - parameterization for control method on drag
%
%   It is possible to specify the number of steps, values for the
%   minimum and maximum values of the drag, specify the 
%   kind of fit to use or the the optscal.
%   
%   Usage:
%       md=parametercontroloptimization(md,varargin)
%
%   Example:
%      md=parametercontroloptimization(md,'nsteps',6)

%process options
options=pairoptions(varargin{:});

%Copy model
md2=md;

%Hard coded parameters
%variable
cmax_max=1000;
cm_maxs=linspace(cmax_max/10,cmax_max,3);
optscal_max=1000;
optscals=linspace(optscal_max/10,optscal_max,3);
fits=[0 2];
%Kept constant
md2.verbose=0;
md2.cm_min=1;
md2.eps_cm=NaN;
md2.nsteps=getfieldvalue(options,'nsteps',5);
md2.inversion.control_parameters=getfieldvalue(options,'md2.inversion.control_parameters',{'FrictionCoefficient'});
md2.maxiter=10*ones(md2.nsteps,1);
md2.cm_jump=0.99*ones(md2.nsteps,1);
md2.inversion.iscontrol=1;
md2.weights=ones(md2.numberofnodes,1);

%loop over the set of parameters
best=0;
count=1;
for fit=fits,
	md2.fit=fit*ones(md2.nsteps,1);
	for cm_max=cm_maxs;
		md2.cm_max=cm_max;
		for optscal=optscals;
			md2.optscal=optscal*ones(md2.nsteps,1);

			%current run
			disp(sprintf('\n   Step %i/%i, fit=%i, cm_max=%g, optscal=%g\n',count,length(cm_maxs)*length(optscals)*length(fits),fit,cm_max,optscal))
			md2=solve(md2,'analysis_type','DiagnosticAnalysis');
			count=count+1;

			%Check misfit difference
			rel=(md2.results.DiagnosticAnalysis.J(1)-md2.results.DiagnosticAnalysis.J(end))/md2.results.DiagnosticAnalysis.J(1);
			disp(['   ΔJ/J=' num2str(rel*100) '% for fit=' num2str(fit) ',cm_max=' num2str(cm_max) ', and optscal=' num2str(optscal) ]);
			if (rel>best),
				disp(sprintf('   --> current best'))
				fit_final    =md2.fit;
				cmmax_final  =md2.cm_max;
				optscal_final=md2.optscal;
				best=rel;
			end
		end
	end
end

%load final parameters onto initial model
md.fit    =fit_final;
md.inversion.max_parameters =cmmax_final;
md.inversion.gradient_scaling=optscal_final;
