%POLLUX class definition
%
%   Usage:
%      cluster=pollux();
%      cluster=pollux('np',3);
%      cluster=pollux('np',3,'login','username');

classdef pollux
    properties (SetAccess=public) 
		 % {{{1
		 name='pollux'
		 login='larour';
		 np=128;
		 port=0;
		 queue='shortp';
		 time=180;
		 codepath='/workc/edw/larour/issm-2.0/bin'
		 executionpath='/workc/edw/larour/Testing/Execution'
		 %}}}
	 end
	 methods
		 function cluster=pollux(varargin) % {{{1
			 options=pairoptions(varargin{:});
			 for i=1:size(options.list,1),
				 fieldname=options.list{i,1};
				 fieldvalue=options.list{i,2};
				 if ismember(fieldname,properties('pollux')),
					 cluster.(fieldname)=fieldvalue;
				 else
					 disp(['''' fieldname ''' is not a property of cluster pollux']);
				 end
			 end
		 end
		 %}}}
		 function disp(cluster) % {{{1
			 %  display the object
			 disp(sprintf('class ''%s'' object ''%s'' = ',class(cluster),inputname(1)));
			 disp(sprintf('    name: %s',cluster.name));
			 disp(sprintf('    login: %s',cluster.login));
			 disp(sprintf('    port: %i',cluster.port));
			 disp(sprintf('    np: %i',cluster.np));
			 disp(sprintf('    queue: %s',cluster.queue));
			 disp(sprintf('    time: %i',cluster.time));
			 disp(sprintf('    codepath: %s',cluster.codepath));
			 disp(sprintf('    executionpath: %s',cluster.executionpath));
		 end
		 %}}}
		 function checkconsistency(cluster,md,solution,analyses) % {{{1

			 available_queues={'shortp','longp'};
			 queue_requirements_time=[180 720];
			 queue_requirements_np=[128 128];

			 QueueRequirements(available_queues,queue_requirements_time,queue_requirements_np,cluster.queue,cluster.np,cluster.time)
		 end
		 %}}}
		 function BuildQueueScript(cluster,md) % {{{1

			 %retrieve parameters 
			 modelname=md.miscellaneous.name; 
			 solution=md.private.solution;

			 %open file for writing: 
			 fid=fopen([modelname '.queue'],'w');

			 fprintf(fid,'#!/bin/sh\n');
			 fprintf(fid,'#PBS -l walltime=%i\n',cluster.time*60); %walltime is in seconds.
			 fprintf(fid,'#PBS -N %s\n',modelname);
			 fprintf(fid,'#PBS -l ncpus=%i\n',cluster.np);
			 if ~isempty(queue),
				 fprintf(fid,'#PBS -q %s\n',cluster.queue);
			 end
			 fprintf(fid,'#PBS -o %s.outlog \n',modelname);
			 fprintf(fid,'#PBS -e %s.errlog \n',modelname);

			 fprintf(fid,'export PBS_O_WORKDIR=%s\n',cluster.executionpath);
			 fprintf(fid,'cd $PBS_O_WORKDIR\n');
			 fprintf(fid,'export OMP_NUM_THREADS=1\n');
			 fprintf(fid,'dplace -s1 -c0-%i mpiexec -np %i %s/issm.exe %s %s %s',cluster.np-1,cluster.np,cluster.codepath,EnumToString(solution),cluster.executionpath,modelname);

			 %close file
			 fclose(fid);

		 end
		 %}}}
		 function LaunchQueueJob(cluster,md,options)% {{{1
			 
			 %lauch command, to be executed via ssh
			 launchcommand=['cd ' cluster.executionpath ' && rm -rf ./' md.private.runtimename ' && mkdir ' md.private.runtimename ...
			                ' && cd ' md.private.runtimename ' && mv ../' md.private.runtimename '.tar.gz ./ && tar -zxf ' md.private.runtimename '.tar.gz  && qsub ' modelname '.queue '];

			if ~strcmpi(options.batch,'yes'),
				
				%compress the files into one zip.
				compressstring=['tar -zcf ' md.private.runtimename '.tar.gz ' md.miscellaneous.name '.bin ' md.miscellaneous.name '.queue '  md.miscellaneous.name '.petsc '];
				if md.qmu.isdakota,
					compressstring=[compressstring md.miscellaneous.name '.qmu.in'];
				end
				system(compressstring);
				
				disp('uploading input file and queueing script');
				issmscpout(md.cluster.name,md.cluster.executionpath,md.cluster.login,md.cluster.port,{[md.private.runtimename '.tar.gz']});
				
				disp('launching solution sequence on remote cluster');
				issmssh(md.cluster.name,md.cluster.login,md.cluster.port,launchcommand);

			else
				disp('batch mode requested: not launching job interactively');
				disp('launch solution sequence on remote cluster by hand');
			end

		 end
		 %}}}
		 function Download(cluster,md)% {{{1

			%some check
			if isempty(md.private.runtimename),
				error('pfe Download error message: supply runtime name for results to be loaded!');
			end

			%Figure out the  directory where all the files are in: 
			directory=[cluster.executionpath '/' md.private.runtimename '/'];

			%What packages are we picking up from remote cluster
			packages={[md.miscellaneous.name '.outlog'],[md.miscellaneous.name '.errlog']};
			if md.qmu.isdakota,
				packages{end+1}=[md.miscellaneous.name '.qmu.err'];
				packages{end+1}=[md.miscellaneous.name '.qmu.out'];
				if isfield(md.qmu.params,'tabular_graphics_data'),
					if md.qmu.params.tabular_graphics_data==true,
						packages{end+1}='dakota_tabular.dat'; 
					end
				end
			else
				packages{end+1}=[md.miscellaneous.name '.outbin'];
			end

			%copy files from cluster to present directory
			issmscpin(cluster.name, cluster.login, cluster.port, directory, packages);
		end %}}}
	end
end
