/* \file PetscVectorToMatlabVector.cpp
 * \brief: convert a sparse or dense Petsc vector into a matlab vector
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif


#ifdef _SERIAL_

/*Petsc includes: */
#include "petscmat.h"
#include "petscvec.h"
#include "petscksp.h"

/*Petsc includes: */
#include "mex.h"

#include "../../../shared/shared.h"
#include <string>


int PetscVectorToMatlabVector(mxArray** pdataref,Vec vector){


	int i;
	int rows;
	int* idxm=NULL;
	double* values=NULL;

	/*output: */
	mxArray* dataref=NULL;

	/*Get size of vector: */
	VecGetSize(vector,&rows);

	if(rows){
		idxm=(int*)xmalloc(rows*sizeof(int));
		values=(double*)xmalloc(rows*sizeof(double));
		for(i=0;i<rows;i++)idxm[i]=i;
		 
		VecGetValues(vector,rows,idxm,values);
	}

	/*Using values, build a matlab vector: */
	dataref = mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(dataref,rows);
	mxSetN(dataref,1);
	mxSetPr(dataref,(double*)values);	

	/*Some logic here to make the vector sparse? Although this could slow down the code quite a bit: */

	/*Assign output pointers: */
	*pdataref=dataref;

	return 1;
}


#endif  //#ifdef _SERIAL_

