/*!\file: solver_adjoint_linear.cpp
 * \brief: numerical core of linear solutions
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules/modules.h"

void solver_adjoint_linear(FemModel* femmodel){
	/*This is axactly the same solver as solver_linear except that Reduceloadfromgtofx and Mergesolutionfromftogx
	 * use the flag "true" so that all spc are taken as 0*/

	/*intermediary: */
	Mat  Kff = NULL, Kfs = NULL;
	Vec  ug  = NULL, uf  = NULL;
	Vec  pf  = NULL;
	Vec  df  = NULL;
	Vec  ys  = NULL;
	int  configuration_type;

	/*Recover parameters: */
	femmodel->parameters->FindParam(&configuration_type,ConfigurationTypeEnum);
	UpdateConstraintsx(femmodel->nodes,femmodel->constraints,femmodel->parameters);

	SystemMatricesx(&Kff, &Kfs, &pf, &df, NULL,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
	CreateNodalConstraintsx(&ys,femmodel->nodes,configuration_type);
	Reduceloadx(pf, Kfs, ys,true); MatFree(&Kfs); //true means spc = 0
	Solverx(&uf, Kff, pf, NULL, df, femmodel->parameters); MatFree(&Kff); VecFree(&pf); VecFree(&df);
	Mergesolutionfromftogx(&ug, uf,ys,femmodel->nodes,femmodel->parameters,true); VecFree(&uf);VecFree(&ys); //true means spc0
	InputUpdateFromSolutionx(femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,ug);
	VecFree(&ug); VecFree(&uf); 
}
