/*!\file: matrix.h
 * \brief prototypes for matrix.h
 */ 

#ifndef _MATRIXUTILS_H_
#define _MATRIXUTILS_H_

int  TripleMultiply( double* a, int nrowa, int ncola, int itrna, double* b, int nrowb, int ncolb, int itrnb, double* c, int nrowc, int ncolc, int itrnc, double* d, int iaddd);
int  MatrixMultiply( double* a, int nrowa, int ncola, int itrna, double* b, int nrowb, int ncolb, int itrnb, double* c, int iaddc );
int  MatrixInverse( double* a, int ndim, int nrow, double* b, int nvec, double* pdet );
void Matrix2x2Invert(double* Ainv, double* A);
void Matrix2x2Determinant(double* Adet,double* A);
void Matrix3x3Invert(double* Ainv, double* A);
void Matrix3x3Determinant(double* Adet,double* A);
void MatrixTranspose(double* tA,double* A,int nrows, int ncols);

#endif //ifndef _MATRIXUTILS_H_
