/*! \file Option.h 
 *  \brief: header file for option abstract object
 */

#ifndef _OPTIONOBJECT_H_
#define _OPTIONOBJECT_H_

/*Headers:{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "../Object.h"
/*}}}*/

class Option: public Object {

	public:

		char* name;
		int   numel;
		int   ndims;
		int*  size;

		/*Option constructors, destructors {{{1*/
		Option();
		~Option();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		virtual void  Echo();
		virtual void  DeepEcho();
		virtual void  DeepEcho(char* indent);
		int   Id(){_error_("Not implemented yet");};
		int   MyRank(){_error_("Not implemented yet");};
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset){_error_("Not implemented yet");};
		int   MarshallSize(){_error_("Not implemented yet");};
		void  Demarshall(char** pmarshalled_dataset){_error_("Not implemented yet");};
		#endif
		int   ObjectEnum(){return OptionEnum;};
		Object* copy(){_error_("Not implemented yet");};
		/*}}}*/

		/*virtual functions: */
		virtual char* Name()=0;
		virtual int   NumEl()=0;
		virtual int   NDims()=0;
		virtual int*  Size()=0;
		virtual void  Get(double* pvalue)=0;
		virtual void  Get(bool* pvalue)=0;
		virtual void  Get(char** pvalue)=0;
		virtual void  Get(char*** ppvalue,int *pnumel)=0;
		virtual void  Get(double** pvalue,int *pnumel)=0;
		virtual void  Get(Options** pvalue)=0;
		virtual void  Get(Options*** ppvalue,int *pnumel)=0;

};
#endif  /* _OPTIONOBJECT_H */

