/*!\file KML_Unknown.cpp
 * \brief: implementation of the kml_unknown object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Unknown::KML_Unknown(){{{1*/
KML_Unknown::KML_Unknown(){

	name      =NULL;
	value     =NULL;

}
/*}}}*/
/*FUNCTION KML_Unknown::~KML_Unknown(){{{1*/
KML_Unknown::~KML_Unknown(){

	if (name      ) xfree((void**)&name);
	if (value     ) xfree((void**)&value);

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Unknown::Echo {{{1*/
void  KML_Unknown::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_Unknown_%s:\n",name);
	KML_Object::Echo();

	if (value     )
		_printf_(flag,"         value: \"%s\"\n"     ,value);

	return;
}
/*}}}*/
/*FUNCTION KML_Unknown::DeepEcho {{{1*/
void  KML_Unknown::DeepEcho(){

	char  indent[81]="";

	KML_Unknown::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION KML_Unknown::DeepEcho {{{1*/
void  KML_Unknown::DeepEcho(const char* indent){

	bool  flag=true;

	_printf_(flag,"%sKML_Unknown_%s:\n",indent,name);
	KML_Object::DeepEcho(indent);

	if (value     )
		_printf_(flag,"%s         value: \"%s\"\n"     ,indent,value);

	return;
}
/*}}}*/
/*FUNCTION KML_Unknown::Write {{{1*/
void  KML_Unknown::Write(FILE* filout,const char* indent){

	fprintf(filout,"%s<%s",indent,name);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");
	WriteCommnt(filout,indent);

	KML_Object::Write(filout,indent);

	if (value     )
		fprintf(filout,"%s  %s\n",indent,value);

	fprintf(filout,"%s</%s>\n",indent,name);

	return;
}
/*}}}*/
/*FUNCTION KML_Unknown::Read {{{1*/
void  KML_Unknown::Read(FILE* fid,char* kstr){

	char*        kstri;
	int          ncom=0;
	char**       pcom=NULL;

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid,
							  &ncom,&pcom)) {
		if      (!strncmp(&kstri[0],"</", 2) &&
				 !strncmp(&kstri[2],name,strlen(name))) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_Unknown::Read -- Unexpected closing tag %s.\n",kstri);

		else if (strncmp(kstri,"<",1))
			KMLFileTokenParse( value     ,NULL,0,
							  NULL,
							  fid);

		else if (!strncmp(kstri,"<",1))
			KML_Object::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	this->AddCommnt(ncom,pcom);

	for (ncom; ncom>0; ncom--)
		xfree((void**)&(pcom[ncom-1]));
	xfree((void**)&pcom);

	return;
}
/*}}}*/
