/*! \file KML_Overlay.h 
 *  \brief: header file for kml_overlay abstract object
 */

#ifndef _KML_OVERLAY_H_
#define _KML_OVERLAY_H_

#define KML_OVERLAY_COLOR_LENGTH  8

/*Headers:*/
/*{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./KML_Feature.h"
class KML_Icon;
/*}}}*/

class KML_Overlay: public KML_Feature {

	public:

		char  color[KML_OVERLAY_COLOR_LENGTH+1];
		int   draword;
		KML_Icon* icon;

		/*KML_Overlay constructors, destructors {{{1*/
		KML_Overlay();
		~KML_Overlay();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(const char* indent);
		void  Write(FILE* fid,const char* indent);
		void  Read(FILE* fid,char* kstr);
		int   Id(){_error_("Not implemented yet.");};
		int   MyRank(){_error_("Not implemented yet.");};
		void  Marshall(char** pmarshalled_dataset){_error_("Not implemented yet.");};
		int   MarshallSize(){_error_("Not implemented yet.");};
		void  Demarshall(char** pmarshalled_dataset){_error_("Not implemented yet.");};
		int   ObjectEnum(){_error_("Not implemented yet.");};
		Object* copy(){_error_("Not implemented yet.");};
		/*}}}*/

};
#endif  /* _KML_OVERLAY_H */

