/*! \file KML_Object.h 
 *  \brief: header file for kml_object abstract object
 */

#ifndef _KML_OBJECT_H_
#define _KML_OBJECT_H_

/*Headers:{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "../Object.h"
class DataSet;
/*}}}*/

class KML_Object: public Object {

	public:

		DataSet* attrib;
		DataSet* commnt;

		/*KML_Object constructors, destructors {{{1*/
		KML_Object();
		~KML_Object();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		virtual void  Echo();
		virtual void  DeepEcho();
		virtual void  DeepEcho(const char* indent);
		int   Id(){_error_("Not implemented yet.");};
		int   MyRank(){_error_("Not implemented yet.");};
		void  Marshall(char** pmarshalled_dataset){_error_("Not implemented yet.");};
		int   MarshallSize(){_error_("Not implemented yet.");};
		void  Demarshall(char** pmarshalled_dataset){_error_("Not implemented yet.");};
		int   ObjectEnum(){_error_("Not implemented yet.");};
		Object* copy(){_error_("Not implemented yet.");};
		/*}}}*/

		/*virtual functions: */
		virtual void  Write(FILE* fid,const char* indent)=0;
		virtual void  Read(FILE* fid,char* kstr)=0;
		virtual void  WriteExp(FILE* fid,const char* nstr,int sgn,double cm,double sp);
		virtual void  AddAttrib(const char* name,const char* value);
		virtual void  FindAttrib(char** pvalue,char* name,char* deflt);
		virtual void  WriteAttrib(FILE* fid,const char* indent);
		virtual void  AddCommnt(int ncom,char** pcom);
		virtual void  AddCommnt(char* value);
		virtual void  FindCommnt(char** pvalue,int inum);
		virtual void  WriteCommnt(FILE* fid,const char* indent);

};
#endif  /* _KML_OBJECT_H */

