/*!\file GaussPenta.h
 * \brief: header file for node object
 */

#ifndef _GAUSSPENTA_H_
#define _GAUSSPENTA_H_

/*Headers:*/
/*{{{1*/
#include "./../../shared/shared.h"
class GaussTria;
/*}}}*/

class GaussPenta{

	private:
		int numgauss;
		double* weights;
		double* coords1;
		double* coords2;
		double* coords3;
		double* coords4;

	public:
		double weight;
		double coord1;
		double coord2;
		double coord3;
		double coord4;
		
	public:

		/*GaussPenta constructors, destructors*/
		GaussPenta();
		GaussPenta(int order_horiz,int order_vert);
		GaussPenta(int index1, int index2,int order);
		GaussPenta(int index1, int index2, int index3, int order);
		GaussPenta(int index1, int index2, int index3, int index4,int order_horiz,int order_vert);
		~GaussPenta();

		/*Methods*/
		int  begin(void);
		int  end(void);
		void Echo(void);
		void GaussPoint(int ig);
		void GaussVertex(int iv);
		void GaussFaceTria(int index1, int index2, int index3, int order);
		void GaussCenter(void);
		void SynchronizeGaussTria(GaussTria* gauss_tria);
};
#endif
