/*!\file TriaHook.c
 * \brief: implementation of the TriaHook object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION TriaHook::TriaHook(){{{1*/
TriaHook::TriaHook(){
	numanalyses=UNDEF;
	this->hnodes=NULL;
	this->hmatice=NULL;
	this->hmatpar=NULL;
}
/*}}}*/
/*FUNCTION TriaHook::~TriaHook(){{{1*/
TriaHook::~TriaHook(){
	int i;

	for(i=0;i<this->numanalyses;i++){
		if (this->hnodes[i]) delete this->hnodes[i];
	}
	delete [] this->hnodes;
	delete hmatice;
	delete hmatpar;

}
/*}}}*/
/*FUNCTION TriaHook::TriaHook(int in_numanalyses,int matice_id, int matpar_id){{{1*/
TriaHook::TriaHook(int in_numanalyses,int matice_id, IoModel* iomodel){

	/*intermediary: */
	int matpar_id;

	/*retrieve parameters: */
	iomodel->Constant(&matpar_id,MeshNumberofelementsEnum); matpar_id++;
	
	this->numanalyses=in_numanalyses;
	this->hnodes= new Hook*[in_numanalyses];
	this->hmatice=new Hook(&matice_id,1);
	this->hmatpar=new Hook(&matpar_id,1);

	//Initialize hnodes as NULL
	for(int i=0;i<this->numanalyses;i++){
		this->hnodes[i]=NULL;
	}

}
/*}}}*/

/*FUNCTION TriaHook::SetHookNodes{{{1*/
void TriaHook::SetHookNodes(int* node_ids,int analysis_counter){

	/*initialize hook*/
	this->hnodes[analysis_counter]=new Hook(node_ids,3);
}
/*}}}*/
