/*!\file Orthx
 * \brief orthogonalize searching directions for inverse control methods
 */

#include "./Orthx.h"

void	Orthx( Vec* pnewgradj, Vec gradj, Vec oldgradj){
	
	/*output: */
	Vec newgradj=NULL;

	/*intermediary:*/
	double norm_new,norm_old,dot_product;;

	/*Initialize output*/
	VecDuplicate(gradj,&newgradj);
	VecCopy(gradj,newgradj);

	/*rough orthagonalization
	gradient=gradient-(gradient'*oldgradient)*oldgradient /norm(oldgradient)^2; */
	if(oldgradj){
		VecNorm(oldgradj,NORM_2,&norm_old);
		_assert_(norm_old!=0); 
		VecDot(newgradj,oldgradj,&dot_product);
		_assert_(dot_product!=NAN); 
		VecAXPY(newgradj, -dot_product/pow(norm_old,2), oldgradj);
	}

	/*Assign correct pointer*/
	*pnewgradj=newgradj;
}
