/*!\file InputControlUpdatex
 * \brief: Y=Y+aX operation on inputs.
 */

#include "./InputControlUpdatex.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputControlUpdatex(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters,double scalar,bool save_parameter){

	/*Go through elemnets, and ask to carry out the operation on inputs: */
	for(int i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->InputControlUpdate(scalar,save_parameter);
	}
}
