#!/bin/bash
#get number of lines of code
cloc-1.55.pl $ISSM_TIER/src $ISSM_TIER/m4 --exclude-dir=.svn --exclude-ext=exp --exclude-lang=make --out=temp
cat temp
./cloc2html.py
rm temp

cat $ISSM_TIER/src/dox/issm.dox | sed '/<table/,//d' > input1
cat $ISSM_TIER/src/dox/issm.dox | sed '1,/<\/table>/d' > input2
cat input1 temp.html input2 > $ISSM_TIER/src/dox/issm.dox
rm input1 input2 temp.html

exit 1





#OLDER MANUAL VESION
#get Matlab number of lines
cd $ISSM_TIER/src/m
M_LOC=$(find . -name "*.m" -exec wc -l '{}' \; | awk '{ sum += $1 } END { print sum}');
echo "Matlab code: $M_LOC"

#get C/CPP number of lines
cd $ISSM_TIER/src
CPP_LOC=$(find . -name "*.cpp" -exec wc -l '{}' \; | awk '{ sum += $1 } END { print sum}');
echo "C++    code: $CPP_LOC"
C_LOC=$(find . -name "*.c" -exec wc -l '{}' \; | awk '{ sum += $1 } END { print sum}');
echo "C      code: $C_LOC"
H_LOC=$(find . -name "*.h" -exec wc -l '{}' \; | awk '{ sum += $1 } END { print sum}');
echo "header code: $H_LOC"

#print total
let SUM=$M_LOC+$CPP_LOC+$C_LOC+$H_LOC
echo "Total      : $SUM"
