#!/bin/bash

#Some cleanup
rm -rf src install mpich2-1.4
mkdir src install

#Untar 
tar -zxvf  mpich2-1.4.tar.gz

#Move mpich2 into src directory
mv mpich2-1.4/* src
rm -rf mpich2-1.4

#Configure mpich2
cd src
export CFLAGS="$CFLAGS -fPIC"
export FFLAGS="$FFLAGS -fPIC"
./configure \
	--prefix="$ISSM_TIER/externalpackages/mpich2/install" \
	--enable-shared \
	--enable-sharedlibs=gcc \
	--enable-f91=gfortran 

#Compile mpich2
if [ -z $1 ]; then
	make
else
	make -j $1
fi
make install 

#remove so files
cd ../install/lib
rm -rf *.so
