md=triangle(model,'../Exp/Square.exp',150000);
md=setmask(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md=extrude(md,4,1);
md=setflowequation(md,'pattyn','all');
md.cluster=none;
md.timestepping.time_step=0;
md=solve(md,ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature','BasalforcingsMeltingRate'};
field_tolerances={1e-13,1e-13};
field_values={...
	(md.results.ThermalSolution.Temperature),...
	(md.results.ThermalSolution.BasalforcingsMeltingRate),...
	};
