md=triangle(model,'../Exp/Square.exp',180000);
md=setmask(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');
md=extrude(md,3,1);
md=setflowequation(md,'macayeal','all');
md.initialization.waterfraction=zeros(md.mesh.numberofvertices,1);
md.cluster=none;
md=solve(md,EnthalpySolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Enthalpy1','Waterfraction1','Temperature1',...
	'Enthalpy2','Waterfraction2','Temperature2',...
	'Enthalpy3','Waterfraction3','Temperature3'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	(md.results.EnthalpySolution(1).Enthalpy),...
	(md.results.EnthalpySolution(1).Waterfraction),...
	(md.results.EnthalpySolution(1).Temperature),...
	(md.results.EnthalpySolution(2).Enthalpy),...
	(md.results.EnthalpySolution(2).Waterfraction),...
	(md.results.EnthalpySolution(2).Temperature),...
	(md.results.EnthalpySolution(3).Enthalpy),...
	(md.results.EnthalpySolution(3).Waterfraction),...
	(md.results.EnthalpySolution(3).Temperature),...
	};
