/*\file InputUpdateFromConstant.c
*\brief: update elements properties using a constant value
*/

#include "./InputUpdateFromConstant.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	double   constant;
	int      name;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputUpdateFromConstantUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&elements,ELEMENTSIN);
	FetchMatlabData((DataSet**)&nodes,NODESIN);
	FetchMatlabData((DataSet**)&vertices,VERTICESIN);
	FetchMatlabData((DataSet**)&loads,LOADSIN);
	FetchMatlabData((DataSet**)&materials,MATERIALSIN);
	FetchMatlabData(&parameters,PARAMETERSIN);
	FetchMatlabData(&constant,CONSTANT);
	FetchMatlabData(&name,NAME);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Generate internal degree of freedom numbers: */
	InputUpdateFromConstantx(elements,nodes,vertices,loads, materials,parameters,constant,name);

	/*write output datasets: */
	WriteMatlabData(ELEMENTS,elements);
	WriteMatlabData(LOADS,loads);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void InputUpdateFromConstantUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [elements loads] = %s(elements,nodes,vertices,loads,materials,parameters,constant,name);\n",__FUNCT__);
	_printf_(true,"\n");
}
